/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter;

import com.apple.transporter.CommandLineOptionProcessor;
import com.apple.transporter.ErrorMessageCollector;
import com.apple.transporter.WebService;
import com.apple.transporter.commlink.api.ConnectionServiceLauncher;
import com.apple.transporter.factory.OperationFactory;
import com.apple.transporter.factory.WebServiceFactory;
import com.apple.transporter.foundation.NotificationCenter;
import com.apple.transporter.log.Logger;
import com.apple.transporter.operation.Operation;
import com.apple.transporter.operation.option.AuthSessionIdOption;
import com.apple.transporter.operation.option.AuthSharedSecretOption;
import com.apple.transporter.stats.api.StatisticCollector;
import com.apple.transporter.toolregistry.api.ToolRegistry;
import com.apple.transporter.transport.TransportType;
import com.apple.transporter.util.ConfigurationUtil;
import com.apple.transporter.util.FileUtil;
import com.apple.transporter.util.SystemUtil;
import com.apple.transporter.util.XMLUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class Application {
    public static PrintStream XMLStream = System.out;
    public static final int sleepDuration = 30000;
    public static boolean hidePassword = true;
    private static String[] commandLineArgs;
    public static boolean shouldDisplayThroughput;
    public static boolean shouldDisplayProgress;
    public static boolean shouldDeleteSuccessfulPackages;
    private static boolean shouldPerformChecksum;
    private static boolean shouldValidateChaptersXML;
    private static boolean generateXML;
    private static boolean shouldDoAssetReplacementVerification;
    public static boolean disableTransportEncryption;
    private static boolean modeSupportsLogCompression;
    private static boolean shouldWriteSummaryToFile;
    private static String summaryFileWritePath;
    private static Writer summaryFileWriter;
    private static ConnectionServiceLauncher connectionServiceLauncher;
    private static StatisticCollector statisticCollector;
    private static ToolRegistry toolRegistry;
    private static List<String> WarningsForAllMethods;
    private static List<String> InfoMessagesForAllMethods;

    public static void main(String[] argv) {
        System.exit(Application.begin(argv));
    }

    private static int processCommandLineArgs(String[] argv) {
        Application.setCommandLineArgs(argv);
        Application.preprocessArgs(argv);
        CommandLineOptionProcessor options = new CommandLineOptionProcessor();
        int commandLineProcessingResult = options.parse(argv);
        if (commandLineProcessingResult != -1) {
            return commandLineProcessingResult;
        }
        if (!Logger.configureLogging()) {
            System.out.println("ERROR: Could NOT configure logging.");
            return 1;
        }
        Logger.info("Logging configured successfully.");
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int begin(String[] argv) {
        StringBuilder sb;
        statisticCollector.startOperationReturningPreviousStatistic("clientApplication.start");
        int result = 0;
        try {
            result = Application.reallyBegin(argv);
        }
        catch (Throwable throwable) {
            StringBuilder sb2;
            Application.stopConnectionService();
            statisticCollector.stop();
            if (Boolean.getBoolean("dumpStats")) {
                Logger.info("x-tx-correlation-key: " + WebService.TXCorrelationKeyHeaderValue);
                sb2 = new StringBuilder();
                sb2.append("Statistics:\n");
                statisticCollector.dumpStatistics(sb2);
                Logger.info(sb2.toString());
            }
            if (Boolean.getBoolean("dumpVersions")) {
                sb2 = new StringBuilder("Tool Versions:").append('\n');
                boolean toolsRegistered = false;
                if (null != toolRegistry) {
                    Map registeredTools = toolRegistry.getRegisteredTools();
                    toolsRegistered = registeredTools.size() > 0;
                    registeredTools.forEach((toolName, toolVersion) -> sb2.append('\t').append((String)toolName).append(" : ").append((String)toolVersion).append('\n'));
                }
                if (!toolsRegistered) {
                    sb2.append('\t').append("No tools are registered").append('\n');
                }
                Logger.info(sb2.toString());
            }
            FileUtil.cleanupFiles();
            throw throwable;
        }
        Application.stopConnectionService();
        statisticCollector.stop();
        if (Boolean.getBoolean("dumpStats")) {
            Logger.info("x-tx-correlation-key: " + WebService.TXCorrelationKeyHeaderValue);
            sb = new StringBuilder();
            sb.append("Statistics:\n");
            statisticCollector.dumpStatistics(sb);
            Logger.info(sb.toString());
        }
        if (Boolean.getBoolean("dumpVersions")) {
            sb = new StringBuilder("Tool Versions:").append('\n');
            boolean toolsRegistered = false;
            if (null != toolRegistry) {
                Map registeredTools = toolRegistry.getRegisteredTools();
                toolsRegistered = registeredTools.size() > 0;
                registeredTools.forEach((toolName, toolVersion) -> sb2.append('\t').append((String)toolName).append(" : ").append((String)toolVersion).append('\n'));
            }
            if (!toolsRegistered) {
                sb.append('\t').append("No tools are registered").append('\n');
            }
            Logger.info(sb.toString());
        }
        FileUtil.cleanupFiles();
        Logger.extreme("Returning " + String.valueOf(result));
        return result;
    }

    private static int reallyBegin(String[] argv) {
        boolean wasSuccessful;
        ConfigurationUtil.loadPropertyDefaults();
        int result = Application.processCommandLineArgs(argv);
        if (result != -1) {
            return result;
        }
        if (ConfigurationUtil.refreshDefaultsFromRemote()) {
            ConfigurationUtil.loadPropertyDefaults();
        }
        if (FileUtil.localConfigHome() == null) {
            File userHome = FileUtil.userHomeDirectory();
            Logger.info("Transporter is running as user: " + System.getProperty("user.name"));
            Logger.info("User home folder configured as: " + userHome != null ? userHome.getAbsolutePath() : null);
            Logger.error("Your home folder must be writable in order to save run-time configuration data.  Please ensure your home folder exists and is writable.");
            return 1;
        }
        if (generateXML) {
            Application.generateXMLHeader();
        }
        Logger.info("iTMSTransporter : iTunes Store Transporter [" + System.getProperty("versionNumber") + "]");
        Logger.info("OS identifier: " + WebService.getOSIdentifier());
        Logger.info(SystemUtil.memoryStatsString());
        Application.logClientIfNeeded();
        Application.launchConnectionService();
        OperationFactory factory = OperationFactory.defaultFactory();
        WebService service = WebServiceFactory.instance().createWebService();
        service.setSessionIdAndSharedSecret(AuthSessionIdOption.sessionId(), AuthSharedSecretOption.sharedSecret());
        Operation operation = factory.operation(service);
        if (operation == null) {
            Logger.error("Unknown operation requested.");
            wasSuccessful = false;
        } else {
            try {
                wasSuccessful = operation.execute();
            }
            catch (Exception e) {
                Logger.error("There was a general exception while executing", e);
                wasSuccessful = false;
            }
            Application.displayWarningMessages();
            Application.displayInfoMessages();
        }
        if (generateXML) {
            Application.generateXMLFooter();
        }
        if (Application.shouldWriteSummaryToFile() && Application.summaryFileWriter() != null) {
            try {
                Application.summaryFileWriter().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (System.getProperty("transporter.log.notificationcenter") != null) {
            System.gc();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Logger.extreme("Registered observers: " + NotificationCenter.defaultCenter().toString());
        }
        Logger.closeLogPrintStream();
        System.gc();
        if (wasSuccessful) {
            return 0;
        }
        return 1;
    }

    public static void generateXMLHeader() {
        Application.writeSummary("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        Application.writeSummary("<itunes_transporter>\n");
    }

    public static void generateXMLFooter() {
        Application.writeSummary("</itunes_transporter>\n");
    }

    public static int sleepDuration() {
        return 30000;
    }

    public static boolean shouldHidePassword() {
        return hidePassword;
    }

    public static boolean shouldDisplayThroughput() {
        return shouldDisplayThroughput;
    }

    public static void setShouldDisplayThroughput(boolean shouldDisplayThroughput) {
        Application.shouldDisplayThroughput = shouldDisplayThroughput;
    }

    public static boolean shouldDeleteSuccessfulPackages() {
        return shouldDeleteSuccessfulPackages;
    }

    public static boolean shouldGenerateXML() {
        return generateXML;
    }

    public static void setShouldDeleteSuccessfulPackages(boolean value) {
        shouldDeleteSuccessfulPackages = value;
    }

    public static void setGenerateXML(boolean value) {
        generateXML = value;
    }

    public static void setShouldPerformChecksum(boolean value) {
        shouldPerformChecksum = value;
    }

    public static void setModeSupportsLogCompression(boolean value) {
        modeSupportsLogCompression = value;
    }

    public static boolean modeSupportsLogCompression() {
        return modeSupportsLogCompression;
    }

    public static boolean shouldWriteSummaryToFile() {
        return shouldWriteSummaryToFile;
    }

    public static void setShouldWriteSummaryToFile(boolean shouldWriteSummaryToFile) {
        Application.shouldWriteSummaryToFile = shouldWriteSummaryToFile;
    }

    public static String summaryFileWritePath() {
        return summaryFileWritePath;
    }

    public static void setSummaryFileWritePath(String summaryFileWritePath) {
        Application.summaryFileWritePath = summaryFileWritePath;
    }

    public static Writer summaryFileWriter() {
        return summaryFileWriter;
    }

    public static void setSummaryFileWriter(Writer summaryFileWriter) {
        Application.summaryFileWriter = summaryFileWriter;
    }

    public static void setCommandLineArgs(String[] value) {
        commandLineArgs = new String[value.length];
        System.arraycopy(value, 0, commandLineArgs, 0, value.length);
    }

    public static String[] commandLineArgs() {
        return commandLineArgs;
    }

    public static String commandLineArgsAsString() {
        if (Application.commandLineArgs() == null) {
            return "";
        }
        String[] allArgsArray = Application.commandLineArgs();
        StringBuilder allArgsSansPassword = new StringBuilder();
        HashSet<String> strippedOptions = new HashSet<String>();
        strippedOptions.add("-CSAuthToken");
        strippedOptions.add("-CSPoolSize");
        strippedOptions.add("-CSPort");
        strippedOptions.add("-dumpStats");
        strippedOptions.add("-dumpVersions");
        HashSet<String> hiddenValueParameters = new HashSet<String>();
        hiddenValueParameters.add("-sessionid");
        hiddenValueParameters.add("-sharedsecret");
        hiddenValueParameters.add("-dsToken");
        hiddenValueParameters.add("-hsa2headers");
        hiddenValueParameters.add("-p");
        hiddenValueParameters.add("-P");
        int maxIndex = allArgsArray.length - 1;
        for (int i = 0; i < allArgsArray.length; ++i) {
            String previousValue;
            String argValue = allArgsArray[i];
            if (strippedOptions.contains(argValue)) continue;
            String string = previousValue = i > 0 ? allArgsArray[i - 1] : null;
            if (null != previousValue) {
                if (strippedOptions.contains(previousValue)) continue;
                if (hiddenValueParameters.contains(previousValue)) {
                    argValue = "**hidden value**";
                }
            }
            allArgsSansPassword.append(argValue);
            if (i >= maxIndex) continue;
            allArgsSansPassword.append(" ");
        }
        return allArgsSansPassword.toString();
    }

    public static boolean doesContainSOAPError(Map returnValue) {
        if (returnValue == null) {
            return false;
        }
        Boolean wasSuccess = (Boolean)returnValue.get(System.getProperty("successKey"));
        if (wasSuccess != null && !wasSuccess.booleanValue()) {
            Application.logUnnecessaryError("Apple's web service operation was not successful");
            return true;
        }
        return false;
    }

    public static void displaySOAPErrorMessages(Map returnValue) {
        Application.displaySOAPErrorMessages(returnValue, null, 1, true);
    }

    public static void displaySOAPErrorMessages(Map returnValue, XMLUtil.XMLTag parentTag, int xmlIndentLevel, boolean shouldWriteXml) {
        String exceptionMessage;
        if (returnValue == null) {
            return;
        }
        XMLUtil.XMLTag errorTag = null;
        if (generateXML) {
            errorTag = XMLUtil.generateLogTag(xmlIndentLevel, Logger.Level.Error, null);
            if (parentTag != null) {
                parentTag.addChildTag(errorTag);
            }
        }
        Object[] errors = (Object[])returnValue.get(System.getProperty("errorsKey"));
        List<Object> errorsArray = null;
        if (errors != null && errors.length > 0) {
            errorsArray = Arrays.asList(errors);
        }
        if (errorsArray != null && errorsArray.size() > 0) {
            for (Object o : errorsArray) {
                String aMsg = (String)o;
                Logger.error(aMsg);
                if (errorTag == null) continue;
                errorTag.addChildTag("message").setText(aMsg);
            }
        }
        Object errorCode = returnValue.get(System.getProperty("errorCodeKey"));
        Logger.extreme("The error code is: " + errorCode);
        if (errorTag != null) {
            errorTag.addChildTag("error_code").setText(errorCode.toString());
        }
        if ((exceptionMessage = (String)returnValue.get(System.getProperty("exceptionKey"))) != null && exceptionMessage.length() > 0) {
            Logger.extreme(exceptionMessage);
            if (errorTag != null) {
                errorTag.addChildTag("exception").setText(exceptionMessage);
            }
        }
        if (errorTag != null && shouldWriteXml) {
            Application.writeXML(errorTag.marshall());
        }
    }

    public static void collectWarningMessages(Map<String, Object> returnValue) {
        if (returnValue == null) {
            return;
        }
        Object[] warnings = (Object[])returnValue.get(System.getProperty("warningsKey"));
        if (warnings != null && warnings.length > 0) {
            for (Object warning : warnings) {
                if (WarningsForAllMethods.contains(warning)) continue;
                WarningsForAllMethods.add((String)warning);
            }
        }
    }

    public static void displayWarningMessages() {
        if (WarningsForAllMethods.isEmpty()) {
            return;
        }
        Logger.info("The following warnings were received from Apple's web service ...");
        for (String msg : WarningsForAllMethods) {
            Logger.warn(msg);
        }
        WarningsForAllMethods.clear();
    }

    public static void collectInfoMessages(Map<String, Object> returnValue) {
        if (returnValue == null) {
            return;
        }
        Object[] warnings = (Object[])returnValue.get(System.getProperty("infoMessagesKey"));
        if (warnings != null && warnings.length > 0) {
            for (Object warning : warnings) {
                if (InfoMessagesForAllMethods.contains(warning)) continue;
                InfoMessagesForAllMethods.add((String)warning);
            }
        }
    }

    public static void displayInfoMessages() {
        if (InfoMessagesForAllMethods.isEmpty()) {
            return;
        }
        Logger.info("The following info messages were received from Apple's web service ...");
        for (String msg : InfoMessagesForAllMethods) {
            Logger.infoMessage(msg);
        }
        InfoMessagesForAllMethods.clear();
    }

    public static void displaySOAPWarningMessagesIfNeededInXML(Map returnValue, XMLUtil.XMLTag parentTag, int xmlIndentLevel) {
        if (returnValue == null) {
            return;
        }
        Object[] warnings = (Object[])returnValue.get(System.getProperty("warningsKey"));
        List<Object> warningsArray = null;
        if (warnings != null && warnings.length > 0) {
            warningsArray = Arrays.asList(warnings);
        }
        if (warningsArray != null && !warningsArray.isEmpty()) {
            for (Object o : warningsArray) {
                String aMsg = (String)o;
                XMLUtil.XMLTag warnTag = XMLUtil.generateLogTag(xmlIndentLevel, Logger.Level.Warn, aMsg);
                if (parentTag == null) continue;
                parentTag.addChildTag(warnTag);
            }
        }
    }

    public static void displaySOAPInfoMessagesIfNeededInXML(Map returnValue, XMLUtil.XMLTag parentTag, int xmlIndentLevel) {
        if (returnValue == null) {
            return;
        }
        Object[] infoMessages = (Object[])returnValue.get(System.getProperty("infoMessagesKey"));
        List<Object> infoMessagesArray = null;
        if (infoMessages != null && infoMessages.length > 0) {
            infoMessagesArray = Arrays.asList(infoMessages);
        }
        if (infoMessagesArray != null && !infoMessagesArray.isEmpty()) {
            for (Object o : infoMessagesArray) {
                String aMsg = (String)o;
                XMLUtil.XMLTag infoTag = XMLUtil.generateLogTag(xmlIndentLevel, Logger.Level.Info, aMsg);
                if (parentTag == null) continue;
                parentTag.addChildTag(infoTag);
            }
        }
    }

    public static void writeXML(String s) {
        Logger.essential(s);
    }

    public static void writeSummary(String s) {
        if (s != null) {
            if (Application.shouldGenerateXML()) {
                Application.writeXML(s);
            } else {
                String s2 = s;
                if (s2.endsWith("\n")) {
                    s2 = s2.substring(0, s2.length() - 1);
                }
                Logger.essential(s2);
            }
            if (shouldWriteSummaryToFile && summaryFileWriter != null) {
                try {
                    summaryFileWriter.write(s);
                }
                catch (IOException e) {
                    Logger.error("Error writing to summary file", e);
                }
            }
        }
    }

    public static void logClientIfNeeded() {
        String client = System.getProperty("transporter.client");
        String clientVersion = System.getProperty("transporter.client.version");
        String logValue = null;
        if (client != null) {
            logValue = client;
            if (clientVersion != null) {
                logValue = logValue + " " + clientVersion;
            }
            Logger.info("Client: " + logValue);
        }
    }

    public static boolean isTestTransferMode() {
        String mode = System.getProperty("m");
        return "transferTest".equalsIgnoreCase(mode);
    }

    private static void preprocessArgs(String[] argv) {
        if (argv == null) {
            return;
        }
        for (int i = 0; i < argv.length; ++i) {
            String anArg = argv[i];
            if (anArg == null || !anArg.equals("-t")) continue;
            int transportIndex = ++i;
            try {
                while (i < argv.length - 1 && TransportType.valueOf(argv[i + 1]).isChainable()) {
                    argv[transportIndex] = argv[transportIndex] + "," + argv[++i];
                    argv[i] = "";
                }
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public static boolean shouldPerformChecksum() {
        return shouldPerformChecksum;
    }

    public static boolean shouldValidateChaptersXML() {
        return shouldValidateChaptersXML;
    }

    public static boolean shouldDoAssetReplacementVerification() {
        return shouldDoAssetReplacementVerification;
    }

    public static void setShouldValidateChaptersXML(boolean value) {
        shouldValidateChaptersXML = value;
    }

    public static void setShouldDoAssetReplacementVerification(boolean value) {
        shouldDoAssetReplacementVerification = value;
    }

    public static void showNonPackageBasedErrorSummary() {
        Logger.essential(" ");
        Logger.essential(" ");
        Logger.essential(" ");
        Logger.essential("Error Summary");
        Logger.essential(" ");
        List<String> errorArray = ErrorMessageCollector.sharedInstance().nonPackageErrorInfo();
        if (errorArray != null) {
            for (String error : errorArray) {
                Logger.essential("    " + error);
            }
        }
    }

    public static void checkUpdateOverride(Map<String, Object> returnValue) {
        if (returnValue == null) {
            return;
        }
        Boolean overrideUpdateCheck = (Boolean)returnValue.get(System.getProperty("overrideUpdateCheckKey"));
        if (overrideUpdateCheck == null || !overrideUpdateCheck.booleanValue()) {
            return;
        }
        FileUtil.deleteLocalConfigHomeOnExit();
    }

    public static void logUnnecessaryError(String message) {
        Boolean shouldLogUnnecessaryErrors = Application.shouldLogUnnecessaryErrors();
        if (shouldLogUnnecessaryErrors.booleanValue()) {
            Logger.error(message);
        }
    }

    public static void logUnnecessaryError(String message, Throwable t) {
        Boolean shouldLogUnnecessaryErrors = Application.shouldLogUnnecessaryErrors();
        if (shouldLogUnnecessaryErrors.booleanValue()) {
            Logger.error(message, t);
        }
    }

    public static void logExceptionWithUnnecessaryError(String message, Throwable t) {
        Boolean shouldLogUnnecessaryErrors = Application.shouldLogUnnecessaryErrors();
        if (shouldLogUnnecessaryErrors.booleanValue()) {
            Logger.error(message, t);
        } else {
            Logger.error(null, t);
        }
    }

    private static Boolean shouldLogUnnecessaryErrors() {
        return Boolean.getBoolean("logUnnecessaryErrors");
    }

    public static void setConnectionServiceLauncher(ConnectionServiceLauncher connectionServiceLauncher) {
        Application.connectionServiceLauncher = connectionServiceLauncher;
    }

    private static void launchConnectionService() {
        if (null != connectionServiceLauncher) {
            connectionServiceLauncher.launch();
        }
    }

    private static void stopConnectionService() {
        if (null != connectionServiceLauncher) {
            connectionServiceLauncher.halt();
        }
    }

    public static StatisticCollector getStatisticCollector() {
        return statisticCollector;
    }

    public static void setStatisticCollector(StatisticCollector statisticCollector) {
        Application.statisticCollector = statisticCollector;
    }

    public static void setToolRegistry(ToolRegistry toolRegistry) {
        Application.toolRegistry = toolRegistry;
    }

    static {
        shouldDisplayThroughput = false;
        shouldDisplayProgress = true;
        shouldDeleteSuccessfulPackages = false;
        generateXML = false;
        disableTransportEncryption = false;
        modeSupportsLogCompression = false;
        shouldWriteSummaryToFile = false;
        summaryFileWriter = null;
        WarningsForAllMethods = new ArrayList<String>();
        InfoMessagesForAllMethods = new ArrayList<String>();
    }
}

