/*
 * Decompiled with CFR 0.152.
 */
package org.jabsorb.serializer.impl;

import org.jabsorb.serializer.AbstractSerializer;
import org.jabsorb.serializer.MarshallException;
import org.jabsorb.serializer.ObjectMatch;
import org.jabsorb.serializer.SerializerState;
import org.jabsorb.serializer.UnmarshallException;

public class StringSerializer
extends AbstractSerializer {
    private static final long serialVersionUID = 2L;
    private static Class[] _serializableClasses = new Class[]{String.class, Character.TYPE, Character.class, [B.class, [C.class};
    private static Class[] _JSONClasses = new Class[]{String.class, Integer.class};

    public Class[] getJSONClasses() {
        return _JSONClasses;
    }

    public Class[] getSerializableClasses() {
        return _serializableClasses;
    }

    public Object marshall(SerializerState state, Object p, Object o) throws MarshallException {
        if (o instanceof Character) {
            return o.toString();
        }
        if (o instanceof byte[]) {
            return new String((byte[])o);
        }
        if (o instanceof char[]) {
            return new String((char[])o);
        }
        return o;
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object jso) throws UnmarshallException {
        state.setSerialized(jso, ObjectMatch.OKAY);
        return ObjectMatch.OKAY;
    }

    public Object unmarshall(SerializerState state, Class clazz, Object jso) throws UnmarshallException {
        String val;
        String string = val = jso instanceof String ? (String)jso : jso.toString();
        Object returnValue = clazz == Character.TYPE ? new Character(val.charAt(0)) : (clazz == [B.class ? (Object)val.getBytes() : (clazz == [C.class ? (Object)val.toCharArray() : val));
        state.setSerialized(jso, returnValue);
        return returnValue;
    }
}

