/*
 * Decompiled with CFR 0.152.
 */
package org.jabsorb.serializer.impl;

import org.jabsorb.serializer.AbstractSerializer;
import org.jabsorb.serializer.MarshallException;
import org.jabsorb.serializer.ObjectMatch;
import org.jabsorb.serializer.SerializerState;
import org.jabsorb.serializer.UnmarshallException;

public class PrimitiveSerializer
extends AbstractSerializer {
    private static final long serialVersionUID = 2L;
    private static Class[] _serializableClasses = new Class[]{Integer.TYPE, Byte.TYPE, Short.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
    private static Class[] _JSONClasses = new Class[]{Integer.class, Byte.class, Short.class, Long.class, Float.class, Double.class, String.class};

    public Class[] getSerializableClasses() {
        return _serializableClasses;
    }

    public Class[] getJSONClasses() {
        return _JSONClasses;
    }

    public Object toPrimitive(Class clazz, Object jso) throws NumberFormatException {
        if (Integer.TYPE.equals(clazz)) {
            if (jso instanceof String) {
                return new Integer((String)jso);
            }
            return new Integer(((Number)jso).intValue());
        }
        if (Long.TYPE.equals(clazz)) {
            if (jso instanceof String) {
                return new Long((String)jso);
            }
            return new Long(((Number)jso).longValue());
        }
        if (Short.TYPE.equals(clazz)) {
            if (jso instanceof String) {
                return new Short((String)jso);
            }
            return new Short(((Number)jso).shortValue());
        }
        if (Byte.TYPE.equals(clazz)) {
            if (jso instanceof String) {
                return new Byte((String)jso);
            }
            return new Byte(((Number)jso).byteValue());
        }
        if (Float.TYPE.equals(clazz)) {
            if (jso instanceof String) {
                return new Float((String)jso);
            }
            return new Float(((Number)jso).floatValue());
        }
        if (Double.TYPE.equals(clazz)) {
            if (jso instanceof String) {
                return new Double((String)jso);
            }
            return new Double(((Number)jso).doubleValue());
        }
        return null;
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object jso) throws UnmarshallException {
        try {
            this.toPrimitive(clazz, jso);
        }
        catch (NumberFormatException e) {
            throw new UnmarshallException("not a primitive", e);
        }
        state.setSerialized(jso, ObjectMatch.OKAY);
        return ObjectMatch.OKAY;
    }

    public Object unmarshall(SerializerState state, Class clazz, Object jso) throws UnmarshallException {
        try {
            Object primitive = this.toPrimitive(clazz, jso);
            state.setSerialized(jso, primitive);
            return primitive;
        }
        catch (NumberFormatException e) {
            throw new UnmarshallException("cannot convert object " + jso + " to type " + clazz.getName(), e);
        }
    }

    public Object marshall(SerializerState state, Object p, Object o) throws MarshallException {
        return o;
    }
}

