/*
 * Decompiled with CFR 0.152.
 */
package org.jabsorb.serializer.impl;

import org.jabsorb.serializer.AbstractSerializer;
import org.jabsorb.serializer.MarshallException;
import org.jabsorb.serializer.ObjectMatch;
import org.jabsorb.serializer.SerializerState;
import org.jabsorb.serializer.UnmarshallException;

public class BooleanSerializer
extends AbstractSerializer {
    private static final long serialVersionUID = 2L;
    private static Class[] _serializableClasses = new Class[]{Boolean.TYPE, Boolean.class};
    private static Class[] _JSONClasses = new Class[]{Boolean.class, String.class};

    public Class[] getJSONClasses() {
        return _JSONClasses;
    }

    public Class[] getSerializableClasses() {
        return _serializableClasses;
    }

    public Object marshall(SerializerState state, Object p, Object o) throws MarshallException {
        return o;
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object jso) throws UnmarshallException {
        ObjectMatch returnValue = ObjectMatch.OKAY;
        state.setSerialized(jso, returnValue);
        return ObjectMatch.OKAY;
    }

    public Object unmarshall(SerializerState state, Class clazz, Object jso) throws UnmarshallException {
        Boolean returnValue = Boolean.FALSE;
        if (jso instanceof String) {
            try {
                returnValue = new Boolean((String)jso);
            }
            catch (Exception e) {
                throw new UnmarshallException("Cannot convert " + jso + " to Boolean", e);
            }
        } else if (clazz == Boolean.TYPE) {
            returnValue = (Boolean)jso;
        }
        state.setSerialized(jso, returnValue);
        return returnValue;
    }
}

