/*
 * Decompiled with CFR 0.152.
 */
package org.jabsorb;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import org.jabsorb.JSONRPCBridge;
import org.jabsorb.serializer.Serializer;
import org.jabsorb.serializer.impl.ReferenceSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONRPCBridgeState
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final Logger log = LoggerFactory.getLogger((Class)JSONRPCBridgeState.class);
    private JSONRPCBridge bridge;
    private HashMap classMap = new HashMap();
    private HashMap objectMap = new HashMap();
    private HashMap referenceMap = null;
    private Serializer referenceSerializer = null;
    private HashSet referenceSet = null;
    private HashSet callableReferenceSet = null;

    public JSONRPCBridgeState(JSONRPCBridge bridge) {
        this.bridge = bridge;
    }

    public HashSet getCallableReferenceSet() {
        return this.callableReferenceSet;
    }

    public void setCallableReferenceSet(HashSet callableReferenceSet) {
        this.callableReferenceSet = callableReferenceSet;
    }

    public HashMap getClassMap() {
        return this.classMap;
    }

    public void setClassMap(HashMap classMap) {
        this.classMap = classMap;
    }

    public HashMap getObjectMap() {
        return this.objectMap;
    }

    public void setObjectMap(HashMap objectMap) {
        this.objectMap = objectMap;
    }

    public HashMap getReferenceMap() {
        return this.referenceMap;
    }

    public void setReferenceMap(HashMap referenceMap) {
        this.referenceMap = referenceMap;
    }

    public Serializer getReferenceSerializer() {
        return this.referenceSerializer;
    }

    public void setReferenceSerializer(Serializer referenceSerializer) {
        this.referenceSerializer = referenceSerializer;
    }

    public HashSet getReferenceSet() {
        return this.referenceSet;
    }

    public void setReferenceSet(HashSet referenceSet) {
        this.referenceSet = referenceSet;
    }

    public synchronized void enableReferences() throws Exception {
        if (this.referenceSerializer == null) {
            this.referenceSerializer = new ReferenceSerializer(this.bridge);
            this.bridge.registerSerializer(this.referenceSerializer);
            log.info("enabled references on this bridge");
        }
        if (this.referenceMap == null) {
            this.referenceMap = new HashMap();
        }
        if (this.referenceSet == null) {
            this.referenceSet = new HashSet();
        }
        if (this.callableReferenceSet == null) {
            this.callableReferenceSet = new HashSet();
        }
    }
}

