local dungeonIndex = 9
local pi = math.pi
local nerfMultiplier = 0.74 --npcs got nerfed by 26% compared against m0 values, bosses unchanged
MethodDungeonTools.dungeonTotalCount[dungeonIndex] = {normal=420,teeming=504,teemingEnabled=true}
MethodDungeonTools.dungeonBosses[dungeonIndex] = {--Lower Karazhan
	[3] = {
		[1] = {
            ["name"] = "Opera Hall: Wikket",
            ["health"] = 132731495, --but there is 2 of them :thinking:
            ["encounterID"] = 1820,
            ["level"] = 112,
            ["creatureType"] = "Humanoid",
            ["id"] = 114284,
            ["displayId"] = 17550,
            ["x"] = 150.99915154278,
            ["y"] = -167.49961474724,
        },		
		[2] = {
            ["name"] = "Maiden of Virtue",
            ["health"] = 93092225,
            ["encounterID"] = 1555,
            ["level"] = 112,
            ["creatureType"] = "Giant",
            ["id"] = 113971,
            ["displayId"] = 16198,
            ["x"] = 698.1226427608,
            ["y"] = -278.28112020695,
        },
	},
	[4] = {
		[1] = {
            ["name"] = "Moroes",
            ["health"] = 75937736,
            ["encounterID"] = 1837,
            ["level"] = 112,
            ["creatureType"] = "Undead",
            ["id"] = 114312,
            ["displayId"] = 16540,
            ["x"] = 224.28443185713,
            ["y"] = -353.1564480984,
        },
	},
	[6] = {
		[1] = {
            ["name"] = "Attumen the Huntsman", --health of horse right now  
            ["health"] = 36786446,
            ["encounterID"] = 1835,
            ["level"] = 112,
            ["creatureType"] = "Undead",
            ["id"] = 114264,
            ["displayId"] = 73811,
            ["x"] = 378.99656015448,
            ["y"] = -460.49874357507,
        },
		
	},
}
MethodDungeonTools.dungeonEnemies[dungeonIndex] = {
	[1] = {
        ["name"] = "Forlorn Spirit",
        ["health"] = 21771241*nerfMultiplier,
        ["level"] = 111,
        ["creatureType"] = "Undead",
        ["id"] = 114626,
        ["displayId"] = 26404,
        ["count"] = 4,
        ["scale"] = 1,
        ["color"] = {r=1,g=1,b=1,a=0.8},
        ["clones"] = {
            [1] = {x = 466.15596558832,y = -324.23342732763,sublevel=1,g=94},
			[2] = {x = 503.88323720501,y = -300.59703923951,sublevel=1,g=95},
        },
    },
	[2] = {
        ["name"] = "Spectral Patron",
        ["health"] = 8418063,
        ["level"] = 110,
        ["creatureType"] = "Undead",
        ["id"] = 114541,
        ["displayId"] = 16555,
        ["count"] = 1,
        ["scale"] = 1,
        ["color"] = {r=1,g=1,b=1,a=0.8},
        ["clones"] = {
            [1] = {x = 263.29146003598,y = -213.07387390799,sublevel=1,g=1},
			[2] = {x = 271.18082631627,y = -215.74394520525,sublevel=1,g=1},
			[3] = {x = 307.81750311738,y = -191.52853489189,sublevel=1,g=2},
			[4] = {x = 315.09021011591,y = -190.16488038432,sublevel=1,g=2},
			[5] = {x = 344.01301857732,y = -178.85013053493,sublevel=1,g=3},
			[6] = {x = 349.01300707718,y = -185.21377354235,sublevel=1,g=3,patrolFacing=(20/32)*pi,patrolFacing2=(57/32)*pi,patrol={
				[1] = {x = 349.01300707718,y = -185.21377354235},
				[2] = {x = 367.83290015132,y = -160.48390627053},
				[3] = {x = 367.20485826385,y = -119.31822251313},
				[4] = {x = 354.28784279582,y = -99.318170978819},
				[5] = {x = 312.70469236654,y = -77.954590426884},
				[6] = {x = 286.98795027105,y = -74.772729564397},
				[7] = {x = 312.70469236654,y = -77.954590426884},
				[8] = {x = 354.28784279582,y = -99.318170978819},
				[9] = {x = 367.20485826385,y = -119.31822251313},
				[10] = {x = 367.83290015132,y = -160.48390627053},
				[11] = {x = 349.01300707718,y = -185.21377354235},
				[12] = {x = 305.17971330135,y = -207.60019864878},
				[13] = {x = 268.36150577428,y = -204.41839630722},
				[14] = {x = 305.17971330135,y = -207.60019864878},
			}},
			[7] = {x = 345.47241609982,y = -120.54337543469,sublevel=1,g=4},
			[8] = {x = 347.64397650053,y = -113.02316787848,sublevel=1,g=4},
			[9] = {x = 439.48119422002,y = -115.99208155251,sublevel=2,g=5},
			[10] = {x = 428.23115090654,y = -132.24205768969,sublevel=2,g=5},
			[11] = {x = 601.99993068955,y = -216.49449563393,sublevel=2,g=6},
			[12] = {x = 601.23068978147,y = -231.87908271295,sublevel=2,g=6},
			[13] = {x = 614.30758714805,y = -251.10987433238,sublevel=2,g=6},
			[14] = {x = 606.51612025453,y = -402.92274920085,sublevel=2,g=7},
			[15] = {x = 591.1315661873,y = -407.53816163754,sublevel=2,g=7},
			[16] = {x = 583.43928915368,y = -422.15347479669,sublevel=2,g=7},
			[17] = {x = 493.99998655915,y = -497.49966439791,sublevel=2,g=8},
			[18] = {x = 513.99982395023,y = -501.49967479147,sublevel=2,g=8},


			[19] = {x = 353.03761765242,y = -155.22728655249,sublevel=1,g=96,teeming=true},
			[20] = {x = 344.8557686349,y = -145.22729004579,sublevel=1,g=96,teeming=true},
			[21] = {x = 353.94668164352,y = -135.68182553465,sublevel=1,g=96,teeming=true},

			
			[27] = {x = 231.02156954711,y = -215.8496654847,sublevel=3,g=22},
			[28] = {x = 227.38519654087,y = -222.21328898516,sublevel=3,g=22},
			[29] = {x = 220.56702153789,y = -231.30420199378,sublevel=3,g=22},
			[30] = {x = 223.10756707888,y = -226.17457631489,sublevel=3,g=22},
			[31] = {x = 227.19841400308,y = -234.35638720515,sublevel=3,g=22},
			[32] = {x = 229.01665922417,y = -230.26546225304,sublevel=3,g=22},
			[33] = {x = 234.01660925193,y = -224.35635060078,sublevel=3,g=22},
			[34] = {x = 239.0166373076,y = -219.35636155906,sublevel=3,g=22},
			[35] = {x = 243.10752324576,y = -222.9927154524,sublevel=3,g=22},
			
			[36] = {x = 246.72516284084,y = -241.24821757961,sublevel=3,g=23},
			[37] = {x = 249.90698434455,y = -237.15733208479,sublevel=3,g=23},
			[38] = {x = 255.73096091339,y = -240.70536580617,sublevel=3,g=23},
			[39] = {x = 261.18550150689,y = -234.3417221091,sublevel=3,g=23},
			[40] = {x = 265.276426459,y = -227.97811742598,sublevel=3,g=23},
			[41] = {x = 262.99963555082,y = -244.72259741972,sublevel=3,g=23},
			[42] = {x = 270.72685503793,y = -231.54079891629,sublevel=3,g=23},
			
			[43] = {x = 271.2063107684,y = -192.16041664265,sublevel=3,g=24},
			[44] = {x = 269.10106456873,y = -184.79198718273,sublevel=3,g=24},
			[45] = {x = 266.24395527518,y = -177.60046129589,sublevel=3,g=24},
			[46] = {x = 265.33489118556,y = -171.69134964363,sublevel=3,g=24},
			[47] = {x = 277.34921216499,y = -187.06528068814,sublevel=3,g=24},
			[48] = {x = 280.53102391522,y = -174.33799467328,sublevel=3,g=24},
			[49] = {x = 282.34921041834,y = -177.97440669346,sublevel=3,g=24},
			[50] = {x = 286.89467667614,y = -192.97437219304,sublevel=3,g=24},
			
			[51] = {x = 230.00314802624,y = -187.43687147896,sublevel=3,g=25},
			[52] = {x = 229.54859652371,y = -180.16414497346,sublevel=3,g=25},
			[53] = {x = 237.9281302736,y = -186.15684047056,sublevel=3,g=25},
			[54] = {x = 237.40180743017,y = -182.4726257406,sublevel=3,g=25},
			[55] = {x = 223.19131652781,y = -171.94632698117,sublevel=3,g=25},
			[56] = {x = 222.1386256669,y = -166.68314372092,sublevel=3,g=25},
			[57] = {x = 230.55974598773,y = -164.05157467782,sublevel=3,g=25},
			[58] = {x = 238.01573314402,y = -168.39381873453,sublevel=3,g=25},

			[59] = {x = 345.35966099311,y = -189.23519055961,sublevel=1,g=3,teeming=true},

        },
    },
	[3] = {
        ["name"] = "Ghostly Philanthropist",
        ["health"] = 14514161,
        ["level"] = 111,
        ["creatureType"] = "Undead",
        ["id"] = 114542,
        ["displayId"] = 73336,
        ["count"] = 4,
        ["scale"] = 1,
        ["color"] = {r=1,g=1,b=1,a=0.8},
        ["clones"] = {
            [1] = {x = 276.90807733297,y = -213.17477927558,sublevel=1,g=1},
			[2] = {x = 302.99891122988,y = -192.56215244977,sublevel=1,g=2},
			[3] = {x = 314.8170162118,y = -184.83485493477,sublevel=1,g=2},			
			[4] = {x = 354.46754707957,y = -191.57739704281,sublevel=1,g=3},			
			[5] = {x = 339.46216649696,y = -109.84138538871,sublevel=1,g=4},
			[6] = {x = 433.23111055233,y = -147.24204391543,sublevel=2,g=5},
			[7] = {x = 625.07682781399,y = -257.26370256163,sublevel=2,g=6},
			[8] = {x = 572.67004848775,y = -427.53816115325,sublevel=2,g=7},
			[9] = {x = 538.99989963882,y = -491.49975609593,sublevel=2,g=8},
			[10] = {x = 340.03859105147,y = -182.60577464681,sublevel=1,g=3,teeming=true},
			[11] = {x = 353.33339320471,y = -147.80470225207,sublevel=1,g=96,teeming=true},
			[12] = {x = 353.33339320471,y = -141.44107875162,sublevel=1,g=96,teeming=true},
			[13] = {x = 361.06069071971,y = -134.16835224611,sublevel=1,g=96,teeming=true},
			[14] = {x = 204.10709655195,y = -206.92441823884,sublevel=3,g=15,teeming=true},
			[15] = {x = 208.19802150405,y = -176.46991292977,sublevel=3,g=15,teeming=true},

        },
    },
	[4] = {
        ["name"] = "Phantom Crew",
        ["health"] = 11224084,
        ["level"] = 110,
        ["creatureType"] = "Undead",
        ["id"] = 114584,
        ["displayId"] = 73338,
        ["count"] = 1,
        ["scale"] = 1,
        ["color"] = {r=1,g=1,b=1,a=0.8},
        ["clones"] = {
            [1] = {x = 101.36353088974,y = -138.53512683505,sublevel=3,patrolFacing=(30/32)*pi,patrolFacing2=(48/32)*pi,patrol={
				[1] = {x = 101.36353088974,y = -138.53512683505}, --blue
				[2] = {x = 127.72721976657,y = -140.22730926837},
				[3] = {x = 149.09081443152,y = -146.1363465626},
				[4] = {x = 127.72721976657,y = -140.22730926837},
				[5] = {x = 101.36353088974,y = -138.53512683505}, --blue
				[6] = {x = 94.736744256378,y = -181.61077916867},
				[7] = {x = 86.315669109597,y = -207.40025969137},
				[8] = {x = 94.736744256378,y = -181.61077916867},
			}},


			[2] = {x = 131.81820015123,y = -116.89797485326,sublevel=3,patrolFacing=(34/32)*pi,patrolFacing2=(48/32)*pi,patrol={
				[1] = {x =131.81820015123,y = -116.89797485326}, --green
				[2] = {x = 173.6363921881,y = -124.77271927251},
				[3] = {x =131.81820015123,y = -116.89797485326}, --green
				[4] = {x = 120.90912014646,y = -116.59090926894},
				[5] = {x = 81.818134027936,y = -117.72712823921},
				[6] = {x = 120.90912014646,y = -116.59090926894},
				[7] = {x =131.81820015123,y = -116.89797485326}, --green
				[8] = {x = 134.54537276978,y = -141.10905703147},
				[9] = {x = 94.545352852345,y = -129.86452465004},
				[10] = {x = 134.54537276978,y = -141.10905703147},
			}},
        },
    },
	[5] = {
        ["name"] = "Ghostly Understudy",
        ["health"] = 11224084,
        ["level"] = 110,
        ["creatureType"] = "Undead",
        ["id"] = 114526,
        ["displayId"] = 73302,
        ["count"] = 1,
        ["scale"] = 1,
        ["color"] = {r=1,g=1,b=1,a=0.8},
        ["clones"] = {
            [1] = {x = 165.90876695027,y = -122.04530088353,sublevel=3,g=9},
			[2] = {x = 157.36793905287,y = -124.9998519246,sublevel=3,g=9},
			[3] = {x = 153.15744665353,y = -119.21036840795,sublevel=3,g=9},
			[4] = {x = 149.47323192357,y = -123.42090598134,sublevel=3,g=9},
			[5] = {x = 137.27235497977,y = -134.77255864731,sublevel=3,g=10},
			[6] = {x = 132.27232746596,y = -133.86345564226,sublevel=3,g=10},
			[7] = {x = 110.45419250139,y = -122.95436874148,sublevel=3,g=11},
			[8] = {x = 107.27237099767,y = -115.68160322203,sublevel=3,g=11},
			[9] = {x = 100.45421550167,y = -122.04524622946,sublevel=3,g=11},
			[10] = {x = 82.104572955355,y = -132.89454068626,sublevel=3,g=12},
			[11] = {x = 74.209911000102,y = -131.31557215597,sublevel=3,g=12},
			[12] = {x = 75.262511512913,y = -116.05241297972,sublevel=3,g=12},
			[13] = {x = 83.683541485645,y = -111.84192058038,sublevel=3,g=12},
			[14] = {x = 85.788879946057,y = -162.84745087797,sublevel=3,g=13},
			[15] = {x = 95.788923623127,y = -157.58426761772,sublevel=3,g=13},
			[16] = {x = 86.315157615438,y = -156.00532167446,sublevel=3,g=13},
			[17] = {x = 109.09044138229,y = -183.35335266627,sublevel=3,g=14},
			[18] = {x = 108.18133827872,y = -192.44426666009,sublevel=3,g=14},
        },
    },
	[6] = {
        ["name"] = "Backup Singer",
        ["health"] = 12627094,
        ["level"] = 110,
        ["creatureType"] = "Undead",
        ["id"] = 116549,
        ["displayId"] = 74235,
        ["count"] = 4,
        ["scale"] = 1,
        ["color"] = {r=1,g=1,b=1,a=0.8},
        ["clones"] = {
            [1] = {x = 186.65361438144,y = -222.48727377396,sublevel=3,g=17},
			[2] = {x = 177.27212040318,y = -210.62106166721,sublevel=3,g=17},
			[3] = {x = 184.99937974165,y = -212.89379991915,sublevel=3,g=17},
			[4] = {x = 177.27212040318,y = -219.25742410925,sublevel=3,g=17},
			[5] = {x = 195.90846092866,y = -168.79614757645,sublevel=3,g=18},
			[6] = {x = 201.81749773306,y = -161.5904234484,sublevel=3,g=18},
			[7] = {x = 195.90846092866,y = -160.15978513442,sublevel=3,g=18},
			[8] = {x = 198.63577023936,y = -154.25069298913,sublevel=3,g=18},
			[9] = {x = 203.63583730898,y = -156.06886018231,sublevel=3,g=18},
			[10] = {x = 190.81559593757,y = -216.80882330638,sublevel=3,g=17,teeming=true},
			[11] = {x = 182.633785934,y = -205.89976280858,sublevel=3,g=17,teeming=true},
        },
    },
	[7] = {
        ["name"] = "Skeletal Usher",
        ["health"] = 11224084,
        ["level"] = 110,
        ["creatureType"] = "Undead",
        ["id"] = 114544,
        ["displayId"] = 73313,
        ["count"] = 4,
        ["scale"] = 1,
        ["color"] = {r=1,g=1,b=1,a=0.8},
        ["clones"] = {
            [1] = {x = 337.22543396168,y = -215.68015231816,sublevel=3,g=97,patrolFacing=(32/32)*pi,patrolFacing2=(0/32)*pi,patrol={
				[1] = {x = 337.22543396168,y = -215.68015231816},--mid
				[2] = {x = 336.86315493583,y = -234.74885959301},
				[3] = {x = 314.06066972964,y = -260.26339253943},
				[4] = {x = 285.38566516187,y = -275.78763848991},
				[5] = {x = 223.63634997925,y = -277.84490819188},
				[6] = {x = 285.38566516187,y = -275.78763848991},
				[7] = {x = 314.06066972964,y = -260.26339253943},
				[8] = {x = 336.86315493583,y = -234.74885959301},
				[9] = {x = 337.22543396168,y = -215.68015231816},--mid
				[10] = {x = 337.9587465102,y = -180.8518785913},
				[11] = {x = 314.61361945472,y = -154.88580290874},
				[12] = {x = 272.33720943553,y = -134.55639158295},
				[13] = {x = 232.72636400037,y = -128.90598811516},
				[14] = {x = 272.33720943553,y = -134.55639158295},
				[15] = {x = 314.61361945472,y = -154.88580290874},
				[16] = {x = 337.9587465102,y = -180.8518785913},
			}},
			[2] = {x = 323.99874029122,y = -222.49864557572,sublevel=3},
			[3] = {x = 325.99868111499,y = -207.49866024405,sublevel=3},
			[4] = {x = 360.72628908001,y = -223.30035849694,sublevel=3,g=20},
			[5] = {x = 362.83158045373,y = -211.19511379424,sublevel=3,g=20},
			[6] = {x = 398.3230271251,y = -226.69279865489,sublevel=3,g=21},
			[7] = {x = 399.23216924262,y = -215.32918542307,sublevel=3,g=21},
			[8] = {x = 210.81173304256,y = -248.97279102389,sublevel=3},
			[9] = {x = 221.72077403337,y = -151.24552494864,sublevel=3},
			[10] = {x = 348.21653245397,y = -195.68532118312,sublevel=1,g=3,teeming=true},
			[11] = {x = 648.99973447062,y = -361.50004132278,sublevel=2,teeming=true,patrolFacing=(27/32)*pi,patrolFacing2=(63/32)*pi,patrol={
				[1] ={x = 648.99973447062,y = -361.50004132278}, --star
				[2] = {x = 653.45446107362,y = -269.6538466602},
				[3] = {x = 617.37053511187,y = -205.4814309538},
				[4] = {x = 653.45446107362,y = -269.6538466602},
				[5] = {x = 648.99973447062,y = -361.50004132278}, --star
				[6] = {x = 631.99993706121,y = -394.50000905246},
				[7] = {x = 537.99971427023,y = -459.49997409992},
				[8] = {x = 451.99976975843,y = -468.50000821426},
				[9] = {x = 537.99971427023,y = -459.49997409992},
				[10] = {x = 631.99993706121,y = -394.50000905246},
			}},
			[12] = {x = 344.01469741187,y = -215.59123526022,sublevel=3,g=97,teeming=true},
        },
    },
	[8] = {
        ["name"] = "Spectral Patron",
        ["health"] = 11224084,
        ["level"] = 110,
        ["creatureType"] = "Undead",
        ["id"] = 116550,
        ["displayId"] = 16555,
        ["count"] = 4,
        ["scale"] = 1,
        ["color"] = {r=1,g=1,b=1,a=0.8},
        ["clones"] = {
			[19] = {x = 205.26259415064,y = -182.65780745615,sublevel=3,g=15},
			[20] = {x = 204.09043285476,y = -189.2623938208,sublevel=3,g=15},
			[21] = {x = 205.45404849616,y = -196.53510160748,sublevel=3,g=15},
			[22] = {x = 202.57828907258,y = -200.5525356755,sublevel=3,g=15},
			[23] = {x = 182.0888270787,y = -164.79501357977,sublevel=3,g=16},
			[24] = {x = 180.72517257113,y = -168.88587956761,sublevel=3,g=16},
			[25] = {x = 181.81760461025,y = -173.77660144877,sublevel=3,g=16},
			[26] = {x = 179.9994376141,y = -176.95840344551,sublevel=3,g=16},
        },
    },
	[9] = {
        ["name"] = "Undying Servant",
        ["health"] = 9119568,
        ["level"] = 110,
        ["creatureType"] = "Undead",
        ["id"] = 114634,
        ["displayId"] = 73417,
        ["count"] = 4,
        ["scale"] = 1,
        ["color"] = {r=1,g=1,b=1,a=0.8},
        ["clones"] = {
            [1] = {x = 422.58950952493,y = -227.57702011854,sublevel=3,patrolFacing=(44/32)*pi,patrol={
				[1] = {x = 527.54736249614,y = -240.59110899057}, --unmarked1
				[2] = {x = 531.5603610157,y = -219.84193898203}, --unmakred1
				[3] = {x = 410.34835244501,y = -204.18061596697},--pu
				[4] = {x = 404.95290078777,y = -251.14399799703},
				[5] = {x = 374.45065180923,y = -272.42666151314},
				[6] = {x = 402.47321749423,y = -275.36095153394},
				[7] = {x = 418.4740987581,y = -254.70166757007},
				[8] = {x = 422.58950952493,y = -227.57702011854},--red
				[9] = {x = 474.63919780784,y = -243.9607384373},
				[10] = {x = 494.59829947984,y = -252.15108638834},
			}},
			[2] = {x = 538.29288766597,y = -234.03492518011,sublevel=3,patrolFacing=(9/32)*pi,patrolFacing2=(45/32)*pi,patrol={
				[1] = {x = 538.29288766597,y = -234.03492518011},
				[2] = {x = 522.65851018744,y = -217.21284513563},
				[3] = {x = 473.35844195619,y = -209.55401245974},
				[4] = {x = 475.63112168721,y = -181.37222589564},
				[5] = {x = 473.35844195619,y = -209.55401245974},
				[6] = {x = 522.65851018744,y = -217.21284513563},
				[7] = {x = 538.29288766597,y = -234.03492518011},--star
				[8] = {x = 600.78251873604,y = -246.76115197568},
				[9] = {x = 599.82059751206,y = -261.58517485771},
				[10] = {x = 561.40792988632,y = -257.5574979106},
				[11] = {x = 561.32966028623,y = -270.81535502417},
				[12] = {x = 561.40792988632,y = -257.5574979106},
				[13] = {x = 599.82059751206,y = -261.58517485771},
				[14] = {x = 600.78251873604,y = -246.76115197568},
			}},
			[3] = {x = 420.80447186512,y = -260.81333108175,sublevel=3,g=29},
			[4] = {x = 483.97936866065,y = -241.32231993236,sublevel=3,g=30},
			[5] = {x = 481.15480784338,y = -250.8007785872,sublevel=3,g=30},
			[6] = {x = 431.68705880048,y = -271.31479686697,sublevel=4,patrolFacing=(31/32)*pi,patrolFacing2=(48/32)*pi,patrol={ --skull guy
				[1] = {x = 431.68705880048,y = -271.31479686697},--green
				[2] = {x = 422.4297218147,y = -342.3424789402},
				[3] = {x = 431.68705880048,y = -271.31479686697},--green
				[4] = {x = 589.99037051703,y = -291.08517782603},
				[5] = {x = 590.44488300561,y = -304.72154733896},
				[6] = {x = 589.99037051703,y = -291.08517782603},
			}},
			[7] = {x = 425.96443487667,y = -317.94549952678,sublevel=4,patrolFacing=(63/32)*pi,patrol={
				[1] = {x = 425.96443487667,y = -317.94549952678},
				[2] = {x = 431.68705880048,y = -271.31479686697},--green
				[3] = {x = 589.99037051703,y = -291.08517782603},
				[4] = {x = 590.44488300561,y = -304.72154733896},
				[5] = {x = 589.99037051703,y = -291.08517782603},
				[6] = {x = 431.68705880048,y = -271.31479686697},--green
			}},
			[8] = {x = 500.65373365769,y = -334.38084961043,sublevel=4,patrolFacing=(16/32)*pi,patrol={
				[1] = {x = 500.65373365769,y = -334.38084961043}, --unmakred1
				[2] = {x = 467.77502591413,y = -335.12078777668},
				[3] = {x = 444.93155020596,y = -300.64376528626},
				[4] = {x = 464.14457248101,y = -298.30644146321},
				[5] = {x = 474.62074264598,y = -310.36288278588},
				[6] = {x = 505.47609063337,y = -315.75031424546},
				[7] = {x = 513.83146670299,y = -302.59988482758},
				[8] = {x = 547.6563248724,y = -305.54672811165},
				[9] = {x = 566.05543641851,y = -320.145324298},
				[10] = {x = 555.20071248758,y = -347.99835386851},
			}},


			[9] = {x = 404.43062235115,y = -218.7534464735,sublevel=3,g=21,teeming=true},
			[10] = {x = 403.97607084863,y = -225.48071647469,sublevel=3,g=21,teeming=true},
        },
    },
	[10] = {
        ["name"] = "Spectral Valet",
        ["health"] = 18868408,
        ["level"] = 111,
        ["creatureType"] = "Undead",
        ["id"] = 114633,
        ["displayId"] = 16494,
        ["count"] = 4,
        ["scale"] = 1,
        ["color"] = {r=1,g=1,b=1,a=0.8},
        ["clones"] = {
            [1] = {x = 473.34785612811,y = -207.37380345559,sublevel=3},
			[2] = {x = 421.92481267477,y = -267.48601343091,sublevel=3,g=29},
			[3] = {x = 430.56121319482,y = -267.48601343091,sublevel=3,g=29},
        },
    },
	[11] = {
        ["name"] = "Phantom Guest",
        ["health"] = 2279892,
        ["level"] = 110,
        ["creatureType"] = "Undead",
        ["id"] = 114625,
        ["displayId"] = 16464,
        ["count"] = 1,
        ["scale"] = 1,
        ["color"] = {r=1,g=1,b=1,a=0.8},
        ["clones"] = {
            [1] = {x = 509.56618987363,y = -217.61384351754,sublevel=3,g=26},
			[2] = {x = 503.70636817776,y = -219.79363920191,sublevel=3,g=26},
			[3] = {x = 512.34280864771,y = -223.42999309526,sublevel=3,g=26},
			[4] = {x = 513.70642428911,y = -227.97545009217,sublevel=3,g=26},
			[5] = {x = 513.70642428911,y = -230.70272038892,sublevel=3,g=26},
			[6] = {x = 505.28552952524,y = -224.82885911605,sublevel=3,g=26},
			[7] = {x = 506.86454322958,y = -226.93406014167,sublevel=3,g=26},
			[8] = {x = 506.33826556019,y = -231.14464288911,sublevel=3,g=26},
			[9] = {x = 511.07503562892,y = -236.40778097531,sublevel=3,g=26},
			
			[10] = {x = 454.05284606553,y = -217.37694834634,sublevel=3,g=27},
			[11] = {x = 460.07055158941,y = -219.37118314728,sublevel=3,g=27},
			[12] = {x = 454.1615381124,y = -222.55302415797,sublevel=3,g=27},
			[13] = {x = 449.1615105986,y = -224.37121066109,sublevel=3,g=27},
			[14] = {x = 450.07061360364,y = -227.09846115531,sublevel=3,g=27},
			[15] = {x = 456.43421759712,y = -226.64394866673,sublevel=3,g=27},
			[16] = {x = 461.43424511093,y = -225.28029415916,sublevel=3,g=27},
			[17] = {x = 460.52510309194,y = -229.371160147,sublevel=3,g=27},
			[18] = {x = 453.25235707946,y = -231.64391765962,sublevel=3,g=27},
			
			[19] = {x = 482.89329270994,y = -273.47400509062,sublevel=3},
			[20] = {x = 515.03397887344,y = -274.83153428945,sublevel=3},
			[21] = {x = 549.17612443151,y = -277.31862426991,sublevel=3,g=28},
			[22] = {x = 557.35789542113,y = -278.68223976353,sublevel=3,g=28},
			[23] = {x = 539.541150496,y = -358.22719470822,sublevel=3},
			[24] = {x = 589.08656201997,y = -304.13630717297,sublevel=3},
			
			[25] = {x = 267.36226721422,y = -290.92417133901,sublevel=4,g=53},
			[26] = {x = 277.81679684944,y = -285.0150987007,sublevel=4,g=53},
			[27] = {x = 289.63498114001,y = -292.74235803917,sublevel=4,g=53},
			[28] = {x = 291.90769988498,y = -309.10597981968,sublevel=4,g=53},
			[29] = {x = 285.08958266403,y = -331.37873275943,sublevel=4,g=53},
			[30] = {x = 272.36221724199,y = -334.56053510099,sublevel=4,g=53},
			
			[31] = {x = 327.23774304242,y = -340.44416624722,sublevel=4,g=54},
			[32] = {x = 327.23774304242,y = -323.6020611277,sublevel=4,g=54},
			[33] = {x = 348.8167537528,y = -315.7073539984,sublevel=4,g=54},
			[34] = {x = 354.079891839,y = -328.86522180093,sublevel=4,g=54},
			[35] = {x = 352.50087813467,y = -339.39154314738,sublevel=4,g=54},
			[36] = {x = 352.06297110139,y = -344.60761497536,sublevel=4,g=54},
			
			[37] = {x = 322.45399371749,y = -387.15983927998,sublevel=4,g=55},
			[38] = {x = 321.99948122892,y = -401.25074078846,sublevel=4,g=55},
			[39] = {x = 340.63581973474,y = -408.97801879648,sublevel=4,g=55},
			[40] = {x = 345.6358082346,y = -406.25074879529,sublevel=4,g=55},
			[41] = {x = 346.99946274217,y = -399.43255428534,sublevel=4,g=55},
			[42] = {x = 347.45401424469,y = -391.25074428177,sublevel=4,g=55},
			
			[43] = {x = 276.34191405262,y = -424.77218957841,sublevel=4,g=56},
			[44] = {x = 278.16012006271,y = -407.04491506369,sublevel=4,g=56},
			[45] = {x = 273.1601705768,y = -390.22672404704,sublevel=4,g=56},
			[46] = {x = 256.34196005318,y = -391.59037855461,sublevel=4,g=56},
			[47] = {x = 251.79652305584,y = -411.590371568,sublevel=4,g=56},
			[48] = {x = 256.79647254176,y = -431.59036458139,sublevel=4,g=56},
			
			[49] = {x = 291.7239795262,y = -445.6812223829,sublevel=4},
			
			[50] = {x = 443.52945912348,y = -328.63367170492,sublevel=4,g=80},
			[51] = {x = 448.24793975582,y = -320.75194799266,sublevel=4,g=80},
			[52] = {x = 457.79336525302,y = -322.57009548183,sublevel=4,g=80},
			[53] = {x = 464.61152074902,y = -328.93375799623,sublevel=4,g=80},
			[54] = {x = 460.06608375169,y = -337.11558750678,sublevel=4,g=80},
			[55] = {x = 453.24788924173,y = -336.20648450173,sublevel=4,g=80},
			
			[56] = {x = 486.83512828464,y = -346.31930567857,sublevel=4,g=81},
			[57] = {x = 492.41338534534,y = -339.52225703279,sublevel=4,g=81},
			[58] = {x = 500.59523436286,y = -342.24952703399,sublevel=4,g=81},
			[59] = {x = 496.04973830105,y = -351.34043112731,sublevel=4,g=81},
			[60] = {x = 503.32244529957,y = -351.79494361589,sublevel=4,g=81},
			[61] = {x = 505.14065130967,y = -347.70405812107,sublevel=4,g=81},
			
			[62] = {x = 480.04409385496,y = -302.43082580389,sublevel=4,g=82},
			[63] = {x = 483.22591535868,y = -285.61265429422,sublevel=4,g=82},
			[64] = {x = 489.31718969834,y = -291.05512575372,sublevel=4,g=82},
			[65] = {x = 489.77170218692,y = -298.78240376175,sublevel=4,g=82},
			[66] = {x = 472.49901818867,y = -296.96421725863,sublevel=4,g=82},
			[67] = {x = 476.1353911949,y = -289.23691974363,sublevel=4,g=82},
			
			[68] = {x = 543.40815526149,y = -354.23693605109,sublevel=4,g=83},
			[69] = {x = 558.40815977502,y = -347.41876104811,sublevel=4,g=83},
			[70] = {x = 549.9779021692,y = -357.05510571606,sublevel=4,g=83},
			[71] = {x = 556.34154517663,y = -354.78234820345,sublevel=4,g=83},
			[72] = {x = 544.97795268329,y = -344.78235169675,sublevel=4,g=83},
			[73] = {x = 550.43245367172,y = -341.14597869052,sublevel=4,g=83},
			
			[74] = {x = 561.8620353012,y = -304.85731895613,sublevel=4,g=84},
			[75] = {x = 579.4691172231,y = -295.26638920284,sublevel=4,g=84},
			[76] = {x = 568.69837216087,y = -302.87643885053,sublevel=4,g=84},
			[77] = {x = 577.33473366697,y = -302.87643885053,sublevel=4,g=84},
			[78] = {x = 564.60748666605,y = -296.05822483361,sublevel=4,g=84},
			[79] = {x = 571.42568117601,y = -291.96731983182,sublevel=4,g=84},
			[80] = {x = 600.19481304435,y = -335.33908128892,sublevel=4},
        },
    },
	[12] = {
        ["name"] = "Spectral Retainer",
        ["health"] = 23585511,
        ["level"] = 111,
        ["creatureType"] = "Undead",
        ["id"] = 114629,
        ["displayId"] = 73465,
        ["count"] = 4,
        ["scale"] = 1,
        ["color"] = {r=1,g=1,b=1,a=0.8},
        ["clones"] = {
            [1] = {x = 429.19755868725,y = -257.0314654217,sublevel=3,g=29},
			[2] = {x = 478.42753784219,y = -247.61895708348,sublevel=3,g=30},			
			[3] = {x = 513.77683142359,y = -313.34052542304,sublevel=4,g=85},			
			[4] = {x = 449.4132018587,y = -285.55338483873,sublevel=4,g=86},
        },
    },
	[13] = {
        ["name"] = "Spectral Attendant",
        ["health"] = 9821073,
        ["level"] = 110,
        ["creatureType"] = "Undead",
        ["id"] = 114632,
        ["displayId"] = 16514,
        ["count"] = 4,
        ["scale"] = 1,
        ["color"] = {r=1,g=1,b=1,a=0.8},
        ["clones"] = {
            [1] = {x = 432.99216116691,y = -262.22692643352,sublevel=3,g=29},
			[2] = {x = 490.39746615361,y = -244.9588381489,sublevel=3,g=30},
			[3] = {x = 489.03381149826,y = -250.41337874241,sublevel=3,g=30},
			[4] = {x = 516.69289934394,y = -321.81186761919,sublevel=4,g=85},
			[5] = {x = 522.86774443221,y = -309.24960091428,sublevel=4,g=85},
			[6] = {x = 453.04953585099,y = -296.4624648435,sublevel=4,g=86},
			[7] = {x = 439.86773734756,y = -293.73519484231,sublevel=4,g=86},
        },
    },
	[14] = {
        ["name"] = "Phantom Guardsman",
        ["health"] = 11399460,
        ["level"] = 110,
        ["creatureType"] = "Undead",
        ["id"] = 114636,
        ["displayId"] = 16454,
        ["count"] = 4,
        ["scale"] = 1,
        ["color"] = {r=1,g=1,b=1,a=0.8},
        ["clones"] = {
            [1] = {x = 510.73677773599,y = -159.29211332513,sublevel=3,g=31},
			[2] = {x = 517.5416403315,y = -159.54203866411,sublevel=3,g=31},
			[3] = {x = 597.34302816892,y = -188.43997943275,sublevel=3,g=41,note="Random spawn sentry or guard"},
			[4] = {x = 638.21122807757,y = -234.3161059158,sublevel=3,g=42,note="Random spawn sentry or guard"},
			[5] = {x = 365.99703308195,y = -256.4987388663,sublevel=5,g=63,patrolFacing=(14/32)*pi,patrol={
				[1] = {x = 365.99703308195,y = -256.4987388663},
				[2] = {x = 299.33461823165,y = -246.78578195354},
				[3] = {x = 234.78915618528,y = -298.60397611275},
				[4] = {x = 222.06190780509,y = -366.78581155944},
				[5] = {x = 279.28211937828,y = -444.31822444565},
				[6] = {x = 365.64574379867,y = -450.68184863574},
				[7] = {x = 417.00944492702,y = -404.7727661288},
				[8] = {x = 439.55884660488,y = -363.98491575787},
				[9] = {x = 430.92252317679,y = -304.43944275322},
			}},
			[6] = {x = 390.99702208675,y = -320.49856742658,sublevel=5,g=64},
			[7] = {x = 382.99691546895,y = -307.49856583401,sublevel=5,g=64},
			[8] = {x = 447.3915757738,y = -432.67067174265,sublevel=5,g=65},
			[9] = {x = 432.39149160678,y = -450.85251923727,sublevel=5,g=65},
			[10] = {x = 386.14452209172,y = -389.43674597233,sublevel=5,g=66},
			[11] = {x = 392.39455211524,y = -396.31173071843,sublevel=5,g=66},
			[12] = {x = 301.86865692113,y = -287.15878063611,sublevel=5,g=68},
			[13] = {x = 286.86868979598,y = -271.70430097312,sublevel=5,g=68},
			[14] = {x = 221.06910804349,y = -278.06778837819,sublevel=5,g=69},
			[15] = {x = 214.70546503606,y = -297.15867838653,sublevel=5,g=69},
			[16] = {x = 265.80370758606,y = -312.80590319682,sublevel=5,g=70},
			[17] = {x = 253.53101075765,y = -328.71499293252,sublevel=5,g=70},
			[18] = {x = 634.86002323803,y = -239.80266262532,sublevel=3,g=42,teeming=true},
			[19] = {x = 647.13271873642,y = -222.07538811061,sublevel=3,g=42,teeming=true},
			[20] = {x = 335.87167325016,y = -286.12220277265,sublevel=5,g=101,teeming=true},
			[21] = {x = 344.81907124037,y = -289.28009465918,sublevel=5,g=101,teeming=true},
			[22] = {x = 344.99962850846,y = -476.49996638857,sublevel=5,g=102,teeming=true},
			[23] = {x = 344.99962850846,y = -494.49999170192,sublevel=5,g=102,teeming=true},
			[24] = {x = 348.54159487738,y = -447.04544033469,sublevel=6,g=71,teeming=true},
			[25] = {x = 345.35977337367,y = -452.95455134657,sublevel=6,g=71,teeming=true},
        },
    },
	[15] = {
        ["name"] = "Reformed Maiden",
        ["health"] = 7856858,
        ["level"] = 110,
        ["creatureType"] = "Demon",
        ["id"] = 114783,
        ["displayId"] = 16551,
        ["count"] = 4,
        ["scale"] = 1,
        ["color"] = {r=1,g=1,b=1,a=0.8},
        ["clones"] = {
            [1] = {x = 537.54159433094,y = -137.26930764508,sublevel=3,g=32},			
			[2] = {x = 540.61766086629,y = -81.135808301347,sublevel=3,g=33},
			[3] = {x = 481.32932767863,y = -113.86300284464,sublevel=3,g=36},
			[4] = {x = 489.0565870171,y = -108.86301380292,sublevel=3,g=36},
			[5] = {x = 557.00838664274,y = -185.29768737476,sublevel=3,g=38},
			[6] = {x = 541.50808198976,y = -194.55365017587,sublevel=3,g=39},
			[7] = {x = 586.40201472183,y = -144.3444543744,sublevel=3,g=43},
			[8] = {x = 598.2201990124,y = -103.4354194301,sublevel=3,g=44},
			[9] = {x = 561.63508318045,y = -133.40846330692,sublevel=3,g=46},
			[10] = {x = 667.49234885847,y = -188.7896668291,sublevel=3,g=48},
			[11] = {x = 691.80376495691,y = -161.10500223578,sublevel=3,g=50},
			[12] = {x = 703.09368272113,y = -137.0508629767,sublevel=3,g=51},
			[13] = {x = 708.54814528673,y = -129.32360363823,sublevel=3,g=51},
        },
    },
	[16] = {
        ["name"] = "Wholesome Hostess",
        ["health"] = 11224084,
        ["level"] = 110,
        ["creatureType"] = "Undead",
        ["id"] = 114796,
        ["displayId"] = 16543,
        ["count"] = 4,
        ["scale"] = 1,
        ["color"] = {r=1,g=1,b=1,a=0.8},
        ["clones"] = {
            [1] = {x = 529.35982334131,y = -141.36019313989,sublevel=3,g=32},
			[2] = {x = 534.70860837533,y = -87.044860792305,sublevel=3,g=33},			
			[3] = {x = 510.44288884631,y = -94.474277523136,sublevel=3,g=35},
			[4] = {x = 464.51111605628,y = -90.681158072019,sublevel=3,g=37},
			[5] = {x = 559.09945553959,y = -179.21599568111,sublevel=3,g=38,patrolFacing=(14/32)*pi,patrolFacing2=(44/32)*pi,patrol={
				[1] = {x = 559.09945553959,y = -179.21599568111},--blue
				[2] = {x = 514.79770569277,y = -168.48430999373},--yellow
				[3] = {x = 518.8885722902,y = -108.93892665835},--skull
				[4] = {x = 479.34313776595,y = -100.75707764083},--inner skul
				[5] = {x = 518.8885722902,y = -108.93892665835},--skull
				[6] = {x = 514.79770569277,y = -168.48430999373},--yellow
				[7] = {x = 559.09945553959,y = -179.21599568111},--blue
				[8] = {x = 582.3188602114,y = -110.35507097078},--moon
				[9] = {x = 559.09945553959,y = -179.21599568111},--blue
				[10] = {x = 630.95520774428,y = -219.90050054887},--green
				[11] = {x = 690.95522579839,y = -133.99139797646},--purple
				[12] = {x = 630.95520774428,y = -219.90050054887},--green
				[13] = {x = 559.09945553959,y = -179.21599568111},--blue
				[14] = {x = 582.3188602114,y = -110.35507097078},--moon
				[15] = {x = 559.09945553959,y = -179.21599568111},--blue
				[16] = {x = 514.79770569277,y = -168.48430999373},--yellow
				[17] = {x = 518.8885722902,y = -108.93892665835},--skull
				[18] = {x = 479.34313776595,y = -100.75707764083},--inner skul
				[19] = {x = 518.8885722902,y = -108.93892665835},--skull
				[20] = {x = 514.79770569277,y = -168.48430999373},--yellow
				[21] = {x = 559.09945553959,y = -179.21599568111},--blue
				[22] = {x = 630.95520774428,y = -219.90050054887},--green
				[23] = {x = 690.95522579839,y = -133.99139797646},--purple
				[24] = {x = 630.95520774428,y = -219.90050054887},--green

			}},
			[6] = {x = 544.68986447953,y = -199.55363867573,sublevel=3,g=39},
			[7] = {x = 562.20848652372,y = -202.98482005969,sublevel=3,g=40},			
			[8] = {x = 577.76569129374,y = -145.70810902975,sublevel=3,g=43},				
			[9] = {x = 593.22013194278,y = -99.799026522806,sublevel=3,g=44},
			[10] = {x = 582.08966892702,y = -96.13574324201,sublevel=3,g=45},	
			[11] = {x = 643.09131983527,y = -182.93224927212,sublevel=3,g=47},	
			[12] = {x = 663.80813412851,y = -195.10547318919,sublevel=3,g=48},
			[13] = {x = 687.06690454009,y = -169.52605479554,sublevel=3,g=50},			
			[14] = {x = 683.54820007814,y = -121.59634429976,sublevel=3,g=52},
			[15] = {x = 551.15056743248,y = -196.62557419674,sublevel=3,g=39,teeming=true},
        },
    },
	[17] = {
        ["name"] = "Virtuous Lady",
        ["health"] = 7856858,
        ["level"] = 110,
        ["creatureType"] = "Undead",
        ["id"] = 114792,
        ["displayId"] = 16547,
        ["count"] = 4,
        ["scale"] = 1,
        ["color"] = {r=1,g=1,b=1,a=0.8},
        ["clones"] = {
            [1] = {x = 512.78465699861,y = -131.13577132784,sublevel=3,g=34},
			[2] = {x = 505.69956771493,y = -133.98147371996,sublevel=3,g=34},
			[3] = {x = 512.26119312193,y = -85.383428871442,sublevel=3,g=35},
			[4] = {x = 469.96569566373,y = -85.226636985492,sublevel=3,g=37},			
			[5] = {x = 567.20847502358,y = -202.98482005969,sublevel=3,g=40},
			[6] = {x = 573.90781902281,y = -95.681152676275,sublevel=3,g=45},	
			[7] = {x = 568.45327842931,y = -131.59027660676,sublevel=3,g=46},
			[8] = {x = 638.54584382399,y = -187.4777252834,sublevel=3,g=47},
			[9] = {x = 657.08967750494,y = -156.61845011144,sublevel=3,g=49},
			[10] = {x = 655.27139346696,y = -160.70933560625,sublevel=3,g=49},
			[11] = {x = 690.82090786482,y = -117.05086779587,sublevel=3,g=52},
			[12] = {x = 547.05960390977,y = -191.62558569688,sublevel=3,g=39,teeming=true},
			[13] = {x = 559.31193018453,y = -196.90215176127,sublevel=3,g=40,teeming=true},
			[14] = {x = 565.10139111416,y = -197.95470710003,sublevel=3,g=40,teeming=true},
        },
    },
	[18] = {
        ["name"] = "Spectral Sentry",
        ["health"] = 11224084,
        ["level"] = 110,
        ["creatureType"] = "Undead",
        ["id"] = 114637,
        ["displayId"] = 16458,
        ["count"] = 4,
        ["scale"] = 1,
        ["color"] = {r=1,g=1,b=1,a=0.8},
        ["clones"] = {
            [1] = {x = 551.00652559478,y = -165.41656002662,sublevel=3},
			[2] = {x = 571.4610723274,y = -171.78018421671,sublevel=3},			
			[3] = {x = 603.25211967383,y = -192.07633293201,sublevel=3,g=41,note="Random spawn sentry or guard"},
			[4] = {x = 642.53099855413,y = -227.3108040583,sublevel=3,g=42,note="Random spawn sentry or guard"},			
			[5] = {x = 361.99689394236,y = -270.49871087074,sublevel=5,g=63},
			[6] = {x = 390.35802541518,y = -303.18898260562,sublevel=5,g=64},
			[7] = {x = 398.08528475365,y = -315.00716689619,sublevel=5,g=64},
			[8] = {x = 430.11877286182,y = -438.12523184313,sublevel=5,g=65},
			[9] = {x = 408.75512302564,y = -424.03430930061,sublevel=5,patrolFacing=(43/32)*pi,patrolFacing2=(9/32)*pi,patrol={
				[1] = {x = 408.75512302564,y = -424.03430930061},
				[2] = {x = 392.38284875864,y = -409.35761625324},
				[3] = {x = 408.75512302564,y = -424.03430930061},
				[4] = {x = 425.11013133361,y = -433.90304892401},
			}},
			[10] = {x = 375.51954078919,y = -404.43675902016,sublevel=5,g=66},
			[11] = {x = 311.6026692047,y = -471.6839473906,sublevel=5,g=67},
			[12] = {x = 314.10275631596,y = -447.93399155159,sublevel=5,g=67},
			[13] = {x = 304.58337207007,y = -280.10437659248,sublevel=5,g=68},
			[14] = {x = 289.58340494491,y = -262.83167121538,sublevel=5,g=68},
			[15] = {x = 251.63815577463,y = -280.7203867191,sublevel=5,patrolFacing=(49/32)*pi,patrol={
				[1] = {x = 251.63815577463,y = -280.7203867191},
				[2] = {x = 279.71380387275,y = -277.2446260036},
				[3] = {x = 306.72958867556,y = -291.68819060631},
				[4] = {x = 307.74069072299,y = -236.2592572044},
				[5] = {x = 300.34457313695,y = -217.75694992672},
				[6] = {x = 228.08468774247,y = -287.98315892764},
				[7] = {x = 197.27262677347,y = -345.52451995465},
				[8] = {x = 235.01884885997,y = -346.6518670996},
			}},
			[16] = {x = 216.90126132195,y = -283.3404067866,sublevel=5,g=69},
			[17] = {x = 216.90126132195,y = -303.79493179554,sublevel=5,g=69},
			[18] = {x = 260.90531406234,y = -315.46780268977,sublevel=5,g=70},
			[19] = {x = 254.54167105491,y = -335.01322469366,sublevel=5,g=70},
			[20] = {x = 642.13273023656,y = -232.0753846173,sublevel=3,g=42,teeming=true},
			[21] = {x = 345.87171692723,y = -279.80644158661,sublevel=5,g=101,teeming=true},
			[22] = {x = 335.87167325016,y = -277.70112762587,sublevel=5,g=101,teeming=true},
			[23] = {x = 357.99963010103,y = -472.49999891035,sublevel=5,g=102,teeming=true},
			[24] = {x = 359.99965675548,y = -488.49999756925,sublevel=5,g=102,teeming=true},
        },
    },
	
	[19] = {
        ["name"] = "Arcane Warden",
        ["health"] = 23585511,
        ["level"] = 111,
        ["creatureType"] = "Elemental",
        ["id"] = 114624,
        ["displayId"] = 61125,
        ["count"] = 8,
        ["scale"] = 1,
        ["color"] = {r=1,g=1,b=1,a=0.8},
        ["clones"] = {
            [1] = {x = 363.28167879596,y = -430.59500450464,sublevel=4,g=100},
			[2] = {x = 303.99731513858,y = -276.49870399758,sublevel=4,g=99},
			[3] = {x = 406.77974060126,y = -311.81999755711,sublevel=4,g=98},
			[4] = {x = 405.50682930917,y = -327.88835274568,sublevel=4,g=98,teeming=true},
			[5] = {x = 408.2341383243,y = -295.61560571298,sublevel=4,g=98,teeming=true},
			[6] = {x = 312.60704850344,y = -277.64394510374,sublevel=4,g=99,teeming=true},
			[7] = {x = 363.05723929787,y = -440.78959614011,sublevel=4,g=100,teeming=true},
        },
    },
	[20] = {
        ["name"] = "Skeletal Waiter",
        ["health"] = 14695587,
        ["level"] = 111,
        ["creatureType"] = "Undead",
        ["id"] = 114628,
        ["displayId"] = 73472,
        ["count"] = 4,
        ["scale"] = 1,
        ["color"] = {r=1,g=1,b=1,a=0.8},
        ["clones"] = {
            [1] = {x = 332.66031158643,y = -464.77275508932,sublevel=4,patrolFacing=(14/32)*pi,patrolFacing2=(44/32)*pi,patrol={
				[1] = {x = 332.66031158643,y = -464.77275508932},
				[2] = {x = 271.12902479924,y = -364.4142032679},
				[3] = {x = 210.45438368497,y = -365.23365461759},
				[4] = {x = 271.12902479924,y = -364.4142032679},
				[5] = {x = 332.66031158643,y = -464.77275508932},--green
				[6] = {x = 333.99956571311,y = -493.50000586733},
				[7] = {x = 388.99961206503,y = -500.50001332723},
				[8] = {x = 333.99956571311,y = -493.50000586733},
			}},
			[2] = {x = 381.9973385781,y = -75.498648090288,sublevel=5,g=57},
			[3] = {x = 381.9973385781,y = -84.498596373947,sublevel=5,g=57},
			[4] = {x = 613.24416160501,y = -180.6812560768,sublevel=5,g=62},
			[5] = {x = 605.51686325259,y = -171.59034208297,sublevel=5,g=62},
        },
    },
	[21] = {
        ["name"] = "Skeletal Hound",
        ["health"] = 14205481,
        ["level"] = 110,
        ["creatureType"] = "Undead",
        ["id"] = 114794,
        ["displayId"] = 73458,
        ["count"] = 4,
        ["scale"] = 1.2,
        ["color"] = {r=1,g=1,b=1,a=0.8},
        ["clones"] = {
            [1] = {x = 309.09237137988,y = -121.59028463598,sublevel=5,g=58},
			[2] = {x = 533.95609049916,y = -139.05189937813,sublevel=5,patrolFacing=(39/32)*pi,patrol={
				[1] = {x = 533.95609049916,y = -139.05189937813},
				[2] = {x = 545.09117623484,y = -159.31817306921},
				[3] = {x = 571.45477324171,y = -163.409078071},
				[4] = {x = 577.36386474661,y = -148.86364456697},
				[5] = {x = 576.90935225804,y = -129.31818354913},
				[6] = {x = 546.90930421703,y = -115.68183354318},
			}},
			[3] = {x = 586.55846303839,y = -373.97545182207,sublevel=4},
        },
    },
	[22] = {
        ["name"] = "Ghostly Baker",
        ["health"] = 6839676,
        ["level"] = 110,
        ["creatureType"] = "Undead",
        ["id"] = 114716,
        ["displayId"] = 16529,
        ["count"] = 1,
        ["scale"] = 1,
        ["color"] = {r=1,g=1,b=1,a=0.8},
        ["clones"] = {
            [1] = {x = 317.72877189992,y = -133.40846764579,sublevel=5,g=58},
			[2] = {x = 419.53618655127,y = -122.04493331164,sublevel=5,g=59},
			[3] = {x = 539.60782457877,y = -187.95396386348,sublevel=5,g=61},
        },
    },
	[23] = {
        ["name"] = "Ghostly Chef",
        ["health"] = 14205481,
        ["level"] = 110,
        ["creatureType"] = "Undead",
        ["id"] = 114715,
        ["displayId"] = 16524,
        ["count"] = 4,
        ["scale"] = 1,
        ["color"] = {r=1,g=1,b=1,a=0.8},
        ["clones"] = {
            [1] = {x = 316.50978950745,y = -146.59037630061,sublevel=5,g=58},
			[2] = {x = 438.99707703293,y = -123.49876561947,sublevel=5,g=59},
			[3] = {x = 428.17254899331,y = -119.7721950597,sublevel=5,g=59},
			[4] = {x = 371.61462663003,y = -168.34076785299,sublevel=5,patrolFacing=(39/32)*pi,patrol={
				[1] = {x = 371.61462663003,y = -168.34076785299},
				[2] = {x = 383.71067755711,y = -183.47128591208},
				[3] = {x = 410.52886798679,y = -180.7440351223},
				[4] = {x = 419.61978198061,y = -168.92585083173},
				[5] = {x = 398.71068369621,y = -153.01676109603},
			}},
			[5] = {x = 519.15327784616,y = -185.68124511851,sublevel=5,g=61},
			[6] = {x = 530.06232001921,y = -185.68124511851,sublevel=5,g=61},
        },
    },
	[24] = {
        ["name"] = "Ghostly Steward",
        ["health"] = 14205481,
        ["level"] = 110,
        ["creatureType"] = "Undead",
        ["id"] = 114714,
        ["displayId"] = 16535,
        ["count"] = 4,
        ["scale"] = 1,
        ["color"] = {r=1,g=1,b=1,a=0.8},
        ["clones"] = {
            [1] = {x = 446.61461831163,y = -179.70440059178,sublevel=5},
			[2] = {x = 554.60783803977,y = -133.40851806954,sublevel=5,g=60},
			[3] = {x = 552.78967084659,y = -143.40853516693,sublevel=5,g=60},
        },
    },
	[25] = {
        ["name"] = "Spectral Journeyman",
        ["health"] = 16158753,
        ["level"] = 110,
        ["creatureType"] = "Undead",
        ["id"] = 114802,
        ["displayId"] = 73470,
        ["count"] = 4,
        ["scale"] = 1,
        ["color"] = {r=1,g=1,b=1,a=0.8},
        ["clones"] = {
            [1] = {x = 351.73132341236,y = -454.31765559914,sublevel=6,g=71},
			[2] = {x = 353.46827623718,y = -447.49944618549,sublevel=6,g=71},			
			[2] = {x = 347.61365165306,y = -417.49941704864,sublevel=6,g=72},
        },
    },
	[26] = {
        ["name"] = "Spectral Apprentice",
        ["health"] = 16158753,
        ["level"] = 110,
        ["creatureType"] = "Undead",
        ["id"] = 114801,
        ["displayId"] = 16417,
        ["count"] = 4,
        ["scale"] = 1,
        ["color"] = {r=1,g=1,b=1,a=0.8},
        ["clones"] = {
            [1] = {x = 353.46827623718,y = -442.04484766218,sublevel=6,g=71},
			[2] = {x = 369.36563782991,y = -409.59361660775,sublevel=6,g=72},
			[3] = {x = 362.14970715029,y = -409.94669601312,sublevel=6,g=72},
			[4] = {x = 339.88635413806,y = -422.95399606497,sublevel=6,g=72},
			[5] = {x = 363.17979330448,y = -498.40854662626,sublevel=6,g=78},
			[6] = {x = 329.95902761124,y = -486.13579466577,sublevel=6,g=79},
			[7] = {x = 394.05460694759,y = -327.37198587238,sublevel=5,g=64,teeming=true},
			[8] = {x = 401.78186544864,y = -321.00832335797,sublevel=5,g=64,teeming=true},
			[9] = {x = 374.39834690511,y = -257.80464444771,sublevel=5,g=63,teeming=true},
			[10] = {x = 372.58021872588,y = -273.71373418341,sublevel=5,g=63,teeming=true},
			[11] = {x = 354.13379726787,y = -447.95454333974,sublevel=6,g=71},
        },
    },
	[27] = {
        ["name"] = "Spectral Charger",
        ["health"] = 14205481,
        ["level"] = 110,
        ["creatureType"] = "Undead",
        ["id"] = 114804,
        ["displayId"] = 16407,
        ["count"] = 4,
        ["scale"] = 1,
        ["color"] = {r=1,g=1,b=1,a=0.8},
        ["clones"] = {
            [1] = {x = 388.79561252632,y = -400.66789707704,sublevel=6},
			[2] = {x = 394.70054302388,y = -431.13589934981,sublevel=6,g=73},
			[3] = {x = 400.60963452879,y = -435.22676533765,sublevel=6,g=73},
			[4] = {x = 440.15510806699,y = -466.59042887228,sublevel=6,g=74},
			[5] = {x = 437.88231154042,y = -476.590405872,sublevel=6,g=74},
			[6] = {x = 430.15513106727,y = -498.86311738405,sublevel=6,g=76},
			[7] = {x = 427.42786106607,y = -506.59039539208,sublevel=6,g=76},
			[8] = {x = 391.97331203664,y = -522.95405441317,sublevel=6,g=77},
			[9] = {x = 381.97329602297,y = -522.49948340368,sublevel=6,g=77},
			[10] = {x = 362.01369224324,y = -491.13581933259,sublevel=6,g=78},
			[11] = {x = 357.92280630509,y = -501.59034896782,sublevel=6,g=78},
			[12] = {x = 324.11024977228,y = -485.22673067467,sublevel=6,g=79},
			[13] = {x = 323.20114676724,y = -476.5903496616,sublevel=6,g=79},
			[14] = {x = 364.72784557708,y = -503.86361737811,sublevel=6,g=78,teeming=true},
			[15] = {x = 369.27332158837,y = -497.95452587321,sublevel=6,g=78,teeming=true},
        },
    },
	[28] = {
        ["name"] = "Spectral Stable Hand",
        ["health"] = 14205481,
        ["level"] = 110,
        ["creatureType"] = "Undead",
        ["id"] = 114803,
        ["displayId"] = 16397,
        ["count"] = 4,
        ["scale"] = 1,
        ["color"] = {r=1,g=1,b=1,a=0.8},
        ["clones"] = {
            [1] = {x = 435.6096320557,y = -485.68131888062,sublevel=6,patrolFacing=(62/32)*pi,patrolFacing2=(27/32)*pi,patrol={
				[1] = {x = 435.6096320557,y = -485.68131888062},
				[2] = {x = 430.95474877065,y = -495.68182803912},
				[3] = {x = 435.6096320557,y = -485.68131888062},
				[4] = {x = 437.31835345377,y = -478.40912266202},
			}},
			[2] = {x = 366.36153712512,y = -492.95398652578,sublevel=6,g=78},
			[3] = {x = 328.59533408973,y = -479.77217116531,sublevel=6,g=79},
			[4] = {x = 329.04988559225,y = -472.04487365032,sublevel=6,g=79},
        },
    },
	[29] = {
        ["name"] = "Coldmist Widow",
        ["health"] = 11364385,
        ["level"] = 110,
        ["creatureType"] = "Beast",
        ["id"] = 115019,
        ["displayId"] = 16050,
        ["count"] = 8,
        ["scale"] = 1,
        ["color"] = {r=1,g=1,b=1,a=0.8},
        ["clones"] = {
            [1] = {x = 505.61274520887,y = -262.18668160152,sublevel=6,g=87},
			[2] = {x = 506.9405322862,y = -245.96554217584,sublevel=6,g=87},
			[3] = {x = 475.52765060204,y = -214.34180960998,sublevel=6,g=88},
			[4] = {x = 462.34592869797,y = -217.06909941371,sublevel=6,g=88},
			[5] = {x = 448.70961622817,y = -213.88727756517,sublevel=6,g=88},
			[6] = {x = 400.5194281756,y = -239.15688971534,sublevel=6,g=89},
			[7] = {x = 397.7921581744,y = -225.06594919291,sublevel=6,g=89},
			[8] = {x = 400.97401869207,y = -212.338702192,sublevel=6,g=89},	
			[9] = {x = 580.82220322801,y = -156.43656002687,sublevel=6,g=90},
			[10] = {x = 567.1858142081,y = -153.70925101173,sublevel=6,g=90},
			[11] = {x = 553.09491269962,y = -152.34567453205,sublevel=6,g=90},
			[12] = {x = 495.99602039345,y = -79.498658902943,sublevel=6},
			[13] = {x = 507.43100219001,y = -87.95393183191,sublevel=6,g=91},
			[14] = {x = 518.34012239097,y = -89.317566980285,sublevel=6,g=91},
			[15] = {x = 552.15552620222,y = -125.52563466364,sublevel=6},
			[16] = {x = 571.10292269545,y = -127.63090345033,sublevel=6,g=92},
			[17] = {x = 580.05027551162,y = -128.68348137612,sublevel=6,g=92},
			[18] = {x = 565.5535281264,y = -87.044854064551,sublevel=6},
			[19] = {x = 576.91719987914,y = -89.317572809518,sublevel=6,g=93},
			[20] = {x = 586.46266542475,y = -89.772124361302,sublevel=6,g=93},
			
        },
    },
	[30] = {
        ["name"] = "Coldmist Stalker",
        ["health"] = 11364385,
        ["level"] = 110,
        ["creatureType"] = "Beast",
        ["id"] = 115115,
        ["displayId"] = 16051,
        ["count"] = 4,
        ["scale"] = 0.8,
        ["color"] = {r=1,g=1,b=1,a=0.8},
        ["clones"] = {
            [1] = {x = 468.55873072546,y = -297.01337133548,sublevel=6},
			[2] = {x = 455.59480628465,y = -261.35741292209,sublevel=6},
			[3] = {x = 398.70126117945,y = -203.24778918338,sublevel=6},
			[4] = {x = 406.88307118303,y = -251.42960472071,sublevel=6},
			[5] = {x = 497.33761075277,y = -191.42960617357,sublevel=6},			
			[6] = {x = 559.91310720957,y = -168.70925552526,sublevel=6},
			[7] = {x = 542.08578296582,y = -178.65054046265,sublevel=6},
			[8] = {x = 488.99609876424,y = -98.498654628173,sublevel=6},
			[9] = {x = 525.54906177474,y = -89.772108803278,sublevel=6},
			[10] = {x = 531.4581142657,y = -120.22664982588,sublevel=6},
			[11] = {x = 570.27275731482,y = -97.044821631039,sublevel=6},
			[12] = {x = 628.44913541382,y = -116.59030215585,sublevel=6},
			[13] = {x = 627.99466193919,y = -107.49938914723,sublevel=6},
			[14] = {x = 623.44918592791,y = -100.68123365122,sublevel=6},
			[15] = {x = 615.7219664408,y = -100.2266821487,sublevel=6},
			[16] = {x = 611.63096390415,y = -107.49938914723,sublevel=6},
			[17] = {x = 611.17649042952,y = -114.31758365718,sublevel=6},
			[18] = {x = 614.81282442181,y = -123.4084966658,sublevel=6},
			[19] = {x = 607.99462991186,y = -129.77212016626,sublevel=6},
			[20] = {x = 513.15797901601,y = -160.85911612286,sublevel=6},
			[21] = {x = 472.24884653684,y = -150.40456698066,sublevel=6},
			[22] = {x = 421.14262066192,y = -176.73884221125,sublevel=6},
			[23] = {x = 430.23365071238,y = -174.01157221005,sublevel=6},
			[24] = {x = 435.68807367292,y = -174.46612371258,sublevel=6},
			[25] = {x = 453.41546522948,y = -173.55705972148,sublevel=6},
			[26] = {x = 408.80044343844,y = -129.34926718709,sublevel=6},
			[27] = {x = 425.61855458486,y = -135.71293668726,sublevel=6},
			[28] = {x = 463.4150938915,y = -207.12163967268,sublevel=6},
        },
    },
	[31] = {
        ["name"] = "Arcanid",
        ["health"] = 14030105,
        ["level"] = 110,
        ["creatureType"] = "Beast",
        ["id"] = 115020,
        ["displayId"] = 72245,
        ["count"] = 8,
        ["scale"] = 1,
        ["color"] = {r=1,g=1,b=1,a=0.8},
        ["clones"] = {
            [1] = {x = 494.59772501279,y = -240.59722821976,sublevel=6,patrolFacing=(63/32)*pi,patrolFacing2=(16/32)*pi,patrol={
				[1] = {x = 494.59772501279,y = -240.59722821976},
				[2] = {x = 414.59774428948,y = -235.14266811928},
				[3] = {x = 494.59772501279,y = -240.59722821976},
				[4] = {x = 497.77958587528,y = -183.32447396008},
			}},
			[2] = {x = 451.33181430652,y = -157.45797518887,sublevel=6,patrolFacing=(47/32)*pi,patrolFacing2=(16/32)*pi,patrol={
				[1] = {x = 451.33181430652,y = -157.45797518887},
				[2] = {x = 411.42762430493,y = -152.37473028432},
				[3] = {x = 451.33181430652,y = -157.45797518887},
				[4] = {x = 565.82467330989,y = -168.84467946338},
			}},
			[3] = {x = 569.13938140534,y = -106.59085582796,sublevel=6,patrolFacing=(48/32)*pi,patrolFacing2=(15/32)*pi,patrol={
				[1] = {x = 569.13938140534,y = -106.59085582796},
				[2] = {x = 616.15615741263,y = -112.36200315436},
				[3] = {x = 569.13938140534,y = -106.59085582796},
				[4] = {x = 527.51974582508,y = -100.99833263312},
			}},
			[4] = {x = 509.76015083653,y = -79.318125397963,sublevel=6,patrolFacing=(48/32)*pi,patrolFacing2=(31/32)*pi,patrol={
				[1] = {x = 509.76015083653,y = -79.318125397963},
				[2] = {x = 505.49475203516,y = -150.0395039277}, --purple
				[3] = {x = 509.76015083653,y = -79.318125397963},
				[4] = {x = 537.48740535583,y = -82.95445978433},
			}},
        },
    },
	[32] = {
		["name"] = "Shrieking Terror",
		["health"] = 21045157*nerfMultiplier,
		["level"] = 110,
		["creatureType"] = "Undead",
		["id"] = 114627,
		["displayId"] = 10698,
		["count"] = 4,
		["scale"] = 1,
		["color"] = {r=1,g=1,b=1,a=0.8},
		["clones"] = {
			[1] = {x = 472.61093967535,y = -320.11423016035,sublevel=1,g=94,teeming=true},
			[2] = {x = 496.71148751795,y = -299.18760712171,sublevel=1,g=95,teeming=true},
		},
	},
}
