--
--	Grail Achievements
--	Written by scott@mithrandir.com
--
--	Version History
--		001	Initial version
--		002	Converted to be a load-on-demand addon.
--		003	Added the cooking and fishing achievements.
--		004	Added the Just Another Day in Tol Barad achievements.
--		005	Removed the version check since live now has MoP data in it.
--		006 Changes the internal structure to reduce memory consumption by over 0.6 MB.
--			Basically after the quests are added to the map areas associated with the
--			achievements the data is removed, except a new table is created to map the
--			questId to the loremaster map area appropriate for the quest.
--		007 Interface 50300
--		008	Adds some achievements for Wrathion.
--			Moves some achievements from The Maelstrom into Kalimdor and Eastern Kingdoms.
--			Splits Grail.achievements into Grail.loremasterAchievements and Grail.extraAchievements for those that want finer grain control.
--		009	Makes it so the Pandaria "loremaster" achievements are fleshed out to include all the prerequisite quests for each sub achievement.
--		010	Switches to not rely on Grail.quests any more.
--			Corrects a lack of populating the Loremaster only quests data for the Pandaria quests (which Loremaster uses for pins).
--
--	Known Issues
--
--	UTF-8 file
--

local pairs, tContains, tinsert, tonumber, wipe = pairs, tContains, tinsert, tonumber, wipe
local GetAchievementInfo, GetBuildInfo = GetAchievementInfo, GetBuildInfo

local Grail_Achievements_File_Version = 010

if Grail.achievementsVersionNumber < Grail_Achievements_File_Version then
	Grail.achievementsVersionNumber = Grail_Achievements_File_Version

local originalMem = gcinfo()
local debugStartTime = debugprofilestop()
local supportedFactions = {'Alliance', 'Horde'}

-- We use continents as separators and their mapIds as indexes
local mapKalimdor = 13
local mapEasternKingdoms = 14
local mapOutland = 466
local mapNorthrend = 485
local mapTheMaelstrom = 751
local mapPandaria = 862
local mapDraenor = 962
local mapBrokenIsles = 1007
local mapArgus = 1184
local mapZandalar = 0
local mapKulTiras = 0

if Grail.battleForAzeroth then
	mapKalimdor = 12
	mapEasternKingdoms = 13
	mapOutland = 101
	mapNorthrend = 113
	mapTheMaelstrom = 948
	mapPandaria = 424
	mapDraenor = 572
	mapBrokenIsles = 619
	mapArgus = 905
	mapZandalar = 875
	mapKulTiras = 876
end

--	These are the achievements organized by zone for completing the "loremaster" achievements (basically completing a specific number of quests in each zone).
Grail.loremasterAchievements = {
	['Alliance'] = {
		[mapKalimdor] = { 504925, 504926, 504928, 504930, 504929, 504931, 504932, 504934, 504937, 504936, 504935, 504938, 504939, 504940, 504870, 504872, },
		[mapEasternKingdoms] = { 504896, 504900, 504909, 504901, 504905, 504892, 504897, 504899, 504906, 504902, 504910, 504904, 504893, 504903, 504873, 504869, },
		[mapOutland] = { 501194, 501190, 501192, 501193, 501195, 501191, 501189, },
		[mapNorthrend] = { 500037, 500034, 500040, 500039, 500035, 500033, 500036, 500038, },
		[mapTheMaelstrom] = { 504871, },
		[mapPandaria] = { 506300, 506301, 506535, 506537, 506539, 506540, },
		},
	['Horde'] = {
		[mapKalimdor] = { 504976, 504927, 504930, 504978, 504931, 504979, 504933, 504934, 504981, 504980, 504935, 504938, 504939, 504940, 504870, 504872, },
		[mapEasternKingdoms] = { 504896, 504900, 504909, 504901, 504905, 504892, 504908, 504895, 504897, 504906, 504910, 504894, 504904, 504893, 505501, 504982, },
		[mapOutland] = { 501194, 501190, 501273, 501193, 501195, 501272, 501271, },
		[mapNorthrend] = { 501357, 501356, 500040, 500039, 501359, 501358, 500036, 500038, },
		[mapTheMaelstrom] = { 504871, },
		[mapPandaria] = { 506301, 506534, 506536, 506538, 506539, 506540, },
		},
	}

--	These are the achievements organized by zone for completing special sets of quests that are not "loremaster" but extra.
Grail.extraAchievements = {
	['Alliance'] = {
		[mapKalimdor] = { 505453, 504961, 505859, 505866, },
		[mapEasternKingdoms] = { 500940, 505318, 505320, 504960, 505452, },
		[mapOutland] = { 500939, },
		[mapNorthrend] = { 500561, 501596, 500961, 500962, 500938, 500547, },
		[mapTheMaelstrom] = { },
		[mapPandaria] = { 507296, 507297, 507312, 507314, 507315, 507310, 507612, },
		},
	['Horde'] = {
		[mapKalimdor] = { 504961, 505859, 505866, },
		[mapEasternKingdoms] = { 500940, 504960, 505452, 505319, 505321, },
		[mapOutland] = { 500939, },
		[mapNorthrend] = { 500561, 501596, 500961, 500962, 500938, 500547, },
		[mapTheMaelstrom] = { },
		[mapPandaria] = { 507296, 507297, 507312, 507314, 507315, 507310, 507612, },
		},
	}

--	Grail.achievements is a combination of Grail.loremasterAchievements and Grail.extraAchievements and will be created at the end

--	These are the achievements organized by world event.
Grail.worldEventAchievements = {
	['Alliance'] = {
		['A'] = { 501695, },
		['B'] = { 501186, },
		['F'] = { 506027, 506028, 506029, },
		['L'] = { 506006, 500912, 500911, 501396, 500915, 500910, 500914, },
		['M'] = { 501028, 501029, 506007, 501030, 506013, 506011, 501022, 501023, 506008, 501024, 501145, 508042, 508045, },
		['V'] = { 500279, },
		['W'] = { 501040, 500289, 500966, 500963, 505836, 500969, 505837, 507601, },
		['Y'] = { 503596, },
		},
	['Horde'] = {
		['A'] = { 501695, },
		['B'] = { 501186, },
		['F'] = { 506027, 506028, 506029, },
		['L'] = { 506006, 500912, 500911, 501396, 500915, 500910, 500914, },
		['M'] = { 501031, 501032, 506010, 501033, 506014, 506012, 501025, 501026, 506009, 501027, 501145, 508043, 508044, },
		['V'] = { 500279, },
		['W'] = { 501041, 500289, 500967, 500965, 505835, 500968, 505838, 507602, },
		['Y'] = { 503597, },
		},
	}

--	These are the achievements organized by profession.
Grail.professionAchievements = {
	['Alliance'] = {
		['C'] = { 500906, 505842, 505841, 505474, 501782, },
		['F'] = { 503217, 505848, 505847, 505476, 500905, },
		},
	['Horde'] = {
		['C'] = { 500906, 505475, 505843, 505844, 501783, },
		['F'] = { 503217, 505477, 505849, 505850, 500905, },
		},
	}

--	These are the achievements for pet battles.
Grail.petBattleAchievements = {
	['Alliance'] = { 506603, },
	['Horde'] = { },
	}

local G = {}

G[2]={63,504925,504976}
G[23]={63,504925,504976}
G[24]={63,504925,504976}
G[25]={63,504925,504976}
G[184]={52,504903}
G[185]={50,504906}
G[186]={50,504906}
G[187]={50,504906}
G[188]={50,504906}
G[190]={50,504906}
G[191]={50,504906}
G[192]={50,504906}
G[193]={50,504906}
G[194]={50,504906}
G[195]={50,504906}
G[196]={50,504906}
G[197]={50,504906}
G[208]={50,504906,500940}
G[216]={63,504925,504976}
G[309]={48,504899}
G[351]={71,504935}
G[485]={26,504897}
G[583]={50,504906}
G[648]={71,504935}
G[824]={63,504925,504976}
G[836]={26,504897}
G[844]={10,504933}
G[845]={10,504933}
G[848]={10,504933}
G[850]={10,504933}
G[851]={10,504933}
G[852]={10,504933}
G[855]={10,504933}
G[858]={10,504933}
G[863]={10,504933}
G[865]={10,504933}
G[867]={10,504933}
G[869]={10,504933}
G[870]={10,504933}
G[871]={10,504933}
G[872]={10,504933}
G[875]={10,504933}
G[876]={10,504933}
G[877]={10,504933}
G[880]={10,504933}
G[881]={10,504933}
G[887]={10,504933}
G[891]={10,504933}
G[895]={10,504933}
G[899]={10,504933}
G[903]={10,504933}
G[905]={10,504933}
G[1036]={50,504906}
G[1168]={70,504929,504978}
G[1201]={70,504929,504978}
G[1202]={70,504929,504978}
G[1204]={70,504929,504978}
G[1205]={70,504929,504978}
G[1222]={70,504929,504978}
G[1258]={70,504929,504978}
G[1270]={70,504929,504978}
G[1271]={70,504929,504978}
G[1918]={63,504925,504976}
G[2278]={504956}
G[3861]={52,504903}
G[4021]={10,504933}
G[4601]={504956}
G[4602]={504956}
G[4621]={50,504906}
G[5041]={10,504933}
G[5713]={62,504928}
G[6031]={77,504931}
G[6132]={66,504930}
G[6441]={63,504925,504976}
G[6442]={63,504925,504976}
G[6462]={63,504925,504976}
G[6482]={63,504925,504976}
G[6503]={63,504925,504976}
G[6544]={63,504925,504976}
G[6621]={63,504925,504976}
G[6641]={63,504925,504976}
G[6984]={500279}
G[7045]={500279}
G[7498]={504956}
G[7499]={504956}
G[7501]={504956}
G[7502]={504956}
G[7503]={504956}
G[7604]={504956}
G[7761]={504956}
G[7838]={50,504906}
G[7863]={63,504925}
G[7865]={63,504925}
G[8183]={504956}
G[8184]={504956}
G[8185]={504956}
G[8187]={504956}
G[8189]={504956}
G[8191]={504956}
G[8192]={504956}
G[8227]={504956}
G[8277]={81,504934}
G[8278]={81,504934}
G[8279]={81,504934}
G[8280]={81,504934}
G[8281]={81,504934}
G[8282]={81,504934}
G[8283]={81,504934}
G[8284]={81,504934}
G[8285]={81,504934}
G[8287]={81,504934}
G[8304]={81,504934}
G[8306]={81,504934}
G[8308]={81,504934}
G[8309]={81,504934}
G[8310]={81,504934}
G[8314]={81,504934}
G[8316]={81,504934}
G[8318]={81,504934}
G[8320]={81,504934}
G[8321]={81,504934}
G[8323]={81,504934}
G[8376]={81,504934}
G[8377]={81,504934}
G[8378]={81,504934}
G[8379]={81,504934}
G[8380]={81,504934}
G[8381]={81,504934}
G[8382]={81,504934}
G[8470]={77,504931}
G[8481]={83,504940}
G[8619]={500910}
G[8635]={500910}
G[8636]={500912}
G[8642]={500912}
G[8643]={500912}
G[8644]={500910}
G[8645]={500912}
G[8646]={500915}
G[8647]={500912}
G[8648]={500914}
G[8649]={500912}
G[8650]={500912}
G[8651]={500912}
G[8652]={500912}
G[8653]={500912}
G[8654]={500911}
G[8670]={500911}
G[8671]={500911}
G[8672]={500911}
G[8673]={500911}
G[8674]={500912}
G[8675]={500912}
G[8676]={500910}
G[8677]={500914}
G[8678]={500914}
G[8679]={500911}
G[8680]={500911}
G[8681]={500911}
G[8682]={500911}
G[8683]={500912}
G[8684]={500911}
G[8685]={500911}
G[8686]={500911}
G[8688]={500912}
G[8713]={500910}
G[8714]={500912}
G[8715]={500911}
G[8716]={500912}
G[8717]={500911}
G[8718]={500915}
G[8719]={500911}
G[8720]={500911}
G[8721]={500911}
G[8722]={500912}
G[8723]={500911}
G[8724]={500911}
G[8725]={500911}
G[8726]={500911}
G[8727]={500910}
G[8748]={71,504935}
G[8749]={71,504935}
G[8758]={71,504935}
G[8759]={71,504935}
G[8866]={500915}
G[9138]={95,504908}
G[9139]={95,504908}
G[9140]={95,504908}
G[9143]={95,504908}
G[9145]={95,504908}
G[9146]={95,504908}
G[9147]={95,504908}
G[9148]={95,504908}
G[9149]={95,504908}
G[9150]={95,504908}
G[9151]={95,504908}
G[9152]={95,504908}
G[9155]={95,504908}
G[9156]={95,504908}
G[9157]={95,504908}
G[9158]={95,504908}
G[9159]={95,504908}
G[9160]={95,504908}
G[9161]={95,504908}
G[9162]={95,504908}
G[9163]={95,504908}
G[9164]={95,504908}
G[9166]={95,504908}
G[9167]={95,504908}
G[9169]={95,504908}
G[9170]={95,504908}
G[9171]={95,504908}
G[9172]={95,504908}
G[9173]={95,504908}
G[9174]={95,504908}
G[9175]={95,504908}
G[9176]={95,504908}
G[9192]={95,504908}
G[9193]={95,504908}
G[9199]={95,504908}
G[9207]={95,504908}
G[9212]={95,504908}
G[9214]={95,504908}
G[9215]={95,504908}
G[9216]={95,504908}
G[9217]={95,504908}
G[9218]={95,504908}
G[9220]={95,504908}
G[9272]={50,504906}
G[9274]={95,504908}
G[9275]={95,504908}
G[9276]={95,504908}
G[9277]={95,504908}
G[9281]={95,504908}
G[9282]={95,504908}
G[9315]={95,504908}
G[9327]={95,504908}
G[9328]={95,504908}
G[9329]={95,504908}
G[9339]={501145}
G[9340]={100,501189,501271}
G[9345]={100,501189,501271}
G[9349]={100,501189,501271}
G[9351]={100,501189,501271}
G[9355]={100,501189,501271}
G[9356]={100,501189,501271}
G[9361]={100,501189,501271}
G[9365]={501145}
G[9366]={100,501189,501271}
G[9370]={100,501189,501271}
G[9372]={100,501189,501271}
G[9373]={100,501189,501271}
G[9374]={100,501189,501271}
G[9375]={100,501189,501271}
G[9376]={100,501189,501271}
G[9381]={100,501189,501271}
G[9383]={100,501189,501271}
G[9385]={100,501189,501271}
G[9387]={100,501189,501271}
G[9390]={100,501189,501271}
G[9391]={100,501189,501271}
G[9396]={100,501189,501271}
G[9397]={100,501189,501271}
G[9398]={100,501189,501271}
G[9399]={100,501189,501271}
G[9400]={100,501189,501271}
G[9401]={100,501189,501271}
G[9405]={100,501189,501271}
G[9406]={100,501189,501271}
G[9407]={100,501189,501271}
G[9410]={100,501189,501271}
G[9415]={81,504934}
G[9416]={81,504934}
G[9417]={100,501189,501271}
G[9418]={100,501189,501271}
G[9419]={81,504934}
G[9420]={100,501189,501271}
G[9422]={81,504934}
G[9423]={100,501189,501271}
G[9424]={100,501189,501271}
G[9426]={100,501189,501271}
G[9427]={100,501189,501271}
G[9430]={100,501189,501271}
G[9436]={50,504906}
G[9437]={70,504929,504978}
G[9442]={100,501189,501271}
G[9447]={100,501189,501271}
G[9457]={50,504906}
G[9466]={100,501189,501271}
G[9483]={100,501189,501271}
G[9490]={100,501189,501271}
G[9498]={100,501189,501271}
G[9499]={100,501189,501271}
G[9543]={100,501189,501271}
G[9545]={100,501189,501271}
G[9548]={106,504926}
G[9549]={106,504926}
G[9550]={106,504926}
G[9557]={106,504926}
G[9558]={100,501189,501271}
G[9561]={106,504926}
G[9563]={100,501189,501271}
G[9567]={106,504926}
G[9569]={106,504926}
G[9574]={106,504926}
G[9576]={106,504926}
G[9578]={106,504926}
G[9579]={106,504926}
G[9580]={106,504926}
G[9581]={106,504926}
G[9584]={106,504926}
G[9585]={106,504926}
G[9594]={106,504926}
G[9620]={106,504926}
G[9624]={106,504926}
G[9628]={106,504926}
G[9629]={106,504926}
G[9632]={106,504926}
G[9634]={106,504926}
G[9641]={106,504926}
G[9643]={106,504926}
G[9646]={106,504926}
G[9647]={106,504926}
G[9648]={106,504926}
G[9649]={106,504926}
G[9663]={106,504926}
G[9666]={106,504926}
G[9667]={106,504926}
G[9668]={106,504926}
G[9669]={106,504926}
G[9670]={106,504926}
G[9671]={106,504926}
G[9672]={106,504926}
G[9674]={106,504926}
G[9682]={106,504926}
G[9683]={106,504926}
G[9687]={106,504926}
G[9688]={106,504926}
G[9689]={106,504926}
G[9693]={106,504926}
G[9694]={106,504926}
G[9696]={106,504926}
G[9697]={102,501190}
G[9698]={106,504926}
G[9699]={106,504926}
G[9700]={106,504926}
G[9701]={102,501190}
G[9702]={102,501190}
G[9703]={106,504926}
G[9706]={106,504926}
G[9708]={102,501190}
G[9709]={102,501190}
G[9711]={106,504926}
G[9716]={102,501190}
G[9718]={102,501190}
G[9720]={102,501190}
G[9724]={102,501190}
G[9726]={102,501190}
G[9728]={102,501190}
G[9730]={102,501190}
G[9731]={102,501190}
G[9732]={102,501190}
G[9739]={102,501190}
G[9740]={106,504926}
G[9741]={106,504926}
G[9742]={102,501190}
G[9743]={102,501190}
G[9744]={102,501190}
G[9746]={106,504926}
G[9747]={102,501190}
G[9748]={106,504926}
G[9751]={106,504926}
G[9752]={102,501190}
G[9753]={106,504926}
G[9756]={106,504926}
G[9758]={95,504908}
G[9759]={106,504926}
G[9760]={106,504926}
G[9761]={106,504926}
G[9762]={106,504926}
G[9769]={102,501190}
G[9770]={102,501190}
G[9771]={102,501190}
G[9772]={102,501190}
G[9773]={102,501190}
G[9774]={102,501190}
G[9775]={102,501190}
G[9776]={102,501190}
G[9777]={102,501190}
G[9778]={102,501190}
G[9779]={106,504926}
G[9780]={102,501190}
G[9781]={102,501190}
G[9782]={102,501190}
G[9783]={102,501190}
G[9785]={102,501190}
G[9786]={102,501190}
G[9787]={102,501190}
G[9788]={102,501190}
G[9789]={107,501192,501273}
G[9790]={102,501190}
G[9791]={102,501190}
G[9792]={102,501190}
G[9793]={102,501190}
G[9794]={105,501193}
G[9795]={105,501193}
G[9796]={102,501190}
G[9797]={102,501190}
G[9800]={107,501192,501273}
G[9801]={102,501190}
G[9802]={102,501190}
G[9803]={102,501190}
G[9804]={107,501192,501273}
G[9805]={107,501192,501273}
G[9806]={102,501190}
G[9808]={102,501190}
G[9809]={102,501190}
G[9810]={107,501192,501273}
G[9811]={95,504908}
G[9814]={102,501190}
G[9815]={107,501192,501273}
G[9816]={102,501190}
G[9817]={102,501190}
G[9818]={107,501192,501273}
G[9819]={107,501192,501273}
G[9820]={102,501190}
G[9821]={107,501192,501273}
G[9822]={102,501190}
G[9823]={102,501190}
G[9827]={102,501190}
G[9828]={102,501190}
G[9830]={102,501190}
G[9833]={102,501190}
G[9834]={102,501190}
G[9835]={102,501190}
G[9839]={102,501190}
G[9841]={102,501190}
G[9842]={102,501190}
G[9845]={102,501190}
G[9846]={102,501190}
G[9847]={102,501190}
G[9848]={102,501190}
G[9849]={107,501192,501273}
G[9850]={107,501192,501273}
G[9851]={107,501192,501273}
G[9852]={107,501192,501273,500939}
G[9853]={107,501192,501273}
G[9854]={107,501192,501273}
G[9855]={107,501192,501273}
G[9856]={107,501192,501273}
G[9857]={107,501192,501273}
G[9858]={107,501192,501273}
G[9859]={107,501192,501273}
G[9861]={107,501192,501273}
G[9862]={107,501192,501273}
G[9863]={107,501192,501273}
G[9864]={107,501192,501273}
G[9865]={107,501192,501273}
G[9866]={107,501192,501273}
G[9867]={107,501192,501273}
G[9868]={107,501192,501273}
G[9869]={107,501192,501273}
G[9870]={107,501192,501273}
G[9871]={107,501192,501273}
G[9872]={107,501192,501273}
G[9873]={107,501192,501273}
G[9874]={107,501192,501273}
G[9877]={95,504908}
G[9878]={107,501192,501273}
G[9879]={107,501192,501273}
G[9882]={107,501192,501273}
G[9884]={107,501192,501273}
G[9886]={107,501192,501273}
G[9888]={108,501191,501272}
G[9889]={108,501191,501272}
G[9890]={108,501191,501272}
G[9891]={107,501192,501273}
G[9893]={107,501192,501273}
G[9894]={102,501190}
G[9895]={102,501190}
G[9896]={102,501190}
G[9897]={107,501192,501273}
G[9898]={102,501190}
G[9899]={102,501190}
G[9900]={107,501192,501273}
G[9901]={102,501190}
G[9902]={102,501190}
G[9903]={102,501190}
G[9904]={102,501190}
G[9905]={102,501190}
G[9906]={107,501192,501273}
G[9907]={107,501192,501273}
G[9910]={107,501192,501273}
G[9911]={102,501190}
G[9912]={102,501190}
G[9913]={107,501192,501273}
G[9914]={107,501192,501273}
G[9916]={107,501192,501273}
G[9917]={107,501192,501273}
G[9918]={107,501192,501273}
G[9919]={102,501190}
G[9920]={107,501192,501273}
G[9921]={107,501192,501273}
G[9922]={107,501192,501273}
G[9923]={107,501192,501273}
G[9924]={107,501192,501273}
G[9925]={107,501192,501273}
G[9927]={107,501192,501273}
G[9928]={107,501192,501273}
G[9931]={107,501192,501273}
G[9932]={107,501192,501273}
G[9933]={107,501192,501273}
G[9934]={107,501192,501273}
G[9935]={107,501192,501273}
G[9936]={107,501192,501273}
G[9937]={107,501192,501273}
G[9938]={107,501192,501273}
G[9939]={107,501192,501273}
G[9940]={107,501192,501273}
G[9944]={107,501192,501273}
G[9945]={107,501192,501273}
G[9946]={107,501192,501273}
G[9948]={107,501192,501273}
G[9951]={108,501191,501272}
G[9954]={107,501192,501273}
G[9955]={107,501192,501273}
G[9956]={107,501192,501273}
G[9957]={108,501191,501272}
G[9960]={108,501191,501272}
G[9961]={108,501191,501272}
G[9962]={107,501192,501273}
G[9967]={107,501192,501273}
G[9968]={108,501191,501272}
G[9970]={107,501192,501273}
G[9971]={108,501191,501272}
G[9972]={107,501192,501273}
G[9973]={107,501192,501273}
G[9977]={107,501192,501273}
G[9978]={108,501191,501272}
G[9982]={107,501192,501273}
G[9983]={107,501192,501273}
G[9986]={108,501191,501272}
G[9987]={108,501191,501272}
G[9990]={108,501191,501272}
G[9991]={107,501192,501273}
G[9992]={108,501191,501272}
G[9993]={108,501191,501272}
G[9994]={108,501191,501272}
G[9995]={108,501191,501272}
G[9996]={108,501191,501272}
G[9997]={108,501191,501272}
G[9998]={108,501191,501272}
G[9999]={107,501192,501273}
G[10000]={108,501191,501272}
G[10001]={107,501192,501273}
G[10002]={108,501191,501272}
G[10003]={108,501191,501272}
G[10004]={107,501192,501273}
G[10005]={108,501191,501272}
G[10006]={108,501191,501272}
G[10007]={108,501191,501272}
G[10008]={108,501191,501272}
G[10009]={108,501191,501272}
G[10010]={108,501191,501272}
G[10011]={107,501192,501273}
G[10012]={108,501191,501272}
G[10013]={108,501191,501272}
G[10016]={108,501191,501272}
G[10018]={108,501191,501272}
G[10022]={108,501191,501272}
G[10023]={108,501191,501272}
G[10026]={108,501191,501272}
G[10027]={108,501191,501272}
G[10028]={108,501191,501272}
G[10030]={108,501191,501272}
G[10031]={108,501191,501272}
G[10033]={108,501191,501272}
G[10034]={108,501191,501272}
G[10035]={108,501191,501272}
G[10036]={108,501191,501272}
G[10037]={108,501191,501272}
G[10038]={108,501191,501272}
G[10039]={108,501191,501272}
G[10040]={108,501191,501272}
G[10041]={108,501191,501272}
G[10042]={108,501191,501272}
G[10043]={108,501191,501272}
G[10044]={107,501192,501273}
G[10045]={107,501192,501273}
G[10047]={100,501189,501271}
G[10050]={100,501189,501271}
G[10051]={108,501191,501272}
G[10052]={108,501191,501272}
G[10055]={100,501189,501271}
G[10057]={100,501189,501271}
G[10058]={100,501189,501271}
G[10063]={106,504926}
G[10064]={106,504926}
G[10065]={106,504926}
G[10066]={106,504926}
G[10067]={106,504926}
G[10074]={107,501192,501273}
G[10076]={107,501192,501273}
G[10078]={100,501189,501271}
G[10079]={100,501189,501271}
G[10081]={107,501192,501273}
G[10082]={107,501192,501273}
G[10085]={107,501192,501273}
G[10086]={100,501189,501271}
G[10087]={100,501189,501271}
G[10093]={100,501189,501271}
G[10096]={102,501190}
G[10099]={100,501189,501271}
G[10101]={107,501192,501273}
G[10102]={107,501192,501273}
G[10103]={100,501189,501271}
G[10104]={102,501190}
G[10105]={102,501190}
G[10106]={100,501189,501271}
G[10107]={107,501192,501273}
G[10108]={107,501192,501273}
G[10109]={107,501192,501273}
G[10110]={100,501189,501271}
G[10111]={107,501192,501273}
G[10112]={108,501191,501272}
G[10113]={107,501192,501273}
G[10114]={107,501192,501273}
G[10115]={102,501190}
G[10116]={102,501190}
G[10117]={102,501190}
G[10118]={102,501190}
G[10119]={100,501189,501271}
G[10120]={100,501189,501271}
G[10121]={100,501189,501271}
G[10123]={100,501189,501271}
G[10124]={100,501189,501271}
G[10129]={100,501189,501271}
G[10132]={100,501189,501271}
G[10134]={100,501189,501271}
G[10136]={100,501189,501271}
G[10140]={100,501189,501271}
G[10141]={100,501189,501271}
G[10142]={100,501189,501271}
G[10143]={100,501189,501271}
G[10144]={100,501189,501271}
G[10146]={100,501189,501271}
G[10159]={100,501189,501271}
G[10160]={100,501189,501271}
G[10161]={100,501189,501271}
G[10162]={100,501189,501271}
G[10163]={100,501189,501271}
G[10167]={504956}
G[10170]={107,501192,501273}
G[10171]={107,501192,501273}
G[10172]={107,501192,501273}
G[10173]={109,501194}
G[10174]={109,501194}
G[10176]={109,501194}
G[10180]={108,501191,501272}
G[10182]={109,501194}
G[10183]={109,501194}
G[10184]={109,501194}
G[10185]={109,501194}
G[10186]={109,501194}
G[10188]={109,501194}
G[10189]={109,501194}
G[10190]={109,501194}
G[10191]={109,501194}
G[10192]={109,501194}
G[10193]={109,501194}
G[10194]={109,501194}
G[10197]={109,501194}
G[10198]={109,501194}
G[10199]={109,501194}
G[10200]={109,501194}
G[10201]={108,501191,501272}
G[10202]={109,501194}
G[10203]={109,501194}
G[10204]={109,501194}
G[10205]={109,501194}
G[10206]={109,501194}
G[10208]={100,501189,501271}
G[10209]={109,501194}
G[10210]={108,501191,501272}
G[10213]={100,501189,501271}
G[10216]={504956}
G[10220]={100,501189,501271}
G[10221]={109,501194}
G[10222]={109,501194}
G[10223]={109,501194}
G[10224]={109,501194}
G[10225]={109,501194}
G[10226]={109,501194}
G[10227]={108,501191,501272}
G[10229]={100,501189,501271}
G[10230]={100,501189,501271}
G[10232]={109,501194}
G[10233]={109,501194}
G[10234]={109,501194}
G[10235]={109,501194}
G[10236]={100,501189,501271}
G[10237]={109,501194}
G[10238]={100,501189,501271}
G[10239]={109,501194}
G[10240]={109,501194}
G[10241]={109,501194}
G[10242]={100,501189,501271}
G[10243]={109,501194}
G[10245]={109,501194}
G[10246]={109,501194}
G[10247]={109,501194}
G[10248]={109,501194}
G[10249]={109,501194}
G[10250]={100,501189,501271}
G[10252]={107,501192,501273}
G[10253]={504956}
G[10254]={100,501189,501271}
G[10255]={100,501189,501271}
G[10256]={109,501194}
G[10257]={109,501194}
G[10258]={100,501189,501271}
G[10261]={109,501194}
G[10262]={109,501194}
G[10263]={109,501194}
G[10264]={109,501194}
G[10265]={109,501194}
G[10266]={109,501194}
G[10267]={109,501194}
G[10268]={109,501194}
G[10269]={109,501194}
G[10270]={109,501194}
G[10271]={109,501194}
G[10272]={109,501194}
G[10273]={109,501194}
G[10274]={109,501194}
G[10275]={109,501194}
G[10276]={109,501194}
G[10278]={100,501189,501271}
G[10281]={109,501194}
G[10286]={100,501189,501271}
G[10287]={100,501189,501271}
G[10288]={100,501189,501271}
G[10289]={100,501189,501271}
G[10290]={109,501194}
G[10291]={100,501189,501271}
G[10293]={109,501194}
G[10294]={100,501189,501271}
G[10295]={100,501189,501271}
G[10299]={109,501194}
G[10300]={109,501194}
G[10301]={109,501194}
G[10305]={109,501194}
G[10306]={109,501194}
G[10307]={109,501194}
G[10309]={109,501194}
G[10310]={109,501194}
G[10311]={109,501194}
G[10312]={109,501194}
G[10313]={109,501194}
G[10314]={109,501194}
G[10315]={109,501194}
G[10316]={109,501194}
G[10317]={109,501194}
G[10318]={109,501194}
G[10319]={109,501194}
G[10320]={109,501194}
G[10321]={109,501194}
G[10322]={109,501194}
G[10323]={109,501194}
G[10328]={109,501194}
G[10329]={109,501194}
G[10330]={109,501194}
G[10331]={109,501194}
G[10332]={109,501194}
G[10333]={109,501194}
G[10334]={109,501194}
G[10335]={109,501194}
G[10336]={109,501194}
G[10337]={109,501194}
G[10338]={109,501194}
G[10339]={109,501194}
G[10340]={100,501189,501271}
G[10341]={109,501194}
G[10342]={109,501194}
G[10343]={109,501194}
G[10344]={100,501189,501271}
G[10345]={109,501194}
G[10346]={100,501189,501271}
G[10347]={100,501189,501271}
G[10348]={109,501194}
G[10349]={100,501189,501271}
G[10351]={100,501189,501271}
G[10353]={109,501194}
G[10355]={102,501190}
G[10365]={109,501194}
G[10367]={100,501189,501271}
G[10368]={100,501189,501271}
G[10369]={100,501189,501271}
G[10380]={109,501194}
G[10381]={109,501194}
G[10382]={100,501189,501271}
G[10384]={109,501194}
G[10385]={109,501194}
G[10388]={100,501189,501271}
G[10389]={100,501189,501271}
G[10390]={100,501189,501271}
G[10391]={100,501189,501271}
G[10392]={100,501189,501271}
G[10393]={100,501189,501271}
G[10394]={100,501189,501271}
G[10395]={100,501189,501271}
G[10396]={100,501189,501271}
G[10397]={100,501189,501271}
G[10399]={100,501189,501271}
G[10400]={100,501189,501271}
G[10403]={100,501189,501271}
G[10405]={109,501194}
G[10406]={109,501194}
G[10407]={109,501194}
G[10408]={109,501194}
G[10410]={109,501194}
G[10411]={109,501194}
G[10417]={109,501194}
G[10418]={109,501194}
G[10422]={109,501194}
G[10423]={109,501194}
G[10424]={109,501194}
G[10425]={109,501194}
G[10426]={109,501194}
G[10427]={109,501194}
G[10429]={109,501194}
G[10430]={109,501194}
G[10431]={109,501194}
G[10432]={109,501194}
G[10433]={109,501194}
G[10434]={109,501194}
G[10435]={109,501194}
G[10436]={109,501194}
G[10437]={109,501194}
G[10438]={109,501194}
G[10439]={109,501194}
G[10440]={109,501194}
G[10442]={100,501189,501271}
G[10443]={100,501189,501271}
G[10444]={108,501191,501272}
G[10446]={108,501191,501272}
G[10447]={108,501191,501272}
G[10448]={108,501191,501272}
G[10449]={100,501189,501271}
G[10450]={100,501189,501271}
G[10451]={104,501195}
G[10455]={105,501193}
G[10456]={105,501193}
G[10457]={105,501193}
G[10458]={104,501195}
G[10476]={107,501192,501273}
G[10479]={107,501192,501273}
G[10480]={104,501195}
G[10481]={104,501195}
G[10482]={100,501189,501271}
G[10483]={100,501189,501271}
G[10484]={100,501189,501271}
G[10485]={100,501189,501271}
G[10486]={105,501193}
G[10487]={105,501193}
G[10488]={105,501193}
G[10489]={105,501193}
G[10502]={105,501193}
G[10503]={105,501193}
G[10504]={105,501193}
G[10505]={105,501193}
G[10506]={105,501193}
G[10508]={109,501194}
G[10510]={105,501193}
G[10511]={105,501193}
G[10512]={105,501193}
G[10513]={104,501195}
G[10514]={104,501195}
G[10515]={104,501195}
G[10516]={105,501193}
G[10517]={105,501193}
G[10518]={105,501193}
G[10519]={104,501195}
G[10521]={104,501195}
G[10522]={104,501195}
G[10523]={104,501195}
G[10524]={105,501193}
G[10525]={105,501193}
G[10526]={105,501193}
G[10527]={104,501195}
G[10528]={104,501195}
G[10537]={104,501195}
G[10538]={100,501189,501271}
G[10540]={104,501195}
G[10541]={104,501195}
G[10542]={105,501193}
G[10543]={105,501193}
G[10544]={105,501193}
G[10545]={105,501193}
G[10546]={104,501195}
G[10547]={104,501195}
G[10550]={104,501195}
G[10555]={105,501193}
G[10556]={105,501193}
G[10557]={105,501193}
G[10562]={104,501195}
G[10563]={104,501195}
G[10564]={104,501195}
G[10565]={105,501193}
G[10566]={105,501193}
G[10567]={105,501193}
G[10568]={104,501195}
G[10569]={104,501195}
G[10570]={104,501195}
G[10571]={104,501195}
G[10572]={104,501195}
G[10573]={104,501195}
G[10574]={104,501195}
G[10575]={104,501195}
G[10576]={104,501195}
G[10577]={104,501195}
G[10578]={104,501195}
G[10579]={104,501195}
G[10580]={105,501193}
G[10581]={105,501193}
G[10582]={104,501195}
G[10583]={104,501195}
G[10584]={105,501193}
G[10585]={104,501195}
G[10586]={104,501195}
G[10587]={104,501195}
G[10588]={104,501195}
G[10589]={104,501195}
G[10594]={105,501193}
G[10595]={104,501195}
G[10596]={104,501195}
G[10597]={104,501195}
G[10598]={104,501195}
G[10599]={104,501195}
G[10600]={104,501195}
G[10601]={104,501195}
G[10602]={104,501195}
G[10603]={104,501195}
G[10604]={104,501195}
G[10606]={104,501195}
G[10607]={105,501193}
G[10608]={105,501193}
G[10609]={105,501193}
G[10611]={104,501195}
G[10612]={104,501195}
G[10613]={104,501195}
G[10614]={105,501193}
G[10615]={105,501193}
G[10617]={105,501193}
G[10618]={105,501193}
G[10619]={104,501195}
G[10620]={105,501193}
G[10621]={104,501195}
G[10622]={104,501195}
G[10623]={104,501195}
G[10624]={104,501195}
G[10625]={104,501195}
G[10626]={104,501195}
G[10627]={104,501195}
G[10628]={104,501195}
G[10629]={100,501189,501271}
G[10630]={100,501189,501271}
G[10632]={105,501193}
G[10633]={104,501195}
G[10634]={104,501195}
G[10635]={104,501195}
G[10636]={104,501195}
G[10637]={104,501195}
G[10639]={104,501195}
G[10640]={107,501192,501273}
G[10641]={107,501192,501273}
G[10642]={104,501195}
G[10643]={104,501195}
G[10644]={104,501195}
G[10645]={104,501195}
G[10646]={107,501192,501273}
G[10647]={104,501195}
G[10648]={104,501195}
G[10652]={109,501194}
G[10657]={105,501193}
G[10660]={104,501195}
G[10661]={104,501195}
G[10662]={104,501195}
G[10663]={104,501195}
G[10664]={104,501195}
G[10668]={107,501192,501273}
G[10669]={107,501192,501273}
G[10671]={105,501193}
G[10672]={104,501195}
G[10673]={104,501195}
G[10674]={105,501193}
G[10675]={105,501193}
G[10677]={104,501195}
G[10678]={104,501195}
G[10680]={104,501195}
G[10681]={104,501195}
G[10682]={105,501193}
G[10683]={104,501195}
G[10684]={104,501195}
G[10685]={104,501195}
G[10686]={104,501195}
G[10687]={104,501195}
G[10688]={104,501195}
G[10689]={107,501192,501273}
G[10690]={105,501193}
G[10692]={104,501195}
G[10701]={109,501194}
G[10702]={104,501195}
G[10703]={104,501195}
G[10705]={504956}
G[10709]={105,501193}
G[10710]={105,501193}
G[10711]={105,501193}
G[10712]={105,501193}
G[10713]={105,501193}
G[10714]={105,501193}
G[10715]={105,501193}
G[10717]={105,501193}
G[10718]={105,501193}
G[10719]={105,501193}
G[10720]={105,501193}
G[10721]={105,501193}
G[10722]={105,501193}
G[10723]={105,501193}
G[10724]={105,501193}
G[10742]={105,501193}
G[10744]={104,501195}
G[10745]={104,501195}
G[10747]={105,501193}
G[10748]={105,501193}
G[10749]={105,501193}
G[10750]={104,501195}
G[10751]={104,501195}
G[10753]={105,501193}
G[10759]={104,501195}
G[10760]={104,501195}
G[10761]={104,501195}
G[10765]={104,501195}
G[10766]={104,501195}
G[10767]={104,501195}
G[10768]={104,501195}
G[10769]={104,501195}
G[10770]={105,501193}
G[10771]={105,501193}
G[10772]={104,501195}
G[10773]={104,501195}
G[10774]={104,501195}
G[10775]={104,501195}
G[10776]={104,501195}
G[10777]={104,501195}
G[10778]={104,501195}
G[10780]={104,501195}
G[10781]={104,501195}
G[10782]={104,501195}
G[10783]={105,501193}
G[10784]={105,501193}
G[10785]={105,501193}
G[10786]={105,501193}
G[10791]={108,501191,501272}
G[10792]={100,501189,501271}
G[10793]={104,501195}
G[10795]={105,501193}
G[10796]={105,501193}
G[10797]={105,501193}
G[10798]={105,501193}
G[10799]={105,501193}
G[10800]={105,501193}
G[10801]={105,501193}
G[10802]={105,501193}
G[10803]={105,501193}
G[10804]={104,501195}
G[10805]={105,501193}
G[10806]={105,501193}
G[10807]={104,501195}
G[10808]={104,501195}
G[10809]={100,501189,501271}
G[10810]={105,501193}
G[10811]={104,501195}
G[10812]={105,501193}
G[10813]={100,501189,501271}
G[10814]={104,501195}
G[10816]={104,501195}
G[10817]={104,501195}
G[10818]={105,501193}
G[10819]={105,501193}
G[10820]={105,501193}
G[10821]={105,501193}
G[10824]={104,501195}
G[10825]={105,501193}
G[10826]={104,501195}
G[10829]={105,501193}
G[10830]={105,501193}
G[10834]={100,501189,501271}
G[10835]={100,501189,501271}
G[10836]={104,501195}
G[10837]={104,501195}
G[10838]={100,501189,501271}
G[10839]={108,501191,501272}
G[10840]={108,501191,501272}
G[10842]={108,501191,501272}
G[10843]={105,501193}
G[10845]={105,501193}
G[10846]={105,501193}
G[10847]={108,501191,501272}
G[10848]={108,501191,501272}
G[10849]={108,501191,501272}
G[10850]={109,501194}
G[10851]={105,501193}
G[10852]={108,501191,501272}
G[10853]={105,501193}
G[10854]={104,501195}
G[10855]={109,501194}
G[10856]={109,501194}
G[10857]={109,501194}
G[10858]={104,501195}
G[10859]={105,501193}
G[10860]={105,501193}
G[10861]={108,501191,501272}
G[10862]={108,501191,501272}
G[10863]={108,501191,501272}
G[10864]={100,501189,501271}
G[10865]={105,501193}
G[10866]={104,501195}
G[10867]={105,501193}
G[10868]={108,501191,501272}
G[10869]={108,501191,501272}
G[10870]={104,501195}
G[10871]={104,501195}
G[10872]={104,501195}
G[10873]={108,501191,501272}
G[10874]={108,501191,501272}
G[10875]={100,501189,501271}
G[10876]={100,501189,501271}
G[10877]={108,501191,501272}
G[10878]={108,501191,501272}
G[10879]={108,501191,501272}
G[10880]={108,501191,501272}
G[10881]={108,501191,501272}
G[10887]={108,501191,501272}
G[10889]={108,501191,501272}
G[10893]={105,501193}
G[10894]={105,501193}
G[10895]={100,501189,501271}
G[10896]={108,501191,501272}
G[10898]={108,501191,501272}
G[10900]={504956}
G[10903]={100,501189,501271}
G[10904]={105,501193}
G[10908]={108,501191,501272}
G[10909]={100,501189,501271}
G[10910]={105,501193}
G[10911]={105,501193}
G[10912]={105,501193}
G[10913]={108,501191,501272}
G[10914]={108,501191,501272}
G[10915]={108,501191,501272}
G[10916]={100,501189,501271}
G[10917]={108,501191,501272}
G[10919]={100,501189,501271}
G[10920]={108,501191,501272}
G[10921]={108,501191,501272}
G[10922]={108,501191,501272}
G[10923]={108,501191,501272}
G[10924]={109,501194}
G[10926]={108,501191,501272}
G[10927]={105,501193}
G[10928]={105,501193}
G[10929]={108,501191,501272}
G[10930]={108,501191,501272}
G[10935]={100,501189,501271}
G[10936]={100,501189,501271}
G[10937]={100,501189,501271}
G[10969]={109,501194}
G[10970]={109,501194}
G[10971]={109,501194}
G[10983]={105,501193}
G[10989]={105,501193}
G[10995]={105,501193}
G[10996]={105,501193}
G[10997]={105,501193}
G[11000]={105,501193}
G[11002]={100,501189,501271}
G[11003]={100,501189,501271}
G[11009]={105,501193}
G[11010]={105,501193}
G[11012]={104,501195}
G[11013]={104,501195}
G[11014]={104,501195}
G[11019]={104,501195}
G[11022]={105,501193}
G[11025]={105,501193}
G[11030]={105,501193}
G[11036]={105,501193}
G[11037]={107,501192,501273}
G[11040]={105,501193}
G[11042]={107,501192,501273}
G[11043]={105,501193}
G[11044]={107,501192,501273}
G[11047]={105,501193}
G[11048]={107,501192,501273}
G[11057]={105,501193}
G[11058]={105,501193}
G[11059]={105,501193}
G[11061]={105,501193}
G[11062]={105,501193}
G[11063]={104,501195}
G[11064]={104,501195}
G[11065]={105,501193}
G[11067]={104,501195}
G[11068]={104,501195}
G[11069]={104,501195}
G[11070]={104,501195}
G[11075]={104,501195}
G[11079]={105,501193}
G[11091]={105,501193}
G[11095]={104,501195}
G[11102]={105,501193}
G[11108]={104,501195}
G[11119]={105,501193}
G[11131]={500289}
--G[11132]={504956}
G[11153]={117,500034,501356}
G[11154]={117,500034,501356}
G[11155]={117,500034,501356}
G[11157]={117,500034,501356}
G[11167]={117,500034,501356}
G[11168]={117,500034,501356}
G[11170]={117,500034,501356}
G[11175]={117,500034,501356}
G[11176]={117,500034,501356}
--G[11178]={504956}
G[11182]={117,500034,501356}
G[11187]={117,500034,501356}
G[11188]={117,500034,501356}
G[11190]={117,500034,501356}
G[11199]={117,500034,501356}
G[11202]={117,500034,501356}
G[11208]={70,504929,504978}
G[11211]={70,504929,504978}
G[11212]={70,504929,504978}
G[11213]={70,504929,504978}
G[11215]={70,504929,504978}
G[11218]={117,500034,501356}
G[11219]={500289}
G[11221]={117,500034,501356}
G[11224]={117,500034,501356}
G[11227]={117,500034,501356}
G[11228]={117,500034,501356}
G[11229]={117,500034,501356}
G[11230]={117,500034,501356}
G[11231]={117,500034,501356}
G[11232]={117,500034,501356}
G[11233]={117,500034,501356}
G[11234]={117,500034,501356}
G[11235]={117,500034,501356}
G[11236]={117,500034,501356}
G[11237]={117,500034,501356}
G[11238]={117,500034,501356}
G[11239]={117,500034,501356}
G[11240]={117,500034,501356}
G[11241]={117,500034,501356}
G[11243]={117,500034,501356}
G[11244]={117,500034,501356}
G[11245]={117,500034,501356}
G[11246]={117,500034,501356}
G[11247]={117,500034,501356}
G[11248]={117,500034,501356}
G[11249]={117,500034,501356}
G[11250]={117,500034,501356}
G[11251]={117,500034,501356}
G[11252]={504956}
G[11253]={117,500034,501356}
G[11254]={117,500034,501356}
G[11255]={117,500034,501356}
G[11256]={117,500034,501356}
G[11257]={117,500034,501356}
G[11258]={117,500034,501356}
G[11259]={117,500034,501356}
G[11260]={117,500034,501356}
G[11261]={117,500034,501356}
G[11263]={117,500034,501356}
G[11264]={117,500034,501356}
G[11265]={117,500034,501356}
G[11266]={117,500034,501356}
G[11267]={117,500034,501356}
G[11268]={117,500034,501356}
G[11269]={117,500034,501356}
G[11270]={117,500034,501356}
G[11271]={117,500034,501356}
G[11272]={504956}
G[11273]={117,500034,501356}
G[11274]={117,500034,501356}
G[11275]={117,500034,501356}
G[11276]={117,500034,501356}
G[11277]={117,500034,501356}
G[11278]={117,500034,501356}
G[11279]={117,500034,501356}
G[11280]={117,500034,501356}
G[11281]={117,500034,501356}
G[11282]={117,500034,501356}
G[11283]={117,500034,501356}
G[11284]={117,500034,501356}
G[11285]={117,500034,501356}
G[11286]={117,500034,501356}
G[11287]={117,500034,501356}
G[11288]={117,500034,501356}
G[11289]={117,500034,501356}
G[11290]={117,500034,501356}
G[11291]={117,500034,501356}
G[11292]={117,500034,501356}
G[11295]={117,500034,501356}
G[11296]={117,500034,501356}
G[11297]={117,500034,501356}
G[11298]={117,500034,501356}
G[11299]={117,500034,501356}
G[11300]={117,500034,501356}
G[11301]={117,500034,501356}
G[11302]={117,500034,501356}
G[11303]={117,500034,501356}
G[11304]={117,500034,501356}
G[11305]={117,500034,501356}
G[11306]={117,500034,501356}
G[11307]={117,500034,501356}
G[11308]={117,500034,501356}
G[11309]={117,500034,501356}
G[11310]={117,500034,501356}
G[11311]={117,500034,501356}
G[11312]={117,500034,501356}
G[11313]={117,500034,501356}
G[11314]={117,500034,501356}
G[11315]={117,500034,501356}
G[11316]={117,500034,501356}
G[11317]={117,500034,501356}
G[11319]={117,500034,501356}
G[11322]={117,500034,501356}
G[11323]={117,500034,501356}
G[11324]={117,500034,501356}
G[11325]={117,500034,501356}
G[11326]={117,500034,501356}
G[11327]={117,500034,501356}
G[11328]={117,500034,501356}
G[11329]={117,500034,501356}
G[11330]={117,500034,501356}
G[11331]={117,500034,501356}
G[11332]={117,500034,501356}
G[11333]={117,500034,501356}
G[11343]={117,500034,501356}
G[11344]={117,500034,501356}
G[11346]={117,500034,501356}
G[11348]={117,500034,501356}
G[11349]={117,500034,501356}
G[11350]={117,500034,501356}
G[11351]={117,500034,501356}
G[11352]={117,500034,501356}
G[11355]={117,500034,501356}
G[11358]={117,500034,501356}
G[11359]={117,500034,501356}
G[11365]={117,500034,501356}
G[11366]={117,500034,501356}
G[11367]={117,500034,501356}
G[11377]={500906}
G[11379]={500906}
G[11380]={500906}
G[11381]={500906}
G[11390]={117,500034,501356}
G[11391]={117,500034,501356}
G[11393]={117,500034,501356}
G[11394]={117,500034,501356}
G[11395]={117,500034,501356}
G[11396]={117,500034,501356}
G[11397]={117,500034,501356}
G[11398]={117,500034,501356}
G[11399]={117,500034,501356}
G[11406]={117,500034,501356}
G[11410]={117,500034,501356}
G[11411]={117,500034,501356}
G[11414]={117,500034,501356}
G[11415]={117,500034,501356}
G[11416]={117,500034,501356}
G[11417]={117,500034,501356}
G[11418]={117,500034,501356}
G[11420]={117,500034,501356}
G[11421]={117,500034,501356}
G[11422]={117,500034,501356}
G[11423]={117,500034,501356}
G[11424]={117,500034,501356}
G[11426]={117,500034,501356}
G[11427]={117,500034,501356}
G[11428]={117,500034,501356}
G[11429]={117,500034,501356}
G[11430]={117,500034,501356}
G[11432]={117,500034,501356}
G[11433]={117,500034,501356}
G[11434]={117,500034,501356}
G[11436]={117,500034,501356}
G[11443]={117,500034,501356}
G[11448]={117,500034,501356}
G[11452]={117,500034,501356}
G[11453]={117,500034,501356}
G[11455]={117,500034,501356}
G[11456]={117,500034,501356}
G[11457]={117,500034,501356}
G[11458]={117,500034,501356}
G[11459]={117,500034,501356}
G[11460]={117,500034,501356}
G[11464]={117,500034,501356}
G[11465]={117,500034,501356}
G[11466]={117,500034,501356}
G[11467]={117,500034,501356}
G[11468]={117,500034,501356}
G[11469]={117,500034,501356}
G[11470]={117,500034,501356}
G[11471]={117,500034,501356}
G[11473]={117,500034,501356}
G[11474]={117,500034,501356}
G[11475]={117,500034,501356}
G[11476]={117,500034,501356}
G[11477]={117,500034,501356}
G[11478]={117,500034,501356}
G[11479]={117,500034,501356}
G[11480]={117,500034,501356}
G[11483]={117,500034,501356}
G[11484]={117,500034,501356}
G[11485]={117,500034,501356}
G[11489]={117,500034,501356}
G[11491]={117,500034,501356}
G[11494]={117,500034,501356}
G[11495]={117,500034,501356}
G[11501]={117,500034,501356}
G[11502]={107,501192,501273}
G[11504]={117,500034,501356}
G[11505]={108,501191,501272}
G[11506]={108,501191,501272}
G[11507]={117,500034,501356}
G[11508]={117,500034,501356}
G[11509]={117,500034,501356}
G[11510]={117,500034,501356}
G[11511]={117,500034,501356}
G[11512]={117,500034,501356}
G[11519]={117,500034,501356}
G[11527]={117,500034,501356}
G[11529]={117,500034,501356}
G[11530]={117,500034,501356}
G[11559]={114,500033,501358}
G[11560]={114,500033,501358}
G[11561]={114,500033,501358}
G[11562]={114,500033,501358}
G[11563]={114,500033,501358}
G[11564]={114,500033,501358}
G[11565]={114,500033,501358}
G[11566]={114,500033,501358}
G[11567]={117,500034,501356}
G[11568]={117,500034,501356}
G[11569]={114,500033,501358}
G[11570]={114,500033,501358}
G[11571]={114,500033,501358}
G[11572]={117,500034,501356}
G[11573]={117,500034,501356}
G[11574]={114,500033,501358}
G[11575]={114,500033,501358}
G[11576]={114,500033,501358}
G[11580]={501028}
G[11581]={501031}
G[11582]={114,500033,501358}
G[11583]={501022}
G[11584]={501025}
G[11585]={114,500033,501358}
G[11586]={114,500033,501358}
G[11587]={114,500033,501358}
G[11590]={114,500033,501358}
G[11591]={114,500033,501358}
G[11592]={114,500033,501358}
G[11593]={114,500033,501358}
G[11594]={114,500033,501358}
G[11595]={114,500033,501358}
G[11596]={114,500033,501358}
G[11598]={114,500033,501358}
G[11599]={114,500033,501358}
G[11600]={114,500033,501358}
G[11601]={114,500033,501358}
G[11602]={114,500033,501358}
G[11603]={114,500033,501358}
G[11604]={114,500033,501358}
G[11605]={114,500033,501358}
G[11606]={114,500033,501358}
G[11607]={114,500033,501358}
G[11608]={114,500033,501358}
G[11609]={114,500033,501358}
G[11610]={114,500033,501358}
G[11611]={114,500033,501358}
G[11612]={114,500033,501358}
G[11613]={114,500033,501358}
G[11614]={114,500033,501358}
G[11615]={114,500033,501358}
G[11616]={114,500033,501358}
G[11617]={114,500033,501358}
G[11618]={114,500033,501358}
G[11619]={114,500033,501358}
G[11620]={114,500033,501358}
G[11623]={114,500033,501358}
G[11624]={114,500033,501358}
G[11625]={114,500033,501358}
G[11626]={114,500033,501358}
G[11627]={114,500033,501358}
G[11628]={114,500033,501358}
G[11629]={114,500033,501358}
G[11630]={114,500033,501358}
G[11631]={114,500033,501358}
G[11632]={114,500033,501358}
G[11633]={114,500033,501358}
G[11634]={114,500033,501358}
G[11635]={114,500033,501358}
G[11636]={114,500033,501358}
G[11637]={114,500033,501358}
G[11638]={114,500033,501358}
G[11639]={114,500033,501358}
G[11640]={114,500033,501358}
G[11641]={114,500033,501358}
G[11642]={114,500033,501358}
G[11643]={114,500033,501358}
G[11644]={114,500033,501358}
G[11645]={114,500033,501358}
G[11646]={114,500033,501358}
G[11647]={114,500033,501358}
G[11648]={114,500033,501358}
G[11649]={114,500033,501358}
G[11650]={114,500033,501358}
G[11651]={114,500033,501358}
G[11652]={114,500033,501358}
G[11653]={114,500033,501358}
G[11654]={114,500033,501358}
G[11655]={114,500033,501358}
G[11656]={114,500033,501358}
G[11658]={114,500033,501358}
G[11659]={114,500033,501358}
G[11660]={114,500033,501358}
G[11661]={114,500033,501358}
G[11662]={114,500033,501358}
G[11663]={114,500033,501358}
G[11664]={114,500033,501358}
G[11665]={500905}
G[11666]={500905}
G[11667]={500905}
G[11668]={500905}
G[11669]={500905}
G[11670]={114,500033,501358}
G[11671]={114,500033,501358}
G[11672]={114,500033,501358}
G[11673]={114,500033,501358}
G[11674]={114,500033,501358}
G[11675]={114,500033,501358}
G[11676]={114,500033,501358}
G[11677]={114,500033,501358}
G[11678]={114,500033,501358}
G[11679]={114,500033,501358}
G[11680]={114,500033,501358}
G[11681]={114,500033,501358}
G[11682]={114,500033,501358}
G[11683]={114,500033,501358}
G[11684]={114,500033,501358}
G[11685]={114,500033,501358}
G[11686]={114,500033,501358}
G[11687]={114,500033,501358}
G[11688]={114,500033,501358}
G[11689]={114,500033,501358}
G[11690]={114,500033,501358}
G[11692]={114,500033,501358}
G[11693]={114,500033,501358}
G[11694]={114,500033,501358}
G[11695]={114,500033,501358}
G[11697]={114,500033,501358}
G[11698]={114,500033,501358}
G[11699]={114,500033,501358}
G[11700]={114,500033,501358}
G[11701]={114,500033,501358}
G[11702]={114,500033,501358}
G[11703]={114,500033,501358}
G[11704]={114,500033,501358}
G[11705]={114,500033,501358}
G[11706]={114,500033,501358}
G[11707]={114,500033,501358}
G[11708]={114,500033,501358}
G[11709]={114,500033,501358}
G[11710]={114,500033,501358}
G[11711]={114,500033,501358}
G[11712]={114,500033,501358}
G[11713]={114,500033,501358}
G[11714]={114,500033,501358}
G[11715]={114,500033,501358}
G[11716]={114,500033,501358}
G[11717]={114,500033,501358}
G[11718]={114,500033,501358}
G[11719]={114,500033,501358}
G[11720]={114,500033,501358}
G[11721]={114,500033,501358}
G[11722]={114,500033,501358}
G[11723]={114,500033,501358}
G[11724]={114,500033,501358}
G[11725]={114,500033,501358}
G[11726]={114,500033,501358}
G[11727]={114,500033,501358}
G[11728]={114,500033,501358}
G[11729]={114,500033,501358}
G[11730]={114,500033,501358}
G[11732]={501031}
G[11733]={114,500033,501358}
G[11734]={501032}
G[11735]={501032}
G[11736]={501033}
G[11737]={501031}
G[11738]={501032}
G[11739]={501031}
G[11740]={501032}
G[11741]={501032}
G[11742]={501031}
G[11743]={501031}
G[11744]={501032}
G[11745]={501031}
G[11746]={501032}
G[11747]={501033}
G[11749]={501031}
G[11750]={501033}
G[11751]={501031}
G[11752]={501033}
G[11753]={501032}
G[11754]={501033}
G[11755]={501031}
G[11756]={501031}
G[11757]={501031}
G[11758]={501033}
G[11759]={501033}
G[11760]={501032}
G[11761]={501031}
G[11762]={501032}
G[11763]={501032}
G[11764]={501028}
G[11765]={501029}
G[11766]={501028}
G[11767]={501030}
G[11768]={501028}
G[11769]={501029}
G[11770]={501029}
G[11771]={501029}
G[11772]={501028}
G[11773]={501029}
G[11774]={501028}
G[11775]={501030}
G[11776]={501028}
G[11777]={501029}
G[11778]={501030}
G[11779]={501030}
G[11780]={501029}
G[11781]={501028}
G[11782]={501030}
G[11783]={501029}
G[11784]={501028}
G[11786]={501028}
G[11787]={501030}
G[11788]={114,500033,501358}
G[11789]={114,500033,501358}
G[11790]={114,500033,501358}
G[11791]={114,500033,501358}
G[11792]={114,500033,501358}
G[11793]={114,500033,501358}
G[11794]={114,500033,501358}
G[11795]={114,500033,501358}
G[11796]={114,500033,501358}
G[11797]={114,500033,501358}
G[11798]={114,500033,501358}
G[11799]={501030}
G[11800]={501029}
G[11801]={501028}
G[11802]={501029}
G[11803]={501029}
G[11804]={501022}
G[11805]={501023}
G[11806]={501023}
G[11807]={501024}
G[11808]={501022}
G[11809]={501023}
G[11810]={501022}
G[11811]={501023}
G[11812]={501023}
G[11813]={501022}
G[11814]={501022}
G[11815]={501023}
G[11816]={501022}
G[11817]={501023}
G[11818]={501024}
G[11820]={501022}
G[11821]={501024}
G[11822]={501022}
G[11823]={501024}
G[11824]={501023}
G[11825]={501024}
G[11826]={501022}
G[11827]={501022}
G[11828]={501022}
G[11829]={501024}
G[11830]={501024}
G[11831]={501023}
G[11832]={501022}
G[11833]={501023}
G[11834]={501023}
G[11835]={501027}
G[11836]={501026}
G[11837]={501025}
G[11838]={501026}
G[11839]={501026}
G[11840]={501025}
G[11841]={501026}
G[11842]={501025}
G[11843]={501027}
G[11844]={501025}
G[11845]={501026}
G[11846]={501026}
G[11847]={501026}
G[11848]={501025}
G[11849]={501026}
G[11850]={501025}
G[11851]={501027}
G[11852]={501026}
G[11853]={501025}
G[11854]={501027}
G[11855]={501027}
G[11856]={501026}
G[11857]={501025}
G[11858]={501027}
G[11859]={501026}
G[11860]={501025}
G[11862]={501025}
G[11863]={501027}
G[11864]={114,500033,501358}
G[11865]={114,500033,501358}
G[11866]={114,500033,501358}
G[11868]={114,500033,501358}
G[11869]={114,500033,501358}
G[11870]={114,500033,501358}
G[11871]={114,500033,501358}
G[11872]={114,500033,501358}
G[11873]={114,500033,501358}
G[11876]={114,500033,501358}
G[11878]={114,500033,501358}
G[11879]={114,500033,501358}
G[11881]={114,500033,501358}
G[11884]={114,500033,501358}
G[11887]={114,500033,501358}
G[11888]={114,500033,501358}
G[11889]={114,500033,501358}
G[11890]={114,500033,501358}
G[11892]={114,500033,501358,500561}
G[11893]={114,500033,501358}
G[11894]={114,500033,501358}
G[11895]={114,500033,501358}
G[11896]={114,500033,501358}
G[11897]={114,500033,501358}
G[11898]={114,500033,501358}
G[11899]={114,500033,501358}
G[11900]={114,500033,501358}
G[11901]={114,500033,501358}
G[11902]={114,500033,501358}
G[11903]={114,500033,501358}
G[11904]={114,500033,501358}
G[11906]={114,500033,501358}
G[11907]={114,500033,501358}
G[11908]={114,500033,501358}
G[11909]={114,500033,501358}
G[11910]={114,500033,501358}
G[11912]={114,500033,501358}
G[11913]={114,500033,501358}
G[11914]={114,500033,501358}
G[11916]={114,500033,501358}
G[11918]={114,500033,501358}
G[11919]={114,500033,501358}
G[11920]={114,500033,501358}
G[11927]={114,500033,501358}
G[11928]={114,500033,501358}
G[11929]={114,500033,501358}
G[11930]={114,500033,501358}
G[11931]={114,500033,501358}
G[11932]={114,500033,501358}
G[11936]={114,500033,501358}
G[11938]={114,500033,501358}
G[11940]={114,500033,501358}
G[11941]={114,500033,501358}
G[11942]={114,500033,501358}
G[11943]={114,500033,501358}
G[11944]={114,500033,501358}
G[11946]={114,500033,501358}
G[11949]={114,500033,501358}
G[11950]={114,500033,501358}
G[11951]={114,500033,501358}
G[11956]={114,500033,501358}
G[11957]={114,500033,501358}
G[11959]={115,500035,501359}
G[11961]={114,500033,501358}
G[11962]={114,500033,501358}
G[11963]={114,500033,501358}
G[11965]={114,500033,501358}
G[11967]={114,500033,501358}
G[11968]={114,500033,501358}
G[11969]={114,500033,501358}
G[11977]={115,500035,501359}
G[11978]={115,500035,501359}
G[11979]={115,500035,501359}
G[11980]={115,500035,501359}
G[11981]={116,500037,501357}
G[11982]={116,500037,501357}
G[11983]={115,500035,501359}
G[11984]={116,500037,501357}
G[11985]={116,500037,501357}
G[11986]={116,500037,501357}
G[11988]={116,500037,501357}
G[11989]={116,500037,501357}
G[11990]={116,500037,501357}
G[11991]={116,500037,501357}
G[11993]={116,500037,501357}
G[11995]={115,500035,501359}
G[11996]={115,500035,501359}
G[11998]={116,500037,501357}
G[11999]={115,500035,501359}
G[12000]={115,500035,501359}
G[12002]={116,500037,501357}
G[12003]={116,500037,501357}
G[12004]={115,500035,501359}
G[12005]={115,500035,501359}
G[12006]={115,500035,501359}
G[12007]={116,500037,501357}
G[12008]={115,500035,501359}
G[12009]={115,500035,501359}
G[12010]={116,500037,501357}
G[12011]={115,500035,501359}
G[12013]={115,500035,501359}
G[12014]={116,500037,501357}
G[12016]={115,500035,501359}
G[12017]={115,500035,501359}
G[12019]={114,500033,501358}
G[12020]={501186}
G[12026]={116,500037,501357}
G[12027]={116,500037,501357}
G[12028]={115,500035,501359}
G[12029]={116,500037,501357}
G[12030]={115,500035,501359}
G[12031]={115,500035,501359}
G[12032]={115,500035,501359}
G[12033]={115,500035,501359}
G[12034]={115,500035,501359}
G[12035]={114,500033,501358}
G[12036]={115,500035,501359}
G[12037]={504956}
G[12038]={116,500037,501357}
G[12039]={115,500035,501359}
G[12040]={115,500035,501359}
G[12041]={115,500035,501359}
G[12042]={116,500037,501357}
G[12043]={115,500035,501359}
G[12044]={115,500035,501359}
G[12045]={115,500035,501359}
G[12046]={115,500035,501359}
G[12047]={115,500035,501359}
G[12048]={115,500035,501359}
G[12049]={115,500035,501359}
G[12050]={115,500035,501359}
G[12052]={115,500035,501359}
G[12053]={115,500035,501359}
G[12054]={116,500037,501357}
G[12055]={115,500035,501359}
G[12056]={115,500035,501359}
G[12057]={115,500035,501359}
G[12058]={116,500037,501357}
G[12059]={115,500035,501359}
G[12060]={115,500035,501359}
G[12061]={115,500035,501359}
G[12063]={115,500035,501359}
G[12064]={115,500035,501359}
G[12065]={115,500035,501359}
G[12066]={115,500035,501359}
G[12067]={115,500035,501359}
G[12068]={116,500037,501357}
G[12069]={115,500035,501359}
G[12070]={116,500037,501357}
G[12071]={115,500035,501359}
G[12072]={115,500035,501359}
G[12073]={116,500037,501357}
G[12074]={116,500037,501357}
G[12075]={115,500035,501359}
G[12076]={115,500035,501359}
G[12077]={115,500035,501359}
G[12078]={115,500035,501359}
G[12079]={115,500035,501359}
G[12080]={115,500035,501359}
G[12081]={116,500037,501357}
G[12082]={116,500037,501357}
G[12083]={115,500035,501359}
G[12084]={115,500035,501359}
G[12085]={115,500035,501359}
G[12086]={114,500033,501358}
G[12088]={114,500033,501358}
G[12089]={115,500035,501359}
G[12090]={115,500035,501359}
G[12091]={115,500035,501359}
G[12092]={115,500035,501359}
G[12093]={116,500037,501357}
G[12094]={116,500037,501357}
G[12095]={115,500035,501359}
G[12096]={115,500035,501359}
G[12097]={115,500035,501359}
G[12098]={115,500035,501359}
G[12099]={116,500037,501357}
G[12100]={115,500035,501359}
G[12101]={115,500035,501359}
G[12102]={115,500035,501359}
G[12104]={115,500035,501359}
G[12105]={116,500037,501357}
G[12106]={115,500035,501359}
G[12107]={115,500035,501359}
G[12109]={116,500037,501357}
G[12110]={115,500035,501359}
G[12111]={115,500035,501359}
G[12112]={115,500035,501359}
G[12113]={116,500037,501357}
G[12114]={116,500037,501357}
G[12115]={115,500035,501359}
G[12116]={116,500037,501357}
G[12117]={115,500035,501359}
G[12118]={115,500035,501359}
G[12119]={115,500035,501359}
G[12120]={116,500037,501357}
G[12121]={116,500037,501357}
G[12122]={115,500035,501359}
G[12123]={115,500035,501359}
G[12124]={115,500035,501359}
G[12125]={115,500035,501359}
G[12126]={115,500035,501359}
G[12127]={115,500035,501359}
G[12128]={116,500037,501357}
G[12129]={116,500037,501357}
G[12130]={116,500037,501357}
G[12131]={116,500037,501357}
G[12132]={115,500035,501359}
G[12134]={116,500037,501357}
G[12135]={500289}
G[12136]={115,500035,501359}
G[12137]={116,500037,501357}
G[12138]={116,500037,501357}
G[12139]={500289}
G[12140]={115,500035,501359}
G[12141]={114,500033,501358}
G[12142]={115,500035,501359}
G[12143]={115,500035,501359}
G[12144]={115,500035,501359}
G[12145]={115,500035,501359}
G[12146]={115,500035,501359}
G[12147]={115,500035,501359}
G[12148]={115,500035,501359}
G[12149]={115,500035,501359}
G[12150]={115,500035,501359}
G[12151]={115,500035,501359}
G[12152]={116,500037,501357}
G[12153]={116,500037,501357}
G[12154]={116,500037,501357}
G[12157]={115,500035,501359}
G[12158]={116,500037,501357}
G[12159]={116,500037,501357}
G[12160]={116,500037,501357}
G[12161]={116,500037,501357}
G[12164]={116,500037,501357}
G[12165]={116,500037,501357}
G[12166]={115,500035,501359}
G[12167]={115,500035,501359}
G[12168]={115,500035,501359}
G[12169]={115,500035,501359}
G[12170]={116,500037,501357}
G[12171]={115,500035,501359}
G[12174]={115,500035,501359}
G[12175]={116,500037,501357}
G[12176]={116,500037,501357}
G[12177]={116,500037,501357}
G[12178]={116,500037,501357}
G[12180]={116,500037,501357}
G[12181]={117,500034,501356}
G[12182]={115,500035,501359}
G[12183]={116,500037,501357}
G[12184]={116,500037,501357}
G[12185]={116,500037,501357}
G[12188]={115,500035,501359}
G[12189]={115,500035,501359}
G[12190]={116,500037,501357}
G[12192]={501186}
G[12195]={116,500037,501357}
G[12196]={116,500037,501357}
G[12197]={116,500037,501357}
G[12198]={116,500037,501357}
G[12199]={116,500037,501357}
G[12200]={115,500035,501359}
G[12201]={116,500037,501357}
G[12202]={116,500037,501357}
G[12203]={116,500037,501357}
G[12204]={116,500037,501357}
G[12205]={115,500035,501359}
G[12206]={115,500035,501359}
G[12207]={116,500037,501357}
G[12208]={116,500037,501357}
G[12209]={115,500035,501359}
G[12210]={116,500037,501357}
G[12211]={115,500035,501359}
G[12212]={116,500037,501357}
G[12213]={116,500037,501357}
G[12214]={115,500035,501359}
G[12215]={116,500037,501357}
G[12216]={116,500037,501357}
G[12217]={116,500037,501357}
G[12218]={115,500035,501359}
G[12219]={116,500037,501357}
G[12220]={116,500037,501357}
G[12221]={115,500035,501359}
G[12222]={116,500037,501357}
G[12223]={116,500037,501357}
G[12224]={115,500035,501359}
G[12225]={116,500037,501357}
G[12226]={116,500037,501357}
G[12227]={116,500037,501357}
G[12229]={116,500037,501357}
G[12230]={115,500035,501359}
G[12231]={116,500037,501357}
G[12232]={115,500035,501359}
G[12234]={115,500035,501359}
G[12235]={115,500035,501359}
G[12236]={116,500037,501357}
G[12237]={115,500035,501359}
G[12238]={501596}
G[12239]={115,500035,501359}
G[12240]={115,500035,501359}
G[12241]={116,500037,501357}
G[12242]={116,500037,501357}
G[12243]={115,500035,501359}
G[12245]={115,500035,501359}
G[12246]={116,500037,501357}
G[12247]={116,500037,501357}
G[12248]={116,500037,501357}
G[12249]={116,500037,501357}
G[12250]={116,500037,501357}
G[12251]={115,500035,501359}
G[12252]={115,500035,501359}
G[12253]={115,500035,501359}
G[12254]={115,500035,501359}
G[12255]={116,500037,501357}
G[12256]={116,500037,501357}
G[12257]={116,500037,501357}
G[12258]={115,500035,501359}
G[12259]={116,500037,501357}
G[12260]={115,500035,501359}
G[12261]={115,500035,501359}
G[12262]={115,500035,501359}
G[12263]={115,500035,501359}
G[12264]={115,500035,501359}
G[12265]={115,500035,501359}
G[12266]={115,500035,501359}
G[12267]={115,500035,501359}
G[12269]={115,500035,501359}
G[12271]={115,500035,501359}
G[12272]={115,500035,501359}
G[12273]={115,500035,501359}
G[12274]={115,500035,501359}
G[12275]={115,500035,501359}
G[12276]={115,500035,501359}
G[12277]={115,500035,501359}
G[12279]={116,500037,501357}
G[12281]={115,500035,501359}
G[12282]={115,500035,501359}
G[12283]={115,500035,501359}
G[12285]={115,500035,501359}
G[12286]={500966}
G[12287]={115,500035,501359}
G[12290]={115,500035,501359}
G[12291]={115,500035,501359}
G[12292]={116,500037,501357}
G[12293]={116,500037,501357}
G[12294]={116,500037,501357}
G[12295]={116,500037,501357}
G[12297]={115,500035,501359}
G[12298]={115,500035,501359}
G[12299]={116,500037,501357}
G[12300]={116,500037,501357}
G[12301]={115,500035,501359}
G[12302]={116,500037,501357}
G[12303]={115,500035,501359}
G[12304]={115,500035,501359}
G[12305]={115,500035,501359}
G[12307]={116,500037,501357}
G[12308]={116,500037,501357}
G[12309]={115,500035,501359}
G[12310]={116,500037,501357}
G[12311]={115,500035,501359}
G[12312]={115,500035,501359}
G[12319]={115,500035,501359}
G[12320]={115,500035,501359}
G[12321]={115,500035,501359}
G[12325]={115,500035,501359}
G[12326]={115,500035,501359}
G[12327]={116,500037,501357}
G[12328]={116,500037,501357}
G[12329]={116,500037,501357}
G[12330]={116,500037,501357}
G[12331]={500963}
G[12332]={500966}
G[12333]={500963}
G[12334]={500963}
G[12335]={500966}
G[12336]={500966}
G[12337]={500963}
G[12339]={500966}
G[12340]={500966}
G[12341]={500963}
G[12342]={500966}
G[12343]={500966}
G[12344]={500966}
G[12345]={500963}
G[12348]={500963}
--G[12349]={500963}	-- Theramore...now destroyed
G[12350]={500963}
G[12351]={500966}
G[12352]={500969}
G[12353]={500969}
G[12354]={500969}
G[12355]={500969}
G[12356]={500969}
G[12357]={500969}
G[12358]={500969}
G[12359]={500969}
G[12360]={500969}
G[12361]={500965}
G[12362]={500965}
G[12363]={500967}
G[12364]={500967}
G[12365]={500967}
G[12366]={500965}
G[12367]={500965}
G[12368]={500967}
G[12369]={500967}
G[12370]={500967}
G[12371]={500967}
G[12372]={115,500035,501359}
G[12373]={500967}
G[12374]={500965}
G[12376]={500967}
G[12377]={500965}
G[12378]={500965}
G[12380]={500967}
G[12381]={500965}
G[12382]={500967}
G[12383]={500965}
G[12384]={500967}
G[12386]={500965}
G[12387]={500967}
G[12388]={500968}
G[12389]={500968}
G[12390]={500968}
G[12391]={500968}
G[12392]={500968}
G[12393]={500968}
G[12394]={500968}
G[12395]={500968}
G[12396]={500963,500965}
G[12397]={500966,500967}
G[12398]={500963,500965}
G[12399]={500963,500965}
G[12400]={500963,500965}
G[12401]={500963,500965}
G[12402]={500966,500967}
G[12403]={500969,500968}
G[12404]={500969,500968}
G[12406]={500969,500968}
G[12407]={500969,500968}
G[12408]={500969,500968}
G[12409]={500969,500968}
G[12411]={116,500037,501357}
G[12412]={116,500037,501357}
G[12413]={116,500037,501357}
G[12414]={116,500037,501357}
G[12415]={116,500037,501357}
G[12416]={115,500035,501359}
G[12417]={115,500035,501359}
G[12418]={115,500035,501359}
G[12419]={115,500035,501359}
G[12422]={116,500037,501357}
G[12423]={116,500037,501357}
G[12424]={116,500037,501357}
G[12425]={116,500037,501357}
G[12427]={116,500037,501357}
G[12428]={116,500037,501357}
G[12429]={116,500037,501357}
G[12430]={116,500037,501357}
G[12431]={116,500037,501357}
G[12435]={115,500035,501359}
G[12436]={116,500037,501357}
G[12438]={115,500035,501359}
G[12439]={115,500035,501359}
G[12440]={115,500035,501359}
G[12441]={115,500035,501359}
G[12442]={115,500035,501359}
G[12447]={115,500035,501359}
G[12448]={115,500035,501359}
G[12449]={115,500035,501359}
G[12450]={115,500035,501359}
G[12451]={116,500037,501357}
G[12453]={116,500037,501357}
G[12454]={115,500035,501359}
G[12455]={115,500035,501359}
G[12456]={115,500035,501359}
G[12457]={115,500035,501359}
G[12458]={115,500035,501359}
G[12459]={115,500035,501359}
G[12460]={115,500035,501359}
G[12461]={115,500035,501359}
G[12462]={115,500035,501359}
G[12463]={115,500035,501359}
G[12464]={115,500035,501359}
G[12465]={115,500035,501359}
G[12466]={115,500035,501359}
G[12467]={115,500035,501359}
G[12468]={116,500037,501357}
G[12469]={115,500035,501359}
G[12470]={115,500035,501359}
G[12471]={114,500033,501358}
G[12472]={115,500035,501359}
G[12473]={115,500035,501359}
G[12474]={115,500035,501359}
G[12475]={115,500035,501359}
G[12476]={115,500035,501359}
G[12477]={115,500035,501359}
G[12478]={115,500035,501359}
G[12481]={117,500034,501356}
G[12482]={117,500034,501356}
G[12483]={116,500037,501357}
G[12484]={116,500037,501357}
G[12486]={114,500033,501358}
G[12487]={116,500037,501357}
G[12488]={115,500035,501359}
G[12489]={119,500039}
G[12495]={115,500035,501359}
G[12496]={115,500035,501359}
G[12497]={115,500035,501359}
G[12498]={115,500035,501359}
G[12499]={115,500035,501359,500547}
G[12500]={115,500035,501359,500547}
G[12503]={121,500036}
G[12504]={121,500036}
G[12505]={121,500036}
G[12506]={121,500036}
G[12507]={121,500036}
G[12508]={121,500036}
G[12510]={121,500036}
G[12511]={116,500037,501357}
G[12512]={121,500036}
G[12514]={121,500036}
G[12516]={121,500036}
G[12520]={119,500039}
G[12521]={119,500039}
G[12522]={119,500039}
G[12523]={119,500039}
G[12524]={119,500039}
G[12525]={119,500039}
G[12526]={119,500039}
G[12527]={121,500036}
G[12528]={119,500039}
G[12529]={119,500039}
G[12530]={119,500039}
G[12531]={119,500039}
G[12532]={119,500039}
G[12533]={119,500039}
G[12534]={119,500039}
G[12535]={119,500039}
G[12536]={119,500039}
G[12537]={119,500039}
G[12538]={119,500039}
G[12539]={119,500039}
G[12540]={119,500039}
G[12542]={115,500035,501359}
G[12543]={119,500039}
G[12544]={119,500039}
G[12545]={115,500035,501359}
G[12546]={119,500039}
G[12547]={78,504939}
G[12548]={119,500039}
G[12549]={119,500039}
G[12550]={119,500039}
G[12551]={119,500039}
G[12552]={121,500036}
G[12553]={121,500036}
G[12554]={121,500036}
G[12555]={121,500036}
G[12556]={119,500039}
G[12557]={121,500036}
G[12558]={119,500039}
G[12559]={119,500039}
G[12560]={119,500039}
G[12561]={119,500039}
G[12562]={121,500036}
G[12565]={121,500036}
G[12566]={117,500034,501356}
G[12567]={121,500036}
G[12569]={119,500039}
G[12570]={119,500039}
G[12571]={119,500039}
G[12572]={119,500039}
G[12573]={119,500039}
G[12574]={119,500039}
G[12575]={119,500039}
G[12576]={119,500039}
G[12577]={119,500039}
G[12578]={119,500039}
G[12579]={119,500039}
G[12580]={119,500039}
G[12581]={119,500039}
G[12582]={119,500039}
G[12583]={121,500036}
G[12584]={121,500036}
G[12589]={119,500039}
G[12592]={119,500039}
G[12595]={119,500039}
G[12596]={121,500036}
G[12597]={121,500036}
G[12598]={121,500036}
G[12599]={121,500036}
G[12603]={119,500039}
G[12605]={119,500039}
G[12606]={121,500036}
G[12607]={119,500039}
G[12608]={119,500039}
G[12609]={121,500036}
G[12610]={121,500036}
G[12611]={119,500039}
G[12612]={119,500039}
G[12613]={119,500039}
G[12614]={119,500039,500938}
G[12615]={121,500036}
G[12617]={119,500039}
G[12618]={121,500036}
G[12620]={119,500039}
G[12621]={119,500039}
G[12622]={121,500036}
G[12623]={121,500036}
G[12624]={119,500039}
G[12627]={121,500036}
G[12628]={121,500036}
G[12629]={121,500036}
G[12630]={121,500036}
G[12631]={121,500036}
G[12632]={121,500036}
G[12633]={121,500036}
G[12634]={119,500039}
G[12635]={121,500036}
G[12637]={121,500036}
G[12638]={121,500036}
G[12639]={121,500036}
G[12640]={121,500036}
G[12642]={121,500036}
G[12643]={121,500036}
G[12644]={119,500039}
G[12645]={119,500039}
G[12646]={121,500036}
G[12647]={121,500036}
G[12648]={121,500036}
G[12649]={121,500036}
G[12650]={121,500036}
G[12651]={119,500039}
G[12652]={121,500036}
G[12653]={121,500036}
G[12654]={119,500039}
G[12655]={121,500036}
G[12656]={121,500036}
G[12658]={119,500039}
G[12659]={121,500036}
G[12660]={119,500039}
G[12661]={121,500036}
G[12662]={121,500036}
G[12663]={121,500036}
G[12664]={121,500036}
G[12665]={121,500036}
G[12666]={121,500036}
G[12667]={121,500036}
G[12668]={121,500036}
G[12669]={121,500036}
G[12671]={119,500039}
G[12672]={121,500036}
G[12673]={121,500036}
G[12674]={121,500036}
G[12675]={121,500036}
G[12676]={121,500036}
G[12677]={121,500036}
G[12681]={119,500039}
G[12683]={119,500039}
G[12684]={121,500036}
G[12685]={121,500036}
G[12686]={121,500036}
G[12688]={119,500039}
G[12689]={119,500039}
G[12690]={121,500036}
G[12691]={119,500039}
G[12696]={119,500039}
G[12699]={119,500039}
G[12702]={500961}
G[12703]={500961}
G[12704]={500962}
G[12705]={500962}
G[12707]={121,500036}
G[12708]={121,500036}
G[12709]={121,500036}
G[12710]={121,500036}
G[12712]={121,500036}
G[12713]={121,500036,501596}
G[12721]={121,500036}
G[12726]={500962}
G[12728]={114,500033,501358}
G[12729]={121,500036}
G[12730]={121,500036}
G[12732]={500961}
G[12734]={500961}
G[12735]={500962}
G[12736]={500962}
G[12737]={500962}
G[12740]={121,500036}
G[12741]={500961}
G[12758]={500961}
G[12759]={500961}
G[12760]={500961}
G[12761]={500962}
G[12762]={500962}
G[12763]={116,500037,501357}
G[12766]={115,500035,501359}
G[12767]={115,500035,501359}
G[12768]={115,500035,501359}
G[12769]={115,500035,501359}
G[12770]={116,500037,501357}
G[12789]={121,500036}
G[12792]={121,500036}
G[12793]={121,500036}
G[12795]={121,500036}
G[12797]={119,500039}
G[12799]={121,500036}
G[12802]={116,500037,501357}
G[12803]={119,500039}
G[12804]={119,500039}
G[12805]={119,500039}
G[12806]={118,500040}
G[12807]={118,500040}
G[12810]={118,500040}
G[12814]={118,500040}
G[12818]={120,500038}
G[12819]={120,500038}
G[12820]={120,500038}
G[12821]={120,500038}
G[12822]={120,500038}
G[12823]={120,500038}
G[12824]={120,500038}
G[12826]={120,500038}
G[12827]={120,500038}
G[12828]={120,500038}
G[12829]={120,500038}
G[12830]={120,500038}
G[12831]={120,500038}
G[12832]={120,500038}
G[12833]={120,500038}
G[12836]={120,500038}
G[12839]={118,500040}
G[12840]={118,500040}
G[12841]={120,500038}
G[12843]={120,500038}
G[12844]={120,500038}
G[12846]={120,500038}
G[12847]={118,500040}
G[12851]={120,500038}
G[12852]={118,500040}
G[12853]={120,500038}
G[12854]={120,500038}
G[12855]={120,500038}
G[12856]={120,500038}
G[12857]={121,500036}
G[12858]={120,500038}
G[12859]={121,500036}
G[12860]={120,500038}
G[12861]={121,500036}
G[12862]={120,500038}
G[12863]={120,500038}
G[12864]={120,500038}
G[12865]={120,500038}
G[12866]={120,500038}
G[12867]={120,500038}
G[12868]={120,500038}
G[12870]={120,500038}
G[12871]={120,500038}
G[12872]={120,500038}
G[12873]={120,500038}
G[12874]={120,500038}
G[12875]={120,500038}
G[12876]={120,500038}
G[12877]={120,500038}
G[12878]={120,500038}
G[12879]={120,500038}
G[12880]={120,500038}
G[12882]={120,500038}
G[12883]={121,500036}
G[12884]={121,500036}
G[12885]={120,500038}
G[12886]={120,500038}
G[12887]={118,500040}
G[12888]={120,500038}
G[12889]={120,500038}
G[12891]={118,500040}
G[12892]={118,500040}
G[12893]={118,500040}
G[12894]={121,500036}
G[12895]={120,500038}
G[12896]={118,500040}
G[12897]={118,500040}
G[12898]={118,500040}
G[12899]={118,500040}
G[12900]={120,500038}
G[12901]={121,500036}
G[12902]={121,500036}
G[12903]={121,500036}
G[12904]={121,500036}
G[12905]={120,500038}
G[12906]={120,500038}
G[12907]={120,500038}
G[12908]={120,500038}
G[12909]={120,500038}
G[12910]={120,500038}
G[12912]={121,500036}
G[12913]={120,500038}
G[12914]={121,500036}
G[12915]={120,500038}
G[12916]={121,500036}
G[12917]={120,500038}
G[12919]={121,500036}
G[12920]={120,500038}
G[12921]={120,500038}
G[12922]={120,500038}
G[12924]={120,500038}
G[12925]={120,500038}
G[12926]={120,500038}
G[12927]={120,500038}
G[12928]={120,500038}
G[12929]={120,500038}
G[12930]={120,500038}
G[12931]={120,500038}
G[12932]={121,500036}
G[12933]={121,500036}
G[12934]={121,500036}
G[12935]={121,500036}
G[12936]={121,500036}
G[12937]={120,500038}
G[12938]={118,500040}
G[12939]={118,500040}
G[12940]={505836,505835}
G[12941]={505836,505835}
G[12942]={120,500038}
G[12943]={118,500040}
G[12944]={505836}
G[12945]={505836}
G[12946]={505835}
G[12947]={505835}
G[12948]={121,500036}
G[12949]={118,500040}
G[12950]={505836,505835}
G[12951]={118,500040}
G[12953]={120,500038}
G[12954]={121,500036}
G[12955]={118,500040}
G[12956]={120,500038}
G[12957]={120,500038}
G[12964]={120,500038}
G[12965]={120,500038}
G[12966]={120,500038}
G[12967]={120,500038}
G[12968]={120,500038}
G[12969]={120,500038}
G[12970]={120,500038}
G[12971]={120,500038}
G[12972]={120,500038}
G[12973]={120,500038}
G[12974]={121,500036}
G[12975]={120,500038}
G[12976]={120,500038}
G[12978]={120,500038}
G[12979]={120,500038}
G[12980]={120,500038}
G[12982]={118,500040}
G[12983]={120,500038}
G[12984]={120,500038}
G[12985]={120,500038}
G[12986]={120,500038}
G[12987]={120,500038}
G[12988]={120,500038}
G[12989]={120,500038}
G[12991]={120,500038}
G[12992]={118,500040}
G[12993]={120,500038}
G[12996]={120,500038}
G[12997]={120,500038}
G[12998]={120,500038}
G[12999]={118,500040}
G[13000]={120,500038}
G[13001]={120,500038}
G[13005]={120,500038}
G[13007]={120,500038}
G[13008]={118,500040}
G[13009]={120,500038}
G[13010]={120,500038}
G[13011]={120,500038}
G[13012]={501396}
G[13013]={501396}
G[13014]={501396}
G[13015]={501396}
G[13016]={501396}
G[13017]={500910}
G[13018]={501396}
G[13019]={501396}
G[13020]={501396}
G[13021]={500910}
G[13022]={500910}
G[13023]={500910}
G[13024]={501396}
G[13025]={501396}
G[13026]={501396}
G[13027]={501396}
G[13028]={501396}
G[13029]={501396}
G[13030]={501396}
G[13031]={501396}
G[13032]={501396}
G[13033]={501396}
G[13034]={120,500038}
G[13035]={120,500038}
G[13036]={118,500040}
G[13037]={120,500038}
G[13038]={120,500038}
G[13039]={118,500040}
G[13040]={118,500040}
G[13042]={118,500040}
G[13043]={118,500040}
G[13044]={118,500040}
G[13045]={118,500040}
G[13047]={120,500038}
G[13048]={120,500038}
G[13049]={120,500038}
G[13050]={120,500038}
G[13051]={120,500038}
G[13054]={120,500038}
G[13055]={120,500038}
G[13056]={120,500038}
G[13057]={120,500038}
G[13058]={120,500038}
G[13059]={118,500040}
G[13060]={120,500038}
G[13061]={120,500038}
G[13062]={120,500038}
G[13063]={120,500038}
G[13064]={120,500038}
G[13065]={500910}
G[13066]={500910}
G[13067]={500910}
G[13068]={118,500040}
G[13070]={118,500040}
G[13072]={118,500040}
G[13073]={118,500040}
G[13074]={118,500040}
G[13075]={118,500040}
G[13076]={118,500040}
G[13077]={118,500040}
G[13078]={115,500035,501359}
G[13079]={118,500040}
G[13080]={118,500040}
G[13081]={118,500040}
G[13082]={118,500040}
G[13083]={118,500040}
G[13084]={118,500040}
G[13085]={118,500040}
G[13086]={118,500040}
G[13091]={118,500040}
G[13092]={118,500040}
G[13097]={121,500036}
G[13099]={121,500036}
G[13100]={501782}
G[13101]={501782}
G[13102]={501782}
G[13103]={501782}
G[13104]={118,500040}
G[13105]={118,500040}
G[13106]={118,500040}
G[13107]={501782}
G[13110]={118,500040}
G[13112]={501783}
G[13113]={501783}
G[13114]={501783}
G[13115]={501783}
G[13116]={501783}
G[13117]={118,500040}
G[13118]={118,500040}
G[13119]={118,500040}
G[13120]={118,500040}
G[13121]={118,500040}
G[13122]={118,500040}
G[13124]={504956}
G[13125]={118,500040}
G[13130]={118,500040}
G[13131]={504956}
G[13133]={118,500040}
G[13134]={118,500040}
G[13135]={118,500040}
G[13136]={118,500040}
G[13137]={118,500040}
G[13138]={118,500040}
G[13139]={118,500040}
G[13140]={118,500040}
G[13141]={118,500040}
G[13142]={118,500040}
G[13143]={118,500040}
G[13144]={118,500040}
G[13145]={118,500040}
G[13146]={118,500040}
G[13147]={118,500040}
G[13149]={504956}
G[13152]={118,500040}
G[13155]={118,500040}
G[13157]={118,500040}
G[13160]={118,500040}
G[13161]={118,500040}
G[13162]={118,500040}
G[13163]={118,500040}
G[13164]={118,500040}
G[13168]={118,500040}
G[13169]={118,500040}
G[13170]={118,500040}
G[13171]={118,500040}
G[13172]={118,500040}
G[13174]={118,500040}
G[13205]={504956}
G[13207]={504956}
G[13211]={118,500040}
G[13212]={118,500040}
G[13213]={118,500040}
G[13214]={118,500040}
G[13215]={118,500040}
G[13216]={118,500040}
G[13217]={118,500040}
G[13218]={118,500040}
G[13219]={118,500040}
G[13220]={118,500040}
G[13221]={118,500040}
G[13224]={118,500040}
G[13225]={118,500040}
G[13226]={118,500040}
G[13227]={118,500040}
G[13228]={118,500040}
G[13229]={118,500040}
G[13230]={118,500040}
G[13231]={118,500040}
G[13232]={118,500040}
G[13235]={118,500040}
G[13236]={118,500040}
G[13237]={118,500040}
G[13238]={118,500040}
G[13239]={118,500040}
G[13258]={118,500040}
G[13259]={118,500040}
G[13260]={118,500040}
G[13263]={118,500040}
G[13264]={118,500040}
G[13271]={118,500040}
G[13273]={120,500038}
G[13274]={120,500038}
G[13275]={118,500040}
G[13277]={118,500040}
G[13278]={118,500040}
G[13279]={118,500040}
G[13280]={118,500040}
G[13282]={118,500040}
G[13283]={118,500040}
G[13285]={120,500038}
G[13286]={118,500040}
G[13287]={118,500040}
G[13288]={118,500040}
G[13290]={118,500040}
G[13291]={118,500040}
G[13293]={118,500040}
G[13294]={118,500040}
G[13295]={118,500040}
G[13296]={118,500040}
G[13298]={118,500040}
G[13304]={118,500040}
G[13305]={118,500040}
G[13306]={118,500040}
G[13307]={118,500040}
G[13308]={118,500040}
G[13312]={118,500040}
G[13313]={118,500040}
G[13314]={118,500040}
G[13315]={118,500040}
G[13316]={118,500040}
G[13318]={118,500040}
G[13319]={118,500040}
G[13320]={118,500040}
G[13321]={118,500040}
G[13328]={118,500040}
G[13329]={118,500040}
G[13332]={118,500040}
G[13334]={118,500040}
G[13335]={118,500040}
G[13337]={118,500040}
G[13338]={118,500040}
G[13339]={118,500040}
G[13340]={118,500040}
G[13341]={118,500040}
G[13342]={118,500040}
G[13343]={115,500035,501359}
G[13345]={118,500040}
G[13346]={118,500040}
G[13348]={118,500040}
G[13349]={118,500040}
G[13351]={118,500040}
G[13352]={118,500040}
G[13354]={118,500040}
G[13355]={118,500040}
G[13356]={118,500040}
G[13358]={118,500040}
G[13359]={118,500040}
G[13360]={118,500040}
G[13361]={118,500040}
G[13362]={118,500040}
G[13363]={118,500040}
G[13364]={118,500040}
G[13366]={118,500040}
G[13367]={118,500040}
G[13372]={115,500035,501359}
G[13373]={118,500040}
G[13375]={115,500035,501359}
G[13379]={118,500040}
G[13380]={118,500040}
G[13386]={118,500040}
G[13387]={118,500040}
G[13389]={118,500040}
G[13390]={118,500040}
G[13391]={118,500040}
G[13392]={118,500040}
G[13393]={118,500040}
G[13394]={118,500040}
G[13395]={118,500040}
G[13396]={118,500040}
G[13397]={118,500040}
G[13398]={118,500040}
G[13399]={118,500040}
G[13400]={118,500040}
G[13401]={118,500040}
G[13402]={118,500040}
G[13403]={118,500040}
G[13408]={100,501189,501271}
G[13409]={100,501189,501271}
G[13410]={100,501189,501271}
G[13411]={100,501189,501271}
G[13413]={114,500033,501358}
G[13415]={120,500038}
G[13416]={120,500038}
G[13418]={118,500040}
G[13419]={118,500040}
G[13420]={120,500038}
G[13426]={120,500038}
G[13431]={504956}
G[13433]={505836}
G[13434]={505836}
G[13435]={505836}
G[13436]={505836}
G[13437]={505836}
G[13438]={505836}
G[13439]={505836}
G[13440]={506010}
G[13441]={506007}
G[13442]={506010}
G[13443]={506010}
G[13444]={506010}
G[13445]={506010}
G[13446]={506010}
G[13447]={506010}
G[13448]={505836}
G[13449]={506010}
G[13450]={506007}
G[13451]={506007}
G[13452]={505836,505835}
G[13453]={506007}
G[13454]={506007}
G[13455]={506007}
G[13456]={505836,505835}
G[13457]={506007}
G[13458]={506007}
G[13459]={505836,505835}
G[13460]={505836,505835}
G[13461]={505836,505835}
G[13462]={505836,505835}
G[13463]={505836,505835}
G[13464]={505835}
G[13465]={505835}
G[13466]={505835}
G[13467]={505835}
G[13468]={505835}
G[13469]={505835}
G[13470]={505835}
G[13471]={505835}
G[13472]={505836,505835}
G[13473]={505836}
G[13474]={505835}
G[13481]={118,500040}
G[13482]={118,500040}
G[13485]={506008}
G[13486]={506008}
G[13487]={506008}
G[13488]={506008}
G[13489]={506008}
G[13490]={506008}
G[13491]={506008}
G[13492]={506008}
G[13493]={506009}
G[13494]={506009}
G[13495]={506009}
G[13496]={506009}
G[13497]={506009}
G[13498]={506009}
G[13499]={506009}
G[13500]={506009}
G[13501]={505835}
G[13504]={62,504928}
G[13505]={62,504928}
G[13506]={62,504928}
G[13507]={62,504928}
G[13508]={62,504928}
G[13509]={62,504928}
G[13510]={62,504928}
G[13511]={62,504928}
G[13512]={62,504928}
G[13513]={62,504928}
G[13514]={62,504928}
G[13515]={62,504928}
G[13518]={62,504928}
G[13519]={62,504928}
G[13520]={62,504928}
G[13521]={62,504928}
G[13522]={62,504928}
G[13523]={62,504928}
G[13525]={62,504928}
G[13526]={62,504928}
G[13527]={62,504928}
G[13528]={62,504928}
G[13529]={62,504928}
G[13537]={62,504928}
G[13542]={62,504928}
G[13543]={62,504928}
G[13544]={62,504928}
G[13545]={62,504928}
G[13546]={62,504928}
G[13547]={62,504928}
G[13548]={505835}
G[13549]={121,500036}
G[13554]={62,504928}
G[13556]={121,500036}
G[13557]={62,504928}
G[13558]={62,504928}
G[13560]={62,504928}
G[13561]={62,504928}
G[13562]={62,504928}
G[13563]={62,504928}
G[13564]={62,504928}
G[13565]={62,504928}
G[13566]={62,504928}
G[13567]={62,504928}
G[13568]={62,504928}
G[13569]={62,504928}
G[13570]={62,504928}
G[13572]={62,504928}
G[13573]={62,504928}
G[13575]={62,504928}
G[13576]={62,504928}
G[13577]={62,504928}
G[13578]={62,504928}
G[13579]={62,504928}
G[13580]={62,504928}
G[13581]={62,504928}
G[13582]={62,504928}
G[13583]={62,504928}
G[13584]={62,504928}
G[13585]={62,504928}
G[13586]={62,504928}
G[13587]={62,504928}
G[13588]={62,504928}
G[13589]={62,504928}
G[13590]={62,504928}
G[13591]={62,504928}
G[13594]={63,504925}
G[13595]={63,504925}
G[13596]={62,504928}
G[13597]={62,504928}
G[13598]={62,504928}
G[13599]={62,504928}
G[13601]={62,504928}
G[13602]={63,504925}
G[13605]={62,504928}
G[13612]={63,504925,504976}
G[13613]={63,504925,504976}
G[13615]={63,504925,504976}
G[13617]={63,504925}
G[13618]={63,504925,504976}
G[13619]={63,504925,504976}
G[13620]={63,504925,504976}
G[13621]={63,504925,504976}
G[13623]={63,504925}
G[13624]={63,504925}
G[13626]={63,504925}
G[13628]={63,504925,504976}
G[13630]={63,504925}
G[13632]={63,504925}
G[13636]={48,504899}
G[13639]={48,504899}
G[13640]={63,504925,504976}
G[13642]={63,504925}
G[13644]={63,504925}
G[13645]={63,504925}
G[13646]={63,504925}
G[13647]={48,504899}
G[13648]={48,504899}
G[13650]={48,504899}
G[13651]={63,504925,504976}
G[13653]={63,504925,504976}
G[13655]={48,504899}
G[13656]={48,504899}
G[13657]={48,504899}
G[13658]={48,504899}
G[13659]={48,504899}
G[13660]={48,504899}
G[13661]={48,504899}
G[13683]={63,504925}
G[13698]={63,504925}
G[13712]={63,504925,504976}
G[13730]={63,504925,504976}
G[13751]={63,504925,504976}
G[13766]={63,504925}
G[13792]={63,504925}
G[13796]={63,504925}
G[13797]={63,504925,504976}
G[13798]={63,504925,504976}
G[13801]={63,504925,504976}
G[13803]={63,504925,504976}
G[13805]={63,504925,504976}
G[13806]={63,504925,504976}
G[13808]={63,504925,504976}
G[13815]={63,504925,504976}
G[13830]={503217}
G[13831]={62,504928}
G[13832]={503217}
G[13833]={503217}
G[13834]={503217}
G[13836]={503217}
G[13841]={63,504925,504976}
G[13842]={63,504925,504976}
G[13844]={62,504928}
G[13848]={63,504925,504976}
G[13849]={63,504925}
G[13850]={78,504939}
G[13853]={63,504925}
G[13865]={63,504925,504976}
G[13866]={63,504925,504976}
G[13867]={63,504925}
G[13868]={63,504925}
G[13869]={63,504925}
G[13870]={63,504925,504976}
G[13871]={63,504925,504976}
G[13872]={63,504925}
G[13873]={63,504925,504976}
G[13874]={63,504925}
G[13875]={63,504925,504976}
G[13876]={63,504925}
G[13877]={63,504925}
G[13878]={10,504933}
G[13879]={63,504925,504976}
G[13880]={63,504925}
G[13881]={62,504928}
G[13882]={62,504928}
G[13883]={63,504925,504976}
G[13884]={63,504925}
G[13885]={62,504928}
G[13886]={63,504925}
G[13887]={78,504939}
G[13888]={63,504925,504976}
G[13889]={78,504939}
G[13890]={63,504925,504976}
G[13891]={62,504928}
G[13892]={62,504928}
G[13893]={62,504928}
G[13895]={62,504928}
G[13896]={62,504928}
G[13897]={62,504928}
G[13898]={62,504928}
G[13899]={62,504928}
G[13900]={62,504928}
G[13901]={63,504925,504976}
G[13902]={62,504928}
G[13903]={78,504939}
G[13904]={78,504939}
G[13905]={78,504939}
G[13907]={62,504928}
G[13909]={62,504928}
G[13910]={62,504928}
G[13911]={62,504928}
G[13912]={62,504928}
G[13913]={63,504925}
G[13914]={78,504939}
G[13915]={78,504939}
G[13916]={78,504939}
G[13917]={78,504939}
G[13918]={62,504928}
G[13920]={63,504925,504976}
G[13921]={63,504925}
G[13922]={63,504925}
G[13923]={63,504925,504976}
G[13924]={63,504925}
G[13925]={62,504928}
G[13928]={63,504925}
G[13935]={63,504925}
G[13936]={63,504925,504976}
G[13940]={62,504928}
G[13942]={63,504925,504976}
G[13943]={63,504925,504976}
G[13944]={63,504925,504976}
G[13947]={63,504925,504976}
G[13948]={62,504928}
G[13949]={10,504933}
G[13953]={62,504928}
G[13958]={63,504925,504976}
G[13961]={10,504933}
G[13962]={63,504925,504976}
G[13963]={10,504933}
G[13964]={63,504925}
G[13965]={63,504925}
G[13967]={63,504925,504976}
G[13968]={10,504933}
G[13969]={10,504933}
G[13970]={10,504933}
G[13971]={10,504933}
G[13973]={10,504933}
G[13974]={63,504925,504976}
G[13975]={10,504933}
G[13976]={63,504925}
G[13977]={63,504925,504976}
G[13979]={63,504925}
G[13980]={63,504925,504976}
G[13981]={63,504925}
G[13982]={63,504925}
G[13983]={63,504925,504976}
G[13985]={63,504925}
G[13987]={63,504925}
G[13988]={10,504933}
G[13989]={63,504925}
G[13991]={10,504933}
G[13992]={10,504933}
G[13995]={10,504933}
G[13998]={10,504933}
G[13999]={10,504933}
G[14003]={10,504933}
G[14004]={10,504933}
G[14006]={10,504933}
G[14034]={10,504933}
G[14038]={10,504933}
G[14042]={10,504933}
G[14045]={10,504933}
G[14046]={10,504933}
G[14048]={503596}
G[14049]={10,504933}
G[14050]={10,504933}
G[14051]={503596}
G[14052]={10,504933}
G[14053]={503596}
G[14054]={503596}
G[14055]={503596}
G[14056]={10,504933}
G[14057]={10,504933}
G[14058]={503597}
G[14059]={503597}
G[14060]={503597}
G[14061]={503597}
G[14062]={503597}
G[14063]={10,504933}
G[14066]={10,504933}
G[14067]={10,504933}
G[14068]={10,504933}
G[14072]={10,504933}
G[14073]={10,504933}
G[14117]={76,504927}
G[14118]={76,504927}
G[14127]={76,504927}
G[14128]={76,504927}
G[14129]={76,504927}
G[14130]={76,504927}
G[14131]={76,504927}
G[14132]={76,504927}
G[14134]={76,504927}
G[14135]={76,504927}
G[14155]={76,504927}
G[14161]={76,504927}
G[14162]={76,504927}
G[14165]={76,504927}
G[14190]={76,504927}
G[14192]={76,504927}
G[14193]={66,504930}
G[14194]={76,504927}
G[14196]={66,504930}
G[14197]={76,504927}
G[14201]={76,504927}
G[14202]={76,504927}
G[14209]={76,504927}
G[14215]={76,504927}
G[14216]={76,504927}
G[14226]={76,504927}
G[14230]={76,504927}
G[14246]={66,504930}
G[14247]={66,504930}
G[14249]={76,504927}
G[14250]={76,504927}
G[14251]={66,504930}
G[14252]={66,504930}
G[14253]={66,504930}
G[14254]={66,504930}
G[14256]={66,504930}
G[14257]={66,504930}
G[14258]={76,504927}
G[14260]={66,504930}
G[14261]={76,504927}
G[14262]={76,504927}
G[14263]={76,504927}
G[14264]={66,504930}
G[14267]={76,504927}
G[14268]={66,504930}
G[14270]={76,504927}
G[14271]={76,504927}
G[14282]={66,504930}
G[14284]={66,504930}
G[14292]={66,504930}
G[14295]={76,504927}
G[14296]={76,504927}
G[14297]={76,504927}
G[14299]={76,504927}
G[14300]={76,504927}
G[14301]={66,504930}
G[14302]={66,504930}
G[14304]={66,504930}
G[14305]={66,504930}
G[14306]={66,504930}
G[14307]={66,504930}
G[14308]={76,504927}
G[14309]={66,504930}
G[14310]={76,504927}
G[14311]={66,504930}
G[14312]={66,504930}
G[14314]={66,504930}
G[14316]={66,504930}
G[14318]={66,504930}
G[14322]={76,504927}
G[14323]={76,504927}
G[14324]={76,504927}
G[14325]={66,504930}
G[14327]={66,504930}
G[14328]={66,504930}
G[14329]={66,504930}
G[14330]={66,504930}
G[14333]={66,504930}
G[14340]={76,504927}
G[14345]={76,504927}
G[14354]={66,504930}
G[14357]={66,504930}
G[14358]={66,504930}
G[14361]={66,504930}
G[14362]={66,504930}
G[14363]={66,504930}
G[14364]={66,504930}
G[14365]={66,504930}
G[14370]={76,504927}
G[14371]={76,504927}
G[14372]={66,504930}
G[14376]={66,504930}
G[14377]={76,504927}
G[14383]={76,504927}
G[14384]={66,504930}
G[14385]={76,504927}
G[14388]={76,504927}
G[14389]={76,504927}
G[14390]={76,504927}
G[14391]={76,504927}
G[14392]={76,504927}
G[14407]={76,504927}
G[14408]={76,504927}
G[14410]={69,504932,504979}
G[14413]={76,504927}
G[14422]={76,504927}
G[14423]={76,504927}
G[14424]={76,504927}
G[14428]={76,504927}
G[14429]={76,504927}
G[14430]={76,504927}
G[14431]={76,504927}
G[14432]={76,504927}
G[14433]={76,504927}
G[14435]={76,504927}
G[14442]={76,504927}
G[14443]={118,500040}
G[14462]={76,504927}
G[14464]={76,504927}
G[14468]={76,504927}
G[14469]={76,504927}
G[14470]={76,504927}
G[14471]={76,504927}
G[14472]={76,504927}
G[14475]={76,504927}
G[14476]={76,504927}
G[14477]={76,504927}
G[14478]={76,504927}
G[14479]={76,504927}
G[14480]={76,504927}
G[14484]={76,504927}
G[14485]={76,504927}
G[14486]={76,504927}
G[14487]={76,504927}
G[24430]={76,504927}
G[24433]={76,504927}
G[24434]={76,504927}
G[24435]={76,504927}
G[24436]={76,504927}
G[24437]={76,504927}
G[24439]={76,504927}
G[24448]={76,504927}
G[24449]={76,504927}
G[24452]={76,504927}
G[24453]={76,504927}
G[24455]={76,504927}
G[24458]={76,504927}
G[24463]={76,504927}
G[24467]={76,504927}
G[24478]={76,504927}
G[24479]={76,504927}
G[24497]={76,504927}
G[24504]={199,504937,504981}
G[24505]={199,504937,504981}
G[24506]={504956}
G[24510]={504956}
G[24512]={199,504937,504981}
G[24513]={199,504937,504981}
G[24514]={199,504937,504981}
G[24515]={199,504937,504981}
G[24517]={199,504937,504981}
G[24518]={199,504937,504981}
G[24519]={199,504937,504981}
G[24525]={199,504937,504981}
G[24529]={199,504937,504981}
G[24534]={199,504937,504981}
G[24539]={199,504937,504981}
G[24542]={199,504937,504981}
G[24543]={199,504937,504981}
G[24546]={199,504937,504981}
G[24551]={199,504937,504981}
G[24552]={199,504937,504981}
G[24554]={118,500040}
G[24565]={199,504937,504981}
G[24566]={199,504937,504981}
G[24569]={199,504937,504981}
G[24570]={199,504937,504981}
G[24571]={199,504937,504981}
G[24572]={199,504937,504981}
G[24573]={199,504937,504981}
G[24574]={199,504937,504981}
G[24577]={199,504937,504981}
G[24591]={199,504981}
G[24601]={199,504937,504981}
G[24603]={199,504937,504981}
G[24604]={199,504937,504981}
G[24606]={199,504937,504981}
G[24608]={199,504937,504981}
G[24618]={199,504937,504981}
G[24619]={199,504937,504981}
G[24620]={199,504937,504981}
G[24621]={199,504937,504981}
G[24631]={199,504937,504981}
G[24632]={199,504937,504981}
G[24633]={199,504937,504981}
G[24634]={199,504937,504981}
G[24637]={199,504937,504981}
G[24638]={501695}
G[24645]={501695}
G[24647]={501695}
G[24648]={501695}
G[24649]={501695}
G[24650]={501695}
G[24651]={501695}
G[24652]={501695}
G[24653]={199,504937,504981}
G[24654]={199,504937,504981}
G[24658]={501695}
G[24659]={501695}
G[24660]={501695}
G[24662]={501695}
G[24663]={501695}
G[24664]={501695}
G[24665]={501695}
G[24666]={501695}
G[24667]={199,504937,504981}
G[24684]={199,504937,504981}
G[24685]={199,504937,504981}
G[24686]={78,504939}
G[24687]={78,504939}
G[24689]={78,504939}
G[24690]={78,504939}
G[24691]={78,504939}
G[24692]={78,504939}
G[24693]={78,504939}
G[24694]={78,504939}
G[24695]={78,504939}
G[24697]={78,504939}
G[24698]={78,504939}
G[24699]={78,504939}
G[24700]={78,504939}
G[24701]={78,504939}
G[24703]={78,504939}
G[24704]={78,504939}
G[24705]={78,504939}
G[24706]={78,504939}
G[24707]={78,504939}
G[24708]={78,504939}
G[24709]={78,504939}
G[24714]={78,504939}
G[24715]={78,504939}
G[24717]={78,504939}
G[24719]={78,504939}
G[24720]={78,504939}
G[24721]={78,504939}
G[24722]={78,504939}
G[24723]={78,504939}
G[24730]={78,504939}
G[24731]={78,504939}
G[24732]={78,504939}
G[24733]={78,504939}
G[24734]={78,504939}
G[24735]={78,504939}
G[24736]={78,504939}
G[24737]={78,504939}
G[24740]={78,504939}
G[24742]={78,504939}
G[24747]={199,504937,504981}
G[24794]={78,504939}
G[24807]={199,504937,504981}
G[24824]={199,504937,504981}
G[24854]={78,504939}
G[24855]={78,504939}
G[24862]={199,504937}
G[24863]={199,504937}
G[24865]={78,504939}
G[24866]={78,504939}
G[24905]={71,504935}
G[24906]={71,504935}
G[24907]={71,504935}
G[24910]={71,504935}
G[24911]={78,504939}
G[24913]={51,504904}
G[24921]={199,504937}
G[24926]={78,504939}
G[24927]={71,504935}
G[24928]={71,504935}
G[24931]={71,504935}
G[24932]={71,504935}
G[24933]={71,504935}
G[24934]={199,504937}
G[24938]={199,504937}
G[24939]={199,504937}
G[24941]={199,504937}
G[24943]={199,504937}
G[24944]={199,504937}
G[24947]={71,504935}
G[24948]={199,504937}
G[24949]={71,504935}
G[24950]={71,504935}
G[24951]={71,504935}
G[24953]={71,504935}
G[24955]={71,504935}
G[24956]={199,504937}
G[24957]={71,504935}
G[24963]={71,504935}
G[25000]={199,504937}
G[25001]={71,504935}
G[25002]={199,504937}
G[25008]={199,504937}
G[25014]={71,504935}
G[25015]={199,504937}
G[25017]={71,504935}
G[25018]={71,504935}
G[25019]={71,504935}
G[25020]={71,504935}
G[25021]={71,504935}
G[25022]={199,504937}
G[25025]={71,504935}
G[25026]={71,504935}
G[25027]={199,504937}
G[25028]={199,504937}
G[25032]={71,504935}
G[25034]={199,504937}
G[25036]={199,504937}
G[25041]={199,504937}
G[25042]={199,504937}
G[25043]={199,504937}
G[25044]={199,504937}
G[25045]={199,504937}
G[25048]={71,504935}
G[25049]={71,504935}
G[25050]={71,504935}
G[25051]={70,504929,504978}
G[25052]={71,504935}
G[25053]={71,504935}
G[25054]={71,504935}
G[25057]={199,504937}
G[25059]={199,504937}
G[25060]={71,504935}
G[25061]={71,504935}
G[25062]={71,504935}
G[25063]={71,504935}
G[25065]={71,504935}
G[25067]={71,504935}
G[25068]={71,504935}
G[25069]={71,504935}
G[25070]={71,504935}
G[25072]={71,504935}
G[25074]={199,504937}
G[25075]={199,504937}
G[25079]={199,504937}
G[25080]={199,504937}
G[25081]={199,504937}
G[25082]={199,504937}
G[25084]={199,504937}
G[25085]={199,504937}
G[25086]={199,504937}
G[25087]={199,504937}
G[25091]={71,504935}
G[25094]={71,504935}
G[25095]={71,504935}
G[25102]={199,504937}
G[25103]={71,504935}
G[25104]={199,504937}
G[25106]={199,504937}
G[25107]={71,504935}
G[25108]={199,504937}
G[25111]={71,504935}
G[25112]={71,504935}
G[25115]={71,504935}
G[25118]={48,504899}
G[25120]={199,504937}
G[25121]={71,504935}
G[25151]={199,504937}
G[25153]={199,504937}
G[25163]={199,504937}
G[25164]={205,504869,504982}
G[25166]={71,504935}
G[25174]={199,504937}
G[25175]={199,504937}
G[25182]={199,504937}
G[25183]={199,504937}
G[25185]={199,504937}
G[25186]={199,504937}
G[25191]={199,504937}
G[25197]={199,504937}
G[25208]={69,504932,504979}
G[25209]={69,504932,504979}
G[25210]={69,504932,504979}
G[25211]={56,504899}
G[25215]={205,504869,504982}
G[25216]={205,504869,504982}
G[25217]={205,504869,504982}
G[25218]={205,504869,504982}
G[25219]={205,504869,504982}
G[25220]={205,504869,504982}
G[25221]={205,504869,504982}
G[25222]={205,504869,504982}
G[25223]={198,504870}
G[25224]={198,504870}
G[25230]={69,504932,504979}
G[25233]={198,504870}
G[25234]={198,504870}
G[25235]={47,504903}
G[25237]={69,504932,504979}
G[25241]={69,504932,504979}
G[25250]={69,504932,504979}
G[25252]={69,504932,504979}
G[25255]={198,504870}
G[25268]={198,504870}
G[25269]={198,504870}
G[25270]={198,504870}
G[25271]={198,504870}
G[25272]={198,504870}
G[25273]={198,504870}
G[25274]={198,504870}
G[25276]={198,504870}
G[25277]={198,504870}
G[25278]={198,504870}
G[25279]={198,504870}
G[25280]={198,504870}
G[25281]={201,504869,504982}
G[25284]={199,504937,504981}
G[25291]={198,504870}
G[25292]={70,504929,504978}
G[25294]={198,504870}
G[25296]={198,504870}
G[25297]={198,504870}
G[25298]={198,504870}
G[25299]={198,504870}
G[25300]={198,504870}
G[25301]={198,504870}
G[25303]={198,504870}
G[25304]={69,504932,504979}
G[25308]={198,504870}
G[25309]={198,504870}
G[25310]={198,504870}
G[25311]={198,504870}
G[25312]={198,504870}
G[25314]={198,504870}
G[25315]={198,504870}
G[25317]={198,504870}
G[25319]={198,504870}
G[25320]={198,504870}
G[25321]={198,504870}
G[25323]={198,504870}
G[25324]={198,504870}
G[25325]={198,504870}
G[25328]={198,504870}
G[25329]={69,504932,504979}
G[25330]={198,504870}
G[25332]={198,504870}
G[25333]={69,504932,504979}
G[25334]={205,504869,504982}
G[25336]={69,504932,504979}
G[25337]={69,504932,504979}
G[25338]={69,504932,504979}
G[25339]={69,504932,504979}
G[25340]={69,504932,504979}
G[25341]={69,504932,504979}
G[25342]={69,504932,504979}
G[25344]={69,504932,504979}
G[25345]={69,504932,504979}
G[25346]={69,504932,504979}
G[25349]={69,504932,504979}
G[25350]={69,504932,504979}
G[25352]={198,504870}
G[25353]={198,504870}
G[25354]={198,504870}
G[25355]={198,504870}
G[25356]={64,504938}
G[25357]={201,504869,504982}
G[25358]={201,504869,504982}
G[25359]={205,504869,504982}
G[25360]={205,504869,504982}
G[25361]={69,504932,504979}
G[25362]={69,504932,504979}
G[25363]={69,504932,504979}
G[25364]={69,504932,504979}
G[25365]={69,504932,504979}
G[25366]={69,504932,504979}
G[25367]={69,504932,504979}
G[25368]={69,504932,504979}
G[25369]={69,504932,504979}
G[25370]={198,504870}
G[25371]={201,504869,504982}
G[25372]={198,504870}
G[25373]={69,504932,504979}
G[25374]={69,504932,504979}
G[25375]={69,504932,504979}
G[25377]={201,504869,504982}
G[25378]={69,504932,504979}
G[25379]={69,504932,504979}
G[25381]={198,504870}
G[25382]={198,504870}
G[25383]={69,504932,504979}
G[25385]={198,504870}
G[25386]={69,504932,504979}
G[25387]={69,504932,504979}
G[25388]={201,504869,504982}
G[25389]={201,504869,504982}
G[25390]={201,504869,504982}
G[25391]={69,504932,504979}
G[25392]={198,504870}
G[25394]={69,504932,504979}
G[25395]={56,504899}
G[25396]={69,504932,504979}
G[25397]={69,504932,504979}
G[25398]={69,504932,504979}
G[25399]={69,504932,504979}
G[25400]={69,504932,504979}
G[25401]={69,504932,504979}
G[25402]={69,504932,504979}
G[25403]={69,504932,504979}
G[25404]={198,504870}
G[25405]={201,504869,504982}
G[25406]={69,504932,504979}
G[25407]={69,504932,504979}
G[25408]={198,504870}
G[25409]={69,504932,504979}
G[25410]={69,504932,504979}
G[25411]={198,504870}
G[25412]={198,504870}
G[25420]={71,504935}
G[25421]={71,504935}
G[25422]={69,504932,504979}
G[25423]={69,504932,504979}
G[25424]={198,504870}
G[25426]={69,504932,504979}
G[25427]={69,504932,504979}
G[25428]={198,504870}
G[25429]={69,504932,504979}
G[25430]={198,504870}
G[25431]={69,504932,504979}
G[25432]={69,504932,504979}
G[25433]={69,504932,504979}
G[25434]={69,504932,504979}
G[25436]={69,504932,504979}
G[25437]={69,504932,504979}
G[25438]={69,504932,504979}
G[25439]={205,504869,504982}
G[25440]={205,504869,504982}
G[25441]={205,504869,504982}
G[25442]={205,504869,504982}
G[25447]={69,504932,504979}
G[25448]={69,504932,504979}
G[25449]={69,504932,504979}
G[25450]={69,504932,504979}
G[25451]={69,504932,504979}
G[25452]={69,504932,504979}
G[25453]={69,504932,504979}
G[25454]={69,504932,504979}
G[25456]={205,504869,504982}
G[25458]={69,504932,504979}
G[25459]={201,504869,504982}
G[25460]={198,504870}
G[25462]={198,504870}
G[25463]={69,504932,504979}
G[25464]={198,504870}
G[25465]={69,504932,504979}
G[25466]={69,504932,504979}
G[25467]={201,504869,504982}
G[25468]={69,504932,504979}
G[25469]={69,504932,504979}
G[25471]={205,504869,504982}
G[25472]={198,504870}
G[25475]={69,504932,504979}
G[25476]={69,504932,504979}
G[25477]={201,504869,504982}
G[25478]={64,504938}
G[25479]={69,504932,504979}
G[25481]={69,504932,504979}
G[25486]={69,504932,504979}
G[25487]={64,504938}
G[25488]={64,504938}
G[25489]={64,504938}
G[25490]={198,504870}
G[25491]={198,504870}
G[25492]={198,504870}
G[25493]={198,504870}
G[25494]={198,504870}
G[25496]={198,504870}
G[25499]={198,504870}
G[25502]={198,504870}
G[25503]={201,504869,504982}
G[25504]={64,504938}
G[25505]={64,504938}
G[25507]={198,504870}
G[25509]={198,504870}
G[25510]={198,504870}
G[25513]={71,504935}
G[25514]={198,504870}
G[25515]={64,504938}
G[25516]={64,504938}
G[25517]={64,504938}
G[25518]={64,504938}
G[25519]={198,504870}
G[25520]={198,504870}
G[25521]={71,504935}
G[25522]={71,504935}
G[25523]={198,504870}
G[25524]={64,504938}
G[25525]={198,504870}
G[25526]={64,504938}
G[25531]={198,504870}
G[25534]={71,504935}
G[25535]={205,504869,504982}
G[25536]={205,504869,504982}
G[25537]={205,504869,504982}
G[25538]={205,504869,504982}
G[25539]={205,504869,504982}
G[25540]={205,504869,504982}
G[25541]={71,504935}
G[25542]={64,504938}
G[25543]={64,504938}
G[25544]={198,504870}
G[25545]={201,504869,504982}
G[25546]={201,504869,504982}
G[25547]={201,504869,504982}
G[25548]={198,504870}
G[25552]={198,504870}
G[25554]={198,504870}
G[25555]={198,504870}
G[25556]={504956}
G[25558]={201,504869,504982}
G[25559]={71,504935}
G[25560]={198,504870}
G[25561]={64,504938}
G[25562]={64,504938}
G[25564]={201,504869,504982}
G[25565]={71,504935}
G[25566]={71,504935}
G[25574]={198,504870}
G[25575]={198,504870}
G[25576]={198,504870}
G[25577]={198,504870}
G[25578]={198,504870}
G[25579]={205,504869,504982}
G[25580]={205,504869,504982}
G[25581]={205,504869,504982}
G[25582]={205,504869,504982}
G[25583]={205,504869,504982}
G[25584]={198,504870}
G[25585]={64,504938}
G[25586]={64,504938}
G[25587]={201,504869,504982}
G[25588]={64,504938}
G[25589]={64,504938}
G[25590]={64,504938}
G[25591]={71,504935}
G[25592]={205,504869,504982}
G[25593]={205,504869,504982}
G[25594]={205,504869,504982}
G[25595]={205,504869,504982}
G[25596]={64,504938}
G[25597]={198,504870}
G[25598]={201,504869,504982}
G[25599]={198,504870}
G[25600]={198,504870}
G[25601]={198,504870}
G[25602]={201,504869,504982}
G[25607]={63,504925}
G[25608]={198,504870}
G[25609]={64,504938}
G[25610]={64,504938}
G[25611]={198,504870}
G[25612]={198,504870}
G[25613]={65,504936,504980}
G[25614]={65,504936,504980}
G[25615]={65,504936,504980}
G[25616]={65,504936,504980}
G[25617]={198,504870}
G[25618]={198,504870}
G[25619]={205,504869,504982}
G[25620]={205,504869,504982}
G[25621]={65,504936,504980}
G[25622]={65,504936,504980}
G[25623]={198,504870}
G[25624]={198,504870}
G[25626]={205,504869,504982}
G[25627]={64,504938}
G[25628]={64,504938}
G[25629]={205,504869,504982}
G[25630]={198,504870}
G[25637]={205,504869,504982}
G[25638]={201,504869,504982}
G[25640]={65,504936,504980}
G[25641]={69,504932,504979}
G[25642]={65,504936,504980}
G[25643]={69,504932,504979}
G[25644]={198,504870}
G[25645]={69,504932,504979}
G[25646]={65,504936,504980}
G[25647]={65,504936,504980}
G[25649]={65,504936,504980}
G[25650]={65,504936,504980}
G[25651]={201,504869,504982}
G[25652]={65,504936,504980}
G[25653]={198,504870}
G[25654]={69,504932,504979}
G[25655]={198,504870}
G[25656]={198,504870}
G[25657]={201,504869,504982}
G[25658]={205,504869,504982}
G[25659]={205,504869,504982}
G[25660]={64,504938}
G[25661]={64,504938}
G[25662]={65,504936,504980}
G[25663]={198,504870}
G[25664]={198,504870}
G[25665]={198,504870}
G[25669]={65,504936,504980}
G[25670]={201,504869,504982}
G[25671]={65,504936,504980}
G[25672]={64,504938}
G[25673]={65,504936,504980}
G[25674]={17,504909}
G[25675]={17,504909}
G[25676]={17,504909}
G[25677]={17,504909}
G[25678]={17,504909}
G[25679]={17,504909}
G[25680]={17,504909}
G[25681]={17,504909}
G[25682]={17,504909}
G[25683]={17,504909}
G[25684]={17,504909}
G[25685]={17,504909}
G[25686]={17,504909}
G[25687]={17,504909}
G[25688]={17,504909}
G[25689]={17,504909}
G[25690]={17,504909}
G[25691]={17,504909}
G[25692]={17,504909}
G[25693]={17,504909}
G[25694]={17,504909}
G[25695]={17,504909}
G[25696]={17,504909}
G[25697]={17,504909}
G[25698]={17,504909}
G[25699]={17,504909}
G[25700]={17,504909}
G[25701]={17,504909}
G[25702]={17,504909}
G[25703]={17,504909}
G[25704]={64,504938}
G[25705]={17,504909}
G[25706]={17,504909}
G[25708]={17,504909}
G[25709]={17,504909}
G[25710]={17,504909}
G[25711]={17,504909}
G[25712]={17,504909}
G[25713]={17,504909}
G[25714]={17,504909}
G[25715]={17,504909}
G[25716]={17,504909}
G[25717]={17,504909}
G[25718]={17,504909}
G[25719]={17,504909}
G[25720]={17,504909}
G[25721]={56,504899}
G[25722]={56,504899}
G[25723]={56,504899}
G[25725]={56,504899}
G[25726]={56,504899}
G[25727]={56,504899}
G[25728]={65,504936,504980}
G[25729]={65,504936,504980}
G[25730]={65,504936,504980}
G[25731]={198,504870}
G[25732]={201,504869,504982}
G[25733]={56,504899}
G[25734]={56,504899}
G[25735]={56,504899}
G[25736]={56,504899}
G[25739]={65,504936,504980}
G[25740]={198,504870}
G[25741]={65,504936,504980}
G[25743]={201,504869,504982}
G[25744]={64,504938}
G[25745]={64,504938}
G[25746]={198,504870}
G[25747]={205,504869,504982}
G[25748]={205,504869,504982}
G[25749]={205,504869,504982}
G[25751]={205,504869,504982}
G[25752]={205,504869,504982}
G[25753]={205,504869,504982}
G[25754]={205,504869,504982}
G[25755]={205,504869,504982}
G[25756]={64,504938}
G[25757]={64,504938}
G[25758]={198,504870}
G[25760]={205,504869,504982}
G[25761]={198,504870}
G[25762]={64,504938}
G[25763]={198,504870}
G[25764]={198,504870}
G[25765]={65,504936,504980}
G[25766]={65,504936,504980}
G[25767]={65,504936,504980}
G[25768]={65,504936,504980}
G[25769]={65,504936,504980}
G[25770]={56,504899}
G[25771]={17,504909}
G[25774]={64,504938}
G[25775]={64,504938}
G[25776]={198,504870}
G[25777]={56,504899}
G[25778]={64,504938}
G[25779]={64,504938}
G[25780]={56,504899}
G[25790]={64,504938}
G[25791]={64,504938}
G[25793]={65,504936,504980}
G[25794]={201,504869,504982}
G[25795]={198,504870}
G[25796]={64,504938}
G[25797]={64,504938}
G[25798]={64,504938}
G[25799]={64,504938}
G[25800]={56,504899}
G[25801]={56,504899}
G[25802]={56,504899}
G[25803]={56,504899}
G[25804]={56,504899}
G[25805]={56,504899}
G[25806]={65,504936,504980}
G[25807]={198,504870}
G[25808]={65,504936,504980}
G[25809]={65,504936,504980}
G[25810]={198,504870}
G[25811]={65,504936,504980}
G[25812]={201,504869,504982}
G[25813]={64,504938}
G[25814]={64,504938}
G[25815]={56,504899}
G[25816]={56,504899}
G[25817]={56,504899}
G[25818]={56,504899}
G[25819]={56,504899}
G[25820]={56,504899}
G[25821]={65,504936,504980}
G[25822]={65,504936,504980}
G[25823]={65,504936,504980}
G[25824]={201,504869,504982}
G[25825]={64,504938}
G[25826]={64,504938}
G[25830]={198,504870}
G[25832]={198,504870}
G[25834]={65,504936,504980}
G[25835]={64,504938}
G[25836]={64,504938}
G[25837]={65,504936,504980}
G[25842]={198,504870}
G[25843]={198,504870}
G[25844]={65,504936,504980}
G[25845]={65,504936,504980}
G[25846]={65,504936,504980}
G[25847]={65,504936,504980}
G[25848]={65,504936,504980}
G[25849]={56,504899}
G[25850]={56,504899}
G[25851]={65,504936,504980}
G[25852]={65,504936,504980}
G[25853]={56,504899}
G[25854]={56,504899}
G[25855]={56,504899}
G[25856]={56,504899}
G[25857]={56,504899}
G[25858]={205,504869,504982}
G[25859]={205,504869,504982}
G[25860]={205,504869,504982}
G[25861]={205,504869,504982}
G[25862]={205,504869,504982}
G[25863]={205,504869,504982}
G[25864]={56,504899}
G[25865]={56,504899}
G[25866]={56,504899}
G[25867]={56,504899}
G[25868]={56,504899}
G[25869]={64,504938}
G[25870]={64,504938}
G[25871]={64,504938}
G[25872]={64,504938}
G[25873]={64,504938}
G[25874]={64,504938}
G[25875]={65,504936,504980}
G[25876]={65,504936,504980}
G[25877]={65,504936,504980}
G[25878]={65,504936,504980}
G[25879]={65,504936,504980}
G[25880]={65,504936,504980}
G[25881]={198,504870}
G[25883]={201,504869,504982}
G[25884]={201,504869,504982}
G[25885]={201,504869,504982}
G[25886]={198,504870}
G[25887]={201,504869,504982}
G[25888]={201,504869,504982}
G[25889]={65,504936,504980}
G[25890]={205,504869,504982}
G[25891]={65,504936,504980}
G[25892]={205,504869,504982}
G[25893]={205,504869,504982}
G[25894]={205,504869,504982}
G[25895]={205,504869,504982}
G[25896]={205,504869,504982}
G[25897]={205,504869,504982}
G[25898]={205,504869,504982}
G[25899]={198,504870}
G[25900]={205,504869,504982}
G[25901]={198,504870}
G[25904]={198,504870}
G[25906]={198,504870}
G[25907]={205,504869,504982}
G[25908]={205,504869,504982}
G[25909]={205,504869,504982}
G[25910]={198,504870}
G[25911]={205,504869,504982}
G[25912]={65,504936,504980}
G[25913]={65,504936,504980}
G[25914]={65,504936,504980}
G[25915]={198,504870}
G[25916]={205,504869,504982}
G[25917]={205,504869,504982}
G[25918]={205,504869,504982}
G[25919]={205,504869,504982}
G[25920]={205,504869,504982}
G[25921]={205,504869,504982}
G[25922]={205,504869,504982}
G[25923]={198,504870}
G[25925]={65,504936,504980}
G[25926]={56,504899}
G[25927]={56,504899}
G[25928]={198,504870}
G[25930]={65,504936,504980}
G[25931]={65,504936,504980}
G[25934]={65,504936,504980}
G[25935]={65,504936,504980}
G[25936]={201,504869,504982}
G[25938]={65,504936,504980}
G[25939]={56,504899}
G[25940]={198,504870}
G[25941]={201,504869,504982}
G[25942]={201,504869,504982}
G[25943]={201,504869,504982}
G[25944]={201,504869,504982}
G[25945]={65,504936,504980}
G[25946]={201,504869,504982}
G[25947]={201,504869,504982}
G[25948]={201,504869,504982}
G[25949]={201,504869,504982}
G[25950]={204,504869,504982}
G[25951]={205,504869,504982,505452}
G[25952]={205,504869,504982}
G[25953]={205,504869,504982}
G[25954]={205,504869,504982}
G[25955]={205,504869,504982}
G[25956]={205,504869,504982}
G[25957]={205,504869,504982}
G[25958]={205,504869,504982}
G[25959]={205,504869,504982}
G[25960]={205,504869,504982}
G[25962]={205,504869,504982}
G[25963]={205,504869,504982}
G[25964]={205,504869,504982}
G[25965]={205,504869,504982}
G[25966]={205,504869,504982}
G[25967]={205,504869,504982}
G[25968]={205,504869,504982}
G[25969]={205,504869,504982}
G[25970]={205,504869,504982}
G[25971]={205,504869,504982}
G[25972]={205,504869,504982}
G[25973]={205,504869,504982}
G[25974]={204,504869,504982}
G[25975]={204,504869,504982}
G[25976]={204,504869,504982}
G[25977]={204,504869,504982}
G[25980]={204,504869,504982}
G[25981]={204,504869,504982}
G[25982]={204,504869,504982}
G[25983]={204,504869,504982}
G[25984]={204,504869,504982}
G[25985]={198,504870}
G[25987]={204,504869,504982}
G[25988]={204,504869,504982}
G[25989]={205,504869,504982}
G[25990]={205,504869,504982}
G[25991]={205,504869,504982}
G[25992]={205,504869,504982}
G[25993]={205,504869,504982}
G[25994]={205,504869,504982}
G[25995]={205,504869,504982}
G[25996]={205,504869,504982}
G[25999]={65,504936,504980}
G[26000]={201,504869,504982}
G[26001]={65,504936,504980}
G[26002]={65,504936,504980}
G[26003]={65,504936,504980}
G[26004]={65,504936,504980}
G[26005]={205,504869,504982}
G[26006]={205,504869,504982}
G[26007]={201,504869,504982}
G[26008]={201,504869,504982}
G[26009]={65,504936,504980}
G[26010]={65,504936,504980}
G[26011]={65,504936,504980}
G[26014]={204,504869,504982}
G[26015]={204,504869,504982}
G[26016]={65,504936,504980}
G[26017]={204,504869,504982}
G[26018]={204,504869,504982}
G[26019]={204,504869,504982}
G[26020]={65,504936,504980}
G[26021]={204,504869,504982}
G[26022]={14,504896}
G[26023]={14,504896}
G[26024]={14,504896}
G[26025]={14,504896}
G[26026]={65,504936,504980}
G[26027]={14,504896}
G[26028]={65,504936,504980}
G[26029]={14,504896}
G[26030]={14,504896}
G[26031]={14,504896}
G[26032]={14,504896}
G[26033]={14,504896}
G[26035]={14,504896}
G[26036]={14,504896}
G[26037]={14,504896}
G[26038]={14,504896}
G[26039]={14,504896}
G[26040]={201,504869,504982}
G[26041]={14,504896}
G[26042]={14,504896}
G[26043]={65,504936,504980}
G[26044]={65,504936,504980}
G[26045]={65,504936,504980}
G[26046]={65,504936,504980}
G[26047]={65,504936,504980}
G[26048]={65,504936,504980}
G[26049]={14,504896}
G[26050]={14,504896}
G[26051]={14,504896}
G[26052]={14,504896}
G[26053]={14,504896}
G[26055]={14,504896}
G[26056]={204,504869,504982}
G[26057]={204,504869,504982}
G[26058]={65,504936,504980}
G[26059]={65,504936,504980}
G[26060]={65,504936,504980}
G[26061]={65,504936,504980}
G[26062]={65,504936,504980}
G[26063]={65,504936,504980}
G[26064]={65,504936,504980}
G[26065]={204,504869,504982}
G[26066]={65,504936,504980}
G[26067]={65,504936,504980}
G[26068]={65,504936,504980}
G[26069]={65,504936,504980}
G[26070]={204,504869,504982}
G[26071]={204,504869,504982}
G[26072]={204,504869,504982}
G[26073]={65,504936,504980}
G[26074]={65,504936,504980}
G[26075]={65,504936,504980}
G[26076]={65,504936,504980}
G[26077]={65,504936,504980}
G[26079]={14,504896}
G[26080]={204,504869,504982}
G[26081]={14,504896}
G[26082]={65,504936,504980}
G[26083]={14,504896}
G[26084]={14,504896}
G[26086]={204,504869,504982}
G[26087]={204,504869,504982}
G[26088]={204,504869,504982}
G[26089]={204,504869,504982}
G[26090]={204,504869,504982}
G[26091]={204,504869,504982}
G[26092]={204,504869,504982}
G[26093]={14,504896}
G[26095]={14,504896}
G[26096]={204,504869,504982}
G[26097]={65,504936,504980}
G[26098]={65,504936,504980}
G[26099]={65,504936,504980}
G[26100]={65,504936,504980}
G[26101]={65,504936,504980}
G[26103]={204,504869,504982}
G[26105]={204,504869,504982}
G[26106]={204,504869,504982}
G[26107]={14,504896}
G[26108]={14,504896}
G[26110]={14,504896}
G[26111]={204,504869,504982}
G[26113]={14,504896}
G[26114]={14,504896}
G[26115]={65,504936,504980}
G[26116]={14,504896}
G[26117]={14,504896}
G[26120]={56,504899}
G[26122]={204,504869,504982}
G[26125]={204,504869,504982}
G[26126]={204,504869,504982}
G[26127]={56,504899}
G[26128]={56,504899}
G[26130]={204,504869,504982}
G[26132]={204,504869,504982}
G[26133]={204,504869,504982}
G[26134]={65,504936,504980}
G[26135]={205,504869,504982}
G[26137]={56,504899}
G[26139]={14,504896}
G[26140]={204,504869,504982}
G[26141]={204,504869,504982}
G[26142]={204,504869,504982}
G[26143]={204,504869,504982}
G[26145]={48,504899}
G[26146]={48,504899}
G[26147]={48,504899}
G[26148]={48,504899}
G[26153]={505474}
G[26157]={17,504909}
G[26158]={17,504909}
G[26159]={17,504909}
G[26160]={17,504909}
G[26161]={17,504909}
G[26162]={17,504909}
G[26163]={17,504909}
G[26164]={17,504909}
G[26165]={17,504909}
G[26166]={17,504909}
G[26167]={17,504909}
G[26168]={17,504909}
G[26169]={17,504909}
G[26170]={17,504909}
G[26171]={17,504909}
G[26172]={17,504909}
G[26173]={17,504909}
G[26174]={17,504909}
G[26175]={17,504909}
G[26176]={48,504899}
G[26177]={505474}
G[26182]={204,504869,504982}
G[26183]={505474}
G[26184]={17,504909}
G[26185]={17,504909}
G[26186]={17,504909}
G[26187]={17,504909}
G[26189]={56,504899}
G[26190]={505474}
G[26191]={205,504869,504982}
G[26192]={505474}
G[26193]={204,504869,504982,505318}
G[26194]={204,504869,504982,505319}
G[26195]={56,504899}
G[26196]={56,504899}
G[26209]={52,504903}
G[26210]={26,504897}
G[26211]={26,504897}
G[26212]={26,504897}
G[26213]={52,504903}
G[26214]={52,504903}
G[26215]={52,504903}
G[26219]={204,504869,504982}
G[26220]={505475}
G[26221]={204,504869,504982}
G[26223]={26,504897}
G[26224]={26,504897}
G[26225]={26,504897}
G[26226]={505475}
G[26227]={505475}
G[26228]={52,504903}
G[26229]={52,504903}
G[26230]={52,504903}
G[26232]={52,504903}
G[26233]={505475}
G[26234]={505475}
G[26235]={505475}
G[26236]={52,504903}
G[26237]={52,504903}
G[26238]={26,504897}
G[26240]={26,504897}
G[26241]={52,504903}
G[26244]={207,504871}
G[26245]={207,504871}
G[26246]={207,504871}
G[26247]={207,504871}
G[26248]={207,504871}
G[26249]={207,504871}
G[26250]={207,504871}
G[26251]={207,504871}
G[26252]={52,504903}
G[26254]={207,504871}
G[26255]={207,504871}
G[26256]={207,504871}
G[26257]={52,504903}
G[26258]={207,504871}
G[26259]={207,504871}
G[26260]={207,504871}
G[26261]={207,504871}
G[26263]={26,504897}
G[26266]={52,504903}
G[26267]={26,504897}
G[26268]={26,504897}
G[26269]={50,504906}
G[26270]={52,504903}
G[26271]={52,504903}
G[26278]={50,504906}
G[26279]={50,504906}
G[26280]={50,504906}
G[26281]={50,504906}
G[26283]={26,504897}
G[26286]={52,504903}
G[26287]={52,504903}
G[26288]={52,504903}
G[26289]={52,504903}
G[26290]={52,504903}
G[26291]={52,504903}
G[26292]={52,504903}
G[26295]={52,504903}
G[26296]={52,504903}
G[26297]={52,504903}
G[26298]={50,504906}
G[26299]={50,504906}
G[26300]={50,504906}
G[26301]={50,504906}
G[26302]={50,504906}
G[26303]={50,504906}
G[26304]={50,504906}
G[26305]={50,504906}
G[26306]={26,504897}
G[26307]={26,504897}
G[26308]={26,504897}
G[26309]={26,504897}
G[26310]={26,504897}
G[26312]={207,504871}
G[26313]={207,504871}
G[26314]={207,504871}
G[26315]={207,504871}
G[26317]={50,504906}
G[26319]={52,504903}
G[26320]={52,504903}
G[26321]={50,504906}
G[26322]={52,504903}
G[26323]={50,504906}
G[26325]={50,504906}
G[26326]={207,504871}
G[26327]={56,504899}
G[26328]={207,504871}
G[26330]={50,504906}
G[26332]={50,504906}
G[26334]={50,504906}
G[26335]={76,504927}
G[26336]={14,504896}
G[26337]={76,504927}
G[26338]={50,504906}
G[26340]={50,504906}
G[26341]={14,504896}
G[26343]={50,504906}
G[26344]={50,504906}
G[26345]={50,504906}
G[26346]={14,504896}
G[26347]={52,504903}
G[26348]={52,504903}
G[26349]={52,504903}
G[26350]={50,504906}
G[26351]={50,504906}
G[26352]={50,504906}
G[26353]={52,504903}
G[26354]={52,504903}
G[26355]={52,504903}
G[26356]={52,504903}
G[26357]={26,504897}
G[26359]={50,504906}
G[26360]={50,504906}
G[26361]={76,504927}
G[26362]={50,504906}
G[26363]={26,504897}
G[26365]={49,504902}
G[26366]={26,504897}
G[26367]={26,504897}
G[26368]={26,504897}
G[26369]={26,504897}
G[26370]={52,504903}
G[26371]={52,504903}
G[26372]={76,504927}
G[26374]={76,504927}
G[26375]={207,504871}
G[26376]={207,504871}
G[26377]={207,504871}
G[26381]={26,504897}
G[26382]={26,504897}
G[26384]={26,504897}
G[26386]={50,504906}
G[26387]={26,504897}
G[26388]={76,504927}
G[26399]={50,504906}
G[26400]={50,504906}
G[26401]={69,504932,504979}
G[26402]={69,504932,504979}
G[26403]={50,504906}
G[26404]={50,504906}
G[26405]={50,504906}
G[26406]={26,504897}
G[26407]={50,504906}
G[26408]={63,504925}
G[26409]={207,504871}
G[26410]={207,504871}
G[26411]={207,504871}
G[26413]={207,504871}
G[26414]={505476}
G[26416]={50,504906}
G[26417]={50,504906}
G[26418]={26,504897}
G[26419]={26,504897}
G[26420]={505476}
G[26426]={207,504871}
G[26427]={207,504871}
G[26428]={14,504896}
G[26429]={14,504896}
G[26430]={26,504897}
G[26432]={26,504897}
G[26433]={210,504905}
G[26434]={210,504905}
G[26435]={210,504905}
G[26436]={207,504871}
G[26437]={207,504871}
G[26438]={207,504871}
G[26439]={207,504871}
G[26440]={207,504871}
G[26441]={207,504871}
G[26442]={505476}
G[26443]={63,504925}
G[26444]={63,504925}
G[26445]={63,504925}
G[26446]={63,504925}
G[26447]={63,504925,504976}
G[26448]={63,504925,504976}
G[26449]={63,504925,504976}
G[26450]={210,504905}
G[26451]={210,504905}
G[26452]={210,504905}
G[26453]={63,504925}
G[26454]={63,504925}
G[26455]={63,504925}
G[26456]={63,504925}
G[26457]={63,504925}
G[26462]={26,504897}
G[26463]={63,504925}
G[26464]={63,504925}
G[26465]={63,504925}
G[26466]={63,504925}
G[26467]={63,504925}
G[26468]={63,504925}
G[26469]={63,504925}
G[26470]={63,504925}
G[26472]={63,504925}
G[26473]={63,504925}
G[26474]={63,504925}
G[26475]={63,504925}
G[26476]={63,504925}
G[26477]={63,504925}
G[26478]={63,504925}
G[26479]={63,504925}
G[26480]={63,504925}
G[26481]={63,504925}
G[26482]={63,504925}
G[26483]={26,504897}
G[26484]={207,504871}
G[26485]={26,504897}
G[26486]={26,504897}
G[26487]={210,504905}
G[26488]={505476}
G[26489]={210,504905}
G[26490]={26,504897}
G[26491]={26,504897}
G[26492]={26,504897}
G[26493]={210,504905}
G[26494]={210,504905}
G[26495]={210,504905}
G[26496]={26,504897}
G[26497]={26,504897}
G[26498]={26,504897}
G[26499]={207,504871}
G[26500]={207,504871}
G[26501]={207,504871}
G[26502]={207,504871}
G[26503]={49,504902}
G[26504]={49,504902}
G[26505]={49,504902}
G[26506]={49,504902}
G[26507]={207,504871}
G[26508]={49,504902}
G[26509]={49,504902}
G[26510]={49,504902}
G[26511]={49,504902}
G[26512]={49,504902}
G[26513]={49,504902}
G[26514]={49,504902}
G[26515]={26,504897}
G[26516]={26,504897}
G[26517]={26,504897}
G[26518]={26,504897}
G[26519]={49,504902}
G[26520]={49,504902}
G[26521]={26,504897}
G[26523]={26,504897}
G[26524]={26,504897}
G[26525]={26,504897}
G[26526]={26,504897}
G[26528]={26,504897}
G[26529]={26,504897}
G[26530]={26,504897}
G[26531]={26,504897}
G[26532]={26,504897}
G[26533]={210,504905}
G[26534]={210,504905}
G[26535]={210,504905}
G[26536]={505476}
G[26537]={207,504871}
G[26538]={241,504873,505501}
G[26539]={241,504873,505501}
G[26540]={241,504873,505501}
G[26542]={26,504897}
G[26543]={505477}
G[26544]={49,504902}
G[26545]={49,504902}
G[26546]={26,504897}
G[26547]={26,504897}
G[26548]={26,504897}
G[26549]={241,504873,505501}
G[26550]={210,504905}
G[26553]={210,504905}
G[26554]={210,504905}
G[26555]={210,504905}
G[26556]={505477}
G[26557]={505477}
G[26558]={26,504897}
G[26560]={49,504902}
G[26561]={49,504902}
G[26562]={49,504902}
G[26563]={49,504902}
G[26564]={207,504871}
G[26567]={49,504902}
G[26569]={49,504902}
G[26570]={49,504902}
G[26571]={49,504902}
G[26572]={505477}
G[26573]={49,504902}
G[26574]={69,504932,504979}
G[26575]={207,504871}
G[26576]={207,504871}
G[26577]={207,504871}
G[26578]={207,504871}
G[26579]={207,504871}
G[26580]={207,504871}
G[26581]={207,504871}
G[26582]={207,504871}
G[26583]={207,504871}
G[26584]={207,504871}
G[26585]={207,504871}
G[26586]={49,504902}
G[26587]={49,504902}
G[26588]={505477}
G[26590]={210,504905}
G[26591]={207,504871}
G[26592]={210,504905}
G[26593]={210,504905}
G[26594]={210,504905}
G[26595]={210,504905}
G[26596]={70,504929,504978}
G[26597]={210,504905}
G[26598]={210,504905}
G[26599]={210,504905}
G[26600]={210,504905}
G[26601]={210,504905}
G[26602]={210,504905}
G[26603]={210,504905}
G[26604]={210,504905}
G[26605]={210,504905}
G[26606]={210,504905}
G[26607]={49,504902}
G[26608]={241,504873,505501}
G[26609]={210,504905}
G[26610]={210,504905}
G[26611]={210,504905}
G[26612]={210,504905}
G[26613]={210,504905}
G[26614]={210,504905}
G[26616]={49,504902}
G[26617]={210,504905}
G[26618]={47,504903}
G[26619]={241,504873,505501}
G[26620]={47,504903}
G[26621]={241,504873,505501}
G[26622]={241,504873,505501}
G[26623]={47,504903}
G[26624]={210,504905}
G[26625]={207,504871}
G[26627]={47,504903}
G[26628]={14,504896}
G[26630]={210,504905}
G[26631]={210,504905}
G[26632]={207,504871}
G[26633]={210,504905}
G[26634]={210,504905}
G[26635]={210,504905}
G[26636]={49,504902}
G[26637]={49,504902}
G[26638]={49,504902}
G[26639]={49,504902}
G[26640]={49,504902}
G[26641]={26,504897}
G[26643]={26,504897}
G[26644]={210,504905}
G[26645]={47,504903}
G[26646]={49,504902}
G[26647]={210,504905}
G[26648]={210,504905}
G[26649]={210,504905}
G[26650]={210,504905}
G[26651]={49,504902}
G[26652]={47,504903}
G[26653]={47,504903}
G[26654]={47,504903}
G[26655]={47,504903}
G[26656]={207,504871}
G[26657]={207,504871}
G[26658]={207,504871}
G[26659]={207,504871}
G[26660]={47,504903}
G[26661]={47,504903}
G[26662]={210,504905}
G[26663]={210,504905}
G[26664]={210,504905}
G[26665]={210,504905}
G[26666]={47,504903}
G[26667]={47,504903}
G[26668]={49,504902}
G[26669]={47,504903}
G[26670]={47,504903}
G[26671]={47,504903}
G[26672]={47,504903}
G[26674]={47,504903}
G[26676]={47,504903}
G[26677]={47,504903}
G[26678]={210,504905}
G[26679]={210,504905}
G[26680]={47,504903}
G[26681]={47,504903}
G[26682]={70,504929,504978}
G[26683]={47,504903}
G[26684]={47,504903}
G[26685]={47,504903}
G[26686]={47,504903}
G[26687]={70,504929,504978}
G[26688]={47,504903}
G[26689]={47,504903}
G[26690]={47,504903}
G[26691]={47,504903}
G[26692]={49,504902}
G[26693]={49,504902}
G[26694]={49,504902}
G[26695]={210,504905}
G[26696]={70,504929,504978}
G[26697]={210,504905}
G[26698]={210,504905}
G[26699]={210,504905}
G[26700]={210,504905}
G[26701]={70,504929,504978}
G[26702]={70,504929,504978}
G[26703]={210,504905}
G[26707]={47,504903}
G[26708]={49,504902}
G[26709]={207,504871}
G[26713]={49,504902}
G[26714]={49,504902}
G[26717]={47,504903}
G[26719]={47,504903}
G[26720]={47,504903}
G[26721]={47,504903}
G[26722]={47,504903}
G[26723]={47,504903}
G[26724]={47,504903}
G[26725]={47,504903}
G[26726]={49,504902}
G[26727]={47,504903}
G[26728]={47,504903}
G[26729]={50,504906}
G[26730]={50,504906}
G[26731]={50,504906}
G[26732]={50,504906}
G[26733]={50,504906}
G[26734]={50,504906}
G[26735]={50,504906}
G[26736]={50,504906}
G[26737]={50,504906}
G[26738]={50,504906}
G[26739]={50,504906}
G[26740]={50,504906}
G[26742]={50,504906}
G[26743]={50,504906}
G[26744]={50,504906}
G[26745]={50,504906}
G[26746]={50,504906}
G[26747]={50,504906}
G[26748]={50,504906}
G[26749]={50,504906}
G[26750]={207,504871}
G[26751]={50,504906}
G[26752]={207,504871}
G[26753]={47,504903}
G[26754]={47,504903}
G[26755]={207,504871}
G[26760]={47,504903}
G[26761]={49,504902}
G[26762]={207,504871}
G[26763]={50,504906}
G[26765]={50,504906}
G[26766]={207,504871}
G[26768]={207,504871}
G[26769]={10,504933}
G[26770]={207,504871}
G[26771]={207,504871}
G[26772]={50,504906}
G[26773]={50,504906}
G[26774]={50,504906}
G[26775]={50,504906}
G[26776]={50,504906}
G[26777]={47,504903}
G[26778]={47,504903}
G[26779]={50,504906}
G[26780]={50,504906}
G[26781]={50,504906}
G[26782]={50,504906}
G[26783]={50,504906}
G[26784]={241,504873,505501}
G[26785]={47,504903}
G[26786]={241,504873,505501}
G[26787]={47,504903}
G[26788]={241,504873,505501}
G[26791]={207,504871}
G[26792]={207,504871}
G[26793]={47,504903}
G[26794]={47,504903}
G[26795]={47,504903}
G[26796]={47,504903}
G[26797]={47,504903}
G[26798]={241,504873,505501}
G[26805]={210,504905}
G[26808]={210,504905}
G[26809]={210,504905}
G[26812]={210,504905}
G[26813]={210,504905}
G[26814]={210,504905}
G[26815]={210,504905}
G[26816]={210,504905}
G[26817]={210,504905}
G[26818]={210,504905}
G[26819]={210,504905}
G[26820]={210,504905}
G[26821]={210,504905}
G[26822]={210,504905}
G[26823]={210,504905}
G[26824]={210,504905}
G[26825]={210,504905}
G[26826]={210,504905}
G[26827]={207,504871}
G[26828]={207,504871}
G[26829]={207,504871}
G[26831]={207,504871}
G[26832]={207,504871}
G[26833]={207,504871}
G[26834]={207,504871}
G[26835]={207,504871}
G[26836]={207,504871}
G[26838]={50,504906}
G[26842]={48,504899}
G[26843]={48,504899}
G[26844]={48,504899}
G[26845]={48,504899}
G[26846]={48,504899}
G[26857]={207,504871}
G[26860]={48,504899}
G[26861]={207,504871}
G[26863]={48,504899}
G[26864]={48,504899}
G[26865]={504956}
G[26866]={504956}
G[26868]={48,504899}
G[26869]={207,504871}
G[26871]={207,504871}
G[26875]={207,504871}
G[26876]={207,504871}
G[26878]={504956}
G[26886]={71,504935}
G[26887]={71,504935}
G[26889]={71,504935}
G[26890]={63,504925,504976}
G[26894]={504956}
G[26895]={71,504935}
G[26896]={71,504935}
G[26897]={504956}
G[26898]={504956}
G[26906]={504956}
G[26908]={504956}
G[26909]={14,504896}
G[26911]={14,504896}
G[26912]={14,504896}
G[26920]={22,504893}
G[26921]={22,504893}
G[26922]={22,504893}
G[26923]={22,504893}
G[26924]={22,504893}
G[26925]={22,504893}
G[26926]={22,504893}
G[26927]={48,504899}
G[26928]={48,504899}
G[26929]={48,504899}
G[26930]={22,504893}
G[26931]={22,504893}
G[26932]={48,504899}
G[26933]={22,504893}
G[26934]={22,504893}
G[26935]={22,504893}
G[26936]={22,504893}
G[26937]={22,504893}
G[26938]={22,504893}
G[26943]={504956}
G[26944]={504956}
G[26950]={504956}
G[26952]={22,504893}
G[26953]={22,504893}
G[26954]={22,504893}
G[26955]={22,504893}
G[26956]={22,504893}
G[26957]={22,504893}
G[26961]={48,504899}
G[26965]={21,504894}
G[26971]={207,504871}
G[26972]={504956}
G[26978]={22,504893}
G[26979]={22,504893}
G[26980]={56,504899}
G[26981]={56,504899}
G[26982]={504956}
G[26986]={504956}
G[26989]={21,504894}
G[26992]={21,504894}
G[26995]={21,504894}
G[26998]={21,504894}
G[26999]={22,504893}
G[27000]={22,504893}
G[27001]={22,504893}
G[27002]={22,504893}
G[27004]={207,504871}
G[27005]={207,504871}
G[27006]={207,504871}
G[27007]={207,504871}
G[27008]={207,504871}
G[27010]={207,504871}
G[27011]={22,504893}
G[27012]={22,504893}
G[27013]={22,504893}
G[27016]={48,504899}
G[27017]={22,504893}
G[27025]={48,504899}
G[27026]={48,504899}
G[27028]={48,504899}
G[27030]={48,504899}
G[27031]={48,504899}
G[27032]={48,504899}
G[27033]={48,504899}
G[27034]={48,504899}
G[27035]={48,504899}
G[27036]={48,504899}
G[27037]={48,504899}
G[27039]={21,504894}
G[27042]={207,504871}
G[27043]={207,504871}
G[27045]={21,504894}
G[27053]={22,504893}
G[27054]={22,504893}
G[27055]={22,504893}
G[27056]={21,504894}
G[27057]={22,504893}
G[27058]={207,504871}
G[27059]={207,504871}
G[27061]={207,504871}
G[27062]={504956}
G[27065]={21,504894}
G[27069]={21,504894}
G[27073]={21,504894}
G[27074]={48,504899}
G[27075]={48,504899}
G[27077]={48,504899}
G[27078]={48,504899}
G[27082]={21,504894}
G[27083]={22,504893}
G[27084]={22,504893}
G[27085]={22,504893}
G[27086]={22,504893}
G[27087]={22,504893}
G[27088]={21,504894}
G[27089]={22,504893}
G[27090]={22,504893}
G[27093]={21,504894}
G[27094]={21,504894}
G[27095]={21,504894}
G[27096]={21,504894}
G[27097]={21,504894}
G[27098]={21,504894}
G[27099]={21,504894}
G[27100]={207,504871}
G[27101]={207,504871}
G[27102]={207,504871}
G[27115]={48,504899}
G[27116]={48,504899}
G[27117]={22,504893}
G[27123]={207,504871}
G[27126]={207,504871}
G[27135]={207,504871}
G[27136]={207,504871}
G[27141]={249,504872}
G[27144]={22,504893}
G[27151]={22,504893}
G[27152]={22,504893}
G[27153]={22,504893}
G[27154]={22,504893}
G[27155]={22,504893}
G[27156]={22,504893}
G[27157]={22,504893}
G[27158]={22,504893}
G[27159]={22,504893}
G[27160]={22,504893}
G[27161]={22,504893}
G[27162]={22,504893}
G[27163]={22,504893}
G[27164]={22,504893}
G[27165]={22,504893}
G[27166]={22,504893}
G[27167]={22,504893}
G[27168]={22,504893}
G[27169]={22,504893}
G[27170]={22,504893}
G[27171]={22,504893}
G[27172]={22,504893}
G[27173]={22,504893}
G[27174]={22,504893}
G[27175]={22,504893}
G[27176]={249,504872}
G[27177]={241,504873,505501}
G[27178]={241,504873,505501}
G[27179]={249,504872}
G[27180]={21,504894}
G[27181]={21,504894}
G[27182]={70,504929,504978}
G[27183]={70,504929,504978}
G[27184]={70,504929,504978}
G[27186]={70,504929,504978}
G[27188]={70,504929,504978}
G[27189]={70,504929,504978}
G[27190]={70,504929,504978}
G[27191]={70,504929,504978}
G[27193]={21,504894}
G[27194]={21,504894}
G[27195]={21,504894}
G[27196]={249,504872}
G[27197]={22,504893}
G[27198]={22,504893}
G[27199]={22,504893}
G[27200]={241,504873,505501}
G[27201]={22,504893}
G[27202]={22,504893}
G[27204]={22,504893}
G[27205]={22,504893}
G[27206]={22,504893}
G[27210]={70,504929,504978}
G[27211]={70,504929,504978}
G[27212]={70,504929,504978}
G[27213]={70,504929,504978}
G[27214]={70,504929,504978}
G[27215]={70,504929,504978}
G[27216]={70,504929,504978}
G[27217]={70,504929,504978}
G[27218]={70,504929,504978}
G[27219]={70,504929,504978}
G[27220]={70,504929,504978}
G[27221]={70,504929,504978}
G[27222]={70,504929,504978}
G[27226]={21,504894}
G[27229]={70,504929,504978}
G[27231]={21,504894}
G[27232]={21,504894}
G[27233]={22,504893}
G[27234]={70,504929,504978}
G[27235]={70,504929,504978}
G[27236]={70,504929,504978}
G[27237]={70,504929,504978}
G[27238]={70,504929,504978}
G[27239]={70,504929,504978}
G[27240]={70,504929,504978}
G[27241]={70,504929,504978}
G[27242]={70,504929,504978}
G[27243]={70,504929,504978}
G[27244]={70,504929,504978}
G[27245]={70,504929,504978}
G[27246]={70,504929,504978}
G[27247]={70,504929,504978}
G[27248]={70,504929,504978}
G[27249]={70,504929,504978}
G[27251]={70,504929,504978}
G[27252]={70,504929,504978}
G[27253]={70,504929,504978}
G[27254]={70,504929,504978}
G[27255]={70,504929,504978}
G[27256]={70,504929,504978}
G[27257]={70,504929,504978}
G[27258]={70,504929,504978}
G[27259]={70,504929,504978}
G[27260]={70,504929,504978}
G[27261]={70,504929,504978}
G[27262]={70,504929,504978}
G[27263]={70,504929,504978}
G[27264]={70,504929,504978}
G[27275]={64,504938}
G[27276]={64,504938}
G[27284]={70,504929,504978}
G[27285]={70,504929,504978}
G[27286]={70,504929,504978}
G[27287]={70,504929,504978}
G[27288]={70,504929,504978}
G[27290]={21,504894}
G[27291]={70,504929,504978}
G[27292]={70,504929,504978}
G[27293]={70,504929,504978}
G[27294]={70,504929,504978}
G[27295]={70,504929,504978}
G[27296]={70,504929,504978}
G[27297]={70,504929,504978}
G[27299]={241,504873,505501}
G[27300]={241,504873,505501}
G[27301]={241,504873,505501}
G[27302]={241,504873,505501}
G[27303]={241,504873,505501}
G[27306]={70,504929,504978}
G[27310]={64,504938}
G[27311]={64,504938}
G[27312]={64,504938}
G[27313]={64,504938}
G[27314]={64,504938}
G[27315]={64,504938}
G[27316]={64,504938}
G[27317]={64,504938}
G[27318]={64,504938}
G[27319]={64,504938}
G[27320]={64,504938}
G[27321]={64,504938}
G[27322]={21,504894}
G[27323]={64,504938}
G[27324]={64,504938}
G[27325]={64,504938}
G[27326]={64,504938}
G[27327]={64,504938}
G[27328]={64,504938}
G[27329]={64,504938}
G[27330]={64,504938}
G[27333]={21,504894}
G[27336]={70,504929,504978}
G[27338]={241,504873,505501}
G[27339]={70,504929,504978}
G[27340]={70,504929,504978}
G[27341]={241,504873,505501}
G[27342]={21,504894}
G[27345]={21,504894}
G[27346]={70,504929,504978}
G[27347]={70,504929,504978}
G[27348]={70,504929,504978}
G[27349]={21,504894}
G[27350]={21,504894}
G[27357]={64,504938}
G[27358]={64,504938}
G[27360]={21,504894}
G[27364]={21,504894}
G[27366]={241,504873,505501}
G[27367]={23,504892}
G[27368]={23,504892}
G[27369]={23,504892}
G[27370]={23,504892}
G[27371]={23,504892}
G[27372]={23,504892}
G[27374]={241,504873,505501}
G[27375]={241,504873,505501}
G[27376]={241,504873,505501}
G[27377]={241,504873,505501}
G[27378]={241,504873,505501}
G[27379]={241,504873,505501}
G[27380]={241,504873,505501}
G[27381]={23,504892}
G[27382]={23,504892}
G[27383]={23,504892}
G[27384]={23,504892}
G[27385]={23,504892}
G[27386]={23,504892}
G[27387]={23,504892}
G[27388]={23,504892}
G[27389]={23,504892}
G[27390]={23,504892}
G[27391]={23,504892}
G[27392]={23,504892}
G[27393]={205,504869,504982}
G[27394]={205,504869,504982}
G[27401]={21,504894}
G[27405]={21,504894}
G[27406]={21,504894}
G[27407]={70,504929,504978}
G[27408]={70,504929,504978}
G[27409]={70,504929,504978}
G[27410]={70,504929,504978}
G[27411]={70,504929,504978}
G[27412]={70,504929,504978}
G[27413]={70,504929,504978}
G[27414]={70,504929,504978}
G[27415]={70,504929,504978}
G[27416]={70,504929,504978}
G[27417]={70,504929,504978}
G[27418]={70,504929,504978}
G[27420]={23,504892}
G[27421]={23,504892}
G[27422]={504956}
G[27423]={21,504894}
G[27424]={70,504929,504978}
G[27425]={70,504929,504978}
G[27426]={70,504929,504978}
G[27427]={70,504929,504978}
G[27428]={70,504929,504978}
G[27429]={70,504929,504978}
G[27430]={70,504929,504978}
G[27431]={249,504872}
G[27432]={23,504892}
G[27433]={241,504873,505501}
G[27438]={21,504894}
G[27446]={71,504935}
G[27447]={71,504935}
G[27448]={23,504892}
G[27449]={23,504892}
G[27450]={23,504892}
G[27451]={23,504892}
G[27452]={23,504892}
G[27453]={23,504892}
G[27454]={23,504892}
G[27455]={23,504892}
G[27456]={23,504892}
G[27457]={23,504892}
G[27458]={23,504892}
G[27459]={23,504892}
G[27460]={23,504892}
G[27461]={23,504892}
G[27462]={23,504892}
G[27463]={23,504892}
G[27464]={23,504892}
G[27465]={23,504892}
G[27466]={23,504892}
G[27467]={23,504892}
G[27468]={241,504873,505501}
G[27470]={504956}
G[27472]={21,504894}
G[27474]={21,504894}
G[27475]={21,504894}
G[27476]={21,504894}
G[27477]={23,504892}
G[27479]={23,504892}
G[27480]={25,504895}
G[27481]={23,504892}
G[27485]={241,504873,505501}
G[27486]={241,504873,505501}
G[27487]={23,504892}
G[27488]={23,504892}
G[27489]={23,504892}
G[27490]={241,504873,505501}
G[27491]={241,504873,505501}
G[27492]={241,504873,505501}
G[27493]={241,504873,505501}
G[27496]={241,504873,505501}
G[27497]={241,504873,505501}
G[27500]={241,504873,505501}
G[27501]={241,504873,505501}
G[27504]={241,504873,505501}
G[27505]={241,504873,505501}
G[27506]={241,504873,505501}
G[27507]={241,504873,505501}
G[27508]={241,504873,505501}
G[27509]={241,504873,505501}
G[27510]={21,504894}
G[27511]={249,504872}
G[27512]={21,504894}
G[27513]={21,504894}
G[27514]={241,504873,505501}
G[27515]={241,504873,505501}
G[27516]={241,504873,505501}
G[27517]={249,504872}
G[27518]={21,504894}
G[27519]={249,504872}
G[27520]={249,504872}
G[27521]={23,504892}
G[27522]={23,504892}
G[27523]={23,504892}
G[27524]={23,504892}
G[27525]={23,504892}
G[27526]={23,504892}
G[27527]={23,504892}
G[27528]={23,504892}
G[27529]={23,504892}
G[27530]={23,504892}
G[27531]={23,504892}
G[27532]={23,504892}
G[27533]={23,504892}
G[27534]={23,504892}
G[27535]={23,504892}
G[27536]={51,504904}
G[27537]={241,504873,505501}
G[27538]={241,504873,505501}
G[27539]={23,504892}
G[27541]={249,504872}
G[27542]={21,504894}
G[27544]={23,504892}
G[27545]={241,504873,505501}
G[27547]={21,504894}
G[27548]={21,504894}
G[27549]={249,504872}
G[27550]={21,504894}
G[27551]={23,504892}
G[27555]={23,504892}
G[27558]={23,504892}
G[27560]={23,504892}
G[27562]={23,504892}
G[27564]={241,504873,505501}
G[27576]={241,504873,505501}
G[27577]={21,504894}
G[27580]={21,504894}
G[27583]={241,504873,505501}
G[27584]={241,504873,505501}
G[27586]={241,504873,505501}
G[27587]={51,504904}
G[27592]={51,504904}
G[27595]={249,504872}
G[27597]={51,504904}
G[27598]={51,504904}
G[27599]={51,504904}
G[27600]={51,504904}
G[27602]={249,504872}
G[27606]={241,504873,505501}
G[27607]={241,504873,505501}
G[27610]={241,504873,505501}
G[27611]={241,504873,505501}
G[27612]={23,504892}
G[27613]={23,504892}
G[27614]={23,504892}
G[27615]={23,504892}
G[27616]={23,504892}
G[27617]={23,504892}
G[27618]={23,504892}
G[27619]={23,504892}
G[27620]={23,504892}
G[27621]={241,504873,505501}
G[27622]={241,504873,505501}
G[27623]={249,504872}
G[27624]={249,504872}
G[27625]={26,504897}
G[27626]={26,504897}
G[27628]={249,504872}
G[27629]={249,504872}
G[27630]={249,504872}
G[27631]={249,504872}
G[27632]={249,504872}
G[27636]={241,504873,505501}
G[27640]={241,504873,505501}
G[27641]={241,504873,505501}
G[27642]={241,504873,505501}
G[27643]={241,504873,505501}
G[27644]={241,504873,505501}
G[27645]={241,504873,505501}
G[27646]={241,504873,505501}
G[27647]={241,504873,505501}
G[27648]={241,504873,505501}
G[27649]={241,504873,505501}
G[27650]={241,504873,505501}
G[27651]={241,504873,505501}
G[27652]={241,504873,505501}
G[27653]={241,504873,505501}
G[27654]={241,504873,505501}
G[27655]={241,504873,505501}
G[27656]={51,504904}
G[27657]={241,504873,505501}
G[27658]={241,504873,505501}
G[27659]={241,504873,505501}
G[27660]={241,504873,505501}
G[27661]={241,504873,505501}
G[27662]={241,504873,505501}
G[27663]={51,504904}
G[27668]={201,504869,504982}
G[27669]={249,504872}
G[27683]={23,504892}
G[27684]={23,504892}
G[27685]={201,504869,504982}
G[27687]={201,504869,504982}
G[27688]={241,504873,505501}
G[27689]={241,504873,505501}
G[27690]={241,504873,505501}
G[27691]={51,504904}
G[27692]={504956}
G[27694]={51,504904}
G[27696]={241,504873,505501}
G[27699]={201,504869,504982}
G[27701]={241,504873,505501}
G[27703]={241,504873,505501}
G[27704]={51,504904}
G[27705]={51,504904}
G[27706]={249,504872}
G[27708]={201,504869,504982}
G[27713]={15,504900}
G[27714]={15,504900}
G[27715]={15,504900}
G[27716]={205,504869,504982}
G[27717]={205,504869,504982}
G[27725]={26,504897}
G[27738]={249,504872}
G[27740]={51,504904}
G[27747]={241,504873,505501}
G[27750]={241,504873,505501}
G[27751]={241,504873,505501}
G[27752]={241,504873,505501}
G[27753]={241,504873,505501}
G[27754]={241,504873,505501}
G[27755]={249,504872}
G[27756]={504956}
G[27757]={51,504904}
G[27760]={249,504872}
G[27761]={249,504872}
G[27762]={15,504900}
G[27763]={15,504900}
G[27764]={15,504900}
G[27765]={15,504900}
G[27766]={15,504900}
G[27769]={15,504900}
G[27770]={15,504900}
G[27771]={15,504900}
G[27772]={15,504900}
G[27774]={15,504900}
G[27775]={15,504900}
G[27776]={15,504900}
G[27777]={249,504872}
G[27778]={249,504872}
G[27779]={249,504872}
G[27787]={505320}
G[27788]={505321}
G[27789]={15,504900}
G[27790]={504956}
G[27791]={15,504900}
G[27792]={15,504900}
G[27794]={15,504900}
G[27795]={51,504904}
G[27796]={15,504900}
G[27797]={15,504900}
G[27798]={241,504873,505501}
G[27803]={241,504873,505501}
G[27804]={241,504873,505501}
G[27805]={241,504873,505501}
G[27806]={241,504873,505501}
G[27807]={241,504873,505501}
G[27808]={241,504873,505501}
G[27809]={241,504873,505501}
G[27810]={241,504873,505501}
G[27811]={241,504873,505501}
G[27812]={241,504873,505501}
G[27813]={241,504873,505501}
G[27814]={241,504873,505501}
G[27815]={241,504873,505501}
G[27816]={241,504873,505501}
G[27817]={241,504873,505501}
G[27818]={51,504904}
G[27821]={51,504904}
G[27822]={51,504904}
G[27823]={15,504900}
G[27824]={15,504900}
G[27825]={15,504900}
G[27826]={15,504900}
G[27827]={15,504900}
G[27828]={15,504900}
G[27829]={15,504900}
G[27830]={15,504900}
G[27831]={15,504900}
G[27832]={15,504900}
G[27833]={15,504900}
G[27834]={15,504900}
G[27835]={15,504900}
G[27836]={249,504872}
G[27837]={249,504872}
G[27838]={249,504872}
G[27839]={249,504872}
G[27840]={51,504904}
G[27843]={51,504904}
G[27845]={51,504904}
G[27849]={51,504904}
G[27851]={51,504904}
G[27852]={51,504904}
G[27853]={51,504904}
G[27854]={51,504904}
G[27855]={51,504904}
G[27856]={51,504904}
G[27857]={51,504904}
G[27859]={15,504900}
G[27860]={51,504904}
G[27863]={241,504873,505501}
G[27864]={241,504873,505501}
G[27865]={241,504873,505501}
G[27867]={241,504873,505501}
G[27868]={241,504873,505501,504960}
G[27869]={51,504904}
G[27870]={51,504904}
G[27871]={51,504904}
G[27874]={198,504870}
G[27875]={51,504904}
G[27876]={51,504904}
G[27877]={15,504900}
G[27878]={15,504900}
G[27879]={15,504900}
G[27880]={15,504900}
G[27881]={15,504900}
G[27882]={15,504900}
G[27883]={15,504900}
G[27884]={15,504900}
G[27888]={15,504900}
G[27889]={15,504900}
G[27890]={15,504900}
G[27891]={15,504900}
G[27892]={15,504900}
G[27893]={15,504900}
G[27894]={15,504900}
G[27895]={15,504900}
G[27896]={15,504900}
G[27897]={15,504900}
G[27899]={249,504872}
G[27900]={249,504872}
G[27901]={249,504872}
G[27902]={51,504904}
G[27903]={249,504872}
G[27904]={51,504904}
G[27905]={249,504872}
G[27906]={51,504904}
G[27907]={51,504904}
G[27908]={51,504904}
G[27909]={51,504904}
G[27910]={51,504904}
G[27911]={51,504904}
G[27912]={15,504900}
G[27913]={15,504900}
G[27914]={51,504904}
G[27915]={504956}
G[27916]={51,504904}
G[27917]={504956}
G[27918]={51,504904}
G[27919]={17,504909}
G[27922]={249,504872}
G[27923]={249,504872}
G[27924]={249,504872}
G[27926]={249,504872}
G[27927]={15,504900}
G[27928]={249,504872}
G[27929]={241,504873,505501}
G[27930]={15,504900}
G[27931]={207,504871}
G[27932]={207,504871}
G[27933]={207,504871}
G[27935]={207,504871}
G[27936]={207,504871}
G[27937]={207,504871}
G[27938]={207,504871}
G[27939]={249,504872}
G[27941]={249,504872}
G[27942]={249,504872}
G[27943]={249,504872}
G[27944]={505718}
G[27945]={241,504873,505501}
G[27947]={241,504873,505501}
G[27948]={505718}
G[27949]={505718}
G[27951]={241,504873,505501}
G[27952]={207,504871}
G[27953]={207,504871}
G[27954]={241,504873,505501}
G[27955]={241,504873,505501}
G[27956]={32,504910}
G[27957]={32,504910}
G[27958]={32,504910}
G[27960]={32,504910}
G[27961]={32,504910}
G[27962]={32,504910}
G[27963]={32,504910}
G[27964]={32,504910}
G[27965]={32,504910}
G[27966]={505718}
G[27967]={505718}
G[27969]={249,504872}
G[27970]={505718}
G[27971]={505718}
G[27972]={505718}
G[27973]={505718}
G[27974]={504956}
G[27975]={505718}
G[27976]={32,504910}
G[27977]={32,504910}
G[27978]={505718}
G[27979]={32,504910}
G[27980]={32,504910}
G[27981]={32,504910}
G[27982]={32,504910}
G[27984]={32,504910}
G[27986]={32,504910}
G[27987]={505718}
G[27989]={77,504931}
G[27990]={249,504872}
G[27991]={505718}
G[27992]={505718}
G[27993]={249,504872}
G[27994]={77,504931}
G[27995]={77,504931}
G[27997]={77,504931}
G[27999]={241,504873,505501}
G[28000]={77,504931}
G[28001]={241,504873,505501}
G[28002]={249,504872}
G[28028]={32,504910}
G[28029]={32,504910}
G[28030]={32,504910}
G[28031]={64,504938}
G[28032]={32,504910}
G[28033]={32,504910}
G[28034]={32,504910}
G[28035]={32,504910}
G[28038]={241,504873,505501}
G[28041]={241,504873,505501}
G[28042]={64,504938}
G[28043]={241,504873,505501}
G[28044]={77,504931}
G[28045]={64,504938}
G[28046]={505718}
G[28047]={64,504938}
G[28048]={64,504938}
G[28049]={77,504931}
G[28050]={505718}
G[28051]={64,504938}
G[28052]={32,504910}
G[28053]={32,504910}
G[28054]={32,504910}
G[28055]={32,504910}
G[28056]={32,504910}
G[28057]={32,504910}
G[28058]={32,504910}
G[28059]={505718}
G[28060]={32,504910}
G[28063]={505718}
G[28064]={32,504910}
G[28068]={504956}
G[28069]={504956}
G[28084]={65,504936,504980}
G[28085]={64,504938}
G[28086]={64,504938}
G[28087]={64,504938}
G[28088]={64,504938}
G[28090]={241,504873,505501}
G[28091]={241,504873,505501}
G[28092]={241,504873,505501}
G[28093]={241,504873,505501}
G[28094]={241,504873,505501}
G[28096]={25,504895}
G[28097]={241,504873,505501}
G[28098]={64,504938}
G[28099]={32,504910}
G[28100]={77,504931}
G[28101]={241,504873,505501}
G[28102]={77,504931}
G[28103]={241,504873,505501}
G[28104]={241,504873,505501}
G[28105]={249,504872}
G[28107]={241,504873,505501}
G[28108]={241,504873,505501}
G[28109]={241,504873,505501}
G[28111]={25,504895}
G[28112]={249,504872}
G[28113]={77,504931}
G[28114]={25,504895}
G[28115]={25,504895}
G[28116]={77,504931}
G[28117]={505718}
G[28118]={505718}
G[28119]={77,504931}
G[28120]={505718}
G[28121]={77,504931}
G[28122]={505718}
G[28123]={241,504873,505501}
G[28124]={64,504938}
G[28125]={64,504938}
G[28126]={77,504931}
G[28127]={64,504938}
G[28128]={77,504931}
G[28129]={77,504931}
G[28130]={505718}
G[28131]={77,504931}
G[28132]={249,504872}
G[28133]={241,504873,505501}
G[28135]={249,504872}
G[28136]={64,504938}
G[28137]={505718}
G[28138]={25,504895}
G[28139]={64,504938}
G[28141]={249,504872}
G[28142]={64,504938}
G[28144]={25,504895}
G[28145]={249,504872}
G[28146]={25,504895}
G[28147]={241,504873,505501}
G[28148]={77,504931}
G[28149]={241,504873,505501}
G[28150]={77,504931}
G[28151]={241,504873,505501}
G[28152]={77,504931}
G[28153]={77,504931}
G[28154]={25,504895}
G[28155]={77,504931}
G[28156]={25,504895}
G[28157]={64,504938}
G[28158]={64,504938}
G[28159]={64,504938}
G[28160]={64,504938}
G[28161]={64,504938}
G[28162]={505718}
G[28163]={505718}
G[28165]={505718}
G[28166]={241,504873,505501}
G[28168]={25,504895}
G[28170]={241,504873,505501}
G[28171]={241,504873,505501}
G[28172]={36,504901}
G[28173]={241,504873,505501}
G[28174]={36,504901}
G[28175]={241,504873,505501}
G[28176]={241,504873,505501}
G[28177]={36,504901}
G[28178]={36,504901}
G[28179]={36,504901}
G[28180]={36,504901}
G[28181]={36,504901}
G[28182]={36,504901}
G[28183]={36,504901}
G[28184]={36,504901}
G[28185]={505718}
G[28186]={505718}
G[28187]={249,504872}
G[28188]={505718}
G[28190]={77,504931}
G[28191]={241,504873,505501}
G[28192]={25,504895}
G[28193]={249,504872}
G[28194]={249,504872}
G[28195]={249,504872}
G[28196]={25,504895}
G[28197]={25,504895}
G[28198]={249,504872}
G[28199]={25,504895}
G[28200]={249,504872}
G[28201]={249,504872}
G[28202]={36,504901}
G[28203]={36,504901}
G[28204]={36,504901}
G[28205]={36,504901}
G[28206]={25,504895}
G[28207]={77,504931}
G[28208]={77,504931}
G[28209]={25,504895}
G[28210]={249,504872}
G[28211]={241,504873,505501}
G[28212]={241,504873,505501}
G[28213]={77,504931}
G[28214]={77,504931}
G[28215]={241,504873,505501}
G[28216]={241,504873,505501}
G[28217]={77,504931}
G[28218]={77,504931}
G[28219]={77,504931}
G[28220]={77,504931}
G[28221]={77,504931}
G[28222]={77,504931}
G[28223]={505718}
G[28224]={77,504931}
G[28225]={36,504901}
G[28226]={36,504901}
G[28227]={36,504901}
G[28230]={25,504895}
G[28231]={25,504895}
G[28232]={505718}
G[28233]={241,504873,505501}
G[28234]={241,504873,505501}
G[28235]={25,504895}
G[28237]={25,504895}
G[28239]={36,504901}
G[28241]={241,504873,505501}
G[28242]={241,504873,505501}
G[28243]={241,504873,505501}
G[28244]={241,504873,505501}
G[28245]={36,504901}
G[28246]={36,504901}
G[28247]={241,504873,505501}
G[28248]={241,504873,505501}
G[28249]={241,504873,505501}
G[28250]={249,504872}
G[28251]={25,504895}
G[28253]={36,504901}
G[28254]={36,504901}
G[28256]={77,504931}
G[28257]={77,504931}
G[28261]={77,504931}
G[28264]={77,504931}
G[28265]={36,504901}
G[28266]={36,504901}
G[28267]={249,504872}
G[28269]={249,504872}
G[28271]={249,504872}
G[28272]={249,504872}
G[28273]={249,504872}
G[28274]={249,504872}
G[28275]={505718}
G[28276]={249,504872}
G[28277]={249,504872}
G[28278]={36,504901}
G[28279]={36,504901}
G[28280]={241,504873,505501}
G[28281]={241,504873,505501}
G[28282]={241,504873,505501}
G[28283]={64,504938}
G[28284]={64,504938}
G[28286]={36,504901}
G[28288]={77,504931}
G[28291]={249,504872}
G[28294]={241,504873,505501}
G[28305]={77,504931}
G[28306]={77,504931}
G[28310]={36,504901}
G[28311]={36,504901}
G[28312]={36,504901}
G[28313]={36,504901}
G[28314]={36,504901}
G[28315]={36,504901}
G[28316]={36,504901}
G[28317]={36,504901}
G[28318]={36,504901}
G[28319]={36,504901}
G[28320]={36,504901}
G[28321]={36,504901}
G[28322]={36,504901}
G[28324]={25,504895}
G[28325]={25,504895}
G[28326]={36,504901}
G[28327]={36,504901}
G[28329]={25,504895}
G[28330]={25,504895}
G[28331]={25,504895}
G[28332]={25,504895}
G[28333]={77,504931}
G[28334]={77,504931}
G[28335]={77,504931}
G[28336]={77,504931}
G[28337]={77,504931}
G[28338]={77,504931}
G[28339]={77,504931}
G[28340]={77,504931}
G[28341]={77,504931}
G[28342]={77,504931}
G[28344]={25,504895}
G[28345]={25,504895}
G[28346]={241,504873,505501}
G[28348]={25,504895}
G[28350]={249,504872}
G[28351]={249,504872}
G[28352]={249,504872}
G[28353]={249,504872}
G[28354]={25,504895}
G[28356]={25,504895}
G[28357]={77,504931}
G[28358]={77,504931}
G[28359]={77,504931}
G[28360]={77,504931}
G[28361]={77,504931}
G[28362]={77,504931}
G[28363]={249,504872}
G[28364]={77,504931}
G[28366]={77,504931}
G[28367]={249,504872}
G[28368]={77,504931}
G[28369]={241,504873,505501}
G[28370]={77,504931}
G[28372]={77,504931}
G[28373]={77,504931}
G[28374]={77,504931}
G[28375]={25,504895}
G[28376]={249,504872}
G[28377]={241,504873,505501}
G[28378]={241,504873,505501}
G[28379]={241,504873,505501}
G[28380]={77,504931}
G[28381]={77,504931}
G[28382]={77,504931}
G[28383]={77,504931}
G[28384]={77,504931}
G[28385]={77,504931}
G[28386]={77,504931}
G[28387]={77,504931}
G[28388]={77,504931}
G[28389]={77,504931}
G[28392]={77,504931}
G[28397]={25,504895}
G[28400]={25,504895}
G[28402]={249,504872}
G[28403]={249,504872}
G[28404]={249,504872}
G[28407]={241,504873,505501}
G[28408]={241,504873,505501}
G[28409]={241,504873,505501}
G[28410]={241,504873,505501}
G[28411]={241,504873,505501}
G[28413]={241,504873,505501}
G[28415]={36,504901}
G[28416]={36,504901}
G[28417]={36,504901}
G[28418]={36,504901}
G[28419]={36,504901}
G[28420]={36,504901}
G[28421]={36,504901}
G[28422]={36,504901}
G[28423]={36,504901}
G[28424]={36,504901}
G[28425]={36,504901}
G[28426]={36,504901}
G[28427]={36,504901}
G[28428]={36,504901}
G[28429]={36,504901}
G[28430]={36,504901}
G[28431]={36,504901}
G[28432]={36,504901}
G[28433]={36,504901}
G[28434]={36,504901}
G[28436]={36,504901}
G[28437]={36,504901}
G[28438]={36,504901}
G[28439]={36,504901}
G[28440]={36,504901}
G[28441]={36,504901}
G[28442]={36,504901}
G[28443]={36,504901}
G[28444]={36,504901}
G[28445]={36,504901}
G[28446]={36,504901}
G[28447]={36,504901}
G[28448]={36,504901}
G[28450]={36,504901}
G[28451]={36,504901}
G[28452]={36,504901}
G[28454]={36,504901}
G[28455]={36,504901}
G[28456]={36,504901}
G[28460]={83,504940}
G[28464]={83,504940}
G[28467]={83,504940}
G[28469]={83,504940}
G[28470]={83,504940}
G[28471]={83,504940}
G[28472]={83,504940}	-- needed for The Winterfall Furbolg (Winterspring Quests)
G[28479]={83,504940}
G[28480]={249,504872}
G[28482]={249,504872}
G[28483]={249,504872}
G[28484]={25,504895}
G[28485]={25,504895}
G[28486]={249,504872}
G[28487]={25,504895}
G[28489]={25,504895}
G[28491]={36,504901}
G[28492]={63,504925}
G[28493]={63,504925,504976}
G[28495]={25,504895}
G[28497]={249,504872}
G[28498]={249,504872}
G[28499]={249,504872}
G[28500]={249,504872}
G[28501]={249,504872}
G[28502]={249,504872}
G[28503]={64,504938}
G[28504]={64,504938}
G[28505]={22,504893}
G[28506]={25,504895}
G[28507]={71,504935}
G[28508]={22,504893}
G[28509]={71,504935}
G[28510]={69,504932,504979}
G[28512]={32,504910}
G[28513]={83,504940}
G[28514]={36,504901}
G[28515]={36,504901}
G[28518]={83,504940}
G[28519]={83,504940}
G[28520]={249,504872}
G[28521]={83,504940}
G[28522]={83,504940}
G[28524]={83,504940}
G[28525]={78,504939}
G[28526]={78,504939}
G[28527]={81,504934}
G[28528]={81,504934}
G[28529]={62,504928,505453}
G[28530]={83,504940}
G[28531]={66,504930}
G[28532]={65,504936,504980}
G[28533]={249,504872}
G[28534]={83,504940}
G[28535]={83,504940}
G[28536]={83,504940}
G[28537]={83,504940}
G[28538]={25,504895}
G[28539]={65,504936,504980}
G[28540]={83,504940}
G[28542]={77,504931}
G[28543]={77,504931}
G[28544]={83,504940}
G[28545]={83,504940}
G[28548]={66,504930}
G[28549]={199,504937,504981}
G[28550]={199,504937}
G[28551]={199,504937}
G[28552]={199,504937}
G[28553]={17,504909}
G[28554]={70,504929,504978}
G[28556]={25,504895}
G[28560]={95,504908}
G[28561]={249,504872}
G[28562]={52,504903}
G[28563]={49,504902}
G[28564]={47,504903}
G[28565]={56,504899}
G[28566]={25,504895}
G[28568]={21,504894}
G[28569]={51,504904}
G[28570]={51,504904}
G[28571]={25,504895}
G[28572]={14,504896}
G[28574]={26,504897}
G[28575]={22,504893}
G[28576]={22,504893}
G[28577]={23,504892}
G[28578]={23,504892}
G[28579]={15,504900}
G[28580]={15,504900}
G[28581]={32,504910}
G[28582]={32,504910}
G[28583]={241,504873,505501}
G[28584]={241,504873,505501}
G[28586]={241,504873,505501}
G[28587]={25,504895}
G[28588]={241,504873,505501}
G[28589]={241,504873,505501}
G[28590]={241,504873,505501}
G[28591]={241,504873,505501}
G[28592]={241,504873,505501}
G[28593]={241,504873,505501}
G[28594]={241,504873,505501}
G[28595]={241,504873,505501}
G[28596]={241,504873,505501}
G[28597]={241,504873,505501}
G[28598]={241,504873,505501}
G[28599]={241,504873,505501}
G[28600]={25,504895}
G[28602]={249,504872}
G[28603]={25,504895}
G[28604]={25,504895}
G[28605]={25,504895}
G[28609]={83,504940}
G[28610]={83,504940}
G[28611]={249,504872}
G[28612]={249,504872,504961}
G[28613]={249,504872}
G[28614]={83,504940}
G[28615]={83,504940}
G[28616]={25,504895}
G[28618]={83,504940}
G[28619]={14,504896}
G[28620]={25,504895}
G[28622]={249,504872}
G[28623]={249,504872}
G[28624]={83,504940}
G[28625]={83,504940}
G[28626]={83,504940}
G[28627]={83,504940}
G[28628]={83,504940}	-- Superior Weapons (for Winterspring Quests)
G[28629]={83,504940}
G[28630]={83,504940}
G[28631]={83,504940}
G[28632]={83,504940}
G[28633]={249,504872}
G[28634]={25,504895}
G[28635]={25,504895}
G[28636]={25,504895}
G[28637]={83,504940}
G[28639]={83,504940}	-- needed for The Hub of Goodgrub's Grub (Winterspring Quests)
G[28640]={83,504940}
G[28641]={83,504940}
G[28643]={25,504895}
G[28644]={25,504895}
G[28645]={25,504895}
G[28646]={25,504895}
G[28647]={25,504895}
G[28654]={504956}
G[28655]={241,504873,505501}
G[28656]={83,504940}
G[28657]={505719}
G[28658]={505719}
G[28659]={505719}
G[28660]={505719}
G[28661]={505719}
G[28662]={505719}
G[28663]={505719}
G[28664]={505719}
G[28665]={505719}
G[28666]={36,504901}
G[28667]={36,504901}
G[28668]={505719}
G[28669]={505719}
G[28670]={505719}
G[28671]={17,504909}
G[28673]={17,504909}
G[28674]={83,504940}
G[28675]={51,504904}
G[28676]={83,504940}
G[28677]={51,504904}
G[28678]={505719}
G[28679]={505719}
G[28680]={505719}
G[28681]={505719}
G[28682]={505719}
G[28683]={505719}
G[28684]={505719}
G[28685]={505719}
G[28686]={505719}
G[28687]={505719}
G[28688]={50,504906}
G[28689]={505719}
G[28690]={505719}
G[28691]={505719}
G[28692]={505719}
G[28693]={505719}
G[28694]={505719}
G[28695]={505719}
G[28696]={505719}
G[28697]={505719}
G[28698]={505719}
G[28699]={50,504906}
G[28700]={505719}
G[28701]={83,504940}
G[28702]={210,504905}
G[28703]={83,504940}
G[28704]={210,504905}
G[28705]={17,504909}
G[28706]={83,504940}
G[28707]={83,504940}
G[28708]={100,501189,501271}
G[28709]={114,500033,501358}
G[28710]={83,504940}	-- needed for Spray It and Slay It (Winterspring Quests)
G[28711]={114,500033,501358}
G[28712]={241,504873,505501}
G[28718]={83,504940}
G[28719]={83,504940}
G[28722]={83,504940}
G[28732]={504956}
G[28733]={25,504895}
G[28735]={504956}
G[28737]={504956}
G[28741]={504956}
G[28742]={83,504940}	-- needed for The Hub of Goodgrub's Grub (Winterspring Quests)
G[28744]={25,504895}
G[28747]={25,504895}
G[28749]={22,504893}
G[28750]={22,504893}
G[28758]={241,504873,505501}
G[28768]={83,504940}
G[28781]={504956}
G[28782]={83,504940}	-- needed for The Hub of Goodgrub's Grub (Winterspring Quests)
G[28814]={504956}
G[28815]={504956}
G[28828]={83,504940}	-- needed for The Hub of Goodgrub's Grub (Winterspring Quests)
G[28829]={83,504940}
G[28830]={83,504940}	-- needed for Jadrag's Fate (Winterspring Quests)
G[28831]={83,504940}	-- needed for Jadrag's Fate (Winterspring Quests)
G[28836]={504956}
G[28837]={83,504940}
G[28838]={83,504940}
G[28839]={83,504940}
G[28840]={83,504940}
G[28841]={83,504940}
G[28842]={83,504940}	-- needed for Umbrance's Deliverance (Winterspring Quests)
G[28843]={504956}
G[28845]={504956}
G[28847]={83,504940}
G[28848]={83,504940}	-- needed for Ruins of Kel'Theril (Winterspring Quests)
G[28849]={76,504927}
G[28852]={504956}
G[28856]={81,504934}
G[28857]={17,504909}
G[28858]={17,504909}
G[28859]={81,504934}
G[28865]={17,504909}
G[28866]={504956}
G[28867]={17,504909}
G[28869]={207,504871}
G[28870]={504956}
G[28876]={63,504925,504976}
G[28877]={10,504933}
G[28881]={71,504935}
G[28910]={501031}
G[28911]={501028}
G[28913]={501032}
G[28914]={501029}
G[28922]={501022}
G[28924]={501025}
G[28926]={501023}
G[28927]={501026}
G[28934]={501695}
G[28935]={501695}
G[28943]={506014}
G[28944]={506013}
G[28945]={506011}
G[28946]={506012}
G[28947]={506014}
G[28948]={506013}
G[28949]={506012}
G[28950]={506011}
G[28951]={500963}
G[28952]={500963}
G[28953]={500965}
G[28954]={500966}
G[28955]={500966,500967}
G[28956]={500966}
G[28957]={500967}
G[28958]={500965}
G[28959]={500967}
G[28960]={500966}
G[28961]={500966}
G[28962]={500967}
G[28963]={500966}
G[28964]={500966}
G[28965]={500966,500967}
G[28966]={500967}
G[28967]={500966,500967}
G[28968]={500966}
G[28969]={500967}
G[28970]={500966}
G[28971]={500967}
G[28972]={500967}
G[28973]={505838}
G[28974]={505838}
G[28976]={505838}
G[28977]={505837}
G[28978]={505837}
G[28979]={505837}
G[28980]={505837}
G[28981]={505837,505838}
G[28982]={505837,505838}
G[28983]={505837}
G[28984]={505838}
G[28985]={505837}
G[28986]={505838}
G[28987]={500967}
G[28988]={500966}
G[28989]={500965}
G[28990]={500966}
G[28991]={500966}
G[28992]={500965}
G[28993]={500963,500965}
G[28994]={500963,500965}
G[28995]={500963}
G[28996]={500965}
G[28998]={500965}
G[28999]={505837,505838}
G[29000]={505837,505838}
G[29001]={505837,505838}
G[29002]={500965}
G[29003]={500965}
G[29004]={500965}
G[29005]={500965}
G[29006]={500963}
G[29007]={500963}
G[29008]={500963}
G[29009]={500965}
G[29010]={500963}
G[29011]={500963}
G[29012]={500963}
G[29013]={500963}
G[29014]={500963,500965}
G[29016]={505837,500838}
G[29017]={505837,505838}
G[29018]={500963,500965}
G[29019]={505838}
G[29020]={505837}
G[29030]={506011,506012}
G[29031]={506011,506012}
G[29032]={83,504940}
G[29035]={83,504940}
G[29036]={506011,506012}
G[29037]={83,504940}
G[29038]={83,504940}
G[29039]={83,504940}
G[29040]={83,504940}
G[29051]={83,504940}
G[29052]={83,504940}
G[29053]={83,504940}
G[29054]={501040}
G[29066]={198,504870}
G[29075]={501040}
G[29086]={10,504933}
G[29088]={10,504933}
G[29090]={10,504933}
G[29144]={501040}
G[29181]={505866}
G[29195]={505859}
G[29198]={505866}
G[29200]={505859}
G[29201]={505866}
G[29203]={505859}
G[29214]={505866}
G[29254]={505866}
G[29272]={505866}
G[29279]={505866}
G[29281]={505866}
G[29283]={505866}
G[29313]={505842}
G[29314]={505842}
G[29315]={505844}
G[29316]={505842}
G[29317]={505850}
G[29318]={505842}
G[29319]={505850}
G[29320]={505850}
G[29321]={505848}
G[29322]={505850}
G[29323]={505848}
G[29324]={505848}
G[29325]={505848}
G[29332]={505844}
G[29333]={505844}
G[29334]={505844}
G[29342]={505847}
G[29343]={505847}
G[29344]={505847}
G[29345]={505849}
G[29346]={505849}
G[29347]={505847}
G[29348]={505849}
G[29349]={505849}
G[29350]={505847}
G[29351]={505841}
G[29352]={505841}
G[29353]={505841}
G[29354]={505849}
G[29355]={505841}
G[29356]={505841}
G[29357]={505842}
G[29358]={505843}
G[29359]={505848}
G[29360]={505844}
G[29361]={505850}
G[29362]={505843}
G[29363]={505843}
G[29364]={505843}
G[29365]={505843}
G[29371]={501040}
G[29374]={501041}
G[29375]={501041}
G[29376]={501041}
G[29377]={501041}
G[29443]={506027,506029}
G[29444]={506027,506029}
G[29445]={506027,506029}
G[29446]={506027,506029}
G[29451]={506027,506029}
G[29456]={506028,506029}
G[29457]={506028,506029}
G[29458]={506028,506029}
G[29464]={506029}
G[29647]={506300}	-- need for the Tian Monastery part				-- ** Logically one could also turn in 29639 or 29646 instead.  Cannot currently handle this. **
G[29670]={506300,506534}	-- needed for Nectarbreeze Orchard part
G[29694]={506534}	-- needed for The Remains of Hellscream's Fist part
G[29734]={506006}
G[29735]={506006}
G[29736]={506006}
G[29737]={506006}
G[29738]={506006}
G[29739]={506006}
G[29740]={506006}
G[29741]={506006}
G[29742]={506006}
G[29755]={506300,506534}	-- needed for Ruins of Gan-Shi part
G[29822]={506534}	-- needed for First Contact part
G[29879]={506534}	-- needed for Strange Bedfellows part
G[29882]={506300,506534}	-- needed for Dawn's Blossom part
G[29894]={506300}	-- needed for The Waterspeaking Ceremony part
G[29901]={506300}	-- needed for The White Pawn part
G[29905]={506300}	-- needed for Pearlfin Village part
G[29906]={506300}	-- needed for Pearlfin Village part
G[29918]={506301}	-- needed for Thunderfoot Fields part
G[29920]={506300,506534}	-- needed for Dawn's Blossom part
G[29930]={506300,506534}	-- needed for Greenstone Quarry part
G[29952]={506301}	-- needed for Mudmug's Place part
G[29967]={506534}	-- needed for Grookin Hill part
G[29990]={506301}	-- needed for The Hidden Master part
G[30000]={506300,506534}	-- needed for The Temple of the Jade Serpent part
G[30073]={506301}	-- needed for Chen's Masterpiece part
G[30078]={506301}	-- needed for Stormstout Brewery part
G[30090]={506535,506536}	-- needed for Zhu's Watch part
G[30131]={506536}	-- needed for Thunder Cleft part
G[30174]={506536}	-- needed for Dawnchaser Retreat part
G[30186]={506301}	-- needed for Nesingwary's Safari part
G[30273]={506535,506536} -- needed for Temple of the Red Crane part
G[30348]={506535}	-- needed for The Incursion part
G[30445]={506535}	-- needed for The Waters of Youth part
G[30485]={506534}	-- needed for The Battle for the Forest part
G[30492]={506537,506538}	-- needed for The Yak Wash part
G[30500]={506300,506534}	-- needed for Overcoming Doubt part
G[30502]={506300,506534}	-- needed for Overcoming Doubt part
G[30504]={506534}	-- needed for Overcoming Doubt part
G[30514]={506537}	-- needed for Westwind Rest part
G[30515]={506538}
G[30637]={507315}	-- needed for ??? part
G[30639]={507315}	-- needed for The Jade Army part
G[30642]={507315}	-- needed for Weapons of the Thunder King part
G[30646]={507315}	-- needed for Welcome Home part
G[30660]={506537}	-- needed for The Yaungol Invasion part
G[30672]={506535,506536}	-- needed for Nayeli Lagoon part
G[30675]={506535,506536}	-- needed for Nayeli Lagoon part
G[30784]={506539}	-- needed for Fire Camp Osul part
G[30793]={506539}	-- needed for Mistlurkers in the Sumprushes part
G[30800]={506537,506538} -- needed for The Thunder King part
G[30855]={506537,506538} -- needed for Inkgill Mere part
G[30900]={506539}	-- needed for On Hatred's Path part
G[30926]={506539}	-- needed for Tai Ho's Investigation part
G[30946]={506537,506538}	-- needed for Zouchin Village part
G[30968]={506539}	-- needed for The Sha of Hatred part
G[31006]={507312}	-- needed for Kil'ruk the Wind-Reaver part
G[31010]={507312}	-- needed for Malik the Unscathed part
G[31026]={507312}	-- needed for Korven the Prime part
G[31038]={507297}
G[31066]={506540}	-- needed for The First Paragons part
G[31085]={507312}	-- needed for Iyyokuk the Lucid part
G[31086]={506540}	-- needed for Taste of Amber part
G[31104]={507297}
G[31127]={507297}
G[31128]={507297}
G[31179]={507312}	-- needed for Skeer the Bloodseeker part
G[31220]={507297}
G[31221]={507297}
G[31277]={507310}
G[31315]={507296}
G[31316]={506603}
G[31319]={506300}	-- needed for Overcoming Doubt part
G[31354]={506540,507312} -- needed for Like a Deck Boss part of Dread Haste Makes Dread Waste and Ka'roz the Locust part of Amber is the Color of My Energy
G[31362]={506300}	-- needed for The Battle for the Forest part
G[31394]={506537}	-- needed for Temple of the White Tiger part
G[31398]={506540,507312}	-- needed for Might of the Klaxxi part of Dread Haste Makes Dread Waster and Kaz'tik the Manipulator part of Amber is the Color of My Energy
G[31606]={507312}	-- needed for Rik'kal the Dissector part
G[31724]={506603}
G[31725]={506603}
G[31726]={506603}
G[31728]={506603}
G[31729]={506603}
G[31745]={506300}	-- needed for Paw'don Village part
G[31779]={506534}	-- needed for First Contact part
G[31786]={507612}
G[31787]={507612}
G[31788]={507612}
G[31789]={507612}
G[31790]={507612}
G[31791]={507612}
G[31792]={507612}
G[31793]={507612}
G[31794]={507612}
G[31795]={507612}
G[31796]={507612}
G[31797]={507612}
G[31798]={507612}
G[31799]={507612}
G[31800]={507612}
G[31801]={507612}
G[31802]={507612}
G[31803]={507612}
G[31804]={507612}
G[31805]={507612}
G[31808]={507314}
G[32020]={507602}
G[32021]={507601,507602}
G[32022]={507602}
G[32023]={507601,507602}
G[32024]={507601,507602}
G[32026]={507601,507602}
G[32027]={507601,507602}
G[32028]={507602}
G[32029]={507601,507602}
G[32031]={507601,507602}
G[32032]={507601,507602}
G[32033]={507601}
G[32034]={507601,507602}
G[32036]={507601,507602}
G[32037]={507601,507602}
G[32039]={507601,507602}
G[32040]={507602}
G[32041]={507601,507602}
G[32042]={507601}
G[32043]={507601,507602}
G[32044]={507601,507602}
G[32046]={507601,507602}
G[32047]={507602}
G[32048]={507601,507602}
G[32049]={507601}
G[32050]={507602}
G[32051]={507601,507602}
G[32052]={507601}

-- 15851 is the 5.0.3 release dated 2012-07-10
local _, release = GetBuildInfo()
release = tonumber(release)

Grail.extraAchievements['Alliance'][mapPandaria] = { 507296, 507297, 507312, 507314, 507315, 507310, 507612, 507928, }
Grail.extraAchievements['Horde'][mapPandaria] = { 507296, 507297, 507312, 507314, 507315, 507310, 507612, 507929, }

G[32108]={507929}	-- needed for Domination Point part
G[32109]={507928}	-- needed for Lion's Landing part
G[32191]={507929}	-- needed for Blood for Blood part
G[32194]={507928}	-- needed for The Korune part		*** TODO: Determine if also need 32243 as well for this ***
G[32244]={507929}	-- needed for Blood for Blood part
G[32257]={507929}	-- needed for The Voice of the Gods part
G[32316]={507928}	-- needed for Heart of the Alliance part
G[32328]={507929}	-- needed for The Darnassus Operation part
G[32330]={507929}	-- needed for Rise of the Blood Elves part
G[32335]={507928}	-- needed for An Ancient Ally part
G[32336]={507928}	-- needed for In Search of Harmony part
G[32337]={507928}	-- needed for In Search of Harmony part
G[32338]={507928}	-- needed for In Search of Harmony part
G[32352]={507929}	-- needed for Pride part
G[32362]={507928}	-- needed for Jaina's Hope part
G[32368]={507929}	-- needed for Secrets of the Past part
G[32371]={507928}	-- needed for Secrets of the Past part
G[32372]={507929}	-- needed for The Horde is Family part
G[32378]={507929}	-- needed for The Korune part
G[32379]={507929}	-- needed for The Korune part
G[32384]={507929}	-- needed for The Korune part
G[32392]={507929}	-- needed for The Divine Bell part
G[32394]={507928}	-- needed for The Divine Bell part
G[32397]={507928}	-- needed for The Voice of the Gods part
G[32399]={507929}	-- needed for The Breath of Darkest Shadow part
G[32412]={507929}	-- needed for The Purge of Dalaran part
G[32423]={507928}	-- needed for The Purge of Dalaran part
G[32426]={507928}	-- needed for The Man With a Thousand Faces part
G[32455]={507928}	-- needed for 

Grail.extraAchievements['Alliance'][mapPandaria] = { 507296, 507297, 507312, 507314, 507315, 507310, 507612, 507928, 507533, 507534, 507535, 507536, 508099, }
Grail.extraAchievements['Horde'][mapPandaria] = { 507296, 507297, 507312, 507314, 507315, 507310, 507612, 507929, 507533, 508008, 507535, 507536, 508099, }
Grail.extraAchievements['Alliance'][mapEasternKingdoms] = { 500940, 505318, 505320, 504960, 505452, 508306, }
Grail.extraAchievements['Horde'][mapEasternKingdoms] = { 500940, 504960, 505452, 505319, 505321, 508307, }

G[31482]={507533}
G[32212]={508099}	-- needed for Build a Base part of Isle of Thunder (Horde)
G[32277]={508099}	-- needed for Take the Forge of Isle of Thunder (Horde)
G[32278]={508099}	-- needed for Assault the Shipyard of Isle of Thunder (Horde)
G[32279]={508099}	-- needed for The Fall of Shan Bu of Isle of Thunder (Horde)
G[32390]={507534}
G[32432]={508008}
G[32496]={508042}
G[32497]={508044,508045}
G[32498]={508044,508045}
G[32499]={508044,508045}
G[32500]={508044,508045}
G[32501]={508044,508045}
G[32502]={508044,508045}
G[32503]={508043}
G[32597]={507535}
G[32680]={508099}	-- needed for First Landing part of Isle of Thunder (Horde)
G[32681]={508099}	-- needed for First Landing part of Isle of Thunder (Alliance)
G[32644]={508099}	-- needed for Build a Base part of Isle of Thunder (Alliance)
G[32654]={508099}	-- needed for Break Down the Wall of Isle of Thunder
G[32652]={508099}	-- needed for Take the Forge of Isle of Thunder (Alliance)
G[32655]={508099}	-- needed for Assault the Shipyard of Isle of Thunder (Alliance)
G[32656]={508099}	-- needed for The Fall of Shan Bu of Isle of Thunder (Alliance)
G[32807]={508307,508306}	-- needed for The Lorewalker's Counsel of Darkspear Revolutionary and Hordebreaker
G[32811]={508306}	-- needed for Battlefield: Barrens of Hordebreaker
G[32814]={508307}	-- needed for Durotar Liberation of Darkspear Revolutionary
G[32816]={508307,508306}	-- needed for The Path of the Last Emperor of Darkspear Revolutionary and Hordebreaker
G[32861]={507536}
G[32862]={508307}	-- needed for Battlefield: Barrens (Weekly) of Darkspear Revolutionary
G[32872]={508306}	-- needed for Battlefield: Barrens (Weekly) of Hordebreaker

Grail.extraAchievements['Alliance'][mapPandaria] = { 507296, 507297, 507312, 507314, 507310, 507612, 507928, 507533, 507534, 507535, 507536, 508099, 508726, 508727, 508729, 508730, }
Grail.extraAchievements['Horde'][mapPandaria] = { 507296, 507297, 507312, 507314, 507310, 507612, 507929, 507533, 508008, 507535, 507536, 508099, 508726, 508727, 508729, 508730, }
Grail.extraAchievements['Alliance'][mapEasternKingdoms] = { 500940, 505318, 505320, 504960, 505452, }
Grail.extraAchievements['Horde'][mapEasternKingdoms] = { 500940, 504960, 505452, 505319, 505321, }
G[32956]={508727}
G[32957]={508727}
G[32958]={508727}
G[32968]={508726}
G[32969]={508726}
G[32971]={508726}
G[32974]={508730}
G[32975]={508730}
G[32976]={508730}
G[33203]={508729}	-- Skull-Covered
G[33204]={508729}	-- Sturdy
G[33205]={508729}	-- Sturdy
G[33206]={508729}	-- Sturdy
G[33207]={508729}	-- Sturdy
G[33208]={508729}	-- Smoldering
G[33209]={508729}	-- Smoldering
G[33210]={508729}	-- Blazing
-- 8729 requires 17 of the Moss-Covered chests, but there are many more than that on the island.  So basically it would be really great if we could transform
-- the way prerequisites work to have the same P: concepts that quests use.  This would allow us to specify 17 of a group that contains all the Moss-Covered
-- chests.  However, it would be interesting to present the data in something like Wholly.

Grail.loremasterAchievements['Alliance'][mapDraenor] = { 508845, 508920, 508923, 508925, 508927, 509528, 509618, }
Grail.loremasterAchievements['Horde'][mapDraenor] = { 508671, 508919, 508924, 508926, 508928, 509529, 509618, }
Grail.extraAchievements['Alliance'][mapDraenor] = { 509602, 509605, 509607, 509615, 509674, 509825, 510067, 510068, }
Grail.extraAchievements['Horde'][mapDraenor] = { 509605, 509606, 509607, 509615, 509674, 509836, 510074, 510075 }
G[32796]={508671}	-- needed for Ga'nar's Vengeance part of You'll Get Caught Up In The... Frostfire!
G[33116]={509528}	-- needed for On the Shadow's Trail
G[33145]={509606}
G[33256]={508845}	-- needed for The Light Prevails part of As I Walk Through the Valley of the Shadow of Moon
G[33271]={508845}	-- needed for Gloomshade Grove of As I Walk Through the Valley of the Shadow of Moon
G[33427]={509492}	-- needed for Ours is the Fury part of Garrison Campaign (Horde)
G[33473]={508671}	-- needed for Defense of Wor'gol part of You'll Get Caught Up In The... Frostfire!
G[33527]={508671}	-- needed for Die Belagerung der Speerspießerfestung part of Ein Lied von Frost und Feuer
G[33582]={508919,508920}	-- needed for The Plight of the Arakkoa of Tala-done With This
G[33731]={508919}	-- needed for The Battle for Shattrath part of Don't Let the Tala-door Hit You on the Way Out
G[33828]={508671}	-- needed for Thunder's Fall part of You'll Get Caught Up In The... Frostfire!
G[34019]={508845}	-- needed for Shadows Awaken part of As I Walk Through the Valley of the Shadow of Moon
G[34054]={508845}	-- needed for A Sister's Sacrifice part of As I Walk Through the Valley of the Shadow of Moon
G[34076]={509602}
G[34087]={509492}	-- needed for Iron Siegeworks part of Garrison Campaign (Horde)
G[34099]={508920}	-- needed for The Battle for Shattrath part of Tala-done With This
G[34124]={508671}	-- needed for The Battle of Thunder Pass part of You'll Get Caught Up In The... Frostfire!
G[34154]={508920}	-- needed for In the Shadows of AUchindown part of Don't Let the Tala-door Hit You on the Way Out
G[34295]={509529}
G[34319]={509492}	-- needed for Bloodmaul Compound part of Garrison Campaign (Horde)
G[34450]={509492}	-- needed for Darktide Roost part of Garrison Campaign (Horde)
G[34496]={509602}
G[34501]={509606}
G[34504]={509602}
G[34505]={509606}
G[34564]={508919}	-- needed for In the Shadows of Auchindoun part of Don't Let the Tala-door Hit You on the Way Out
G[34596]={508927}	-- needed for Trouble at the Overwatch part of Nagrandeur
G[34639]={509674}
G[34660]={509674}
G[34666]={508927,508928}	-- needed for The Ring of Trials part of Nagrandeur
G[34667]={509674}
G[34692]={508845}	-- needed for Establishing a Foothold ofAs I Walk Through the Valley of the Shadow of Moon
G[34711]={508920}	-- needed for Establishing your Mage Tower of Tala-done With This
G[34712]={508919}	-- needed for Establishing your Outpost part of Don't Let the Tala-door Hit You on the Way Out
G[34723]={509615}
G[34724]={509607}
G[34728]={509602}
G[34769]={508927}	-- needed for The Might of Steel and Blood part of Nagrandeur
G[34775]={508671}	-- needed for Foothold in a Savage Land part of You'll Get Caught Up In The... Frostfire!
G[34792]={508845}	-- needed for The Pursuit of Justice part of As I Walk Through the Valley of the Shadow of Moon
G[34899]={508928}	-- needed for Die Macht von Stahl und Blut part of Nagrandeur
G[34918]={508928}
G[34942]={508925,508926}	-- needed for Secrets of the Talonpriests part of Between Arak and a Hard Place
G[34957]={508927}	-- needed for A Blademaster's Honor part of Nagrandeur
G[34971]={508919}	-- needed for Establishing your Outpost part of Don't Let the Tala-door Hit You on the Way Out
G[34981]={508920}	-- establishing your Armory
G[35012]={508925,508926}	-- needed for The Gods of Arak parts of Between...
G[35015]={508845}	-- needed for Purifying the Gene Pool part of As I Walk Through the Valley of the Shadow of Moon
G[35061]={508927}	-- needed for The Taking of Lokrath part of Nagrandeur
G[35063]={508923}	-- needed for We Need an Outpost of Putting the Gore in Gorgrond
G[35088]={508927,508928}	-- needed for The Shadow of the Void part of Nagrandeur
G[35097]={508928}
G[35136]={508924}
G[35137]={508923}	-- The Sparring Arena
G[35151]={508924}	-- needed for Your Base, Your Choice part of Putting the Gore in Gorgrond
G[35152]={508924}
G[35158]={508928}	-- needed for Trouble at the Overwatch of Nagrandeur
G[35169]={508927}	-- needed for The Legacy of Garrosh Hellscream part of Nagrandeur
G[35171]={508928}
G[35197]={509492}	-- needed for The Sargerei part of Garrison Campaign (Horde)
G[35236]={509674}
G[35237]={509674}
G[35245]={508925}	-- needed for The Gods of Arak part of Between Arak and a Hard Place
G[35255]={508923}	-- needed for Power of the Genasaur of
G[35298]={508925,508926}	-- needed for Pinchwhistle Gearworks part of Between Arak and a Hard Place
G[35317]={508928}
G[35379]={509615}
G[35396]={508927}	-- needed for The Dark Heart of Oshu'Gun part of Nagrandeur
G[35416]={508924}
G[35687]={509492}	-- needed for The Fall of Shattrath part of Garrison Campaign (Horde)
G[35835]={508925}   -- SECURING SOUTHPORT, SMUGGLER'S DEN, Between Arak and a Hard Place
G[36473]={509607}
G[36476]={509607}
G[35482]={508925}	-- needed for Admiral Taylor's Garrison part of Between Arak and a Hard Place
G[35634]={508925,508926}	-- needed for Legacy of the Apexis part of Between Arak and a Hard Place
G[35649]={509605}
G[35671]={508925,508926}	-- needed for Shadows Gather part of Between Arak and a Hard Place
G[35702]={508923}	--	needed for In the Land of Giants  -  Chains of Iron
G[35704]={508925,508926}	-- needed for When the Raven Swallows the Day part of Between Arak and a Hard Place
G[35881]={509607}
G[35884]={508921}	-- needed for Welcome to Draenor
G[35896]={508925,508926}	-- needed for Terrok's Legend part of Between Arak and a Hard Place
G[36183]={508926}
G[36290]={509492}	-- needed for The Ring of Blood part of Garrison Campaign (Horde)
G[36480]={509607}
G[36500]={509607}
G[36504]={509607}
G[36563]={509607}
G[36564]={509607}
G[36566]={509607}
G[36571]={509607}
G[36573]={508924}
G[36574]={508924}	-- needed for The Iron Approach part of Putting the Gore in Gorgrond
G[36575]={508923}	-- needed for The Iron Approach part of Putting the Gore in Gorgrond
G[36576]={508923}	-- needed for The Iron Approach part of Putting the Gore in Gorgrond
G[36590]={509605}
G[36603]={509607}
G[36660]={509605}
G[36792]={509605}
G[36940]={509618}	-- needed for The Iron Invasion
G[36941]={509618}	-- needed for The Iron Invasion
G[37280]={509615}
G[37421]={509674}
G[37422]={509674}
G[37516]={509492}	-- needed for Broken Precipice part of Garrison Campaign (Horde)
G[37811]={509825}	-- The Spirit Forge (Master Relic Hunter)
G[37852]={509825}	-- The Apexis Device (Master Relic Hunter)
G[37885]={509825}	-- Breaching the Barrier (Master Relic Hunter)
G[37891]={510068}	-- Ironhold Harbor (Draenor's Last Stand)
G[37919]={509825}	-- The Blessing of Beasts (Master Relic Hunter)
G[37945]={509825}	-- Taking from the Taker (Master Relic Hunter)
G[37979]={509825}	-- The Crystal Reborn (Master Relic Hunter)
G[37992]={509836}	-- The Spirit Forge (Master Relic Hunter)
G[37993]={509836}	-- The Apexis Device (Master Relic Hunter)
G[37994]={509836}	-- Breaching the Barrier (Master Relic Hunter)
G[37995]={509836}	-- The Blessing of Beasts (Master Relic Hunter)
G[37996]={509836}	-- Taking from the Taker (Master Relic Hunter)
G[37997]={509836}	-- The Crystal Reborn (Master Relic Hunter)
G[37935]={510074}	-- The Invasion of Tanaan (In Pursuit of Gul'dan)
G[37940]={510075}	-- Ironhold Harbor (Draenor's Last Stand)
G[37968]={510068}	-- Temple of Sha'naar (Draenor's Last Stand)
G[38044]={510075}	-- Zeth'gol (Draenor's Last Stand)
G[38045]={510068}	-- Zeth'gol (Draenor's Last Stand)
G[38046]={510068}	-- The Iron Front (Draenor's Last Stand)
G[38047]={510075}	-- The Iron Front (Draenor's Last Stand)
G[38223]={510074,510067}	-- Dark Ascension (In Pursuit of Gul'dan)
G[38250]={510068}	-- Ruins of Kra'nak (Draenor's Last Stand)
G[38252]={510075}	-- Ruins of Kra'nak (Draenor's Last Stand)
G[38259]={510067}	-- All Hands on Deck (In Pursuit of Gul'dan)
G[38274]={510074,510067}	-- Bane of the Bleeding Hollow (In Pursuit of Gul'dan)
G[38416]={510074}	-- The Fate of Teron'gor (In Pursuit of Gul'dan)
G[38440]={510068}	-- The Fel Forge (Draenor's Last Stand)
G[38441]={510075}	-- The Fel Forge (Draenor's Last Stand)
G[38445]={510067}	-- The Invasion of Tanaan (In Pursuit of Gul'dan)
G[38449]={510075}	-- Temple of Sha'naar (Draenor's Last Stand)
G[38463]={510074}	-- The Cipher of Damnation (In Pursuit of Gul'dan)
G[38562]={510067}	-- The Fate of Teron'gor (In Pursuit of Gul'dan)
G[38574]={510074}	-- All Hands on Deck (In Pursuit of Gul'dan)
G[38585]={510068}	-- Throne of Kil'jaeden (Draenor's Last Stand)
G[38586]={510075}	-- Throne of Kil'jaeden (Draenor's Last Stand)
G[39394]={510067}	-- The Cipher of Damnation (In Pursuit of Gul'dan)

Grail.loremasterAchievements['Alliance'][mapBrokenIsles] = { 511124, 510698, 510763, 510059, 510790, }
Grail.loremasterAchievements['Horde'][mapBrokenIsles] = { 511124, 510698, 510763, 510059, 510790, }
Grail.extraAchievements['Alliance'][mapBrokenIsles] = { 510617, 510756, 511340, 511544, 511546, }
Grail.extraAchievements['Horde'][mapBrokenIsles] = { 510617, 510756, 511340, 511544, 511546, }
G[37449]={510763}	-- needed for Behind Legion Lines part of Azsuna Matata
G[37470]={510763}	-- needed for Azsuna vs Azshara part of Azsuna Matata
G[37566]={510763}	-- needed for Against the Giants part of Azsuna Matata
G[38060]={510790}	-- needed for The Aftermath of Vrykul Story, Bro
G[38147]={510698}	-- needed for Archdruid of the Claw part of That's 'Val'sharah Folks!
G[38225]={510698}	-- needed for Archdruid of Lore part of That's 'Val'sharah Folks!
G[38235]={510698}	-- needed for Archdruid of Lore part of That's 'Val'sharah Folks!
G[38624]={510790}	-- needed for The Trial of Will part of Vrykul Story, Bro
G[38691]={510698}	-- needed for Bradensbrook part of That's 'Val'sharah Folks!
G[38721]={510698}	-- needed for Black Rook Hold part of That's 'Val'sharah Folks!
G[38743]={510698}	-- needed for All Nightmare Long part of That's 'Val'sharah Folks!
G[38753]={510698}	-- needed for Into the Nightmare part of That's 'Val'sharah Folks!
G[38818]={510790}	-- needed for The Trial of Valor of Vrykul Story, Bro
G[38882]={510790}	-- needed for Secrets of the Shieldmaidens of Vrykul Story, Bro
G[38909]={510059}	-- needed for Riverbend of Ain't No Mountain High Enough
G[39122]={510790}	-- needed for Secrets of the Shieldmaidens of Vrykul Story, Bro
G[39387]={510059}	-- needed for The Skyhorn Tribe of Ain't No Mountain High Enough
G[39426]={510059}	-- needed for The Bloodtotem Tribe of Ain't No Mountain High Enough
G[39487]={510059}	-- needed for The Rivermane Tribe of Ain't No Mountain High Enough
G[39579]={510059}	-- needed for Secrets of Highmountain of Ain't No Mountain High Enough
G[39597]={510790}	-- needed for The Trial of Might of Vrykul Story, Bro
G[39780]={510059}	-- needed for Battle of Snowblind Mesa of Ain't No Mountain High Enough
G[39800]={510790}	-- needed for Greymane's Gambit part of Vrykul Story, Bro
G[39801]={510790}	-- needed for Greymane's Gambit of Vrykul Story, Bro
G[39855]={510790}	-- needed for To Helheim and Back of Vrykul Story, Bro
G[39992]={510059}	-- needed for Huln's War of Ain't No Mountain High Enough
G[40005]={510790}	-- needed for The Champion of Stormheim of Vrykul Story, Bro
G[40009]={510617}	-- needed for Nightfall of Nightfallen But Not Forgotten
G[40321]={511124}	-- needed for Tidying Tel'anor of Good Suramaritan
G[40336]={511124}	-- needed for Jandvik's Jarl of Good Suramaritan
G[40412]={511124}	-- needed for Breaking the Lightbreaker of Good Suramaritan
G[40573]={510698}	-- needed for Archdruid of the Vale part of That's 'Val'sharah Folks!
G[40794]={510763}	-- needed for Mak'rana and the Fate of the Queen's Reprisal part of Azsuna Matata
G[40956]={510617}	-- needed for Chief Telemancer Oculeth of Nightfallen But Not Forgotten
G[40972]={511124}	-- needed for Moon Guard Stronghold of Good Suramaritan
G[41028]={510756}	-- needed for Anora Hollow of Leyline Bling
G[41138]={510617}	-- needed for Feeding Shal'Aran of Nightfallen But Not Forgotten
G[41494]={511124}	-- needed for Eminent Grow-main of Good Suramaritan
G[41760]={510617}	-- needed for Arcanist Kel'danath of Nightfallen But Not Forgotten
G[42147]={510617}	-- needed for Masquerade of Nightfallen But Not Forgotten
G[42230]={510617,511124}	-- needed for The Light Below of Nightfallen But Not Forgotten and An Ancient Gift of Good Suramaritan
G[42244]={510763}	-- needed for Mak'rana and the Fate of the Queen's Reprisal part of Azsuna Matata
G[42488]={511124}	-- needed for The Waning Crescent of Good Suramaritan
G[42756]={510763}	-- needed for Defending Azurewing Repose part of Azsuna Matata
G[43318]={511124}	-- needed for Statecraft of Good Suramaritan
G[43362]={511124}	-- A Growing Crisis (Good Suramaritan)
G[43568]={511124}	-- needed for A Change of Seasons of Good Suramaritan
G[43587]={510756}	-- needed for Elor'shan of Leyline Bling
G[43588]={510756}	-- needed for Kel'balor of Leyline Bling
G[43590]={510756}	-- needed for Moonwhisper Gulch of Leyline Bling
G[43591]={510756}	-- needed for Moon Guard of Leyline Bling
G[43592]={510756}	-- needed for Falanaar North of Leyline Bling
G[43593]={510756}	-- needed for Falanaar South of Leyline Bling
G[43594]={510756}	-- needed for Halls of the Eclipse of Leyline Bling
G[44052]={511124}	-- needed for Blood and Wine of Good Suramaritan
G[44719]={511340}	-- Breaking the Nighthold (Insurrection)
G[44740]={511340}	-- March on Suramar (Insurrection)
G[44756]={511340}	-- Waxing Crescent (Insurrection)
G[44790]={511340}	-- Crafting War (Insurrection)
G[44814]={511340}	-- Missing Persons (Insurrection)
G[44833]={511340}	-- Elisande's Retort (Insurrection)
G[44845]={511340}	-- An Elven Problem (Insurrection)
G[44955]={511340}	-- Lockdown (Insurrection)
G[45064]={511340}	-- As Strong As Our Will (Insurrection)
G[45856]={511544}	-- Battle for Val'sharah (Defender of the Broken Isles)
G[46110]={511544}	-- Battle for Stormheim (Defender of the Broken Isles)
G[46182]={511544}	-- Battle for Highmountain (Defender of the Broken Isles)
G[46199]={511544}	-- Battle for Azsuna (Defender of the Broken Isles)
G[46245]={511546}	-- Begin Construction (Breaching the Tomb)
G[46246]={511546}	-- Strike Them Down (Breaching the Tomb)
G[46247]={511546}	-- Defending Broken Isles (Breaching the Tomb)
G[46248]={511546}	-- Self-Fulfilling Prophecy (Breaching the Tomb)
G[46249]={511546}	-- Championing Our Cause (Breaching the Tomb)
G[46250]={511546}	-- Take Out the Head... (Breaching the Tomb)
G[46251]={511546}	-- Shard Times (Breaching the Tomb)
G[46252]={511546}	-- Intolerable Infestation (Breaching the Tomb)
G[46730]={511546}	-- Armies of Legionfall (Breaching the Tomb)
G[46734]={511546}	-- Assault on Broken Shore (Breaching the Tomb)
G[46769]={511546}	-- Relieved of Their Valuables (Breaching the Tomb)
G[46832]={511546}	-- Aalgen Point (Breaching the Tomb)
G[46845]={511546}	-- Vengeance Point (Breaching the Tomb)
G[47137]={511546}	-- Champions of Legionfall (Breaching the Tomb)
G[47139]={511546}	-- Mark of the Sentinax (Breaching the Tomb)

Grail.loremasterAchievements['Alliance'][mapArgus] = {  }
Grail.loremasterAchievements['Horde'][mapArgus] = {  }
Grail.extraAchievements['Alliance'][mapArgus] = { 512066, 512073, }
Grail.extraAchievements['Horde'][mapArgus] = { 512066, 512073, }
G[47182]={512073}	-- Needed for Fel Heart of Argus (Locked and Loaded)
G[47287]={512073}	-- Light's Judgment (Locked and Loaded)
G[48929]={512066}	-- The Assault Begins (You Are Now Prepared!)
G[47994]={512073}	-- Lightforged Warframe (Locked and Loaded)
G[48107]={512066,512073}	-- Dark Awakenings (You Are Now Prepared!), Shroud of Arcane Echoes (Locked and Loaded)
G[47220]={512066}	-- War of Light and Shadow (You Are Now Prepared!)
-- G[49224]={}	-- needed for achievement Now You're Cooking With Netherlight

if Grail.battleForAzeroth then
Grail.loremasterAchievements['Alliance'][mapZandalar] = {  }
Grail.loremasterAchievements['Horde'][mapZandalar] = { 511861, 511868, 512478, }
Grail.extraAchievements['Alliance'][mapZandalar] = { 512771, 512849, 512851, }
Grail.extraAchievements['Horde'][mapZandalar] = { 512555, 512771, 512849, 512851, }
Grail.loremasterAchievements['Alliance'][mapKulTiras] = { 512473, 512496, 512497, }
Grail.loremasterAchievements['Horde'][mapKulTiras] = { 512853, 512852, 512995, }
Grail.extraAchievements['Alliance'][mapKulTiras] = { 512510, 512853, 512852, 512995, }
Grail.extraAchievements['Horde'][mapKulTiras] = { 512509, }
G[47188]={511868}	-- Deep in the Swamp (The Dark Heart of Nazmir)
G[47189]={}	-- Come Sail Away () -- Alliance
G[47229]={}	-- (A Bargain of Blood)
G[47250]={511868}	-- A Pact with Death (The Dark Heart of Nazmir)
G[47440]={511861}	-- Zanchuli Council (The Throne of Zuldazar)
G[47528]={511861}	-- Web of Lies (The Throne of Zuldazar)
G[47601]={511868}	-- Bring the Boom (The Dark Heart of Nazmir)
G[47696]={511868}	-- A Friend of the Frogs (The Dark Heart of Nazmir)
G[47741]={511861}	-- Among the People (The Throne of Zuldazar)
G[47874]={512478}	-- The Warguard's Fate (Secrets in the Sands)
G[47879]={511861}	-- Warport Rastari (The Throne of Zuldazar)
G[47982]={512497}	-- The Final Effigy (Drust Do It)	-- Alliance
G[48088]={512473}	-- The Norwington Estate (A Sound Plan)	-- Alliance
G[48089]={512473}	-- The Norwington Estate (A Sound Plan)	-- Alliance
G[48198]={512497}	-- The Burden of Proof (Drust Do It)	-- Alliance
G[48421]={512473}	-- Castaways and Cutouts (A Sound Plan) -- Alliance
G[48505]={512473}	-- Castaways and Cutouts (A Sound Plan) -- Alliance
G[48538]={512497}	-- An Airtight Alibi (Drust Do It)	-- Alliance
G[48549]={512478}	-- Dangers in the Desert (Secrets in the Sands)
G[48550]={512478}	-- Dangers in the Desert (Secrets in the Sands)
G[48897]={511861}	-- Zanchuli Council (The Throne of Zuldazar)
G[48938]={512851}
G[48946]={512497}	-- The Order of Embers (Drust Do It)	-- Alliance
G[49082]={511868}	-- Undercover Sista (The Dark Heart of Nazmir)
G[49160]={511868}	-- Turtle Power (The Dark Heart of Nazmir)
G[49178]={512473}	-- Castaways and Cutouts (A Sound Plan) -- Alliance
G[49223]={513049}	-- The Long Con -- Alliance
G[49226]={512473}	-- Castaways and Cutouts (A Sound Plan) -- Alliance	-- TODO: Verify required
G[49230]={512473}	-- Castaways and Cutouts (A Sound Plan) -- Alliance
G[49257]={512851}
G[49302]={512473}	-- The Shadow Over Anglepoint (A Sound Plan) -- Alliance
G[49313]={512771}
G[49340]={512478}	-- The Three Keepers (Secrets in the Sands)
G[49404]={512473}	-- Freehold (A Sound Plan) -- Alliance
G[49426]={511861}	-- March of the Loa (The Throne of Zuldazar)
G[49483]={512771}
G[49484]={512771}
G[49663]={511861}	-- Portents and Prophecies (The Throne of Zuldazar)
G[49736]={512473}	-- Defenders of Daelin's Gate (A Sound Plan)	-- Alliance
G[49740]={512473}	-- Defenders of Daelin's Gate (A Sound Plan)	-- Alliance
G[49807]={512497}	-- A New Order (Drust Do It)	-- Alliance
G[49811]={512853}
G[49831]={512496}	-- From the Depths They Come (Stormsong and Dance)
G[49867]={512771}
G[49885]={512771}
G[49889]={512771}
G[49890]={512497}	-- Clear Victory (Drust Do It)	-- Alliance
G[49891]={512771}
G[49936]={512851}
G[49963]={512852}
G[49979]={512771}
G[49985]={511868}	-- Everything Contained (The Dark Heart of Nazmir)
G[49997]={512496}	-- A House in Peril (Stormsong and Dance)
G[50045]={512771}
G[50061]={512771}
G[50063]={512497}	-- Fighting With Fire (Drust Do It)	-- Alliance
G[50087]={511868}	-- Bleeding the Blood Trolls (The Dark Heart of Nazmir)
G[50089]={512853}
G[50237]={512849}
G[50259]={512851}
G[50442]={512852}
G[50457]={512497}	-- Break On Through (Drust Do It)	-- Alliance
G[50531]={512473}	-- The Ashvane Trading Company (A Sound Plan) -- Alliance
G[50533]={512497}	-- Sick It To 'Em (Drust Do It)	-- Alliance
G[50550]={512478}	-- Storming the Spire (Secrets in the Sands)
G[50526]={512853}
G[50561]={512478}	-- A City of Secrets (Secrets in the Sands)
G[50582]={512851}
G[50588]={512497}	-- Storming the Manor (Drust Do It)	-- Alliance
G[50611]={512496}	-- The Growing Tempest (Stormsong and Dance)
G[50640]={512496}	-- Briarback Kraul (Stormsong and Dance)
--G[50691]={512496}	-- Treasure in Deadwash (Stormsong and Dance)	-- Alliance	-- TODO: Verify required
G[50702]={512478}	-- Atul'Aman (Secrets in the Sands)
--G[50704]={512496}	-- Treasure in Deadwash (Stormsong and Dance)	-- Alliance	-- TODO: Verify required
G[50707]={512851}
G[50734]={512853}
G[50742]={512496}	-- Treasure in Deadwash (Stormsong and Dance)	-- Alliance
G[50824]={512496}	-- At the Edge of Madness (Stormsong and Dance)	-- Alliance
G[50881]={511861}	-- Port of Zandalar (The Throne of Zuldazar)
G[50937]={512853}
G[50947]={512851}
G[50949]={512851}
G[50972]={512473}	-- Enemies Within (A Sound Plan)	-- Alliance
G[51093]={512849}
G[51132]={512849}
G[51133]={512849}
G[51135]={512849}
G[51136]={512849}
G[51137]={512849}
G[51140]={512496}	-- Treasure in Deadwash (Stormsong and Dance)	-- Alliance
G[51338]={512851}
G[51364]={512478}	-- Unlikely Allies (Secrets in the Sands)
G[51401]={512496}	-- The Tidesages of Stormsong (Stormsong and Dance)	-- Alliance
G[51449]={512853}
G[51624]={512851}
G[51712]={512496}	-- Cycle of Hatred (Stormsong and Dance)
G[51825]={512473}	-- Enemies Within (A Sound Plan)	-- Alliance
G[51967]={512510}	-- Nazmir Foothold (Ready for War) -- Alliance
G[51968]={512510}	-- Zuldazar Foothold (Ready for War) -- Alliance
G[51969]={512510}	-- Vol'dun Foothold (Ready for War) -- Alliance
G[51986]={512509}	-- Stormsong Valley Foothold (Ready for War)	-- Horde
--G[52130]={513053}	-- Deadliest Catch	-- Alliance
G[52131]={512555}	-- Welcome to Zandalar -- Horde
G[52146]={512510}	-- Blood in the Sand (Ready for War) -- Alliance
G[52195]={512852}
G[52219]={512510}	-- Chasing Darkness (Ready for War) -- Alliance
G[52261]={512510}	-- A Golden Opportunity (Ready for War) -- Alliance
G[52326]={512853}
G[52429]={512853}
G[52496]={512510}	-- Blood in the Water (Ready for War) -- Alliance
G[52790]={512510}	-- The Strike on Zuldazar (Ready for War) -- Alliance
G[52807]={512852}
G[52833]={512852}
G[52836]={512852}
G[52845]={512852}
G[52866]={512852}
G[52867]={512852}
G[52870]={512852}
G[52976]={512853}
G[52980]={512853}
G[52992]={512849}
G[52994]={512849}
G[53004]={512849}
G[53356]={512995}
G[53357]={512995}
G[53385]={512995}
G[53386]={512995}
G[53387]={512995}
G[53471]={512995}
G[53472]={512995}
G[53473]={512995}
G[53474]={512995}
G[53475]={512995}
end

Grail.timings.AchievementsInitialSetup = debugprofilestop() - debugStartTime
debugStartTime = debugprofilestop()

Grail.questsLoremaster = {}

-- TODO: Need to delay this until after combat

-- Now create Grail.achievements by combining Grail.loremasterAchievements and Grail.extraAchievements
Grail.achievements = {}
for _, faction in pairs(supportedFactions) do
	Grail.achievements[faction] = {}
	for index, table in pairs(Grail.loremasterAchievements[faction]) do
		Grail.achievements[faction][index] = Grail:_TableAppend({}, table)
	end
	for index, table in pairs(Grail.extraAchievements[faction]) do
		Grail.achievements[faction][index] = Grail:_TableAppend(Grail.achievements[faction][index], table)
	end
end

Grail.timings.AchievementsFactionCreation = debugprofilestop() - debugStartTime
debugStartTime = debugprofilestop()

for questId, achs in pairs(G) do
	if achs ~= nil then
		-- Add this quest to its achievements
		for _, achievementId in pairs(achs) do
			if achievementId < Grail.mapAreaBaseAchievement and achievementId > 0 then
				if nil == Grail.loremasterQuests[achievementId] then Grail.loremasterQuests[achievementId] = {} end
				if not Grail.experimental then
					if not tContains(Grail.loremasterQuests[achievementId], questId) then tinsert(Grail.loremasterQuests[achievementId], questId) end
				else
					Grail:_MarkQuestInDatabase(questId, Grail.loremasterQuests[achievementId])
				end
				Grail.questsLoremaster[questId] = achievementId
			else
				local _, title = GetAchievementInfo(achievementId - Grail.mapAreaBaseAchievement)
				Grail:AddQuestToMapArea(questId, achievementId, title)
			end
		end
	end
end

wipe(G)
G = nil
Grail.timings.AchievementsInternalConversion = debugprofilestop() - debugStartTime

-- Now we generate the contents of the Loremaster achievements for Pandaria by looking at the specific quests
-- that are required and add all the quests that are prerequisites for those.
debugStartTime = debugprofilestop()
local achievementsDone = {}
local achievementsToZoneMapping = { [506300] = 806, [506301] = 807, [506534] = 806, [506535] = 857, [506536] = 857, [506537] = 809, [506538] = 809, [506539] = 810, [506540] = 858, [508671] = 941, [508845] = 947, [508919] = 946, [508920] = 946, [508923] = 949, [508924] = 949, [508925] = 948, [508926] = 948, [508927] = 950, [508928] = 950, [509528] = 947, [509529] = 941, [509602] = 947, [509605] = 948, [509606] = 941, [509607] = 949, [509615] = 950, [510617] = 1033, [509618] = 19, [509674] = 946, [510698] = 1018, [510763] = 1015, [510059] = 1024, [510756] = 1033, [510790] = 1017, [511124] = 1033, }
if Grail.battleForAzeroth then
	achievementsToZoneMapping = { [506300] = 371, [506301] = 376, [506534] = 371, [506535] = 418, [506536] = 418, [506537] = 379, [506538] = 379, [506539] = 388, [506540] = 422, [508671] = 525, [508845] = 539, [508919] = 535, [508920] = 535, [508923] = 543, [508924] = 543, [508925] = 542, [508926] = 542, [508927] = 550, [508928] = 550, [509528] = 539, [509529] = 525, [509602] = 539, [509605] = 542, [509606] = 525, [509607] = 543, [509615] = 550, [510617] = 680, [509618] = 17, [509674] = 535, [510698] = 641, [510763] = 630, [510059] = 650, [510756] = 680, [510790] = 634, [511124] = 680, [511861] = 862, [511868] = 863, [512478] = 864, [512473] = 895, [512496] = 942, [512497] = 896, [512509] = 862, [512510] = 895, [512555] = 862, }
end

local expansions = { mapPandaria, mapDraenor, mapBrokenIsles, mapArgus, mapKulTiras, }
for _, faction in pairs(supportedFactions) do
	for _, expansion in pairs(expansions) do
		for _, achievement in pairs(Grail.loremasterAchievements[faction][expansion]) do
			if not tContains(achievementsDone, achievement) then
				local newTable = {}
				for _, questId in pairs(Grail.indexedQuests[achievement]) do
					--	This check is made because processing of something earlier in the "master" list could result in a prerequisite being
					--	evaluated that occurs later in the "master" list and we do not want to add it and do more work than we need.
					if not tContains(newTable, questId) then
						tinsert(newTable, questId)
						local controlTable = { ["result"] = {}, ["preq"] = newTable, ["lastIndexUsed"] = 0, ["doMath"] = true }
						-- Get the entire list of prerequisites for questId and add them to newTable
						Grail._PreparePrerequisiteInfo(Grail:QuestPrerequisites(questId, true), controlTable)
					end
				end
				Grail.indexedQuests[achievement] = newTable
				local mappedZone = achievementsToZoneMapping[achievement]
				if nil ~= mappedZone then
					Grail.loremasterQuests[mappedZone] = Grail:_SetAppend(newTable, Grail.loremasterQuests[mappedZone])
				end
				tinsert(achievementsDone, achievement)
			end
		end
	end
end
wipe(achievementsDone)
achievementsDone = nil
Grail.timings.AchievementsPandariaLoremaster = debugprofilestop() - debugStartTime
Grail.memoryUsage.Achievements = gcinfo() - originalMem

end
