/*jslint vars: true, plusplus: true, devel: true, nomen: true, regexp: true, indent: 4, maxerr: 50 */
/*global $, window, location, CSInterface, SystemPath, themeManager*/



(function () {
    'use strict';

    var csInterface = new CSInterface();
    
    // Opens the chrome developer tools in host app
    function showDevTools() {
        window.__adobe_cep__.showDevTools();
    }
    
    // Reloads extension panel
    function reloadPanel() {
        location.reload();
    }
    
   
    
    // Loads / executes a jsx file
    function loadJSXFile(pPath) {
        var scriptPath = csInterface.getSystemPath(SystemPath.EXTENSION) + pPath;
        csInterface.evalScript('evalFile("' + scriptPath + '")');
    }
    
     
    var myPanelPath = csInterface.getSystemPath(SystemPath.EXTENSION);
    
    ///////////////////////////////////////////////////////////////////////////////
    // Function: Get Extension Path
    // Usage: 
    // Input: <nothing>
    // Return: <nothing>
    ///////////////////////////////////////////////////////////////////////////////

    function loadJSXFile(pPath) {
        var scriptPath = csInterface.getSystemPath(SystemPath.EXTENSION) + pPath;
        csInterface.evalScript('evalFile("' + scriptPath + '")');
    }
    
    ///////////////////////////////////////////////////////////////////////////////
    // Function: LoseFocus
    // Usage: Return keyboard focus back to Photoshop so Ctrl-N and others work
    // Input: <nothing>
    // Return: <nothing>
    ///////////////////////////////////////////////////////////////////////////////
   function LoseFocus() {
   var gExtensionId = "com.cromaline.PPWtools"
   var csEvent = new CSEvent("com.adobe.PhotoshopLoseFocus", "APPLICATION");
   csEvent.extensionId = gExtensionId; 
   csInterface.dispatchEvent(csEvent);
        
        
}
    
    
    

    
    
    
    function init() {
                
        themeManager.init();
       
   
        csInterface.onload =  csInterface.evalScript("LoadA('" + myPanelPath + "');");  
        

        
        $("#AdjustCurves").click(function () {
             csInterface.evalScript('EditCurve()');
            LoseFocus();
           
        });
        
        $("#MakeCurves").click(function () {
              csInterface.evalScript('MakeCurves()' )
            
        });
        
        $("#DuplicateLayer").click(function () {
              csInterface.evalScript('DuplicateLayer ()');
            LoseFocus();
             
        });
        
        $("#AddComposite").click(function () {
              csInterface.evalScript('AddComposite()');
            LoseFocus();
           
        });
        
        $("#ConvertLAB").click(function () {
              csInterface.evalScript('ConvertLAB()');
            LoseFocus();
        });
        
        $("#ConvertRGB").click(function () {
              csInterface.evalScript('ConvertRGB()');
            LoseFocus();
        });
        
        $("#BH").click(function () {
              csInterface.evalScript('BH()');
            LoseFocus();
        });
        
        
        $("#GB").click(function () {
              csInterface.evalScript('GB()');
            LoseFocus();
        });
        
        $("#SB").click(function () {
              csInterface.evalScript('SB()');
            LoseFocus();
        });
        
        $("#DS").click(function () {
              csInterface.evalScript('DS()');
            LoseFocus();
        });
		
		$("#HK").click(function () {
            loadJSXFile("/jsx/HK.jsx");
            LoseFocus();
        });
        
        $("#FalseCMYK").click(function () {
            loadJSXFile("/jsx/FalseCMYK.jsx");
            LoseFocus();
        });
        
         $("#Gamma10").click(function () {
            loadJSXFile("/jsx/Gamma10.jsx");
             LoseFocus();
        });
        
        $("#Gamma14").click(function () {
            loadJSXFile("/jsx/Gamma14.jsx");
            LoseFocus();
        });
        

        
        $("#SkySC").click(function () {
            loadJSXFile("/jsx/SkySC.jsx");
            LoseFocus();
        });
        
        
        $("#SkyB").click(function () {
            loadJSXFile("/jsx/SkyB.jsx");
            LoseFocus();
        });
        
        $("#Skin").click(function () {
            loadJSXFile("/jsx/Skin.jsx");
            LoseFocus();
        });
        
        $("#MMMCB").click(function () {
              csInterface.evalScript('MMMCB()');
            LoseFocus();
        });
        
        $("#MMM").click(function () {
              csInterface.evalScript('MMM()');
            LoseFocus();
        });
        
        
        $("#CB").click(function () {
            loadJSXFile("/jsx/CB.jsx");
            LoseFocus();
        });
        
        $("#SharpenOld").click(function () {
            loadJSXFile("/jsx/SharpenOld.jsx");
            LoseFocus();
        });
        
        $("#Sharpen2015").click(function () {
             csInterface.evalScript('Sharpen2015()');
            LoseFocus();
        });
        
        
         $("#SH").click(function () {
              csInterface.evalScript('SH()');
             LoseFocus();
        });
        
        
        
         $("#LH").click(function () {
              loadJSXFile("/jsx/LH.jsx");
             LoseFocus();
        });
        
          
         $("#VH").click(function () {
              loadJSXFile("/jsx/VH.jsx");
             LoseFocus();
        });
        
         $("#AssigProfPref").click(function () {
              loadJSXFile("/jsx/PreferencesFP.jsx");
             LoseFocus();
        });
        
        
          $("#ConversFlatPref").click(function () {
              loadJSXFile("/jsx/Preferences_Conversion_Flattening.jsx");
              LoseFocus();
        });
        
         
          $("#SharpenPref").click(function () {
              loadJSXFile("/jsx/PreferencesSharpen.jsx");
              LoseFocus();
        });
  
        
          $("#ResetAllPref").click(function () {
              loadJSXFile("/jsx/ResetAllPreferences.jsx");
              LoseFocus();
        });
  
        
          $("#ResetAction").click(function () {
             csInterface.evalScript("ReloadAction('" + myPanelPath + "');");    
              LoseFocus();
        });
  
                
           $("#ResetPresetSharpen").click(function () {
              loadJSXFile("/jsx/ResetSharpenPresets.jsx");
               LoseFocus();
        });
  
                       
          $("#tab3").click(function () {
          csInterface.evalScript('OpenColors()');
              LoseFocus();
        });
        
           $("#tab2").click(function () {
          csInterface.evalScript('OpenDocumentation()');
              LoseFocus();
        });
        
        
        $("#OtherGamma").click(function () {
             csInterface.evalScript("OtherGamma('" + myPanelPath + "');");    
              LoseFocus();
        });
       
                

           
     
        
        
    }
        
    init();

}());
    
