/*jslint vars: true, plusplus: true, devel: true, nomen: true, regexp: true, indent: 4, maxerr: 50 */
/*global $, window, location, CSInterface, SystemPath, themeManager*/



(function () {
    'use strict';

    var csInterface = new CSInterface();
    
    // Opens the chrome developer tools in host app
    function showDevTools() {
        window.__adobe_cep__.showDevTools();
    }
    
    // Reloads extension panel
    function reloadPanel() {
        location.reload();
    }
    

    
    ///////////////////////////////////////////////////////////////////////////////
    // Function: Get Extension Path
    // Usage: 
    // Input: <nothing>
    // Return: <nothing>
    ///////////////////////////////////////////////////////////////////////////////
    var myPanelPath = csInterface.getSystemPath(SystemPath.EXTENSION);
    function loadJSXFile(pPath) {
        //var scriptPath = csInterface.getSystemPath(SystemPath.EXTENSION) + pPath;
        csInterface.evalScript('evalFile("' + scriptPath + '")');
    }
    
    ///////////////////////////////////////////////////////////////////////////////
    // Function: LoseFocus
    // Usage: Return keyboard focus back to Photoshop so Ctrl-N and others work
    // Input: <nothing>
    // Return: <nothing>
    ///////////////////////////////////////////////////////////////////////////////
   function LoseFocus() {
   var gExtensionId = "com.cromaline.PPW-Documentation"
   var csEvent = new CSEvent("com.adobe.PhotoshopLoseFocus", "APPLICATION");
   csEvent.extensionId = gExtensionId; 
   csInterface.dispatchEvent(csEvent);
        
        
}
    

 
    
    function init() {
                
        themeManager.init();

                
        $("#Credits").click(function () {
	    csInterface.evalScript("Credits('" + myPanelPath + "');");     
        });
        
        $("#DocSH").click(function () {

	    csInterface.evalScript("DocSH('" + myPanelPath + "');");     
        });
        
        $("#DocBH").click(function () {

	    csInterface.evalScript("DocBH('" + myPanelPath + "');");     
        });
        

        $("#DocLVH").click(function () {

	    csInterface.evalScript("DocLVH('" + myPanelPath + "');");     
        });

        $("#DocDarkenSKY").click(function () {

	    csInterface.evalScript("DocDarkenSKY('" + myPanelPath + "');");     
        });
        
        $("#DocFP").click(function () {

	    csInterface.evalScript("DocFP('" + myPanelPath + "');");     
        });
        
        $("#DocHK").click(function () {

	    csInterface.evalScript("DocHK('" + myPanelPath + "');");     
        });
        
        $("#DocSHARPENING").click(function () {

	    csInterface.evalScript("DocSHARPENING('" + myPanelPath + "');");     
        });
        
        $("#DocMMMCB").click(function () {

	    csInterface.evalScript("DocMMMCB('" + myPanelPath + "');");     
        });
        
        $("#DocMMM").click(function () {

	    csInterface.evalScript("DocMMM('" + myPanelPath + "');");     
        });
        
        $("#DocCB").click(function () {

	    csInterface.evalScript("DocCB('" + myPanelPath + "');");     
        });
        
        $("#DocSKIN").click(function () {

	    csInterface.evalScript("DocSKIN('" + myPanelPath + "');");     
        });
        
        $("#Manual").click(function () {

	    csInterface.evalScript("Manual('" + myPanelPath + "');");     
        });
        
        $("#Overview").click(function () {
        
	    csInterface.evalScript("Overview('" + myPanelPath + "');");     
        });
        
        $("#VersionHistory").click(function () {
        
	    csInterface.evalScript("VersionHistory('" + myPanelPath + "');");     
        });
        
        $("#Movie").click(function () { 
       
         try{csInterface.openURLInDefaultBrowser('http://www.moderncolorworkflow.com/video-demo'); }catch(e){}
        });
        
     
        
        $("#GetUpdate").click(function () { 
          
         try{csInterface.openURLInDefaultBrowser('http://www.moderncolorworkflow.com/free-resources'); }catch(e){}
        });
        
        $("#Truobleshooting").click(function () { 
          
         try{csInterface.openURLInDefaultBrowser('http://www.moderncolorworkflow.com/troubleshooting-ppw-panel-installation'); }catch(e){}
        });

                $("#Classes").click(function () { 
          
         try{csInterface.openURLInDefaultBrowser('https://www.ledet.com/margulis'); }catch(e){}
        });

        
                $("#Book").click(function () { 
          
         try{csInterface.openURLInDefaultBrowser('http://www.moderncolorworkflow.com'); }catch(e){}
        });

     
     
        
        
    }
        
    init();

}());
    
