NUTOOL_PIN.g_cfg_chips = [
	//NUC100AN BN
	// { name: "NUC100VD2AN", pkg: "LQFP100" },
	// { name: "NUC100VD3AN", pkg: "LQFP100" },
	// { name: "NUC100VE3AN", pkg: "LQFP100" },
	// { name: "NUC120VD2AN", pkg: "LQFP100" },
	// { name: "NUC120VD3AN", pkg: "LQFP100" },
	// { name: "NUC120VE3AN", pkg: "LQFP100" },
	// { name: "NUC100RD3AN", pkg: "LQFP64" },
	// { name: "NUC100RE3AN", pkg: "LQFP64" },
	// { name: "NUC100RC1BN", pkg: "LQFP64" },
	// { name: "NUC100RD1BN", pkg: "LQFP64" },
	// { name: "NUC100RD2BN", pkg: "LQFP64" },
	// { name: "NUC120RD3AN", pkg: "LQFP64" },
	// { name: "NUC120RE3AN", pkg: "LQFP64" },
	// { name: "NUC120RC1BN", pkg: "LQFP64" },
	// { name: "NUC120RD1BN", pkg: "LQFP64" },
	// { name: "NUC120RD2BN", pkg: "LQFP64" },
	// { name: "NUC100LD3AN", pkg: "LQFP48" },
	// { name: "NUC100LE3AN", pkg: "LQFP48" },
	// { name: "NUC100LC1BN", pkg: "LQFP48" },
	// { name: "NUC100LD1BN", pkg: "LQFP48" },
	// { name: "NUC100LD2BN", pkg: "LQFP48" },
	// { name: "NUC120LD3AN", pkg: "LQFP48" },
	// { name: "NUC120LE3AN", pkg: "LQFP48" },
	// { name: "NUC120LC1BN", pkg: "LQFP48" },
	// { name: "NUC120LD1BN", pkg: "LQFP48" },
	// { name: "NUC120LD2BN", pkg: "LQFP48" },
	//NUC100CN
	{ name: "NUC130VE3CN", pkg: "LQFP100" },
	{ name: "NUC140VE3CN", pkg: "LQFP100" },
	{ name: "NUC130RC1CN", pkg: "LQFP64" },
	{ name: "NUC130RD2CN", pkg: "LQFP64" },
	{ name: "NUC130RE3CN", pkg: "LQFP64" },
	{ name: "NUC140RC1CN", pkg: "LQFP64" },
	{ name: "NUC140RD2CN", pkg: "LQFP64" },
	{ name: "NUC140RE3CN", pkg: "LQFP64" },
	{ name: "NUC130LC1CN", pkg: "LQFP48" },
	{ name: "NUC130LD2CN", pkg: "LQFP48" },
	{ name: "NUC130LE3CN", pkg: "LQFP48" },
	{ name: "NUC140LC1CN", pkg: "LQFP48" },
	{ name: "NUC140LD2CN", pkg: "LQFP48" },
	{ name: "NUC140LE3CN", pkg: "LQFP48" },
	//NUC100DN
	//{ name: "NUC100VD2DN", pkg: "LQFP100" },
	//{ name: "NUC100VD3DN", pkg: "LQFP100" },
	{ name: "NUC100VE3DN", pkg: "LQFP100" },
	{ name: "NUC100RC1DN", pkg: "LQFP64" },
	{ name: "NUC100RD1DN", pkg: "LQFP64" },
	{ name: "NUC100RD2DN", pkg: "LQFP64" },
	//{ name: "NUC100RD3DN", pkg: "LQFP64" },
	{ name: "NUC100RE3DN", pkg: "LQFP64" },
	{ name: "NUC100LC1DN", pkg: "LQFP48" },
	//{ name: "NUC100LD1DN", pkg: "LQFP48" },
	{ name: "NUC100LD2DN", pkg: "LQFP48" },
	//{ name: "NUC100LD3DN", pkg: "LQFP48" },
	{ name: "NUC100LE3DN", pkg: "LQFP48" },
	//{ name: "NUC120VD2DN", pkg: "LQFP100" },
	//{ name: "NUC120VD3DN", pkg: "LQFP100" },
	{ name: "NUC120VE3DN", pkg: "LQFP100" },
	{ name: "NUC120RC1DN", pkg: "LQFP64" },
	//{ name: "NUC120RD1DN", pkg: "LQFP64" },
	{ name: "NUC120RD2DN", pkg: "LQFP64" },
	//{ name: "NUC120RD3DN", pkg: "LQFP64" },
	{ name: "NUC120RE3DN", pkg: "LQFP64" },
	{ name: "NUC120LC1DN", pkg: "LQFP48" },
	//{ name: "NUC120LD1DN", pkg: "LQFP48" },
	{ name: "NUC120LD2DN", pkg: "LQFP48" },
	//{ name: "NUC120LD3DN", pkg: "LQFP48" },
	{ name: "NUC120LE3DN", pkg: "LQFP48" },
	//NUC131
	{ name: "NUC131SC2AE", pkg: "LQFP64" },
	{ name: "NUC131SD2AE", pkg: "LQFP64" },
	{ name: "NUC131LC2AE", pkg: "LQFP48" },
	{ name: "NUC131LD2AE", pkg: "LQFP48" },
	//NUC121AE
	{ name: "NUC121SC2AE", pkg: "LQFP64" },
	{ name: "NUC121LC2AE", pkg: "LQFP48" },
	{ name: "NUC121ZC2AE", pkg: "QFN33" },
	{ name: "NUC125SC2AE", pkg: "LQFP64" },
	{ name: "NUC125LC2AE", pkg: "LQFP48" },
	{ name: "NUC125ZC2AE", pkg: "QFN33" },
	//NUC122AN
	//{ name: "NUC122ZD2AN", pkg: "QFN33" },
	//{ name: "NUC122ZC1AN", pkg: "QFN33" },
	//{ name: "NUC122LD2AN", pkg: "LQFP48" },
	//{ name: "NUC122LC1AN", pkg: "LQFP48" },
	//{ name: "NUC122SD2AN", pkg: "LQFP64" },
	//{ name: "NUC122SC1AN", pkg: "LQFP64" },
	//NUC123AN
	{ name: "NUC123ZD4AN0", pkg: "QFN33" },
	{ name: "NUC123ZC2AN1", pkg: "QFN33" },
	{ name: "NUC123LD4AN0", pkg: "LQFP48" },
	{ name: "NUC123LC2AN1", pkg: "LQFP48" },
	{ name: "NUC123SD4AN0", pkg: "LQFP64" },
	{ name: "NUC123SC2AN1", pkg: "LQFP64" },
	//NUC123AE
	{ name: "NUC123ZD4AE0", pkg: "QFN33" },
	{ name: "NUC123ZC2AE1", pkg: "QFN33" },
	{ name: "NUC123SD4AE0", pkg: "LQFP64" },
	{ name: "NUC123SC2AE1", pkg: "LQFP64" },
	{ name: "NUC123LD4AE0", pkg: "LQFP48" },
	{ name: "NUC123LC2AE1", pkg: "LQFP48" },
	// NUC126
	{ name: "NUC126LE4AE", pkg: "LQFP48" },
	{ name: "NUC126LG4AE", pkg: "LQFP48" },
	{ name: "NUC126SE4AE", pkg: "LQFP64" },
	{ name: "NUC126SG4AE", pkg: "LQFP64" },
	{ name: "NUC126VG4AE", pkg: "LQFP100" },
	// NUC1261
	{ name: "NUC1261LG4AE", pkg: "LQFP48" },
	{ name: "NUC1261LE4AE", pkg: "LQFP48" },
	{ name: "NUC1261NE4AE", pkg: "LQFP48" },
	{ name: "NUC1261SG4AE", pkg: "LQFP64" },
	{ name: "NUC1261SE4AE", pkg: "LQFP64" }
];

NUTOOL_PIN.g_cfg_pkgs = {
	"LQFP100(NUC130)": [
		'PE.15', 'PE.14', 'PE.13', 'PB.14', 'PB.13', 'PB.12', 'X32O', 'X32I', 'PA.11', 'PA.10',
		'PA.9', 'PA.8', 'PD.8', 'PD.9', 'PD.10', 'PD.11', 'PD.12', 'PD.13', 'PB.4', 'PB.5',
		'PB.6', 'PB.7', 'LDO', 'VDD', 'VSS',
		'PE.12', 'PE.11', 'PE.10', 'PE.9', 'PE.8', 'PE.7', 'PB.0', 'PB.1', 'PB.2', 'PB.3',
		'PD.6', 'PD.7', 'PD.14', 'PD.15', 'PC.5', 'PC.4', 'PC.3', 'PC.2', 'PC.1', 'PC.0',
		'PE.6', 'PE.5', 'PB.11', 'PB.10', 'PB.9',
		'PE.4', 'PE.3', 'PE.2', 'PE.1', 'PE.0', 'PC.13', 'PC.12', 'PC.11', 'PC.10', 'PC.9',
		'PC.8', 'PA.15', 'PA.14', 'PA.13', 'PA.12', 'ICE_DAT', 'ICE_CK', 'VDD', 'VSS', 'AVSS',
		'PA.0', 'PA.1', 'PA.2', 'PA.3', 'PA.4',
		'PA.5', 'PA.6', 'PA.7', 'VREF', 'AVDD', 'PD.0', 'PD.1', 'PD.2', 'PD.3', 'PD.4',
		'PD.5', 'PC.7', 'PC.6', 'PC.15', 'PC.14', 'PB.15', 'XT1_OUT', 'XT1_IN', '/RESET', 'VSS',
		'VDD', 'PS2DAT', 'PS2CLK', 'PVSS', 'PB.8'
	],
	"LQFP64(NUC130)": [
		'PB.14', 'PB.13', 'PB.12', 'X32O', 'X32I', 'PA.11', 'PA.10', 'PA.9', 'PA.8', 'PB.4',
		'PB.5', 'PB.6', 'PB.7', 'LDO', 'VDD', 'VSS',
		'PB.0', 'PB.1', 'PB.2', 'PB.3', 'PD.6', 'PD.7', 'PD.14', 'PD.15', 'PC.3', 'PC.2',
		'PC.1', 'PC.0', 'PE.5', 'PB.11', 'PB.10', 'PB.9',
		'PC.11', 'PC.10', 'PC.9', 'PC.8', 'PA.15', 'PA.14', 'PA.13', 'PA.12', 'ICE_DAT', 'ICE_CK',
		'AVSS', 'PA.0', 'PA.1', 'PA.2', 'PA.3', 'PA.4',
		'PA.5', 'PA.6', 'PA.7', 'AVDD', 'PC.7', 'PC.6', 'PC.15', 'PC.14', 'PB.15', 'XT1_OUT',
		'XT1_IN', '/RESET', 'VSS', 'VDD', 'PVSS', 'PB.8'
	],
	"LQFP48(NUC130)": [
		'PB.12', 'X32O', 'X32I', 'PA.11', 'PA.10', 'PA.9', 'PA.8', 'PB.4', 'PB.5', 'LDO',
		'VDD', 'VSS',
		'PB.0', 'PB.1', 'PB.2', 'PB.3', 'PD.6', 'PD.7', 'PD.14', 'PD.15', 'PC.3', 'PC.2',
		'PC.1', 'PC.0',
		'PA.15', 'PA.14', 'PA.13', 'PA.12', 'ICE_DAT', 'ICE_CK', 'AVSS', 'PA.0', 'PA.1', 'PA.2',
		'PA.3', 'PA.4',
		'PA.5', 'PA.6', 'PA.7', 'AVDD', 'PC.7', 'PC.6', 'PB.15', 'XT1_OUT', 'XT1_IN', '/RESET',
		'PVSS', 'PB.8'
	],
	"LQFP100(NUC140)": [
		'PE.15', 'PE.14', 'PE.13', 'PB.14', 'PB.13', 'PB.12', 'X32O', 'X32I', 'PA.11', 'PA.10',
		'PA.9', 'PA.8', 'PD.8', 'PD.9', 'PD.10', 'PD.11', 'PD.12', 'PD.13', 'PB.4', 'PB.5',
		'PB.6', 'PB.7', 'LDO', 'VDD', 'VSS',
		'PE.8', 'PE.7', 'VBUS', 'VDD33', 'D-', 'D+', 'PB.0', 'PB.1', 'PB.2', 'PB.3',
		'PD.6', 'PD.7', 'PD.14', 'PD.15', 'PC.5', 'PC.4', 'PC.3', 'PC.2', 'PC.1', 'PC.0',
		'PE.6', 'PE.5', 'PB.11', 'PB.10', 'PB.9',
		'PE.4', 'PE.3', 'PE.2', 'PE.1', 'PE.0', 'PC.13', 'PC.12', 'PC.11', 'PC.10', 'PC.9',
		'PC.8', 'PA.15', 'PA.14', 'PA.13', 'PA.12', 'ICE_DAT', 'ICE_CK', 'VDD', 'VSS', 'AVSS',
		'PA.0', 'PA.1', 'PA.2', 'PA.3', 'PA.4',
		'PA.5', 'PA.6', 'PA.7', 'VREF', 'AVDD', 'PD.0', 'PD.1', 'PD.2', 'PD.3', 'PD.4',
		'PD.5', 'PC.7', 'PC.6', 'PC.15', 'PC.14', 'PB.15', 'XT1_OUT', 'XT1_IN', '/RESET', 'VSS',
		'VDD', 'PS2DAT', 'PS2CLK', 'PVSS', 'PB.8'
	],
	"LQFP64(NUC140)": [
		'PB.14', 'PB.13', 'PB.12', 'X32O', 'X32I', 'PA.11', 'PA.10', 'PA.9', 'PA.8', 'PB.4',
		'PB.5', 'PB.6', 'PB.7', 'LDO', 'VDD', 'VSS',
		'VBUS', 'VDD33', 'D-', 'D+', 'PB.0', 'PB.1', 'PB.2', 'PB.3', 'PD.6', 'PD.7',
		'PD.14', 'PD.15', 'PC.3', 'PC.2', 'PC.1', 'PC.0',
		'PC.11', 'PC.10', 'PC.9', 'PC.8', 'PA.15', 'PA.14', 'PA.13', 'PA.12', 'ICE_DAT', 'ICE_CK',
		'AVSS', 'PA.0', 'PA.1', 'PA.2', 'PA.3', 'PA.4',
		'PA.5', 'PA.6', 'PA.7', 'AVDD', 'PC.7', 'PC.6', 'PC.15', 'PC.14', 'PB.15', 'XT1_OUT',
		'XT1_IN', '/RESET', 'VSS', 'VDD', 'PVSS', 'PB.8'
	],
	"LQFP48(NUC140)": [
		'PB.12', 'X32O', 'X32I', 'PA.11', 'PA.10', 'PA.9', 'PA.8', 'PB.4', 'PB.5', 'LDO',
		'VDD', 'VSS',
		'VBUS', 'VDD33', 'D-', 'D+', 'PB.0', 'PB.1', 'PD.6', 'PD.7', 'PC.3', 'PC.2',
		'PC.1', 'PC.0',
		'PA.15', 'PA.14', 'PA.13', 'PA.12', 'ICE_DAT', 'ICE_CK', 'AVSS', 'PA.0', 'PA.1', 'PA.2',
		'PA.3', 'PA.4',
		'PA.5', 'PA.6', 'PA.7', 'AVDD', 'PC.7', 'PC.6', 'PB.15', 'XT1_OUT', 'XT1_IN', '/RESET',
		'PVSS', 'PB.8'
	]
};

NUTOOL_PIN.g_cfg_gpios = [
	{ f: ['PA.0:0', 'ADC0:1'] },
	{ f: ['PA.1:0', 'ADC1:1', 'AD12:7'] },
	{ f: ['PA.2:0', 'ADC2:1', 'AD11:7'] },
	{ f: ['PA.3:0', 'ADC3:1', 'AD10:7'] },
	{ f: ['PA.4:0', 'ADC4:1', 'AD9:7'] },
	{ f: ['PA.5:0', 'ADC5:1', 'AD8:7'] },
	{ f: ['PA.6:0', 'ADC6:1', 'AD7:3'] },
	{ f: ['PA.7:0', 'ADC7:1', 'SPISS21:3', 'AD6:5'] },
	{ f: ['PA.8:0', 'I2C0SDA:1'] },
	{ f: ['PA.9:0', 'I2C0SCL:1'] },
	{ f: ['PA.10:0', 'I2C1SDA:1', 'nWR:3'] },
	{ f: ['PA.11:0', 'I2C1SCL:1', 'nRD:3'] },
	{ f: ['PA.12:0', 'PWM0:1', 'AD13:7'] },
	{ f: ['PA.13:0', 'PWM1:1', 'AD14:7'] },
	{ f: ['PA.14:0', 'PWM2:1', 'AD15:7'] },
	{ f: ['PA.15:0', 'PWM3:1', 'I2SMCLK:3'] },

	{ f: ['PB.0:0', 'RXD0:1'] },
	{ f: ['PB.1:0', 'TXD0:1'] },
	{ f: ['PB.2:0', 'RTS0:2', 'T2EX:3', 'nWRL:14'] },
	{ f: ['PB.3:0', 'CTS0:2', 'T3EX:3', 'nWRH:14'] },
	{ f: ['PB.4:0', 'RXD1:1'] },
	{ f: ['PB.5:0', 'TXD1:1'] },
	{ f: ['PB.6:0', 'RTS1:1', 'ALE:3'] },
	{ f: ['PB.7:0', 'CTS1:1', 'nCS:3'] },
	{ f: ['PB.8:0', 'TM0:1', 'STADC:2'] },
	{ f: ['PB.9:0', 'TM1:1', 'SPISS11:3'] },
	{ f: ['PB.10:0', 'TM2:1', 'SPISS01:3'] },
	{ f: ['PB.11:0', 'TM3:1', 'PWM4:3'] },
	{ f: ['PB.12:0', 'CPO0:1', 'CLKO:3', 'AD0:5'] },
	{ f: ['PB.13:0', 'CPO1:1', 'AD1:3'] },
	{ f: ['PB.14:0', 'INT0:1', 'SPISS31:3'] },
	{ f: ['PB.15:0', 'INT1:1', 'T0EX:3'] },

	{ f: ['PC.0:0', 'SPISS00:1', 'I2SLRCLK:3'] },
	{ f: ['PC.1:0', 'SPICLK0:1', 'I2SBCLK:3'] },
	{ f: ['PC.2:0', 'MISO00:1', 'I2SDI:3'] },
	{ f: ['PC.3:0', 'MOSI00:1', 'I2SDO:3'] },
	{ f: ['PC.4:0', 'MISO01:1'] },
	{ f: ['PC.5:0', 'MOSI01:1'] },
	{ f: ['PC.6:0', 'CPP0:1', 'AD4:3'] },
	{ f: ['PC.7:0', 'CPN0:1', 'AD5:3'] },
	{ f: ['PC.8:0', 'SPISS10:1', 'MCLK:7'] },
	{ f: ['PC.9:0', 'SPICLK1:1'] },
	{ f: ['PC.10:0', 'MISO10:1'] },
	{ f: ['PC.11:0', 'MOSI10:1'] },
	{ f: ['PC.12:0', 'MISO11:1'] },
	{ f: ['PC.13:0', 'MOSI11:1'] },
	{ f: ['PC.14:0', 'CPP1:1', 'AD2:3'] },
	{ f: ['PC.15:0', 'CPN1:1', 'AD3:3'] },

	{ f: ['PD.0:0', 'SPISS20:1'] },
	{ f: ['PD.1:0', 'SPICLK2:1'] },
	{ f: ['PD.2:0', 'MISO20:1'] },
	{ f: ['PD.3:0', 'MOSI20:1'] },
	{ f: ['PD.4:0', 'MISO21:1'] },
	{ f: ['PD.5:0', 'MOSI21:1'] },
	{ f: ['PD.6:0', 'CANRX0:1'] },
	{ f: ['PD.7:0', 'CANTX0:1'] },
	{ f: ['PD.8:0', 'SPISS30:1'] },
	{ f: ['PD.9:0', 'SPICLK3:1'] },
	{ f: ['PD.10:0', 'MISO30:1'] },
	{ f: ['PD.11:0', 'MOSI30:1'] },
	{ f: ['PD.12:0', 'MISO31:1'] },
	{ f: ['PD.13:0', 'MOSI31:1'] },
	{ f: ['PD.14:0', 'RXD2:1'] },
	{ f: ['PD.15:0', 'TXD2:1'] },

	{ f: ['PE.0:0', 'PWM6:1'] },
	{ f: ['PE.1:0', 'PWM7:1'] },
	{ f: ['PE.2:0'] },
	{ f: ['PE.3:0'] },
	{ f: ['PE.4:0'] },
	{ f: ['PE.5:0', 'PWM5:1', 'T1EX:3'] },
	{ f: ['PE.6:0'] },
	{ f: ['PE.7:0'] },
	{ f: ['PE.8:0'] },
	{ f: ['PE.9:0'] },
	{ f: ['PE.10:0'] },
	{ f: ['PE.11:0'] },
	{ f: ['PE.12:0'] },
	{ f: ['PE.13:0'] },
	{ f: ['PE.14:0'] },
	{ f: ['PE.15:0'] }
];

NUTOOL_PIN.g_cfg_gpiosDefines = [];
NUTOOL_PIN.g_cfg_gpiosDescriptions = [
	'/RESET:External reset input: Low active, set this pin low reset chip to initial state. With internal pull-up',

	'AD0:EBI Address/Data bus bit0',
	'AD1:EBI Address/Data bus bit1',
	'AD2:EBI Address/Data bus bit 2',
	'AD3:EBI Address/Data bus bit 3',
	'AD4:EBI Address/Data bus bit 4',
	'AD5:EBI Address/Data bus bit 5',
	'AD6:EBI Address/Data bus bit6',
	'AD7:EBI Address/Data bus bit7',
	'AD8:EBI Address/Data bus bit8',
	'AD9:EBI Address/Data bus bit9',
	'AD10:EBI Address/Data bus bit10',
	'AD11:EBI Address/Data bus bit11',
	'AD12:EBI Address/Data bus bit12',
	'AD13:EBI Address/Data bus bit13',
	'AD14:EBI Address/Data bus bit14',
	'AD15:EBI Address/Data bus bit15',

	'ADC0:ADC analog input',
	'ADC1:ADC analog input',
	'ADC2:ADC analog input',
	'ADC3:ADC analog input',
	'ADC4:ADC analog input',
	'ADC5:ADC analog input',
	'ADC6:ADC analog input',
	'ADC7:ADC analog input',

	'ALE:EBI address latch enable output pin',
	'AVDD:Power supply for internal analog circuit',
	'AVSS:Ground Pin for analog circuit',

	'CANRX0:CAN Bus0 RX Input',
	'CANTX0:CAN Bus0 TX Output',
	'CLKO:Frequency Divider output pin',

	'CPN0:Comparator0 Negative input pin',
	'CPN1:Comparator1 Negative input pin',
	'CPO0:Comparator0 output pin',
	'CPO1:Comparator1 output pin',
	'CPP0:Comparator0 Positive input pin',
	'CPP1:Comparator1 Positive input pin',

	'CTS0:Clear to Send input pin for UART0',
	'CTS1:Clear to Send input pin for UART1',

	'D-:USB Differential Signal D-',
	'D+:USB Differential Signal D+',

	'I2C0SCL:I2C0 clock pin',
	'I2C0SDA:I2C0 data I/O pin',
	'I2C1SCL:I2C1 clock pin',
	'I2C1SDA:I2C1 data I/O pin',

	'I2SBCLK:I2S bit clock pin',
	'I2SDI:I2S data input',
	'I2SDO:I2S data output',
	'I2SLRCLK:I2S left right channel clock',
	'I2SMCLK:I2S master clock output pin',

	'ICE_CK:Serial Wired Debugger Clock pin',
	'ICE_DAT:Serial Wired Debugger Data pin',

	'INT0:External interrupt0 input pin',
	'INT1:External interrupt1 input pin',

	'LDO:LDO output pin',
	'MCLK:EBI clock output',

	'MISO00:SPI0 MISO (Master In, Slave Out) pin',
	'MISO01:SPI0 2nd MISO (Master In, Slave Out) pin',
	'MISO10:SPI1 MISO (Master In, Slave Out) pin',
	'MISO11:SPI1 2nd MISO (Master In, Slave Out) pin',
	'MISO20:SPI2 MISO (Master In, Slave Out) pin',
	'MISO21:SPI2 2nd MISO (Master In, Slave Out) pin',
	'MISO30:SPI3 MISO (Master In, Slave Out) pin',
	'MISO31:SPI3 2nd MISO (Master In, Slave Out) pin',
	'MOSI00:SPI0 MOSI (Master Out, Slave In) pin',
	'MOSI01:SPI0 2nd MOSI (Master Out, Slave In) pin',
	'MOSI10:SPI1 MOSI (Master Out, Slave In) pin',
	'MOSI11:SPI1 2nd MOSI (Master Out, Slave In) pin',
	'MOSI20:SPI2 MOSI (Master Out, Slave In) pin',
	'MOSI21:SPI2 2nd MOSI (Master Out, Slave In) pin',
	'MOSI30:SPI3 MOSI (Master Out, Slave In) pin',
	'MOSI31:SPI3 2nd MOSI (Master Out, Slave In) pin',

	'nCS:EBI chip select enable output pin',
	'nRD:EBI read enable output pin',
	'nWR:EBI write enable output pin',
	'nWRH:EBI high byte write enable output pin',
	'nWRL:EBI low byte write enable output pin',

	'PS2CLK:PS/2 clock pin',
	'PS2DAT:PS/2 Data pin',
	'PVSS:PLL Ground',

	'PWM0:PWM output/Capture input',
	'PWM1:PWM output/Capture input',
	'PWM2:PWM output/Capture input',
	'PWM3:PWM output/Capture input',
	'PWM4:PWM output/Capture input',
	'PWM5:PWM output/Capture input',
	'PWM6:PWM output/Capture input',
	'PWM7:PWM output/Capture input',

	'RTS0:Request to Send output pin for UART0',
	'RTS1:Request to Send output pin for UART1',

	'RXD0:Data receiver input pin for UART0',
	'RXD1:Data receiver input pin for UART1',
	'RXD2:Data receiver input pin for UART2',

	'SPICLK0:SPI0 serial clock pin',
	'SPICLK1:SPI1 serial clock pin',
	'SPICLK2:SPI2 serial clock pin',
	'SPICLK3:SPI3 serial clock pin',
	'SPISS00:SPI0 slave select pin',
	'SPISS01:SPI0 2nd slave select pin',
	'SPISS10:SPI1 slave select pin',
	'SPISS11:SPI1 2nd slave select pin',
	'SPISS20:SPI2 slave select pin',
	'SPISS21:SPI2 2nd slave select pin',
	'SPISS30:SPI3 slave select pin',
	'SPISS31:SPI3 2nd slave select pin',

	'STADC:ADC external trigger input',

	'T0EX:Timer 0 external capture input pin',
	'T1EX:Timer1 external capture input pin',
	'T2EX:Timer2 external capture input pin',
	'T3EX:Timer3 external capture input pin',

	'TM0:Timer0 event counter input / toggle output',
	'TM1:Timer1 event counter input / toggle output',
	'TM2:Timer2 event counter input / toggle output',
	'TM3:Timer3 event counter input / toggle output',

	'TXD0:Data transmitter output pin for UART0',
	'TXD1:Data transmitter output pin for UART1',
	'TXD2:Data transmitter output pin for UART2',

	'VBUS:POWER SUPPLY: From USB Host or HUB',
	'VDD:Power supply for I/O ports and LDO source for internal PLL and digital circuit',
	'VDD33:Internal Power Regulator Output 3.3 V Decoupling Pin',
	'VREF:Voltage reference input for ADC',
	'VSS:Ground',

	'X32I:External 32.768 kHz low speed crystal input pin',
	'X32O:External 32.768 kHz low speed crystal output pin',
	'XT1_IN:External 4~24 MHz high speed crystal input pin',
	'XT1_OUT:External 4~24 MHz high speed crystal output pin'
];

NUTOOL_PIN.g_cfg_regDescriptions = {};
NUTOOL_PIN.g_cfg_regDescriptions.GPA_MFP = '0x50000030';
NUTOOL_PIN.g_cfg_regDescriptions.GPB_MFP = '0x50000034';
NUTOOL_PIN.g_cfg_regDescriptions.GPC_MFP = '0x50000038';
NUTOOL_PIN.g_cfg_regDescriptions.GPD_MFP = '0x5000003C';
NUTOOL_PIN.g_cfg_regDescriptions.GPE_MFP = '0x50000040';
NUTOOL_PIN.g_cfg_regDescriptions.ALT_MFP = '0x50000050';

NUTOOL_PIN.g_cfg_gpioMatrix = [
	{ f: ['PA.0', 'GPA_MFP[0]:0'] },
	{ f: ['PA.1', 'GPA_MFP[1]:0', 'ALT_MFP[11]:1', 'ALT_MFP[20]:2'] },
	{ f: ['PA.2', 'GPA_MFP[2]:0', 'ALT_MFP[11]:1', 'ALT_MFP[19]:2'] },
	{ f: ['PA.3', 'GPA_MFP[3]:0', 'ALT_MFP[11]:1', 'ALT_MFP[18]:2'] },
	{ f: ['PA.4', 'GPA_MFP[4]:0', 'ALT_MFP[11]:1', 'ALT_MFP[17]:2'] },
	{ f: ['PA.5', 'GPA_MFP[5]:0', 'ALT_MFP[11]:1', 'ALT_MFP[16]:2'] },
	{ f: ['PA.6', 'GPA_MFP[6]:0', 'ALT_MFP[11]:1'] },
	{ f: ['PA.7', 'GPA_MFP[7]:0', 'ALT_MFP[2]:1', 'ALT_MFP[11]:2'] },
	{ f: ['PA.8', 'GPA_MFP[8]:0'] },
	{ f: ['PA.9', 'GPA_MFP[9]:0'] },
	{ f: ['PA.10', 'GPA_MFP[10]:0', 'ALT_MFP[11]:1'] },
	{ f: ['PA.11', 'GPA_MFP[11]:0', 'ALT_MFP[11]:1'] },
	{ f: ['PA.12', 'GPA_MFP[12]:0', 'ALT_MFP[11]:1', 'ALT_MFP[21]:2'] },
	{ f: ['PA.13', 'GPA_MFP[13]:0', 'ALT_MFP[11]:1', 'ALT_MFP[22]:2'] },
	{ f: ['PA.14', 'GPA_MFP[14]:0', 'ALT_MFP[11]:1', 'ALT_MFP[23]:2'] },
	{ f: ['PA.15', 'GPA_MFP[15]:0', 'ALT_MFP[9]:1'] },

	{ f: ['PB.0', 'GPB_MFP[0]:0'] },
	{ f: ['PB.1', 'GPB_MFP[1]:0'] },
	{ f: ['PB.2', 'ALT_MFP[26]:0', 'GPB_MFP[2]:1', 'ALT_MFP[11]:2', 'ALT_MFP[13]:3'] },
	{ f: ['PB.3', 'ALT_MFP[27]:0', 'GPB_MFP[3]:1', 'ALT_MFP[11]:2', 'ALT_MFP[14]:3'] },
	{ f: ['PB.4', 'GPB_MFP[4]:0'] },
	{ f: ['PB.5', 'GPB_MFP[5]:0'] },
	{ f: ['PB.6', 'GPB_MFP[6]:0', 'ALT_MFP[11]:1'] },
	{ f: ['PB.7', 'GPB_MFP[7]:0', 'ALT_MFP[11]:1'] },
	{ f: ['PB.8', 'GPB_MFP[8]:0', 'ALT_MFP2[24]:1'] },
	{ f: ['PB.9', 'GPB_MFP[9]:0', 'ALT_MFP[1]:1'] },
	{ f: ['PB.10', 'GPB_MFP[10]:0', 'ALT_MFP[0]:1'] },
	{ f: ['PB.11', 'GPB_MFP[11]:0', 'ALT_MFP[4]:1'] },
	{ f: ['PB.12', 'GPB_MFP[12]:0', 'ALT_MFP[10]:1', 'ALT_MFP[11]:2'] },
	{ f: ['PB.13', 'GPB_MFP[13]:0', 'ALT_MFP[11]:1'] },
	{ f: ['PB.14', 'GPB_MFP[14]:0', 'ALT_MFP[3]:1'] },
	{ f: ['PB.15', 'GPB_MFP[15]:0', 'ALT_MFP[24]:1'] },

	{ f: ['PC.0', 'GPC_MFP[0]:0', 'ALT_MFP[5]:1'] },
	{ f: ['PC.1', 'GPC_MFP[1]:0', 'ALT_MFP[6]:1'] },
	{ f: ['PC.2', 'GPC_MFP[2]:0', 'ALT_MFP[7]:1'] },
	{ f: ['PC.3', 'GPC_MFP[3]:0', 'ALT_MFP[8]:1'] },
	{ f: ['PC.4', 'GPC_MFP[4]:0'] },
	{ f: ['PC.5', 'GPC_MFP[5]:0'] },
	{ f: ['PC.6', 'GPC_MFP[6]:0', 'ALT_MFP[11]:1'] },
	{ f: ['PC.7', 'GPC_MFP[7]:0', 'ALT_MFP[11]:1'] },
	{ f: ['PC.8', 'GPC_MFP[8]:0', 'ALT_MFP[11]:1', 'ALT_MFP[12]:2'] },
	{ f: ['PC.9', 'GPC_MFP[9]:0'] },
	{ f: ['PC.10', 'GPC_MFP[10]:0'] },
	{ f: ['PC.11', 'GPC_MFP[11]:0'] },
	{ f: ['PC.12', 'GPC_MFP[12]:0'] },
	{ f: ['PC.13', 'GPC_MFP[13]:0'] },
	{ f: ['PC.14', 'GPC_MFP[14]:0', 'ALT_MFP[11]:1'] },
	{ f: ['PC.15', 'GPC_MFP[15]:0', 'ALT_MFP[11]:1'] },

	{ f: ['PD.0', 'GPD_MFP[0]:0'] },
	{ f: ['PD.1', 'GPD_MFP[1]:0'] },
	{ f: ['PD.2', 'GPD_MFP[2]:0'] },
	{ f: ['PD.3', 'GPD_MFP[3]:0'] },
	{ f: ['PD.4', 'GPD_MFP[4]:0'] },
	{ f: ['PD.5', 'GPD_MFP[5]:0'] },
	{ f: ['PD.6', 'GPD_MFP[6]:0'] },
	{ f: ['PD.7', 'GPD_MFP[7]:0'] },
	{ f: ['PD.8', 'GPD_MFP[8]:0'] },
	{ f: ['PD.9', 'GPD_MFP[9]:0'] },
	{ f: ['PD.10', 'GPD_MFP[10]:0'] },
	{ f: ['PD.11', 'GPD_MFP[11]:0'] },
	{ f: ['PD.12', 'GPD_MFP[12]:0'] },
	{ f: ['PD.13', 'GPD_MFP[13]:0'] },
	{ f: ['PD.14', 'GPD_MFP[14]:0'] },
	{ f: ['PD.15', 'GPD_MFP[15]:0'] },

	{ f: ['PE.0', 'GPE_MFP[0]:0'] },
	{ f: ['PE.1', 'GPE_MFP[1]:0'] },
	{ f: ['PE.2'] },
	{ f: ['PE.3'] },
	{ f: ['PE.4'] },
	{ f: ['PE.5', 'GPE_MFP[5]:0', 'ALT_MFP[25]:1'] },
	{ f: ['PE.6'] },
	{ f: ['PE.7'] },
	{ f: ['PE.8'] },
	{ f: ['PE.9'] },
	{ f: ['PE.10'] },
	{ f: ['PE.11'] },
	{ f: ['PE.12'] },
	{ f: ['PE.13'] },
	{ f: ['PE.14'] },
	{ f: ['PE.15'] }
];

NUTOOL_PIN.g_cfg_shareBits = ['ALT_MFP[11]'];
NUTOOL_PIN.g_cfg_addGPIO = {};
NUTOOL_PIN.g_cfg_unusedGPIO = {
	"NUC130RC1CN(LQFP64)": {
		"PB.14": ["SPISS31"],
		"PB.10": ["SPISS01"],
		"PB.9": ["SPISS11"],
		"PA.7": ["SPISS21"]
	},
	"NUC130RD2CN(LQFP64)": function () {
		return this["NUC130RC1CN(LQFP64)"];
	},
	"NUC130RE3CN(LQFP64)": function () {
		return this["NUC130RC1CN(LQFP64)"];
	},
	"NUC130LC1CN(LQFP48)": {
		"PB.12": ["AD0"],
		"PA.11": ["nRD"],
		"PA.10": ["nWR"],
		"PB.2": ["nWRL"],
		"PB.3": ["nWRH"],
		"PB.10": ["SPISS01"],
		"PB.9": ["SPISS11"],
		"PA.14": ["AD15"],
		"PA.13": ["AD14"],
		"PA.12": ["AD13"],
		"PA.1": ["AD12"],
		"PA.2": ["AD11"],
		"PA.3": ["AD10"],
		"PA.4": ["AD9"],
		"PA.5": ["AD8"],
		"PA.6": ["AD7"],
		"PA.7": ["AD6", "SPISS21"],
		"PC.7": ["AD5"],
		"PC.6": ["AD4"]
	},
	"NUC130LD2CN(LQFP48)": function () {
		return this["NUC130LC1CN(LQFP48)"];
	},
	"NUC130LE3CN(LQFP48)": function () {
		return this["NUC130LC1CN(LQFP48)"];
	},
	"NUC140RC1CN(LQFP64)": {
		"PB.14": ["SPISS31"],
		"PB.10": ["SPISS01"],
		"PB.9": ["SPISS11"],
		"PA.7": ["SPISS21"]
	},
	"NUC140RD2CN(LQFP64)": function () {
		return this["NUC140RC1CN(LQFP64)"];
	},
	"NUC140RE3CN(LQFP64)": function () {
		return this["NUC140RC1CN(LQFP64)"];
	},
	"NUC140LC1CN(LQFP48)": {
		"PB.12": ["AD0"],
		"PA.11": ["nRD"],
		"PA.10": ["nWR"],
		"PB.2": ["nWRL"],
		"PB.3": ["nWRH"],
		"PA.14": ["AD15"],
		"PA.13": ["AD14"],
		"PA.12": ["AD13"],
		"PA.1": ["AD12"],
		"PA.2": ["AD11"],
		"PA.3": ["AD10"],
		"PA.4": ["AD9"],
		"PA.5": ["AD8"],
		"PA.6": ["AD7"],
		"PA.7": ["AD6", "SPISS21"],
		"PC.7": ["AD5"],
		"PC.6": ["AD4"]
	},
	"NUC140LD2CN(LQFP48)": function () {
		return this["NUC140LC1CN(LQFP48)"];
	},
	"NUC140LE3CN(LQFP48)": function () {
		return this["NUC140LC1CN(LQFP48)"];
	}
};

NUTOOL_PIN.decidepackageNumber = function (given_partNumber_package) {
	var partNumber_package;

	if (typeof given_partNumber_package === 'undefined') {
		partNumber_package = NUTOOL_PIN.getg_partNumber_package();
	}
	else {
		partNumber_package = given_partNumber_package;
	}

	NUTOOL_PIN.g_packageNumber = partNumber_package.substring(partNumber_package.indexOf('(') + 1);
	NUTOOL_PIN.g_packageNumber = NUTOOL_PIN.g_packageNumber.substring(0, NUTOOL_PIN.g_packageNumber.indexOf(')'));
	NUTOOL_PIN.g_packageNumberIndex = NUTOOL_PIN.g_packageNumber + '(' + partNumber_package.slice(0, 6) + ')';

	partNumber_package = null;
};
