NUTOOL_PIN.g_cfg_chips = [
	// NUC029AE
	{ name: "NUC029FAE", pkg: "TSSOP20" },
	{ name: "NUC029TAE", pkg: "QFN33" },
	// NUC029AN
	{ name: "NUC029LAN", pkg: "LQFP48" },
	{ name: "NUC029TAN", pkg: "QFN33" },
	// NUC029xDE
	{ name: "NUC029LDE", pkg: "LQFP48" },
	{ name: "NUC029SDE", pkg: "LQFP64" },
	// NUC029xGE
	{ name: "NUC029LGE", pkg: "LQFP48" },
	{ name: "NUC029SGE", pkg: "LQFP64" },
	// NUC029KGE
	{ name: "NUC029KGE", pkg: "LQFP128" },
	// NUC029xEE
	{ name: "NUC029LEE", pkg: "LQFP48" },
	{ name: "NUC029SEE", pkg: "LQFP64" }
];

NUTOOL_PIN.g_cfg_pkgs = {
	"LQFP128(USB1.1)": [
	'PB.13', 'PB.14', 'PB.15', 'PB.5', 'PB.6', 'PB.7', 'nRESET', 'PD.0', 'AVSS', 'NC',
	'VDD', 'NC', 'VSS', 'PC.8', 'PD.8', 'PD.9', 'PD.1', 'PD.2', 'PD.3', 'PD.4',
	'PD.5', 'PE.3', 'PD.6', 'VBAT', 'NC', 'PF.0', 'PF.1', 'NC', 'PF.2', 'PD.10',
	'PD.11', 'PD.12',
	'PD.13', 'NC', 'PD.14', 'PD.15', 'VDD', 'PD.7', 'NC', 'PF.3', 'PF.4', 'NC',
	'VSS', 'NC', 'VDD', 'NC', 'LDO_CAP', 'PC.9', 'PC.10', 'PC.11', 'PC.12', 'PC.13',
	'PC.14', 'PC.0', 'PC.1', 'PC.2', 'PC.3', 'PC.4', 'NC', 'NC', 'NC', 'NC',
	'NC', 'NC',
	'PE.0', 'PC.5', 'PC.6', 'PC.7', 'PE.4', 'PE.5', 'PE.6', 'PE.7', 'PA.8', 'PA.9',
	'PA.10', 'PA.11', 'PF.5', 'PA.7', 'PA.6', 'PA.5', 'PA.4', 'VSS', 'NC', 'VDD',
	'PE.1', 'PE.8', 'PE.9', 'PE.10', 'PE.11', 'PE.12', 'PE.13', 'VDDIO', 'NC', 'USB_VBUS',
	'USB_D-', 'USB_D+',
	'PF.7', 'USB_VDD33_CAP', 'PF.6', 'PC.15', 'PB.12', 'PA.3', 'PA.2', 'PA.1', 'PA.0', 'VDD',
	'PA.12', 'PA.13', 'PA.14', 'PA.15', 'VSS', 'NC', 'VDD', 'NC', 'AVDD', 'NC',
	'VREF', 'PB.0', 'PB.1', 'PB.2', 'PB.3', 'PB.4', 'PB.8', 'PB.9', 'PB.10', 'PB.11',
	'PE.2', 'NC'
	]
};

NUTOOL_PIN.g_cfg_gpios = [
	{ f: ['PA.0:0', 'UART1_nCTS:1', 'UART1_TXD:3', 'USCI1_CTL0:4', 'SC0_CLK:5', 'PWM1_CH5:6', 'EBI_AD0:7', 'INT0:8'] },
	{ f: ['PA.1:0', 'UART1_nRTS:1', 'UART1_RXD:3', 'USCI1_CTL1:4', 'SC0_DAT:5', 'PWM1_CH4:6', 'EBI_AD1:7'] },
	{ f: ['PA.2:0', 'UART0_TXD:2', 'UART0_nCTS:3', 'I2C0_SDA:4', 'SC0_RST:5', 'PWM1_CH3:6', 'EBI_AD2:7', 'USCI1_CTL0:8'] },
	{ f: ['PA.3:0', 'UART0_RXD:2', 'UART0_nRTS:3', 'I2C0_SCL:4', 'SC0_PWR:5', 'PWM1_CH2:6', 'EBI_AD3:7', 'USCI1_CLK:8'] },
	{ f: ['PA.4:0', 'SPI1_SS:2', 'TM3_EXT:3', 'EBI_AD4:7'] },
	{ f: ['PA.5:0', 'SPI1_MOSI:2', 'TM2_EXT:3', 'TM_BRAKE3:6', 'EBI_AD5:7'] },
	{ f: ['PA.6:0', 'SPI1_MISO:2', 'TM1_EXT:3', 'TM_BRAKE2:6', 'EBI_AD6:7'] },
	{ f: ['PA.7:0', 'SPI1_CLK:2', 'TM0_EXT:3', 'TM_BRAKE1:6', 'EBI_AD7:7'] },
	{ f: ['PA.8:0', 'CLKO:1', 'I2C1_SCL:2', 'UART1_TXD:3', 'SC0_PWR:4', 'SC1_RST:5', 'TM_BRAKE0:6', 'PWM0_BRAKE0:7', 'TM1:8'] },
	{ f: ['PA.9:0', 'SPI1_I2SMCLK:1', 'I2C1_SDA:2', 'UART1_RXD:3', 'SC0_RST:4', 'SC1_PWR:5', 'TM_BRAKE1:6', 'PWM1_BRAKE1:7', 'TM2:8'] },
	{ f: ['PA.10:0', 'UART1_nCTS:3', 'SC1_DAT:5'] },
	{ f: ['PA.11:0', 'UART1_nRTS:3', 'SC1_CLK:5'] },
	{ f: ['PA.12:0', 'SPI1_I2SMCLK:2', 'UART2_RXD:3', 'UART1_RXD:4', 'TM_BRAKE2:6'] },
	{ f: ['PA.13:0', 'UART2_TXD:3', 'UART1_TXD:4', 'TM_BRAKE3:6'] },
	{ f: ['PA.14:0', 'UART2_nCTS:3', 'USCI1_CTL1:4', 'TM2:6'] },
	{ f: ['PA.15:0', 'UART2_nRTS:3', 'USCI1_CLK:4', 'TM3:6'] },

	{ f: ['PB.0:0', 'ADC0_CH0:1', 'VDET_P0:2', 'UART2_RXD:3', 'TM2:4', 'USCI1_DAT0:6', 'EBI_nWRL:7', 'INT1:8', 'TM1_EXT:10'] },
	{ f: ['PB.1:0', 'ADC0_CH1:1', 'VDET_P1:2', 'UART2_TXD:3', 'TM3:4', 'SC0_RST:5', 'PWM0_SYNC_OUT:6', 'EBI_nWRH:7', 'USCI1_DAT1:8'] },
	{ f: ['PB.2:0', 'ADC0_CH2:1', 'SPI0_CLK:2', 'SPI1_CLK:3', 'UART1_RXD:4', 'SC0_nCD:5', 'TM_BRAKE0:6', 'EBI_nCS0:7', 'USCI0_DAT0:8', 'TM2_EXT:10'] },
	{ f: ['PB.3:0', 'ADC0_CH3:1', 'SPI0_MISO:2', 'SPI1_MISO:3', 'UART1_TXD:4', 'TM_BRAKE1:6', 'EBI_ALE:7', 'USCI0_DAT1:8', 'TM0_EXT:10'] },
	{ f: ['PB.4:0', 'ADC0_CH4:1', 'SPI0_SS:2', 'SPI1_SS:3', 'UART1_nCTS:4', 'ACMP0_N:5', 'SC1_nCD:6', 'EBI_AD7:7', 'USCI0_CTL1:8', 'UART2_RXD:9', 'TM1_EXT:10'] },
	{ f: ['PB.5:0', 'ADC0_CH13:1', 'SPI0_MOSI:2', 'SPI1_MOSI:3', 'ACMP0_P2:5', 'SC1_RST:6', 'EBI_AD6:7', 'UART2_RXD:9'] },
	{ f: ['PB.6:0', 'ADC0_CH14:1', 'SPI0_MISO:2', 'SPI1_MISO:3', 'ACMP0_P1:5', 'SC1_PWR:6', 'EBI_AD5:7'] },
	{ f: ['PB.7:0', 'ADC0_CH15:1', 'SPI0_CLK:2', 'SPI1_CLK:3', 'USCI2_CTL1:4', 'ACMP0_P0:5', 'SC1_DAT:6', 'EBI_AD4:7'] },
	{ f: ['PB.8:0', 'ADC0_CH5:1', 'UART1_nRTS:4', 'TM_BRAKE2:5', 'PWM0_CH2:6', 'USCI0_CTL0:8'] },
	{ f: ['PB.9:0', 'ADC0_CH6:1', 'USCI0_CLK:8'] },
	{ f: ['PB.10:0', 'ADC0_CH7:1'] },
	{ f: ['PB.11:0', 'ADC0_CH8:1'] },
	{ f: ['PB.12:0', 'PWM1_CH1:6'] },
	{ f: ['PB.13:0', 'ADC0_CH10:1'] },
	{ f: ['PB.14:0', 'ADC0_CH11:1'] },
	{ f: ['PB.15:0', 'ADC0_CH12:1', 'ACMP0_P3:5', 'EBI_nCS1:7'] },

	{ f: ['PC.0:0', 'SC0_DAT:1', 'SPI0_CLK:2', 'UART2_nCTS:3', 'USCI0_DAT0:4', 'ACMP0_WLAT:5', 'PWM0_CH0:6', 'EBI_AD8:7', 'INT2:8'] },
	{ f: ['PC.1:0', 'CLKO:1', 'SC0_CLK:2', 'UART2_nRTS:3', 'USCI0_DAT1:4', 'ACMP1_WLAT:5', 'PWM0_CH1:6', 'EBI_AD9:7'] },
	{ f: ['PC.2:0', 'SC0_RST:1', 'SPI0_SS:2', 'UART2_TXD:3', 'USCI0_CTL1:4', 'ACMP1_O:5', 'PWM0_CH2:6', 'EBI_AD10:7'] },
	{ f: ['PC.3:0', 'SC0_PWR:1', 'SPI0_MOSI:2', 'UART2_RXD:3', 'USCI0_CTL0:5', 'PWM0_CH3:6', 'EBI_AD11:7'] },
	{ f: ['PC.4:0', 'SC0_nCD:1', 'SPI0_MISO:2', 'I2C1_SCL:3', 'USCI0_CLK:5', 'PWM0_CH4:6', 'EBI_AD12:7'] },
	{ f: ['PC.5:0', 'SPI0_I2SMCLK:2', 'I2C1_SDA:3', 'USCI0_DAT0:4', 'PWM0_CH5:6', 'EBI_AD13:7'] },
	{ f: ['PC.6:0', 'USCI0_DAT1:4', 'ACMP1_O:5', 'PWM1_CH0:6', 'EBI_AD14:7'] },
	{ f: ['PC.7:0', 'USCI0_CTL1:4', 'PWM1_CH1:6', 'EBI_AD15:7'] },
	{ f: ['PC.8:0', 'ADC0_CH16:1', 'UART0_nRTS:3'] },
	{ f: ['PC.9:0', 'SPI0_I2SMCLK:2', 'I2C1_SCL:3', 'USCI2_CTL1:4', 'PWM1_CH0:6'] },
	{ f: ['PC.10:0', 'SPI0_MOSI:2', 'I2C1_SDA:3', 'USCI2_DAT1:4', 'PWM1_CH1:6'] },
	{ f: ['PC.11:0', 'SPI0_MISO:2', 'USCI2_CLK:4', 'PWM1_CH2:6'] },
	{ f: ['PC.12:0', 'SPI0_CLK:2', 'USCI2_CTL0:4', 'PWM1_CH3:6'] },
	{ f: ['PC.13:0', 'SPI0_SS:2', 'USCI2_DAT0:4', 'PWM1_CH4:6'] },
	{ f: ['PC.14:0', 'PWM1_CH5:6'] },
	{ f: ['PC.15:0', 'PWM1_CH0:6'] },

	{ f: ['PD.0:0', 'SPI0_I2SMCLK:1', 'SPI1_I2SMCLK:2', 'UART0_RXD:3', 'USCI2_CTL0:4', 'ACMP1_N:5', 'SC1_CLK:6', 'INT3:8'] },
	{ f: ['PD.1:0', 'ADC0_CH19:1', 'PWM0_SYNC_IN:2', 'UART0_TXD:3', 'USCI2_CLK:4', 'ACMP1_P2:5', 'TM0:6', 'EBI_nRD:7'] },
	{ f: ['PD.2:0', 'ADC0_ST:1', 'TM0_EXT:3', 'USCI2_DAT0:4', 'ACMP1_P1:5', 'PWM0_BRAKE0:6', 'EBI_nWR:7', 'INT0:8'] },
	{ f: ['PD.3:0', 'TM2:1', 'SPI0_I2SMCLK:2', 'TM1_EXT:3', 'USCI2_DAT1:4', 'ACMP1_P0:5', 'PWM0_BRAKE1:6', 'EBI_MCLK:7', 'INT1:8'] },
	{ f: ['PD.4:0', 'SPI1_CLK:2', 'I2C0_SDA:3', 'UART2_nRTS:4', 'PWM0_BRAKE0:5', 'TM0:6'] },
	{ f: ['PD.5:0', 'CLKO:1', 'SPI1_MISO:2', 'I2C0_SCL:3', 'UART2_nCTS:4', 'PWM0_BRAKE1:5', 'TM1:6'] },
	{ f: ['PD.6:0', 'CLKO:1', 'SPI1_SS:2', 'UART0_RXD:3', 'UART2_TXD:4', 'ACMP0_O:5', 'PWM0_CH5:6', 'EBI_nWR:7'] },
	{ f: ['PD.7:0', 'USCI1_CTL1:1', 'SPI0_I2SMCLK:2', 'PWM0_SYNC_IN:3', 'TM1:4', 'ACMP0_O:5', 'PWM0_CH5:6', 'EBI_nRD:7'] },
	{ f: ['PD.8:0', 'ADC0_CH17:1', 'UART0_nCTS:3', 'USCI2_CTL1:4', 'TM2:6', 'EBI_nCS0:7'] },
	{ f: ['PD.9:0', 'ADC0_CH18:1', 'UART0_RXD:3', 'USCI2_CTL0:4', 'ACMP1_P3:5', 'TM3:6', 'EBI_ALE:7'] },
	{ f: ['PD.10:0', 'TM2:4', 'USCI2_DAT0:5'] },
	{ f: ['PD.11:0', 'TM3:4', 'USCI2_DAT1:5'] },
	{ f: ['PD.12:0', 'USCI1_CTL0:1', 'SPI1_SS:2', 'UART0_TXD:3', 'PWM1_CH0:6', 'EBI_ADR16:7'] },
	{ f: ['PD.13:0', 'USCI1_DAT1:1', 'SPI1_MOSI:2', 'UART0_RXD:3', 'PWM1_CH1:6', 'EBI_ADR17:7'] },
	{ f: ['PD.14:0', 'USCI1_DAT0:1', 'SPI1_MISO:2', 'UART0_nCTS:3', 'PWM1_CH2:6', 'EBI_ADR18:7'] },
	{ f: ['PD.15:0', 'USCI1_CLK:1', 'SPI1_CLK:2', 'UART0_nRTS:3', 'PWM1_CH3:6', 'EBI_ADR19:7'] },

	{ f: ['PE.0:0', 'SPI0_CLK:2', 'I2C1_SDA:3', 'TM2_EXT:4', 'SC0_nCD:5', 'PWM0_CH0:6', 'EBI_nCS1:7', 'INT4:8'] },
	{ f: ['PE.1:0', 'TM3_EXT:3', 'SC0_nCD:5', 'PWM0_CH1:6'] },
	{ f: ['PE.2:0', 'ADC0_CH9:1', 'UART1_nRTS:4', 'TM_BRAKE3:5', 'PWM0_CH2:6', 'USCI0_CTL0:8'] },
	{ f: ['PE.3:0', 'SPI1_MOSI:2', 'UART2_RXD:4', 'PWM0_CH3:6'] },
	{ f: ['PE.4:0', 'I2C0_SCL:2', 'I2C1_SCL:3', 'USCI0_CTL0:4', 'SC0_PWR:5', 'PWM1_BRAKE0:6', 'EBI_nCS0:7', 'INT0:8'] },
	{ f: ['PE.5:0', 'I2C0_SDA:2', 'I2C1_SDA:3', 'USCI0_CLK:4', 'SC0_RST:5', 'PWM1_BRAKE1:6', 'EBI_ALE:7', 'INT1:8'] },
	{ f: ['PE.6:0', 'ICE_CLK:1', 'I2C0_SCL:2', 'UART0_RXD:3'] },
	{ f: ['PE.7:0', 'ICE_DAT:1', 'I2C0_SDA:2', 'UART0_TXD:3'] },
	{ f: ['PE.8:0', 'UART1_TXD:1', 'TM0:3', 'I2C1_SCL:4', 'SC0_PWR:5'] },
	{ f: ['PE.9:0', 'UART1_RXD:1', 'TM1:3', 'I2C1_SDA:4', 'SC0_RST:5'] },
	{ f: ['PE.10:0', 'SPI1_MISO:1', 'SPI0_MISO:2', 'UART1_nCTS:3', 'SC0_DAT:5', 'SPI1_CLK:6', 'EBI_AD7:7', 'TM0_EXT:8'] },
	{ f: ['PE.11:0', 'SPI1_MOSI:1', 'SPI0_MOSI:2', 'UART1_nRTS:3', 'SC0_CLK:5', 'SPI1_MISO:6', 'EBI_AD6:7', 'TM1_EXT:8'] },
	{ f: ['PE.12:0', 'SPI1_SS:1', 'SPI0_SS:2', 'UART1_TXD:3', 'I2C0_SCL:4', 'SPI1_MOSI:6', 'EBI_AD5:7', 'TM2_EXT:8'] },
	{ f: ['PE.13:0', 'SPI1_CLK:1', 'SPI0_CLK:2', 'UART1_RXD:3', 'I2C0_SDA:4', 'SPI1_SS:6', 'EBI_AD4:7', 'TM3_EXT:8'] },
	{ f: ['PE.14:0'] },
	{ f: ['PE.15:0'] },

	{ f: ['PF.0:0', 'X32_OUT:1', 'USCI2_CTL1:5', 'INT5:8'] },
	{ f: ['PF.1:0', 'X32_IN:1', 'USCI2_CTL0:5', 'PWM1_BRAKE0:6'] },
	{ f: ['PF.2:0', 'USCI2_CLK:5', 'PWM1_BRAKE1:6'] },
	{ f: ['PF.3:0', 'XT1_OUT:1', 'I2C1_SCL:3'] },
	{ f: ['PF.4:0', 'XT1_IN:1', 'I2C1_SDA:3'] },
	{ f: ['PF.5:0', 'TM3_EXT:3', 'SC1_nCD:5', 'TM_BRAKE0:6'] },
	{ f: ['PF.6:0'] },
	{ f: ['PF.7:0'] },
	{ f: ['PF.8:0'] },
	{ f: ['PF.9:0'] },
	{ f: ['PF.10:0'] },
	{ f: ['PF.11:0'] },
	{ f: ['PF.12:0'] },
	{ f: ['PF.13:0'] },
	{ f: ['PF.14:0'] },
	{ f: ['PF.15:0'] }
];

NUTOOL_PIN.g_cfg_gpiosDefines = [
	{ f: ['PA.0', 'UART1_nCTS:SYS_GPA_MFPL_PA0MFP_UART1_nCTS@GPA_MFPL', 'UART1_TXD:SYS_GPA_MFPL_PA0MFP_UART1_TXD@GPA_MFPL', 'USCI1_CTL0:SYS_GPA_MFPL_PA0MFP_USCI1_CTL0@GPA_MFPL', 'SC0_CLK:SYS_GPA_MFPL_PA0MFP_SC0_CLK@GPA_MFPL', 'PWM1_CH5:SYS_GPA_MFPL_PA0MFP_PWM1_CH5@GPA_MFPL', 'EBI_AD0:SYS_GPA_MFPL_PA0MFP_EBI_AD0@GPA_MFPL', 'INT0:SYS_GPA_MFPL_PA0MFP_INT0@GPA_MFPL'] },
	{ f: ['PA.1', 'UART1_nRTS:SYS_GPA_MFPL_PA1MFP_UART1_nRTS@GPA_MFPL', 'UART1_RXD:SYS_GPA_MFPL_PA1MFP_UART1_RXD@GPA_MFPL', 'USCI1_CTL1:SYS_GPA_MFPL_PA1MFP_USCI1_CTL1@GPA_MFPL', 'SC0_DAT:SYS_GPA_MFPL_PA1MFP_SC0_DAT@GPA_MFPL', 'PWM1_CH4:SYS_GPA_MFPL_PA1MFP_PWM1_CH4@GPA_MFPL', 'EBI_AD1:SYS_GPA_MFPL_PA1MFP_EBI_AD1@GPA_MFPL'] },
	{ f: ['PA.2', 'UART0_TXD:SYS_GPA_MFPL_PA2MFP_UART0_TXD@GPA_MFPL', 'UART0_nCTS:SYS_GPA_MFPL_PA2MFP_UART0_nCTS@GPA_MFPL', 'I2C0_SDA:SYS_GPA_MFPL_PA2MFP_I2C0_SDA@GPA_MFPL', 'SC0_RST:SYS_GPA_MFPL_PA2MFP_SC0_RST@GPA_MFPL', 'PWM1_CH3:SYS_GPA_MFPL_PA2MFP_PWM1_CH3@GPA_MFPL', 'EBI_AD2:SYS_GPA_MFPL_PA2MFP_EBI_AD2@GPA_MFPL', 'USCI1_CTL0:SYS_GPA_MFPL_PA2MFP_USCI1_CTL0@GPA_MFPL'] },
	{ f: ['PA.3', 'UART0_RXD:SYS_GPA_MFPL_PA3MFP_UART0_RXD@GPA_MFPL', 'UART0_nRTS:SYS_GPA_MFPL_PA3MFP_UART0_nRTS@GPA_MFPL', 'I2C0_SCL:SYS_GPA_MFPL_PA3MFP_I2C0_SCL@GPA_MFPL', 'SC0_PWR:SYS_GPA_MFPL_PA3MFP_SC0_PWR@GPA_MFPL', 'PWM1_CH2:SYS_GPA_MFPL_PA3MFP_PWM1_CH2@GPA_MFPL', 'EBI_AD3:SYS_GPA_MFPL_PA3MFP_EBI_AD3@GPA_MFPL', 'USCI1_CLK:SYS_GPA_MFPL_PA3MFP_USCI1_CLK@GPA_MFPL'] },
	{ f: ['PA.4', 'SPI1_SS:SYS_GPA_MFPL_PA4MFP_SPI1_SS@GPA_MFPL', 'TM3_EXT:SYS_GPA_MFPL_PA4MFP_TM3_EXT@GPA_MFPL', 'EBI_AD4:SYS_GPA_MFPL_PA4MFP_EBI_AD4@GPA_MFPL'] },
	{ f: ['PA.5', 'SPI1_MOSI:SYS_GPA_MFPL_PA5MFP_SPI1_MOSI@GPA_MFPL', 'TM2_EXT:SYS_GPA_MFPL_PA5MFP_TM2_EXT@GPA_MFPL', 'TM_BRAKE3:SYS_GPA_MFPL_PA5MFP_TM_BRAKE3@GPA_MFPL', 'EBI_AD5:SYS_GPA_MFPL_PA5MFP_EBI_AD5@GPA_MFPL'] },
	{ f: ['PA.6', 'SPI1_MISO:SYS_GPA_MFPL_PA6MFP_SPI1_MISO@GPA_MFPL', 'TM1_EXT:SYS_GPA_MFPL_PA6MFP_TM1_EXT@GPA_MFPL', 'TM_BRAKE2:SYS_GPA_MFPL_PA6MFP_TM_BRAKE2@GPA_MFPL', 'EBI_AD6:SYS_GPA_MFPL_PA6MFP_EBI_AD6@GPA_MFPL'] },
	{ f: ['PA.7', 'SPI1_CLK:SYS_GPA_MFPL_PA7MFP_SPI1_CLK@GPA_MFPL', 'TM0_EXT:SYS_GPA_MFPL_PA7MFP_TM0_EXT@GPA_MFPL', 'TM_BRAKE1:SYS_GPA_MFPL_PA7MFP_TM_BRAKE1@GPA_MFPL', 'EBI_AD7:SYS_GPA_MFPL_PA7MFP_EBI_AD7@GPA_MFPL'] },
	{ f: ['PA.8', 'CLKO:SYS_GPA_MFPH_PA8MFP_CLKO@GPA_MFPH', 'I2C1_SCL:SYS_GPA_MFPH_PA8MFP_I2C1_SCL@GPA_MFPH', 'UART1_TXD:SYS_GPA_MFPH_PA8MFP_UART1_TXD@GPA_MFPH', 'SC0_PWR:SYS_GPA_MFPH_PA8MFP_SC0_PWR@GPA_MFPH', 'SC1_RST:SYS_GPA_MFPH_PA8MFP_SC1_RST@GPA_MFPH', 'TM_BRAKE0:SYS_GPA_MFPH_PA8MFP_TM_BRAKE0@GPA_MFPH', 'PWM0_BRAKE0:SYS_GPA_MFPH_PA8MFP_PWM0_BRAKE0@GPA_MFPH', 'TM1:SYS_GPA_MFPH_PA8MFP_TM1@GPA_MFPH'] },
	{ f: ['PA.9', 'SPI1_I2SMCLK:SYS_GPA_MFPH_PA9MFP_SPI1_I2SMCLK@GPA_MFPH', 'I2C1_SDA:SYS_GPA_MFPH_PA9MFP_I2C1_SDA@GPA_MFPH', 'UART1_RXD:SYS_GPA_MFPH_PA9MFP_UART1_RXD@GPA_MFPH', 'SC0_RST:SYS_GPA_MFPH_PA9MFP_SC0_RST@GPA_MFPH', 'SC1_PWR:SYS_GPA_MFPH_PA9MFP_SC1_PWR@GPA_MFPH', 'TM_BRAKE1:SYS_GPA_MFPH_PA9MFP_TM_BRAKE1@GPA_MFPH', 'PWM1_BRAKE1:SYS_GPA_MFPH_PA9MFP_PWM1_BRAKE1@GPA_MFPH', 'TM2:SYS_GPA_MFPH_PA9MFP_TM2@GPA_MFPH'] },
	{ f: ['PA.10', 'UART1_nCTS:SYS_GPA_MFPH_PA10MFP_UART1_nCTS@GPA_MFPH', 'SC1_DAT:SYS_GPA_MFPH_PA10MFP_SC1_DAT@GPA_MFPH'] },
	{ f: ['PA.11', 'UART1_nRTS:SYS_GPA_MFPH_PA11MFP_UART1_nRTS@GPA_MFPH', 'SC1_CLK:SYS_GPA_MFPH_PA11MFP_SC1_CLK@GPA_MFPH'] },
	{ f: ['PA.12', 'SPI1_I2SMCLK:SYS_GPA_MFPH_PA12MFP_SPI1_I2SMCLK@GPA_MFPH', 'UART2_RXD:SYS_GPA_MFPH_PA12MFP_UART2_RXD@GPA_MFPH', 'UART1_RXD:SYS_GPA_MFPH_PA12MFP_UART1_RXD@GPA_MFPH', 'TM_BRAKE2:SYS_GPA_MFPH_PA12MFP_TM_BRAKE2@GPA_MFPH'] },
	{ f: ['PA.13', 'UART2_TXD:SYS_GPA_MFPH_PA13MFP_UART2_TXD@GPA_MFPH', 'UART1_TXD:SYS_GPA_MFPH_PA13MFP_UART1_TXD@GPA_MFPH', 'TM_BRAKE3:SYS_GPA_MFPH_PA13MFP_TM_BRAKE3@GPA_MFPH'] },
	{ f: ['PA.14', 'UART2_nCTS:SYS_GPA_MFPH_PA14MFP_UART2_nCTS@GPA_MFPH', 'USCI1_CTL1:SYS_GPA_MFPH_PA14MFP_USCI1_CTL1@GPA_MFPH', 'TM2:SYS_GPA_MFPH_PA14MFP_TM2@GPA_MFPH'] },
	{ f: ['PA.15', 'UART2_nRTS:SYS_GPA_MFPH_PA15MFP_UART2_nRTS@GPA_MFPH', 'USCI1_CLK:SYS_GPA_MFPH_PA15MFP_USCI1_CLK@GPA_MFPH', 'TM3:SYS_GPA_MFPH_PA15MFP_TM3@GPA_MFPH'] },

	{ f: ['PB.0', 'ADC0_CH0:SYS_GPB_MFPL_PB0MFP_ADC0_CH0@GPB_MFPL', 'VDET_P0:SYS_GPB_MFPL_PB0MFP_VDET_P0@GPB_MFPL', 'UART2_RXD:SYS_GPB_MFPL_PB0MFP_UART2_RXD@GPB_MFPL', 'TM2:SYS_GPB_MFPL_PB0MFP_TM2@GPB_MFPL', 'USCI1_DAT0:SYS_GPB_MFPL_PB0MFP_USCI1_DAT0@GPB_MFPL', 'EBI_nWRL:SYS_GPB_MFPL_PB0MFP_EBI_nWRL@GPB_MFPL', 'INT1:SYS_GPB_MFPL_PB0MFP_INT1@GPB_MFPL', 'TM1_EXT:SYS_GPB_MFPL_PB0MFP_TM1_EXT@GPB_MFPL'] },
	{ f: ['PB.1', 'ADC0_CH1:SYS_GPB_MFPL_PB1MFP_ADC0_CH1@GPB_MFPL', 'VDET_P1:SYS_GPB_MFPL_PB1MFP_VDET_P1@GPB_MFPL', 'UART2_TXD:SYS_GPB_MFPL_PB1MFP_UART2_TXD@GPB_MFPL', 'TM3:SYS_GPB_MFPL_PB1MFP_TM3@GPB_MFPL', 'SC0_RST:SYS_GPB_MFPL_PB1MFP_SC0_RST@GPB_MFPL', 'PWM0_SYNC_OUT:SYS_GPB_MFPL_PB1MFP_PWM0_SYNC_OUT@GPB_MFPL', 'EBI_nWRH:SYS_GPB_MFPL_PB1MFP_EBI_nWRH@GPB_MFPL', 'USCI1_DAT1:SYS_GPB_MFPL_PB1MFP_USCI1_DAT1@GPB_MFPL'] },
	{ f: ['PB.2', 'ADC0_CH2:SYS_GPB_MFPL_PB2MFP_ADC0_CH2@GPB_MFPL', 'SPI0_CLK:SYS_GPB_MFPL_PB2MFP_SPI0_CLK@GPB_MFPL', 'SPI1_CLK:SYS_GPB_MFPL_PB2MFP_SPI1_CLK@GPB_MFPL', 'UART1_RXD:SYS_GPB_MFPL_PB2MFP_UART1_RXD@GPB_MFPL', 'SC0_nCD:SYS_GPB_MFPL_PB2MFP_SC0_nCD@GPB_MFPL', 'TM_BRAKE0:SYS_GPB_MFPL_PB2MFP_TM_BRAKE0@GPB_MFPL', 'EBI_nCS0:SYS_GPB_MFPL_PB2MFP_EBI_nCS0@GPB_MFPL', 'USCI0_DAT0:SYS_GPB_MFPL_PB2MFP_USCI0_DAT0@GPB_MFPL', 'TM2_EXT:SYS_GPB_MFPL_PB2MFP_TM2_EXT@GPB_MFPL'] },
	{ f: ['PB.3', 'ADC0_CH3:SYS_GPB_MFPL_PB3MFP_ADC0_CH3@GPB_MFPL', 'SPI0_MISO:SYS_GPB_MFPL_PB3MFP_SPI0_MISO@GPB_MFPL', 'SPI1_MISO:SYS_GPB_MFPL_PB3MFP_SPI1_MISO@GPB_MFPL', 'UART1_TXD:SYS_GPB_MFPL_PB3MFP_UART1_TXD@GPB_MFPL', 'TM_BRAKE1:SYS_GPB_MFPL_PB3MFP_TM_BRAKE1@GPB_MFPL', 'EBI_ALE:SYS_GPB_MFPL_PB3MFP_EBI_ALE@GPB_MFPL', 'USCI0_DAT1:SYS_GPB_MFPL_PB3MFP_USCI0_DAT1@GPB_MFPL', 'TM0_EXT:SYS_GPB_MFPL_PB3MFP_TM0_EXT@GPB_MFPL'] },
	{ f: ['PB.4', 'ADC0_CH4:SYS_GPB_MFPL_PB4MFP_ADC0_CH4@GPB_MFPL', 'SPI0_SS:SYS_GPB_MFPL_PB4MFP_SPI0_SS@GPB_MFPL', 'SPI1_SS:SYS_GPB_MFPL_PB4MFP_SPI1_SS@GPB_MFPL', 'UART1_nCTS:SYS_GPB_MFPL_PB4MFP_UART1_nCTS@GPB_MFPL', 'ACMP0_N:SYS_GPB_MFPL_PB4MFP_ACMP0_N@GPB_MFPL', 'SC1_nCD:SYS_GPB_MFPL_PB4MFP_SC1_nCD@GPB_MFPL', 'EBI_AD7:SYS_GPB_MFPL_PB4MFP_EBI_AD7@GPB_MFPL', 'USCI0_CTL1:SYS_GPB_MFPL_PB4MFP_USCI0_CTL1@GPB_MFPL', 'UART2_RXD:SYS_GPB_MFPL_PB4MFP_UART2_RXD@GPB_MFPL', 'TM1_EXT:SYS_GPB_MFPL_PB4MFP_TM1_EXT@GPB_MFPL'] },
	{ f: ['PB.5', 'ADC0_CH13:SYS_GPB_MFPL_PB5MFP_ADC0_CH13@GPB_MFPL', 'SPI0_MOSI:SYS_GPB_MFPL_PB5MFP_SPI0_MOSI@GPB_MFPL', 'SPI1_MOSI:SYS_GPB_MFPL_PB5MFP_SPI1_MOSI@GPB_MFPL', 'ACMP0_P2:SYS_GPB_MFPL_PB5MFP_ACMP0_P2@GPB_MFPL', 'SC1_RST:SYS_GPB_MFPL_PB5MFP_SC1_RST@GPB_MFPL', 'EBI_AD6:SYS_GPB_MFPL_PB5MFP_EBI_AD6@GPB_MFPL', 'UART2_RXD:SYS_GPB_MFPL_PB5MFP_UART2_RXD@GPB_MFPL'] },
	{ f: ['PB.6', 'ADC0_CH14:SYS_GPB_MFPL_PB6MFP_ADC0_CH14@GPB_MFPL', 'SPI0_MISO:SYS_GPB_MFPL_PB6MFP_SPI0_MISO@GPB_MFPL', 'SPI1_MISO:SYS_GPB_MFPL_PB6MFP_SPI1_MISO@GPB_MFPL', 'ACMP0_P1:SYS_GPB_MFPL_PB6MFP_ACMP0_P1@GPB_MFPL', 'SC1_PWR:SYS_GPB_MFPL_PB6MFP_SC1_PWR@GPB_MFPL', 'EBI_AD5:SYS_GPB_MFPL_PB6MFP_EBI_AD5@GPB_MFPL'] },
	{ f: ['PB.7', 'ADC0_CH15:SYS_GPB_MFPL_PB7MFP_ADC0_CH15@GPB_MFPL', 'SPI0_CLK:SYS_GPB_MFPL_PB7MFP_SPI0_CLK@GPB_MFPL', 'SPI1_CLK:SYS_GPB_MFPL_PB7MFP_SPI1_CLK@GPB_MFPL', 'USCI2_CTL1:SYS_GPB_MFPL_PB7MFP_USCI2_CTL1@GPB_MFPL', 'ACMP0_P0:SYS_GPB_MFPL_PB7MFP_ACMP0_P0@GPB_MFPL', 'SC1_DAT:SYS_GPB_MFPL_PB7MFP_SC1_DAT@GPB_MFPL', 'EBI_AD4:SYS_GPB_MFPL_PB7MFP_EBI_AD4@GPB_MFPL'] },
	{ f: ['PB.8', 'ADC0_CH5:SYS_GPB_MFPH_PB8MFP_ADC0_CH5@GPB_MFPH', 'UART1_nRTS:SYS_GPB_MFPH_PB8MFP_UART1_nRTS@GPB_MFPH', 'TM_BRAKE2:SYS_GPB_MFPH_PB8MFP_TM_BRAKE2@GPB_MFPH', 'PWM0_CH2:SYS_GPB_MFPH_PB8MFP_PWM0_CH2@GPB_MFPH', 'USCI0_CTL0:SYS_GPB_MFPH_PB8MFP_USCI0_CTL0@GPB_MFPH'] },
	{ f: ['PB.9', 'ADC0_CH6:SYS_GPB_MFPH_PB9MFP_ADC0_CH6@GPB_MFPH', 'USCI0_CLK:SYS_GPB_MFPH_PB9MFP_USCI0_CLK@GPB_MFPH'] },
	{ f: ['PB.10', 'ADC0_CH7:SYS_GPB_MFPH_PB10MFP_ADC0_CH7@GPB_MFPH'] },
	{ f: ['PB.11', 'ADC0_CH8:SYS_GPB_MFPH_PB11MFP_ADC0_CH8@GPB_MFPH'] },
	{ f: ['PB.12', 'PWM1_CH1:SYS_GPB_MFPH_PB12MFP_PWM1_CH1@GPB_MFPH'] },
	{ f: ['PB.13', 'ADC0_CH10:SYS_GPB_MFPH_PB13MFP_ADC0_CH10@GPB_MFPH'] },
	{ f: ['PB.14', 'ADC0_CH11:SYS_GPB_MFPH_PB14MFP_ADC0_CH11@GPB_MFPH'] },
	{ f: ['PB.15', 'ADC0_CH12:SYS_GPB_MFPH_PB15MFP_ADC0_CH12@GPB_MFPH', 'ACMP0_P3:SYS_GPB_MFPH_PB15MFP_ACMP0_P3@GPB_MFPH', 'EBI_nCS1:SYS_GPB_MFPH_PB15MFP_EBI_nCS1@GPB_MFPH'] },

	{ f: ['PC.0', 'SC0_DAT:SYS_GPC_MFPL_PC0MFP_SC0_DAT@GPC_MFPL', 'SPI0_CLK:SYS_GPC_MFPL_PC0MFP_SPI0_CLK@GPC_MFPL', 'UART2_nCTS:SYS_GPC_MFPL_PC0MFP_UART2_nCTS@GPC_MFPL', 'USCI0_DAT0:SYS_GPC_MFPL_PC0MFP_USCI0_DAT0@GPC_MFPL', 'ACMP0_WLAT:SYS_GPC_MFPL_PC0MFP_ACMP0_WLAT@GPC_MFPL', 'PWM0_CH0:SYS_GPC_MFPL_PC0MFP_PWM0_CH0@GPC_MFPL', 'EBI_AD8:SYS_GPC_MFPL_PC0MFP_EBI_AD8@GPC_MFPL', 'INT2:SYS_GPC_MFPL_PC0MFP_INT2@GPC_MFPL'] },
	{ f: ['PC.1', 'CLKO:SYS_GPC_MFPL_PC1MFP_CLKO@GPC_MFPL', 'SC0_CLK:SYS_GPC_MFPL_PC1MFP_SC0_CLK@GPC_MFPL', 'UART2_nRTS:SYS_GPC_MFPL_PC1MFP_UART2_nRTS@GPC_MFPL', 'USCI0_DAT1:SYS_GPC_MFPL_PC1MFP_USCI0_DAT1@GPC_MFPL', 'ACMP1_WLAT:SYS_GPC_MFPL_PC1MFP_ACMP1_WLAT@GPC_MFPL', 'PWM0_CH1:SYS_GPC_MFPL_PC1MFP_PWM0_CH1@GPC_MFPL', 'EBI_AD9:SYS_GPC_MFPL_PC1MFP_EBI_AD9@GPC_MFPL'] },
	{ f: ['PC.2', 'SC0_RST:SYS_GPC_MFPL_PC2MFP_SC0_RST@GPC_MFPL', 'SPI0_SS:SYS_GPC_MFPL_PC2MFP_SPI0_SS@GPC_MFPL', 'UART2_TXD:SYS_GPC_MFPL_PC2MFP_UART2_TXD@GPC_MFPL', 'USCI0_CTL1:SYS_GPC_MFPL_PC2MFP_USCI0_CTL1@GPC_MFPL', 'ACMP1_O:SYS_GPC_MFPL_PC2MFP_ACMP1_O@GPC_MFPL', 'PWM0_CH2:SYS_GPC_MFPL_PC2MFP_PWM0_CH2@GPC_MFPL', 'EBI_AD10:SYS_GPC_MFPL_PC2MFP_EBI_AD10@GPC_MFPL'] },
	{ f: ['PC.3', 'SC0_PWR:SYS_GPC_MFPL_PC3MFP_SC0_PWR@GPC_MFPL', 'SPI0_MOSI:SYS_GPC_MFPL_PC3MFP_SPI0_MOSI@GPC_MFPL', 'UART2_RXD:SYS_GPC_MFPL_PC3MFP_UART2_RXD@GPC_MFPL', 'USCI0_CTL0:SYS_GPC_MFPL_PC3MFP_USCI0_CTL0@GPC_MFPL', 'PWM0_CH3:SYS_GPC_MFPL_PC3MFP_PWM0_CH3@GPC_MFPL', 'EBI_AD11:SYS_GPC_MFPL_PC3MFP_EBI_AD11@GPC_MFPL'] },
	{ f: ['PC.4', 'SC0_nCD:SYS_GPC_MFPL_PC4MFP_SC0_nCD@GPC_MFPL', 'SPI0_MISO:SYS_GPC_MFPL_PC4MFP_SPI0_MISO@GPC_MFPL', 'I2C1_SCL:SYS_GPC_MFPL_PC4MFP_I2C1_SCL@GPC_MFPL', 'USCI0_CLK:SYS_GPC_MFPL_PC4MFP_USCI0_CLK@GPC_MFPL', 'PWM0_CH4:SYS_GPC_MFPL_PC4MFP_PWM0_CH4@GPC_MFPL', 'EBI_AD12:SYS_GPC_MFPL_PC4MFP_EBI_AD12@GPC_MFPL'] },
	{ f: ['PC.5', 'SPI0_I2SMCLK:SYS_GPC_MFPL_PC5MFP_SPI0_I2SMCLK@GPC_MFPL', 'I2C1_SDA:SYS_GPC_MFPL_PC5MFP_I2C1_SDA@GPC_MFPL', 'USCI0_DAT0:SYS_GPC_MFPL_PC5MFP_USCI0_DAT0@GPC_MFPL', 'PWM0_CH5:SYS_GPC_MFPL_PC5MFP_PWM0_CH5@GPC_MFPL', 'EBI_AD13:SYS_GPC_MFPL_PC5MFP_EBI_AD13@GPC_MFPL'] },
	{ f: ['PC.6', 'USCI0_DAT1:SYS_GPC_MFPL_PC6MFP_USCI0_DAT1@GPC_MFPL', 'ACMP1_O:SYS_GPC_MFPL_PC6MFP_ACMP1_O@GPC_MFPL', 'PWM1_CH0:SYS_GPC_MFPL_PC6MFP_PWM1_CH0@GPC_MFPL', 'EBI_AD14:SYS_GPC_MFPL_PC6MFP_EBI_AD14@GPC_MFPL'] },
	{ f: ['PC.7', 'USCI0_CTL1:SYS_GPC_MFPL_PC7MFP_USCI0_CTL1@GPC_MFPL', 'PWM1_CH1:SYS_GPC_MFPL_PC7MFP_PWM1_CH1@GPC_MFPL', 'EBI_AD15:SYS_GPC_MFPL_PC7MFP_EBI_AD15@GPC_MFPL'] },
	{ f: ['PC.8', 'ADC0_CH16:SYS_GPC_MFPH_PC8MFP_ADC0_CH16@GPC_MFPH', 'UART0_nRTS:SYS_GPC_MFPH_PC8MFP_UART0_nRTS@GPC_MFPH'] },
	{ f: ['PC.9', 'SPI0_I2SMCLK:SYS_GPC_MFPH_PC9MFP_SPI0_I2SMCLK@GPC_MFPH', 'I2C1_SCL:SYS_GPC_MFPH_PC9MFP_I2C1_SCL@GPC_MFPH', 'USCI2_CTL1:SYS_GPC_MFPH_PC9MFP_USCI2_CTL1@GPC_MFPH', 'PWM1_CH0:SYS_GPC_MFPH_PC9MFP_PWM1_CH0@GPC_MFPH'] },
	{ f: ['PC.10', 'SPI0_MOSI:SYS_GPC_MFPH_PC10MFP_SPI0_MOSI@GPC_MFPH', 'I2C1_SDA:SYS_GPC_MFPH_PC10MFP_I2C1_SDA@GPC_MFPH', 'USCI2_DAT1:SYS_GPC_MFPH_PC10MFP_USCI2_DAT1@GPC_MFPH', 'PWM1_CH1:SYS_GPC_MFPH_PC10MFP_PWM1_CH1@GPC_MFPH'] },
	{ f: ['PC.11', 'SPI0_MISO:SYS_GPC_MFPH_PC11MFP_SPI0_MISO@GPC_MFPH', 'USCI2_CLK:SYS_GPC_MFPH_PC11MFP_USCI2_CLK@GPC_MFPH', 'PWM1_CH2:SYS_GPC_MFPH_PC11MFP_PWM1_CH2@GPC_MFPH'] },
	{ f: ['PC.12', 'SPI0_CLK:SYS_GPC_MFPH_PC12MFP_SPI0_CLK@GPC_MFPH', 'USCI2_CTL0:SYS_GPC_MFPH_PC12MFP_USCI2_CTL0@GPC_MFPH', 'PWM1_CH3:SYS_GPC_MFPH_PC12MFP_PWM1_CH3@GPC_MFPH'] },
	{ f: ['PC.13', 'SPI0_SS:SYS_GPC_MFPH_PC13MFP_SPI0_SS@GPC_MFPH', 'USCI2_DAT0:SYS_GPC_MFPH_PC13MFP_USCI2_DAT0@GPC_MFPH', 'PWM1_CH4:SYS_GPC_MFPH_PC13MFP_PWM1_CH4@GPC_MFPH'] },
	{ f: ['PC.14', 'PWM1_CH5:SYS_GPC_MFPH_PC14MFP_PWM1_CH5@GPC_MFPH'] },
	{ f: ['PC.15', 'PWM1_CH0:SYS_GPC_MFPH_PC15MFP_PWM1_CH0@GPC_MFPH'] },

	{ f: ['PD.0', 'SPI0_I2SMCLK:SYS_GPD_MFPL_PD0MFP_SPI0_I2SMCLK@GPD_MFPL', 'SPI1_I2SMCLK:SYS_GPD_MFPL_PD0MFP_SPI1_I2SMCLK@GPD_MFPL', 'UART0_RXD:SYS_GPD_MFPL_PD0MFP_UART0_RXD@GPD_MFPL', 'USCI2_CTL0:SYS_GPD_MFPL_PD0MFP_USCI2_CTL0@GPD_MFPL', 'ACMP1_N:SYS_GPD_MFPL_PD0MFP_ACMP1_N@GPD_MFPL', 'SC1_CLK:SYS_GPD_MFPL_PD0MFP_SC1_CLK@GPD_MFPL', 'INT3:SYS_GPD_MFPL_PD0MFP_INT3@GPD_MFPL'] },
	{ f: ['PD.1', 'ADC0_CH19:SYS_GPD_MFPL_PD1MFP_ADC0_CH19@GPD_MFPL', 'PWM0_SYNC_IN:SYS_GPD_MFPL_PD1MFP_PWM0_SYNC_IN@GPD_MFPL', 'UART0_TXD:SYS_GPD_MFPL_PD1MFP_UART0_TXD@GPD_MFPL', 'USCI2_CLK:SYS_GPD_MFPL_PD1MFP_USCI2_CLK@GPD_MFPL', 'ACMP1_P2:SYS_GPD_MFPL_PD1MFP_ACMP1_P2@GPD_MFPL', 'TM0:SYS_GPD_MFPL_PD1MFP_TM0@GPD_MFPL', 'EBI_nRD:SYS_GPD_MFPL_PD1MFP_EBI_nRD@GPD_MFPL'] },
	{ f: ['PD.2', 'ADC0_ST:SYS_GPD_MFPL_PD2MFP_ADC0_ST@GPD_MFPL', 'TM0_EXT:SYS_GPD_MFPL_PD2MFP_TM0_EXT@GPD_MFPL', 'USCI2_DAT0:SYS_GPD_MFPL_PD2MFP_USCI2_DAT0@GPD_MFPL', 'ACMP1_P1:SYS_GPD_MFPL_PD2MFP_ACMP1_P1@GPD_MFPL', 'PWM0_BRAKE0:SYS_GPD_MFPL_PD2MFP_PWM0_BRAKE0@GPD_MFPL', 'EBI_nWR:SYS_GPD_MFPL_PD2MFP_EBI_nWR@GPD_MFPL', 'INT0:SYS_GPD_MFPL_PD2MFP_INT0@GPD_MFPL'] },
	{ f: ['PD.3', 'TM2:SYS_GPD_MFPL_PD3MFP_TM2@GPD_MFPL', 'SPI0_I2SMCLK:SYS_GPD_MFPL_PD3MFP_SPI0_I2SMCLK@GPD_MFPL', 'TM1_EXT:SYS_GPD_MFPL_PD3MFP_TM1_EXT@GPD_MFPL', 'USCI2_DAT1:SYS_GPD_MFPL_PD3MFP_USCI2_DAT1@GPD_MFPL', 'ACMP1_P0:SYS_GPD_MFPL_PD3MFP_ACMP1_P0@GPD_MFPL', 'PWM0_BRAKE1:SYS_GPD_MFPL_PD3MFP_PWM0_BRAKE1@GPD_MFPL', 'EBI_MCLK:SYS_GPD_MFPL_PD3MFP_EBI_MCLK@GPD_MFPL', 'INT1:SYS_GPD_MFPL_PD3MFP_INT1@GPD_MFPL'] },
	{ f: ['PD.4', 'SPI1_CLK:SYS_GPD_MFPL_PD4MFP_SPI1_CLK@GPD_MFPL', 'I2C0_SDA:SYS_GPD_MFPL_PD4MFP_I2C0_SDA@GPD_MFPL', 'UART2_nRTS:SYS_GPD_MFPL_PD4MFP_UART2_nRTS@GPD_MFPL', 'PWM0_BRAKE0:SYS_GPD_MFPL_PD4MFP_PWM0_BRAKE0@GPD_MFPL', 'TM0:SYS_GPD_MFPL_PD4MFP_TM0@GPD_MFPL'] },
	{ f: ['PD.5', 'CLKO:SYS_GPD_MFPL_PD5MFP_CLKO@GPD_MFPL', 'SPI1_MISO:SYS_GPD_MFPL_PD5MFP_SPI1_MISO@GPD_MFPL', 'I2C0_SCL:SYS_GPD_MFPL_PD5MFP_I2C0_SCL@GPD_MFPL', 'UART2_nCTS:SYS_GPD_MFPL_PD5MFP_UART2_nCTS@GPD_MFPL', 'PWM0_BRAKE1:SYS_GPD_MFPL_PD5MFP_PWM0_BRAKE1@GPD_MFPL', 'TM1:SYS_GPD_MFPL_PD5MFP_TM1@GPD_MFPL'] },
	{ f: ['PD.6', 'CLKO:SYS_GPD_MFPL_PD6MFP_CLKO@GPD_MFPL', 'SPI1_SS:SYS_GPD_MFPL_PD6MFP_SPI1_SS@GPD_MFPL', 'UART0_RXD:SYS_GPD_MFPL_PD6MFP_UART0_RXD@GPD_MFPL', 'UART2_TXD:SYS_GPD_MFPL_PD6MFP_UART2_TXD@GPD_MFPL', 'ACMP0_O:SYS_GPD_MFPL_PD6MFP_ACMP0_O@GPD_MFPL', 'PWM0_CH5:SYS_GPD_MFPL_PD6MFP_PWM0_CH5@GPD_MFPL', 'EBI_nWR:SYS_GPD_MFPL_PD6MFP_EBI_nWR@GPD_MFPL'] },
	{ f: ['PD.7', 'USCI1_CTL1:SYS_GPD_MFPL_PD7MFP_USCI1_CTL1@GPD_MFPL', 'SPI0_I2SMCLK:SYS_GPD_MFPL_PD7MFP_SPI0_I2SMCLK@GPD_MFPL', 'PWM0_SYNC_IN:SYS_GPD_MFPL_PD7MFP_PWM0_SYNC_IN@GPD_MFPL', 'TM1:SYS_GPD_MFPL_PD7MFP_TM1@GPD_MFPL', 'ACMP0_O:SYS_GPD_MFPL_PD7MFP_ACMP0_O@GPD_MFPL', 'PWM0_CH5:SYS_GPD_MFPL_PD7MFP_PWM0_CH5@GPD_MFPL', 'EBI_nRD:SYS_GPD_MFPL_PD7MFP_EBI_nRD@GPD_MFPL'] },
	{ f: ['PD.8', 'ADC0_CH17:SYS_GPD_MFPH_PD8MFP_ADC0_CH17@GPD_MFPH', 'UART0_nCTS:SYS_GPD_MFPH_PD8MFP_UART0_nCTS@GPD_MFPH', 'USCI2_CTL1:SYS_GPD_MFPH_PD8MFP_USCI2_CTL1@GPD_MFPH', 'TM2:SYS_GPD_MFPH_PD8MFP_TM2@GPD_MFPH', 'EBI_nCS0:SYS_GPD_MFPH_PD8MFP_EBI_nCS0@GPD_MFPH'] },
	{ f: ['PD.9', 'ADC0_CH18:SYS_GPD_MFPH_PD9MFP_ADC0_CH18@GPD_MFPH', 'UART0_RXD:SYS_GPD_MFPH_PD9MFP_UART0_RXD@GPD_MFPH', 'USCI2_CTL0:SYS_GPD_MFPH_PD9MFP_USCI2_CTL0@GPD_MFPH', 'ACMP1_P3:SYS_GPD_MFPH_PD9MFP_ACMP1_P3@GPD_MFPH', 'TM3:SYS_GPD_MFPH_PD9MFP_TM3@GPD_MFPH', 'EBI_ALE:SYS_GPD_MFPH_PD9MFP_EBI_ALE@GPD_MFPH'] },
	{ f: ['PD.10', 'TM2:SYS_GPD_MFPH_PD10MFP_TM2@GPD_MFPH', 'USCI2_DAT0:SYS_GPD_MFPH_PD10MFP_USCI2_DAT0@GPD_MFPH'] },
	{ f: ['PD.11', 'TM3:SYS_GPD_MFPH_PD11MFP_TM3@GPD_MFPH', 'USCI2_DAT1:SYS_GPD_MFPH_PD11MFP_USCI2_DAT1@GPD_MFPH'] },
	{ f: ['PD.12', 'USCI1_CTL0:SYS_GPD_MFPH_PD12MFP_USCI1_CTL0@GPD_MFPH', 'SPI1_SS:SYS_GPD_MFPH_PD12MFP_SPI1_SS@GPD_MFPH', 'UART0_TXD:SYS_GPD_MFPH_PD12MFP_UART0_TXD@GPD_MFPH', 'PWM1_CH0:SYS_GPD_MFPH_PD12MFP_PWM1_CH0@GPD_MFPH', 'EBI_ADR16:SYS_GPD_MFPH_PD12MFP_EBI_ADR16@GPD_MFPH'] },
	{ f: ['PD.13', 'USCI1_DAT1:SYS_GPD_MFPH_PD13MFP_USCI1_DAT1@GPD_MFPH', 'SPI1_MOSI:SYS_GPD_MFPH_PD13MFP_SPI1_MOSI@GPD_MFPH', 'UART0_RXD:SYS_GPD_MFPH_PD13MFP_UART0_RXD@GPD_MFPH', 'PWM1_CH1:SYS_GPD_MFPH_PD13MFP_PWM1_CH1@GPD_MFPH', 'EBI_ADR17:SYS_GPD_MFPH_PD13MFP_EBI_ADR17@GPD_MFPH'] },
	{ f: ['PD.14', 'USCI1_DAT0:SYS_GPD_MFPH_PD14MFP_USCI1_DAT0@GPD_MFPH', 'SPI1_MISO:SYS_GPD_MFPH_PD14MFP_SPI1_MISO@GPD_MFPH', 'UART0_nCTS:SYS_GPD_MFPH_PD14MFP_UART0_nCTS@GPD_MFPH', 'PWM1_CH2:SYS_GPD_MFPH_PD14MFP_PWM1_CH2@GPD_MFPH', 'EBI_ADR18:SYS_GPD_MFPH_PD14MFP_EBI_ADR18@GPD_MFPH'] },
	{ f: ['PD.15', 'USCI1_CLK:SYS_GPD_MFPH_PD15MFP_USCI1_CLK@GPD_MFPH', 'SPI1_CLK:SYS_GPD_MFPH_PD15MFP_SPI1_CLK@GPD_MFPH', 'UART0_nRTS:SYS_GPD_MFPH_PD15MFP_UART0_nRTS@GPD_MFPH', 'PWM1_CH3:SYS_GPD_MFPH_PD15MFP_PWM1_CH3@GPD_MFPH', 'EBI_ADR19:SYS_GPD_MFPH_PD15MFP_EBI_ADR19@GPD_MFPH'] },

	{ f: ['PE.0', 'SPI0_CLK:SYS_GPE_MFPL_PE0MFP_SPI0_CLK@GPE_MFPL', 'I2C1_SDA:SYS_GPE_MFPL_PE0MFP_I2C1_SDA@GPE_MFPL', 'TM2_EXT:SYS_GPE_MFPL_PE0MFP_TM2_EXT@GPE_MFPL', 'SC0_nCD:SYS_GPE_MFPL_PE0MFP_SC0_nCD@GPE_MFPL', 'PWM0_CH0:SYS_GPE_MFPL_PE0MFP_PWM0_CH0@GPE_MFPL', 'EBI_nCS1:SYS_GPE_MFPL_PE0MFP_EBI_nCS1@GPE_MFPL', 'INT4:SYS_GPE_MFPL_PE0MFP_INT4@GPE_MFPL'] },
	{ f: ['PE.1', 'TM3_EXT:SYS_GPE_MFPL_PE1MFP_TM3_EXT@GPE_MFPL', 'SC0_nCD:SYS_GPE_MFPL_PE1MFP_SC0_nCD@GPE_MFPL', 'PWM0_CH1:SYS_GPE_MFPL_PE1MFP_PWM0_CH1@GPE_MFPL'] },
	{ f: ['PE.2', 'ADC0_CH9:SYS_GPE_MFPL_PE2MFP_ADC0_CH9@GPE_MFPL', 'UART1_nRTS:SYS_GPE_MFPL_PE2MFP_UART1_nRTS@GPE_MFPL', 'TM_BRAKE3:SYS_GPE_MFPL_PE2MFP_TM_BRAKE3@GPE_MFPL', 'PWM0_CH2:SYS_GPE_MFPL_PE2MFP_PWM0_CH2@GPE_MFPL', 'USCI0_CTL0:SYS_GPE_MFPL_PE2MFP_USCI0_CTL0@GPE_MFPL'] },
	{ f: ['PE.3', 'SPI1_MOSI:SYS_GPE_MFPL_PE3MFP_SPI1_MOSI@GPE_MFPL', 'UART2_RXD:SYS_GPE_MFPL_PE3MFP_UART2_RXD@GPE_MFPL', 'PWM0_CH3:SYS_GPE_MFPL_PE3MFP_PWM0_CH3@GPE_MFPL'] },
	{ f: ['PE.4', 'I2C0_SCL:SYS_GPE_MFPL_PE4MFP_I2C0_SCL@GPE_MFPL', 'I2C1_SCL:SYS_GPE_MFPL_PE4MFP_I2C1_SCL@GPE_MFPL', 'USCI0_CTL0:SYS_GPE_MFPL_PE4MFP_USCI0_CTL0@GPE_MFPL', 'SC0_PWR:SYS_GPE_MFPL_PE4MFP_SC0_PWR@GPE_MFPL', 'PWM1_BRAKE0:SYS_GPE_MFPL_PE4MFP_PWM1_BRAKE0@GPE_MFPL', 'EBI_nCS0:SYS_GPE_MFPL_PE4MFP_EBI_nCS0@GPE_MFPL', 'INT0:SYS_GPE_MFPL_PE4MFP_INT0@GPE_MFPL'] },
	{ f: ['PE.5', 'I2C0_SDA:SYS_GPE_MFPL_PE5MFP_I2C0_SDA@GPE_MFPL', 'I2C1_SDA:SYS_GPE_MFPL_PE5MFP_I2C1_SDA@GPE_MFPL', 'USCI0_CLK:SYS_GPE_MFPL_PE5MFP_USCI0_CLK@GPE_MFPL', 'SC0_RST:SYS_GPE_MFPL_PE5MFP_SC0_RST@GPE_MFPL', 'PWM1_BRAKE1:SYS_GPE_MFPL_PE5MFP_PWM1_BRAKE1@GPE_MFPL', 'EBI_ALE:SYS_GPE_MFPL_PE5MFP_EBI_ALE@GPE_MFPL', 'INT1:SYS_GPE_MFPL_PE5MFP_INT1@GPE_MFPL'] },
	{ f: ['PE.6', 'ICE_CLK:SYS_GPE_MFPL_PE6MFP_ICE_CLK@GPE_MFPL', 'I2C0_SCL:SYS_GPE_MFPL_PE6MFP_I2C0_SCL@GPE_MFPL', 'UART0_RXD:SYS_GPE_MFPL_PE6MFP_UART0_RXD@GPE_MFPL'] },
	{ f: ['PE.7', 'ICE_DAT:SYS_GPE_MFPL_PE7MFP_ICE_DAT@GPE_MFPL', 'I2C0_SDA:SYS_GPE_MFPL_PE7MFP_I2C0_SDA@GPE_MFPL', 'UART0_TXD:SYS_GPE_MFPL_PE7MFP_UART0_TXD@GPE_MFPL'] },
	{ f: ['PE.8', 'UART1_TXD:SYS_GPE_MFPH_PE8MFP_UART1_TXD@GPE_MFPH', 'TM0:SYS_GPE_MFPH_PE8MFP_TM0@GPE_MFPH', 'I2C1_SCL:SYS_GPE_MFPH_PE8MFP_I2C1_SCL@GPE_MFPH', 'SC0_PWR:SYS_GPE_MFPH_PE8MFP_SC0_PWR@GPE_MFPH'] },
	{ f: ['PE.9', 'UART1_RXD:SYS_GPE_MFPH_PE9MFP_UART1_RXD@GPE_MFPH', 'TM1:SYS_GPE_MFPH_PE9MFP_TM1@GPE_MFPH', 'I2C1_SDA:SYS_GPE_MFPH_PE9MFP_I2C1_SDA@GPE_MFPH', 'SC0_RST:SYS_GPE_MFPH_PE9MFP_SC0_RST@GPE_MFPH'] },
	{ f: ['PE.10', 'SPI1_MISO:SYS_GPE_MFPH_PE10MFP_SPI1_MISO@GPE_MFPH', 'SPI0_MISO:SYS_GPE_MFPH_PE10MFP_SPI0_MISO@GPE_MFPH', 'UART1_nCTS:SYS_GPE_MFPH_PE10MFP_UART1_nCTS@GPE_MFPH', 'SC0_DAT:SYS_GPE_MFPH_PE10MFP_SC0_DAT@GPE_MFPH', 'SPI1_CLK:SYS_GPE_MFPH_PE10MFP_SPI1_CLK@GPE_MFPH', 'EBI_AD7:SYS_GPE_MFPH_PE10MFP_EBI_AD7@GPE_MFPH', 'TM0_EXT:SYS_GPE_MFPH_PE10MFP_TM0_EXT@GPE_MFPH'] },
	{ f: ['PE.11', 'SPI1_MOSI:SYS_GPE_MFPH_PE11MFP_SPI1_MOSI@GPE_MFPH', 'SPI0_MOSI:SYS_GPE_MFPH_PE11MFP_SPI0_MOSI@GPE_MFPH', 'UART1_nRTS:SYS_GPE_MFPH_PE11MFP_UART1_nRTS@GPE_MFPH', 'SC0_CLK:SYS_GPE_MFPH_PE11MFP_SC0_CLK@GPE_MFPH', 'SPI1_MISO:SYS_GPE_MFPH_PE11MFP_SPI1_MISO@GPE_MFPH', 'EBI_AD6:SYS_GPE_MFPH_PE11MFP_EBI_AD6@GPE_MFPH', 'TM1_EXT:SYS_GPE_MFPH_PE11MFP_TM1_EXT@GPE_MFPH'] },
	{ f: ['PE.12', 'SPI1_SS:SYS_GPE_MFPH_PE12MFP_SPI1_SS@GPE_MFPH', 'SPI0_SS:SYS_GPE_MFPH_PE12MFP_SPI0_SS@GPE_MFPH', 'UART1_TXD:SYS_GPE_MFPH_PE12MFP_UART1_TXD@GPE_MFPH', 'I2C0_SCL:SYS_GPE_MFPH_PE12MFP_I2C0_SCL@GPE_MFPH', 'SPI1_MOSI:SYS_GPE_MFPH_PE12MFP_SPI1_MOSI@GPE_MFPH', 'EBI_AD5:SYS_GPE_MFPH_PE12MFP_EBI_AD5@GPE_MFPH', 'TM2_EXT:SYS_GPE_MFPH_PE12MFP_TM2_EXT@GPE_MFPH'] },
	{ f: ['PE.13', 'SPI1_CLK:SYS_GPE_MFPH_PE13MFP_SPI1_CLK@GPE_MFPH', 'SPI0_CLK:SYS_GPE_MFPH_PE13MFP_SPI0_CLK@GPE_MFPH', 'UART1_RXD:SYS_GPE_MFPH_PE13MFP_UART1_RXD@GPE_MFPH', 'I2C0_SDA:SYS_GPE_MFPH_PE13MFP_I2C0_SDA@GPE_MFPH', 'SPI1_SS:SYS_GPE_MFPH_PE13MFP_SPI1_SS@GPE_MFPH', 'EBI_AD4:SYS_GPE_MFPH_PE13MFP_EBI_AD4@GPE_MFPH', 'TM3_EXT:SYS_GPE_MFPH_PE13MFP_TM3_EXT@GPE_MFPH'] },
	{ f: ['PE.14'] },
	{ f: ['PE.15'] },

	{ f: ['PF.0', 'X32_OUT:SYS_GPF_MFPL_PF0MFP_X32_OUT@GPF_MFPL', 'USCI2_CTL1:SYS_GPF_MFPL_PF0MFP_USCI2_CTL1@GPF_MFPL', 'INT5:SYS_GPF_MFPL_PF0MFP_INT5@GPF_MFPL'] },
	{ f: ['PF.1', 'X32_IN:SYS_GPF_MFPL_PF1MFP_X32_IN@GPF_MFPL', 'USCI2_CTL0:SYS_GPF_MFPL_PF1MFP_USCI2_CTL0@GPF_MFPL', 'PWM1_BRAKE0:SYS_GPF_MFPL_PF1MFP_PWM1_BRAKE0@GPF_MFPL'] },
	{ f: ['PF.2', 'USCI2_CLK:SYS_GPF_MFPL_PF2MFP_USCI2_CLK@GPF_MFPL', 'PWM1_BRAKE1:SYS_GPF_MFPL_PF2MFP_PWM1_BRAKE1@GPF_MFPL'] },
	{ f: ['PF.3', 'XT1_OUT:SYS_GPF_MFPL_PF3MFP_XT1_OUT@GPF_MFPL', 'I2C1_SCL:SYS_GPF_MFPL_PF3MFP_I2C1_SCL@GPF_MFPL'] },
	{ f: ['PF.4', 'XT1_IN:SYS_GPF_MFPL_PF4MFP_XT1_IN@GPF_MFPL', 'I2C1_SDA:SYS_GPF_MFPL_PF4MFP_I2C1_SDA@GPF_MFPL'] },
	{ f: ['PF.5', 'TM3_EXT:SYS_GPF_MFPL_PF5MFP_TM3_EXT@GPF_MFPL', 'SC1_nCD:SYS_GPF_MFPL_PF5MFP_SC1_nCD@GPF_MFPL', 'TM_BRAKE0:SYS_GPF_MFPL_PF5MFP_TM_BRAKE0@GPF_MFPL'] },
	{ f: ['PF.6'] },
	{ f: ['PF.7'] }
];

NUTOOL_PIN.g_cfg_gpiosDescriptions = [
	'ACMP0_N:Analog comparator 0 negative input pin',
	'ACMP0_O:Analog comparator 0 output pin',
	'ACMP0_P0:Analog comparator 0 positive input 0 pin',
	'ACMP0_P1:Analog comparator 0 positive input 1 pin',
	'ACMP0_P2:Analog comparator 0 positive input 2 pin',
	'ACMP0_P3:Analog comparator 0 positive input 3 pin',
	'ACMP0_WLAT:Analog comparator 0 window latch input pin',
	'ACMP1_N:Analog comparator 1 negative input pin',
	'ACMP1_O:Analog comparator 1 output pin',
	'ACMP1_P0:Analog comparator 1 positive input 0 pin',
	'ACMP1_P1:Analog comparator 1 positive input 1 pin',
	'ACMP1_P2:Analog comparator 1 positive input 2 pin',
	'ACMP1_P3:Analog comparator 1 positive input 3 pin',
	'ACMP1_WLAT:Analog comparator 1 window latch input pin',
	'ADC0_CH0:ADC0 channel 0 analog input',
	'ADC0_CH1:ADC0 channel 1 analog input',
	'ADC0_CH2:ADC0 channel 2 analog input',
	'ADC0_CH3:ADC0 channel 3 analog input',
	'ADC0_CH4:ADC0 channel 4 analog input',
	'ADC0_CH5:ADC0 channel 5 analog input',
	'ADC0_CH6:ADC0 channel 6 analog input',
	'ADC0_CH7:ADC0 channel 7 analog input',
	'ADC0_CH8:ADC0 channel 8 analog input',
	'ADC0_CH9:ADC0 channel 9 analog input',
	'ADC0_CH10:ADC0 channel 10 analog input',
	'ADC0_CH11:ADC0 channel 11 analog input',
	'ADC0_CH12:ADC0 channel 12 analog input',
	'ADC0_CH13:ADC0 channel 13 analog input',
	'ADC0_CH14:ADC0 channel 14 analog input',
	'ADC0_CH15:ADC0 channel 15 analog input',
	'ADC0_CH16:ADC0 channel 16 analog input',
	'ADC0_CH17:ADC0 channel 17 analog input',
	'ADC0_CH18:ADC0 channel 18 analog input',
	'ADC0_CH19:ADC0 channel 19 analog input',
	'ADC0_ST:ADC0 external trigger input pin',
	'CLKO:Clock Out',
	'EBI_AD0:EBI address/data bus bit 0',
	'EBI_AD1:EBI address/data bus bit 1',
	'EBI_AD2:EBI address/data bus bit 2',
	'EBI_AD3:EBI address/data bus bit 3',
	'EBI_AD4:EBI address/data bus bit 4',
	'EBI_AD5:EBI address/data bus bit 5',
	'EBI_AD6:EBI address/data bus bit 6',
	'EBI_AD7:EBI address/data bus bit 7',
	'EBI_AD8:EBI address/data bus bit 8',
	'EBI_AD9:EBI address/data bus bit 9',
	'EBI_AD10:EBI address/data bus bit 10',
	'EBI_AD11:EBI address/data bus bit 11',
	'EBI_AD12:EBI address/data bus bit 12',
	'EBI_AD13:EBI address/data bus bit 13',
	'EBI_AD14:EBI address/data bus bit 14',
	'EBI_AD15:EBI address/data bus bit 15',
	'EBI_ADR16:EBI address bus bit 16',
	'EBI_ADR17:EBI address bus bit 17',
	'EBI_ADR18:EBI address bus bit 18',
	'EBI_ADR19:EBI address bus bit 19',
	'EBI_ALE:EBI address latch enable output pin',
	'EBI_MCLK:EBI external clock output pin',
	'EBI_nCS0:EBI chip select 0 output pin',
	'EBI_nCS1:EBI chip select 1 output pin',
	'EBI_nRD:EBI read enable output pin',
	'EBI_nWR:EBI write enable output pin',
	'EBI_nWRH:EBI high byte write enable output pin',
	'EBI_nWRL:EBI low byte write enable output pin',
	'I2C0_SCL:I2C0 clock pin',
	'I2C0_SDA:I2C0 data input/output pin',
	'I2C1_SCL:I2C1 clock pin',
	'I2C1_SDA:I2C1 data input/output pin',
	'ICE_CLK:Serial wired debugger clock pin',
	'ICE_DAT:Serial wired debugger data pin',
	'INT0:External interrupt 0 input pin',
	'INT1:External interrupt 1 input pin',
	'INT2:External interrupt 2 input pin',
	'INT3:External interrupt 3 input pin',
	'INT4:External interrupt 4 input pin',
	'INT5:External interrupt 5 input pin',
	'PWM0_BRAKE0:PWM0 Brake 0 input pin',
	'PWM0_BRAKE1:PWM0 Brake 1 input pin',
	'PWM0_CH0:PWM0 channel 0 output/capture input',
	'PWM0_CH1:PWM0 channel 1 output/capture input',
	'PWM0_CH2:PWM0 channel 2 output/capture input',
	'PWM0_CH3:PWM0 channel 3 output/capture input',
	'PWM0_CH4:PWM0 channel 4 output/capture input',
	'PWM0_CH5:PWM0 channel 5 output/capture input',
	'PWM0_SYNC_IN:PWM0 counter synchronous trigger input pin',
	'PWM0_SYNC_OUT:PWM0 counter synchronous trigger output pin',
	'PWM1_BRAKE0:PWM1 Brake 0 input pin',
	'PWM1_BRAKE1:PWM1 Brake 1 input pin',
	'PWM1_CH0:PWM1 channel 0 output/capture input',
	'PWM1_CH1:PWM1 channel 1 output/capture input',
	'PWM1_CH2:PWM1 channel 2 output/capture input',
	'PWM1_CH3:PWM1 channel 3 output/capture input',
	'PWM1_CH4:PWM1 channel 4 output/capture input',
	'PWM1_CH5:PWM1 channel 5 output/capture input',
	'SC0_CLK:Smart Card 0 clock pin',
	'SC0_DAT:Smart Card 0 data pin',
	'SC0_nCD:Smart Card 0 card detect pin',
	'SC0_PWR:Smart Card 0 power pin',
	'SC0_RST:Smart Card 0 reset pin',
	'SC1_CLK:Smart Card 1 clock pin',
	'SC1_DAT:Smart Card 1 data pin',
	'SC1_nCD:Smart Card 1 card detect pin',
	'SC1_PWR:Smart Card 1 power pin',
	'SC1_RST:Smart Card 1 reset pin',
	'SPI0_CLK:SPI0 serial clock pin',
	'SPI0_I2SMCLK:SPI0 I2S master clock output pin',
	'SPI0_MISO:SPI0 MISO (Master In, Slave Out) pin',
	'SPI0_MOSI:SPI0 MOSI (Master Out, Slave In) pin',
	'SPI0_SS:SPI0 slave select pin',
	'SPI1_CLK:SPI1 serial clock pin',
	'SPI1_I2SMCLK:SPI1 I2S master clock output pin',
	'SPI1_MISO:SPI1 MISO (Master In, Slave Out) pin',
	'SPI1_MOSI:SPI1 MOSI (Master Out, Slave In) pin',
	'SPI1_SS:SPI1 slave select pin',
	'TM_BRAKE0:Timer Brake 0 input pin',
	'TM_BRAKE1:Timer Brake 1 input pin',
	'TM_BRAKE2:Timer Brake 2 input pin',
	'TM_BRAKE3:Timer Brake 3 input pin',
	'TM0:Timer0 event counter input/toggle output pin',
	'TM0_EXT:Timer0 external capture input/toggle output pin',
	'TM1:Timer1 event counter input/toggle output pin',
	'TM1_EXT:Timer1 external capture input/toggle output pin',
	'TM2:Timer2 event counter input/toggle output pin',
	'TM2_EXT:Timer2 external capture input/toggle output pin',
	'TM3:Timer3 event counter input/toggle output pin',
	'TM3_EXT:Timer3 external capture input/toggle output pin',
	'UART0_nCTS:UART0 clear to Send input pin',
	'UART0_nRTS:UART0 request to Send output pin',
	'UART0_RXD:UART0 data receiver input pin',
	'UART0_TXD:UART0 data transmitter output pin',
	'UART1_nCTS:UART1 clear to Send input pin',
	'UART1_nRTS:UART1 request to Send output pin',
	'UART1_RXD:UART1 data receiver input pin',
	'UART1_TXD:UART1 data transmitter output pin',
	'UART2_nCTS:UART2 clear to Send input pin',
	'UART2_nRTS:UART2 request to Send output pin',
	'UART2_RXD:UART2 data receiver input pin',
	'UART2_TXD:UART2 data transmitter output pin',
	'USCI0_CLK:USCI0 clock pin',
	'USCI0_CTL0:USCI0 control 0 pin',
	'USCI0_CTL1:USCI0 control 1 pin',
	'USCI0_DAT0:USCI0 data 0 pin',
	'USCI0_DAT1:USCI0 data 1 pin',
	'USCI1_CLK:USCI1 clock pin',
	'USCI1_CTL0:USCI1 control 0 pin',
	'USCI1_CTL1:USCI1 control 1 pin',
	'USCI1_DAT0:USCI1 data 0 pin',
	'USCI1_DAT1:USCI1 data 1 pin',
	'USCI2_CLK:USCI2 clock pin',
	'USCI2_CTL0:USCI2 control 0 pin',
	'USCI2_CTL1:USCI2 control 1 pin',
	'USCI2_DAT0:USCI2 data 0 pin',
	'USCI2_DAT1:USCI2 data 1 pin',
	'VDET_P0:Voltage detector positive input 0 pin',
	'VDET_P1:Voltage detector positive input 1 pin',
	'X32_IN:External 32.768 kHz crystal input pin',
	'X32_OUT:External 32.768 kHz crystal output pin',
	'XT1_IN:External 4~24 MHz (high speed) crystal input pin',
	'XT1_OUT:External 4~24 MHz (high speed) crystal output pin'
];

NUTOOL_PIN.g_cfg_regDescriptions = {};
NUTOOL_PIN.g_cfg_regDescriptions.GPA_MFPL = '0x50000030';
NUTOOL_PIN.g_cfg_regDescriptions.GPA_MFPH = '0x50000034';
NUTOOL_PIN.g_cfg_regDescriptions.GPB_MFPL = '0x50000038';
NUTOOL_PIN.g_cfg_regDescriptions.GPB_MFPH = '0x5000003C';
NUTOOL_PIN.g_cfg_regDescriptions.GPC_MFPL = '0x50000040';
NUTOOL_PIN.g_cfg_regDescriptions.GPC_MFPH = '0x50000044';
NUTOOL_PIN.g_cfg_regDescriptions.GPD_MFPL = '0x50000048';
NUTOOL_PIN.g_cfg_regDescriptions.GPD_MFPH = '0x5000004C';
NUTOOL_PIN.g_cfg_regDescriptions.GPE_MFPL = '0x50000050';
NUTOOL_PIN.g_cfg_regDescriptions.GPE_MFPH = '0x50000054';
NUTOOL_PIN.g_cfg_regDescriptions.GPF_MFPL = '0x50000058';

NUTOOL_PIN.g_cfg_gpioMatrix = [];
NUTOOL_PIN.g_cfg_shareBits = [];
NUTOOL_PIN.g_cfg_addGPIO = {};
NUTOOL_PIN.g_cfg_unusedGPIO = {};

NUTOOL_PIN.decidepackageNumber = function (given_partNumber_package) {
	var partNumber_package,
		partNumber;

	if (typeof given_partNumber_package === 'undefined') {
		partNumber_package = NUTOOL_PIN.getg_partNumber_package();
	}
	else {
		partNumber_package = given_partNumber_package;
	}

	NUTOOL_PIN.g_packageNumber = partNumber_package.substring(partNumber_package.indexOf('(') + 1);
	NUTOOL_PIN.g_packageNumber = NUTOOL_PIN.g_packageNumber.substring(0, NUTOOL_PIN.g_packageNumber.indexOf(')'));

	partNumber = partNumber_package.substring(0, partNumber_package.indexOf('('));
	switch (NUTOOL_PIN.g_packageNumber) {
	case 'LQFP128':
	default:
		NUTOOL_PIN.g_packageNumberIndex = "LQFP128(USB1.1)";
		break;
	}
	partNumber_package = null;
	partNumber = null;
};
