// chip content
NUTOOL_PIN.g_cfg_chips = [
	//NANO100AN
	{ name: "NANO100ZC2AN", pkg: "QFN33" },
	{ name: "NANO100ZD2AN", pkg: "QFN33" },
	{ name: "NANO100ZD3AN", pkg: "QFN33" },
	{ name: "NANO100LC2AN", pkg: "LQFP48" },
	{ name: "NANO100LD2AN", pkg: "LQFP48" },
	{ name: "NANO100LD3AN", pkg: "LQFP48" },
	{ name: "NANO100SC2AN", pkg: "LQFP64" },
	{ name: "NANO100SD2AN", pkg: "LQFP64" },
	{ name: "NANO100SD3AN", pkg: "LQFP64" },
	{ name: "NANO100VD2AN", pkg: "LQFP100" },
	{ name: "NANO100VD3AN", pkg: "LQFP100" },

	{ name: "NANO120ZC2AN", pkg: "QFN33" },
	{ name: "NANO120ZD2AN", pkg: "QFN33" },
	{ name: "NANO120ZD3AN", pkg: "QFN33" },
	{ name: "NANO120LC2AN", pkg: "LQFP48" },
	{ name: "NANO120LD2AN", pkg: "LQFP48" },
	{ name: "NANO120LD3AN", pkg: "LQFP48" },
	{ name: "NANO120SC2AN", pkg: "LQFP64" },
	{ name: "NANO120SD2AN", pkg: "LQFP64" },
	{ name: "NANO120SD3AN", pkg: "LQFP64" },
	{ name: "NANO120VD2AN", pkg: "LQFP100" },
	{ name: "NANO120VD3AN", pkg: "LQFP100" },
	//NANO100BN
	{ name: "NANO100NC2BN", pkg: "QFN48" },
	{ name: "NANO100ND2BN", pkg: "QFN48" },
	{ name: "NANO100ND3BN", pkg: "QFN48" },
	{ name: "NANO100NE3BN", pkg: "QFN48" },
	{ name: "NANO100LC2BN", pkg: "LQFP48" },
	{ name: "NANO100LD2BN", pkg: "LQFP48" },
	{ name: "NANO100LD3BN", pkg: "LQFP48" },
	{ name: "NANO100LE3BN", pkg: "LQFP48" },
	{ name: "NANO100SC2BN", pkg: "LQFP64" },
	{ name: "NANO100SD2BN", pkg: "LQFP64" },
	{ name: "NANO100SD3BN", pkg: "LQFP64" },
	{ name: "NANO100SE3BN", pkg: "LQFP64" },
	{ name: "NANO100KD3BN", pkg: "LQFP128" },
	//{ name: "NANO100KC2BN", pkg: "LQFP128" },
	//{ name: "NANO100KD2BN", pkg: "LQFP128" },
	//{ name: "NANO100KC3BN", pkg: "LQFP128" },
	{ name: "NANO100KE3BN", pkg: "LQFP128" },

	{ name: "NANO110SC2BN", pkg: "LQFP64" },
	{ name: "NANO110SD2BN", pkg: "LQFP64" },
	{ name: "NANO110SD3BN", pkg: "LQFP64" },
	{ name: "NANO110SE3BN", pkg: "LQFP64" },
	{ name: "NANO110RC2BN", pkg: "LQFP64" },
	{ name: "NANO110RD2BN", pkg: "LQFP64" },
	{ name: "NANO110RD3BN", pkg: "LQFP64" },
	{ name: "NANO110RE3BN", pkg: "LQFP64" },
	{ name: "NANO110KC2BN", pkg: "LQFP128" },
	{ name: "NANO110KD2BN", pkg: "LQFP128" },
	{ name: "NANO110KD3BN", pkg: "LQFP128" },
	{ name: "NANO110KE3BN", pkg: "LQFP128" },

	{ name: "NANO120LC2BN", pkg: "LQFP48" },
	{ name: "NANO120LD2BN", pkg: "LQFP48" },
	{ name: "NANO120LD3BN", pkg: "LQFP48" },
	{ name: "NANO120LE3BN", pkg: "LQFP48" },
	{ name: "NANO120SC2BN", pkg: "LQFP64" },
	{ name: "NANO120SD2BN", pkg: "LQFP64" },
	{ name: "NANO120SD3BN", pkg: "LQFP64" },
	{ name: "NANO120SE3BN", pkg: "LQFP64" },
	//{ name: "NANO120KC2BN", pkg: "LQFP128" },
	//{ name: "NANO120KD2BN", pkg: "LQFP128" },
	{ name: "NANO120KD3BN", pkg: "LQFP128" },
	{ name: "NANO120KE3BN", pkg: "LQFP128" },

	{ name: "NANO130SC2BN", pkg: "LQFP64" },
	{ name: "NANO130SD2BN", pkg: "LQFP64" },
	{ name: "NANO130SD3BN", pkg: "LQFP64" },
	{ name: "NANO130SE3BN", pkg: "LQFP64" },
	{ name: "NANO130KC2BN", pkg: "LQFP128" },
	{ name: "NANO130KD2BN", pkg: "LQFP128" },
	{ name: "NANO130KD3BN", pkg: "LQFP128" },
	{ name: "NANO130KE3BN", pkg: "LQFP128" },
	//NANO103
	{ name: "NANO103SD3AE", pkg: "LQFP64" },
	{ name: "NANO103LD3AE", pkg: "LQFP48" },
	{ name: "NANO103ZD3AE", pkg: "QFN33" },
	//NANO112
	{ name: "NANO112VC2AN", pkg: "LQFP100" },
	{ name: "NANO112RC2AN", pkg: "LQFP64" },
	{ name: "NANO112RB1AN", pkg: "LQFP64" },
	{ name: "NANO112SC2AN", pkg: "LQFP64" },
	{ name: "NANO112SB1AN", pkg: "LQFP64" },
	{ name: "NANO102SC2AN", pkg: "LQFP64" },
	{ name: "NANO112LC2AN", pkg: "LQFP48" },
	{ name: "NANO112LB1AN", pkg: "LQFP48" },
	{ name: "NANO102LC2AN", pkg: "LQFP48" },
	{ name: "NANO102LB1AN", pkg: "LQFP48" },
	{ name: "NANO102ZB1AN", pkg: "QFN33" },
	{ name: "NANO102ZC2AN", pkg: "QFN33" }
];

NUTOOL_PIN.g_cfg_pkgs = {
	"LQFP128(NANO130)": [
		'PE.13', 'PB.14', 'PB.13', 'PB.12', 'NC', 'X32_OUT', 'X32_IN', 'NC', 'PA.11', 'PA.10',
		'PA.9', 'PA.8', 'PD.8', 'PD.9', 'PD.10', 'PD.11', 'PD.12', 'PD.13', 'PB.4', 'PB.5',
		'PB.6', 'PB.7', 'NC', 'LDO_CAP', 'NC', 'NC', 'VDD', 'NC', 'VSS', 'VSS',
		'VSS', 'VSS',
		'PE.12', 'PE.11', 'PE.10', 'PE.9', 'PE.8', 'PE.7', 'NC', 'USB_VBUS', 'USB_VDD33_CAP', 'USB_D-',
		'USB_D+', 'PB.0', 'PB.1', 'PB.2', 'PB.3', 'PD.6', 'PD.7', 'PD.14', 'PD.15', 'PC.5',
		'PC.4', 'PC.3', 'PC.2', 'PC.1', 'PC.0', 'PE.6', 'LCD_VLCD', 'NC', 'PE.5', 'PB.11',
		'PB.10', 'PB.9',
		'PE.4', 'PE.3', 'PE.2', 'PE.1', 'PE.0', 'PC.13', 'PC.12', 'PC.11', 'PC.10', 'PC.9',
		'PC.8', 'PA.15', 'PA.14', 'PA.13', 'PA.12', 'PF.0', 'PF.1', 'NC', 'VDD', 'NC',
		'VSS', 'VSS', 'AVSS', 'AVSS', 'PA.0', 'PA.1', 'PA.2', 'PA.3', 'PA.4', 'PA.5',
		'PA.6', 'PA.7',
		'VREF', 'NC', 'AVDD', 'PD.0', 'PD.1', 'PD.2', 'PD.3', 'NC', 'PD.4', 'PD.5',
		'PC.7', 'PC.6', 'PC.15', 'PC.14', 'PB.15', 'NC', 'PF.3', 'PF.2', 'NC', 'nRESET',
		'VSS', 'VSS', 'NC', 'VDD', 'NC', 'PF.4', 'PF.5', 'VSS', 'PVSS', 'PB.8',
		'PE.15', 'PE.14'
	],
	"LQFP64(NANO130)": [
		'PB.14', 'PB.13', 'PB.12', 'X32_OUT', 'X32_IN', 'PA.11', 'PA.10', 'PA.9', 'PA.8', 'PB.4',
		'PB.5', 'PB.6', 'PB.7', 'LDO_CAP', 'VDD', 'VSS',
		'USB_VBUS', 'USB_VDD33_CAP', 'USB_D-', 'USB_D+', 'PB.0', 'PB.1', 'PB.2', 'PB.3', 'PC.3', 'PC.2',
		'PC.1', 'PC.0', 'LCD_VLCD', 'PB.11', 'PB.10', 'PB.9',
		'PC.11', 'PC.10', 'PC.9', 'PC.8', 'PA.15', 'PA.14', 'PA.13', 'PA.12', 'PF.0', 'PF.1',
		'AVSS', 'PA.0', 'PA.1', 'PA.2', 'PA.3', 'PA.4',
		'PA.5', 'PA.6', 'VREF', 'AVDD', 'PC.7', 'PC.6', 'PC.15', 'PC.14', 'PB.15', 'PF.3',
		'PF.2', 'nRESET', 'VSS', 'VDD', 'PVSS', 'PB.8'
	],
	"LQFP128(NANO120)": [
		'PE.13', 'PB.14', 'PB.13', 'PB.12', 'NC', 'X32_OUT', 'X32_IN', 'NC', 'PA.11', 'PA.10',
		'PA.9', 'PA.8', 'PD.8', 'PD.9', 'PD.10', 'PD.11', 'PD.12', 'PD.13', 'PB.4', 'PB.5',
		'PB.6', 'PB.7', 'NC', 'LDO_CAP', 'NC', 'NC', 'VDD', 'NC', 'VSS', 'VSS',
		'VSS', 'VSS',
		'PE.12', 'PE.11', 'PE.10', 'PE.9', 'PE.8', 'PE.7', 'NC', 'USB_VBUS', 'USB_VDD33_CAP', 'USB_D-',
		'USB_D+', 'PB.0', 'PB.1', 'PB.2', 'PB.3', 'PD.6', 'PD.7', 'PD.14', 'PD.15', 'PC.5',
		'PC.4', 'PC.3', 'PC.2', 'PC.1', 'PC.0', 'PE.6', 'NC', 'NC', 'PE.5', 'PB.11',
		'PB.10', 'PB.9',
		'PE.4', 'PE.3', 'PE.2', 'PE.1', 'PE.0', 'PC.13', 'PC.12', 'PC.11', 'PC.10', 'PC.9',
		'PC.8', 'PA.15', 'PA.14', 'PA.13', 'PA.12', 'PF.0', 'PF.1', 'NC', 'VDD', 'NC',
		'VSS', 'VSS', 'AVSS', 'AVSS', 'PA.0', 'PA.1', 'PA.2', 'PA.3', 'PA.4', 'PA.5',
		'PA.6', 'PA.7',
		'VREF', 'NC', 'AVDD', 'PD.0', 'PD.1', 'PD.2', 'PD.3', 'NC', 'PD.4', 'PD.5',
		'PC.7', 'PC.6', 'PC.15', 'PC.14', 'PB.15', 'NC', 'PF.3', 'PF.2', 'NC', 'nRESET',
		'VSS', 'VSS', 'NC', 'VDD', 'NC', 'PF.4', 'PF.5', 'VSS', 'PVSS', 'PB.8',
		'PE.15', 'PE.14'
	],
	"LQFP64(NANO120)": [
		'PB.14', 'PB.13', 'PB.12', 'X32_OUT', 'X32_IN', 'PA.11', 'PA.10', 'PA.9', 'PA.8', 'PB.4',
		'PB.5', 'PB.6', 'PB.7', 'LDO_CAP', 'VDD', 'VSS',
		'USB_VBUS', 'USB_VDD33_CAP', 'USB_D-', 'USB_D+', 'PB.0', 'PB.1', 'PB.2', 'PB.3', 'PC.3', 'PC.2',
		'PC.1', 'PC.0', 'PE.5', 'PB.11', 'PB.10', 'PB.9',
		'PC.11', 'PC.10', 'PC.9', 'PC.8', 'PA.15', 'PA.14', 'PA.13', 'PA.12', 'PF.0', 'PF.1',
		'AVSS', 'PA.0', 'PA.1', 'PA.2', 'PA.3', 'PA.4',
		'PA.5', 'PA.6', 'VREF', 'AVDD', 'PC.7', 'PC.6', 'PC.15', 'PC.14', 'PB.15', 'PF.3',
		'PF.2', 'nRESET', 'VSS', 'VDD', 'PVSS', 'PB.8'
	],
	"LQFP48(NANO120)": [
		'PB.12', 'X32_OUT', 'X32_IN', 'PA.11', 'PA.10', 'PA.9', 'PA.8', 'PB.4', 'PB.5', 'LDO_CAP',
		'VDD', 'VSS',
		'USB_VBUS', 'USB_VDD33_CAP', 'USB_D-', 'USB_D+', 'PB.0', 'PB.1', 'PB.2', 'PB.3', 'PC.3', 'PC.2',
		'PC.1', 'PC.0',
		'PA.15', 'PA.14', 'PA.13', 'PA.12', 'PF.0', 'PF.1', 'AVSS', 'PA.0', 'PA.1', 'PA.2',
		'PA.3', 'PA.4',
		'PA.5', 'PA.6', 'VREF', 'AVDD', 'PC.7', 'PC.6', 'PB.15', 'PF.3', 'PF.2', 'nRESET',
		'PVSS', 'PB.8'
	],
	"LQFP128(NANO110)": [
		'PE.13', 'PB.14', 'PB.13', 'PB.12', 'NC', 'X32_OUT', 'X32_IN', 'NC', 'PA.11', 'PA.10',
		'PA.9', 'PA.8', 'PD.8', 'PD.9', 'PD.10', 'PD.11', 'PD.12', 'PD.13', 'PB.4', 'PB.5',
		'PB.6', 'PB.7', 'NC', 'LDO_CAP', 'NC', 'NC', 'VDD', 'NC', 'VSS', 'VSS',
		'VSS', 'VSS',
		'PE.12', 'PE.11', 'PE.10', 'PE.9', 'PE.8', 'PE.7', 'NC', 'NC', 'NC', 'NC',
		'NC', 'PB.0', 'PB.1', 'PB.2', 'PB.3', 'PD.6', 'PD.7', 'PD.14', 'PD.15', 'PC.5',
		'PC.4', 'PC.3', 'PC.2', 'PC.1', 'PC.0', 'PE.6', 'LCD_VLCD', 'NC', 'PE.5', 'PB.11',
		'PB.10', 'PB.9',
		'PE.4', 'PE.3', 'PE.2', 'PE.1', 'PE.0', 'PC.13', 'PC.12', 'PC.11', 'PC.10', 'PC.9',
		'PC.8', 'PA.15', 'PA.14', 'PA.13', 'PA.12', 'PF.0', 'PF.1', 'NC', 'VDD', 'NC',
		'VSS', 'VSS', 'AVSS', 'AVSS', 'PA.0', 'PA.1', 'PA.2', 'PA.3', 'PA.4', 'PA.5',
		'PA.6', 'PA.7',
		'VREF', 'NC', 'AVDD', 'PD.0', 'PD.1', 'PD.2', 'PD.3', 'NC', 'PD.4', 'PD.5',
		'PC.7', 'PC.6', 'PC.15', 'PC.14', 'PB.15', 'NC', 'PF.3', 'PF.2', 'NC', 'nRESET',
		'VSS', 'VSS', 'NC', 'VDD', 'NC', 'PF.4', 'PF.5', 'VSS', 'PVSS', 'PB.8',
		'PE.15', 'PE.14'
	],
	"LQFP64(NANO110)": [
		'PB.14', 'PB.13', 'PB.12', 'X32_OUT', 'X32_IN', 'PA.11', 'PA.10', 'PA.9', 'PA.8', 'PB.4',
		'PB.5', 'PB.6', 'PB.7', 'LDO_CAP', 'VDD', 'VSS',
		'PB.0', 'PB.1', 'PB.2', 'PB.3', 'PD.6', 'PD.7', 'PD.14', 'PD.15', 'PC.3', 'PC.2',
		'PC.1', 'PC.0', 'LCD_VLCD', 'PB.11', 'PB.10', 'PB.9',
		'PC.11', 'PC.10', 'PC.9', 'PC.8', 'PA.15', 'PA.14', 'PA.13', 'PA.12', 'PF.0', 'PF.1',
		'AVSS', 'PA.0', 'PA.1', 'PA.2', 'PA.3', 'PA.4',
		'PA.5', 'PA.6', 'VREF', 'AVDD', 'PC.7', 'PC.6', 'PC.15', 'PC.14', 'PB.15', 'PF.3',
		'PF.2', 'nRESET', 'VSS', 'VDD', 'PVSS', 'PB.8'
	],
	"LQFP128(NANO100)": [
		'PE.13', 'PB.14', 'PB.13', 'PB.12', 'NC', 'X32_OUT', 'X32_IN', 'NC', 'PA.11', 'PA.10',
		'PA.9', 'PA.8', 'PD.8', 'PD.9', 'PD.10', 'PD.11', 'PD.12', 'PD.13', 'PB.4', 'PB.5',
		'PB.6', 'PB.7', 'NC', 'LDO_CAP', 'NC', 'NC', 'VDD', 'NC', 'VSS', 'VSS',
		'VSS', 'VSS',
		'PE.12', 'PE.11', 'PE.10', 'PE.9', 'PE.8', 'PE.7', 'NC', 'NC', 'NC', 'NC',
		'NC', 'PB.0', 'PB.1', 'PB.2', 'PB.3', 'PD.6', 'PD.7', 'PD.14', 'PD.15', 'PC.5',
		'PC.4', 'PC.3', 'PC.2', 'PC.1', 'PC.0', 'PE.6', 'NC', 'NC', 'PE.5', 'PB.11',
		'PB.10', 'PB.9',
		'PE.4', 'PE.3', 'PE.2', 'PE.1', 'PE.0', 'PC.13', 'PC.12', 'PC.11', 'PC.10', 'PC.9',
		'PC.8', 'PA.15', 'PA.14', 'PA.13', 'PA.12', 'PF.0', 'PF.1', 'NC', 'VDD', 'NC',
		'VSS', 'VSS', 'AVSS', 'AVSS', 'PA.0', 'PA.1', 'PA.2', 'PA.3', 'PA.4', 'PA.5',
		'PA.6', 'PA.7',
		'VREF', 'NC', 'AVDD', 'PD.0', 'PD.1', 'PD.2', 'PD.3', 'NC', 'PD.4', 'PD.5',
		'PC.7', 'PC.6', 'PC.15', 'PC.14', 'PB.15', 'NC', 'PF.3', 'PF.2', 'NC', 'nRESET',
		'VSS', 'VSS', 'NC', 'VDD', 'NC', 'PF.4', 'PF.5', 'VSS', 'PVSS', 'PB.8',
		'PE.15', 'PE.14'
	],
	"LQFP64(NANO100)": [
		'PB.14', 'PB.13', 'PB.12', 'X32_OUT', 'X32_IN', 'PA.11', 'PA.10', 'PA.9', 'PA.8', 'PB.4',
		'PB.5', 'PB.6', 'PB.7', 'LDO_CAP', 'VDD', 'VSS',
		'PB.0', 'PB.1', 'PB.2', 'PB.3', 'PD.6', 'PD.7', 'PD.14', 'PD.15', 'PC.3', 'PC.2',
		'PC.1', 'PC.0', 'PE.5', 'PB.11', 'PB.10', 'PB.9',
		'PC.11', 'PC.10', 'PC.9', 'PC.8', 'PA.15', 'PA.14', 'PA.13', 'PA.12', 'PF.0', 'PF.1',
		'AVSS', 'PA.0', 'PA.1', 'PA.2', 'PA.3', 'PA.4',
		'PA.5', 'PA.6', 'VREF', 'AVDD', 'PC.7', 'PC.6', 'PC.15', 'PC.14', 'PB.15', 'PF.3',
		'PF.2', 'nRESET', 'VSS', 'VDD', 'PVSS', 'PB.8'
	],
	"LQFP48(NANO100)": [
		'PB.12', 'X32_OUT', 'X32_IN', 'PA.11', 'PA.10', 'PA.9', 'PA.8', 'PB.4', 'PB.5', 'LDO_CAP',
		'VDD', 'VSS',
		'PB.0', 'PB.1', 'PB.2', 'PB.3', 'PC.3', 'PC.2', 'PC.1', 'PC.0', 'PE.5', 'PB.11',
		'PB.10', 'PB.9',
		'PA.15', 'PA.14', 'PA.13', 'PA.12', 'PF.0', 'PF.1', 'AVSS', 'PA.0', 'PA.1', 'PA.2',
		'PA.3', 'PA.4',
		'PA.5', 'PA.6', 'VREF', 'AVDD', 'PC.7', 'PC.6', 'PB.15', 'PF.3', 'PF.2', 'nRESET',
		'PVSS', 'PB.8'
	],
	"QFN48(NANO100)": [
		'PB.12', 'X32_OUT', 'X32_IN', 'PA.11', 'PA.10', 'PA.9', 'PA.8', 'PB.4', 'PB.5', 'LDO_CAP',
		'VDD', 'VSS',
		'PB.0', 'PB.1', 'PB.2', 'PB.3', 'PC.3', 'PC.2', 'PC.1', 'PC.0', 'PE.5', 'PB.11',
		'PB.10', 'PB.9',
		'PA.15', 'PA.14', 'PA.13', 'PA.12', 'PF.0', 'PF.1', 'AVSS', 'PA.0', 'PA.1', 'PA.2',
		'PA.3', 'PA.4',
		'PA.5', 'PA.6', 'VREF', 'AVDD', 'PC.7', 'PC.6', 'PB.15', 'PF.3', 'PF.2', 'nRESET',
		'PVSS', 'PB.8'
	]
};

NUTOOL_PIN.g_cfg_gpios = [
	{ f: ['PA.0:0', 'AD0:1', 'SC2_CD:4'] },
	{ f: ['PA.1:0', 'AD1:1', 'EBI_AD12:2'] },
	{ f: ['PA.2:0', 'AD2:1', 'EBI_AD11:2', 'UART1_RXD:5'] },
	{ f: ['PA.3:0', 'AD3:1', 'EBI_AD10:2', 'UART1_TXD:5'] },
	{ f: ['PA.4:0', 'AD4:1', 'EBI_AD9:2', 'SC2_PWR:4', 'I2C0_SDA:5'] },
	{ f: ['PA.5:0', 'AD5:1', 'EBI_AD8:2', 'SC2_RST:4', 'I2C0_SCL:5'] },
	{ f: ['PA.6:0', 'AD6:1', 'EBI_AD7:2', 'TC3:3', 'SC2_CLK:4', 'PWM0_CH3:5'] },
	{ f: ['PA.7:0', 'AD7:1', 'EBI_AD6:2', 'TC2:3', 'SC2_DAT:4', 'PWM0_CH2:5'] },
	{ f: ['PA.8:0', 'I2C0_SDA:1', 'SC0_CLK:3', 'SPI2_SS0:4'] },
	{ f: ['PA.9:0', 'I2C0_SCL:1', 'SC0_DAT:3', 'SPI2_CLK:4'] },
	{ f: ['PA.10:0', 'I2C1_SDA:1', 'EBI_nWR:2', 'SC0_PWR:3', 'SPI2_MISO0:4'] },
	{ f: ['PA.11:0', 'I2C1_SCL:1', 'EBI_nRD:2', 'SC0_RST:3', 'SPI2_MOSI0:4'] },
	{ f: ['PA.12:0', 'PWM0_CH0:1', 'EBI_AD13:2', 'TC0:3', 'I2C0_SDA:5'] },
	{ f: ['PA.13:0', 'PWM0_CH1:1', 'EBI_AD14:2', 'TC1:3', 'I2C0_SCL:5'] },
	{ f: ['PA.14:0', 'PWM0_CH2:1', 'EBI_AD15:2', 'TC2:3', 'UART0_RXD:6'] },
	{ f: ['PA.15:0', 'PWM0_CH3:1', 'I2S_MCLK:2', 'TC3:3', 'SC0_PWR:4', 'UART0_TXD:6'] },

	{ f: ['PB.0:0', 'UART0_RXD:1', 'SPI1_MOSI0:3'] },
	{ f: ['PB.1:0', 'UART0_TXD:1', 'SPI1_MISO0:3'] },
	{ f: ['PB.2:0', 'UART0_RTSn:1', 'EBI_nWRL:2', 'SPI1_CLK:3'] },
	{ f: ['PB.3:0', 'UART0_CTSn:1', 'EBI_nWRH:2', 'SPI1_SS0:3'] },
	{ f: ['PB.4:0', 'UART1_RXD:1', 'SC0_CD:3', 'SPI2_SS0:4'] },
	{ f: ['PB.5:0', 'UART1_TXD:1', 'SC0_RST:3', 'SPI2_CLK:4'] },
	{ f: ['PB.6:0', 'UART1_RTSn:1', 'EBI_ALE:2', 'SPI2_MISO0:4'] },
	{ f: ['PB.7:0', 'UART1_CTSn:1', 'EBI_nCS:2', 'SPI2_MOSI0:4'] },
	{ f: ['PB.8:0', 'STADC:1', 'TM0:2', 'INT0:3', 'SC2_PWR:4'] },
	{ f: ['PB.9:0', 'SPI1_SS1:1', 'TM1:2', 'SC2_RST:4', 'INT0:5'] },
	{ f: ['PB.10:0', 'SPI0_SS1:1', 'TM2:2', 'SC2_CLK:4', 'SPI0_MOSI0:5'] },
	{ f: ['PB.11:0', 'PWM1_CH0:1', 'TM3:2', 'SC2_DAT:4', 'SPI0_MISO0:5'] },
	{ f: ['PB.12:0', 'EBI_AD0:2', 'FCLKO:4'] },
	{ f: ['PB.13:0', 'EBI_AD1:2'] },
	{ f: ['PB.14:0', 'INT0:1', 'SC2_CD:3', 'SPI2_SS1:4'] },
	{ f: ['PB.15:0', 'INT1:1', 'SNOOPER:3', 'SC1_CD:4'] },

	{ f: ['PC.0:0', 'SPI0_SS0:1', 'I2S_LRCLK:2', 'SC1_CLK:4'] },
	{ f: ['PC.1:0', 'SPI0_CLK:1', 'I2S_BCLK:2', 'SC1_DAT:4'] },
	{ f: ['PC.2:0', 'SPI0_MISO0:1', 'I2S_DI:2', 'SC1_PWR:4'] },
	{ f: ['PC.3:0', 'SPI0_MOSI0:1', 'I2S_DO:2', 'SC1_RST:4'] },
	{ f: ['PC.4:0', 'SPI0_MISO1:1'] },
	{ f: ['PC.5:0', 'SPI0_MOSI1:1'] },
	{ f: ['PC.6:0', 'DA0_OUT:1', 'EBI_AD4:2', 'TC0:3', 'SC1_CD:4', 'PWM0_CH0:5'] },
	{ f: ['PC.7:0', 'DA1_OUT:1', 'EBI_AD5:2', 'TC1:3', 'PWM0_CH1:5'] },
	{ f: ['PC.8:0', 'SPI1_SS0:1', 'EBI_MCLK:2', 'I2C1_SDA:5'] },
	{ f: ['PC.9:0', 'SPI1_CLK:1', 'I2C1_SCL:5'] },
	{ f: ['PC.10:0', 'SPI1_MISO0:1', 'UART1_RXD:5'] },
	{ f: ['PC.11:0', 'SPI1_MOSI0:1', 'UART1_TXD:5'] },
	{ f: ['PC.12:0', 'SPI1_MISO1:1', 'PWM1_CH0:2', 'INT0:5', 'I2C0_SDA:6'] },
	{ f: ['PC.13:0', 'SPI1_MOSI1:1', 'PWM1_CH1:2', 'SNOOPER:4', 'INT1:5', 'I2C0_SCL:6'] },
	{ f: ['PC.14:0', 'EBI_AD2:2', 'PWM1_CH3:4'] },
	{ f: ['PC.15:0', 'EBI_AD3:2', 'TC0:3', 'PWM1_CH2:4'] },

	{ f: ['PD.0:0', 'UART1_RXD:1', 'SPI2_SS0:3', 'SC1_CLK:4', 'AD8:5'] },
	{ f: ['PD.1:0', 'UART1_TXD:1', 'SPI2_CLK:3', 'SC1_DAT:4', 'AD9:5'] },
	{ f: ['PD.2:0', 'UART1_RTSn:1', 'I2S_LRCLK:2', 'SPI2_MISO0:3', 'SC1_PWR:4', 'AD10:5'] },
	{ f: ['PD.3:0', 'UART1_CTSn:1', 'I2S_BCLK:2', 'SPI2_MOSI0:3', 'SC1_RST:4', 'AD11:5'] },
	{ f: ['PD.4:0', 'I2S_DI:2', 'SPI2_MISO1:3', 'SC1_CD:4'] },
	{ f: ['PD.5:0', 'I2S_DO:2', 'SPI2_MOSI1:3'] },
	{ f: ['PD.6:0'] },
	{ f: ['PD.7:0'] },
	{ f: ['PD.8:0'] },
	{ f: ['PD.9:0'] },
	{ f: ['PD.10:0'] },
	{ f: ['PD.11:0'] },
	{ f: ['PD.12:0'] },
	{ f: ['PD.13:0'] },
	{ f: ['PD.14:0'] },
	{ f: ['PD.15:0'] },

	{ f: ['PE.0:0', 'PWM1_CH2:1', 'I2S_MCLK:2'] },
	{ f: ['PE.1:0', 'PWM1_CH3:1', 'SPI0_SS0:6'] },
	{ f: ['PE.2:0', 'SPI0_CLK:6'] },
	{ f: ['PE.3:0', 'SPI0_MISO0:6'] },
	{ f: ['PE.4:0', 'SPI0_MOSI0:6'] },
	{ f: ['PE.5:0', 'PWM1_CH1:1'] },
	{ f: ['PE.6:0'] },
	{ f: ['PE.7:0'] },
	{ f: ['PE.8:0'] },
	{ f: ['PE.9:0'] },
	{ f: ['PE.10:0'] },
	{ f: ['PE.11:0'] },
	{ f: ['PE.12:0'] },
	{ f: ['PE.13:0'] },
	{ f: ['PE.14:0'] },
	{ f: ['PE.15:0'] },

	{ f: ['PF.0:0', 'INT0:5', 'ICE_DAT:7'] },
	{ f: ['PF.1:0', 'FCLKO:4', 'INT1:5', 'ICE_CLK:7'] },
	{ f: ['PF.2:0', 'XT1_OUT:7'] },
	{ f: ['PF.3:0', 'XT1_IN:7'] },
	{ f: ['PF.4:0', 'I2C0_SDA:1'] },
	{ f: ['PF.5:0', 'I2C0_SCL:1'] }
];

NUTOOL_PIN.g_cfg_gpiosDefines = [
	{ f: ['PA.0', 'AD0:SYS_PA_L_MFP_PA0_MFP_ADC_CH0@PA_L_MFP', 'SC2_CD:SYS_PA_L_MFP_PA0_MFP_SC2_CD@PA_L_MFP'] },
	{ f: ['PA.1', 'AD1:SYS_PA_L_MFP_PA1_MFP_ADC_CH1@PA_L_MFP', 'EBI_AD12:SYS_PA_L_MFP_PA1_MFP_EBI_AD12@PA_L_MFP'] },
	{ f: ['PA.2', 'AD2:SYS_PA_L_MFP_PA2_MFP_ADC_CH2@PA_L_MFP', 'EBI_AD11:SYS_PA_L_MFP_PA2_MFP_EBI_AD11@PA_L_MFP', 'UART1_RXD:SYS_PA_L_MFP_PA2_MFP_UART1_RX@PA_L_MFP', 'LCD_SEG23:SYS_PA_L_MFP_PA2_MFP_LCD_S23@PA_L_MFP'] },
	{ f: ['PA.3', 'AD3:SYS_PA_L_MFP_PA3_MFP_ADC_CH3@PA_L_MFP', 'EBI_AD10:SYS_PA_L_MFP_PA3_MFP_EBI_AD10@PA_L_MFP', 'UART1_TXD:SYS_PA_L_MFP_PA3_MFP_UART1_TX@PA_L_MFP', 'LCD_SEG22:SYS_PA_L_MFP_PA3_MFP_LCD_S22@PA_L_MFP'] },
	{ f: ['PA.4', 'AD4:SYS_PA_L_MFP_PA4_MFP_ADC_CH4@PA_L_MFP', 'EBI_AD9:SYS_PA_L_MFP_PA4_MFP_EBI_AD9@PA_L_MFP', 'SC2_PWR:SYS_PA_L_MFP_PA4_MFP_SC2_PWR@PA_L_MFP', 'I2C0_SDA:SYS_PA_L_MFP_PA4_MFP_I2C0_SDA@PA_L_MFP', 'LCD_SEG39:SYS_PA_L_MFP_PA4_MFP_LCD_S39@PA_L_MFP', 'LCD_SEG21:SYS_PA_L_MFP_PA4_MFP_LCD_S21@PA_L_MFP'] },
	{ f: ['PA.5', 'AD5:SYS_PA_L_MFP_PA5_MFP_ADC_CH5@PA_L_MFP', 'EBI_AD8:SYS_PA_L_MFP_PA5_MFP_EBI_AD8@PA_L_MFP', 'SC2_RST:SYS_PA_L_MFP_PA5_MFP_SC2_RST@PA_L_MFP', 'I2C0_SCL:SYS_PA_L_MFP_PA5_MFP_I2C0_SCL@PA_L_MFP', 'LCD_SEG38:SYS_PA_L_MFP_PA5_MFP_LCD_S38@PA_L_MFP', 'LCD_SEG20:SYS_PA_L_MFP_PA5_MFP_LCD_S20@PA_L_MFP'] },
	{ f: ['PA.6', 'AD6:SYS_PA_L_MFP_PA6_MFP_ADC_CH6@PA_L_MFP', 'EBI_AD7:SYS_PA_L_MFP_PA6_MFP_EBI_AD7@PA_L_MFP', 'TC3:SYS_PA_L_MFP_PA6_MFP_TMR3_CAP@PA_L_MFP', 'SC2_CLK:SYS_PA_L_MFP_PA6_MFP_SC2_CLK@PA_L_MFP', 'PWM0_CH3:SYS_PA_L_MFP_PA6_MFP_PWM0_CH3@PA_L_MFP', 'LCD_SEG37:SYS_PA_L_MFP_PA6_MFP_LCD_S37@PA_L_MFP', 'LCD_SEG19:SYS_PA_L_MFP_PA6_MFP_LCD_S19@PA_L_MFP'] },
	{ f: ['PA.7', 'AD7:SYS_PA_L_MFP_PA7_MFP_ADC_CH7@PA_L_MFP', 'EBI_AD6:SYS_PA_L_MFP_PA7_MFP_EBI_AD6@PA_L_MFP', 'TC2:SYS_PA_L_MFP_PA7_MFP_TMR2_CAP@PA_L_MFP', 'SC2_DAT:SYS_PA_L_MFP_PA7_MFP_SC2_DAT@PA_L_MFP', 'PWM0_CH2:SYS_PA_L_MFP_PA7_MFP_PWM0_CH2@PA_L_MFP', 'LCD_SEG36:SYS_PA_L_MFP_PA7_MFP_LCD_S36@PA_L_MFP'] },
	{ f: ['PA.8', 'I2C0_SDA:SYS_PA_H_MFP_PA8_MFP_I2C0_SDA@PA_H_MFP', 'SC0_CLK:SYS_PA_H_MFP_PA8_MFP_SC0_CLK@PA_H_MFP', 'SPI2_SS0:SYS_PA_H_MFP_PA8_MFP_SPI2_SS0@PA_H_MFP', 'LCD_SEG20:SYS_PA_H_MFP_PA8_MFP_LCD_S20@PA_H_MFP', 'LCD_SEG6:SYS_PA_H_MFP_PA8_MFP_LCD_S6@PA_H_MFP'] },
	{ f: ['PA.9', 'I2C0_SCL:SYS_PA_H_MFP_PA9_MFP_I2C0_SCL@PA_H_MFP', 'SC0_DAT:SYS_PA_H_MFP_PA9_MFP_SC0_DAT@PA_H_MFP', 'SPI2_CLK:SYS_PA_H_MFP_PA9_MFP_SPI2_SCLK@PA_H_MFP', 'LCD_SEG21:SYS_PA_H_MFP_PA9_MFP_LCD_S21@PA_H_MFP', 'LCD_SEG7:SYS_PA_H_MFP_PA9_MFP_LCD_S7@PA_H_MFP'] },
	{ f: ['PA.10', 'I2C1_SDA:SYS_PA_H_MFP_PA10_MFP_I2C1_SDA@PA_H_MFP', 'EBI_nWR:SYS_PA_H_MFP_PA10_MFP_EBI_NWE@PA_H_MFP', 'SC0_PWR:SYS_PA_H_MFP_PA10_MFP_SC0_PWR@PA_H_MFP', 'SPI2_MISO0:SYS_PA_H_MFP_PA10_MFP_SPI2_MISO0@PA_H_MFP', 'LCD_SEG22:SYS_PA_H_MFP_PA10_MFP_LCD_S22@PA_H_MFP', 'LCD_SEG8:SYS_PA_H_MFP_PA10_MFP_LCD_S8@PA_H_MFP'] },
	{ f: ['PA.11', 'I2C1_SCL:SYS_PA_H_MFP_PA11_MFP_I2C1_SCL@PA_H_MFP', 'EBI_nRD:SYS_PA_H_MFP_PA11_MFP_EBI_NRE@PA_H_MFP', 'SC0_RST:SYS_PA_H_MFP_PA11_MFP_SC0_RST@PA_H_MFP', 'SPI2_MOSI0:SYS_PA_H_MFP_PA11_MFP_SPI2_MOSI0@PA_H_MFP', 'LCD_SEG23:SYS_PA_H_MFP_PA11_MFP_LCD_S23@PA_H_MFP', 'LCD_SEG9:SYS_PA_H_MFP_PA11_MFP_LCD_S9@PA_H_MFP'] },
	{ f: ['PA.12', 'PWM0_CH0:SYS_PA_H_MFP_PA12_MFP_PWM0_CH0@PA_H_MFP', 'EBI_AD13:SYS_PA_H_MFP_PA12_MFP_EBI_AD13@PA_H_MFP', 'TC0:SYS_PA_H_MFP_PA12_MFP_TMR0_CAP@PA_H_MFP', 'I2C0_SDA:SYS_PA_H_MFP_PA12_MFP_I2C0_SDA@PA_H_MFP', 'LCD_SEG24:SYS_PA_H_MFP_PA12_MFP_LCD_S24@PA_H_MFP'] },
	{ f: ['PA.13', 'PWM0_CH1:SYS_PA_H_MFP_PA13_MFP_PWM0_CH1@PA_H_MFP', 'EBI_AD14:SYS_PA_H_MFP_PA13_MFP_EBI_AD14@PA_H_MFP', 'TC1:SYS_PA_H_MFP_PA13_MFP_TMR1_CAP@PA_H_MFP', 'I2C0_SCL:SYS_PA_H_MFP_PA13_MFP_I2C0_SCL@PA_H_MFP', 'LCD_SEG25:SYS_PA_H_MFP_PA13_MFP_LCD_S25@PA_H_MFP'] },
	{ f: ['PA.14', 'PWM0_CH2:SYS_PA_H_MFP_PA14_MFP_PWM0_CH2@PA_H_MFP', 'EBI_AD15:SYS_PA_H_MFP_PA14_MFP_EBI_AD15@PA_H_MFP', 'TC2:SYS_PA_H_MFP_PA14_MFP_TMR2_CAP@PA_H_MFP', 'UART0_RXD:SYS_PA_H_MFP_PA14_MFP_UART0_RX@PA_H_MFP', 'LCD_SEG26:SYS_PA_H_MFP_PA14_MFP_LCD_S26@PA_H_MFP'] },
	{ f: ['PA.15', 'PWM0_CH3:SYS_PA_H_MFP_PA15_MFP_PWM0_CH3@PA_H_MFP', 'I2S_MCLK:SYS_PA_H_MFP_PA15_MFP_I2S_MCLK@PA_H_MFP', 'TC3:SYS_PA_H_MFP_PA15_MFP_TMR3_CAP@PA_H_MFP', 'SC0_PWR:SYS_PA_H_MFP_PA15_MFP_SC0_PWR@PA_H_MFP', 'UART0_TXD:SYS_PA_H_MFP_PA15_MFP_UART0_TX@PA_H_MFP', 'LCD_SEG27:SYS_PA_H_MFP_PA15_MFP_LCD_S27@PA_H_MFP'] },

	{ f: ['PB.0', 'UART0_RXD:SYS_PB_L_MFP_PB0_MFP_UART0_RX@PB_L_MFP', 'SPI1_MOSI0:SYS_PB_L_MFP_PB0_MFP_SPI1_MOSI0@PB_L_MFP', 'LCD_SEG7:SYS_PB_L_MFP_PB0_MFP_LCD_S7@PB_L_MFP', 'LCD_SEG1:SYS_PB_L_MFP_PB0_MFP_LCD_S1@PB_L_MFP'] },
	{ f: ['PB.1', 'UART0_TXD:SYS_PB_L_MFP_PB1_MFP_UART0_TX@PB_L_MFP', 'SPI1_MISO0:SYS_PB_L_MFP_PB1_MFP_SPI1_MISO0@PB_L_MFP', 'LCD_SEG6:SYS_PB_L_MFP_PB1_MFP_LCD_S6@PB_L_MFP', 'LCD_SEG0:SYS_PB_L_MFP_PB1_MFP_LCD_S0@PB_L_MFP'] },
	{ f: ['PB.2', 'UART0_RTSn:SYS_PB_L_MFP_PB2_MFP_UART0_RTS@PB_L_MFP', 'EBI_nWRL:SYS_PB_L_MFP_PB2_MFP_EBI_NWRL@PB_L_MFP', 'SPI1_CLK:SYS_PB_L_MFP_PB2_MFP_SPI1_SCLK@PB_L_MFP', 'LCD_SEG5:SYS_PB_L_MFP_PB2_MFP_LCD_S5@PB_L_MFP', 'LCD_COM3:SYS_PB_L_MFP_PB2_MFP_LCD_COM3@PB_L_MFP'] },
	{ f: ['PB.3', 'UART0_CTSn:SYS_PB_L_MFP_PB3_MFP_UART0_CTS@PB_L_MFP', 'EBI_nWRH:SYS_PB_L_MFP_PB3_MFP_EBI_NWRH@PB_L_MFP', 'SPI1_SS0:SYS_PB_L_MFP_PB3_MFP_SPI1_SS0@PB_L_MFP', 'LCD_SEG4:SYS_PB_L_MFP_PB3_MFP_LCD_S4@PB_L_MFP', 'LCD_COM2:SYS_PB_L_MFP_PB3_MFP_LCD_COM2@PB_L_MFP'] },
	{ f: ['PB.4', 'UART1_RXD:SYS_PB_L_MFP_PB4_MFP_UART1_RX@PB_L_MFP', 'SC0_CD:SYS_PB_L_MFP_PB4_MFP_SC0_CD@PB_L_MFP', 'SPI2_SS0:SYS_PB_L_MFP_PB4_MFP_SPI2_SS0@PB_L_MFP', 'LCD_SEG13:SYS_PB_L_MFP_PB4_MFP_LCD_S13@PB_L_MFP', 'LCD_SEG5:SYS_PB_L_MFP_PB4_MFP_LCD_S5@PB_L_MFP'] },
	{ f: ['PB.5', 'UART1_TXD:SYS_PB_L_MFP_PB5_MFP_UART1_TX@PB_L_MFP', 'SC0_RST:SYS_PB_L_MFP_PB5_MFP_SC0_RST@PB_L_MFP', 'SPI2_CLK:SYS_PB_L_MFP_PB5_MFP_SPI2_SCLK@PB_L_MFP', 'LCD_SEG12:SYS_PB_L_MFP_PB5_MFP_LCD_S12@PB_L_MFP', 'LCD_SEG4:SYS_PB_L_MFP_PB5_MFP_LCD_S4@PB_L_MFP'] },
	{ f: ['PB.6', 'UART1_RTSn:SYS_PB_L_MFP_PB6_MFP_UART1_RTS@PB_L_MFP', 'EBI_ALE:SYS_PB_L_MFP_PB6_MFP_EBI_ALE@PB_L_MFP', 'SPI2_MISO0:SYS_PB_L_MFP_PB6_MFP_SPI2_MISO0@PB_L_MFP', 'LCD_SEG11:SYS_PB_L_MFP_PB6_MFP_LCD_S11@PB_L_MFP', 'LCD_SEG3:SYS_PB_L_MFP_PB6_MFP_LCD_S3@PB_L_MFP'] },
	{ f: ['PB.7', 'UART1_CTSn:SYS_PB_L_MFP_PB7_MFP_UART1_CTS@PB_L_MFP', 'EBI_nCS:SYS_PB_L_MFP_PB7_MFP_EBI_NCS@PB_L_MFP', 'SPI2_MOSI0:SYS_PB_L_MFP_PB7_MFP_SPI2_MOSI0@PB_L_MFP', 'LCD_SEG10:SYS_PB_L_MFP_PB7_MFP_LCD_S10@PB_L_MFP', 'LCD_SEG2:SYS_PB_L_MFP_PB7_MFP_LCD_S2@PB_L_MFP'] },
	{ f: ['PB.8', 'STADC:SYS_PB_H_MFP_PB8_MFP_ADC_EXT@PB_H_MFP', 'TM0:SYS_PB_H_MFP_PB8_MFP_TMR0_EXT@PB_H_MFP', 'TMR0_TOGGLE_OUT:SYS_PB_H_MFP_PB8_MFP_TMR0_TOGGLE_OUT@PB_H_MFP', 'INT0:SYS_PB_H_MFP_PB8_MFP_EXT_INT0@PB_H_MFP', 'SC2_PWR:SYS_PB_H_MFP_PB8_MFP_SC2_PWR@PB_H_MFP', 'LCD_SEG30:SYS_PB_H_MFP_PB8_MFP_LCD_S30@PB_H_MFP', 'LCD_SEG13:SYS_PB_H_MFP_PB8_MFP_LCD_S13@PB_H_MFP'] },
	{ f: ['PB.9', 'SPI1_SS1:SYS_PB_H_MFP_PB9_MFP_SPI1_SS1@PB_H_MFP', 'TM1:SYS_PB_H_MFP_PB9_MFP_TMR1_EXT@PB_H_MFP', 'TMR1_TOGGLE_OUT:SYS_PB_H_MFP_PB9_MFP_TMR1_TOGGLE_OUT@PB_H_MFP', 'SC2_RST:SYS_PB_H_MFP_PB9_MFP_SC2_RST@PB_H_MFP', 'INT0:SYS_PB_H_MFP_PB9_MFP_EXT_INT0@PB_H_MFP', 'LCD_V3:SYS_PB_H_MFP_PB9_MFP_LCD_V3@PB_H_MFP'] },
	{ f: ['PB.10', 'SPI0_SS1:SYS_PB_H_MFP_PB10_MFP_SPI0_SS1@PB_H_MFP', 'TM2:SYS_PB_H_MFP_PB10_MFP_TMR2_EXT@PB_H_MFP', 'TMR2_TOGGLE_OUT:SYS_PB_H_MFP_PB10_MFP_TMR2_TOGGLE_OUT@PB_H_MFP', 'SC2_CLK:SYS_PB_H_MFP_PB10_MFP_SC2_CLK@PB_H_MFP', 'SPI0_MOSI0:SYS_PB_H_MFP_PB10_MFP_SPI0_MOSI0@PB_H_MFP', 'LCD_V2:SYS_PB_H_MFP_PB10_MFP_LCD_V2@PB_H_MFP'] },
	{ f: ['PB.11', 'PWM1_CH0:SYS_PB_H_MFP_PB11_MFP_PWM1_CH0@PB_H_MFP', 'TM3:SYS_PB_H_MFP_PB11_MFP_TMR3_EXT@PB_H_MFP', 'TMR3_TOGGLE_OUT:SYS_PB_H_MFP_PB11_MFP_TMR3_TOGGLE_OUT@PB_H_MFP', 'SC2_DAT:SYS_PB_H_MFP_PB11_MFP_SC2_DAT@PB_H_MFP', 'SPI0_MISO0:SYS_PB_H_MFP_PB11_MFP_SPI0_MISO0@PB_H_MFP', 'LCD_V1:SYS_PB_H_MFP_PB11_MFP_LCD_V1@PB_H_MFP'] },
	{ f: ['PB.12', 'EBI_AD0:SYS_PB_H_MFP_PB12_MFP_EBI_AD0@PB_H_MFP', 'FCLKO:SYS_PB_H_MFP_PB12_MFP_CKO@PB_H_MFP', 'LCD_SEG24:SYS_PB_H_MFP_PB12_MFP_LCD_S24@PB_H_MFP', 'LCD_SEG10:SYS_PB_H_MFP_PB12_MFP_LCD_S10@PB_H_MFP'] },
	{ f: ['PB.13', 'EBI_AD1:SYS_PB_H_MFP_PB13_MFP_EBI_AD1@PB_H_MFP', 'LCD_SEG25:SYS_PB_H_MFP_PB13_MFP_LCD_S25@PB_H_MFP', 'LCD_SEG11:SYS_PB_H_MFP_PB13_MFP_LCD_S11@PB_H_MFP'] },
	{ f: ['PB.14', 'INT0:SYS_PB_H_MFP_PB14_MFP_EXT_INT0@PB_H_MFP', 'SC2_CD:SYS_PB_H_MFP_PB14_MFP_SC2_CD@PB_H_MFP', 'SPI2_SS1:SYS_PB_H_MFP_PB14_MFP_SPI2_SS1@PB_H_MFP', 'LCD_SEG26:SYS_PB_H_MFP_PB14_MFP_LCD_S26@PB_H_MFP', 'LCD_SEG12:SYS_PB_H_MFP_PB14_MFP_LCD_S12@PB_H_MFP'] },
	{ f: ['PB.15', 'INT1:SYS_PB_H_MFP_PB15_MFP_EXT_INT1@PB_H_MFP', 'SNOOPER:SYS_PB_H_MFP_PB15_MFP_SNOOPER@PB_H_MFP', 'SC1_CD:SYS_PB_H_MFP_PB15_MFP_SC1_CD@PB_H_MFP', 'LCD_SEG31:SYS_PB_H_MFP_PB15_MFP_LCD_S31@PB_H_MFP', 'LCD_SEG14:SYS_PB_H_MFP_PB15_MFP_LCD_S14@PB_H_MFP'] },

	{ f: ['PC.0', 'SPI0_SS0:SYS_PC_L_MFP_PC0_MFP_SPI0_SS0@PC_L_MFP', 'I2S_LRCLK:SYS_PC_L_MFP_PC0_MFP_I2S_WS@PC_L_MFP', 'SC1_CLK:SYS_PC_L_MFP_PC0_MFP_SC1_CLK@PC_L_MFP', 'LCD_DH1:SYS_PC_L_MFP_PC0_MFP_LCD_DH1@PC_L_MFP'] },
	{ f: ['PC.1', 'SPI0_CLK:SYS_PC_L_MFP_PC1_MFP_SPI0_SCLK@PC_L_MFP', 'I2S_BCLK:SYS_PC_L_MFP_PC1_MFP_I2S_BCLK@PC_L_MFP', 'SC1_DAT:SYS_PC_L_MFP_PC1_MFP_SC1_DAT@PC_L_MFP', 'LCD_DH2:SYS_PC_L_MFP_PC1_MFP_LCD_DH2@PC_L_MFP'] },
	{ f: ['PC.2', 'SPI0_MISO0:SYS_PC_L_MFP_PC2_MFP_SPI0_MISO0@PC_L_MFP', 'I2S_DI:SYS_PC_L_MFP_PC2_MFP_I2S_DIN@PC_L_MFP', 'SC1_PWR:SYS_PC_L_MFP_PC2_MFP_SC1_PWR@PC_L_MFP', 'LCD_COM0:SYS_PC_L_MFP_PC2_MFP_LCD_COM0@PC_L_MFP'] },
	{ f: ['PC.3', 'SPI0_MOSI0:SYS_PC_L_MFP_PC3_MFP_SPI0_MOSI0@PC_L_MFP', 'I2S_DO:SYS_PC_L_MFP_PC3_MFP_I2S_DOUT@PC_L_MFP', 'SC1_RST:SYS_PC_L_MFP_PC3_MFP_SC1_RST@PC_L_MFP', 'LCD_COM1:SYS_PC_L_MFP_PC3_MFP_LCD_COM1@PC_L_MFP'] },
	{ f: ['PC.4', 'SPI0_MISO1:SYS_PC_L_MFP_PC4_MFP_SPI0_MISO1@PC_L_MFP', 'LCD_COM2:SYS_PC_L_MFP_PC4_MFP_LCD_COM2@PC_L_MFP'] },
	{ f: ['PC.5', 'SPI0_MOSI1:SYS_PC_L_MFP_PC5_MFP_SPI0_MOSI1@PC_L_MFP', 'LCD_COM3:SYS_PC_L_MFP_PC5_MFP_LCD_COM3@PC_L_MFP'] },
	{ f: ['PC.6', 'DA0_OUT:SYS_PC_L_MFP_PC6_MFP_DA_OUT0@PC_L_MFP', 'EBI_AD4:SYS_PC_L_MFP_PC6_MFP_EBI_AD4@PC_L_MFP', 'TC0:SYS_PC_L_MFP_PC6_MFP_TMR0_CAP@PC_L_MFP', 'SC1_CD:SYS_PC_L_MFP_PC6_MFP_SC1_CD@PC_L_MFP', 'PWM0_CH0:SYS_PC_L_MFP_PC6_MFP_PWM0_CH0@PC_L_MFP'] },
	{ f: ['PC.7', 'DA1_OUT:SYS_PC_L_MFP_PC7_MFP_DA_OUT1@PC_L_MFP', 'EBI_AD5:SYS_PC_L_MFP_PC7_MFP_EBI_AD5@PC_L_MFP', 'TC1:SYS_PC_L_MFP_PC7_MFP_TMR1_CAP@PC_L_MFP', 'PWM0_CH1:SYS_PC_L_MFP_PC7_MFP_PWM0_CH1@PC_L_MFP', 'LCD_SEG17:SYS_PC_L_MFP_PC7_MFP_LCD_S17@PC_L_MFP'] },
	{ f: ['PC.8', 'SPI1_SS0:SYS_PC_H_MFP_PC8_MFP_SPI1_SS0@PC_H_MFP', 'EBI_MCLK:SYS_PC_H_MFP_PC8_MFP_EBI_XCLK@PC_H_MFP', 'I2C1_SDA:SYS_PC_H_MFP_PC8_MFP_I2C1_SDA@PC_H_MFP', 'LCD_SEG28:SYS_PC_H_MFP_PC8_MFP_LCD_S28@PC_H_MFP'] },
	{ f: ['PC.9', 'SPI1_CLK:SYS_PC_H_MFP_PC9_MFP_SPI1_SCLK@PC_H_MFP', 'I2C1_SCL:SYS_PC_H_MFP_PC9_MFP_I2C1_SCL@PC_H_MFP', 'LCD_SEG29:SYS_PC_H_MFP_PC9_MFP_LCD_S29@PC_H_MFP'] },
	{ f: ['PC.10', 'SPI1_MISO0:SYS_PC_H_MFP_PC10_MFP_SPI1_MISO0@PC_H_MFP', 'UART1_RXD:SYS_PC_H_MFP_PC10_MFP_UART1_RX@PC_H_MFP', 'LCD_SEG30:SYS_PC_H_MFP_PC10_MFP_LCD_S30@PC_H_MFP'] },
	{ f: ['PC.11', 'SPI1_MOSI0:SYS_PC_H_MFP_PC11_MFP_SPI1_MOSI0@PC_H_MFP', 'UART1_TXD:SYS_PC_H_MFP_PC11_MFP_UART1_TX@PC_H_MFP', 'LCD_SEG31:SYS_PC_H_MFP_PC11_MFP_LCD_S31@PC_H_MFP'] },
	{ f: ['PC.12', 'SPI1_MISO1:SYS_PC_H_MFP_PC12_MFP_SPI1_MISO1@PC_H_MFP', 'PWM1_CH0:SYS_PC_H_MFP_PC12_MFP_PWM1_CH0@PC_H_MFP', 'INT0:SYS_PC_H_MFP_PC12_MFP_EXT_INT0@PC_H_MFP', 'I2C0_SDA:SYS_PC_H_MFP_PC12_MFP_I2C0_SDA@PC_H_MFP'] },
	{ f: ['PC.13', 'SPI1_MOSI1:SYS_PC_H_MFP_PC13_MFP_SPI1_MOSI1@PC_H_MFP', 'PWM1_CH1:SYS_PC_H_MFP_PC13_MFP_PWM1_CH1@PC_H_MFP', 'SNOOPER:SYS_PC_H_MFP_PC13_MFP_SNOOPER@PC_H_MFP', 'INT1:SYS_PC_H_MFP_PC13_MFP_EXT_INT1@PC_H_MFP', 'I2C0_SCL:SYS_PC_H_MFP_PC13_MFP_I2C0_SCL@PC_H_MFP'] },
	{ f: ['PC.14', 'EBI_AD2:SYS_PC_H_MFP_PC14_MFP_EBI_AD2@PC_H_MFP', 'PWM1_CH3:SYS_PC_H_MFP_PC14_MFP_PWM1_CH3@PC_H_MFP', 'LCD_SEG32:SYS_PC_H_MFP_PC14_MFP_LCD_S32@PC_H_MFP', 'LCD_SEG15:SYS_PC_H_MFP_PC14_MFP_LCD_S15@PC_H_MFP'] },
	{ f: ['PC.15', 'EBI_AD3:SYS_PC_H_MFP_PC15_MFP_EBI_AD3@PC_H_MFP', 'TC0:SYS_PC_H_MFP_PC15_MFP_TMR0_CAP@PC_H_MFP', 'PWM1_CH2:SYS_PC_H_MFP_PC15_MFP_PWM1_CH2@PC_H_MFP', 'LCD_SEG33:SYS_PC_H_MFP_PC15_MFP_LCD_S33@PC_H_MFP', 'LCD_SEG16:SYS_PC_H_MFP_PC15_MFP_LCD_S16@PC_H_MFP'] },

	{ f: ['PD.0', 'UART1_RXD:SYS_PD_L_MFP_PD0_MFP_UART1_RX@PD_L_MFP', 'SPI2_SS0:SYS_PD_L_MFP_PD0_MFP_SPI2_SS0@PD_L_MFP', 'SC1_CLK:SYS_PD_L_MFP_PD0_MFP_SC1_CLK@PD_L_MFP', 'AD8:SYS_PD_L_MFP_PD0_MFP_ADC_CH8@PD_L_MFP'] },
	{ f: ['PD.1', 'UART1_TXD:SYS_PD_L_MFP_PD1_MFP_UART1_TX@PD_L_MFP', 'SPI2_CLK:SYS_PD_L_MFP_PD1_MFP_SPI2_SCLK@PD_L_MFP', 'SC1_DAT:SYS_PD_L_MFP_PD1_MFP_SC1_DAT@PD_L_MFP', 'AD9:SYS_PD_L_MFP_PD1_MFP_ADC_CH9@PD_L_MFP'] },
	{ f: ['PD.2', 'UART1_RTSn:SYS_PD_L_MFP_PD2_MFP_UART1_RTS@PD_L_MFP', 'I2S_LRCLK:SYS_PD_L_MFP_PD2_MFP_I2S_WS@PD_L_MFP', 'SPI2_MISO0:SYS_PD_L_MFP_PD2_MFP_SPI2_MISO0@PD_L_MFP', 'SC1_PWR:SYS_PD_L_MFP_PD2_MFP_SC1_PWR@PD_L_MFP', 'AD10:SYS_PD_L_MFP_PD2_MFP_ADC_CH10@PD_L_MFP'] },
	{ f: ['PD.3', 'UART1_CTSn:SYS_PD_L_MFP_PD3_MFP_UART1_CTS@PD_L_MFP', 'I2S_BCLK:SYS_PD_L_MFP_PD3_MFP_I2S_BCLK@PD_L_MFP', 'SPI2_MOSI0:SYS_PD_L_MFP_PD3_MFP_SPI2_MOSI0@PD_L_MFP', 'SC1_RST:SYS_PD_L_MFP_PD3_MFP_SC1_RST@PD_L_MFP', 'AD11:SYS_PD_L_MFP_PD3_MFP_ADC_CH11@PD_L_MFP'] },
	{ f: ['PD.4', 'I2S_DI:SYS_PD_L_MFP_PD4_MFP_I2S_DIN@PD_L_MFP', 'SPI2_MISO1:SYS_PD_L_MFP_PD4_MFP_SPI2_MISO1@PD_L_MFP', 'SC1_CD:SYS_PD_L_MFP_PD4_MFP_SC1_CD@PD_L_MFP', 'LCD_SEG35:SYS_PD_L_MFP_PD4_MFP_LCD_S35@PD_L_MFP'] },
	{ f: ['PD.5', 'I2S_DO:SYS_PD_L_MFP_PD5_MFP_I2S_DOUT@PD_L_MFP', 'SPI2_MOSI1:SYS_PD_L_MFP_PD5_MFP_SPI2_MOSI1@PD_L_MFP', 'LCD_SEG34:SYS_PD_L_MFP_PD5_MFP_LCD_S34@PD_L_MFP'] },
	{ f: ['PD.6', 'LCD_SEG3:SYS_PD_L_MFP_PD6_MFP_LCD_S3@PD_L_MFP'] },
	{ f: ['PD.7', 'LCD_SEG2:SYS_PD_L_MFP_PD7_MFP_LCD_S2@PD_L_MFP'] },
	{ f: ['PD.8', 'LCD_SEG19:SYS_PD_H_MFP_PD8_MFP_LCD_S19@PD_H_MFP'] },
	{ f: ['PD.9', 'LCD_SEG18:SYS_PD_H_MFP_PD9_MFP_LCD_S18@PD_H_MFP'] },
	{ f: ['PD.10', 'LCD_SEG17:SYS_PD_H_MFP_PD10_MFP_LCD_S17@PD_H_MFP'] },
	{ f: ['PD.11', 'LCD_SEG16:SYS_PD_H_MFP_PD11_MFP_LCD_S16@PD_H_MFP'] },
	{ f: ['PD.12', 'LCD_SEG15:SYS_PD_H_MFP_PD12_MFP_LCD_S15@PD_H_MFP'] },
	{ f: ['PD.13', 'LCD_SEG14:SYS_PD_H_MFP_PD13_MFP_LCD_S14@PD_H_MFP'] },
	{ f: ['PD.14', 'LCD_SEG1:SYS_PD_H_MFP_PD14_MFP_LCD_S1@PD_H_MFP'] },
	{ f: ['PD.15', 'LCD_SEG0:SYS_PD_H_MFP_PD15_MFP_LCD_S0@PD_H_MFP'] },

	{ f: ['PE.0', 'PWM1_CH2:SYS_PE_L_MFP_PE0_MFP_PWM1_CH2@PE_L_MFP', 'I2S_MCLK:SYS_PE_L_MFP_PE0_MFP_I2S_MCLK@PE_L_MFP'] },
	{ f: ['PE.1', 'PWM1_CH3:SYS_PE_L_MFP_PE1_MFP_PWM1_CH3@PE_L_MFP', 'SPI0_SS0:SYS_PE_L_MFP_PE1_MFP_SPI0_SS0@PE_L_MFP'] },
	{ f: ['PE.2', 'SPI0_CLK:SYS_PE_L_MFP_PE2_MFP_SPI0_SCLK@PE_L_MFP'] },
	{ f: ['PE.3', 'SPI0_MISO0:SYS_PE_L_MFP_PE3_MFP_SPI0_MISO0@PE_L_MFP'] },
	{ f: ['PE.4', 'SPI0_MOSI0:SYS_PE_L_MFP_PE4_MFP_SPI0_MOSI0@PE_L_MFP'] },
	{ f: ['PE.5', 'PWM1_CH1:SYS_PE_L_MFP_PE5_MFP_PWM1_CH1@PE_L_MFP'] },
	{ f: ['PE.6'] },
	{ f: ['PE.7', 'LCD_SEG8:SYS_PE_L_MFP_PE7_MFP_LCD_S8@PE_L_MFP'] },
	{ f: ['PE.8', 'LCD_SEG9:SYS_PE_H_MFP_PE8_MFP_LCD_S9@PE_H_MFP'] },
	{ f: ['PE.9', 'UART1_RXD:SYS_PE_H_MFP_PE9_MFP_UART1_RX@PE_H_MFP'] },
	{ f: ['PE.10', 'UART1_TXD:SYS_PE_H_MFP_PE10_MFP_UART1_TX@PE_H_MFP'] },
	{ f: ['PE.11', 'UART1_RTSn:SYS_PE_H_MFP_PE11_MFP_UART1_RTS@PE_H_MFP'] },
	{ f: ['PE.12', 'UART1_CTSn:SYS_PE_H_MFP_PE12_MFP_UART1_CTS@PE_H_MFP'] },
	{ f: ['PE.13', 'LCD_SEG27:SYS_PE_H_MFP_PE13_MFP_LCD_S27@PE_H_MFP'] },
	{ f: ['PE.14', 'LCD_SEG28:SYS_PE_H_MFP_PE14_MFP_LCD_S28@PE_H_MFP'] },
	{ f: ['PE.15', 'LCD_SEG29:SYS_PE_H_MFP_PE15_MFP_LCD_S29@PE_H_MFP'] },

	{ f: ['PF.0', 'INT0:SYS_PF_L_MFP_PF0_MFP_EXT_INT0@PF_L_MFP', 'ICE_DAT:SYS_PF_L_MFP_PF0_MFP_ICE_DAT@PF_L_MFP'] },
	{ f: ['PF.1', 'FCLKO:SYS_PF_L_MFP_PF1_MFP_CKO@PF_L_MFP', 'INT1:SYS_PF_L_MFP_PF1_MFP_EXT_INT1@PF_L_MFP', 'ICE_CLK:SYS_PF_L_MFP_PF1_MFP_ICE_CLK@PF_L_MFP'] },
	{ f: ['PF.2', 'XT1_OUT:SYS_PF_L_MFP_PF2_MFP_HXT_OUT@PF_L_MFP'] },
	{ f: ['PF.3', 'XT1_IN:SYS_PF_L_MFP_PF3_MFP_HXT_IN@PF_L_MFP'] },
	{ f: ['PF.4', 'I2C0_SDA:SYS_PF_L_MFP_PF4_MFP_I2C0_SDA@PF_L_MFP'] },
	{ f: ['PF.5', 'I2C0_SCL:SYS_PF_L_MFP_PF5_MFP_I2C0_SCL@PF_L_MFP'] }
];

NUTOOL_PIN.g_cfg_gpiosDescriptions = [
	'AD0:ADC analog input0',
	'AD1:ADC analog input1',
	'AD2:ADC analog input2',
	'AD3:ADC analog input3',
	'AD4:ADC analog input4',
	'AD5:ADC analog input5',
	'AD6:ADC analog input6',
	'AD7:ADC analog input7',
	'AD8:ADC analog input8',
	'AD9:ADC analog input9',
	'AD10:ADC analog input10',
	'AD11:ADC analog input11',

	'AVDD:Power supply for internal analog circuit',
	'AVSS:Ground Pin for analog circuit',

	'DA0_OUT:DAC0 output',
	'DA1_OUT:DAC1 output',

	'EBI_AD0:EBI Address/Data bus bit0',
	'EBI_AD1:EBI Address/Data bus bit1',
	'EBI_AD2:EBI Address/Data bus bit2',
	'EBI_AD3:EBI Address/Data bus bit3',
	'EBI_AD4:EBI Address/Data bus bit4',
	'EBI_AD5:EBI Address/Data bus bit5',
	'EBI_AD6:EBI Address/Data bus bit6',
	'EBI_AD7:EBI Address/Data bus bit7',
	'EBI_AD8:EBI Address/Data bus bit8',
	'EBI_AD9:EBI Address/Data bus bit9',
	'EBI_AD10:EBI Address/Data bus bit10',
	'EBI_AD11:EBI Address/Data bus bit11',
	'EBI_AD12:EBI Address/Data bus bit12',
	'EBI_AD13:EBI Address/Data bus bit13',
	'EBI_AD14:EBI Address/Data bus bit14',
	'EBI_AD15:EBI Address/Data bus bit15',
	'EBI_ALE:EBI address latch enable output pin',
	'EBI_MCLK:EBI external clock output pin',
	'EBI_nCS:EBI chip select enable output pin',
	'EBI_nRD:EBI read enable output pin',
	'EBI_nWR:EBI write enable output pin',
	'EBI_nWRH:EBI high byte write enable output pin',
	'EBI_nWRL:EBI low byte write enable output pin',

	'FCLKO:Frequency Divider output pin',

	'I2C0_SCL:I2C0 clock pin',
	'I2C0_SDA:I2C0 data I/O pin',
	'I2C1_SCL:I2C1 clock pin',
	'I2C1_SDA:I2C1 data I/O pin',

	'I2S_BCLK:I2S bit clock pin',
	'I2S_DI:I2S data input',
	'I2S_DO:I2S data output',
	'I2S_LRCLK:I2S left right channel clock',
	'I2S_MCLK:I2S master clock output pin',

	'ICE_CLK:Serial Wired Debugger Clock pin',
	'ICE_DAT:Serial Wired Debugger Data pin',

	'INT0:External interrupt0 input pin',
	'INT1:External interrupt1 input pin',

	'LCD_COM0:LCD common output 0',
	'LCD_COM1:LCD common output 1',
	'LCD_COM2:LCD common output 2',
	'LCD_COM3:LCD common output 3',
	'LCD_DH1:LCD externl capacitor pin of charge pump circuit',
	'LCD_DH2:LCD externl capacitor pin of charge pump circuit',
	'LCD_SEG0:LCD segment output 0 (or as LCD_COM4)',
	'LCD_SEG1:LCD segment output 1 (or as LCD_COM5)',
	'LCD_SEG2:LCD segment output 2',
	'LCD_SEG3:LCD segment output 3',
	'LCD_SEG4:LCD segment output 4',
	'LCD_SEG5:LCD segment output 5',
	'LCD_SEG6:LCD segment output 6',
	'LCD_SEG7:LCD segment output 7',
	'LCD_SEG8:LCD segment output 8',
	'LCD_SEG9:LCD segment output 9',
	'LCD_SEG10:LCD segment output 10',
	'LCD_SEG11:LCD segment output 11',
	'LCD_SEG12:LCD segment output 12',
	'LCD_SEG13:LCD segment output 13',
	'LCD_SEG14:LCD segment output 14',
	'LCD_SEG15:LCD segment output 15',
	'LCD_SEG16:LCD segment output 16',
	'LCD_SEG17:LCD segment output 17',
	'LCD_SEG18:LCD segment output 18',
	'LCD_SEG19:LCD segment output 19',
	'LCD_SEG20:LCD segment output 20',
	'LCD_SEG21:LCD segment output 21',
	'LCD_SEG22:LCD segment output 22',
	'LCD_SEG23:LCD segment output 23',
	'LCD_SEG24:LCD segment output 24',
	'LCD_SEG25:LCD segment output 25',
	'LCD_SEG26:LCD segment output 26',
	'LCD_SEG27:LCD segment output 27',
	'LCD_SEG28:LCD segment output 28',
	'LCD_SEG29:LCD segment output 29',
	'LCD_SEG30:LCD segment output 30',
	'LCD_SEG31:LCD segment output 31',
	'LCD_SEG32:LCD segment output 32',
	'LCD_SEG33:LCD segment output 33',
	'LCD_SEG34:LCD segment output 34',
	'LCD_SEG35:LCD segment output 35',
	'LCD_SEG36:LCD segment output 36',
	'LCD_SEG37:LCD segment output 37',
	'LCD_SEG38:LCD segment output 38',
	'LCD_SEG39:LCD segment output 39',

	'LCD_V1:LCD Unit voltage for LCD charge pump circuit',
	'LCD_V2:LCD driver biasing voltage',
	'LCD_V3:LCD driver biasing voltage',
	'LCD_VLCD:LCD power supply pin',
	'LDO_CAP:LDO output pin',
	'nRESET:External reset input: Low active, set this pin low reset chip to initial state. With internal pull-up',
	'PVSS:PLL Ground',

	'PWM0_CH0:PWM0 Channel0 output',
	'PWM0_CH1:PWM0 Channel1 output',
	'PWM0_CH2:PWM0 Channel2 output',
	'PWM0_CH3:PWM0 Channel3 output',
	'PWM1_CH0:PWM1 Channel0 output',
	'PWM1_CH1:PWM1 Channel1 output',
	'PWM1_CH2:PWM1 Channel2 output',
	'PWM1_CH3:PWM1 Channel3 output',

	'SC0_CD:SmartCard0 card detect pin',
	'SC0_CLK:SmartCard0 clock pin(SC0_UART_TXD)',
	'SC0_DAT:SmartCard0 DATA pin(SC0_UART_RXD)',
	'SC0_PWR:SmartCard0 Power pin',
	'SC0_RST:SmartCard0 RST pin',
	'SC1_CD:SmartCard1 card detect pin',
	'SC1_CLK:SmartCard1 clock pin(SC1_UART_TXD)',
	'SC1_DAT:SmartCard1 DATA pin(SC1_UART_RXD)',
	'SC1_PWR:SmartCard1 Power pin',
	'SC1_RST:SmartCard1 RST pin',
	'SC2_CD:SmartCard2 card detect pin',
	'SC2_CLK:SmartCard2 clock pin(SC2_UART_TXD)',
	'SC2_DAT:SmartCard2 DATA pin(SC2_UART_RXD)',
	'SC2_PWR:SmartCard2 Power pin',
	'SC2_RST:SmartCard2 RST pin',

	'SNOOPER:Snooper pin',

	'SPI0_CLK:SPI0 serial clock pin',
	'SPI0_MISO0:SPI0 1st MISO (Master In, Slave Out) pin',
	'SPI0_MISO1:SPI0 2nd MISO (Master In, Slave Out) pin',
	'SPI0_MOSI0:SPI0 1st MOSI (Master Out, Slave In) pin',
	'SPI0_MOSI1:SPI0 2nd MOSI (Master Out, Slave In) pin',
	'SPI0_SS0:SPI0 1st slave select pin',
	'SPI0_SS1:SPI0 2nd slave select pin',
	'SPI1_CLK:SPI1 serial clock pin',
	'SPI1_MISO0:SPI1 1st MISO (Master In, Slave Out) pin',
	'SPI1_MISO1:SPI1 2nd MISO (Master In, Slave Out) pin',
	'SPI1_MOSI0:SPI1 1st MOSI (Master Out, Slave In) pin',
	'SPI1_MOSI1:SPI1 2nd MOSI (Master Out, Slave In) pin',
	'SPI1_SS0:SPI1 1st slave select pin',
	'SPI1_SS1:SPI1 2nd slave select pin',
	'SPI2_CLK:SPI2 serial clock pin',
	'SPI2_MISO0:SPI2 1st MISO (Master In, Slave Out) pin',
	'SPI2_MISO1:SPI2 2nd MISO (Master In, Slave Out) pin',
	'SPI2_MOSI0:SPI2 1st MOSI (Master Out, Slave In) pin',
	'SPI2_MOSI1:SPI2 2nd MOSI (Master Out, Slave In) pin',
	'SPI2_SS0:SPI2 1st slave select pin',
	'SPI2_SS1:SPI2 2nd slave select pin',

	'STADC:ADC external trigger input',

	'TC0:Timer0 capture input',
	'TC1:Timer1 capture input',
	'TC2:Timer2 capture input',
	'TC3:Timer3 capture input',
	'TM0:Timer0 external counter input',
	'TM1:Timer1 external counter input',
	'TM2:Timer2 external counter input',
	'TM3:Timer3 external counter input',
	'TX1:UART1 Data transmitter output pin',

	'UART0_CTSn:UART0 Clear to Send input pin',
	'UART0_nCTS:UART0 Clear to Send input pin',
	'UART0_nRTS:UART0 Request to Send output pin',
	'UART0_RTSn:UART0 Request to Send output pin',
	'UART0_RXD:UART0 Data receiver input pin',
	'UART0_TXD:UART0 Data transmitter output pin',
	'UART1_CTSn:UART1 Clear to Send input pin',
	'UART1_nCTS:UART1 Clear to Send input pin',
	'UART1_nRTS:UART1 Request to Send output pin',
	'UART1_RTSn:UART1 Request to Send output pin',
	'UART1_RXD:UART1 Data receiver input pin',
	'UART1_TXD:UART1 Data transmitter output pin',

	'USB_D-:USB Differential Signal D-',
	'USB_D+:USB Differential Signal D+',
	'USB_VBUS:POWER SUPPLY: From USB Host or HUB',
	'USB_VDD33_CAP:Internal Power Regulator Output 3.3V Decoupling Pin',

	'VDD:Power supply for I/O ports and LDO source for internal PLL and digital circuit',
	'VREF:Voltage reference input for ADC',

	'VSS:Ground',

	'X32I:External 32.768 kHz crystal input pin',
	'X32O:External 32.768 kHz crystal output pin',

	'XT1_IN:External 4~24 MHz crystal output pin',
	'XT1_OUT:External 4~24 MHz crystal input pin'
];

NUTOOL_PIN.g_cfg_regDescriptions = {};
NUTOOL_PIN.g_cfg_regDescriptions.PA_L_MFP = '0x50000030';
NUTOOL_PIN.g_cfg_regDescriptions.PA_H_MFP = '0x50000034';
NUTOOL_PIN.g_cfg_regDescriptions.PB_L_MFP = '0x50000038';
NUTOOL_PIN.g_cfg_regDescriptions.PB_H_MFP = '0x5000003C';
NUTOOL_PIN.g_cfg_regDescriptions.PC_L_MFP = '0x50000040';
NUTOOL_PIN.g_cfg_regDescriptions.PC_H_MFP = '0x50000044';
NUTOOL_PIN.g_cfg_regDescriptions.PD_L_MFP = '0x50000048';
NUTOOL_PIN.g_cfg_regDescriptions.PD_H_MFP = '0x5000004C';
NUTOOL_PIN.g_cfg_regDescriptions.PE_L_MFP = '0x50000050';
NUTOOL_PIN.g_cfg_regDescriptions.PE_H_MFP = '0x50000054';
NUTOOL_PIN.g_cfg_regDescriptions.PF_L_MFP = '0x50000058';

NUTOOL_PIN.g_cfg_gpioMatrix = [];
NUTOOL_PIN.g_cfg_shareBits = [];
NUTOOL_PIN.g_cfg_addGPIO = {
	"NANO110SC2BN(LQFP64)": {
		"PB.14": ['LCD_SEG12:7'],
		"PB.13": ['LCD_SEG11:7'],
		"PB.12": ['LCD_SEG10:7'],
		"PA.11": ['LCD_SEG9:7'],
		"PA.10": ['LCD_SEG8:7'],
		"PA.9": ['LCD_SEG7:7'],
		"PA.8": ['LCD_SEG6:7'],
		"PB.4": ['LCD_SEG5:7'],
		"PB.5": ['LCD_SEG4:7'],
		"PB.6": ['LCD_SEG3:7'],
		"PB.7": ['LCD_SEG2:7'],
		"PB.0": ['LCD_SEG1:7'],
		"PB.1": ['LCD_SEG0:7'],
		"PB.2": ['LCD_COM3:7'],
		"PB.3": ['LCD_COM2:7'],
		"PC.3": ['LCD_COM1:7'],
		"PC.2": ['LCD_COM0:7'],
		"PC.1": ['LCD_DH2:7'],
		"PC.0": ['LCD_DH1:7'],
		"PB.11": ['LCD_V1:7'],
		"PB.10": ['LCD_V2:7'],
		"PB.9": ['LCD_V3:7'],
		"PC.11": ['LCD_SEG31:7'],
		"PC.10": ['LCD_SEG30:7'],
		"PC.9": ['LCD_SEG29:7'],
		"PC.8": ['LCD_SEG28:7'],
		"PA.15": ['LCD_SEG27:7'],
		"PA.14": ['LCD_SEG26:7'],
		"PA.13": ['LCD_SEG25:7'],
		"PA.12": ['LCD_SEG24:7'],
		"PA.2": ['LCD_SEG23:7'],
		"PA.3": ['LCD_SEG22:7'],
		"PA.4": ['LCD_SEG21:7'],
		"PA.5": ['LCD_SEG20:7'],
		"PA.6": ['LCD_SEG19:7'],
		"PA.7": ['LCD_SEG18:7'],
		"PC.7": ['LCD_SEG17:7'],
		"PC.15": ['LCD_SEG16:7'],
		"PC.14": ['LCD_SEG15:7'],
		"PB.15": ['LCD_SEG14:7'],
		"PB.8": ['LCD_SEG13:7'],
		"PE.9": ["UART1_RXD:7"],
		"PE.10": ["UART1_TXD:7"],
		"PE.11": ["UART1_RTSn:7"],
		"PE.12": ["UART1_CTSn:7"]
	},
	"NANO110SD2BN(LQFP64)": function () {
		return this["NANO110SC2BN(LQFP64)"];
	},
	"NANO110SD3BN(LQFP64)": function () {
		return this["NANO110SC2BN(LQFP64)"];
	},
	"NANO110SE3BN(LQFP64)": function () {
		return this["NANO110SC2BN(LQFP64)"];
	},
	"NANO110RC2BN(LQFP64)": function () {
		return this["NANO110SC2BN(LQFP64)"];
	},
	"NANO110RD2BN(LQFP64)": function () {
		return this["NANO110SC2BN(LQFP64)"];
	},
	"NANO110RD3BN(LQFP64)": function () {
		return this["NANO110SC2BN(LQFP64)"];
	},
	"NANO110RE3BN(LQFP64)": function () {
		return this["NANO110SC2BN(LQFP64)"];
	},
	"NANO130SC2BN(LQFP64)": {
		"PB.14": ['LCD_SEG12:7'],
		"PB.13": ['LCD_SEG11:7'],
		"PB.12": ['LCD_SEG10:7'],
		"PA.11": ['LCD_SEG9:7'],
		"PA.10": ['LCD_SEG8:7'],
		"PA.9": ['LCD_SEG7:7'],
		"PA.8": ['LCD_SEG6:7'],
		"PB.4": ['LCD_SEG5:7'],
		"PB.5": ['LCD_SEG4:7'],
		"PB.6": ['LCD_SEG3:7'],
		"PB.7": ['LCD_SEG2:7'],
		"PB.0": ['LCD_SEG1:7'],
		"PB.1": ['LCD_SEG0:7'],
		"PB.2": ['LCD_COM3:7'],
		"PB.3": ['LCD_COM2:7'],
		"PC.3": ['LCD_COM1:7'],
		"PC.2": ['LCD_COM0:7'],
		"PC.1": ['LCD_DH2:7'],
		"PC.0": ['LCD_DH1:7'],
		"PB.11": ['LCD_V1:7'],
		"PB.10": ['LCD_V2:7'],
		"PB.9": ['LCD_V3:7'],
		"PC.11": ['LCD_SEG31:7'],
		"PC.10": ['LCD_SEG30:7'],
		"PC.9": ['LCD_SEG29:7'],
		"PC.8": ['LCD_SEG28:7'],
		"PA.15": ['LCD_SEG27:7'],
		"PA.14": ['LCD_SEG26:7'],
		"PA.13": ['LCD_SEG25:7'],
		"PA.12": ['LCD_SEG24:7'],
		"PA.2": ['LCD_SEG23:7'],
		"PA.3": ['LCD_SEG22:7'],
		"PA.4": ['LCD_SEG21:7'],
		"PA.5": ['LCD_SEG20:7'],
		"PA.6": ['LCD_SEG19:7'],
		"PA.7": ['LCD_SEG18:7'],
		"PC.7": ['LCD_SEG17:7'],
		"PC.15": ['LCD_SEG16:7'],
		"PC.14": ['LCD_SEG15:7'],
		"PB.15": ['LCD_SEG14:7'],
		"PB.8": ['LCD_SEG13:7']
	},
	"NANO130SD2BN(LQFP64)": function () {
		return this["NANO130SC2BN(LQFP64)"];
	},
	"NANO130SD3BN(LQFP64)": function () {
		return this["NANO130SC2BN(LQFP64)"];
	},
	"NANO130SE3BN(LQFP64)": function () {
		return this["NANO130SC2BN(LQFP64)"];
	},
	"NANO110KC2BN(LQFP128)": {
		"PE.13": ['LCD_SEG27:7'],
		"PB.14": ['LCD_SEG26:7'],
		"PB.13": ['LCD_SEG25:7'],
		"PB.12": ['LCD_SEG24:7'],
		"PA.11": ['LCD_SEG23:7'],
		"PA.10": ['LCD_SEG22:7'],
		"PA.9": ['LCD_SEG21:7'],
		"PA.8": ['LCD_SEG20:7'],
		"PB.4": ['LCD_SEG13:7'],
		"PB.5": ['LCD_SEG12:7'],
		"PB.6": ['LCD_SEG11:7'],
		"PB.7": ['LCD_SEG10:7'],
		"PB.0": ['LCD_SEG7:7'],
		"PB.1": ['LCD_SEG6:7'],
		"PB.2": ['LCD_SEG5:7'],
		"PB.3": ['LCD_SEG4:7'],
		"PD.6": ['LCD_SEG3:7'],
		"PD.7": ['LCD_SEG2:7'],
		"PD.14": ['LCD_SEG1:7'],
		"PD.15": ['LCD_SEG0:7'],
		"PC.5": ['LCD_COM3:7'],
		"PC.4": ['LCD_COM2:7'],
		"PC.3": ['LCD_COM1:7'],
		"PC.2": ['LCD_COM0:7'],
		"PC.1": ['LCD_DH2:7'],
		"PC.0": ['LCD_DH1:7'],
		"PB.11": ['LCD_V1:7'],
		"PB.10": ['LCD_V2:7'],
		"PB.9": ['LCD_V3:7'],
		"PA.4": ['LCD_SEG39:7'],
		"PA.5": ['LCD_SEG38:7'],
		"PA.6": ['LCD_SEG37:7'],
		"PA.7": ['LCD_SEG36:7'],
		"PD.4": ['LCD_SEG35:7'],
		"PD.5": ['LCD_SEG34:7'],
		"PC.15": ['LCD_SEG33:7'],
		"PC.14": ['LCD_SEG32:7'],
		"PB.15": ['LCD_SEG31:7'],
		"PB.8": ['LCD_SEG30:7'],
		"PE.15": ['LCD_SEG29:7'],
		"PE.14": ['LCD_SEG28:7'],
		"PE.9": ["UART1_RXD:7"],
		"PE.10": ["UART1_TXD:7"],
		"PE.11": ["UART1_RTSn:7"],
		"PE.12": ["UART1_CTSn:7"],
		"PD.8": ['LCD_SEG19:7'],
		"PD.9": ['LCD_SEG18:7'],
		"PD.10": ['LCD_SEG17:7'],
		"PD.11": ['LCD_SEG16:7'],
		"PD.12": ['LCD_SEG15:7'],
		"PD.13": ['LCD_SEG14:7'],
		"PE.8": ['LCD_SEG9:7'],
		"PE.7": ['LCD_SEG8:7']
	},
	"NANO110KD2BN(LQFP128)": function () {
		return this["NANO110KC2BN(LQFP128)"];
	},
	"NANO110KD3BN(LQFP128)": function () {
		return this["NANO110KC2BN(LQFP128)"];
	},
	"NANO110KE3BN(LQFP128)": function () {
		return this["NANO110KC2BN(LQFP128)"];
	},
	"NANO130KC2BN(LQFP128)": {
		"PE.13": ['LCD_SEG27:7'],
		"PB.14": ['LCD_SEG26:7'],
		"PB.13": ['LCD_SEG25:7'],
		"PB.12": ['LCD_SEG24:7'],
		"PA.11": ['LCD_SEG23:7'],
		"PA.10": ['LCD_SEG22:7'],
		"PA.9": ['LCD_SEG21:7'],
		"PA.8": ['LCD_SEG20:7'],
		"PB.4": ['LCD_SEG13:7'],
		"PB.5": ['LCD_SEG12:7'],
		"PB.6": ['LCD_SEG11:7'],
		"PB.7": ['LCD_SEG10:7'],
		"PB.0": ['LCD_SEG7:7'],
		"PB.1": ['LCD_SEG6:7'],
		"PB.2": ['LCD_SEG5:7'],
		"PB.3": ['LCD_SEG4:7'],
		"PD.6": ['LCD_SEG3:7'],
		"PD.7": ['LCD_SEG2:7'],
		"PD.14": ['LCD_SEG1:7'],
		"PD.15": ['LCD_SEG0:7'],
		"PC.5": ['LCD_COM3:7'],
		"PC.4": ['LCD_COM2:7'],
		"PC.3": ['LCD_COM1:7'],
		"PC.2": ['LCD_COM0:7'],
		"PC.1": ['LCD_DH2:7'],
		"PC.0": ['LCD_DH1:7'],
		"PB.11": ['LCD_V1:7'],
		"PB.10": ['LCD_V2:7'],
		"PB.9": ['LCD_V3:7'],
		"PA.4": ['LCD_SEG39:7'],
		"PA.5": ['LCD_SEG38:7'],
		"PA.6": ['LCD_SEG37:7'],
		"PA.7": ['LCD_SEG36:7'],
		"PD.4": ['LCD_SEG35:7'],
		"PD.5": ['LCD_SEG34:7'],
		"PC.15": ['LCD_SEG33:7'],
		"PC.14": ['LCD_SEG32:7'],
		"PB.15": ['LCD_SEG31:7'],
		"PB.8": ['LCD_SEG30:7'],
		"PE.15": ['LCD_SEG29:7'],
		"PE.14": ['LCD_SEG28:7'],
		"PD.8": ['LCD_SEG19:7'],
		"PD.9": ['LCD_SEG18:7'],
		"PD.10": ['LCD_SEG17:7'],
		"PD.11": ['LCD_SEG16:7'],
		"PD.12": ['LCD_SEG15:7'],
		"PD.13": ['LCD_SEG14:7'],
		"PE.8": ['LCD_SEG9:7'],
		"PE.7": ['LCD_SEG8:7']
	},
	"NANO130KD2BN(LQFP128)": function () {
		return this["NANO130KC2BN(LQFP128)"];
	},
	"NANO130KD3BN(LQFP128)": function () {
		return this["NANO130KC2BN(LQFP128)"];
	},
	"NANO130KE3BN(LQFP128)": function () {
		return this["NANO130KC2BN(LQFP128)"];
	}
};

NUTOOL_PIN.g_cfg_unusedGPIO = {
	"NANO110SC2BN(LQFP64)": {
		"PE.5": ["PWM1_CH1"]
	},
	"NANO110SD2BN(LQFP64)": function () {
		return this["NANO110SC2BN(LQFP64)"];
	},
	"NANO110SD3BN(LQFP64)": function () {
		return this["NANO110SC2BN(LQFP64)"];
	},
	"NANO110SE3BN(LQFP64)": function () {
		return this["NANO110SC2BN(LQFP64)"];
	},
	"NANO110RC2BN(LQFP64)": function () {
		return this["NANO110SC2BN(LQFP64)"];
	},
	"NANO110RD2BN(LQFP64)": function () {
		return this["NANO110SC2BN(LQFP64)"];
	},
	"NANO110RD3BN(LQFP64)": function () {
		return this["NANO110SC2BN(LQFP64)"];
	},
	"NANO110RE3BN(LQFP64)": function () {
		return this["NANO110SC2BN(LQFP64)"];
	},
	"NANO110KC2BN(LQFP128)": function () {
		return this["NANO110SC2BN(LQFP64)"];
	},
	"NANO110KD2BN(LQFP128)": function () {
		return this["NANO110SC2BN(LQFP64)"];
	},
	"NANO110KD3BN(LQFP128)": function () {
		return this["NANO110SC2BN(LQFP64)"];
	},
	"NANO110KE3BN(LQFP128)": function () {
		return this["NANO110SC2BN(LQFP64)"];
	},
	"NANO130SC2BN(LQFP64)": function () {
		return this["NANO110SC2BN(LQFP64)"];
	},
	"NANO130SD2BN(LQFP64)": function () {
		return this["NANO110SC2BN(LQFP64)"];
	},
	"NANO130SD3BN(LQFP64)": function () {
		return this["NANO110SC2BN(LQFP64)"];
	},
	"NANO130SE3BN(LQFP64)": function () {
		return this["NANO110SC2BN(LQFP64)"];
	},
	"NANO130KC2BN(LQFP128)": function () {
		return this["NANO110SC2BN(LQFP64)"];
	},
	"NANO130KD2BN(LQFP128)": function () {
		return this["NANO110SC2BN(LQFP64)"];
	},
	"NANO130KD3BN(LQFP128)": function () {
		return this["NANO110SC2BN(LQFP64)"];
	},
	"NANO130KE3BN(LQFP128)": function () {
		return this["NANO110SC2BN(LQFP64)"];
	}
};

NUTOOL_PIN.decidepackageNumber = function (given_partNumber_package) {
	var partNumber_package;

	if (typeof given_partNumber_package === 'undefined') {
		partNumber_package = NUTOOL_PIN.getg_partNumber_package();
	}
	else {
		partNumber_package = given_partNumber_package;
	}

	NUTOOL_PIN.g_packageNumber = partNumber_package.substring(partNumber_package.indexOf('(') + 1);
	NUTOOL_PIN.g_packageNumber = NUTOOL_PIN.g_packageNumber.substring(0, NUTOOL_PIN.g_packageNumber.indexOf(')'));
	NUTOOL_PIN.g_packageNumberIndex = NUTOOL_PIN.g_packageNumber + '(' + partNumber_package.slice(0, 7) + ')';

	partNumber_package = null;
};
