// chip content
NUTOOL_PIN.g_cfg_chips = [
	//NANO100AN
	{ name: "NANO100ZC2AN", pkg: "QFN33" },
	{ name: "NANO100ZD2AN", pkg: "QFN33" },
	{ name: "NANO100ZD3AN", pkg: "QFN33" },
	{ name: "NANO100LC2AN", pkg: "LQFP48" },
	{ name: "NANO100LD2AN", pkg: "LQFP48" },
	{ name: "NANO100LD3AN", pkg: "LQFP48" },
	{ name: "NANO100SC2AN", pkg: "LQFP64" },
	{ name: "NANO100SD2AN", pkg: "LQFP64" },
	{ name: "NANO100SD3AN", pkg: "LQFP64" },
	{ name: "NANO100VD2AN", pkg: "LQFP100" },
	{ name: "NANO100VD3AN", pkg: "LQFP100" },

	{ name: "NANO120ZC2AN", pkg: "QFN33" },
	{ name: "NANO120ZD2AN", pkg: "QFN33" },
	{ name: "NANO120ZD3AN", pkg: "QFN33" },
	{ name: "NANO120LC2AN", pkg: "LQFP48" },
	{ name: "NANO120LD2AN", pkg: "LQFP48" },
	{ name: "NANO120LD3AN", pkg: "LQFP48" },
	{ name: "NANO120SC2AN", pkg: "LQFP64" },
	{ name: "NANO120SD2AN", pkg: "LQFP64" },
	{ name: "NANO120SD3AN", pkg: "LQFP64" },
	{ name: "NANO120VD2AN", pkg: "LQFP100" },
	{ name: "NANO120VD3AN", pkg: "LQFP100" },
	//NANO100BN
	{ name: "NANO100NC2BN", pkg: "QFN48" },
	{ name: "NANO100ND2BN", pkg: "QFN48" },
	{ name: "NANO100ND3BN", pkg: "QFN48" },
	{ name: "NANO100NE3BN", pkg: "QFN48" },
	{ name: "NANO100LC2BN", pkg: "LQFP48" },
	{ name: "NANO100LD2BN", pkg: "LQFP48" },
	{ name: "NANO100LD3BN", pkg: "LQFP48" },
	{ name: "NANO100LE3BN", pkg: "LQFP48" },
	{ name: "NANO100SC2BN", pkg: "LQFP64" },
	{ name: "NANO100SD2BN", pkg: "LQFP64" },
	{ name: "NANO100SD3BN", pkg: "LQFP64" },
	{ name: "NANO100SE3BN", pkg: "LQFP64" },
	{ name: "NANO100KD3BN", pkg: "LQFP128" },
	//{ name: "NANO100KC2BN", pkg: "LQFP128" },
	//{ name: "NANO100KD2BN", pkg: "LQFP128" },
	//{ name: "NANO100KC3BN", pkg: "LQFP128" },
	{ name: "NANO100KE3BN", pkg: "LQFP128" },

	{ name: "NANO110SC2BN", pkg: "LQFP64" },
	{ name: "NANO110SD2BN", pkg: "LQFP64" },
	{ name: "NANO110SD3BN", pkg: "LQFP64" },
	{ name: "NANO110SE3BN", pkg: "LQFP64" },
	{ name: "NANO110RC2BN", pkg: "LQFP64" },
	{ name: "NANO110RD2BN", pkg: "LQFP64" },
	{ name: "NANO110RD3BN", pkg: "LQFP64" },
	{ name: "NANO110RE3BN", pkg: "LQFP64" },
	{ name: "NANO110KC2BN", pkg: "LQFP128" },
	{ name: "NANO110KD2BN", pkg: "LQFP128" },
	{ name: "NANO110KD3BN", pkg: "LQFP128" },
	{ name: "NANO110KE3BN", pkg: "LQFP128" },

	{ name: "NANO120LC2BN", pkg: "LQFP48" },
	{ name: "NANO120LD2BN", pkg: "LQFP48" },
	{ name: "NANO120LD3BN", pkg: "LQFP48" },
	{ name: "NANO120LE3BN", pkg: "LQFP48" },
	{ name: "NANO120SC2BN", pkg: "LQFP64" },
	{ name: "NANO120SD2BN", pkg: "LQFP64" },
	{ name: "NANO120SD3BN", pkg: "LQFP64" },
	{ name: "NANO120SE3BN", pkg: "LQFP64" },
	//{ name: "NANO120KC2BN", pkg: "LQFP128" },
	//{ name: "NANO120KD2BN", pkg: "LQFP128" },
	{ name: "NANO120KD3BN", pkg: "LQFP128" },
	{ name: "NANO120KE3BN", pkg: "LQFP128" },

	{ name: "NANO130SC2BN", pkg: "LQFP64" },
	{ name: "NANO130SD2BN", pkg: "LQFP64" },
	{ name: "NANO130SD3BN", pkg: "LQFP64" },
	{ name: "NANO130SE3BN", pkg: "LQFP64" },
	{ name: "NANO130KC2BN", pkg: "LQFP128" },
	{ name: "NANO130KD2BN", pkg: "LQFP128" },
	{ name: "NANO130KD3BN", pkg: "LQFP128" },
	{ name: "NANO130KE3BN", pkg: "LQFP128" },
	//NANO103
	{ name: "NANO103SD3AE", pkg: "LQFP64" },
	{ name: "NANO103LD3AE", pkg: "LQFP48" },
	{ name: "NANO103ZD3AE", pkg: "QFN33" },
	//NANO112
	{ name: "NANO112VC2AN", pkg: "LQFP100" },
	{ name: "NANO112RC2AN", pkg: "LQFP64" },
	{ name: "NANO112RB1AN", pkg: "LQFP64" },
	{ name: "NANO112SC2AN", pkg: "LQFP64" },
	{ name: "NANO112SB1AN", pkg: "LQFP64" },
	{ name: "NANO102SC2AN", pkg: "LQFP64" },
	{ name: "NANO112LC2AN", pkg: "LQFP48" },
	{ name: "NANO112LB1AN", pkg: "LQFP48" },
	{ name: "NANO102LC2AN", pkg: "LQFP48" },
	{ name: "NANO102LB1AN", pkg: "LQFP48" },
	{ name: "NANO102ZB1AN", pkg: "QFN33" },
	{ name: "NANO102ZC2AN", pkg: "QFN33" }
];

NUTOOL_PIN.g_cfg_pkgs = {
	"LQFP100(NANO100)": [
		'PE.15', 'PE.14', 'PE.13', 'PB.14', 'PB.13', 'PB.12', 'X32_OUT', 'X32_IN', 'PA.11', 'PA.10',
		'PA.9', 'PA.8', 'PD.8', 'PD.9', 'PD.10', 'PD.11', 'PD.12', 'PD.13', 'PB.4', 'PB.5',
		'PB.6', 'PB.7', 'LDO_CAP', 'VDD', 'VSS',
		'PE.12', 'PE.11', 'PE.10', 'PE.9', 'PE.8', 'PE.7', 'PB.0', 'PB.1', 'PB.2', 'PB.3',
		'PD.6', 'PD.7', 'PD.14', 'PD.15', 'PC.5', 'PC.4', 'PC.3', 'PC.2', 'PC.1', 'PC.0',
		'PE.6', 'PE.5', 'PB.11', 'PB.10', 'PB.9',
		'PE.4', 'PE.3', 'PE.2', 'PE.1', 'PE.0', 'PC.13', 'PC.12', 'PC.11', 'PC.10', 'PC.9',
		'PC.8', 'PA.15', 'PA.14', 'PA.13', 'PA.12', 'PF.0', 'PF.1', 'VDD', 'VSS', 'AVSS',
		'PA.0', 'PA.1', 'PA.2', 'PA.3', 'PA.4',
		'PA.5', 'PA.6', 'PA.7', 'VREF', 'AVDD', 'PD.0', 'PD.1', 'PD.2', 'PD.3', 'PD.4',
		'PD.5', 'PC.7', 'PC.6', 'PC.15', 'PC.14', 'PB.15', 'XT1_OUT', 'XT1_IN', 'nRESET', 'VSS',
		'VDD', 'PF.4', 'PF.5', 'PVSS', 'PB.8'
	],
	"LQFP64(NANO100)": [
		'PB.14', 'PB.13', 'PB.12', 'X32_OUT', 'X32_IN', 'PA.11', 'PA.10', 'PA.9', 'PA.8', 'PB.4',
		'PB.5', 'PB.6', 'PB.7', 'LDO_CAP', 'VDD', 'VSS',
		'PB.0', 'PB.1', 'PB.2', 'PB.3', 'PD.6', 'PD.7', 'PD.14', 'PD.15', 'PC.3', 'PC.2',
		'PC.1', 'PC.0', 'PE.5', 'PB.11', 'PB.10', 'PB.9',
		'PC.11', 'PC.10', 'PC.9', 'PC.8', 'PA.15', 'PA.14', 'PA.13', 'PA.12', 'PF.0', 'PF.1',
		'AVSS', 'PA.0', 'PA.1', 'PA.2', 'PA.3', 'PA.4',
		'PA.5', 'PA.6', 'PA.7', 'AVDD', 'PC.7', 'PC.6', 'PC.15', 'PC.14', 'PB.15', 'XT1_OUT',
		'XT1_IN', 'nRESET', 'VSS', 'VDD', 'PVSS', 'PB.8'
	],
	"LQFP48(NANO100)": [
		'PB.12', 'X32_OUT', 'X32_IN', 'PA.11', 'PA.10', 'PA.9', 'PA.8', 'PB.4', 'PB.5', 'LDO_CAP',
		'VDD', 'VSS',
		'PB.0', 'PB.1', 'PB.2', 'PB.3', 'PC.3', 'PC.2', 'PC.1', 'PC.0', 'PE.5', 'PB.11',
		'PB.10', 'PB.9',
		'PA.15', 'PA.14', 'PA.13', 'PA.12', 'PF.0', 'PF.1', 'AVSS', 'PA.0', 'PA.1', 'PA.2',
		'PA.3', 'PA.4',
		'PA.5', 'PA.6', 'PA.7', 'AVDD', 'PC.7', 'PC.6', 'PB.15', 'XT1_OUT', 'XT1_IN', 'nRESET',
		'PVSS', 'PB.8'
	],
	"QFN33(NANO100)": [
		'X32_IN', 'PA.11', 'PA.10', 'PA.9', 'PA.8', 'LDO_CAP', 'VDD', 'VSS',
		'PB.0', 'PB.1', 'PB.2', 'PB.3', 'PC.3', 'PC.2', 'PC.1', 'PC.0',
		'PA.15', 'PA.14', 'PF.0', 'PF.1', 'PA.0', 'PA.2', 'PA.3', 'PA.4',
		'PA.5', 'AVDD', 'PC.6', 'PB.15', 'XT1_OUT', 'XT1_IN', 'nRESET', 'X32_OUT',
		'VSS'
	],
	"LQFP100(NANO120)": [
		'PE.15', 'PE.14', 'PE.13', 'PB.14', 'PB.13', 'PB.12', 'X32_OUT', 'X32_IN', 'PA.11', 'PA.10',
		'PA.9', 'PA.8', 'PD.8', 'PD.9', 'PD.10', 'PD.11', 'PD.12', 'PD.13', 'PB.4', 'PB.5',
		'PB.6', 'PB.7', 'LDO_CAP', 'VDD', 'VSS',
		'PE.8', 'PE.7', 'USB_VBUS', 'USB_VDD33_CAP', 'USB_D-', 'USB_D+', 'PB.0', 'PB.1', 'PB.2', 'PB.3',
		'PD.6', 'PD.7', 'PD.14', 'PD.15', 'PC.5', 'PC.4', 'PC.3', 'PC.2', 'PC.1', 'PC.0',
		'PE.6', 'PE.5', 'PB.11', 'PB.10', 'PB.9',
		'PE.4', 'PE.3', 'PE.2', 'PE.1', 'PE.0', 'PC.13', 'PC.12', 'PC.11', 'PC.10', 'PC.9',
		'PC.8', 'PA.15', 'PA.14', 'PA.13', 'PA.12', 'PF.0', 'PF.1', 'VDD', 'VSS', 'AVSS',
		'PA.0', 'PA.1', 'PA.2', 'PA.3', 'PA.4',
		'PA.5', 'PA.6', 'PA.7', 'VREF', 'AVDD', 'PD.0', 'PD.1', 'PD.2', 'PD.3', 'PD.4',
		'PD.5', 'PC.7', 'PC.6', 'PC.15', 'PC.14', 'PB.15', 'XT1_OUT', 'XT1_IN', 'nRESET', 'VSS',
		'VDD', 'PF.4', 'PF.5', 'PVSS', 'PB.8'
	],
	"LQFP64(NANO120)": [
		'PB.14', 'PB.13', 'PB.12', 'X32_OUT', 'X32_IN', 'PA.11', 'PA.10', 'PA.9', 'PA.8', 'PB.4',
		'PB.5', 'PB.6', 'PB.7', 'LDO_CAP', 'VDD', 'VSS',
		'USB_VBUS', 'USB_VDD33_CAP', 'USB_D-', 'USB_D+', 'PB.0', 'PB.1', 'PB.2', 'PB.3', 'PC.3', 'PC.2',
		'PC.1', 'PC.0', 'PE.5', 'PB.11', 'PB.10', 'PB.9',
		'PC.11', 'PC.10', 'PC.9', 'PC.8', 'PA.15', 'PA.14', 'PA.13', 'PA.12', 'PF.0', 'PF.1',
		'AVSS', 'PA.0', 'PA.1', 'PA.2', 'PA.3', 'PA.4',
		'PA.5', 'PA.6', 'PA.7', 'AVDD', 'PC.7', 'PC.6', 'PC.15', 'PC.14', 'PB.15', 'XT1_OUT',
		'XT1_IN', 'nRESET', 'VSS', 'VDD', 'PVSS', 'PB.8'
	],
	"LQFP48(NANO120)": [
		'PB.12', 'X32_OUT', 'X32_IN', 'PA.11', 'PA.10', 'PA.9', 'PA.8', 'PB.4', 'PB.5', 'LDO_CAP',
		'VDD', 'VSS',
		'USB_VBUS', 'USB_VDD33_CAP', 'USB_D-', 'USB_D+', 'PB.0', 'PB.1', 'PB.2', 'PB.3', 'PC.3', 'PC.2',
		'PC.1', 'PC.0',
		'PA.15', 'PA.14', 'PA.13', 'PA.12', 'PF.0', 'PF.1', 'AVSS', 'PA.0', 'PA.1', 'PA.2',
		'PA.3', 'PA.4',
		'PA.5', 'PA.6', 'PA.7', 'AVDD', 'PC.7', 'PC.6', 'PB.15', 'XT1_OUT', 'XT1_IN', 'nRESET',
		'PVSS', 'PB.8'
	],
	"QFN33(NANO120)": [
		'PA.11', 'PA.10', 'PA.9', 'PA.8', 'PB.4', 'LDO_CAP', 'VDD', 'VSS',
		'USB_VBUS', 'USB_VDD33_CAP', 'USB_D-', 'USB_D+', 'PC.3', 'PC.2', 'PC.1', 'PC.0',
		'PA.15', 'PA.14', 'PF.0', 'PF.1', 'PA.0', 'PA.2', 'PA.3', 'PA.4',
		'PA.5', 'AVDD', 'PC.6', 'PB.15', 'XT1_OUT', 'XT1_IN', 'nRESET', 'PVSS'
	]
};

NUTOOL_PIN.g_cfg_gpios = [
	{ f: ['PA.0:0', 'ADC0:1'] },
	{ f: ['PA.1:0', 'ADC1:1', 'AD12:2'] },
	{ f: ['PA.2:0', 'ADC2:1', 'AD11:2', 'RX1:5'] },
	{ f: ['PA.3:0', 'ADC3:1', 'AD10:2', 'TX1:5'] },
	{ f: ['PA.4:0', 'ADC4:1', 'AD9:2', 'I2C0SDA:5'] },
	{ f: ['PA.5:0', 'ADC5:1', 'AD8:2', 'I2C0SCK:5'] },
	{ f: ['PA.6:0', 'ADC6:1', 'AD7:2', 'TC3:3', 'PWM0CH3:5'] },
	{ f: ['PA.7:0', 'ADC7:1', 'AD6:2', 'TC2:3', 'PWM0CH2:5'] },
	{ f: ['PA.8:0', 'I2C0SDA:1', 'SC0CLK:3', 'SPISS20:4'] },
	{ f: ['PA.9:0', 'I2C0SCL:1', 'SC0DAT:3', 'SPICLK2:4'] },
	{ f: ['PA.10:0', 'I2C1SDA:1', 'nWR:2', 'SC0PWR:3', 'MISO20:4'] },
	{ f: ['PA.11:0', 'I2C1SCK:1', 'nRD:2', 'SC0RST:3', 'MOSI20:4'] },
	{ f: ['PA.12:0', 'PWM0CH0:1', 'AD13:2', 'TC0:3', 'I2C0SDA:5'] },
	{ f: ['PA.13:0', 'PWM0CH1:1', 'AD14:2', 'TC1:3', 'I2C0SCK:5'] },
	{ f: ['PA.14:0', 'PWM0CH2:1', 'AD15:2', 'TC2:3', 'RX0:6'] },
	{ f: ['PA.15:0', 'PWM0CH3:1', 'I2SMCLK:2', 'TC3:3', 'TX0:6'] },

	{ f: ['PB.0:0', 'RX0:1', 'MOSI10:3'] },
	{ f: ['PB.1:0', 'TX0:1', 'MISO10:3'] },
	{ f: ['PB.2:0', 'RTSn0:1', 'nWRL:2', 'SPICLK1:3'] },
	{ f: ['PB.3:0', 'CTSn0:1', 'nWRH:2', 'SPISS10:3'] },
	{ f: ['PB.4:0', 'RX1:1', 'SC0CD:3', 'SPISS20:4'] },
	{ f: ['PB.5:0', 'TX1:1', 'SPICLK2:4'] },
	{ f: ['PB.6:0', 'RTSn1:1', 'ALE:2', 'MISO20:4'] },
	{ f: ['PB.7:0', 'CTSn1:1', 'nCS:2', 'MOSI20:4'] },
	{ f: ['PB.8:0', 'ADCTRG:1', 'TMR0:2', 'nINT0:3'] },
	{ f: ['PB.9:0', 'SPISS11:1', 'TMR1:2', 'nINT0:5'] },
	{ f: ['PB.10:0', 'SPISS01:1', 'TMR2:2', 'MOSI00:5'] },
	{ f: ['PB.11:0', 'TMR3:1', 'PWM1CH0:2', 'MISO00:5'] },
	{ f: ['PB.12:0', 'AD0:2', 'CLKO:4'] },
	{ f: ['PB.13:0', 'AD1:2'] },
	{ f: ['PB.14:0', 'nINT0:1', 'SPISS21:4'] },
	{ f: ['PB.15:0', 'nINT1:1', 'SNOOPER:3'] },

	{ f: ['PC.0:0', 'SPISS00:1', 'I2SLRCLK:2', 'SC1CLK:4'] },
	{ f: ['PC.1:0', 'SPICLK0:1', 'I2SBCLK:2', 'SC1DAT:4'] },
	{ f: ['PC.2:0', 'MISO00:1', 'I2SDI:2', 'SC1PWR:4'] },
	{ f: ['PC.3:0', 'MOSI00:1', 'I2SDO:2', 'SC1RST:4'] },
	{ f: ['PC.4:0', 'MISO01:1'] },
	{ f: ['PC.5:0', 'MOSI01:1'] },
	{ f: ['PC.6:0', 'AD4:2', 'TC0:3', 'SC1CD:4', 'PWM0CH0:5'] },
	{ f: ['PC.7:0', 'AD5:2', 'TC1:3', 'PWM0CH1:5'] },
	{ f: ['PC.8:0', 'SPISS10:1', 'MCLK:2', 'I2C1SDA:5'] },
	{ f: ['PC.9:0', 'SPICLK1:1', 'I2C1SCK:5'] },
	{ f: ['PC.10:0', 'MISO10:1', 'RX1:5'] },
	{ f: ['PC.11:0', 'MOSI10:1', 'TX1:5'] },
	{ f: ['PC.12:0', 'MISO11:1', 'PWM1CH0:2', 'nINT0:5', 'I2C0SDA:6'] },
	{ f: ['PC.13:0', 'MOSI11:1', 'PWM1CH1:2', 'SNOOPER:4', 'nINT1:5', 'I2C0SCK:6'] },
	{ f: ['PC.14:0', 'AD2:2', 'PWM1CH3:4'] },
	{ f: ['PC.15:0', 'AD3:2', 'TC0:3', 'PWM1CH2:4'] },

	{ f: ['PD.0:0', 'RX1:1', 'SPISS20:3', 'SC1CLK:4'] },
	{ f: ['PD.1:0', 'TX1:1', 'SPICLK2:3', 'SC1DAT:4'] },
	{ f: ['PD.2:0', 'RTSn1:1', 'I2SLRCLK:2', 'MISO20:3', 'SC1PWR:4'] },
	{ f: ['PD.3:0', 'CTSn1:1', 'I2SBCLK:2', 'MOSI20:3', 'SC1RST:4'] },
	{ f: ['PD.4:0', 'I2SDI:2', 'MISO21:3', 'SC1CD:4'] },
	{ f: ['PD.5:0', 'I2SDO:2', 'MOSI21:3'] },
	{ f: ['PD.6:0'] },
	{ f: ['PD.7:0'] },
	{ f: ['PD.8:0'] },
	{ f: ['PD.9:0'] },
	{ f: ['PD.10:0'] },
	{ f: ['PD.11:0'] },
	{ f: ['PD.12:0'] },
	{ f: ['PD.13:0'] },
	{ f: ['PD.14:0'] },
	{ f: ['PD.15:0'] },

	{ f: ['PE.0:0', 'PWM1CH2:1', 'I2SMCLK:2'] },
	{ f: ['PE.1:0', 'PWM1CH3:1', 'SPISS00:6'] },
	{ f: ['PE.2:0', 'SPICLK0:6'] },
	{ f: ['PE.3:0', 'MISO00:6'] },
	{ f: ['PE.4:0', 'MOSI00:6'] },
	{ f: ['PE.5:0', 'PWM1CH1:1'] },
	{ f: ['PE.6:0'] },
	{ f: ['PE.7:0'] },
	{ f: ['PE.8:0'] },
	{ f: ['PE.9:0'] },
	{ f: ['PE.10:0'] },
	{ f: ['PE.11:0'] },
	{ f: ['PE.12:0'] },
	{ f: ['PE.13:0'] },
	{ f: ['PE.14:0'] },
	{ f: ['PE.15:0'] },

	{ f: ['PF.0:0', 'nINT0:5', 'ICE_DAT:7'] },
	{ f: ['PF.1:0', 'CLKO:4', 'nINT1:5', 'ICE_CK:7'] },
	{ f: ['PF.2:0'] },
	{ f: ['PF.3:0'] },
	{ f: ['PF.4:0', 'I2C0SDA:1'] },
	{ f: ['PF.5:0', 'I2C0SCK:1'] }
];

NUTOOL_PIN.g_cfg_gpiosDefines = [
	{ f: ['PA.0', 'ADC0:SYS_PA_L_MFP_PA0_MFP_ADC_CH0@PA_L_MFP'] },
	{ f: ['PA.1', 'ADC1:SYS_PA_L_MFP_PA1_MFP_ADC_CH1@PA_L_MFP', 'AD12:SYS_PA_L_MFP_PA1_MFP_EBI_AD12@PA_L_MFP'] },
	{ f: ['PA.2', 'ADC2:SYS_PA_L_MFP_PA2_MFP_ADC_CH2@PA_L_MFP', 'AD11:SYS_PA_L_MFP_PA2_MFP_EBI_AD11@PA_L_MFP', 'RX1:SYS_PA_L_MFP_PA2_MFP_UART1_RX@PA_L_MFP'] },
	{ f: ['PA.3', 'ADC3:SYS_PA_L_MFP_PA3_MFP_ADC_CH3@PA_L_MFP', 'AD10:SYS_PA_L_MFP_PA3_MFP_EBI_AD10@PA_L_MFP', 'TX1:SYS_PA_L_MFP_PA3_MFP_UART1_TX@PA_L_MFP'] },
	{ f: ['PA.4', 'ADC4:SYS_PA_L_MFP_PA4_MFP_ADC_CH4@PA_L_MFP', 'AD9:SYS_PA_L_MFP_PA4_MFP_EBI_AD9@PA_L_MFP', 'I2C0SDA:SYS_PA_L_MFP_PA4_MFP_I2C0_SDA@PA_L_MFP'] },
	{ f: ['PA.5', 'ADC5:SYS_PA_L_MFP_PA5_MFP_ADC_CH5@PA_L_MFP', 'AD8:SYS_PA_L_MFP_PA5_MFP_EBI_AD8@PA_L_MFP', 'I2C0SCK:SYS_PA_L_MFP_PA5_MFP_I2C0_SCL@PA_L_MFP'] },
	{ f: ['PA.6', 'ADC6:SYS_PA_L_MFP_PA6_MFP_ADC_CH6@PA_L_MFP', 'AD7:SYS_PA_L_MFP_PA6_MFP_EBI_AD7@PA_L_MFP', 'TC3:SYS_PA_L_MFP_PA6_MFP_TMR3_CAP@PA_L_MFP', 'PWM0CH3:SYS_PA_L_MFP_PA6_MFP_PWM0_CH3@PA_L_MFP'] },
	{ f: ['PA.7', 'ADC7:SYS_PA_L_MFP_PA7_MFP_ADC_CH7@PA_L_MFP', 'AD6:SYS_PA_L_MFP_PA7_MFP_EBI_AD6@PA_L_MFP', 'TC2:SYS_PA_L_MFP_PA7_MFP_TMR2_CAP@PA_L_MFP', 'PWM0CH2:SYS_PA_L_MFP_PA7_MFP_PWM0_CH2@PA_L_MFP'] },
	{ f: ['PA.8', 'I2C0SDA:SYS_PA_H_MFP_PA8_MFP_I2C0_SDA@PA_H_MFP', 'SC0CLK:SYS_PA_H_MFP_PA8_MFP_SC0_CLK@PA_H_MFP', 'SPISS20:SYS_PA_H_MFP_PA8_MFP_SPI2_SS0@PA_H_MFP'] },
	{ f: ['PA.9', 'I2C0SCL:SYS_PA_H_MFP_PA9_MFP_I2C0_SCL@PA_H_MFP', 'SC0DAT:SYS_PA_H_MFP_PA9_MFP_SC0_DAT@PA_H_MFP', 'SPICLK2:SYS_PA_H_MFP_PA9_MFP_SPI2_SCLK@PA_H_MFP'] },
	{ f: ['PA.10', 'I2C1SDA:SYS_PA_H_MFP_PA10_MFP_I2C1_SDA@PA_H_MFP', 'nWR:SYS_PA_H_MFP_PA10_MFP_EBI_NWE@PA_H_MFP', 'SC0PWR:SYS_PA_H_MFP_PA10_MFP_SC0_PWR@PA_H_MFP', 'MISO20:SYS_PA_H_MFP_PA10_MFP_SPI2_MISO0@PA_H_MFP'] },
	{ f: ['PA.11', 'I2C1SCK:SYS_PA_H_MFP_PA11_MFP_I2C1_SCL@PA_H_MFP', 'nRD:SYS_PA_H_MFP_PA11_MFP_EBI_NRE@PA_H_MFP', 'SC0RST:SYS_PA_H_MFP_PA11_MFP_SC0_RST@PA_H_MFP', 'MOSI20:SYS_PA_H_MFP_PA11_MFP_SPI2_MOSI0@PA_H_MFP'] },
	{ f: ['PA.12', 'PWM0CH0:SYS_PA_H_MFP_PA12_MFP_PWM0_CH0@PA_H_MFP', 'AD13:SYS_PA_H_MFP_PA12_MFP_EBI_AD13@PA_H_MFP', 'TC0:SYS_PA_H_MFP_PA12_MFP_TMR0_CAP@PA_H_MFP', 'I2C0SDA:SYS_PA_H_MFP_PA12_MFP_I2C0_SDA@PA_H_MFP'] },
	{ f: ['PA.13', 'PWM0CH1:SYS_PA_H_MFP_PA13_MFP_PWM0_CH1@PA_H_MFP', 'AD14:SYS_PA_H_MFP_PA13_MFP_EBI_AD14@PA_H_MFP', 'TC1:SYS_PA_H_MFP_PA13_MFP_TMR1_CAP@PA_H_MFP', 'I2C0SCK:SYS_PA_H_MFP_PA13_MFP_I2C0_SCL@PA_H_MFP'] },
	{ f: ['PA.14', 'PWM0CH2:SYS_PA_H_MFP_PA14_MFP_PWM0_CH2@PA_H_MFP', 'AD15:SYS_PA_H_MFP_PA14_MFP_EBI_AD15@PA_H_MFP', 'TC2:SYS_PA_H_MFP_PA14_MFP_TMR2_CAP@PA_H_MFP', 'RX0:SYS_PA_H_MFP_PA14_MFP_UART0_RX@PA_H_MFP'] },
	{ f: ['PA.15', 'PWM0CH3:SYS_PA_H_MFP_PA15_MFP_PWM0_CH3@PA_H_MFP', 'I2SMCLK:SYS_PA_H_MFP_PA15_MFP_I2S_MCLK@PA_H_MFP', 'TC3:SYS_PA_H_MFP_PA15_MFP_TMR3_CAP@PA_H_MFP', 'TX0:SYS_PA_H_MFP_PA15_MFP_UART0_TX@PA_H_MFP'] },

	{ f: ['PB.0', 'RX0:SYS_PB_L_MFP_PB0_MFP_UART0_RX@PB_L_MFP', 'MOSI10:SYS_PB_L_MFP_PB0_MFP_SPI1_MOSI0@PB_L_MFP'] },
	{ f: ['PB.1', 'TX0:SYS_PB_L_MFP_PB1_MFP_UART0_TX@PB_L_MFP', 'MISO10:SYS_PB_L_MFP_PB1_MFP_SPI1_MISO0@PB_L_MFP'] },
	{ f: ['PB.2', 'RTSn0:SYS_PB_L_MFP_PB2_MFP_UART0_RTS@PB_L_MFP', 'nWRL:SYS_PB_L_MFP_PB2_MFP_EBI_NWRL@PB_L_MFP', 'SPICLK1:SYS_PB_L_MFP_PB2_MFP_SPI1_SCLK@PB_L_MFP'] },
	{ f: ['PB.3', 'CTSn0:SYS_PB_L_MFP_PB3_MFP_UART0_CTS@PB_L_MFP', 'nWRH:SYS_PB_L_MFP_PB3_MFP_EBI_NWRH@PB_L_MFP', 'SPISS10:SYS_PB_L_MFP_PB3_MFP_SPI1_SS0@PB_L_MFP'] },
	{ f: ['PB.4', 'RX1:SYS_PB_L_MFP_PB4_MFP_UART1_RX@PB_L_MFP', 'SC0CD:SYS_PB_L_MFP_PB4_MFP_SC0_CD@PB_L_MFP', 'SPISS20:SYS_PB_L_MFP_PB4_MFP_SPI2_SS0@PB_L_MFP'] },
	{ f: ['PB.5', 'TX1:SYS_PB_L_MFP_PB5_MFP_UART1_TX@PB_L_MFP', 'SPICLK2:SYS_PB_L_MFP_PB5_MFP_SPI2_SCLK@PB_L_MFP'] },
	{ f: ['PB.6', 'RTSn1:SYS_PB_L_MFP_PB6_MFP_UART1_RTS@PB_L_MFP', 'ALE:SYS_PB_L_MFP_PB6_MFP_EBI_ALE@PB_L_MFP', 'MISO20:SYS_PB_L_MFP_PB6_MFP_SPI2_MISO0@PB_L_MFP'] },
	{ f: ['PB.7', 'CTSn1:SYS_PB_L_MFP_PB7_MFP_UART1_CTS@PB_L_MFP', 'nCS:SYS_PB_L_MFP_PB7_MFP_EBI_NCS@PB_L_MFP', 'MOSI20:SYS_PB_L_MFP_PB7_MFP_SPI2_MOSI0@PB_L_MFP'] },
	{ f: ['PB.8', 'ADCTRG:SYS_PB_H_MFP_PB8_MFP_ADC_EXT@PB_H_MFP', 'TMR0:SYS_PB_H_MFP_PB8_MFP_TMR0_EXT@PB_H_MFP', 'TMR0_TOGGLE_OUT:SYS_PB_H_MFP_PB8_MFP_TMR0_TOGGLE_OUT@PB_H_MFP', 'nINT0:SYS_PB_H_MFP_PB8_MFP_EXT_INT0@PB_H_MFP'] },
	{ f: ['PB.9', 'SPISS11:SYS_PB_H_MFP_PB9_MFP_SPI1_SS1@PB_H_MFP', 'TMR1:SYS_PB_H_MFP_PB9_MFP_TMR1_EXT@PB_H_MFP', 'TMR1_TOGGLE_OUT:SYS_PB_H_MFP_PB9_MFP_TMR1_TOGGLE_OUT@PB_H_MFP', 'nINT0:SYS_PB_H_MFP_PB9_MFP_EXT_INT0@PB_H_MFP'] },
	{ f: ['PB.10', 'SPISS01:SYS_PB_H_MFP_PB10_MFP_SPI0_SS1@PB_H_MFP', 'TMR2:SYS_PB_H_MFP_PB10_MFP_TMR2_EXT@PB_H_MFP', 'TMR2_TOGGLE_OUT:SYS_PB_H_MFP_PB10_MFP_TMR2_TOGGLE_OUT@PB_H_MFP', 'MOSI00:SYS_PB_H_MFP_PB10_MFP_SPI0_MOSI0@PB_H_MFP'] },
	{ f: ['PB.11', 'PWM1CH0:SYS_PB_H_MFP_PB11_MFP_PWM1_CH0@PB_H_MFP', 'TMR3:SYS_PB_H_MFP_PB11_MFP_TMR3_EXT@PB_H_MFP', 'TMR3_TOGGLE_OUT:SYS_PB_H_MFP_PB11_MFP_TMR3_TOGGLE_OUT@PB_H_MFP', 'MISO00:SYS_PB_H_MFP_PB11_MFP_SPI0_MISO0@PB_H_MFP'] },
	{ f: ['PB.12', 'AD0:SYS_PB_H_MFP_PB12_MFP_EBI_AD0@PB_H_MFP', 'CLKO:SYS_PB_H_MFP_PB12_MFP_CKO@PB_H_MFP'] },
	{ f: ['PB.13', 'AD1:SYS_PB_H_MFP_PB13_MFP_EBI_AD1@PB_H_MFP'] },
	{ f: ['PB.14', 'nINT0:SYS_PB_H_MFP_PB14_MFP_EXT_INT0@PB_H_MFP', 'SPISS21:SYS_PB_H_MFP_PB14_MFP_SPI2_SS1@PB_H_MFP'] },
	{ f: ['PB.15', 'nINT1:SYS_PB_H_MFP_PB15_MFP_EXT_INT1@PB_H_MFP', 'SNOOPER:SYS_PB_H_MFP_PB15_MFP_SNOOPER@PB_H_MFP'] },

	{ f: ['PC.0', 'SPISS00:SYS_PC_L_MFP_PC0_MFP_SPI0_SS0@PC_L_MFP', 'I2SLRCLK:SYS_PC_L_MFP_PC0_MFP_I2S_WS@PC_L_MFP', 'SC1CLK:SYS_PC_L_MFP_PC0_MFP_SC1_CLK@PC_L_MFP'] },
	{ f: ['PC.1', 'SPICLK0:SYS_PC_L_MFP_PC1_MFP_SPI0_SCLK@PC_L_MFP', 'I2SBCLK:SYS_PC_L_MFP_PC1_MFP_I2S_BCLK@PC_L_MFP', 'SC1DAT:SYS_PC_L_MFP_PC1_MFP_SC1_DAT@PC_L_MFP'] },
	{ f: ['PC.2', 'MISO00:SYS_PC_L_MFP_PC2_MFP_SPI0_MISO0@PC_L_MFP', 'I2SDI:SYS_PC_L_MFP_PC2_MFP_I2S_DIN@PC_L_MFP', 'SC1PWR:SYS_PC_L_MFP_PC2_MFP_SC1_PWR@PC_L_MFP'] },
	{ f: ['PC.3', 'MOSI00:SYS_PC_L_MFP_PC3_MFP_SPI0_MOSI0@PC_L_MFP', 'I2SDO:SYS_PC_L_MFP_PC3_MFP_I2S_DOUT@PC_L_MFP', 'SC1RST:SYS_PC_L_MFP_PC3_MFP_SC1_RST@PC_L_MFP'] },
	{ f: ['PC.4', 'MISO01:SYS_PC_L_MFP_PC4_MFP_SPI0_MISO1@PC_L_MFP'] },
	{ f: ['PC.5', 'MOSI01:SYS_PC_L_MFP_PC5_MFP_SPI0_MOSI1@PC_L_MFP'] },
	{ f: ['PC.6', 'DAC0OUT:SYS_PC_L_MFP_PC6_MFP_DA_OUT0@PC_L_MFP', 'AD4:SYS_PC_L_MFP_PC6_MFP_EBI_AD4@PC_L_MFP', 'TC0:SYS_PC_L_MFP_PC6_MFP_TMR0_CAP@PC_L_MFP', 'SC1CD:SYS_PC_L_MFP_PC6_MFP_SC1_CD@PC_L_MFP', 'PWM0CH0:SYS_PC_L_MFP_PC6_MFP_PWM0_CH0@PC_L_MFP'] },
	{ f: ['PC.7', 'DAC1OUT:SYS_PC_L_MFP_PC7_MFP_DA_OUT1@PC_L_MFP', 'AD5:SYS_PC_L_MFP_PC7_MFP_EBI_AD5@PC_L_MFP', 'TC1:SYS_PC_L_MFP_PC7_MFP_TMR1_CAP@PC_L_MFP', 'PWM0CH1:SYS_PC_L_MFP_PC7_MFP_PWM0_CH1@PC_L_MFP'] },
	{ f: ['PC.8', 'SPISS10:SYS_PC_H_MFP_PC8_MFP_SPI1_SS0@PC_H_MFP', 'MCLK:SYS_PC_H_MFP_PC8_MFP_EBI_XCLK@PC_H_MFP', 'I2C1SDA:SYS_PC_H_MFP_PC8_MFP_I2C1_SDA@PC_H_MFP'] },
	{ f: ['PC.9', 'SPICLK1:SYS_PC_H_MFP_PC9_MFP_SPI1_SCLK@PC_H_MFP', 'I2C1SCK:SYS_PC_H_MFP_PC9_MFP_I2C1_SCL@PC_H_MFP'] },
	{ f: ['PC.10', 'MISO10:SYS_PC_H_MFP_PC10_MFP_SPI1_MISO0@PC_H_MFP', 'RX1:SYS_PC_H_MFP_PC10_MFP_UART1_RX@PC_H_MFP'] },
	{ f: ['PC.11', 'MOSI10:SYS_PC_H_MFP_PC11_MFP_SPI1_MOSI0@PC_H_MFP', 'TX1:SYS_PC_H_MFP_PC11_MFP_UART1_TX@PC_H_MFP'] },
	{ f: ['PC.12', 'MISO11:SYS_PC_H_MFP_PC12_MFP_SPI1_MISO1@PC_H_MFP', 'PWM1CH0:SYS_PC_H_MFP_PC12_MFP_PWM1_CH0@PC_H_MFP', 'nINT0:SYS_PC_H_MFP_PC12_MFP_EXT_INT0@PC_H_MFP', 'I2C0SDA:SYS_PC_H_MFP_PC12_MFP_I2C0_SDA@PC_H_MFP'] },
	{ f: ['PC.13', 'MOSI11:SYS_PC_H_MFP_PC13_MFP_SPI1_MOSI1@PC_H_MFP', 'PWM1CH1:SYS_PC_H_MFP_PC13_MFP_PWM1_CH1@PC_H_MFP', 'SNOOPER:SYS_PC_H_MFP_PC13_MFP_SNOOPER@PC_H_MFP', 'nINT1:SYS_PC_H_MFP_PC13_MFP_EXT_INT1@PC_H_MFP', 'I2C0SCK:SYS_PC_H_MFP_PC13_MFP_I2C0_SCL@PC_H_MFP'] },
	{ f: ['PC.14', 'AD2:SYS_PC_H_MFP_PC14_MFP_EBI_AD2@PC_H_MFP', 'PWM1CH3:SYS_PC_H_MFP_PC14_MFP_PWM1_CH3@PC_H_MFP'] },
	{ f: ['PC.15', 'AD3:SYS_PC_H_MFP_PC15_MFP_EBI_AD3@PC_H_MFP', 'TC0:SYS_PC_H_MFP_PC15_MFP_TMR0_CAP@PC_H_MFP', 'PWM1CH2:SYS_PC_H_MFP_PC15_MFP_PWM1_CH2@PC_H_MFP'] },

	{ f: ['PD.0', 'RX1:SYS_PD_L_MFP_PD0_MFP_UART1_RX@PD_L_MFP', 'SPISS20:SYS_PD_L_MFP_PD0_MFP_SPI2_SS0@PD_L_MFP', 'SC1CLK:SYS_PD_L_MFP_PD0_MFP_SC1_CLK@PD_L_MFP'] },
	{ f: ['PD.1', 'TX1:SYS_PD_L_MFP_PD1_MFP_UART1_TX@PD_L_MFP', 'SPICLK2:SYS_PD_L_MFP_PD1_MFP_SPI2_SCLK@PD_L_MFP', 'SC1DAT:SYS_PD_L_MFP_PD1_MFP_SC1_DAT@PD_L_MFP'] },
	{ f: ['PD.2', 'RTSn1:SYS_PD_L_MFP_PD2_MFP_UART1_RTS@PD_L_MFP', 'I2SLRCLK:SYS_PD_L_MFP_PD2_MFP_I2S_WS@PD_L_MFP', 'MISO20:SYS_PD_L_MFP_PD2_MFP_SPI2_MISO0@PD_L_MFP', 'SC1PWR:SYS_PD_L_MFP_PD2_MFP_SC1_PWR@PD_L_MFP', 'ADC10:SYS_PD_L_MFP_PD2_MFP_ADC_CH10@PD_L_MFP'] },
	{ f: ['PD.3', 'CTSn1:SYS_PD_L_MFP_PD3_MFP_UART1_CTS@PD_L_MFP', 'I2SBCLK:SYS_PD_L_MFP_PD3_MFP_I2S_BCLK@PD_L_MFP', 'MOSI20:SYS_PD_L_MFP_PD3_MFP_SPI2_MOSI0@PD_L_MFP', 'SC1RST:SYS_PD_L_MFP_PD3_MFP_SC1_RST@PD_L_MFP', 'ADC11:SYS_PD_L_MFP_PD3_MFP_ADC_CH11@PD_L_MFP'] },
	{ f: ['PD.4', 'I2SDI:SYS_PD_L_MFP_PD4_MFP_I2S_DIN@PD_L_MFP', 'MISO21:SYS_PD_L_MFP_PD4_MFP_SPI2_MISO1@PD_L_MFP', 'SC1CD:SYS_PD_L_MFP_PD4_MFP_SC1_CD@PD_L_MFP'] },
	{ f: ['PD.5', 'I2SDO:SYS_PD_L_MFP_PD5_MFP_I2S_DOUT@PD_L_MFP', 'MOSI21:SYS_PD_L_MFP_PD5_MFP_SPI2_MOSI1@PD_L_MFP'] },
	{ f: ['PD.6'] },
	{ f: ['PD.7'] },
	{ f: ['PD.8'] },
	{ f: ['PD.9'] },
	{ f: ['PD.10'] },
	{ f: ['PD.11'] },
	{ f: ['PD.12'] },
	{ f: ['PD.13'] },
	{ f: ['PD.14'] },
	{ f: ['PD.15'] },

	{ f: ['PE.0', 'PWM1CH2:SYS_PE_L_MFP_PE0_MFP_PWM1_CH2@PE_L_MFP', 'I2SMCLK:SYS_PE_L_MFP_PE0_MFP_I2S_MCLK@PE_L_MFP'] },
	{ f: ['PE.1', 'PWM1CH3:SYS_PE_L_MFP_PE1_MFP_PWM1_CH3@PE_L_MFP', 'SPISS00:SYS_PE_L_MFP_PE1_MFP_SPI0_SS0@PE_L_MFP'] },
	{ f: ['PE.2', 'SPICLK0:SYS_PE_L_MFP_PE2_MFP_SPI0_SCLK@PE_L_MFP'] },
	{ f: ['PE.3', 'MISO00:SYS_PE_L_MFP_PE3_MFP_SPI0_MISO0@PE_L_MFP'] },
	{ f: ['PE.4', 'MOSI00:SYS_PE_L_MFP_PE4_MFP_SPI0_MOSI0@PE_L_MFP'] },
	{ f: ['PE.5', 'PWM1CH1:SYS_PE_L_MFP_PE5_MFP_PWM1_CH1@PE_L_MFP'] },
	{ f: ['PE.6'] },
	{ f: ['PE.7'] },
	{ f: ['PE.8'] },
	{ f: ['PE.9'] },
	{ f: ['PE.10'] },
	{ f: ['PE.11'] },
	{ f: ['PE.12'] },
	{ f: ['PE.13'] },
	{ f: ['PE.14'] },
	{ f: ['PE.15'] },

	{ f: ['PF.0', 'nINT0:SYS_PF_L_MFP_PF0_MFP_EXT_INT0@PF_L_MFP', 'ICE_DAT:SYS_PF_L_MFP_PF0_MFP_ICE_DAT@PF_L_MFP'] },
	{ f: ['PF.1', 'CLKO:SYS_PF_L_MFP_PF1_MFP_CKO@PF_L_MFP', 'nINT1:SYS_PF_L_MFP_PF1_MFP_EXT_INT1@PF_L_MFP', 'ICE_CK:SYS_PF_L_MFP_PF1_MFP_ICE_CLK@PF_L_MFP'] },
	{ f: ['PF.2', 'HXT_OUT:SYS_PF_L_MFP_PF2_MFP_HXT_OUT@PF_L_MFP'] },
	{ f: ['PF.3', 'HXT_IN:SYS_PF_L_MFP_PF3_MFP_HXT_IN@PF_L_MFP'] },
	{ f: ['PF.4', 'I2C0SDA:SYS_PF_L_MFP_PF4_MFP_I2C0_SDA@PF_L_MFP'] },
	{ f: ['PF.5', 'I2C0SCK:SYS_PF_L_MFP_PF5_MFP_I2C0_SCL@PF_L_MFP'] }
];

NUTOOL_PIN.g_cfg_gpiosDescriptions = [
	'AD0:EBI Address/Data bus bit0',
	'AD1:EBI Address/Data bus bit1',
	'AD2:EBI Address/Data bus bit2',
	'AD3:EBI Address/Data bus bit3',
	'AD4:EBI Address/Data bus bit4',
	'AD5:EBI Address/Data bus bit5',
	'AD6:EBI Address/Data bus bit6',
	'AD7:EBI Address/Data bus bit7',
	'AD8:EBI Address/Data bus bit8',
	'AD9:EBI Address/Data bus bit9',
	'AD10:EBI Address/Data bus bit10',
	'AD11:EBI Address/Data bus bit11',
	'AD12:EBI Address/Data bus bit12',
	'AD13:EBI Address/Data bus bit13',
	'AD14:EBI Address/Data bus bit14',
	'AD15:EBI Address/Data bus bit15',

	'ADC0:ADC analog input0',
	'ADC1:ADC analog input1',
	'ADC2:ADC analog input2',
	'ADC3:ADC analog input3',
	'ADC4:ADC analog input4',
	'ADC5:ADC analog input5',
	'ADC6:ADC analog input6',
	'ADC7:ADC analog input7',
	'ADCTRG:ADC external trigger input',

	'ALE:EBI address latch enable output pin',

	'AVDD:Power supply for internal analog circuit',
	'AVSS:Ground Pin for analog circuit',

	'CLKO:Frequency Divider output pin',

	'CTSn0:UART0 Clear to Send input pin',
	'CTSn1:UART1 Clear to Send input pin',

	'D-:USB Differential Signal D-',
	'D+:USB Differential Signal D+',

	'I2C0SCK:I2C0 clock pin',
	'I2C0SCL:I2C0 clock pin',
	'I2C0SDA:I2C0 data I/O pin',

	'I2C1SCK:I2C1 clock pin',
	'I2C1SDA:I2C1 data I/O pin',

	'I2SBCLK:I2S bit clock pin',
	'I2SDI:I2S data input',
	'I2SDO:I2S data output',
	'I2SLRCLK:I2S left right channel clock',
	'I2SMCLK:I2S master clock output pin',

	'ICE_CK:Serial Wired Debugger Clock pin',
	'ICE_DAT:Serial Wired Debugger Data pin',

	'LDO:LDO output pin',

	'MCLK:EBI external clock output pin',
	'MISO00:SPI0 1st MISO (Master In, Slave Out) pin',
	'MISO01:SPI0 2nd MISO (Master In, Slave Out) pin',
	'MISO10:SPI1 1st MISO (Master In, Slave Out) pin',
	'MISO11:SPI1 2nd MISO (Master In, Slave Out) pin',
	'MISO20:SPI2 1st MISO (Master In, Slave Out) pin',
	'MISO21:SPI2 2nd MISO (Master In, Slave Out) pin',
	'MOSI00:SPI0 1st MOSI (Master Out, Slave In) pin',
	'MOSI01:SPI0 2nd MOSI (Master Out, Slave In) pin',
	'MOSI10:SPI1 1st MOSI (Master Out, Slave In) pin',
	'MOSI11:SPI1 2nd MOSI (Master Out, Slave In) pin',
	'MOSI20:SPI2 1st MOSI (Master Out, Slave In) pin',
	'MOSI21:SPI2 2nd MOSI (Master Out, Slave In) pin',

	'nCS:EBI chip select enable output pin',
	'nINT0:External interrupt0 input pin',
	'nINT1:External interrupt1 input pin',
	'nRD:EBI read enable output pin',
	'nRESET:External reset input: Low active, set this pin low reset chip to initial state. With internal pull-up',
	'nWR:EBI write enable output pin',
	'nWRH:EBI high byte write enable output pin',
	'nWRL:EBI low byte write enable output pin',

	'PVSS:PLL Ground',

	'PWM0CH0:PWM0 Channel0 output',
	'PWM0CH1:PWM0 Channel1 output',
	'PWM0CH2:PWM0 Channel2 output',
	'PWM0CH3:PWM0 Channel3 output',
	'PWM1CH0:PWM1 Channel0 output',
	'PWM1CH1:PWM1 Channel1 output',
	'PWM1CH2:PWM1 Channel2 output',
	'PWM1CH3:PWM1 Channel3 output',

	'RTSn0:UART0 Request to Send output pin',
	'RTSn1:UART1 Request to Send output pin',
	'RX0:UART0 Data receiver input pin',
	'RX1:UART1 Data receiver input pin',

	'SC0CD:SmartCard0 card detect pin',
	'SC0CLK:SmartCard0 clock pin',
	'SC0DAT:SmartCard0 DATA pin',
	'SC0PWR:SmartCard0 Power pin',
	'SC0RST:SmartCard0 RST pin',
	'SC1CD:SmartCard1 card detect pin',
	'SC1CLK:SmartCard1 clock pin',
	'SC1DAT:SmartCard1 DATA pin',
	'SC1PWR:SmartCard1 Power pin',
	'SC1RST:SmartCard1 RST pin',
	'SNOOPER:Snooper pin',
	'SPICLK0:SPI0 serial clock pin',
	'SPICLK1:SPI1 serial clock pin',
	'SPICLK2:SPI2 serial clock pin',
	'SPISS00:SPI0 1st slave select pin',
	'SPISS01:SPI0 2nd slave select pin',
	'SPISS10:SPI1 1st slave select pin',
	'SPISS11:SPI1 2nd slave select pin',
	'SPISS20:SPI2 1st slave select pin',
	'SPISS21:SPI2 2nd slave select pin',

	'TC0:Timer0 capture input',
	'TC1:Timer1 capture input',
	'TC2:Timer2 capture input',
	'TC3:Timer3 capture input',

	'TMR0:Timer0 external counter input',
	'TMR1:Timer1 external counter input',
	'TMR2:Timer2 external counter input',
	'TMR3:Timer3 external counter input',

	'TX0:UART0 Data transmitter output pin',
	'TX1:UART1 Data transmitter output pin',

	'VBUS:POWER SUPPLY: From USB Host or HUB',
	'VDD:Power supply for I/O ports and LDO source for internal PLL and digital circuit',
	'VDD33:Internal Power Regulator Output 3.3V Decoupling Pin',
	'Vref:Voltage reference input for ADC',
	'VSS :Ground',
	'VSS:Ground',

	'X32I:External 32.768 kHz crystal input pin',
	'X32O:External 32.768 kHz crystal output pin',

	'XT1_IN:External 4~24 MHz crystal input pin',
	'XT1_OUT:External 4~24 MHz crystal output pin'
];

NUTOOL_PIN.g_cfg_regDescriptions = {};
NUTOOL_PIN.g_cfg_regDescriptions.PA_L_MFP = '0x50000030';
NUTOOL_PIN.g_cfg_regDescriptions.PA_H_MFP = '0x50000034';
NUTOOL_PIN.g_cfg_regDescriptions.PB_L_MFP = '0x50000038';
NUTOOL_PIN.g_cfg_regDescriptions.PB_H_MFP = '0x5000003C';
NUTOOL_PIN.g_cfg_regDescriptions.PC_L_MFP = '0x50000040';
NUTOOL_PIN.g_cfg_regDescriptions.PC_H_MFP = '0x50000044';
NUTOOL_PIN.g_cfg_regDescriptions.PD_L_MFP = '0x50000048';
NUTOOL_PIN.g_cfg_regDescriptions.PD_H_MFP = '0x5000004C';
NUTOOL_PIN.g_cfg_regDescriptions.PE_L_MFP = '0x50000050';
NUTOOL_PIN.g_cfg_regDescriptions.PE_H_MFP = '0x50000054';
NUTOOL_PIN.g_cfg_regDescriptions.PF_L_MFP = '0x50000058';

NUTOOL_PIN.g_cfg_gpioMatrix = [];
NUTOOL_PIN.g_cfg_shareBits = [];
NUTOOL_PIN.g_cfg_addGPIO = {};
NUTOOL_PIN.g_cfg_unusedGPIO = {};

NUTOOL_PIN.decidepackageNumber = function (given_partNumber_package) {
	var partNumber_package,
		partNumber;

	if (typeof given_partNumber_package === 'undefined') {
		partNumber_package = NUTOOL_PIN.getg_partNumber_package();
	}
	else {
		partNumber_package = given_partNumber_package;
	}

	NUTOOL_PIN.g_packageNumber = partNumber_package.substring(partNumber_package.indexOf('(') + 1);
	NUTOOL_PIN.g_packageNumber = NUTOOL_PIN.g_packageNumber.substring(0, NUTOOL_PIN.g_packageNumber.indexOf(')'));

	partNumber = partNumber_package.substring(0, partNumber_package.indexOf('('));
	switch (NUTOOL_PIN.g_packageNumber) {
	case 'LQFP100':
		switch (partNumber) {
		case "NANO100VD2AN":
		case "NANO100VD3AN":
			NUTOOL_PIN.g_packageNumberIndex = "LQFP100(NANO100)";
			break;
		default:
			NUTOOL_PIN.g_packageNumberIndex = "LQFP100(NANO120)";
			break;
		}
		break;
	case 'LQFP64':
		switch (partNumber) {
		case "NANO100SC2AN":
		case "NANO100SD2AN":
		case "NANO100SD3AN":
			NUTOOL_PIN.g_packageNumberIndex = "LQFP64(NANO100)";
			break;
		default:
			NUTOOL_PIN.g_packageNumberIndex = "LQFP64(NANO120)";
			break;
		}
		break;
	case 'LQFP48':
		switch (partNumber) {
		case "NANO100LC2AN":
		case "NANO100LD2AN":
		case "NANO100LD3AN":
			NUTOOL_PIN.g_packageNumberIndex = "LQFP48(NANO100)";
			break;
		default:
			NUTOOL_PIN.g_packageNumberIndex = "LQFP48(NANO120)";
			break;
		}
		break;
	case 'QFN33':
		switch (partNumber) {
		case "NANO100ZC2AN":
		case "NANO100ZD2AN":
		case "NANO100ZD3AN":
			NUTOOL_PIN.g_packageNumberIndex = "QFN33(NANO100)";
			break;
		default:
			NUTOOL_PIN.g_packageNumberIndex = "QFN33(NANO120)";
			break;
		}
		break;
	}
	partNumber_package = null;
	partNumber = null;
};
