//chip content
NUTOOL_PIN.g_cfg_chips = [
	// M031
	{ name: "M031FB0AE", pkg: "TSSOP20" },
	{ name: "M031FC1AE", pkg: "TSSOP20" },
	{ name: "M031EB0AE", pkg: "TSSOP28" },
	{ name: "M031EC1AE", pkg: "TSSOP28" },
	{ name: "M031TB0AE", pkg: "QFN33" },
	{ name: "M031TC1AE", pkg: "QFN33" },
	{ name: "M031TD2AE", pkg: "QFN33" },
	{ name: "M031LC2AE", pkg: "LQFP48" },
	{ name: "M031LD2AE", pkg: "LQFP48" },
	{ name: "M031LE3AE", pkg: "LQFP48" },
	{ name: "M032LE3AE", pkg: "ULQFP48" },
	{ name: "M031SC2AE", pkg: "LQFP64" },
	{ name: "M031SD2AE", pkg: "LQFP64" },
	{ name: "M031SE3AE", pkg: "LQFP64" },
	{ name: "M032SE3AE", pkg: "ULQFP64" }
];

NUTOOL_PIN.g_cfg_pkgs = {
	"TSSOP20": [
		'VSS', 'LDO_CAP', 'VDD', 'PB.14', 'PB.13',
		'PB.12', 'AVDD', 'PB.5', 'PB.4', 'PB.3',
		'PB.2', 'PF.3', 'PF.2', 'PA.3', 'PA.2',
		'PA.1', 'PA.0', 'nRESET', 'PF.0', 'PF.1'
	],
	"TSSOP28": [
		'PA.12', 'PA.13', 'PA.14', 'PA.15', 'VSS', 'LDO_CAP', 'VDD',
		'PB.14', 'PB.13', 'PB.12', 'AVDD', 'PB.5', 'PB.4', 'PB.3',
		'PB.2', 'PB.1', 'PB.0', 'PF.3', 'PF.2', 'PA.3', 'PA.2',
		'PA.1', 'PA.0', 'nRESET', 'PF.0', 'PF.1', 'PC.1', 'PC.0'
	],
	"QFN33(4*4)": [
		'PB.5', 'PB.4', 'PB.3', 'PB.2', 'PB.1', 'PB.0', 'PF.5', 'PF.4',
		'PF.3', 'PF.2', 'PA.3', 'PA.2', 'PA.1', 'PA.0', 'PF.15', 'nRESET',
		'PF.0', 'PF.1', 'PC.1', 'PC.0', 'PA.12', 'PA.13', 'PA.14', 'PA.15',
		'VSS', 'LDO_CAP', 'VDD', 'PB.15', 'PB.14', 'PB.13', 'PB.12', 'AVDD'
	],
	"LQFP48(7*7)": [
		'PB.5', 'PB.4', 'PB.3', 'PB.2', 'PB.1', 'PB.0', 'PA.11', 'PA.10', 'PA.9', 'PA.8',
		'PF.5', 'PF.4',
		'PF.3', 'PF.2', 'PA.7', 'PA.6', 'PA.5', 'PA.4', 'PA.3', 'PA.2', 'PA.1', 'PA.0',
		'PF.15', 'nRESET',
		'PF.0', 'PF.1', 'PC.5', 'PC.4', 'PC.3', 'PC.2', 'PC.1', 'PC.0', 'PA.12', 'PA.13',
		'PA.14', 'PA.15',
		'VSS', 'LDO_CAP', 'VDD', 'PC.14', 'PB.15', 'PB.14', 'PB.13', 'PB.12', 'AVDD', 'AVSS',
		'PB.7', 'PB.6'
	],
	"LQFP48(USB1.1)(7*7)": [
		'PB.5', 'PB.4', 'PB.3', 'PB.2', 'PB.1', 'PB.0', 'PA.11', 'PA.10', 'PA.9', 'PA.8',
		'PF.5', 'PF.4',
		'PF.3', 'PF.2', 'PA.7', 'PA.6', 'PA.5', 'PA.4', 'PA.3', 'PA.2', 'PA.1', 'PA.0',
		'PF.15', 'nRESET',
		'PF.0', 'PF.1', 'PC.5', 'PC.4', 'PC.3', 'PC.2', 'PC.1', 'PC.0', 'USB_VBUS', 'USB_D-',
		'USB_D+', 'USB_VDD33_CAP',
		'VSS', 'LDO_CAP', 'VDD', 'PC.14', 'PB.15', 'PB.14', 'PB.13', 'PB.12', 'AVDD', 'AVSS',
		'PB.7', 'PB.6'
	],
	"LQFP64": [
		'PB.6', 'PB.5', 'PB.4', 'PB.3', 'PB.2', 'PB.1', 'PB.0', 'PA.11', 'PA.10', 'PA.9',
		'PA.8', 'PF.6', 'PF.14', 'PF.5', 'PF.4', 'PF.3',
		'PF.2', 'PC.7', 'PC.6', 'PA.7', 'PA.6', 'VSS', 'VDD', 'PD.15', 'PA.5', 'PA.4',
		'PA.3', 'PA.2', 'PA.1', 'PA.0', 'PF.15', 'nRESET',
		'PF.0', 'PF.1', 'PC.5', 'PC.4', 'PC.3', 'PC.2', 'PC.1', 'PC.0', 'PD.3', 'PD.2',
		'PD.1', 'PD.0', 'PA.12', 'PA.13', 'PA.14', 'PA.15',
		'VSS', 'LDO_CAP', 'VDD', 'PC.14', 'PB.15', 'PB.14', 'PB.13', 'PB.12', 'AVDD', 'VREF',
		'AVSS', 'PB.11', 'PB.10', 'PB.9', 'PB.8', 'PB.7'
	],
	"LQFP64(USB1.1)": [
		'PB.6', 'PB.5', 'PB.4', 'PB.3', 'PB.2', 'PB.1', 'PB.0', 'PA.11', 'PA.10', 'PA.9',
		'PA.8', 'PF.6', 'PF.14', 'PF.5', 'PF.4', 'PF.3',
		'PF.2', 'PC.7', 'PC.6', 'PA.7', 'PA.6', 'VSS', 'VDD', 'PD.15', 'PA.5', 'PA.4',
		'PA.3', 'PA.2', 'PA.1', 'PA.0', 'PF.15', 'nRESET',
		'PF.0', 'PF.1', 'PC.5', 'PC.4', 'PC.3', 'PC.2', 'PC.1', 'PC.0', 'PD.3', 'PD.2',
		'PD.1', 'PD.0', 'USB_VBUS', 'USB_D-', 'USB_D+', 'USB_VDD33_CAP',
		'VSS', 'LDO_CAP', 'VDD', 'PC.14', 'PB.15', 'PB.14', 'PB.13', 'PB.12', 'AVDD', 'VREF',
		'AVSS', 'PB.11', 'PB.10', 'PB.9', 'PB.8', 'PB.7'
	]
};

NUTOOL_PIN.g_cfg_gpios = [
	{ f: ['PA.0:0', 'SPI0_MOSI:4', 'UART0_RXD:7', 'UART1_nRTS:8', 'PWM0_CH5:13']},
	{ f: ['PA.1:0', 'SPI0_MISO:4', 'UART0_TXD:7', 'UART1_nCTS:8', 'PWM0_CH4:13']},
	{ f: ['PA.2:0', 'SPI0_CLK:4', 'UART1_RXD:8', 'I2C1_SDA:9', 'PWM0_CH3:13']},
	{ f: ['PA.3:0', 'SPI0_SS:4', 'UART1_TXD:8', 'I2C1_SCL:9', 'PWM0_CH2:13', 'CLKO:14', 'PWM1_BRAKE1:15']},
	{ f: ['PA.4:0', 'SPI0_I2SMCLK:4', 'UART0_nRTS:7', 'UART0_RXD:8', 'I2C0_SDA:9', 'PWM0_CH1:13']},
	{ f: ['PA.5:0', 'UART0_nCTS:7', 'UART0_TXD:8', 'I2C0_SCL:9', 'PWM0_CH0:13']},
	{ f: ['PA.6:0', 'EBI_AD6:2', 'UART0_RXD:7', 'I2C1_SDA:8', 'PWM1_CH5:11', 'ACMP1_WLAT:13', 'TM3:14', 'INT0:15']},
	{ f: ['PA.7:0', 'EBI_AD7:2', 'UART0_TXD:7', 'I2C1_SCL:8', 'PWM1_CH4:11', 'ACMP0_WLAT:13', 'TM2:14', 'INT1:15']},
	{ f: ['PA.8:0', 'EBI_ALE:2', 'USCI0_CTL1:6', 'UART1_RXD:7', 'TM3_EXT:13', 'INT4:15']},
	{ f: ['PA.9:0', 'EBI_MCLK:2', 'USCI0_DAT1:6', 'UART1_TXD:7', 'TM2_EXT:13']},
	{ f: ['PA.10:0', 'ACMP1_P0:1', 'EBI_nWR:2', 'USCI0_DAT0:6', 'TM1_EXT:13']},
	{ f: ['PA.11:0', 'ACMP0_P0:1', 'EBI_nRD:2', 'USCI0_CLK:6', 'TM0_EXT:13']},
	{ f: ['PA.12:0', 'I2C1_SCL:4']},
	{ f: ['PA.13:0', 'I2C1_SDA:4']},
	{ f: ['PA.14:0', 'UART0_TXD:3']},
	{ f: ['PA.15:0', 'UART0_RXD:3']},

	{ f: ['PB.0:0', 'ADC0_CH0:1', 'UART2_RXD:7', 'SPI0_I2SMCLK:8', 'I2C1_SDA:9', 'PWM0_CH5:11', 'PWM1_CH5:12', 'PWM0_BRAKE1:13']},
	{ f: ['PB.1:0', 'ADC0_CH1:1', 'UART2_TXD:7', 'I2C1_SCL:9', 'PWM0_CH4:11', 'PWM1_CH4:12', 'PWM0_BRAKE0:13']},
	{ f: ['PB.2:0', 'ADC0_CH2:1', 'ACMP0_P1:1', 'I2C1_SDA:4', 'UART1_RXD:6', 'PWM0_CH3:11', 'TM3:14', 'INT3:15']},
	{ f: ['PB.3:0', 'ADC0_CH3:1', 'ACMP0_N:1', 'I2C1_SCL:4', 'UART1_TXD:6', 'PWM0_CH2:11', 'PWM0_BRAKE0:13', 'TM2:14', 'INT2:15']},
	{ f: ['PB.4:0', 'ADC0_CH4:1', 'ACMP1_P1:1', 'I2C0_SDA:6', 'PWM0_CH1:11', 'UART2_RXD:13', 'TM1:14', 'INT1:15']},
	{ f: ['PB.5:0', 'ADC0_CH5:1', 'ACMP1_N:1', 'I2C0_SCL:6', 'PWM0_CH0:11', 'UART2_TXD:13', 'TM0:14', 'INT0:15']},
	{ f: ['PB.6:0', 'ADC0_CH6:1', 'EBI_nWRH:2', 'UART1_RXD:6', 'EBI_nCS1:8', 'PWM1_BRAKE1:11', 'PWM1_CH5:12', 'INT4:13', 'ACMP1_O:15']},
	{ f: ['PB.7:0', 'ADC0_CH7:1', 'EBI_nWRL:2', 'UART1_TXD:6', 'EBI_nCS0:8', 'PWM1_BRAKE0:11', 'PWM1_CH4:12', 'INT5:13', 'ACMP0_O:15']},
	{ f: ['PB.8:0', 'ADC0_CH8:1', 'EBI_ADR19:2', 'UART0_RXD:5', 'UART1_nRTS:6']},
	{ f: ['PB.9:0', 'ADC0_CH9:1', 'EBI_ADR18:2', 'UART0_TXD:5', 'UART1_nCTS:6']},
	{ f: ['PB.10:0', 'ADC0_CH10:1', 'EBI_ADR17:2', 'UART0_nRTS:5', 'I2C1_SDA:7']},
	{ f: ['PB.11:0', 'ADC0_CH11:1', 'EBI_ADR16:2', 'UART0_nCTS:5', 'I2C1_SCL:7', 'SPI0_I2SMCLK:9']},
	{ f: ['PB.12:0', 'ADC0_CH12:1', 'ACMP0_P2:1', 'ACMP1_P2:1', 'EBI_AD15:2', 'SPI0_MOSI:4', 'USCI0_CLK:5', 'UART0_RXD:6', 'PWM1_CH3:11', 'TM3_EXT:13']},
	{ f: ['PB.13:0', 'ADC0_CH13:1', 'ACMP0_P3:1', 'ACMP1_P3:1', 'EBI_AD14:2', 'SPI0_MISO:4', 'USCI0_DAT0:5', 'UART0_TXD:6', 'PWM1_CH2:11', 'TM2_EXT:13']},
	{ f: ['PB.14:0', 'ADC0_CH14:1', 'EBI_AD13:2', 'SPI0_CLK:4', 'USCI0_DAT1:5', 'UART0_nRTS:6', 'PWM1_CH1:11', 'TM1_EXT:13', 'CLKO:14']},
	{ f: ['PB.15:0', 'ADC0_CH15:1', 'EBI_AD12:2', 'SPI0_SS:4', 'USCI0_CTL1:5', 'UART0_nCTS:6', 'PWM1_CH0:11', 'TM0_EXT:13', 'PWM0_BRAKE1:15']},

	{ f: ['PC.0:0', 'EBI_AD0:2', 'UART2_RXD:8', 'I2C0_SDA:9', 'PWM1_CH5:12', 'ACMP1_O:14']},
	{ f: ['PC.1:0', 'EBI_AD1:2', 'UART2_TXD:8', 'I2C0_SCL:9', 'PWM1_CH4:12', 'ACMP0_O:14']},
	{ f: ['PC.2:0', 'EBI_AD2:2', 'UART2_nCTS:8', 'PWM1_CH3:12']},
	{ f: ['PC.3:0', 'EBI_AD3:2', 'UART2_nRTS:8', 'PWM1_CH2:12']},
	{ f: ['PC.4:0', 'EBI_AD4:2', 'UART2_RXD:8', 'I2C1_SDA:9', 'PWM1_CH1:12']},
	{ f: ['PC.5:0', 'EBI_AD5:2', 'UART2_TXD:8', 'I2C1_SCL:9', 'PWM1_CH0:12']},
	{ f: ['PC.6:0', 'EBI_AD8:2', 'UART0_nRTS:7', 'PWM1_CH3:11', 'TM1:14', 'INT2:15']},
	{ f: ['PC.7:0', 'EBI_AD9:2', 'UART0_nCTS:7', 'PWM1_CH2:11', 'TM0:14', 'INT3:15']},
	{ f: ['PC.8:0']},
	{ f: ['PC.9:0']},
	{ f: ['PC.10:0']},
	{ f: ['PC.11:0']},
	{ f: ['PC.12:0']},
	{ f: ['PC.13:0']},
	{ f: ['PC.14:0', 'EBI_AD11:2', 'SPI0_I2SMCLK:4', 'USCI0_CTL0:5', 'TM1:13']},
	{ f: ['PC.15:0']},

	{ f: ['PD.0:0', 'EBI_AD13:2', 'USCI0_CLK:3', 'SPI0_MOSI:4', 'TM2:14']},
	{ f: ['PD.1:0', 'EBI_AD12:2', 'USCI0_DAT0:3', 'SPI0_MISO:4']},
	{ f: ['PD.2:0', 'EBI_AD11:2', 'USCI0_DAT1:3', 'SPI0_CLK:4', 'UART0_RXD:9']},
	{ f: ['PD.3:0', 'EBI_AD10:2', 'USCI0_CTL1:3', 'SPI0_SS:4', 'UART0_TXD:9']},
	{ f: ['PD.4:0']},
	{ f: ['PD.5:0']},
	{ f: ['PD.6:0']},
	{ f: ['PD.7:0']},
	{ f: ['PD.8:0']},
	{ f: ['PD.9:0']},
	{ f: ['PD.10:0']},
	{ f: ['PD.11:0']},
	{ f: ['PD.12:0']},
	{ f: ['PD.13:0']},
	{ f: ['PD.14:0']},
	{ f: ['PD.15:0', 'PWM0_CH5:12', 'TM3:14', 'INT1:15']},

	{ f: ['PE.0:0']},
	{ f: ['PE.1:0']},
	{ f: ['PE.2:0']},
	{ f: ['PE.3:0']},
	{ f: ['PE.4:0']},
	{ f: ['PE.5:0']},
	{ f: ['PE.6:0']},
	{ f: ['PE.7:0']},
	{ f: ['PE.8:0']},
	{ f: ['PE.9:0']},
	{ f: ['PE.10:0']},
	{ f: ['PE.11:0']},
	{ f: ['PE.12:0']},
	{ f: ['PE.13:0']},
	{ f: ['PE.14:0']},
	{ f: ['PE.15:0']},

	{ f: ['PF.0:0', 'UART1_TXD:2', 'I2C1_SCL:3', 'UART0_TXD:4', 'ICE_DAT:14']},
	{ f: ['PF.1:0', 'UART1_RXD:2', 'I2C1_SDA:3', 'UART0_RXD:4', 'ICE_CLK:14']},
	{ f: ['PF.2:0', 'EBI_nCS1:2', 'UART0_RXD:3', 'I2C0_SDA:4', 'XT1_OUT:10']},
	{ f: ['PF.3:0', 'EBI_nCS0:2', 'UART0_TXD:3', 'I2C0_SCL:4', 'XT1_IN:10']},
	{ f: ['PF.4:0', 'UART2_TXD:2', 'UART2_nRTS:4', 'PWM0_CH1:7', 'X32_OUT:10']},
	{ f: ['PF.5:0', 'UART2_RXD:2', 'UART2_nCTS:4', 'PWM0_CH0:7', 'X32_IN:10', 'ADC0_ST:11']},
	{ f: ['PF.6:0', 'EBI_ADR19:2', 'SPI0_MOSI:5', 'EBI_nCS0:7']},
	{ f: ['PF.7:0']},
	{ f: ['PF.8:0']},
	{ f: ['PF.9:0']},
	{ f: ['PF.10:0']},
	{ f: ['PF.11:0']},
	{ f: ['PF.12:0']},
	{ f: ['PF.13:0']},
	{ f: ['PF.14:0', 'PWM1_BRAKE0:9', 'PWM0_BRAKE0:10', 'PWM0_CH4:12', 'CLKO:13', 'TM3:14', 'INT5:15']},
	{ f: ['PF.15:0', 'PWM0_BRAKE0:11', 'PWM0_CH1:12', 'TM2:13', 'CLKO:14', 'INT4:15']}
];

NUTOOL_PIN.g_cfg_gpiosDefines = [
	{ f: ['PA.0', 'SPI0_MOSI:SYS_GPA_MFPL_PA0MFP_SPI0_MOSI@GPA_MFPL', 'UART0_RXD:SYS_GPA_MFPL_PA0MFP_UART0_RXD@GPA_MFPL', 'UART1_nRTS:SYS_GPA_MFPL_PA0MFP_UART1_nRTS@GPA_MFPL', 'PWM0_CH5:SYS_GPA_MFPL_PA0MFP_PWM0_CH5@GPA_MFPL'] },
	{ f: ['PA.1', 'SPI0_MISO:SYS_GPA_MFPL_PA1MFP_SPI0_MISO@GPA_MFPL', 'UART0_TXD:SYS_GPA_MFPL_PA1MFP_UART0_TXD@GPA_MFPL', 'UART1_nCTS:SYS_GPA_MFPL_PA1MFP_UART1_nCTS@GPA_MFPL', 'PWM0_CH4:SYS_GPA_MFPL_PA1MFP_PWM0_CH4@GPA_MFPL'] },
	{ f: ['PA.2', 'SPI0_CLK:SYS_GPA_MFPL_PA2MFP_SPI0_CLK@GPA_MFPL', 'UART1_RXD:SYS_GPA_MFPL_PA2MFP_UART1_RXD@GPA_MFPL', 'I2C1_SDA:SYS_GPA_MFPL_PA2MFP_I2C1_SDA@GPA_MFPL', 'PWM0_CH3:SYS_GPA_MFPL_PA2MFP_PWM0_CH3@GPA_MFPL'] },
	{ f: ['PA.3', 'SPI0_SS:SYS_GPA_MFPL_PA3MFP_SPI0_SS@GPA_MFPL', 'UART1_TXD:SYS_GPA_MFPL_PA3MFP_UART1_TXD@GPA_MFPL', 'I2C1_SCL:SYS_GPA_MFPL_PA3MFP_I2C1_SCL@GPA_MFPL', 'PWM0_CH2:SYS_GPA_MFPL_PA3MFP_PWM0_CH2@GPA_MFPL', 'CLKO:SYS_GPA_MFPL_PA3MFP_CLKO@GPA_MFPL', 'PWM1_BRAKE1:SYS_GPA_MFPL_PA3MFP_PWM1_BRAKE1@GPA_MFPL'] },
	{ f: ['PA.4', 'SPI0_I2SMCLK:SYS_GPA_MFPL_PA4MFP_SPI0_I2SMCLK@GPA_MFPL', 'UART0_nRTS:SYS_GPA_MFPL_PA4MFP_UART0_nRTS@GPA_MFPL', 'UART0_RXD:SYS_GPA_MFPL_PA4MFP_UART0_RXD@GPA_MFPL', 'I2C0_SDA:SYS_GPA_MFPL_PA4MFP_I2C0_SDA@GPA_MFPL', 'PWM0_CH1:SYS_GPA_MFPL_PA4MFP_PWM0_CH1@GPA_MFPL'] },
	{ f: ['PA.5', 'UART0_nCTS:SYS_GPA_MFPL_PA5MFP_UART0_nCTS@GPA_MFPL', 'UART0_TXD:SYS_GPA_MFPL_PA5MFP_UART0_TXD@GPA_MFPL', 'I2C0_SCL:SYS_GPA_MFPL_PA5MFP_I2C0_SCL@GPA_MFPL', 'PWM0_CH0:SYS_GPA_MFPL_PA5MFP_PWM0_CH0@GPA_MFPL'] },
	{ f: ['PA.6', 'EBI_AD6:SYS_GPA_MFPL_PA6MFP_EBI_AD6@GPA_MFPL', 'UART0_RXD:SYS_GPA_MFPL_PA6MFP_UART0_RXD@GPA_MFPL', 'I2C1_SDA:SYS_GPA_MFPL_PA6MFP_I2C1_SDA@GPA_MFPL', 'PWM1_CH5:SYS_GPA_MFPL_PA6MFP_PWM1_CH5@GPA_MFPL', 'ACMP1_WLAT:SYS_GPA_MFPL_PA6MFP_ACMP1_WLAT@GPA_MFPL', 'TM3:SYS_GPA_MFPL_PA6MFP_TM3@GPA_MFPL', 'INT0:SYS_GPA_MFPL_PA6MFP_INT0@GPA_MFPL'] },
	{ f: ['PA.7', 'EBI_AD7:SYS_GPA_MFPL_PA7MFP_EBI_AD7@GPA_MFPL', 'UART0_TXD:SYS_GPA_MFPL_PA7MFP_UART0_TXD@GPA_MFPL', 'I2C1_SCL:SYS_GPA_MFPL_PA7MFP_I2C1_SCL@GPA_MFPL', 'PWM1_CH4:SYS_GPA_MFPL_PA7MFP_PWM1_CH4@GPA_MFPL', 'ACMP0_WLAT:SYS_GPA_MFPL_PA7MFP_ACMP0_WLAT@GPA_MFPL', 'TM2:SYS_GPA_MFPL_PA7MFP_TM2@GPA_MFPL', 'INT1:SYS_GPA_MFPL_PA7MFP_INT1@GPA_MFPL'] },
	{ f: ['PA.8', 'EBI_ALE:SYS_GPA_MFPH_PA8MFP_EBI_ALE@GPA_MFPH', 'USCI0_CTL1:SYS_GPA_MFPH_PA8MFP_USCI0_CTL1@GPA_MFPH', 'UART1_RXD:SYS_GPA_MFPH_PA8MFP_UART1_RXD@GPA_MFPH', 'TM3_EXT:SYS_GPA_MFPH_PA8MFP_TM3_EXT@GPA_MFPH', 'INT4:SYS_GPA_MFPH_PA8MFP_INT4@GPA_MFPH'] },
	{ f: ['PA.9', 'EBI_MCLK:SYS_GPA_MFPH_PA9MFP_EBI_MCLK@GPA_MFPH', 'USCI0_DAT1:SYS_GPA_MFPH_PA9MFP_USCI0_DAT1@GPA_MFPH', 'UART1_TXD:SYS_GPA_MFPH_PA9MFP_UART1_TXD@GPA_MFPH', 'TM2_EXT:SYS_GPA_MFPH_PA9MFP_TM2_EXT@GPA_MFPH'] },
	{ f: ['PA.10', 'ACMP1_P0:SYS_GPA_MFPH_PA10MFP_ACMP1_P0@GPA_MFPH', 'EBI_nWR:SYS_GPA_MFPH_PA10MFP_EBI_nWR@GPA_MFPH', 'USCI0_DAT0:SYS_GPA_MFPH_PA10MFP_USCI0_DAT0@GPA_MFPH', 'TM1_EXT:SYS_GPA_MFPH_PA10MFP_TM1_EXT@GPA_MFPH'] },
	{ f: ['PA.11', 'ACMP0_P0:SYS_GPA_MFPH_PA11MFP_ACMP0_P0@GPA_MFPH', 'EBI_nRD:SYS_GPA_MFPH_PA11MFP_EBI_nRD@GPA_MFPH', 'USCI0_CLK:SYS_GPA_MFPH_PA11MFP_USCI0_CLK@GPA_MFPH', 'TM0_EXT:SYS_GPA_MFPH_PA11MFP_TM0_EXT@GPA_MFPH'] },
	{ f: ['PA.12', 'I2C1_SCL:SYS_GPA_MFPH_PA12MFP_I2C1_SCL@GPA_MFPH'] },
	{ f: ['PA.13', 'I2C1_SDA:SYS_GPA_MFPH_PA13MFP_I2C1_SDA@GPA_MFPH'] },
	{ f: ['PA.14', 'UART0_TXD:SYS_GPA_MFPH_PA14MFP_UART0_TXD@GPA_MFPH'] },
	{ f: ['PA.15', 'UART0_RXD:SYS_GPA_MFPH_PA15MFP_UART0_RXD@GPA_MFPH'] },
	
	{ f: ['PB.0', 'ADC0_CH0:SYS_GPB_MFPL_PB0MFP_ADC0_CH0@GPB_MFPL', 'UART2_RXD:SYS_GPB_MFPL_PB0MFP_UART2_RXD@GPB_MFPL', 'SPI0_I2SMCLK:SYS_GPB_MFPL_PB0MFP_SPI0_I2SMCLK@GPB_MFPL', 'I2C1_SDA:SYS_GPB_MFPL_PB0MFP_I2C1_SDA@GPB_MFPL', 'PWM0_CH5:SYS_GPB_MFPL_PB0MFP_PWM0_CH5@GPB_MFPL', 'PWM1_CH5:SYS_GPB_MFPL_PB0MFP_PWM1_CH5@GPB_MFPL', 'PWM0_BRAKE1:SYS_GPB_MFPL_PB0MFP_PWM0_BRAKE1@GPB_MFPL'] },
	{ f: ['PB.1', 'ADC0_CH1:SYS_GPB_MFPL_PB1MFP_ADC0_CH1@GPB_MFPL', 'UART2_TXD:SYS_GPB_MFPL_PB1MFP_UART2_TXD@GPB_MFPL', 'I2C1_SCL:SYS_GPB_MFPL_PB1MFP_I2C1_SCL@GPB_MFPL', 'PWM0_CH4:SYS_GPB_MFPL_PB1MFP_PWM0_CH4@GPB_MFPL', 'PWM1_CH4:SYS_GPB_MFPL_PB1MFP_PWM1_CH4@GPB_MFPL', 'PWM0_BRAKE0:SYS_GPB_MFPL_PB1MFP_PWM0_BRAKE0@GPB_MFPL'] },
	{ f: ['PB.2', 'ADC0_CH2:SYS_GPB_MFPL_PB2MFP_ADC0_CH2@GPB_MFPL', 'ACMP0_P1:SYS_GPB_MFPL_PB2MFP_ACMP0_P1@GPB_MFPL', 'I2C1_SDA:SYS_GPB_MFPL_PB2MFP_I2C1_SDA@GPB_MFPL', 'UART1_RXD:SYS_GPB_MFPL_PB2MFP_UART1_RXD@GPB_MFPL', 'PWM0_CH3:SYS_GPB_MFPL_PB2MFP_PWM0_CH3@GPB_MFPL', 'TM3:SYS_GPB_MFPL_PB2MFP_TM3@GPB_MFPL', 'INT3:SYS_GPB_MFPL_PB2MFP_INT3@GPB_MFPL'] },
	{ f: ['PB.3', 'ADC0_CH3:SYS_GPB_MFPL_PB3MFP_ADC0_CH3@GPB_MFPL', 'ACMP0_N:SYS_GPB_MFPL_PB3MFP_ACMP0_N@GPB_MFPL', 'I2C1_SCL:SYS_GPB_MFPL_PB3MFP_I2C1_SCL@GPB_MFPL', 'UART1_TXD:SYS_GPB_MFPL_PB3MFP_UART1_TXD@GPB_MFPL', 'PWM0_CH2:SYS_GPB_MFPL_PB3MFP_PWM0_CH2@GPB_MFPL', 'PWM0_BRAKE0:SYS_GPB_MFPL_PB3MFP_PWM0_BRAKE0@GPB_MFPL', 'TM2:SYS_GPB_MFPL_PB3MFP_TM2@GPB_MFPL', 'INT2:SYS_GPB_MFPL_PB3MFP_INT2@GPB_MFPL'] },
	{ f: ['PB.4', 'ADC0_CH4:SYS_GPB_MFPL_PB4MFP_ADC0_CH4@GPB_MFPL', 'ACMP1_P1:SYS_GPB_MFPL_PB4MFP_ACMP1_P1@GPB_MFPL', 'I2C0_SDA:SYS_GPB_MFPL_PB4MFP_I2C0_SDA@GPB_MFPL', 'PWM0_CH1:SYS_GPB_MFPL_PB4MFP_PWM0_CH1@GPB_MFPL', 'UART2_RXD:SYS_GPB_MFPL_PB4MFP_UART2_RXD@GPB_MFPL', 'TM1:SYS_GPB_MFPL_PB4MFP_TM1@GPB_MFPL', 'INT1:SYS_GPB_MFPL_PB4MFP_INT1@GPB_MFPL'] },
	{ f: ['PB.5', 'ADC0_CH5:SYS_GPB_MFPL_PB5MFP_ADC0_CH5@GPB_MFPL', 'ACMP1_N:SYS_GPB_MFPL_PB5MFP_ACMP1_N@GPB_MFPL', 'I2C0_SCL:SYS_GPB_MFPL_PB5MFP_I2C0_SCL@GPB_MFPL', 'PWM0_CH0:SYS_GPB_MFPL_PB5MFP_PWM0_CH0@GPB_MFPL', 'UART2_TXD:SYS_GPB_MFPL_PB5MFP_UART2_TXD@GPB_MFPL', 'TM0:SYS_GPB_MFPL_PB5MFP_TM0@GPB_MFPL', 'INT0:SYS_GPB_MFPL_PB5MFP_INT0@GPB_MFPL'] },
	{ f: ['PB.6', 'ADC0_CH6:SYS_GPB_MFPL_PB6MFP_ADC0_CH6@GPB_MFPL', 'EBI_nWRH:SYS_GPB_MFPL_PB6MFP_EBI_nWRH@GPB_MFPL', 'UART1_RXD:SYS_GPB_MFPL_PB6MFP_UART1_RXD@GPB_MFPL', 'EBI_nCS1:SYS_GPB_MFPL_PB6MFP_EBI_nCS1@GPB_MFPL', 'PWM1_BRAKE1:SYS_GPB_MFPL_PB6MFP_PWM1_BRAKE1@GPB_MFPL', 'PWM1_CH5:SYS_GPB_MFPL_PB6MFP_PWM1_CH5@GPB_MFPL', 'INT4:SYS_GPB_MFPL_PB6MFP_INT4@GPB_MFPL', 'ACMP1_O:SYS_GPB_MFPL_PB6MFP_ACMP1_O@GPB_MFPL'] },
	{ f: ['PB.7', 'ADC0_CH7:SYS_GPB_MFPL_PB7MFP_ADC0_CH7@GPB_MFPL', 'EBI_nWRL:SYS_GPB_MFPL_PB7MFP_EBI_nWRL@GPB_MFPL', 'UART1_TXD:SYS_GPB_MFPL_PB7MFP_UART1_TXD@GPB_MFPL', 'EBI_nCS0:SYS_GPB_MFPL_PB7MFP_EBI_nCS0@GPB_MFPL', 'PWM1_BRAKE0:SYS_GPB_MFPL_PB7MFP_PWM1_BRAKE0@GPB_MFPL', 'PWM1_CH4:SYS_GPB_MFPL_PB7MFP_PWM1_CH4@GPB_MFPL', 'INT5:SYS_GPB_MFPL_PB7MFP_INT5@GPB_MFPL', 'ACMP0_O:SYS_GPB_MFPL_PB7MFP_ACMP0_O@GPB_MFPL'] },
	{ f: ['PB.8', 'ADC0_CH8:SYS_GPB_MFPH_PB8MFP_ADC0_CH8@GPB_MFPH', 'EBI_ADR19:SYS_GPB_MFPH_PB8MFP_EBI_ADR19@GPB_MFPH', 'UART0_RXD:SYS_GPB_MFPH_PB8MFP_UART0_RXD@GPB_MFPH', 'UART1_nRTS:SYS_GPB_MFPH_PB8MFP_UART1_nRTS@GPB_MFPH'] },
	{ f: ['PB.9', 'ADC0_CH9:SYS_GPB_MFPH_PB9MFP_ADC0_CH9@GPB_MFPH', 'EBI_ADR18:SYS_GPB_MFPH_PB9MFP_EBI_ADR18@GPB_MFPH', 'UART0_TXD:SYS_GPB_MFPH_PB9MFP_UART0_TXD@GPB_MFPH', 'UART1_nCTS:SYS_GPB_MFPH_PB9MFP_UART1_nCTS@GPB_MFPH'] },
	{ f: ['PB.10', 'ADC0_CH10:SYS_GPB_MFPH_PB10MFP_ADC0_CH10@GPB_MFPH', 'EBI_ADR17:SYS_GPB_MFPH_PB10MFP_EBI_ADR17@GPB_MFPH', 'UART0_nRTS:SYS_GPB_MFPH_PB10MFP_UART0_nRTS@GPB_MFPH', 'I2C1_SDA:SYS_GPB_MFPH_PB10MFP_I2C1_SDA@GPB_MFPH'] },
	{ f: ['PB.11', 'ADC0_CH11:SYS_GPB_MFPH_PB11MFP_ADC0_CH11@GPB_MFPH', 'EBI_ADR16:SYS_GPB_MFPH_PB11MFP_EBI_ADR16@GPB_MFPH', 'UART0_nCTS:SYS_GPB_MFPH_PB11MFP_UART0_nCTS@GPB_MFPH', 'I2C1_SCL:SYS_GPB_MFPH_PB11MFP_I2C1_SCL@GPB_MFPH', 'SPI0_I2SMCLK:SYS_GPB_MFPH_PB11MFP_SPI0_I2SMCLK@GPB_MFPH'] },
	{ f: ['PB.12', 'ADC0_CH12:SYS_GPB_MFPH_PB12MFP_ADC0_CH12@GPB_MFPH', 'ACMP0_P2:SYS_GPB_MFPH_PB12MFP_ACMP0_P2@GPB_MFPH', 'ACMP1_P2:SYS_GPB_MFPH_PB12MFP_ACMP1_P2@GPB_MFPH', 'EBI_AD15:SYS_GPB_MFPH_PB12MFP_EBI_AD15@GPB_MFPH', 'SPI0_MOSI:SYS_GPB_MFPH_PB12MFP_SPI0_MOSI@GPB_MFPH', 'USCI0_CLK:SYS_GPB_MFPH_PB12MFP_USCI0_CLK@GPB_MFPH', 'UART0_RXD:SYS_GPB_MFPH_PB12MFP_UART0_RXD@GPB_MFPH', 'PWM1_CH3:SYS_GPB_MFPH_PB12MFP_PWM1_CH3@GPB_MFPH', 'TM3_EXT:SYS_GPB_MFPH_PB12MFP_TM3_EXT@GPB_MFPH'] },
	{ f: ['PB.13', 'ADC0_CH13:SYS_GPB_MFPH_PB13MFP_ADC0_CH13@GPB_MFPH', 'ACMP0_P3:SYS_GPB_MFPH_PB13MFP_ACMP0_P3@GPB_MFPH', 'ACMP1_P3:SYS_GPB_MFPH_PB13MFP_ACMP1_P3@GPB_MFPH', 'EBI_AD14:SYS_GPB_MFPH_PB13MFP_EBI_AD14@GPB_MFPH', 'SPI0_MISO:SYS_GPB_MFPH_PB13MFP_SPI0_MISO@GPB_MFPH', 'USCI0_DAT0:SYS_GPB_MFPH_PB13MFP_USCI0_DAT0@GPB_MFPH', 'UART0_TXD:SYS_GPB_MFPH_PB13MFP_UART0_TXD@GPB_MFPH', 'PWM1_CH2:SYS_GPB_MFPH_PB13MFP_PWM1_CH2@GPB_MFPH', 'TM2_EXT:SYS_GPB_MFPH_PB13MFP_TM2_EXT@GPB_MFPH'] },
	{ f: ['PB.14', 'ADC0_CH14:SYS_GPB_MFPH_PB14MFP_ADC0_CH14@GPB_MFPH', 'EBI_AD13:SYS_GPB_MFPH_PB14MFP_EBI_AD13@GPB_MFPH', 'SPI0_CLK:SYS_GPB_MFPH_PB14MFP_SPI0_CLK@GPB_MFPH', 'USCI0_DAT1:SYS_GPB_MFPH_PB14MFP_USCI0_DAT1@GPB_MFPH', 'UART0_nRTS:SYS_GPB_MFPH_PB14MFP_UART0_nRTS@GPB_MFPH', 'PWM1_CH1:SYS_GPB_MFPH_PB14MFP_PWM1_CH1@GPB_MFPH', 'TM1_EXT:SYS_GPB_MFPH_PB14MFP_TM1_EXT@GPB_MFPH', 'CLKO:SYS_GPB_MFPH_PB14MFP_CLKO@GPB_MFPH'] },
	{ f: ['PB.15', 'ADC0_CH15:SYS_GPB_MFPH_PB15MFP_ADC0_CH15@GPB_MFPH', 'EBI_AD12:SYS_GPB_MFPH_PB15MFP_EBI_AD12@GPB_MFPH', 'SPI0_SS:SYS_GPB_MFPH_PB15MFP_SPI0_SS@GPB_MFPH', 'USCI0_CTL1:SYS_GPB_MFPH_PB15MFP_USCI0_CTL1@GPB_MFPH', 'UART0_nCTS:SYS_GPB_MFPH_PB15MFP_UART0_nCTS@GPB_MFPH', 'PWM1_CH0:SYS_GPB_MFPH_PB15MFP_PWM1_CH0@GPB_MFPH', 'TM0_EXT:SYS_GPB_MFPH_PB15MFP_TM0_EXT@GPB_MFPH', 'PWM0_BRAKE1:SYS_GPB_MFPH_PB15MFP_PWM0_BRAKE1@GPB_MFPH'] },
	
	{ f: ['PC.0', 'EBI_AD0:SYS_GPC_MFPL_PC0MFP_EBI_AD0@GPC_MFPL', 'UART2_RXD:SYS_GPC_MFPL_PC0MFP_UART2_RXD@GPC_MFPL', 'I2C0_SDA:SYS_GPC_MFPL_PC0MFP_I2C0_SDA@GPC_MFPL', 'PWM1_CH5:SYS_GPC_MFPL_PC0MFP_PWM1_CH5@GPC_MFPL', 'ACMP1_O:SYS_GPC_MFPL_PC0MFP_ACMP1_O@GPC_MFPL'] },
	{ f: ['PC.1', 'EBI_AD1:SYS_GPC_MFPL_PC1MFP_EBI_AD1@GPC_MFPL', 'UART2_TXD:SYS_GPC_MFPL_PC1MFP_UART2_TXD@GPC_MFPL', 'I2C0_SCL:SYS_GPC_MFPL_PC1MFP_I2C0_SCL@GPC_MFPL', 'PWM1_CH4:SYS_GPC_MFPL_PC1MFP_PWM1_CH4@GPC_MFPL', 'ACMP0_O:SYS_GPC_MFPL_PC1MFP_ACMP0_O@GPC_MFPL'] },
	{ f: ['PC.2', 'EBI_AD2:SYS_GPC_MFPL_PC2MFP_EBI_AD2@GPC_MFPL', 'UART2_nCTS:SYS_GPC_MFPL_PC2MFP_UART2_nCTS@GPC_MFPL', 'PWM1_CH3:SYS_GPC_MFPL_PC2MFP_PWM1_CH3@GPC_MFPL'] },
	{ f: ['PC.3', 'EBI_AD3:SYS_GPC_MFPL_PC3MFP_EBI_AD3@GPC_MFPL', 'UART2_nRTS:SYS_GPC_MFPL_PC3MFP_UART2_nRTS@GPC_MFPL', 'PWM1_CH2:SYS_GPC_MFPL_PC3MFP_PWM1_CH2@GPC_MFPL'] },
	{ f: ['PC.4', 'EBI_AD4:SYS_GPC_MFPL_PC4MFP_EBI_AD4@GPC_MFPL', 'UART2_RXD:SYS_GPC_MFPL_PC4MFP_UART2_RXD@GPC_MFPL', 'I2C1_SDA:SYS_GPC_MFPL_PC4MFP_I2C1_SDA@GPC_MFPL', 'PWM1_CH1:SYS_GPC_MFPL_PC4MFP_PWM1_CH1@GPC_MFPL'] },
	{ f: ['PC.5', 'EBI_AD5:SYS_GPC_MFPL_PC5MFP_EBI_AD5@GPC_MFPL', 'UART2_TXD:SYS_GPC_MFPL_PC5MFP_UART2_TXD@GPC_MFPL', 'I2C1_SCL:SYS_GPC_MFPL_PC5MFP_I2C1_SCL@GPC_MFPL', 'PWM1_CH0:SYS_GPC_MFPL_PC5MFP_PWM1_CH0@GPC_MFPL'] },
	{ f: ['PC.6', 'EBI_AD8:SYS_GPC_MFPL_PC6MFP_EBI_AD8@GPC_MFPL', 'UART0_nRTS:SYS_GPC_MFPL_PC6MFP_UART0_nRTS@GPC_MFPL', 'PWM1_CH3:SYS_GPC_MFPL_PC6MFP_PWM1_CH3@GPC_MFPL', 'TM1:SYS_GPC_MFPL_PC6MFP_TM1@GPC_MFPL', 'INT2:SYS_GPC_MFPL_PC6MFP_INT2@GPC_MFPL'] },
	{ f: ['PC.7', 'EBI_AD9:SYS_GPC_MFPL_PC7MFP_EBI_AD9@GPC_MFPL', 'UART0_nCTS:SYS_GPC_MFPL_PC7MFP_UART0_nCTS@GPC_MFPL', 'PWM1_CH2:SYS_GPC_MFPL_PC7MFP_PWM1_CH2@GPC_MFPL', 'TM0:SYS_GPC_MFPL_PC7MFP_TM0@GPC_MFPL', 'INT3:SYS_GPC_MFPL_PC7MFP_INT3@GPC_MFPL'] },
	{ f: ['PC.14', 'EBI_AD11:SYS_GPC_MFPH_PC14MFP_EBI_AD11@GPC_MFPH', 'SPI0_I2SMCLK:SYS_GPC_MFPH_PC14MFP_SPI0_I2SMCLK@GPC_MFPH', 'USCI0_CTL0:SYS_GPC_MFPH_PC14MFP_USCI0_CTL0@GPC_MFPH', 'TM1:SYS_GPC_MFPH_PC14MFP_TM1@GPC_MFPH'] },

	{ f: ['PD.0', 'EBI_AD13:SYS_GPD_MFPL_PD0MFP_EBI_AD13@GPD_MFPL', 'USCI0_CLK:SYS_GPD_MFPL_PD0MFP_USCI0_CLK@GPD_MFPL', 'SPI0_MOSI:SYS_GPD_MFPL_PD0MFP_SPI0_MOSI@GPD_MFPL', 'TM2:SYS_GPD_MFPL_PD0MFP_TM2@GPD_MFPL'] },
	{ f: ['PD.1', 'EBI_AD12:SYS_GPD_MFPL_PD1MFP_EBI_AD12@GPD_MFPL', 'USCI0_DAT0:SYS_GPD_MFPL_PD1MFP_USCI0_DAT0@GPD_MFPL', 'SPI0_MISO:SYS_GPD_MFPL_PD1MFP_SPI0_MISO@GPD_MFPL'] },
	{ f: ['PD.2', 'EBI_AD11:SYS_GPD_MFPL_PD2MFP_EBI_AD11@GPD_MFPL', 'USCI0_DAT1:SYS_GPD_MFPL_PD2MFP_USCI0_DAT1@GPD_MFPL', 'SPI0_CLK:SYS_GPD_MFPL_PD2MFP_SPI0_CLK@GPD_MFPL', 'UART0_RXD:SYS_GPD_MFPL_PD2MFP_UART0_RXD@GPD_MFPL'] },
	{ f: ['PD.3', 'EBI_AD10:SYS_GPD_MFPL_PD3MFP_EBI_AD10@GPD_MFPL', 'USCI0_CTL1:SYS_GPD_MFPL_PD3MFP_USCI0_CTL1@GPD_MFPL', 'SPI0_SS:SYS_GPD_MFPL_PD3MFP_SPI0_SS@GPD_MFPL', 'UART0_TXD:SYS_GPD_MFPL_PD3MFP_UART0_TXD@GPD_MFPL'] },
	{ f: ['PD.15', 'PWM0_CH5:SYS_GPD_MFPH_PD15MFP_PWM0_CH5@GPD_MFPH', 'TM3:SYS_GPD_MFPH_PD15MFP_TM3@GPD_MFPH', 'INT1:SYS_GPD_MFPH_PD15MFP_INT1@GPD_MFPH'] },

	{ f: ['PF.0', 'UART1_TXD:SYS_GPF_MFPL_PF0MFP_UART1_TXD@GPF_MFPL', 'I2C1_SCL:SYS_GPF_MFPL_PF0MFP_I2C1_SCL@GPF_MFPL', 'UART0_TXD:SYS_GPF_MFPL_PF0MFP_UART0_TXD@GPF_MFPL', 'ICE_DAT:SYS_GPF_MFPL_PF0MFP_ICE_DAT@GPF_MFPL'] },
	{ f: ['PF.1', 'UART1_RXD:SYS_GPF_MFPL_PF1MFP_UART1_RXD@GPF_MFPL', 'I2C1_SDA:SYS_GPF_MFPL_PF1MFP_I2C1_SDA@GPF_MFPL', 'UART0_RXD:SYS_GPF_MFPL_PF1MFP_UART0_RXD@GPF_MFPL', 'ICE_CLK:SYS_GPF_MFPL_PF1MFP_ICE_CLK@GPF_MFPL'] },
	{ f: ['PF.2', 'EBI_nCS1:SYS_GPF_MFPL_PF2MFP_EBI_nCS1@GPF_MFPL', 'UART0_RXD:SYS_GPF_MFPL_PF2MFP_UART0_RXD@GPF_MFPL', 'I2C0_SDA:SYS_GPF_MFPL_PF2MFP_I2C0_SDA@GPF_MFPL', 'XT1_OUT:SYS_GPF_MFPL_PF2MFP_XT1_OUT@GPF_MFPL'] },
	{ f: ['PF.3', 'EBI_nCS0:SYS_GPF_MFPL_PF3MFP_EBI_nCS0@GPF_MFPL', 'UART0_TXD:SYS_GPF_MFPL_PF3MFP_UART0_TXD@GPF_MFPL', 'I2C0_SCL:SYS_GPF_MFPL_PF3MFP_I2C0_SCL@GPF_MFPL', 'XT1_IN:SYS_GPF_MFPL_PF3MFP_XT1_IN@GPF_MFPL'] },
	{ f: ['PF.4', 'UART2_TXD:SYS_GPF_MFPL_PF4MFP_UART2_TXD@GPF_MFPL', 'UART2_nRTS:SYS_GPF_MFPL_PF4MFP_UART2_nRTS@GPF_MFPL', 'PWM0_CH1:SYS_GPF_MFPL_PF4MFP_PWM0_CH1@GPF_MFPL', 'X32_OUT:SYS_GPF_MFPL_PF4MFP_X32_OUT@GPF_MFPL'] },
	{ f: ['PF.5', 'UART2_RXD:SYS_GPF_MFPL_PF5MFP_UART2_RXD@GPF_MFPL', 'UART2_nCTS:SYS_GPF_MFPL_PF5MFP_UART2_nCTS@GPF_MFPL', 'PWM0_CH0:SYS_GPF_MFPL_PF5MFP_PWM0_CH0@GPF_MFPL', 'X32_IN:SYS_GPF_MFPL_PF5MFP_X32_IN@GPF_MFPL', 'ADC0_ST:SYS_GPF_MFPL_PF5MFP_ADC0_ST@GPF_MFPL'] },
	{ f: ['PF.6', 'EBI_ADR19:SYS_GPF_MFPL_PF6MFP_EBI_ADR19@GPF_MFPL', 'SPI0_MOSI:SYS_GPF_MFPL_PF6MFP_SPI0_MOSI@GPF_MFPL', 'EBI_nCS0:SYS_GPF_MFPL_PF6MFP_EBI_nCS0@GPF_MFPL'] },
	{ f: ['PF.14', 'PWM1_BRAKE0:SYS_GPF_MFPH_PF14MFP_PWM1_BRAKE0@GPF_MFPH', 'PWM0_BRAKE0:SYS_GPF_MFPH_PF14MFP_PWM0_BRAKE0@GPF_MFPH', 'PWM0_CH4:SYS_GPF_MFPH_PF14MFP_PWM0_CH4@GPF_MFPH', 'CLKO:SYS_GPF_MFPH_PF14MFP_CLKO@GPF_MFPH', 'TM3:SYS_GPF_MFPH_PF14MFP_TM3@GPF_MFPH', 'INT5:SYS_GPF_MFPH_PF14MFP_INT5@GPF_MFPH'] },
	{ f: ['PF.15', 'PWM0_BRAKE0:SYS_GPF_MFPH_PF15MFP_PWM0_BRAKE0@GPF_MFPH', 'PWM0_CH1:SYS_GPF_MFPH_PF15MFP_PWM0_CH1@GPF_MFPH', 'TM2:SYS_GPF_MFPH_PF15MFP_TM2@GPF_MFPH', 'CLKO:SYS_GPF_MFPH_PF15MFP_CLKO@GPF_MFPH', 'INT4:SYS_GPF_MFPH_PF15MFP_INT4@GPF_MFPH'] }
];

NUTOOL_PIN.g_cfg_gpiosDescriptions = [
	'ACMP0_N:Analog comparator 0 negative input pin.',
	'ACMP0_O:Analog comparator 0 output pin.',
	'ACMP0_P0:Analog comparator 0 positive input 0 pin.',
	'ACMP0_P1:Analog comparator 0 positive input 1 pin.',
	'ACMP0_P2:Analog comparator 0 positive input 2 pin.',
	'ACMP0_P3:Analog comparator 0 positive input 3 pin.',
	'ACMP0_WLAT:Analog comparator 0 window latch input pin',
	'ACMP1_N:Analog comparator 1 negative input pin.',
	'ACMP1_O:Analog comparator 1 output pin.',
	'ACMP1_P0:Analog comparator 1 positive input 0 pin.',
	'ACMP1_P1:Analog comparator 1 positive input 1 pin.',
	'ACMP1_P2:Analog comparator 1 positive input 2 pin.',
	'ACMP1_P3:Analog comparator 1 positive input 3 pin.',
	'ACMP1_WLAT:Analog comparator 1 window latch input pin',
	'ADC0_CH0:ADC0 channel 0 analog input.',
	'ADC0_CH1:ADC0 channel 1 analog input.',
	'ADC0_CH2:ADC0 channel 2 analog input.',
	'ADC0_CH3:ADC0 channel 3 analog input.',
	'ADC0_CH4:ADC0 channel 4 analog input.',
	'ADC0_CH5:ADC0 channel 5 analog input.',
	'ADC0_CH6:ADC0 channel 6 analog input.',
	'ADC0_CH7:ADC0 channel 7 analog input.',
	'ADC0_CH8:ADC0 channel 8 analog input.',
	'ADC0_CH9:ADC0 channel 9 analog input.',
	'ADC0_CH10:ADC0 channel 10 analog input.',
	'ADC0_CH11:ADC0 channel 11 analog input.',
	'ADC0_CH12:ADC0 channel 12 analog input.',
	'ADC0_CH13:ADC0 channel 13 analog input.',
	'ADC0_CH14:ADC0 channel 14 analog input.',
	'ADC0_CH15:ADC0 channel 15 analog input.',
	'ADC0_ST:ADC0 external trigger input.',
	'CLKO:Clock Out',
	'EBI_AD0:EBI address/data bus bit 0.',
	'EBI_AD1:EBI address/data bus bit 1.',
	'EBI_AD2:EBI address/data bus bit 2.',
	'EBI_AD3:EBI address/data bus bit 3.',
	'EBI_AD4:EBI address/data bus bit 4.',
	'EBI_AD5:EBI address/data bus bit 5.',
	'EBI_AD6:EBI address/data bus bit 6.',
	'EBI_AD7:EBI address/data bus bit 7.',
	'EBI_AD8:EBI address/data bus bit 8.',
	'EBI_AD9:EBI address/data bus bit 9.',
	'EBI_AD10:EBI address/data bus bit 10.',
	'EBI_AD11:EBI address/data bus bit 11.',
	'EBI_AD12:EBI address/data bus bit 12.',
	'EBI_AD13:EBI address/data bus bit 13.',
	'EBI_AD14:EBI address/data bus bit 14.',
	'EBI_AD15:EBI address/data bus bit 15.',
	'EBI_ADR16:EBI address bus bit 16.',
	'EBI_ADR17:EBI address bus bit 17.',
	'EBI_ADR18:EBI address bus bit 18.',
	'EBI_ADR19:EBI address bus bit 19.',
	'EBI_ALE:EBI address latch enable output pin.',
	'EBI_MCLK:EBI external clock output pin.',
	'EBI_nCS0:EBI chip select 0 output pin.',
	'EBI_nCS1:EBI chip select 1 output pin.',
	'EBI_nRD:EBI read enable output pin.',
	'EBI_nWR:EBI write enable output pin.',
	'EBI_nWRH:EBI high byte write enable output pin',
	'EBI_nWRL:EBI low byte write enable output pin.',
	'I2C0_SCL:I2C0 clock pin.',
	'I2C0_SDA:I2C0 data input/output pin.',
	'I2C1_SCL:I2C1 clock pin.',
	'I2C1_SDA:I2C1 data input/output pin.',
	'ICE_CLK:Serial wired debugger clock pin.',
	'ICE_DAT:Serial wired debugger data pin.',
	'INT0:External interrupt 0 input pin.',
	'INT1:External interrupt 1 input pin.',
	'INT2:External interrupt 2 input pin.',
	'INT3:External interrupt 3 input pin.',
	'INT4:External interrupt 4 input pin.',
	'INT5:External interrupt 5 input pin.',
	'PWM0_BRAKE0:PWM0 Brake 0 input pin.',
	'PWM0_BRAKE1:PWM0 Brake 1 input pin.',
	'PWM0_CH0:PWM0 channel 0 output/capture input.',
	'PWM0_CH1:PWM0 channel 1 output/capture input.',
	'PWM0_CH2:PWM0 channel 2 output/capture input.',
	'PWM0_CH3:PWM0 channel 3 output/capture input.',
	'PWM0_CH4:PWM0 channel 4 output/capture input.',
	'PWM0_CH5:PWM0 channel 5 output/capture input.',
	'PWM1_BRAKE0:PWM1 Brake 0 input pin.',
	'PWM1_BRAKE1:PWM1 Brake 1 input pin.',
	'PWM1_CH0:PWM1 channel 0 output/capture input.',
	'PWM1_CH1:PWM1 channel 1 output/capture input.',
	'PWM1_CH2:PWM1 channel 2 output/capture input.',
	'PWM1_CH3:PWM1 channel 3 output/capture input.',
	'PWM1_CH4:PWM1 channel 4 output/capture input.',
	'PWM1_CH5:PWM1 channel 5 output/capture input.',
	'SPI0_CLK:SPI0 serial clock pin.',
	'SPI0_I2SMCLK:SPI0 I2S master clock output pin',
	'SPI0_MISO:SPI0 MISO (Master In, Slave Out) pin.',
	'SPI0_MOSI:SPI0 MOSI (Master Out, Slave In) pin.',
	'SPI0_SS:SPI0 slave select pin.',
	'TM0:Timer0 event counter input/toggle output pin.',
	'TM0_EXT:Timer0 external capture input/toggle output pin.',
	'TM1:Timer1 event counter input/toggle output pin.',
	'TM1_EXT:Timer1 external capture input/toggle output pin.',
	'TM2:Timer2 event counter input/toggle output pin.',
	'TM2_EXT:Timer2 external capture input/toggle output pin.',
	'TM3:Timer3 event counter input/toggle output pin.',
	'TM3_EXT:Timer3 external capture input/toggle output pin.',
	'UART0_nCTS:UART0 clear to Send input pin.',
	'UART0_nRTS:UART0 request to Send output pin.',
	'UART0_RXD:UART0 data receiver input pin.',
	'UART0_TXD:UART0 data transmitter output pin.',
	'UART1_nCTS:UART1 clear to Send input pin.',
	'UART1_nRTS:UART1 request to Send output pin.',
	'UART1_RXD:UART1 data receiver input pin.',
	'UART1_TXD:UART1 data transmitter output pin.',
	'UART2_nCTS:UART2 clear to Send input pin.',
	'UART2_nRTS:UART2 request to Send output pin.',
	'UART2_RXD:UART2 data receiver input pin.',
	'UART2_TXD:UART2 data transmitter output pin.',
	'USCI0_CLK:USCI0 clock pin.',
	'USCI0_CTL0:USCI0 control 0 pin.',
	'USCI0_CTL1:USCI0 control 1 pin.',
	'USCI0_DAT0:USCI0 data 0 pin.',
	'USCI0_DAT1:USCI0 data 1 pin.',
	'X32_IN:External 32.768 kHz crystal input pin.',
	'X32_OUT:External 32.768 kHz crystal output pin.',
	'XT1_IN:External 4~32 MHz (high speed) crystal input pin.',
	'XT1_OUT:External 4~32 MHz (high speed) crystal output pin.'
];

NUTOOL_PIN.g_cfg_regDescriptions = {};
NUTOOL_PIN.g_cfg_regDescriptions.GPA_MFPL = '0x40000030';
NUTOOL_PIN.g_cfg_regDescriptions.GPA_MFPH = '0x40000034';
NUTOOL_PIN.g_cfg_regDescriptions.GPB_MFPL = '0x40000038';
NUTOOL_PIN.g_cfg_regDescriptions.GPB_MFPH = '0x4000003C';
NUTOOL_PIN.g_cfg_regDescriptions.GPC_MFPL = '0x40000040';
NUTOOL_PIN.g_cfg_regDescriptions.GPC_MFPH = '0x40000044';
NUTOOL_PIN.g_cfg_regDescriptions.GPD_MFPL = '0x40000048';
NUTOOL_PIN.g_cfg_regDescriptions.GPD_MFPH = '0x4000004C';
NUTOOL_PIN.g_cfg_regDescriptions.GPF_MFPL = '0x40000058';
NUTOOL_PIN.g_cfg_regDescriptions.GPF_MFPH = '0x4000005C';

NUTOOL_PIN.g_cfg_gpioMatrix = [];
NUTOOL_PIN.g_cfg_shareBits = [];
NUTOOL_PIN.g_cfg_addGPIO = {};
NUTOOL_PIN.g_cfg_unusedGPIO = {
	"M031FB0AE(TSSOP20)": {
		"ALL": ["ACMP0", "ACMP1", "EBI", "PWM1", "TM2", "TM3", "USCI0", "X32", "USB"]
	},
	"M031EB0AE(TSSOP28)": function () {
		return this["M031FB0AE(TSSOP20)"];
	},
	"M031TB0AE(QFN33)": function () {
		return this["M031FB0AE(TSSOP20)"];
	},
	"M031FC1AE(TSSOP20)": {
		"ALL": ["ACMP0", "ACMP1", "EBI", "PWM1", "USCI0", "X32", "USB"]
	},
	"M031EC1AE(TSSOP28)": function () {
		return this["M031FC1AE(TSSOP20)"];
	},
	"M031TC1AE(QFN33)": {
		"ALL": ["ACMP0", "ACMP1", "EBI", "PWM1", "USCI0", "USB"]
	},
	"M031TD2AE(QFN33)": {
		"ALL": ["EBI", "USB"]
	},
	"M031LC1AE(LQFP48)": function () {
		return this["M031TD2AE(QFN33)"];
	},
	"M031LD2AE(LQFP48)": function () {
		return this["M031TD2AE(QFN33)"];
	},
	"M031SC1AE(LQFP64)": function () {
		return this["M031TD2AE(QFN33)"];
	},
	"M031SD2AE(LQFP64)": function () {
		return this["M031TD2AE(QFN33)"];
	},
	"M031LE3AE(LQFP48)": {
		"ALL": ["USB"]
	},
	"M031SE3AE(LQFP64)": function () {
		return this["M031LE3AE(LQFP48)"];
	}
};

NUTOOL_PIN.decidepackageNumber = function (given_partNumber_package) {
	var partNumber_package,
		partNumber;

	if (typeof given_partNumber_package === 'undefined') {
		partNumber_package = NUTOOL_PIN.getg_partNumber_package();
	}
	else {
		partNumber_package = given_partNumber_package;
	}

	NUTOOL_PIN.g_packageNumber = partNumber_package.substring(partNumber_package.indexOf('(') + 1);
	NUTOOL_PIN.g_packageNumber = NUTOOL_PIN.g_packageNumber.substring(0, NUTOOL_PIN.g_packageNumber.indexOf(')'));

	partNumber = partNumber_package.substring(0, partNumber_package.indexOf('('));
	switch (NUTOOL_PIN.g_packageNumber) {
	case 'TSSOP20':
		NUTOOL_PIN.g_packageNumberIndex = "TSSOP20";
		break;
	case 'TSSOP28':
		NUTOOL_PIN.g_packageNumberIndex = "TSSOP28";
		break;
	case 'QFN33':
		NUTOOL_PIN.g_packageNumberIndex = "QFN33(4*4)";
		break;
	case 'LQFP48':
		NUTOOL_PIN.g_packageNumberIndex = "LQFP48(7*7)";
		break;
	case 'ULQFP48':
		NUTOOL_PIN.g_packageNumberIndex = "LQFP48(USB1.1)(7*7)";
		break;
	case 'LQFP64':
		NUTOOL_PIN.g_packageNumberIndex = "LQFP64";
		break;
	default:// 'ULQFP64'
		NUTOOL_PIN.g_packageNumberIndex = "LQFP64(USB1.1)";
		break;
	}
	partNumber_package = null;
	partNumber = null;
};
