/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.SystemTray;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.WritableRaster;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.KeyboardFocusManagerPeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.MouseInfoPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.RobotPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.SystemTrayPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.TrayIconPeer;
import java.awt.peer.WindowPeer;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AccessController;
import java.security.Permission;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import sun.awt.AWTAccessor;
import sun.awt.AWTAutoShutdown;
import sun.awt.AppContext;
import sun.awt.ComponentFactory;
import sun.awt.DebugSettings;
import sun.awt.DefaultMouseInfoPeer;
import sun.awt.InputMethodSupport;
import sun.awt.KeyboardFocusManagerPeerProvider;
import sun.awt.LightweightFrame;
import sun.awt.ModalityEvent;
import sun.awt.ModalityListener;
import sun.awt.PeerEvent;
import sun.awt.PostEventQueue;
import sun.awt.TimedWindowEvent;
import sun.awt.WindowClosingListener;
import sun.awt.WindowClosingSupport;
import sun.awt.im.InputContext;
import sun.awt.im.SimpleInputMethodWindow;
import sun.awt.image.ByteArrayImageSource;
import sun.awt.image.FileImageSource;
import sun.awt.image.ImageRepresentation;
import sun.awt.image.MultiResolutionImage;
import sun.awt.image.MultiResolutionToolkitImage;
import sun.awt.image.ToolkitImage;
import sun.awt.image.URLImageSource;
import sun.font.FontDesignMetrics;
import sun.misc.SoftCache;
import sun.net.util.URLUtil;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetPropertyAction;
import sun.security.util.SecurityConstants;
import sun.util.logging.PlatformLogger;

public abstract class SunToolkit
extends Toolkit
implements WindowClosingSupport,
WindowClosingListener,
ComponentFactory,
InputMethodSupport,
KeyboardFocusManagerPeerProvider {
    public static final int GRAB_EVENT_MASK = Integer.MIN_VALUE;
    private static final String POST_EVENT_QUEUE_KEY = "PostEventQueue";
    protected static int numberOfButtons;
    public static final int MAX_BUTTONS_SUPPORTED = 20;
    private static final ReentrantLock AWT_LOCK;
    private static final Condition AWT_LOCK_COND;
    private static final Map<Object, AppContext> appContextMap;
    static final SoftCache fileImgCache;
    static final SoftCache urlImgCache;
    private static Locale startupLocale;
    private transient WindowClosingListener windowClosingListener = null;
    private static DefaultMouseInfoPeer mPeer;
    private static Dialog.ModalExclusionType DEFAULT_MODAL_EXCLUSION_TYPE;
    private ModalityListenerList modalityListeners = new ModalityListenerList();
    public static final int DEFAULT_WAIT_TIME = 10000;
    private static final int MAX_ITERS = 20;
    private static final int MIN_ITERS = 0;
    private static final int MINIMAL_EDELAY = 0;
    private boolean eventDispatched = false;
    private boolean queueEmpty = false;
    private final Object waitLock = "Wait Lock";
    private static boolean checkedSystemAAFontSettings;
    private static boolean useSystemAAFontSettings;
    private static boolean lastExtraCondition;
    private static RenderingHints desktopFontHints;
    public static final String DESKTOPFONTHINTS = "awt.font.desktophints";
    private static Boolean sunAwtDisableMixing;
    private static final Object DEACTIVATION_TIMES_MAP_KEY;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static void initEQ(AppContext appContext) {
        EventQueue eventQueue;
        String string = System.getProperty("AWT.EventQueueClass", "java.awt.EventQueue");
        try {
            eventQueue = (EventQueue)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("Failed loading " + string + ": " + exception);
            eventQueue = new EventQueue();
        }
        appContext.put(AppContext.EVENT_QUEUE_KEY, eventQueue);
        PostEventQueue postEventQueue = new PostEventQueue(eventQueue);
        appContext.put(POST_EVENT_QUEUE_KEY, postEventQueue);
    }

    public boolean useBufferPerWindow() {
        return false;
    }

    @Override
    public abstract WindowPeer createWindow(Window var1) throws HeadlessException;

    @Override
    public abstract FramePeer createFrame(Frame var1) throws HeadlessException;

    public abstract FramePeer createLightweightFrame(LightweightFrame var1) throws HeadlessException;

    @Override
    public abstract DialogPeer createDialog(Dialog var1) throws HeadlessException;

    @Override
    public abstract ButtonPeer createButton(Button var1) throws HeadlessException;

    @Override
    public abstract TextFieldPeer createTextField(TextField var1) throws HeadlessException;

    @Override
    public abstract ChoicePeer createChoice(Choice var1) throws HeadlessException;

    @Override
    public abstract LabelPeer createLabel(Label var1) throws HeadlessException;

    @Override
    public abstract ListPeer createList(List var1) throws HeadlessException;

    @Override
    public abstract CheckboxPeer createCheckbox(Checkbox var1) throws HeadlessException;

    @Override
    public abstract ScrollbarPeer createScrollbar(Scrollbar var1) throws HeadlessException;

    @Override
    public abstract ScrollPanePeer createScrollPane(ScrollPane var1) throws HeadlessException;

    @Override
    public abstract TextAreaPeer createTextArea(TextArea var1) throws HeadlessException;

    @Override
    public abstract FileDialogPeer createFileDialog(FileDialog var1) throws HeadlessException;

    @Override
    public abstract MenuBarPeer createMenuBar(MenuBar var1) throws HeadlessException;

    @Override
    public abstract MenuPeer createMenu(Menu var1) throws HeadlessException;

    @Override
    public abstract PopupMenuPeer createPopupMenu(PopupMenu var1) throws HeadlessException;

    @Override
    public abstract MenuItemPeer createMenuItem(MenuItem var1) throws HeadlessException;

    @Override
    public abstract CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem var1) throws HeadlessException;

    @Override
    public abstract DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent var1) throws InvalidDnDOperationException;

    public abstract TrayIconPeer createTrayIcon(TrayIcon var1) throws HeadlessException, AWTException;

    public abstract SystemTrayPeer createSystemTray(SystemTray var1);

    public abstract boolean isTraySupported();

    @Override
    public abstract FontPeer getFontPeer(String var1, int var2);

    @Override
    public abstract RobotPeer createRobot(Robot var1, GraphicsDevice var2) throws AWTException;

    @Override
    public abstract KeyboardFocusManagerPeer getKeyboardFocusManagerPeer() throws HeadlessException;

    public static final void awtLock() {
        AWT_LOCK.lock();
    }

    public static final boolean awtTryLock() {
        return AWT_LOCK.tryLock();
    }

    public static final void awtUnlock() {
        AWT_LOCK.unlock();
    }

    public static final void awtLockWait() throws InterruptedException {
        AWT_LOCK_COND.await();
    }

    public static final void awtLockWait(long l) throws InterruptedException {
        AWT_LOCK_COND.await(l, TimeUnit.MILLISECONDS);
    }

    public static final void awtLockNotify() {
        AWT_LOCK_COND.signal();
    }

    public static final void awtLockNotifyAll() {
        AWT_LOCK_COND.signalAll();
    }

    public static final boolean isAWTLockHeldByCurrentThread() {
        return AWT_LOCK.isHeldByCurrentThread();
    }

    public static AppContext createNewAppContext() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        return SunToolkit.createNewAppContext(threadGroup);
    }

    static final AppContext createNewAppContext(ThreadGroup threadGroup) {
        AppContext appContext = new AppContext(threadGroup);
        SunToolkit.initEQ(appContext);
        return appContext;
    }

    static void wakeupEventQueue(EventQueue eventQueue, boolean bl) {
        AWTAccessor.getEventQueueAccessor().wakeup(eventQueue, bl);
    }

    protected static Object targetToPeer(Object object) {
        if (object != null && !GraphicsEnvironment.isHeadless()) {
            return AWTAutoShutdown.getInstance().getPeer(object);
        }
        return null;
    }

    protected static void targetCreatedPeer(Object object, Object object2) {
        if (object != null && object2 != null && !GraphicsEnvironment.isHeadless()) {
            AWTAutoShutdown.getInstance().registerPeer(object, object2);
        }
    }

    protected static void targetDisposedPeer(Object object, Object object2) {
        if (object != null && object2 != null && !GraphicsEnvironment.isHeadless()) {
            AWTAutoShutdown.getInstance().unregisterPeer(object, object2);
        }
    }

    private static boolean setAppContext(Object object, AppContext appContext) {
        if (object instanceof Component) {
            AWTAccessor.getComponentAccessor().setAppContext((Component)object, appContext);
        } else if (object instanceof MenuComponent) {
            AWTAccessor.getMenuComponentAccessor().setAppContext((MenuComponent)object, appContext);
        } else {
            return false;
        }
        return true;
    }

    private static AppContext getAppContext(Object object) {
        if (object instanceof Component) {
            return AWTAccessor.getComponentAccessor().getAppContext((Component)object);
        }
        if (object instanceof MenuComponent) {
            return AWTAccessor.getMenuComponentAccessor().getAppContext((MenuComponent)object);
        }
        return null;
    }

    public static AppContext targetToAppContext(Object object) {
        if (object == null) {
            return null;
        }
        AppContext appContext = SunToolkit.getAppContext(object);
        if (appContext == null) {
            appContext = appContextMap.get(object);
        }
        return appContext;
    }

    public static void setLWRequestStatus(Window window, boolean bl) {
        AWTAccessor.getWindowAccessor().setLWRequestStatus(window, bl);
    }

    public static void checkAndSetPolicy(Container container) {
        FocusTraversalPolicy focusTraversalPolicy = KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalPolicy();
        container.setFocusTraversalPolicy(focusTraversalPolicy);
    }

    private static FocusTraversalPolicy createLayoutPolicy() {
        FocusTraversalPolicy focusTraversalPolicy;
        block6: {
            focusTraversalPolicy = null;
            try {
                Class<?> clazz = Class.forName("javax.swing.LayoutFocusTraversalPolicy");
                focusTraversalPolicy = (FocusTraversalPolicy)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            catch (InstantiationException instantiationException) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        return focusTraversalPolicy;
    }

    public static void insertTargetMapping(Object object, AppContext appContext) {
        if (!SunToolkit.setAppContext(object, appContext)) {
            appContextMap.put(object, appContext);
        }
    }

    public static void postEvent(AppContext appContext, AWTEvent aWTEvent) {
        Object object;
        Object object2;
        if (aWTEvent == null) {
            throw new NullPointerException();
        }
        AWTAccessor.SequencedEventAccessor sequencedEventAccessor = AWTAccessor.getSequencedEventAccessor();
        if (sequencedEventAccessor != null && sequencedEventAccessor.isSequencedEvent(aWTEvent) && ((AWTEvent)(object2 = sequencedEventAccessor.getNested(aWTEvent))).getID() == 208 && object2 instanceof TimedWindowEvent) {
            object = (TimedWindowEvent)object2;
            ((SunToolkit)Toolkit.getDefaultToolkit()).setWindowDeactivationTime((Window)((EventObject)object).getSource(), ((TimedWindowEvent)object).getWhen());
        }
        SunToolkit.setSystemGenerated(aWTEvent);
        object2 = SunToolkit.targetToAppContext(aWTEvent.getSource());
        if (object2 != null && !object2.equals(appContext)) {
            throw new RuntimeException("Event posted on wrong app context : " + aWTEvent);
        }
        object = (PostEventQueue)appContext.get(POST_EVENT_QUEUE_KEY);
        if (object != null) {
            ((PostEventQueue)object).postEvent(aWTEvent);
        }
    }

    public static void postPriorityEvent(final AWTEvent aWTEvent) {
        PeerEvent peerEvent = new PeerEvent(Toolkit.getDefaultToolkit(), new Runnable(){

            @Override
            public void run() {
                AWTAccessor.getAWTEventAccessor().setPosted(aWTEvent);
                ((Component)aWTEvent.getSource()).dispatchEvent(aWTEvent);
            }
        }, 2L);
        SunToolkit.postEvent(SunToolkit.targetToAppContext(aWTEvent.getSource()), peerEvent);
    }

    public static void flushPendingEvents() {
        AppContext appContext = AppContext.getAppContext();
        SunToolkit.flushPendingEvents(appContext);
    }

    public static void flushPendingEvents(AppContext appContext) {
        PostEventQueue postEventQueue = (PostEventQueue)appContext.get(POST_EVENT_QUEUE_KEY);
        if (postEventQueue != null) {
            postEventQueue.flush();
        }
    }

    public static void executeOnEventHandlerThread(Object object, Runnable runnable) {
        SunToolkit.executeOnEventHandlerThread(new PeerEvent(object, runnable, 1L));
    }

    public static void executeOnEventHandlerThread(Object object, Runnable runnable, final long l) {
        SunToolkit.executeOnEventHandlerThread(new PeerEvent(object, runnable, 1L){

            @Override
            public long getWhen() {
                return l;
            }
        });
    }

    public static void executeOnEventHandlerThread(PeerEvent peerEvent) {
        SunToolkit.postEvent(SunToolkit.targetToAppContext(peerEvent.getSource()), peerEvent);
    }

    public static void invokeLaterOnAppContext(AppContext appContext, Runnable runnable) {
        SunToolkit.postEvent(appContext, new PeerEvent(Toolkit.getDefaultToolkit(), runnable, 1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeOnEDTAndWait(Object object, Runnable runnable) throws InterruptedException, InvocationTargetException {
        if (EventQueue.isDispatchThread()) {
            throw new Error("Cannot call executeOnEDTAndWait from any event dispatcher thread");
        }
        class AWTInvocationLock {
            AWTInvocationLock() {
            }
        }
        AWTInvocationLock aWTInvocationLock = new AWTInvocationLock();
        PeerEvent peerEvent = new PeerEvent(object, runnable, aWTInvocationLock, true, 1L);
        Object object2 = aWTInvocationLock;
        synchronized (object2) {
            SunToolkit.executeOnEventHandlerThread(peerEvent);
            while (!peerEvent.isDispatched()) {
                aWTInvocationLock.wait();
            }
        }
        object2 = peerEvent.getThrowable();
        if (object2 != null) {
            throw new InvocationTargetException((Throwable)object2);
        }
    }

    public static boolean isDispatchThreadForAppContext(Object object) {
        AppContext appContext = SunToolkit.targetToAppContext(object);
        EventQueue eventQueue = (EventQueue)appContext.get(AppContext.EVENT_QUEUE_KEY);
        AWTAccessor.EventQueueAccessor eventQueueAccessor = AWTAccessor.getEventQueueAccessor();
        return eventQueueAccessor.isDispatchThreadImpl(eventQueue);
    }

    @Override
    public Dimension getScreenSize() {
        return new Dimension(this.getScreenWidth(), this.getScreenHeight());
    }

    protected abstract int getScreenWidth();

    protected abstract int getScreenHeight();

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return FontDesignMetrics.getMetrics(font);
    }

    @Override
    public String[] getFontList() {
        String[] stringArray = new String[]{"Dialog", "SansSerif", "Serif", "Monospaced", "DialogInput"};
        return stringArray;
    }

    @Override
    public PanelPeer createPanel(Panel panel) {
        return (PanelPeer)((Object)this.createComponent(panel));
    }

    @Override
    public CanvasPeer createCanvas(Canvas canvas) {
        return (CanvasPeer)((Object)this.createComponent(canvas));
    }

    public void disableBackgroundErase(Canvas canvas) {
        this.disableBackgroundEraseImpl(canvas);
    }

    public void disableBackgroundErase(Component component) {
        this.disableBackgroundEraseImpl(component);
    }

    private void disableBackgroundEraseImpl(Component component) {
        AWTAccessor.getComponentAccessor().setBackgroundEraseDisabled(component, true);
    }

    public static boolean getSunAwtNoerasebackground() {
        return AccessController.doPrivileged(new GetBooleanAction("sun.awt.noerasebackground"));
    }

    public static boolean getSunAwtErasebackgroundonresize() {
        return AccessController.doPrivileged(new GetBooleanAction("sun.awt.erasebackgroundonresize"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Image getImageFromHash(Toolkit toolkit, URL uRL) {
        SunToolkit.checkPermissions(uRL);
        SoftCache softCache = urlImgCache;
        synchronized (softCache) {
            String string = uRL.toString();
            Image image = (Image)urlImgCache.get(string);
            if (image == null) {
                try {
                    image = toolkit.createImage(new URLImageSource(uRL));
                    urlImgCache.put(string, image);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return image;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Image getImageFromHash(Toolkit toolkit, String string) {
        SunToolkit.checkPermissions(string);
        SoftCache softCache = fileImgCache;
        synchronized (softCache) {
            Image image = (Image)fileImgCache.get(string);
            if (image == null) {
                try {
                    image = toolkit.createImage(new FileImageSource(string));
                    fileImgCache.put(string, image);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return image;
        }
    }

    @Override
    public Image getImage(String string) {
        return SunToolkit.getImageFromHash((Toolkit)this, string);
    }

    @Override
    public Image getImage(URL uRL) {
        return SunToolkit.getImageFromHash((Toolkit)this, uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Image getImageWithResolutionVariant(String string, String string2) {
        SoftCache softCache = fileImgCache;
        synchronized (softCache) {
            Image image = SunToolkit.getImageFromHash((Toolkit)this, string);
            if (image instanceof MultiResolutionImage) {
                return image;
            }
            Image image2 = SunToolkit.getImageFromHash((Toolkit)this, string2);
            image = SunToolkit.createImageWithResolutionVariant(image, image2);
            fileImgCache.put(string, image);
            return image;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Image getImageWithResolutionVariant(URL uRL, URL uRL2) {
        SoftCache softCache = urlImgCache;
        synchronized (softCache) {
            Image image = SunToolkit.getImageFromHash((Toolkit)this, uRL);
            if (image instanceof MultiResolutionImage) {
                return image;
            }
            Image image2 = SunToolkit.getImageFromHash((Toolkit)this, uRL2);
            image = SunToolkit.createImageWithResolutionVariant(image, image2);
            String string = uRL.toString();
            urlImgCache.put(string, image);
            return image;
        }
    }

    @Override
    public Image createImage(String string) {
        SunToolkit.checkPermissions(string);
        return this.createImage(new FileImageSource(string));
    }

    @Override
    public Image createImage(URL uRL) {
        SunToolkit.checkPermissions(uRL);
        return this.createImage(new URLImageSource(uRL));
    }

    @Override
    public Image createImage(byte[] byArray, int n, int n2) {
        return this.createImage(new ByteArrayImageSource(byArray, n, n2));
    }

    @Override
    public Image createImage(ImageProducer imageProducer) {
        return new ToolkitImage(imageProducer);
    }

    public static Image createImageWithResolutionVariant(Image image, Image image2) {
        return new MultiResolutionToolkitImage(image, image2);
    }

    @Override
    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        if (!(image instanceof ToolkitImage)) {
            return 32;
        }
        ToolkitImage toolkitImage = (ToolkitImage)image;
        int n3 = n == 0 || n2 == 0 ? 32 : toolkitImage.getImageRep().check(imageObserver);
        return (toolkitImage.check(imageObserver) | n3) & this.checkResolutionVariant(image, n, n2, imageObserver);
    }

    @Override
    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        if (n == 0 || n2 == 0) {
            return true;
        }
        if (!(image instanceof ToolkitImage)) {
            return true;
        }
        ToolkitImage toolkitImage = (ToolkitImage)image;
        if (toolkitImage.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = toolkitImage.getImageRep();
        return imageRepresentation.prepare(imageObserver) & this.prepareResolutionVariant(image, n, n2, imageObserver);
    }

    private int checkResolutionVariant(Image image, int n, int n2, ImageObserver imageObserver) {
        ToolkitImage toolkitImage = SunToolkit.getResolutionVariant(image);
        int n3 = SunToolkit.getRVSize(n);
        int n4 = SunToolkit.getRVSize(n2);
        return toolkitImage == null || toolkitImage.hasError() ? 65535 : this.checkImage(toolkitImage, n3, n4, MultiResolutionToolkitImage.getResolutionVariantObserver(image, imageObserver, n, n2, n3, n4, true));
    }

    private boolean prepareResolutionVariant(Image image, int n, int n2, ImageObserver imageObserver) {
        ToolkitImage toolkitImage = SunToolkit.getResolutionVariant(image);
        int n3 = SunToolkit.getRVSize(n);
        int n4 = SunToolkit.getRVSize(n2);
        return toolkitImage == null || toolkitImage.hasError() || this.prepareImage(toolkitImage, n3, n4, MultiResolutionToolkitImage.getResolutionVariantObserver(image, imageObserver, n, n2, n3, n4, true));
    }

    private static int getRVSize(int n) {
        return n == -1 ? -1 : 2 * n;
    }

    private static ToolkitImage getResolutionVariant(Image image) {
        Image image2;
        if (image instanceof MultiResolutionToolkitImage && (image2 = ((MultiResolutionToolkitImage)image).getResolutionVariant()) instanceof ToolkitImage) {
            return (ToolkitImage)image2;
        }
        return null;
    }

    protected static boolean imageCached(String string) {
        return fileImgCache.containsKey(string);
    }

    protected static boolean imageCached(URL uRL) {
        String string = uRL.toString();
        return urlImgCache.containsKey(string);
    }

    protected static boolean imageExists(String string) {
        if (string != null) {
            SunToolkit.checkPermissions(string);
            return new File(string).exists();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean imageExists(URL uRL) {
        if (uRL == null) return false;
        SunToolkit.checkPermissions(uRL);
        try (InputStream inputStream = uRL.openStream();){
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static void checkPermissions(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string);
        }
    }

    private static void checkPermissions(URL uRL) {
        block7: {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    Permission permission = URLUtil.getConnectPermission(uRL);
                    if (permission == null) break block7;
                    try {
                        securityManager.checkPermission(permission);
                    }
                    catch (SecurityException securityException) {
                        if (permission instanceof FilePermission && permission.getActions().indexOf("read") != -1) {
                            securityManager.checkRead(permission.getName());
                            break block7;
                        }
                        if (permission instanceof SocketPermission && permission.getActions().indexOf("connect") != -1) {
                            securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                            break block7;
                        }
                        throw securityException;
                    }
                }
                catch (IOException iOException) {
                    securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getScaledIconImage(java.util.List<Image> list, int n, int n2) {
        int n3;
        if (n == 0 || n2 == 0) {
            return null;
        }
        Image object2 = null;
        int n4 = 0;
        int n5 = 0;
        double d = 3.0;
        double d2 = 0.0;
        for (Image object3 : list) {
            double d3;
            int n9;
            if (object3 == null) continue;
            if (object3 instanceof ToolkitImage) {
                ImageRepresentation n6 = ((ToolkitImage)object3).getImageRep();
                n6.reconstruct(32);
            }
            try {
                n9 = object3.getWidth(null);
                n3 = object3.getHeight(null);
            }
            catch (Exception d4) {
                continue;
            }
            if (n9 <= 0 || n3 <= 0) continue;
            double d4 = Math.min((double)n / (double)n9, (double)n2 / (double)n3);
            int n6 = 0;
            int n7 = 0;
            double d5 = 1.0;
            if (d4 >= 2.0) {
                d4 = Math.floor(d4);
                n6 = n9 * (int)d4;
                n7 = n3 * (int)d4;
                d5 = 1.0 - 0.5 / d4;
            } else if (d4 >= 1.0) {
                d4 = 1.0;
                n6 = n9;
                n7 = n3;
                d5 = 0.0;
            } else if (d4 >= 0.75) {
                d4 = 0.75;
                n6 = n9 * 3 / 4;
                n7 = n3 * 3 / 4;
                d5 = 0.3;
            } else if (d4 >= 0.6666) {
                d4 = 0.6666;
                n6 = n9 * 2 / 3;
                n7 = n3 * 2 / 3;
                d5 = 0.33;
            } else {
                d3 = Math.ceil(1.0 / d4);
                d4 = 1.0 / d3;
                n6 = (int)Math.round((double)n9 / d3);
                n7 = (int)Math.round((double)n3 / d3);
                d5 = 1.0 - 1.0 / d3;
            }
            d3 = ((double)n - (double)n6) / (double)n + ((double)n2 - (double)n7) / (double)n2 + d5;
            if (d3 < d) {
                d = d3;
                d2 = d4;
                object2 = object3;
                n4 = n6;
                n5 = n7;
            }
            if (d3 != 0.0) continue;
            break;
        }
        if (object2 == null) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        try {
            int n8 = (n - n4) / 2;
            n3 = (n2 - n5) / 2;
            graphics2D.drawImage(object2, n8, n3, n4, n5, null);
        }
        finally {
            graphics2D.dispose();
        }
        return bufferedImage;
    }

    public static DataBufferInt getScaledIconData(java.util.List<Image> list, int n, int n2) {
        BufferedImage bufferedImage = SunToolkit.getScaledIconImage(list, n, n2);
        if (bufferedImage == null) {
            return null;
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        return (DataBufferInt)dataBuffer;
    }

    @Override
    protected EventQueue getSystemEventQueueImpl() {
        return SunToolkit.getSystemEventQueueImplPP();
    }

    static EventQueue getSystemEventQueueImplPP() {
        return SunToolkit.getSystemEventQueueImplPP(AppContext.getAppContext());
    }

    public static EventQueue getSystemEventQueueImplPP(AppContext appContext) {
        EventQueue eventQueue = (EventQueue)appContext.get(AppContext.EVENT_QUEUE_KEY);
        return eventQueue;
    }

    public static Container getNativeContainer(Component component) {
        return Toolkit.getNativeContainer(component);
    }

    public static Component getHeavyweightComponent(Component component) {
        while (component != null && AWTAccessor.getComponentAccessor().isLightweight(component)) {
            component = AWTAccessor.getComponentAccessor().getParent(component);
        }
        return component;
    }

    public int getFocusAcceleratorKeyMask() {
        return 8;
    }

    public boolean isPrintableCharacterModifiersMask(int n) {
        return (n & 8) == (n & 2);
    }

    public boolean canPopupOverlapTaskBar() {
        boolean bl = true;
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(SecurityConstants.AWT.SET_WINDOW_ALWAYS_ON_TOP_PERMISSION);
            }
        }
        catch (SecurityException securityException) {
            bl = false;
        }
        return bl;
    }

    @Override
    public Window createInputMethodWindow(String string, InputContext inputContext) {
        return new SimpleInputMethodWindow(string, inputContext);
    }

    @Override
    public boolean enableInputMethodsForTextComponent() {
        return false;
    }

    public static Locale getStartupLocale() {
        if (startupLocale == null) {
            String string;
            String string2;
            String string3 = AccessController.doPrivileged(new GetPropertyAction("user.language", "en"));
            String string4 = AccessController.doPrivileged(new GetPropertyAction("user.region"));
            if (string4 != null) {
                int n = string4.indexOf(95);
                if (n >= 0) {
                    string2 = string4.substring(0, n);
                    string = string4.substring(n + 1);
                } else {
                    string2 = string4;
                    string = "";
                }
            } else {
                string2 = AccessController.doPrivileged(new GetPropertyAction("user.country", ""));
                string = AccessController.doPrivileged(new GetPropertyAction("user.variant", ""));
            }
            startupLocale = new Locale(string3, string2, string);
        }
        return startupLocale;
    }

    @Override
    public Locale getDefaultKeyboardLocale() {
        return SunToolkit.getStartupLocale();
    }

    @Override
    public WindowClosingListener getWindowClosingListener() {
        return this.windowClosingListener;
    }

    @Override
    public void setWindowClosingListener(WindowClosingListener windowClosingListener) {
        this.windowClosingListener = windowClosingListener;
    }

    @Override
    public RuntimeException windowClosingNotify(WindowEvent windowEvent) {
        if (this.windowClosingListener != null) {
            return this.windowClosingListener.windowClosingNotify(windowEvent);
        }
        return null;
    }

    @Override
    public RuntimeException windowClosingDelivered(WindowEvent windowEvent) {
        if (this.windowClosingListener != null) {
            return this.windowClosingListener.windowClosingDelivered(windowEvent);
        }
        return null;
    }

    protected synchronized MouseInfoPeer getMouseInfoPeer() {
        if (mPeer == null) {
            mPeer = new DefaultMouseInfoPeer();
        }
        return mPeer;
    }

    public static boolean needsXEmbed() {
        String string = AccessController.doPrivileged(new GetPropertyAction("sun.awt.noxembed", "false"));
        if ("true".equals(string)) {
            return false;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit instanceof SunToolkit) {
            return ((SunToolkit)toolkit).needsXEmbedImpl();
        }
        return false;
    }

    protected boolean needsXEmbedImpl() {
        return false;
    }

    protected final boolean isXEmbedServerRequested() {
        return AccessController.doPrivileged(new GetBooleanAction("sun.awt.xembedserver"));
    }

    public static boolean isModalExcludedSupported() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        return toolkit.isModalExclusionTypeSupported(DEFAULT_MODAL_EXCLUSION_TYPE);
    }

    protected boolean isModalExcludedSupportedImpl() {
        return false;
    }

    public static void setModalExcluded(Window window) {
        if (DEFAULT_MODAL_EXCLUSION_TYPE == null) {
            DEFAULT_MODAL_EXCLUSION_TYPE = Dialog.ModalExclusionType.APPLICATION_EXCLUDE;
        }
        window.setModalExclusionType(DEFAULT_MODAL_EXCLUSION_TYPE);
    }

    public static boolean isModalExcluded(Window window) {
        if (DEFAULT_MODAL_EXCLUSION_TYPE == null) {
            DEFAULT_MODAL_EXCLUSION_TYPE = Dialog.ModalExclusionType.APPLICATION_EXCLUDE;
        }
        return window.getModalExclusionType().compareTo(DEFAULT_MODAL_EXCLUSION_TYPE) >= 0;
    }

    @Override
    public boolean isModalityTypeSupported(Dialog.ModalityType modalityType) {
        return modalityType == Dialog.ModalityType.MODELESS || modalityType == Dialog.ModalityType.APPLICATION_MODAL;
    }

    @Override
    public boolean isModalExclusionTypeSupported(Dialog.ModalExclusionType modalExclusionType) {
        return modalExclusionType == Dialog.ModalExclusionType.NO_EXCLUDE;
    }

    public void addModalityListener(ModalityListener modalityListener) {
        this.modalityListeners.add(modalityListener);
    }

    public void removeModalityListener(ModalityListener modalityListener) {
        this.modalityListeners.remove(modalityListener);
    }

    public void notifyModalityPushed(Dialog dialog) {
        this.notifyModalityChange(1300, dialog);
    }

    public void notifyModalityPopped(Dialog dialog) {
        this.notifyModalityChange(1301, dialog);
    }

    final void notifyModalityChange(int n, Dialog dialog) {
        ModalityEvent modalityEvent = new ModalityEvent(dialog, this.modalityListeners, n);
        modalityEvent.dispatch();
    }

    public static boolean isLightweightOrUnknown(Component component) {
        if (component.isLightweight() || !(SunToolkit.getDefaultToolkit() instanceof SunToolkit)) {
            return true;
        }
        return !(component instanceof Button) && !(component instanceof Canvas) && !(component instanceof Checkbox) && !(component instanceof Choice) && !(component instanceof Label) && !(component instanceof List) && !(component instanceof Panel) && !(component instanceof Scrollbar) && !(component instanceof ScrollPane) && !(component instanceof TextArea) && !(component instanceof TextField) && !(component instanceof Window);
    }

    public void realSync() throws OperationTimedOut, InfiniteLoop {
        this.realSync(10000L);
    }

    public void realSync(long l) throws OperationTimedOut, InfiniteLoop {
        if (EventQueue.isDispatchThread()) {
            throw new IllegalThreadException("The SunToolkit.realSync() method cannot be used on the event dispatch thread (EDT).");
        }
        int n = 0;
        do {
            int n2;
            this.sync();
            for (n2 = 0; n2 < 0; ++n2) {
                this.syncNativeQueue(l);
            }
            while (this.syncNativeQueue(l) && n2 < 20) {
                ++n2;
            }
            if (n2 >= 20) {
                throw new InfiniteLoop();
            }
            for (n2 = 0; n2 < 0; ++n2) {
                this.waitForIdle(l);
            }
            while (this.waitForIdle(l) && n2 < 20) {
                ++n2;
            }
            if (n2 < 20) continue;
            throw new InfiniteLoop();
        } while ((this.syncNativeQueue(l) || this.waitForIdle(l)) && ++n < 20);
    }

    protected abstract boolean syncNativeQueue(long var1);

    private boolean isEQEmpty() {
        EventQueue eventQueue = this.getSystemEventQueueImpl();
        return AWTAccessor.getEventQueueAccessor().noEvents(eventQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean waitForIdle(final long l) {
        SunToolkit.flushPendingEvents();
        boolean bl = this.isEQEmpty();
        this.queueEmpty = false;
        this.eventDispatched = false;
        Object object = this.waitLock;
        synchronized (object) {
            SunToolkit.postEvent(AppContext.getAppContext(), new PeerEvent(this.getSystemEventQueueImpl(), null, 4L){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void dispatch() {
                    int n;
                    for (n = 0; n < 0; ++n) {
                        SunToolkit.this.syncNativeQueue(l);
                    }
                    while (SunToolkit.this.syncNativeQueue(l) && n < 20) {
                        ++n;
                    }
                    SunToolkit.flushPendingEvents();
                    Object object = SunToolkit.this.waitLock;
                    synchronized (object) {
                        SunToolkit.this.queueEmpty = SunToolkit.this.isEQEmpty();
                        SunToolkit.this.eventDispatched = true;
                        SunToolkit.this.waitLock.notifyAll();
                    }
                }
            });
            try {
                while (!this.eventDispatched) {
                    this.waitLock.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        try {
            Thread.sleep(0L);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted");
        }
        SunToolkit.flushPendingEvents();
        object = this.waitLock;
        synchronized (object) {
            return !this.queueEmpty || !this.isEQEmpty() || !bl;
        }
    }

    public abstract void grab(Window var1);

    public abstract void ungrab(Window var1);

    public static native void closeSplashScreen();

    private void fireDesktopFontPropertyChanges() {
        this.setDesktopProperty(DESKTOPFONTHINTS, SunToolkit.getDesktopFontHints());
    }

    public static void setAAFontSettingsCondition(boolean bl) {
        if (bl != lastExtraCondition) {
            lastExtraCondition = bl;
            if (checkedSystemAAFontSettings) {
                checkedSystemAAFontSettings = false;
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                if (toolkit instanceof SunToolkit) {
                    ((SunToolkit)toolkit).fireDesktopFontPropertyChanges();
                }
            }
        }
    }

    private static RenderingHints getDesktopAAHintsByName(String string) {
        Object object = null;
        if ((string = string.toLowerCase(Locale.ENGLISH)).equals("on")) {
            object = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
        } else if (string.equals("gasp")) {
            object = RenderingHints.VALUE_TEXT_ANTIALIAS_GASP;
        } else if (string.equals("lcd") || string.equals("lcd_hrgb")) {
            object = RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB;
        } else if (string.equals("lcd_hbgr")) {
            object = RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR;
        } else if (string.equals("lcd_vrgb")) {
            object = RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VRGB;
        } else if (string.equals("lcd_vbgr")) {
            object = RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VBGR;
        }
        if (object != null) {
            RenderingHints renderingHints = new RenderingHints(null);
            renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, object);
            return renderingHints;
        }
        return null;
    }

    private static boolean useSystemAAFontSettings() {
        if (!checkedSystemAAFontSettings) {
            useSystemAAFontSettings = true;
            String string = null;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (toolkit instanceof SunToolkit) {
                string = AccessController.doPrivileged(new GetPropertyAction("awt.useSystemAAFontSettings"));
            }
            if (string != null && !(useSystemAAFontSettings = Boolean.valueOf(string).booleanValue())) {
                desktopFontHints = SunToolkit.getDesktopAAHintsByName(string);
            }
            if (useSystemAAFontSettings) {
                useSystemAAFontSettings = lastExtraCondition;
            }
            checkedSystemAAFontSettings = true;
        }
        return useSystemAAFontSettings;
    }

    protected RenderingHints getDesktopAAHints() {
        return null;
    }

    public static RenderingHints getDesktopFontHints() {
        if (SunToolkit.useSystemAAFontSettings()) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (toolkit instanceof SunToolkit) {
                RenderingHints renderingHints = ((SunToolkit)toolkit).getDesktopAAHints();
                return renderingHints;
            }
            return null;
        }
        if (desktopFontHints != null) {
            return (RenderingHints)desktopFontHints.clone();
        }
        return null;
    }

    public abstract boolean isDesktopSupported();

    public static synchronized void consumeNextKeyTyped(KeyEvent keyEvent) {
        try {
            AWTAccessor.getDefaultKeyboardFocusManagerAccessor().consumeNextKeyTyped((DefaultKeyboardFocusManager)KeyboardFocusManager.getCurrentKeyboardFocusManager(), keyEvent);
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
        }
    }

    protected static void dumpPeers(PlatformLogger platformLogger) {
        AWTAutoShutdown.getInstance().dumpPeers(platformLogger);
    }

    public static Window getContainingWindow(Component component) {
        while (component != null && !(component instanceof Window)) {
            component = component.getParent();
        }
        return (Window)component;
    }

    public static synchronized boolean getSunAwtDisableMixing() {
        if (sunAwtDisableMixing == null) {
            sunAwtDisableMixing = AccessController.doPrivileged(new GetBooleanAction("sun.awt.disableMixing"));
        }
        return sunAwtDisableMixing;
    }

    public boolean isNativeGTKAvailable() {
        return false;
    }

    public synchronized void setWindowDeactivationTime(Window window, long l) {
        AppContext appContext = SunToolkit.getAppContext(window);
        WeakHashMap<Window, Long> weakHashMap = (WeakHashMap<Window, Long>)appContext.get(DEACTIVATION_TIMES_MAP_KEY);
        if (weakHashMap == null) {
            weakHashMap = new WeakHashMap<Window, Long>();
            appContext.put(DEACTIVATION_TIMES_MAP_KEY, weakHashMap);
        }
        weakHashMap.put(window, l);
    }

    public synchronized long getWindowDeactivationTime(Window window) {
        AppContext appContext = SunToolkit.getAppContext(window);
        WeakHashMap weakHashMap = (WeakHashMap)appContext.get(DEACTIVATION_TIMES_MAP_KEY);
        if (weakHashMap == null) {
            return -1L;
        }
        Long l = (Long)weakHashMap.get(window);
        return l == null ? -1L : l;
    }

    public boolean isWindowOpacitySupported() {
        return false;
    }

    public boolean isWindowShapingSupported() {
        return false;
    }

    public boolean isWindowTranslucencySupported() {
        return false;
    }

    public boolean isTranslucencyCapable(GraphicsConfiguration graphicsConfiguration) {
        return false;
    }

    public boolean isSwingBackbufferTranslucencySupported() {
        return false;
    }

    public static boolean isContainingTopLevelOpaque(Component component) {
        Window window = SunToolkit.getContainingWindow(component);
        return window != null && window.isOpaque();
    }

    public static boolean isContainingTopLevelTranslucent(Component component) {
        Window window = SunToolkit.getContainingWindow(component);
        return window != null && window.getOpacity() < 1.0f;
    }

    public boolean needUpdateWindow() {
        return false;
    }

    public int getNumberOfButtons() {
        return 3;
    }

    public static boolean isInstanceOf(Object object, String string) {
        if (object == null) {
            return false;
        }
        if (string == null) {
            return false;
        }
        return SunToolkit.isInstanceOf(object.getClass(), string);
    }

    private static boolean isInstanceOf(Class<?> clazz, String string) {
        if (clazz == null) {
            return false;
        }
        if (clazz.getName().equals(string)) {
            return true;
        }
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            if (!clazz2.getName().equals(string)) continue;
            return true;
        }
        return SunToolkit.isInstanceOf(clazz.getSuperclass(), string);
    }

    protected static LightweightFrame getLightweightFrame(Component component) {
        while (component != null) {
            if (component instanceof LightweightFrame) {
                return (LightweightFrame)component;
            }
            if (component instanceof Window) {
                return null;
            }
            component = component.getParent();
        }
        return null;
    }

    public static void setSystemGenerated(AWTEvent aWTEvent) {
        AWTAccessor.getAWTEventAccessor().setSystemGenerated(aWTEvent);
    }

    public static boolean isSystemGenerated(AWTEvent aWTEvent) {
        return AWTAccessor.getAWTEventAccessor().isSystemGenerated(aWTEvent);
    }

    static {
        boolean bl = $assertionsDisabled = !SunToolkit.class.desiredAssertionStatus();
        if (AccessController.doPrivileged(new GetBooleanAction("sun.awt.nativedebug")).booleanValue()) {
            DebugSettings.init();
        }
        numberOfButtons = 0;
        AWT_LOCK = new ReentrantLock();
        AWT_LOCK_COND = AWT_LOCK.newCondition();
        appContextMap = Collections.synchronizedMap(new WeakHashMap());
        fileImgCache = new SoftCache();
        urlImgCache = new SoftCache();
        startupLocale = null;
        mPeer = null;
        DEFAULT_MODAL_EXCLUSION_TYPE = null;
        lastExtraCondition = true;
        sunAwtDisableMixing = null;
        DEACTIVATION_TIMES_MAP_KEY = new Object();
    }

    public static class IllegalThreadException
    extends RuntimeException {
        public IllegalThreadException(String string) {
            super(string);
        }

        public IllegalThreadException() {
        }
    }

    public static class InfiniteLoop
    extends RuntimeException {
    }

    public static class OperationTimedOut
    extends RuntimeException {
        public OperationTimedOut(String string) {
            super(string);
        }

        public OperationTimedOut() {
        }
    }

    static class ModalityListenerList
    implements ModalityListener {
        Vector<ModalityListener> listeners = new Vector();

        ModalityListenerList() {
        }

        void add(ModalityListener modalityListener) {
            this.listeners.addElement(modalityListener);
        }

        void remove(ModalityListener modalityListener) {
            this.listeners.removeElement(modalityListener);
        }

        @Override
        public void modalityPushed(ModalityEvent modalityEvent) {
            Iterator<ModalityListener> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().modalityPushed(modalityEvent);
            }
        }

        @Override
        public void modalityPopped(ModalityEvent modalityEvent) {
            Iterator<ModalityListener> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().modalityPopped(modalityEvent);
            }
        }
    }
}

