/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.Attribute;
import com.sun.java.util.jar.pack.Code;
import com.sun.java.util.jar.pack.ConstantPool;
import com.sun.java.util.jar.pack.Instruction;
import com.sun.java.util.jar.pack.Package;
import com.sun.java.util.jar.pack.Utils;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

class ClassReader {
    int verbose;
    Package pkg;
    Package.Class cls;
    long inPos;
    long constantPoolLimit = -1L;
    DataInputStream in;
    Map<Attribute.Layout, Attribute> attrDefs;
    Map<Attribute.Layout, String> attrCommands;
    String unknownAttrCommand = "error";
    boolean haveUnresolvedEntry;

    ClassReader(Package.Class clazz, InputStream inputStream) throws IOException {
        this.pkg = clazz.getPackage();
        this.cls = clazz;
        this.verbose = this.pkg.verbose;
        this.in = new DataInputStream(new FilterInputStream(inputStream){

            @Override
            public int read(byte[] byArray, int n, int n2) throws IOException {
                int n3 = super.read(byArray, n, n2);
                if (n3 >= 0) {
                    ClassReader.this.inPos += (long)n3;
                }
                return n3;
            }

            @Override
            public int read() throws IOException {
                int n = super.read();
                if (n >= 0) {
                    ++ClassReader.this.inPos;
                }
                return n;
            }

            @Override
            public long skip(long l) throws IOException {
                long l2 = super.skip(l);
                if (l2 >= 0L) {
                    ClassReader.this.inPos += l2;
                }
                return l2;
            }
        });
    }

    public void setAttrDefs(Map<Attribute.Layout, Attribute> map) {
        this.attrDefs = map;
    }

    public void setAttrCommands(Map<Attribute.Layout, String> map) {
        this.attrCommands = map;
    }

    private void skip(int n, String string) throws IOException {
        long l;
        long l2;
        Utils.log.warning("skipping " + n + " bytes of " + string);
        for (l = 0L; l < (long)n; l += l2) {
            l2 = this.in.skip((long)n - l);
            assert (l2 > 0L);
        }
        assert (l == (long)n);
    }

    private int readUnsignedShort() throws IOException {
        return this.in.readUnsignedShort();
    }

    private int readInt() throws IOException {
        return this.in.readInt();
    }

    private ConstantPool.Entry readRef() throws IOException {
        int n = this.in.readUnsignedShort();
        return n == 0 ? null : this.cls.cpMap[n];
    }

    private ConstantPool.Entry readRef(byte by) throws IOException {
        ConstantPool.Entry entry = this.readRef();
        assert (!(entry instanceof UnresolvedEntry));
        this.checkTag(entry, by);
        return entry;
    }

    private ConstantPool.Entry checkTag(ConstantPool.Entry entry, byte by) throws ClassFormatException {
        if (entry == null || !entry.tagMatches(by)) {
            String string = this.inPos == this.constantPoolLimit ? " in constant pool" : " at pos: " + this.inPos;
            String string2 = entry == null ? "null CP index" : "type=" + ConstantPool.tagName(entry.tag);
            throw new ClassFormatException("Bad constant, expected type=" + ConstantPool.tagName(by) + " got " + string2 + ", in File: " + this.cls.file.nameString + string);
        }
        return entry;
    }

    private ConstantPool.Entry checkTag(ConstantPool.Entry entry, byte by, boolean bl) throws ClassFormatException {
        return bl && entry == null ? null : this.checkTag(entry, by);
    }

    private ConstantPool.Entry readRefOrNull(byte by) throws IOException {
        ConstantPool.Entry entry = this.readRef();
        this.checkTag(entry, by, true);
        return entry;
    }

    private ConstantPool.Utf8Entry readUtf8Ref() throws IOException {
        return (ConstantPool.Utf8Entry)this.readRef((byte)1);
    }

    private ConstantPool.ClassEntry readClassRef() throws IOException {
        return (ConstantPool.ClassEntry)this.readRef((byte)7);
    }

    private ConstantPool.ClassEntry readClassRefOrNull() throws IOException {
        return (ConstantPool.ClassEntry)this.readRefOrNull((byte)7);
    }

    private ConstantPool.SignatureEntry readSignatureRef() throws IOException {
        ConstantPool.Entry entry = this.readRef((byte)13);
        return entry != null && entry.getTag() == 1 ? ConstantPool.getSignatureEntry(entry.stringValue()) : (ConstantPool.SignatureEntry)entry;
    }

    void read() throws IOException {
        boolean bl = false;
        try {
            this.readMagicNumbers();
            this.readConstantPool();
            this.readHeader();
            this.readMembers(false);
            this.readMembers(true);
            this.readAttributes(0, this.cls);
            this.fixUnresolvedEntries();
            this.cls.finishReading();
            assert (0 >= this.in.read(new byte[1]));
            bl = true;
        }
        finally {
            if (!bl && this.verbose > 0) {
                Utils.log.warning("Erroneous data at input offset " + this.inPos + " of " + this.cls.file);
            }
        }
    }

    void readMagicNumbers() throws IOException {
        this.cls.magic = this.in.readInt();
        if (this.cls.magic != -889275714) {
            throw new Attribute.FormatException("Bad magic number in class file " + Integer.toHexString(this.cls.magic), 0, "magic-number", "pass");
        }
        short s = (short)this.readUnsignedShort();
        short s2 = (short)this.readUnsignedShort();
        this.cls.version = Package.Version.of(s2, s);
        String string = this.checkVersion(this.cls.version);
        if (string != null) {
            throw new Attribute.FormatException("classfile version too " + string + ": " + this.cls.version + " in " + this.cls.file, 0, "version", "pass");
        }
    }

    private String checkVersion(Package.Version version) {
        short s = version.major;
        short s2 = version.minor;
        if (s < this.pkg.minClassVersion.major || s == this.pkg.minClassVersion.major && s2 < this.pkg.minClassVersion.minor) {
            return "small";
        }
        if (s > this.pkg.maxClassVersion.major || s == this.pkg.maxClassVersion.major && s2 > this.pkg.maxClassVersion.minor) {
            return "large";
        }
        return null;
    }

    void readConstantPool() throws IOException {
        int n;
        int n2;
        int n3 = this.in.readUnsignedShort();
        int[] nArray = new int[n3 * 4];
        int n4 = 0;
        ConstantPool.Entry[] entryArray = new ConstantPool.Entry[n3];
        entryArray[0] = null;
        block20: for (n2 = 1; n2 < n3; ++n2) {
            n = this.in.readByte();
            switch (n) {
                case 1: {
                    entryArray[n2] = ConstantPool.getUtf8Entry(this.in.readUTF());
                    continue block20;
                }
                case 3: {
                    entryArray[n2] = ConstantPool.getLiteralEntry(Integer.valueOf(this.in.readInt()));
                    continue block20;
                }
                case 4: {
                    entryArray[n2] = ConstantPool.getLiteralEntry(Float.valueOf(this.in.readFloat()));
                    continue block20;
                }
                case 5: {
                    entryArray[n2] = ConstantPool.getLiteralEntry(Long.valueOf(this.in.readLong()));
                    entryArray[++n2] = null;
                    continue block20;
                }
                case 6: {
                    entryArray[n2] = ConstantPool.getLiteralEntry(Double.valueOf(this.in.readDouble()));
                    entryArray[++n2] = null;
                    continue block20;
                }
                case 7: 
                case 8: 
                case 16: {
                    nArray[n4++] = n2;
                    nArray[n4++] = n;
                    nArray[n4++] = this.in.readUnsignedShort();
                    nArray[n4++] = -1;
                    continue block20;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    nArray[n4++] = n2;
                    nArray[n4++] = n;
                    nArray[n4++] = this.in.readUnsignedShort();
                    nArray[n4++] = this.in.readUnsignedShort();
                    continue block20;
                }
                case 18: {
                    nArray[n4++] = n2;
                    nArray[n4++] = n;
                    nArray[n4++] = 0xFFFFFFFF ^ this.in.readUnsignedShort();
                    nArray[n4++] = this.in.readUnsignedShort();
                    continue block20;
                }
                case 15: {
                    nArray[n4++] = n2;
                    nArray[n4++] = n;
                    nArray[n4++] = 0xFFFFFFFF ^ this.in.readUnsignedByte();
                    nArray[n4++] = this.in.readUnsignedShort();
                    continue block20;
                }
                default: {
                    throw new ClassFormatException("Bad constant pool tag " + n + " in File: " + this.cls.file.nameString + " at pos: " + this.inPos);
                }
            }
        }
        this.constantPoolLimit = this.inPos;
        while (n4 > 0) {
            if (this.verbose > 3) {
                Utils.log.fine("CP fixups [" + n4 / 4 + "]");
            }
            n2 = n4;
            n4 = 0;
            n = 0;
            block22: while (n < n2) {
                int n5 = nArray[n++];
                int n6 = nArray[n++];
                int n7 = nArray[n++];
                int n8 = nArray[n++];
                if (this.verbose > 3) {
                    Utils.log.fine("  cp[" + n5 + "] = " + ConstantPool.tagName(n6) + "{" + n7 + "," + n8 + "}");
                }
                if (n7 >= 0 && entryArray[n7] == null || n8 >= 0 && entryArray[n8] == null) {
                    nArray[n4++] = n5;
                    nArray[n4++] = n6;
                    nArray[n4++] = n7;
                    nArray[n4++] = n8;
                    continue;
                }
                switch (n6) {
                    case 7: {
                        entryArray[n5] = ConstantPool.getClassEntry(entryArray[n7].stringValue());
                        continue block22;
                    }
                    case 8: {
                        entryArray[n5] = ConstantPool.getStringEntry(entryArray[n7].stringValue());
                        continue block22;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        ConstantPool.ClassEntry classEntry = (ConstantPool.ClassEntry)this.checkTag(entryArray[n7], (byte)7);
                        ConstantPool.DescriptorEntry descriptorEntry = (ConstantPool.DescriptorEntry)this.checkTag(entryArray[n8], (byte)12);
                        entryArray[n5] = ConstantPool.getMemberEntry((byte)n6, classEntry, descriptorEntry);
                        continue block22;
                    }
                    case 12: {
                        ConstantPool.Utf8Entry utf8Entry = (ConstantPool.Utf8Entry)this.checkTag(entryArray[n7], (byte)1);
                        ConstantPool.Utf8Entry utf8Entry2 = (ConstantPool.Utf8Entry)this.checkTag(entryArray[n8], (byte)13);
                        entryArray[n5] = ConstantPool.getDescriptorEntry(utf8Entry, utf8Entry2);
                        continue block22;
                    }
                    case 16: {
                        entryArray[n5] = ConstantPool.getMethodTypeEntry((ConstantPool.Utf8Entry)this.checkTag(entryArray[n7], (byte)13));
                        continue block22;
                    }
                    case 15: {
                        byte by = (byte)(0xFFFFFFFF ^ n7);
                        ConstantPool.MemberEntry memberEntry = (ConstantPool.MemberEntry)this.checkTag(entryArray[n8], (byte)52);
                        entryArray[n5] = ConstantPool.getMethodHandleEntry(by, memberEntry);
                        continue block22;
                    }
                    case 18: {
                        ConstantPool.DescriptorEntry descriptorEntry = (ConstantPool.DescriptorEntry)this.checkTag(entryArray[n8], (byte)12);
                        entryArray[n5] = new UnresolvedEntry((byte)n6, 0xFFFFFFFF ^ n7, descriptorEntry);
                        continue block22;
                    }
                }
                assert (false);
            }
            assert (n4 < n2);
        }
        this.cls.cpMap = entryArray;
    }

    private void fixUnresolvedEntries() {
        if (!this.haveUnresolvedEntry) {
            return;
        }
        ConstantPool.Entry[] entryArray = this.cls.getCPMap();
        for (int i = 0; i < entryArray.length; ++i) {
            ConstantPool.Entry entry = entryArray[i];
            if (!(entry instanceof UnresolvedEntry)) continue;
            entryArray[i] = entry = ((UnresolvedEntry)entry).resolve();
            assert (!(entry instanceof UnresolvedEntry));
        }
        this.haveUnresolvedEntry = false;
    }

    void readHeader() throws IOException {
        this.cls.flags = this.readUnsignedShort();
        this.cls.thisClass = this.readClassRef();
        this.cls.superClass = this.readClassRefOrNull();
        int n = this.readUnsignedShort();
        this.cls.interfaces = new ConstantPool.ClassEntry[n];
        for (int i = 0; i < n; ++i) {
            this.cls.interfaces[i] = this.readClassRef();
        }
    }

    void readMembers(boolean bl) throws IOException {
        int n = this.readUnsignedShort();
        for (int i = 0; i < n; ++i) {
            this.readMember(bl);
        }
    }

    void readMember(boolean bl) throws IOException {
        Package.Class.Member member;
        int n = this.readUnsignedShort();
        ConstantPool.Utf8Entry utf8Entry = this.readUtf8Ref();
        ConstantPool.SignatureEntry signatureEntry = this.readSignatureRef();
        ConstantPool.DescriptorEntry descriptorEntry = ConstantPool.getDescriptorEntry(utf8Entry, signatureEntry);
        if (!bl) {
            Package.Class clazz = this.cls;
            clazz.getClass();
            member = clazz.new Package.Class.Field(n, descriptorEntry);
        } else {
            Package.Class clazz = this.cls;
            clazz.getClass();
            member = clazz.new Package.Class.Method(n, descriptorEntry);
        }
        this.readAttributes(!bl ? 1 : 2, member);
    }

    /*
     * Unable to fully structure code
     */
    void readAttributes(int var1_1, Attribute.Holder var2_2) throws IOException {
        var3_3 = this.readUnsignedShort();
        if (var3_3 == 0) {
            return;
        }
        if (this.verbose > 3) {
            Utils.log.fine("readAttributes " + var2_2 + " [" + var3_3 + "]");
        }
        block12: for (var4_4 = 0; var4_4 < var3_3; ++var4_4) {
            var5_5 = this.readUtf8Ref().stringValue();
            var6_6 = this.readInt();
            if (this.attrCommands == null || (var8_8 = this.attrCommands.get(var7_7 = Attribute.keyForLookup(var1_1, var5_5))) == null) ** GOTO lbl-1000
            var9_10 = var8_8;
            var10_12 = -1;
            switch (var9_10.hashCode()) {
                case 3433489: {
                    if (!var9_10.equals("pass")) break;
                    var10_12 = 0;
                    break;
                }
                case 96784904: {
                    if (!var9_10.equals("error")) break;
                    var10_12 = 1;
                    break;
                }
                case 109773592: {
                    if (!var9_10.equals("strip")) break;
                    var10_12 = 2;
                }
            }
            switch (var10_12) {
                case 0: {
                    var11_13 = "passing attribute bitwise in " + var2_2;
                    throw new Attribute.FormatException((String)var11_13, var1_1, var5_5, var8_8);
                }
                case 1: {
                    var12_14 = "attribute not allowed in " + var2_2;
                    throw new Attribute.FormatException(var12_14, var1_1, var5_5, var8_8);
                }
                case 2: {
                    this.skip(var6_6, var5_5 + " attribute in " + var2_2);
                    continue block12;
                }
                default: lbl-1000:
                // 2 sources

                {
                    var7_7 = Attribute.lookup(Package.attrDefs, var1_1, var5_5);
                    if (this.verbose > 4 && var7_7 != null) {
                        Utils.log.fine("pkg_attribute_lookup " + var5_5 + " = " + var7_7);
                    }
                    if (var7_7 == null) {
                        var7_7 = Attribute.lookup(this.attrDefs, var1_1, var5_5);
                        if (this.verbose > 4 && var7_7 != null) {
                            Utils.log.fine("this " + var5_5 + " = " + var7_7);
                        }
                    }
                    if (var7_7 == null) {
                        var7_7 = Attribute.lookup(null, var1_1, var5_5);
                        if (this.verbose > 4 && var7_7 != null) {
                            Utils.log.fine("null_attribute_lookup " + var5_5 + " = " + var7_7);
                        }
                    }
                    if (var7_7 == null && var6_6 == 0) {
                        var7_7 = Attribute.find(var1_1, var5_5, "");
                    }
                    v0 = var8_9 = var1_1 == 3 && (var5_5.equals("StackMap") != false || var5_5.equals("StackMapX") != false);
                    if (var8_9) {
                        var9_10 = (Code)var2_2;
                        if (var9_10.max_stack >= 65536 || var9_10.max_locals >= 65536 || var9_10.getLength() >= 65536 || var5_5.endsWith("X")) {
                            var7_7 = null;
                        }
                    }
                    if (var7_7 == null) {
                        if (var8_9) {
                            var9_10 = "unsupported StackMap variant in " + var2_2;
                            throw new Attribute.FormatException((String)var9_10, var1_1, var5_5, "pass");
                        }
                        if ("strip".equals(this.unknownAttrCommand)) {
                            this.skip(var6_6, "unknown " + var5_5 + " attribute in " + var2_2);
                            continue block12;
                        }
                        var9_10 = " is unknown attribute in class " + var2_2;
                        throw new Attribute.FormatException((String)var9_10, var1_1, var5_5, this.unknownAttrCommand);
                    }
                    var9_11 = this.inPos;
                    if (var7_7.layout() == Package.attrCodeEmpty) {
                        var11_13 = (Package.Class.Method)var2_2;
                        var11_13.code = new Code((Package.Class.Method)var11_13);
                        try {
                            this.readCode(var11_13.code);
                        }
                        catch (Instruction.FormatException var12_15) {
                            var13_16 = var12_15.getMessage() + " in " + var2_2;
                            throw new ClassFormatException(var13_16, var12_15);
                        }
                        if (!ClassReader.$assertionsDisabled && (long)var6_6 != this.inPos - var9_11) {
                            throw new AssertionError();
                        }
                    } else {
                        if (var7_7.layout() == Package.attrBootstrapMethodsEmpty) {
                            if (!ClassReader.$assertionsDisabled && var2_2 != this.cls) {
                                throw new AssertionError();
                            }
                            this.readBootstrapMethods(this.cls);
                            if (!ClassReader.$assertionsDisabled && (long)var6_6 != this.inPos - var9_11) {
                                throw new AssertionError();
                            }
                            continue block12;
                        }
                        if (var7_7.layout() == Package.attrInnerClassesEmpty) {
                            if (!ClassReader.$assertionsDisabled && var2_2 != this.cls) {
                                throw new AssertionError();
                            }
                            this.readInnerClasses(this.cls);
                            if (!ClassReader.$assertionsDisabled && (long)var6_6 != this.inPos - var9_11) {
                                throw new AssertionError();
                            }
                        } else if (var6_6 > 0) {
                            var11_13 = new byte[var6_6];
                            this.in.readFully((byte[])var11_13);
                            var7_7 = var7_7.addContent((byte[])var11_13);
                        }
                    }
                    if (var7_7.size() == 0 && !var7_7.layout().isEmpty()) {
                        throw new ClassFormatException(var5_5 + ": attribute length cannot be zero, in " + var2_2);
                    }
                    var2_2.addAttribute((Attribute)var7_7);
                    if (this.verbose <= 2) continue block12;
                    Utils.log.fine("read " + var7_7);
                }
            }
        }
    }

    void readCode(Code code) throws IOException {
        code.max_stack = this.readUnsignedShort();
        code.max_locals = this.readUnsignedShort();
        code.bytes = new byte[this.readInt()];
        this.in.readFully(code.bytes);
        ConstantPool.Entry[] entryArray = this.cls.getCPMap();
        Instruction.opcodeChecker(code.bytes, entryArray, this.cls.version);
        int n = this.readUnsignedShort();
        code.setHandlerCount(n);
        for (int i = 0; i < n; ++i) {
            code.handler_start[i] = this.readUnsignedShort();
            code.handler_end[i] = this.readUnsignedShort();
            code.handler_catch[i] = this.readUnsignedShort();
            code.handler_class[i] = this.readClassRefOrNull();
        }
        this.readAttributes(3, code);
    }

    void readBootstrapMethods(Package.Class clazz) throws IOException {
        ConstantPool.BootstrapMethodEntry[] bootstrapMethodEntryArray = new ConstantPool.BootstrapMethodEntry[this.readUnsignedShort()];
        for (int i = 0; i < bootstrapMethodEntryArray.length; ++i) {
            ConstantPool.MethodHandleEntry methodHandleEntry = (ConstantPool.MethodHandleEntry)this.readRef((byte)15);
            ConstantPool.Entry[] entryArray = new ConstantPool.Entry[this.readUnsignedShort()];
            for (int j = 0; j < entryArray.length; ++j) {
                entryArray[j] = this.readRef((byte)51);
            }
            bootstrapMethodEntryArray[i] = ConstantPool.getBootstrapMethodEntry(methodHandleEntry, entryArray);
        }
        clazz.setBootstrapMethods(Arrays.asList(bootstrapMethodEntryArray));
    }

    void readInnerClasses(Package.Class clazz) throws IOException {
        int n = this.readUnsignedShort();
        ArrayList<Package.InnerClass> arrayList = new ArrayList<Package.InnerClass>(n);
        for (int i = 0; i < n; ++i) {
            Package.InnerClass innerClass = new Package.InnerClass(this.readClassRef(), this.readClassRefOrNull(), (ConstantPool.Utf8Entry)this.readRefOrNull((byte)1), this.readUnsignedShort());
            arrayList.add(innerClass);
        }
        clazz.innerClasses = arrayList;
    }

    static class ClassFormatException
    extends IOException {
        private static final long serialVersionUID = -3564121733989501833L;

        public ClassFormatException(String string) {
            super(string);
        }

        public ClassFormatException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    private class UnresolvedEntry
    extends ConstantPool.Entry {
        final Object[] refsOrIndexes;

        UnresolvedEntry(byte by, Object ... objectArray) {
            super(by);
            this.refsOrIndexes = objectArray;
            ClassReader.this.haveUnresolvedEntry = true;
        }

        ConstantPool.Entry resolve() {
            ConstantPool.InvokeDynamicEntry invokeDynamicEntry;
            Package.Class clazz = ClassReader.this.cls;
            switch (this.tag) {
                case 18: {
                    ConstantPool.BootstrapMethodEntry bootstrapMethodEntry = clazz.bootstrapMethods.get((Integer)this.refsOrIndexes[0]);
                    ConstantPool.DescriptorEntry descriptorEntry = (ConstantPool.DescriptorEntry)this.refsOrIndexes[1];
                    invokeDynamicEntry = ConstantPool.getInvokeDynamicEntry(bootstrapMethodEntry, descriptorEntry);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            return invokeDynamicEntry;
        }

        private void unresolved() {
            throw new RuntimeException("unresolved entry has no string");
        }

        @Override
        public int compareTo(Object object) {
            this.unresolved();
            return 0;
        }

        @Override
        public boolean equals(Object object) {
            this.unresolved();
            return false;
        }

        @Override
        protected int computeValueHash() {
            this.unresolved();
            return 0;
        }

        @Override
        public String stringValue() {
            this.unresolved();
            return this.toString();
        }

        @Override
        public String toString() {
            return "(unresolved " + ConstantPool.tagName(this.tag) + ")";
        }
    }
}

