/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.modules;

import io.anuke.mindustry.Vars;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.ItemStack;
import io.anuke.mindustry.world.modules.BlockModule;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public class ItemModule
extends BlockModule {
    private int[] items;
    private int total;

    public ItemModule() {
        this.items = new int[Vars.content.items().size];
    }

    public void forEach(ItemConsumer cons) {
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] <= 0) continue;
            cons.accept(Vars.content.item(i), this.items[i]);
        }
    }

    public float sum(ItemCalculator calc) {
        float sum = 0.0f;
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] <= 0) continue;
            sum += calc.get(Vars.content.item(i), this.items[i]);
        }
        return sum;
    }

    public boolean has(Item item) {
        return this.get(item) > 0;
    }

    public boolean has(Item item, int amount) {
        return this.get(item) >= amount;
    }

    public boolean has(ItemStack[] stacks) {
        for (ItemStack stack : stacks) {
            if (this.has(stack.item, stack.amount)) continue;
            return false;
        }
        return true;
    }

    public boolean has(ItemStack[] stacks, float multiplier) {
        for (ItemStack stack : stacks) {
            if (this.has(stack.item, Math.round((float)stack.amount * multiplier))) continue;
            return false;
        }
        return true;
    }

    public boolean hasOne(ItemStack[] stacks) {
        for (ItemStack stack : stacks) {
            if (this.has(stack.item, 1)) continue;
            return false;
        }
        return true;
    }

    public int total() {
        return this.total;
    }

    public Item take() {
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] <= 0) continue;
            int n = i;
            this.items[n] = this.items[n] - 1;
            --this.total;
            return Vars.content.item(i);
        }
        return null;
    }

    public int get(Item item) {
        return this.items[item.id];
    }

    public void set(Item item, int amount) {
        this.total += amount - this.items[item.id];
        this.items[item.id] = amount;
    }

    public void add(Item item, int amount) {
        short s = item.id;
        this.items[s] = this.items[s] + amount;
        this.total += amount;
    }

    public void addAll(ItemModule items) {
        for (int i = 0; i < items.items.length; ++i) {
            int n = i;
            this.items[n] = this.items[n] + items.items[i];
            this.total += items.items[i];
        }
    }

    public void remove(Item item, int amount) {
        amount = Math.min(amount, this.items[item.id]);
        short s = item.id;
        this.items[s] = this.items[s] - amount;
        this.total -= amount;
    }

    public void remove(ItemStack stack) {
        this.remove(stack.item, stack.amount);
    }

    public void clear() {
        Arrays.fill(this.items, 0);
        this.total = 0;
    }

    @Override
    public void write(DataOutput stream) throws IOException {
        int amount = 0;
        for (int item : this.items) {
            if (item <= 0) continue;
            amount = (byte)(amount + 1);
        }
        stream.writeByte(amount);
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] <= 0) continue;
            stream.writeByte(i);
            stream.writeInt(this.items[i]);
        }
    }

    @Override
    public void read(DataInput stream) throws IOException {
        Arrays.fill(this.items, 0);
        int count = stream.readByte();
        this.total = 0;
        for (int j = 0; j < count; ++j) {
            int itemamount;
            byte itemid = stream.readByte();
            this.items[Vars.content.item((int)itemid).id] = itemamount = stream.readInt();
            this.total += itemamount;
        }
    }

    public static interface ItemCalculator {
        public float get(Item var1, int var2);
    }

    public static interface ItemConsumer {
        public void accept(Item var1, float var2);
    }
}

