/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.modules;

import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.world.consumers.Consume;
import io.anuke.mindustry.world.modules.BlockModule;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ConsumeModule
extends BlockModule {
    private boolean valid;
    private boolean optionalValid;
    private final TileEntity entity;

    public ConsumeModule(TileEntity entity) {
        this.entity = entity;
    }

    public void update() {
        if (this.entity.tile.isEnemyCheat()) {
            this.optionalValid = true;
            this.valid = true;
            return;
        }
        boolean prevValid = this.valid();
        this.valid = true;
        this.optionalValid = true;
        boolean docons = this.entity.block.shouldConsume(this.entity.tile);
        for (Consume cons : this.entity.block.consumes.all()) {
            if (cons.isOptional()) continue;
            if (docons && cons.isUpdate() && prevValid && cons.valid(this.entity)) {
                cons.update(this.entity);
            }
            this.valid &= cons.valid(this.entity);
        }
        for (Consume cons : this.entity.block.consumes.optionals()) {
            if (docons && cons.isUpdate() && prevValid && cons.valid(this.entity)) {
                cons.update(this.entity);
            }
            this.optionalValid &= cons.valid(this.entity);
        }
    }

    public void trigger() {
        for (Consume cons : this.entity.block.consumes.all()) {
            cons.trigger(this.entity);
        }
    }

    public boolean valid() {
        return this.valid && this.entity.block.canProduce(this.entity.tile);
    }

    public boolean optionalValid() {
        return this.valid() && this.optionalValid;
    }

    @Override
    public void write(DataOutput stream) throws IOException {
        stream.writeBoolean(this.valid);
    }

    @Override
    public void read(DataInput stream) throws IOException {
        this.valid = stream.readBoolean();
    }
}

