/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.meta.values;

import io.anuke.arc.Core;
import io.anuke.arc.function.Predicate;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.Strings;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.gen.Tex;
import io.anuke.mindustry.type.Liquid;
import io.anuke.mindustry.ui.Cicon;
import io.anuke.mindustry.world.meta.StatValue;

public class BoosterListValue
implements StatValue {
    protected float reload;
    protected float maxUsed;
    protected float multiplier;
    protected boolean baseReload;
    protected Predicate<Liquid> filter;

    public BoosterListValue(float reload, float maxUsed, float multiplier, boolean baseReload, Predicate<Liquid> filter) {
        this.reload = reload;
        this.maxUsed = maxUsed;
        this.baseReload = baseReload;
        this.multiplier = multiplier;
        this.filter = filter;
    }

    @Override
    public void display(Table table) {
        table.row();
        table.table(c -> {
            for (Liquid liquid : Vars.content.liquids()) {
                if (!this.filter.test(liquid)) continue;
                c.addImage(liquid.icon(Cicon.medium)).size(24.0f).padRight(4.0f).right().top();
                c.add(liquid.localizedName()).padRight(10.0f).left().top();
                c.table(Tex.underline, bt -> {
                    bt.left().defaults().padRight(3.0f).left();
                    float reloadRate = (this.baseReload ? 1.0f : 0.0f) + this.maxUsed * this.multiplier * liquid.heatCapacity;
                    float standardReload = this.baseReload ? this.reload : this.reload / (this.maxUsed * this.multiplier * 0.4f);
                    float result = standardReload / (this.reload / reloadRate);
                    bt.add(Core.bundle.format("bullet.reload", Strings.fixed(result, 1)));
                }).left().padTop(-9.0f);
                c.row();
            }
        }).colspan(table.getColumns());
        table.row();
    }

    void sep(Table table, String text) {
        table.row();
        table.add(text);
    }
}

