/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.meta.values;

import io.anuke.arc.Core;
import io.anuke.arc.collection.ObjectMap;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.Strings;
import io.anuke.mindustry.content.StatusEffects;
import io.anuke.mindustry.ctype.UnlockableContent;
import io.anuke.mindustry.entities.bullet.BulletType;
import io.anuke.mindustry.gen.Tex;
import io.anuke.mindustry.ui.Cicon;
import io.anuke.mindustry.world.meta.StatValue;

public class AmmoListValue<T extends UnlockableContent>
implements StatValue {
    private final ObjectMap<T, BulletType> map;

    public AmmoListValue(ObjectMap<T, BulletType> map) {
        this.map = map;
    }

    @Override
    public void display(Table table) {
        table.row();
        for (UnlockableContent t : this.map.keys()) {
            BulletType type = this.map.get(t);
            table.addImage(this.icon(t)).size(24.0f).padRight(4.0f).right().top();
            table.add(t.localizedName()).padRight(10.0f).left().top();
            table.table(Tex.underline, bt -> {
                bt.left().defaults().padRight(3.0f).left();
                if (type.damage > 0.0f) {
                    bt.add(Core.bundle.format("bullet.damage", Float.valueOf(type.damage)));
                }
                if (type.splashDamage > 0.0f) {
                    this.sep((Table)bt, Core.bundle.format("bullet.splashdamage", (int)type.splashDamage, Strings.fixed(type.splashDamageRadius / 8.0f, 1)));
                }
                if (!Mathf.isEqual(type.ammoMultiplier, 1.0f)) {
                    this.sep((Table)bt, Core.bundle.format("bullet.multiplier", (int)type.ammoMultiplier));
                }
                if (!Mathf.isEqual(type.reloadMultiplier, 1.0f)) {
                    this.sep((Table)bt, Core.bundle.format("bullet.reload", Strings.fixed(type.reloadMultiplier, 1)));
                }
                if (type.knockback > 0.0f) {
                    this.sep((Table)bt, Core.bundle.format("bullet.knockback", Strings.fixed(type.knockback, 1)));
                }
                if (type.status == StatusEffects.burning || type.status == StatusEffects.melting || type.incendAmount > 0) {
                    this.sep((Table)bt, "$bullet.incendiary");
                }
                if (type.status == StatusEffects.freezing) {
                    this.sep((Table)bt, "$bullet.freezing");
                }
                if (type.status == StatusEffects.tarred) {
                    this.sep((Table)bt, "$bullet.tarred");
                }
                if (type.homingPower > 0.01f) {
                    this.sep((Table)bt, "$bullet.homing");
                }
                if (type.lightining > 0) {
                    this.sep((Table)bt, "$bullet.shock");
                }
                if (type.fragBullet != null) {
                    this.sep((Table)bt, "$bullet.frag");
                }
            }).left().padTop(-9.0f);
            table.row();
        }
    }

    void sep(Table table, String text) {
        table.row();
        table.add(text);
    }

    TextureRegion icon(T t) {
        return ((UnlockableContent)t).icon(Cicon.medium);
    }
}

