/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.meta;

import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.ObjectMap;
import io.anuke.arc.collection.OrderedMap;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.ItemStack;
import io.anuke.mindustry.type.Liquid;
import io.anuke.mindustry.world.meta.BlockStat;
import io.anuke.mindustry.world.meta.StatCategory;
import io.anuke.mindustry.world.meta.StatUnit;
import io.anuke.mindustry.world.meta.StatValue;
import io.anuke.mindustry.world.meta.values.BooleanValue;
import io.anuke.mindustry.world.meta.values.ItemListValue;
import io.anuke.mindustry.world.meta.values.LiquidValue;
import io.anuke.mindustry.world.meta.values.NumberValue;
import io.anuke.mindustry.world.meta.values.StringValue;

public class BlockStats {
    private final OrderedMap<StatCategory, OrderedMap<BlockStat, Array<StatValue>>> map = new OrderedMap();
    private boolean dirty;

    public void add(BlockStat stat, float value, StatUnit unit) {
        this.add(stat, new NumberValue(value, unit));
    }

    public void add(BlockStat stat, boolean value) {
        this.add(stat, new BooleanValue(value));
    }

    public void add(BlockStat stat, Item item) {
        this.add(stat, new ItemListValue(new ItemStack(item, 1)));
    }

    public void add(BlockStat stat, ItemStack item) {
        this.add(stat, new ItemListValue(item));
    }

    public void add(BlockStat stat, Liquid liquid, float amount, boolean perSecond) {
        this.add(stat, new LiquidValue(liquid, amount, perSecond));
    }

    public void add(BlockStat stat, String format, Object ... args) {
        this.add(stat, new StringValue(format, args));
    }

    public void add(BlockStat stat, StatValue value) {
        if (!this.map.containsKey(stat.category)) {
            this.map.put(stat.category, new OrderedMap());
        }
        ((OrderedMap)this.map.get(stat.category)).getOr(stat, Array::new).add(value);
        this.dirty = true;
    }

    public void remove(BlockStat stat) {
        if (!this.map.containsKey(stat.category) || !((OrderedMap)this.map.get(stat.category)).containsKey(stat)) {
            throw new RuntimeException("No stat entry found: \"" + (Object)((Object)stat) + "\" in block.");
        }
        ((OrderedMap)this.map.get(stat.category)).remove(stat);
        this.dirty = true;
    }

    public OrderedMap<StatCategory, OrderedMap<BlockStat, Array<StatValue>>> toMap() {
        if (this.dirty) {
            this.map.orderedKeys().sort();
            for (ObjectMap.Entry entry : this.map.entries()) {
                ((OrderedMap)entry.value).orderedKeys().sort();
            }
            this.dirty = false;
        }
        return this.map;
    }
}

