/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.consumers;

import io.anuke.arc.collection.Bits;
import io.anuke.arc.function.Predicate;
import io.anuke.arc.util.Structs;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.ItemStack;
import io.anuke.mindustry.type.Liquid;
import io.anuke.mindustry.world.blocks.power.ConditionalConsumePower;
import io.anuke.mindustry.world.consumers.Consume;
import io.anuke.mindustry.world.consumers.ConsumeItems;
import io.anuke.mindustry.world.consumers.ConsumeLiquid;
import io.anuke.mindustry.world.consumers.ConsumePower;
import io.anuke.mindustry.world.consumers.ConsumeType;
import io.anuke.mindustry.world.meta.BlockStats;

public class Consumers {
    private Consume[] map = new Consume[ConsumeType.values().length];
    private Consume[] results;
    private Consume[] optionalResults;
    public final Bits itemFilters;
    public final Bits liquidfilters;

    public Consumers() {
        this.itemFilters = new Bits(Vars.content.items().size);
        this.liquidfilters = new Bits(Vars.content.liquids().size);
    }

    public void init() {
        this.results = Structs.filter(Consume.class, this.map, m -> m != null);
        this.optionalResults = Structs.filter(Consume.class, this.map, m -> m != null && m.isOptional());
        for (Consume cons : this.results) {
            cons.applyItemFilter(this.itemFilters);
            cons.applyLiquidFilter(this.liquidfilters);
        }
    }

    public ConsumePower getPower() {
        return (ConsumePower)this.get(ConsumeType.power);
    }

    public boolean hasPower() {
        return this.has(ConsumeType.power);
    }

    public ConsumeLiquid liquid(Liquid liquid, float amount) {
        return this.add(new ConsumeLiquid(liquid, amount));
    }

    public ConsumePower power(float powerPerTick) {
        return this.add(new ConsumePower(powerPerTick, 0.0f, false));
    }

    public ConsumePower powerCond(float usage, Predicate<TileEntity> cons) {
        return this.add(new ConditionalConsumePower(usage, cons));
    }

    public ConsumePower powerBuffered(float powerCapacity) {
        return this.add(new ConsumePower(0.0f, powerCapacity, true));
    }

    public ConsumeItems item(Item item) {
        return this.item(item, 1);
    }

    public ConsumeItems item(Item item, int amount) {
        return this.add(new ConsumeItems(new ItemStack[]{new ItemStack(item, amount)}));
    }

    public ConsumeItems items(ItemStack ... items) {
        return this.add(new ConsumeItems(items));
    }

    public <T extends Consume> T add(T consume) {
        this.map[consume.type().ordinal()] = consume;
        return consume;
    }

    public void remove(ConsumeType type) {
        this.map[type.ordinal()] = null;
    }

    public boolean has(ConsumeType type) {
        return this.map[type.ordinal()] != null;
    }

    public <T extends Consume> T get(ConsumeType type) {
        if (this.map[type.ordinal()] == null) {
            throw new IllegalArgumentException("Block does not contain consumer of type '" + (Object)((Object)type) + "'!");
        }
        return (T)this.map[type.ordinal()];
    }

    public Consume[] all() {
        return this.results;
    }

    public Consume[] optionals() {
        return this.optionalResults;
    }

    public void display(BlockStats stats) {
        for (Consume c : this.map) {
            if (c == null) continue;
            c.display(stats);
        }
    }
}

