/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.consumers;

import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.consumers.Consume;
import io.anuke.mindustry.world.consumers.ConsumeType;
import io.anuke.mindustry.world.meta.BlockStat;
import io.anuke.mindustry.world.meta.BlockStats;
import io.anuke.mindustry.world.meta.StatUnit;

public class ConsumePower
extends Consume {
    public final float usage;
    public final float capacity;
    public final boolean buffered;

    public ConsumePower(float usage, float capacity, boolean buffered) {
        this.usage = usage;
        this.capacity = capacity;
        this.buffered = buffered;
    }

    protected ConsumePower() {
        this(0.0f, 0.0f, false);
    }

    @Override
    public ConsumeType type() {
        return ConsumeType.power;
    }

    @Override
    public void build(Tile tile, Table table) {
    }

    @Override
    public String getIcon() {
        return "icon-power";
    }

    @Override
    public void update(TileEntity entity) {
    }

    @Override
    public boolean valid(TileEntity entity) {
        if (this.buffered) {
            return true;
        }
        return entity.power.satisfaction > 0.0f;
    }

    @Override
    public void display(BlockStats stats) {
        if (this.buffered) {
            stats.add(BlockStat.powerCapacity, this.capacity, StatUnit.none);
        } else {
            stats.add(BlockStat.powerUse, this.usage * 60.0f, StatUnit.powerSecond);
        }
    }

    public float requestedPower(TileEntity entity) {
        if (this.buffered) {
            return (1.0f - entity.power.satisfaction) * this.capacity;
        }
        return this.usage;
    }
}

