/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.consumers;

import io.anuke.arc.collection.Bits;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.ArcAnnotate;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.type.Liquid;
import io.anuke.mindustry.ui.Cicon;
import io.anuke.mindustry.ui.ReqImage;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.consumers.ConsumeLiquidBase;
import io.anuke.mindustry.world.meta.BlockStat;
import io.anuke.mindustry.world.meta.BlockStats;

public class ConsumeLiquid
extends ConsumeLiquidBase {
    @ArcAnnotate.NonNull
    public final Liquid liquid;

    public ConsumeLiquid(Liquid liquid, float amount) {
        super(amount);
        this.liquid = liquid;
    }

    protected ConsumeLiquid() {
        this(null, 0.0f);
    }

    @Override
    public void applyLiquidFilter(Bits filter) {
        filter.set(this.liquid.id);
    }

    @Override
    public void build(Tile tile, Table table) {
        table.add(new ReqImage(this.liquid.icon(Cicon.medium), () -> this.valid(tile.entity))).size(32.0f);
    }

    @Override
    public String getIcon() {
        return "icon-liquid-consume";
    }

    @Override
    public void update(TileEntity entity) {
        entity.liquids.remove(this.liquid, Math.min(this.use(entity), entity.liquids.get(this.liquid)));
    }

    @Override
    public boolean valid(TileEntity entity) {
        return entity != null && entity.liquids != null && entity.liquids.get(this.liquid) >= this.use(entity);
    }

    @Override
    public void display(BlockStats stats) {
        stats.add(this.booster ? BlockStat.booster : BlockStat.input, this.liquid, this.amount * this.timePeriod, this.timePeriod == 60.0f);
    }
}

