/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.consumers;

import io.anuke.arc.collection.Bits;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.consumers.ConsumeType;
import io.anuke.mindustry.world.meta.BlockStats;

public abstract class Consume {
    protected boolean optional;
    protected boolean booster;
    protected boolean update = true;

    public void applyItemFilter(Bits filter) {
    }

    public void applyLiquidFilter(Bits filter) {
    }

    public Consume optional(boolean optional, boolean boost) {
        this.optional = optional;
        this.booster = boost;
        return this;
    }

    public Consume boost() {
        return this.optional(true, true);
    }

    public Consume update(boolean update) {
        this.update = update;
        return this;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean isBoost() {
        return this.booster;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public abstract ConsumeType type();

    public abstract void build(Tile var1, Table var2);

    public void trigger(TileEntity entity) {
    }

    public abstract String getIcon();

    public abstract void update(TileEntity var1);

    public abstract boolean valid(TileEntity var1);

    public abstract void display(BlockStats var1);
}

