/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.units;

import io.anuke.arc.Core;
import io.anuke.arc.collection.EnumSet;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Angles;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Rectangle;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.entities.Units;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.entities.type.Unit;
import io.anuke.mindustry.graphics.Drawf;
import io.anuke.mindustry.graphics.Layer;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.meta.BlockFlag;

public class RepairPoint
extends Block {
    private static Rectangle rect = new Rectangle();
    protected int timerTarget;
    protected float repairRadius;
    protected float repairSpeed;
    protected float powerUse;
    protected TextureRegion baseRegion;
    protected TextureRegion laser;
    protected TextureRegion laserEnd;

    public RepairPoint(String name) {
        super(name);
        this.timerTarget = this.timers++;
        this.repairRadius = 50.0f;
        this.repairSpeed = 0.3f;
        this.update = true;
        this.solid = true;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.repair});
        this.layer = Layer.turret;
        this.layer2 = Layer.power;
        this.hasPower = true;
        this.outlineIcon = true;
    }

    @Override
    public void load() {
        super.load();
        this.baseRegion = Core.atlas.find(this.name + "-base");
        this.laser = Core.atlas.find("laser");
        this.laserEnd = Core.atlas.find("laser-end");
    }

    @Override
    public void init() {
        this.consumes.powerCond(this.powerUse, entity -> ((RepairPointEntity)entity).target != null);
        super.init();
    }

    @Override
    public void drawSelect(Tile tile) {
        Drawf.dashCircle(tile.drawx(), tile.drawy(), this.repairRadius, Pal.accent);
    }

    @Override
    public void draw(Tile tile) {
        Draw.rect(this.baseRegion, tile.drawx(), tile.drawy());
    }

    @Override
    public void drawLayer(Tile tile) {
        RepairPointEntity entity = (RepairPointEntity)tile.entity();
        Draw.rect(this.region, tile.drawx(), tile.drawy(), entity.rotation - 90.0f);
    }

    @Override
    public void drawLayer2(Tile tile) {
        RepairPointEntity entity = (RepairPointEntity)tile.entity();
        if (entity.target != null && Angles.angleDist(entity.angleTo(entity.target), entity.rotation) < 30.0f) {
            float ang = entity.angleTo(entity.target);
            float len = 5.0f;
            Draw.color(Color.valueOf("e8ffd7"));
            Drawf.laser(this.laser, this.laserEnd, tile.drawx() + Angles.trnsx(ang, len), tile.drawy() + Angles.trnsy(ang, len), entity.target.x, entity.target.y, entity.strength);
            Draw.color();
        }
    }

    @Override
    public TextureRegion[] generateIcons() {
        return new TextureRegion[]{Core.atlas.find(this.name + "-base"), Core.atlas.find(this.name)};
    }

    @Override
    public void update(Tile tile) {
        RepairPointEntity entity = (RepairPointEntity)tile.entity();
        boolean targetIsBeingRepaired = false;
        if (entity.target != null && (entity.target.isDead() || entity.target.dst(tile) > this.repairRadius || entity.target.health >= entity.target.maxHealth())) {
            entity.target = null;
        } else if (entity.target != null && entity.cons.valid()) {
            entity.target.health += this.repairSpeed * Time.delta() * entity.strength * entity.power.satisfaction;
            entity.target.clampHealth();
            entity.rotation = Mathf.slerpDelta(entity.rotation, entity.angleTo(entity.target), 0.5f);
            targetIsBeingRepaired = true;
        }
        entity.strength = entity.target != null && targetIsBeingRepaired ? Mathf.lerpDelta(entity.strength, 1.0f, 0.08f * Time.delta()) : Mathf.lerpDelta(entity.strength, 0.0f, 0.07f * Time.delta());
        if (entity.timer.get(this.timerTarget, 20.0f)) {
            rect.setSize(this.repairRadius * 2.0f).setCenter(tile.drawx(), tile.drawy());
            entity.target = Units.closest(tile.getTeam(), tile.drawx(), tile.drawy(), this.repairRadius, unit -> unit.health < unit.maxHealth());
        }
    }

    @Override
    public boolean shouldConsume(Tile tile) {
        RepairPointEntity entity = (RepairPointEntity)tile.entity();
        return entity.target != null;
    }

    @Override
    public TileEntity newEntity() {
        return new RepairPointEntity();
    }

    public class RepairPointEntity
    extends TileEntity {
        public Unit target;
        public float strength;
        public float rotation = 90.0f;
    }
}

