/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.units;

import io.anuke.arc.Events;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Geometry;
import io.anuke.arc.util.ArcAnnotate;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.content.Mechs;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.traits.SpawnerTrait;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.entities.type.Unit;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.gen.Call;
import io.anuke.mindustry.graphics.Layer;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.type.Mech;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.RespawnBlock;
import io.anuke.mindustry.world.meta.BlockStat;
import io.anuke.mindustry.world.meta.StatUnit;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MechPad
extends Block {
    @ArcAnnotate.NonNull
    protected Mech mech;
    protected float buildTime = 300.0f;

    public MechPad(String name) {
        super(name);
        this.update = true;
        this.solid = false;
        this.hasPower = true;
        this.layer = Layer.overlay;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(BlockStat.productionTime, this.buildTime / 60.0f, StatUnit.seconds);
    }

    @Override
    public boolean shouldConsume(Tile tile) {
        return false;
    }

    public static void onMechFactoryTap(Player player, Tile tile) {
        if (player == null || !(tile.block() instanceof MechPad) || !MechPad.checkValidTap(tile, player)) {
            return;
        }
        MechFactoryEntity entity = (MechFactoryEntity)tile.entity();
        if (!entity.cons.valid()) {
            return;
        }
        player.beginRespawning(entity);
        entity.sameMech = false;
    }

    public static void onMechFactoryDone(Tile tile) {
        if (!(tile.entity instanceof MechFactoryEntity)) {
            return;
        }
        MechFactoryEntity entity = (MechFactoryEntity)tile.entity();
        Effects.effect(Fx.spawn, entity);
        if (entity.player == null) {
            return;
        }
        Mech mech = ((MechPad)tile.block()).mech;
        boolean resetSpawner = !entity.sameMech && entity.player.mech == mech;
        entity.player.mech = !entity.sameMech && entity.player.mech == mech ? Mechs.starter : mech;
        Player player = entity.player;
        entity.progress = 0.0f;
        entity.player.onRespawn(tile);
        if (resetSpawner) {
            entity.player.lastSpawner = null;
        }
        entity.player = null;
        Events.fire(new EventType.MechChangeEvent(player, player.mech));
    }

    protected static boolean checkValidTap(Tile tile, Player player) {
        MechFactoryEntity entity = (MechFactoryEntity)tile.entity();
        return !player.isDead() && tile.interactable(player.getTeam()) && Math.abs(player.x - tile.drawx()) <= (float)(tile.block().size * 8) && Math.abs(player.y - tile.drawy()) <= (float)(tile.block().size * 8) && entity.cons.valid() && entity.player == null;
    }

    @Override
    public void drawSelect(Tile tile) {
        Draw.color(Pal.accent);
        for (int i = 0; i < 4; ++i) {
            float length = (float)(8 * this.size) / 2.0f + 3.0f + Mathf.absin(Time.time(), 5.0f, 2.0f);
            Draw.rect("transfer-arrow", tile.drawx() + (float)Geometry.d4[i].x * length, tile.drawy() + (float)Geometry.d4[i].y * length, (float)((i + 2) * 90));
        }
        Draw.color();
    }

    @Override
    public void tapped(Tile tile, Player player) {
        MechFactoryEntity entity = (MechFactoryEntity)tile.entity();
        if (MechPad.checkValidTap(tile, player)) {
            Call.onMechFactoryTap(player, tile);
        } else if (player.isLocal && Vars.mobile && !player.isDead() && entity.cons.valid() && entity.player == null) {
            player.moveTarget = player.moveTarget == tile.entity ? null : tile.entity;
        }
    }

    @Override
    public void drawLayer(Tile tile) {
        MechFactoryEntity entity = (MechFactoryEntity)tile.entity();
        if (entity.player != null) {
            RespawnBlock.drawRespawn(tile, entity.heat, entity.progress, entity.time, entity.player, !entity.sameMech && entity.player.mech == this.mech ? Mechs.starter : this.mech);
        }
    }

    @Override
    public void update(Tile tile) {
        MechFactoryEntity entity = (MechFactoryEntity)tile.entity();
        if (entity.player != null) {
            entity.player.set(tile.drawx(), tile.drawy());
            entity.heat = Mathf.lerpDelta(entity.heat, 1.0f, 0.1f);
            entity.progress += 1.0f / this.buildTime * entity.delta();
            entity.time += 0.5f * entity.delta();
            if (entity.progress >= 1.0f) {
                Call.onMechFactoryDone(tile);
            }
        } else {
            entity.heat = Mathf.lerpDelta(entity.heat, 0.0f, 0.1f);
        }
    }

    @Override
    public TileEntity newEntity() {
        return new MechFactoryEntity();
    }

    public class MechFactoryEntity
    extends TileEntity
    implements SpawnerTrait {
        Player player;
        boolean sameMech;
        float progress;
        float time;
        float heat;

        @Override
        public boolean hasUnit(Unit unit) {
            return unit == this.player;
        }

        @Override
        public void updateSpawning(Player unit) {
            if (this.player == null) {
                this.progress = 0.0f;
                this.player = unit;
                this.sameMech = true;
                this.player.beginRespawning(this);
            }
        }

        @Override
        public void write(DataOutput stream) throws IOException {
            super.write(stream);
            stream.writeFloat(this.progress);
            stream.writeFloat(this.time);
            stream.writeFloat(this.heat);
        }

        @Override
        public void read(DataInput stream, byte revision) throws IOException {
            super.read(stream, revision);
            this.progress = stream.readFloat();
            this.time = stream.readFloat();
            this.heat = stream.readFloat();
        }
    }
}

