/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.storage;

import io.anuke.arc.function.Eachable;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.entities.traits.BuilderTrait;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.ItemSelection;
import io.anuke.mindustry.world.blocks.storage.StorageBlock;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Unloader
extends Block {
    protected float speed = 1.0f;
    protected final int timerUnload = this.timers++;
    private static Item lastItem;

    public Unloader(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.health = 70;
        this.hasItems = true;
        this.configurable = true;
    }

    @Override
    public void drawRequestConfig(BuilderTrait.BuildRequest req, Eachable<BuilderTrait.BuildRequest> list) {
        this.drawRequestConfigCenter(req, Vars.content.item(req.config), "unloader-center");
    }

    @Override
    public boolean canDump(Tile tile, Tile to, Item item) {
        return !(to.block() instanceof StorageBlock);
    }

    @Override
    public void setBars() {
        super.setBars();
        this.bars.remove("items");
    }

    @Override
    public void playerPlaced(Tile tile) {
        if (lastItem != null) {
            tile.configure(Unloader.lastItem.id);
        }
    }

    @Override
    public void configured(Tile tile, Player player, int value) {
        tile.entity.items.clear();
        ((UnloaderEntity)tile.entity()).sortItem = Vars.content.item(value);
    }

    @Override
    public void update(Tile tile) {
        UnloaderEntity entity = (UnloaderEntity)tile.entity();
        if (tile.entity.timer.get(this.timerUnload, this.speed / entity.timeScale) && tile.entity.items.total() == 0) {
            for (Tile other : tile.entity.proximity()) {
                if (!other.interactable(tile.getTeam()) || !other.block().unloadable || !other.block().hasItems || entity.items.total() != 0 || (entity.sortItem != null || other.entity.items.total() <= 0) && !this.hasItem(other, entity.sortItem)) continue;
                this.offloadNear(tile, this.removeItem(other, entity.sortItem));
            }
        }
        if (entity.items.total() > 0) {
            this.tryDump(tile);
        }
    }

    private Item removeItem(Tile tile, Item item) {
        TileEntity entity = tile.entity;
        if (item == null) {
            return entity.items.take();
        }
        if (entity.items.has(item)) {
            entity.items.remove(item, 1);
            return item;
        }
        return null;
    }

    private boolean hasItem(Tile tile, Item item) {
        TileEntity entity = tile.entity;
        if (item == null) {
            return entity.items.total() > 0;
        }
        return entity.items.has(item);
    }

    @Override
    public void draw(Tile tile) {
        super.draw(tile);
        UnloaderEntity entity = (UnloaderEntity)tile.entity();
        Draw.color(entity.sortItem == null ? Color.clear : entity.sortItem.color);
        Draw.rect("unloader-center", tile.worldx(), tile.worldy());
        Draw.color();
    }

    @Override
    public void buildTable(Tile tile, Table table) {
        UnloaderEntity entity = (UnloaderEntity)tile.entity();
        ItemSelection.buildItemTable(table, () -> entity.sortItem, item -> {
            lastItem = item;
            tile.configure(item == null ? -1 : (int)item.id);
        });
    }

    @Override
    public TileEntity newEntity() {
        return new UnloaderEntity();
    }

    public static class UnloaderEntity
    extends TileEntity {
        public Item sortItem = null;

        @Override
        public int config() {
            return this.sortItem == null ? -1 : (int)this.sortItem.id;
        }

        @Override
        public void write(DataOutput stream) throws IOException {
            super.write(stream);
            stream.writeByte(this.sortItem == null ? -1 : (int)this.sortItem.id);
        }

        @Override
        public void read(DataInput stream, byte revision) throws IOException {
            super.read(stream, revision);
            byte id = stream.readByte();
            this.sortItem = id == -1 ? null : Vars.content.items().get(id);
        }
    }
}

