/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.sandbox;

import io.anuke.arc.Core;
import io.anuke.arc.collection.Array;
import io.anuke.arc.function.Eachable;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.scene.style.TextureRegionDrawable;
import io.anuke.arc.scene.ui.ButtonGroup;
import io.anuke.arc.scene.ui.ImageButton;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.ArcAnnotate;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.entities.traits.BuilderTrait;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.gen.Tex;
import io.anuke.mindustry.type.Liquid;
import io.anuke.mindustry.ui.Cicon;
import io.anuke.mindustry.ui.Styles;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LiquidSource
extends Block {
    private static Liquid lastLiquid;

    public LiquidSource(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.hasLiquids = true;
        this.liquidCapacity = 100.0f;
        this.configurable = true;
        this.outputsLiquid = true;
    }

    @Override
    public void playerPlaced(Tile tile) {
        if (lastLiquid != null) {
            Core.app.post(() -> tile.configure(LiquidSource.lastLiquid.id));
        }
    }

    @Override
    public void setBars() {
        super.setBars();
        this.bars.remove("liquid");
    }

    @Override
    public void update(Tile tile) {
        LiquidSourceEntity entity = (LiquidSourceEntity)tile.entity();
        if (entity.source == null) {
            tile.entity.liquids.clear();
        } else {
            tile.entity.liquids.add(entity.source, this.liquidCapacity);
            this.tryDumpLiquid(tile, entity.source);
        }
    }

    @Override
    public void drawRequestConfig(BuilderTrait.BuildRequest req, Eachable<BuilderTrait.BuildRequest> list) {
        this.drawRequestConfigCenter(req, Vars.content.liquid(req.config), "center");
    }

    @Override
    public void draw(Tile tile) {
        super.draw(tile);
        LiquidSourceEntity entity = (LiquidSourceEntity)tile.entity();
        if (entity.source != null) {
            Draw.color(entity.source.color);
            Draw.rect("center", tile.worldx(), tile.worldy());
            Draw.color();
        }
    }

    @Override
    public void buildTable(Tile tile, Table table) {
        LiquidSourceEntity entity = (LiquidSourceEntity)tile.entity();
        Array<Liquid> items = Vars.content.liquids();
        ButtonGroup group = new ButtonGroup();
        group.setMinCheckCount(0);
        Table cont = new Table();
        for (int i = 0; i < items.size; ++i) {
            int f = i;
            ImageButton button = cont.addImageButton(Tex.clear, Styles.clearToggleTransi, 24.0f, () -> Vars.control.input.frag.config.hideConfig()).size(38.0f).group(group).get();
            button.changed(() -> {
                tile.configure(button.isChecked() ? (int)((Liquid)items.get((int)f)).id : -1);
                Vars.control.input.frag.config.hideConfig();
                lastLiquid = (Liquid)items.get(f);
            });
            button.getStyle().imageUp = new TextureRegionDrawable(items.get(i).icon(Cicon.medium));
            button.setChecked(entity.source == items.get(i));
            if (i % 4 != 3) continue;
            cont.row();
        }
        table.add(cont);
    }

    @Override
    public TileEntity newEntity() {
        return new LiquidSourceEntity();
    }

    @Override
    public void configured(Tile tile, Player player, int value) {
        ((LiquidSourceEntity)tile.entity()).source = value == -1 ? null : Vars.content.liquid(value);
    }

    class LiquidSourceEntity
    extends TileEntity {
        @ArcAnnotate.Nullable
        public Liquid source = null;

        LiquidSourceEntity() {
        }

        @Override
        public int config() {
            return this.source == null ? -1 : (int)this.source.id;
        }

        @Override
        public void write(DataOutput stream) throws IOException {
            super.write(stream);
            stream.writeByte(this.source == null ? -1 : (int)this.source.id);
        }

        @Override
        public void read(DataInput stream, byte revision) throws IOException {
            super.read(stream, revision);
            byte id = stream.readByte();
            this.source = id == -1 ? null : Vars.content.liquid(id);
        }
    }
}

