/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.sandbox;

import io.anuke.arc.Core;
import io.anuke.arc.function.Eachable;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.entities.traits.BuilderTrait;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.ItemSelection;
import io.anuke.mindustry.world.meta.BlockGroup;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ItemSource
extends Block {
    private static Item lastItem;

    public ItemSource(String name) {
        super(name);
        this.hasItems = true;
        this.update = true;
        this.solid = true;
        this.group = BlockGroup.transportation;
        this.configurable = true;
    }

    @Override
    public void configured(Tile tile, Player player, int value) {
        ((ItemSourceEntity)tile.entity()).outputItem = Vars.content.item(value);
    }

    @Override
    public void playerPlaced(Tile tile) {
        if (lastItem != null) {
            Core.app.post(() -> tile.configure(ItemSource.lastItem.id));
        }
    }

    @Override
    public void setBars() {
        super.setBars();
        this.bars.remove("items");
    }

    @Override
    public void drawRequestConfig(BuilderTrait.BuildRequest req, Eachable<BuilderTrait.BuildRequest> list) {
        this.drawRequestConfigCenter(req, Vars.content.item(req.config), "center");
    }

    @Override
    public boolean outputsItems() {
        return true;
    }

    @Override
    public void draw(Tile tile) {
        super.draw(tile);
        ItemSourceEntity entity = (ItemSourceEntity)tile.entity();
        if (entity.outputItem == null) {
            return;
        }
        Draw.color(entity.outputItem.color);
        Draw.rect("center", tile.worldx(), tile.worldy());
        Draw.color();
    }

    @Override
    public void update(Tile tile) {
        ItemSourceEntity entity = (ItemSourceEntity)tile.entity();
        if (entity.outputItem == null) {
            return;
        }
        entity.items.set(entity.outputItem, 1);
        this.tryDump(tile, entity.outputItem);
        entity.items.set(entity.outputItem, 0);
    }

    @Override
    public void buildTable(Tile tile, Table table) {
        ItemSourceEntity entity = (ItemSourceEntity)tile.entity();
        ItemSelection.buildItemTable(table, () -> entity.outputItem, item -> {
            lastItem = item;
            tile.configure(item == null ? -1 : (int)item.id);
        });
    }

    @Override
    public boolean acceptItem(Item item, Tile tile, Tile source) {
        return false;
    }

    @Override
    public TileEntity newEntity() {
        return new ItemSourceEntity();
    }

    public class ItemSourceEntity
    extends TileEntity {
        Item outputItem;

        @Override
        public int config() {
            return this.outputItem == null ? -1 : (int)this.outputItem.id;
        }

        @Override
        public void write(DataOutput stream) throws IOException {
            super.write(stream);
            stream.writeShort(this.outputItem == null ? -1 : (int)this.outputItem.id);
        }

        @Override
        public void read(DataInput stream, byte revision) throws IOException {
            super.read(stream, revision);
            this.outputItem = Vars.content.item(stream.readShort());
        }
    }
}

