/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.production;

import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.util.ArcAnnotate;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.ItemStack;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.production.GenericCrafter;
import io.anuke.mindustry.world.consumers.ConsumeLiquidBase;
import io.anuke.mindustry.world.consumers.ConsumeType;
import io.anuke.mindustry.world.meta.BlockStat;
import io.anuke.mindustry.world.meta.StatUnit;
import io.anuke.mindustry.world.meta.values.ItemFilterValue;

public class Separator
extends Block {
    @ArcAnnotate.NonNull
    protected ItemStack[] results;
    protected float craftTime;
    protected float spinnerRadius = 2.5f;
    protected float spinnerLength = 1.0f;
    protected float spinnerThickness = 1.0f;
    protected float spinnerSpeed = 2.0f;
    protected Color color = Color.valueOf("858585");
    protected int liquidRegion;

    public Separator(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.hasItems = true;
        this.hasLiquids = true;
        this.liquidRegion = this.reg("-liquid");
    }

    @Override
    public void setStats() {
        if (this.consumes.has(ConsumeType.liquid)) {
            ConsumeLiquidBase cons = (ConsumeLiquidBase)this.consumes.get(ConsumeType.liquid);
            cons.timePeriod = this.craftTime;
        }
        super.setStats();
        this.stats.add(BlockStat.output, new ItemFilterValue(item -> {
            for (ItemStack i : this.results) {
                if (item != i.item) continue;
                return true;
            }
            return false;
        }));
        this.stats.add(BlockStat.productionTime, this.craftTime / 60.0f, StatUnit.seconds);
    }

    @Override
    public boolean canProduce(Tile tile) {
        return tile.entity.items.total() < this.itemCapacity;
    }

    @Override
    public void draw(Tile tile) {
        super.draw(tile);
        GenericCrafter.GenericCrafterEntity entity = (GenericCrafter.GenericCrafterEntity)tile.entity();
        Draw.color(tile.entity.liquids.current().color);
        Draw.alpha(tile.entity.liquids.total() / this.liquidCapacity);
        Draw.rect(this.reg(this.liquidRegion), tile.drawx(), tile.drawy());
        Draw.color(this.color);
        Lines.stroke(this.spinnerThickness);
        Lines.spikes(tile.drawx(), tile.drawy(), this.spinnerRadius, this.spinnerLength, 3, entity.totalProgress * this.spinnerSpeed);
        Draw.reset();
    }

    @Override
    public void update(Tile tile) {
        GenericCrafter.GenericCrafterEntity entity = (GenericCrafter.GenericCrafterEntity)tile.entity();
        entity.totalProgress += entity.warmup * entity.delta();
        if (entity.cons.valid()) {
            entity.progress += this.getProgressIncrease(entity, this.craftTime);
            entity.warmup = Mathf.lerpDelta(entity.warmup, 1.0f, 0.02f);
        } else {
            entity.warmup = Mathf.lerpDelta(entity.warmup, 0.0f, 0.02f);
        }
        if (entity.progress >= 1.0f) {
            entity.progress = 0.0f;
            int sum = 0;
            for (ItemStack stack : this.results) {
                sum += stack.amount;
            }
            int i = Mathf.random(sum);
            int count = 0;
            Item item = null;
            for (ItemStack stack : this.results) {
                if (i >= count && i < count + stack.amount) {
                    item = stack.item;
                    break;
                }
                count += stack.amount;
            }
            entity.cons.trigger();
            if (item != null && entity.items.get(item) < this.itemCapacity) {
                this.offloadNear(tile, item);
            }
        }
        if (entity.timer.get(this.timerDump, 5.0f)) {
            this.tryDump(tile);
        }
    }

    @Override
    public TileEntity newEntity() {
        return new GenericCrafter.GenericCrafterEntity();
    }
}

