/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.production;

import io.anuke.arc.Core;
import io.anuke.arc.collection.Array;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.mindustry.graphics.Layer;
import io.anuke.mindustry.type.Liquid;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.LiquidBlock;
import io.anuke.mindustry.world.meta.BlockGroup;
import io.anuke.mindustry.world.meta.BlockStat;
import io.anuke.mindustry.world.meta.StatUnit;

public class Pump
extends LiquidBlock {
    protected final Array<Tile> drawTiles = new Array();
    protected final Array<Tile> updateTiles = new Array();
    protected final int timerContentCheck = this.timers++;
    protected float pumpAmount = 1.0f;

    public Pump(String name) {
        super(name);
        this.layer = Layer.overlay;
        this.group = BlockGroup.liquids;
        this.floating = true;
    }

    @Override
    public void load() {
        super.load();
        this.liquidRegion = Core.atlas.find("pump-liquid");
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(BlockStat.output, 60.0f * this.pumpAmount, StatUnit.liquidSecond);
    }

    @Override
    public void draw(Tile tile) {
        Draw.rect(this.name, tile.drawx(), tile.drawy());
        Draw.color(tile.entity.liquids.current().color);
        Draw.alpha(tile.entity.liquids.total() / this.liquidCapacity);
        Draw.rect(this.liquidRegion, tile.drawx(), tile.drawy());
        Draw.color();
    }

    @Override
    public TextureRegion[] generateIcons() {
        return new TextureRegion[]{Core.atlas.find(this.name)};
    }

    @Override
    public boolean canPlaceOn(Tile tile) {
        if (this.isMultiblock()) {
            Liquid last = null;
            for (Tile other : tile.getLinkedTilesAs(this, this.drawTiles)) {
                if (other.floor().liquidDrop == null) continue;
                if (other.floor().liquidDrop != last && last != null) {
                    return false;
                }
                last = other.floor().liquidDrop;
            }
            return last != null;
        }
        return this.isValid(tile);
    }

    @Override
    public void update(Tile tile) {
        float tiles = 0.0f;
        Liquid liquidDrop = null;
        if (this.isMultiblock()) {
            for (Tile other : tile.getLinkedTiles(this.updateTiles)) {
                if (!this.isValid(other)) continue;
                liquidDrop = other.floor().liquidDrop;
                tiles += 1.0f;
            }
        } else {
            tiles = 1.0f;
            liquidDrop = tile.floor().liquidDrop;
        }
        if (tile.entity.cons.valid() && liquidDrop != null) {
            float maxPump = Math.min(this.liquidCapacity - tile.entity.liquids.total(), tiles * this.pumpAmount * tile.entity.delta() / (float)this.size / (float)this.size);
            if (this.hasPower) {
                maxPump *= tile.entity.power.satisfaction;
            }
            tile.entity.liquids.add(liquidDrop, maxPump);
        }
        if (tile.entity.liquids.currentAmount() > 0.0f && tile.entity.timer.get(this.timerContentCheck, 10.0f)) {
            this.useContent(tile, tile.entity.liquids.current());
        }
        this.tryDumpLiquid(tile, tile.entity.liquids.current());
    }

    protected boolean isValid(Tile tile) {
        return tile != null && tile.floor().liquidDrop != null;
    }
}

