/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.production;

import io.anuke.arc.Core;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.production.SolidPump;
import io.anuke.mindustry.world.meta.BlockStat;
import io.anuke.mindustry.world.meta.StatUnit;

public class Fracker
extends SolidPump {
    protected final float itemUseTime = 100.0f;
    protected TextureRegion liquidRegion;
    protected TextureRegion rotatorRegion;
    protected TextureRegion topRegion;

    public Fracker(String name) {
        super(name);
        this.hasItems = true;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(BlockStat.productionTime, 1.6666666f, StatUnit.seconds);
    }

    @Override
    public void load() {
        super.load();
        this.liquidRegion = Core.atlas.find(this.name + "-liquid");
        this.rotatorRegion = Core.atlas.find(this.name + "-rotator");
        this.topRegion = Core.atlas.find(this.name + "-top");
    }

    @Override
    public boolean outputsItems() {
        return false;
    }

    @Override
    public void drawCracks(Tile tile) {
    }

    @Override
    public boolean canProduce(Tile tile) {
        return tile.entity.liquids.get(this.result) < this.liquidCapacity - 0.01f;
    }

    @Override
    public void draw(Tile tile) {
        FrackerEntity entity = (FrackerEntity)tile.entity();
        Draw.rect(this.region, tile.drawx(), tile.drawy());
        super.drawCracks(tile);
        Draw.color(this.result.color);
        Draw.alpha(tile.entity.liquids.get(this.result) / this.liquidCapacity);
        Draw.rect(this.liquidRegion, tile.drawx(), tile.drawy());
        Draw.color();
        Draw.rect(this.rotatorRegion, tile.drawx(), tile.drawy(), entity.pumpTime);
        Draw.rect(this.topRegion, tile.drawx(), tile.drawy());
    }

    @Override
    public TextureRegion[] generateIcons() {
        return new TextureRegion[]{Core.atlas.find(this.name), Core.atlas.find(this.name + "-rotator"), Core.atlas.find(this.name + "-top")};
    }

    @Override
    public void update(Tile tile) {
        FrackerEntity entity = (FrackerEntity)tile.entity();
        if (entity.cons.valid()) {
            if (entity.accumulator >= 100.0f) {
                entity.cons.trigger();
                entity.accumulator -= 100.0f;
            }
            super.update(tile);
            entity.accumulator += entity.delta() * entity.power.satisfaction;
        } else {
            this.tryDumpLiquid(tile, this.result);
        }
    }

    @Override
    public TileEntity newEntity() {
        return new FrackerEntity();
    }

    @Override
    public float typeLiquid(Tile tile) {
        return tile.entity.liquids.get(this.result);
    }

    public static class FrackerEntity
    extends SolidPump.SolidPumpEntity {
        public float accumulator;
    }
}

