/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.production;

import io.anuke.arc.Core;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.ObjectIntMap;
import io.anuke.arc.graphics.Blending;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.util.Strings;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.content.Items;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.gen.Sounds;
import io.anuke.mindustry.graphics.Layer;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.ui.Bar;
import io.anuke.mindustry.ui.Cicon;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.meta.BlockGroup;
import io.anuke.mindustry.world.meta.BlockStat;
import io.anuke.mindustry.world.meta.StatUnit;

public class Drill
extends Block {
    protected static final float hardnessDrillMultiplier = 50.0f;
    protected final ObjectIntMap<Item> oreCount = new ObjectIntMap();
    protected final Array<Item> itemArray = new Array();
    protected int tier;
    protected float drillTime = 300.0f;
    protected float liquidBoostIntensity = 1.6f;
    protected float warmupSpeed = 0.02f;
    protected Item returnItem;
    protected int returnCount;
    protected boolean drawMineItem = false;
    protected Effects.Effect drillEffect = Fx.mine;
    protected float rotateSpeed = 2.0f;
    protected Effects.Effect updateEffect = Fx.pulverizeSmall;
    protected float updateEffectChance = 0.02f;
    protected boolean drawRim = false;
    protected Color heatColor = Color.valueOf("ff5512");
    protected TextureRegion rimRegion;
    protected TextureRegion rotatorRegion;
    protected TextureRegion topRegion;

    public Drill(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.layer = Layer.overlay;
        this.group = BlockGroup.drills;
        this.hasLiquids = true;
        this.liquidCapacity = 5.0f;
        this.hasItems = true;
        this.idleSound = Sounds.drill;
        this.idleSoundVolume = 0.003f;
    }

    @Override
    public void setBars() {
        super.setBars();
        this.bars.add("drillspeed", e -> {
            DrillEntity entity = (DrillEntity)e;
            return new Bar(() -> Core.bundle.format("bar.drillspeed", Strings.fixed(entity.lastDrillSpeed * 60.0f * entity.timeScale, 2)), () -> Pal.ammo, () -> entity.warmup);
        });
    }

    @Override
    public void load() {
        super.load();
        this.rimRegion = Core.atlas.find(this.name + "-rim");
        this.rotatorRegion = Core.atlas.find(this.name + "-rotator");
        this.topRegion = Core.atlas.find(this.name + "-top");
    }

    @Override
    public void drawCracks(Tile tile) {
    }

    @Override
    public void draw(Tile tile) {
        float s = 0.3f;
        float ts = 0.6f;
        DrillEntity entity = (DrillEntity)tile.entity();
        Draw.rect(this.region, tile.drawx(), tile.drawy());
        super.drawCracks(tile);
        if (this.drawRim) {
            Draw.color(this.heatColor);
            Draw.alpha(entity.warmup * ts * (1.0f - s + Mathf.absin(Time.time(), 3.0f, s)));
            Draw.blend(Blending.additive);
            Draw.rect(this.rimRegion, tile.drawx(), tile.drawy());
            Draw.blend();
            Draw.color();
        }
        Draw.rect(this.rotatorRegion, tile.drawx(), tile.drawy(), entity.drillTime * this.rotateSpeed);
        Draw.rect(this.topRegion, tile.drawx(), tile.drawy());
        if (entity.dominantItem != null && this.drawMineItem) {
            Draw.color(entity.dominantItem.color);
            Draw.rect("drill-top", tile.drawx(), tile.drawy(), 1.0f);
            Draw.color();
        }
    }

    @Override
    public TextureRegion[] generateIcons() {
        return new TextureRegion[]{Core.atlas.find(this.name), Core.atlas.find(this.name + "-rotator"), Core.atlas.find(this.name + "-top")};
    }

    @Override
    public boolean canProduce(Tile tile) {
        return tile.entity.items.total() < this.itemCapacity;
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        Tile tile = Vars.world.tile(x, y);
        if (tile == null) {
            return;
        }
        this.countOre(tile);
        if (this.returnItem != null) {
            float width = this.drawPlaceText(Core.bundle.formatFloat("bar.drillspeed", 60.0f / (this.drillTime + 50.0f * (float)this.returnItem.hardness) * (float)this.returnCount, 2), x, y, valid);
            float dx = (float)(x * 8) + this.offset() - width / 2.0f - 4.0f;
            float dy = (float)(y * 8) + this.offset() + (float)(this.size * 8) / 2.0f + 5.0f;
            Draw.mixcol(Color.darkGray, 1.0f);
            Draw.rect(this.returnItem.icon(Cicon.small), dx, dy - 1.0f);
            Draw.reset();
            Draw.rect(this.returnItem.icon(Cicon.small), dx, dy);
        } else {
            Item item;
            Tile to = tile.getLinkedTilesAs(this, this.tempTiles).find(t -> t.drop() != null && t.drop().hardness > this.tier);
            Item item2 = item = to == null ? null : to.drop();
            if (item != null) {
                this.drawPlaceText(Core.bundle.get("bar.drilltierreq"), x, y, valid);
            }
        }
    }

    @Override
    public void drawSelect(Tile tile) {
        DrillEntity entity = (DrillEntity)tile.entity();
        if (entity.dominantItem != null) {
            float dx = tile.drawx() - (float)(this.size * 8) / 2.0f;
            float dy = tile.drawy() + (float)(this.size * 8) / 2.0f;
            Draw.mixcol(Color.darkGray, 1.0f);
            Draw.rect(entity.dominantItem.icon(Cicon.small), dx, dy - 1.0f);
            Draw.reset();
            Draw.rect(entity.dominantItem.icon(Cicon.small), dx, dy);
        }
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(BlockStat.drillTier, table -> {
            Array<Item> list = new Array<Item>();
            for (Item item : Vars.content.items()) {
                if (this.tier < item.hardness || !Core.atlas.has(item.name + "1")) continue;
                list.add(item);
            }
            for (int i = 0; i < list.size; ++i) {
                Item item;
                item = (Item)list.get(i);
                table.addImage(Core.atlas.find(item.name + "1")).size(24.0f).padRight(2.0f).padLeft(2.0f).padTop(3.0f).padBottom(3.0f);
                table.add(item.localizedName());
                if (i == list.size - 1) continue;
                table.add("/").padLeft(5.0f).padRight(5.0f);
            }
        });
        this.stats.add(BlockStat.drillSpeed, 60.0f / this.drillTime * (float)this.size * (float)this.size, StatUnit.itemsSecond);
        this.stats.add(BlockStat.boostEffect, this.liquidBoostIntensity, StatUnit.timesSpeed);
    }

    void countOre(Tile tile) {
        this.returnItem = null;
        this.returnCount = 0;
        this.oreCount.clear();
        this.itemArray.clear();
        for (Tile other : tile.getLinkedTilesAs(this, this.tempTiles)) {
            if (!this.isValid(other)) continue;
            this.oreCount.getAndIncrement(this.getDrop(other), 0, 1);
        }
        for (Item item : this.oreCount.keys()) {
            this.itemArray.add(item);
        }
        this.itemArray.sort((item1, item2) -> {
            int type = Boolean.compare(item1 != Items.sand, item2 != Items.sand);
            if (type != 0) {
                return type;
            }
            int amounts = Integer.compare(this.oreCount.get((Item)item1, 0), this.oreCount.get((Item)item2, 0));
            if (amounts != 0) {
                return amounts;
            }
            return Integer.compare(item1.id, item2.id);
        });
        if (this.itemArray.size == 0) {
            return;
        }
        this.returnItem = this.itemArray.peek();
        this.returnCount = this.oreCount.get(this.itemArray.peek(), 0);
    }

    @Override
    public void update(Tile tile) {
        DrillEntity entity = (DrillEntity)tile.entity();
        if (entity.dominantItem == null) {
            this.countOre(tile);
            if (this.returnItem == null) {
                return;
            }
            entity.dominantItem = this.returnItem;
            entity.dominantItems = this.returnCount;
        }
        if (entity.timer.get(this.timerDump, 5.0f)) {
            this.tryDump(tile, entity.dominantItem);
        }
        entity.drillTime += entity.warmup * entity.delta();
        if (entity.items.total() < this.itemCapacity && entity.dominantItems > 0 && entity.cons.valid()) {
            float speed = 1.0f;
            if (entity.cons.optionalValid()) {
                speed = this.liquidBoostIntensity;
            }
            if (this.hasPower) {
                speed *= entity.power.satisfaction;
            }
            entity.lastDrillSpeed = speed * (float)entity.dominantItems * entity.warmup / (this.drillTime + 50.0f * (float)entity.dominantItem.hardness);
            entity.warmup = Mathf.lerpDelta(entity.warmup, speed, this.warmupSpeed);
            entity.progress += entity.delta() * (float)entity.dominantItems * speed * entity.warmup;
            if (Mathf.chance(Time.delta() * this.updateEffectChance * entity.warmup)) {
                Effects.effect(this.updateEffect, entity.x + Mathf.range((float)this.size * 2.0f), entity.y + Mathf.range((float)this.size * 2.0f));
            }
        } else {
            entity.lastDrillSpeed = 0.0f;
            entity.warmup = Mathf.lerpDelta(entity.warmup, 0.0f, this.warmupSpeed);
            return;
        }
        if (entity.dominantItems > 0 && entity.progress >= this.drillTime + 50.0f * (float)entity.dominantItem.hardness && tile.entity.items.total() < this.itemCapacity) {
            this.offloadNear(tile, entity.dominantItem);
            this.useContent(tile, entity.dominantItem);
            ++entity.index;
            entity.progress = 0.0f;
            Effects.effect(this.drillEffect, entity.dominantItem.color, entity.x + (float)Mathf.range(this.size), entity.y + (float)Mathf.range(this.size));
        }
    }

    @Override
    public boolean canPlaceOn(Tile tile) {
        if (this.isMultiblock()) {
            for (Tile other : tile.getLinkedTilesAs(this, this.tempTiles)) {
                if (!this.isValid(other)) continue;
                return true;
            }
            return false;
        }
        return this.isValid(tile);
    }

    @Override
    public TileEntity newEntity() {
        return new DrillEntity();
    }

    public int tier() {
        return this.tier;
    }

    public Item getDrop(Tile tile) {
        return tile.drop();
    }

    public boolean isValid(Tile tile) {
        if (tile == null) {
            return false;
        }
        Item drops = tile.drop();
        return drops != null && drops.hardness <= this.tier;
    }

    public static class DrillEntity
    extends TileEntity {
        float progress;
        int index;
        float warmup;
        float drillTime;
        float lastDrillSpeed;
        int dominantItems;
        Item dominantItem;
    }
}

