/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.power;

import io.anuke.arc.Core;
import io.anuke.arc.collection.EnumSet;
import io.anuke.arc.util.Strings;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.ui.Bar;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.power.PowerDistributor;
import io.anuke.mindustry.world.meta.BlockFlag;
import io.anuke.mindustry.world.meta.BlockStat;
import io.anuke.mindustry.world.meta.StatUnit;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class PowerGenerator
extends PowerDistributor {
    protected float powerProduction;
    public BlockStat generationType = BlockStat.basePowerGeneration;

    public PowerGenerator(String name) {
        super(name);
        this.baseExplosiveness = 5.0f;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.producer});
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(this.generationType, this.powerProduction * 60.0f, StatUnit.powerSecond);
    }

    @Override
    public void setBars() {
        super.setBars();
        if (this.hasPower && this.outputsPower && !this.consumes.hasPower()) {
            this.bars.add("power", entity -> new Bar(() -> Core.bundle.format("bar.poweroutput", Strings.fixed(entity.block.getPowerProduction(entity.tile) * 60.0f * entity.timeScale, 1)), () -> Pal.powerBar, () -> ((GeneratorEntity)entity).productionEfficiency));
        }
    }

    @Override
    public float getPowerProduction(Tile tile) {
        return this.powerProduction * ((GeneratorEntity)tile.entity()).productionEfficiency;
    }

    @Override
    public boolean outputsItems() {
        return false;
    }

    @Override
    public TileEntity newEntity() {
        return new GeneratorEntity();
    }

    public static class GeneratorEntity
    extends TileEntity {
        public float generateTime;
        public float productionEfficiency = 0.0f;

        @Override
        public void write(DataOutput stream) throws IOException {
            super.write(stream);
            stream.writeFloat(this.productionEfficiency);
        }

        @Override
        public void read(DataInput stream, byte revision) throws IOException {
            super.read(stream, revision);
            this.productionEfficiency = stream.readFloat();
        }
    }
}

