/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.power;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Fill;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.entities.Damage;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.gen.Sounds;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.Liquid;
import io.anuke.mindustry.ui.Bar;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.power.PowerGenerator;
import io.anuke.mindustry.world.consumers.ConsumeItems;
import io.anuke.mindustry.world.consumers.ConsumeLiquid;
import io.anuke.mindustry.world.consumers.ConsumeType;
import io.anuke.mindustry.world.meta.BlockStat;
import io.anuke.mindustry.world.meta.StatUnit;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class NuclearReactor
extends PowerGenerator {
    protected final int timerFuel;
    protected final Vector2 tr;
    protected Color coolColor;
    protected Color hotColor;
    protected float itemDuration;
    protected float heating;
    protected float smokeThreshold;
    protected int explosionRadius;
    protected int explosionDamage;
    protected float flashThreshold;
    protected float coolantPower;
    protected TextureRegion topRegion;
    protected TextureRegion lightsRegion;

    public NuclearReactor(String name) {
        super(name);
        this.timerFuel = this.timers++;
        this.tr = new Vector2();
        this.coolColor = new Color(1.0f, 1.0f, 1.0f, 0.0f);
        this.hotColor = Color.valueOf("ff9575a3");
        this.itemDuration = 120.0f;
        this.heating = 0.01f;
        this.smokeThreshold = 0.3f;
        this.explosionRadius = 40;
        this.explosionDamage = 1350;
        this.flashThreshold = 0.46f;
        this.coolantPower = 0.5f;
        this.itemCapacity = 30;
        this.liquidCapacity = 30.0f;
        this.hasItems = true;
        this.hasLiquids = true;
    }

    @Override
    public void setStats() {
        super.setStats();
        if (this.hasItems) {
            this.stats.add(BlockStat.productionTime, this.itemDuration / 60.0f, StatUnit.seconds);
        }
    }

    @Override
    public void load() {
        super.load();
        this.topRegion = Core.atlas.find(this.name + "-center");
        this.lightsRegion = Core.atlas.find(this.name + "-lights");
    }

    @Override
    public void setBars() {
        super.setBars();
        this.bars.add("heat", entity -> new Bar("bar.heat", Pal.lightOrange, () -> ((NuclearReactorEntity)entity).heat));
    }

    @Override
    public void update(Tile tile) {
        float smoke;
        float fullness;
        NuclearReactorEntity entity = (NuclearReactorEntity)tile.entity();
        ConsumeLiquid cliquid = (ConsumeLiquid)this.consumes.get(ConsumeType.liquid);
        Item item = ((ConsumeItems)this.consumes.get((ConsumeType)ConsumeType.item)).items[0].item;
        int fuel = entity.items.get(item);
        entity.productionEfficiency = fullness = (float)fuel / (float)this.itemCapacity;
        if (fuel > 0) {
            entity.heat += fullness * this.heating * Math.min(entity.delta(), 4.0f);
            if (entity.timer.get(this.timerFuel, this.itemDuration / entity.timeScale)) {
                entity.cons.trigger();
            }
        }
        Liquid liquid = cliquid.liquid;
        float liquidAmount = cliquid.amount;
        if (entity.heat > 0.0f) {
            float maxUsed = Math.min(Math.min(entity.liquids.get(liquid), entity.heat / this.coolantPower), liquidAmount * entity.delta());
            entity.heat -= maxUsed * this.coolantPower;
            entity.liquids.remove(liquid, maxUsed);
        }
        if (entity.heat > this.smokeThreshold && Mathf.chance((double)(smoke = 1.0f + (entity.heat - this.smokeThreshold) / (1.0f - this.smokeThreshold)) / 20.0 * (double)entity.delta())) {
            Effects.effect(Fx.reactorsmoke, tile.worldx() + Mathf.range((float)(this.size * 8) / 2.0f), tile.worldy() + Mathf.random((float)(this.size * 8) / 2.0f));
        }
        entity.heat = Mathf.clamp(entity.heat);
        if (entity.heat >= 0.999f) {
            Events.fire(EventType.Trigger.thoriumReactorOverheat);
            entity.kill();
        }
    }

    @Override
    public void onDestroyed(Tile tile) {
        int i;
        super.onDestroyed(tile);
        Sounds.explosionbig.at(tile);
        NuclearReactorEntity entity = (NuclearReactorEntity)tile.entity();
        int fuel = entity.items.get(((ConsumeItems)this.consumes.get((ConsumeType)ConsumeType.item)).items[0].item);
        if (fuel < 5 && entity.heat < 0.5f) {
            return;
        }
        Effects.shake(6.0f, 16.0f, tile.worldx(), tile.worldy());
        Effects.effect(Fx.nuclearShockwave, tile.worldx(), tile.worldy());
        for (i = 0; i < 6; ++i) {
            Time.run(Mathf.random(40), () -> Effects.effect(Fx.nuclearcloud, tile.worldx(), tile.worldy()));
        }
        Damage.damage(tile.worldx(), tile.worldy(), this.explosionRadius * 8, this.explosionDamage * 4);
        for (i = 0; i < 20; ++i) {
            Time.run(Mathf.random(50), () -> {
                this.tr.rnd(Mathf.random(40.0f));
                Effects.effect(Fx.explosion, this.tr.x + tile.worldx(), this.tr.y + tile.worldy());
            });
        }
        for (i = 0; i < 70; ++i) {
            Time.run(Mathf.random(80), () -> {
                this.tr.rnd(Mathf.random(120.0f));
                Effects.effect(Fx.nuclearsmoke, this.tr.x + tile.worldx(), this.tr.y + tile.worldy());
            });
        }
    }

    @Override
    public void draw(Tile tile) {
        super.draw(tile);
        NuclearReactorEntity entity = (NuclearReactorEntity)tile.entity();
        Draw.color(this.coolColor, this.hotColor, entity.heat);
        Fill.rect(tile.drawx(), tile.drawy(), this.size * 8, this.size * 8);
        Draw.color(entity.liquids.current().color);
        Draw.alpha(entity.liquids.currentAmount() / this.liquidCapacity);
        Draw.rect(this.topRegion, tile.drawx(), tile.drawy());
        if (entity.heat > this.flashThreshold) {
            float flash = 1.0f + (entity.heat - this.flashThreshold) / (1.0f - this.flashThreshold) * 5.4f;
            entity.flash += flash * Time.delta();
            Draw.color(Color.red, Color.yellow, Mathf.absin(entity.flash, 9.0f, 1.0f));
            Draw.alpha(0.6f);
            Draw.rect(this.lightsRegion, tile.drawx(), tile.drawy());
        }
        Draw.reset();
    }

    @Override
    public TileEntity newEntity() {
        return new NuclearReactorEntity();
    }

    public static class NuclearReactorEntity
    extends PowerGenerator.GeneratorEntity {
        public float heat;
        public float flash;

        @Override
        public void write(DataOutput stream) throws IOException {
            super.write(stream);
            stream.writeFloat(this.heat);
        }

        @Override
        public void read(DataInput stream, byte revision) throws IOException {
            super.read(stream, revision);
            this.heat = stream.readFloat();
        }
    }
}

