/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.power;

import io.anuke.arc.Core;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.Liquid;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.power.PowerGenerator;
import io.anuke.mindustry.world.consumers.ConsumeItemFilter;
import io.anuke.mindustry.world.consumers.ConsumeLiquidFilter;
import io.anuke.mindustry.world.meta.BlockStat;
import io.anuke.mindustry.world.meta.StatUnit;

public class ItemLiquidGenerator
extends PowerGenerator {
    protected float minItemEfficiency = 0.2f;
    protected float itemDuration = 70.0f;
    protected float minLiquidEfficiency = 0.2f;
    protected float maxLiquidGenerate = 0.4f;
    protected Effects.Effect generateEffect = Fx.generatespark;
    protected Effects.Effect explodeEffect = Fx.generatespark;
    protected Color heatColor = Color.valueOf("ff9b59");
    protected TextureRegion topRegion;
    protected TextureRegion liquidRegion;
    protected boolean randomlyExplode = true;
    protected boolean defaults = false;

    public ItemLiquidGenerator(boolean hasItems, boolean hasLiquids, String name) {
        super(name);
        this.hasItems = hasItems;
        this.hasLiquids = hasLiquids;
        this.setDefaults();
    }

    public ItemLiquidGenerator(String name) {
        super(name);
    }

    protected void setDefaults() {
        if (this.hasItems) {
            this.consumes.add(new ConsumeItemFilter(item -> this.getItemEfficiency((Item)item) >= this.minItemEfficiency)).update(false).optional(true, false);
        }
        if (this.hasLiquids) {
            this.consumes.add(new ConsumeLiquidFilter(liquid -> this.getLiquidEfficiency((Liquid)liquid) >= this.minLiquidEfficiency, this.maxLiquidGenerate)).update(false).optional(true, false);
        }
        this.defaults = true;
    }

    @Override
    public void init() {
        if (!this.defaults) {
            this.setDefaults();
        }
        super.init();
    }

    @Override
    public void load() {
        super.load();
        if (this.hasItems) {
            this.topRegion = Core.atlas.find(this.name + "-top");
        }
        this.liquidRegion = Core.atlas.find(this.name + "-liquid");
    }

    @Override
    public void setStats() {
        super.setStats();
        if (this.hasItems) {
            this.stats.add(BlockStat.productionTime, this.itemDuration / 60.0f, StatUnit.seconds);
        }
    }

    @Override
    public boolean shouldConsume(Tile tile) {
        ItemLiquidGeneratorEntity entity = (ItemLiquidGeneratorEntity)tile.entity();
        return entity.generateTime > 0.0f;
    }

    @Override
    public void update(Tile tile) {
        ItemLiquidGeneratorEntity entity = (ItemLiquidGeneratorEntity)tile.entity();
        float calculationDelta = entity.delta();
        if (!entity.cons.valid()) {
            entity.productionEfficiency = 0.0f;
            return;
        }
        Liquid liquid = null;
        for (Liquid other : Vars.content.liquids()) {
            if (!this.hasLiquids || !(entity.liquids.get(other) >= 0.001f) || !(this.getLiquidEfficiency(other) >= this.minLiquidEfficiency)) continue;
            liquid = other;
            break;
        }
        entity.heat = Mathf.lerpDelta(entity.heat, entity.generateTime >= 0.001f ? 1.0f : 0.0f, 0.05f);
        if (this.hasLiquids && liquid != null && entity.liquids.get(liquid) >= 0.001f) {
            float baseLiquidEfficiency = this.getLiquidEfficiency(liquid);
            float maximumPossible = this.maxLiquidGenerate * calculationDelta;
            float used = Math.min(entity.liquids.get(liquid) * calculationDelta, maximumPossible);
            entity.liquids.remove(liquid, used);
            entity.productionEfficiency = baseLiquidEfficiency * used / maximumPossible;
            if (used > 0.001f && Mathf.chance(0.05 * (double)entity.delta())) {
                Effects.effect(this.generateEffect, tile.drawx() + Mathf.range(3.0f), tile.drawy() + Mathf.range(3.0f));
            }
        } else if (this.hasItems) {
            if (entity.generateTime <= 0.0f && entity.items.total() > 0) {
                Effects.effect(this.generateEffect, tile.worldx() + Mathf.range(3.0f), tile.worldy() + Mathf.range(3.0f));
                Item item = entity.items.take();
                entity.productionEfficiency = this.getItemEfficiency(item);
                entity.explosiveness = item.explosiveness;
                entity.generateTime = 1.0f;
            }
            if (entity.generateTime > 0.0f) {
                entity.generateTime -= Math.min(1.0f / this.itemDuration * entity.delta(), entity.generateTime);
                if (this.randomlyExplode && Mathf.chance((double)entity.delta() * 0.06 * (double)Mathf.clamp(entity.explosiveness - 0.5f))) {
                    Core.app.post(() -> {
                        entity.damage(Mathf.random(11.0f));
                        Effects.effect(this.explodeEffect, tile.worldx() + Mathf.range((float)(this.size * 8) / 2.0f), tile.worldy() + Mathf.range((float)(this.size * 8) / 2.0f));
                    });
                }
            } else {
                entity.productionEfficiency = 0.0f;
            }
        }
    }

    @Override
    public void draw(Tile tile) {
        super.draw(tile);
        ItemLiquidGeneratorEntity entity = (ItemLiquidGeneratorEntity)tile.entity();
        if (this.hasItems) {
            Draw.color(this.heatColor);
            Draw.alpha(entity.heat * 0.4f + Mathf.absin(Time.time(), 8.0f, 0.6f) * entity.heat);
            Draw.rect(this.topRegion, tile.drawx(), tile.drawy());
            Draw.reset();
        }
        if (this.hasLiquids) {
            Draw.color(entity.liquids.current().color);
            Draw.alpha(entity.liquids.currentAmount() / this.liquidCapacity);
            Draw.rect(this.liquidRegion, tile.drawx(), tile.drawy());
            Draw.color();
        }
    }

    protected float getItemEfficiency(Item item) {
        return 0.0f;
    }

    protected float getLiquidEfficiency(Liquid liquid) {
        return 0.0f;
    }

    @Override
    public TileEntity newEntity() {
        return new ItemLiquidGeneratorEntity();
    }

    public static class ItemLiquidGeneratorEntity
    extends PowerGenerator.GeneratorEntity {
        public float explosiveness;
        public float heat;
    }
}

