/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.distribution;

import io.anuke.arc.function.Eachable;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.ArcAnnotate;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.entities.traits.BuilderTrait;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.DirectionalItemBuffer;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.ItemSelection;
import io.anuke.mindustry.world.meta.BlockGroup;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Sorter
extends Block {
    private static Item lastItem;
    protected boolean invert;

    public Sorter(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.instantTransfer = true;
        this.group = BlockGroup.transportation;
        this.configurable = true;
        this.unloadable = false;
    }

    @Override
    public boolean outputsItems() {
        return true;
    }

    @Override
    public void playerPlaced(Tile tile) {
        if (lastItem != null) {
            tile.configure(Sorter.lastItem.id);
        }
    }

    @Override
    public void configured(Tile tile, Player player, int value) {
        ((SorterEntity)tile.entity()).sortItem = Vars.content.item(value);
    }

    @Override
    public void drawRequestConfig(BuilderTrait.BuildRequest req, Eachable<BuilderTrait.BuildRequest> list) {
        this.drawRequestConfigCenter(req, Vars.content.item(req.config), "center");
    }

    @Override
    public void draw(Tile tile) {
        super.draw(tile);
        SorterEntity entity = (SorterEntity)tile.entity();
        if (entity.sortItem == null) {
            return;
        }
        Draw.color(entity.sortItem.color);
        Draw.rect("center", tile.worldx(), tile.worldy());
        Draw.color();
    }

    @Override
    public boolean acceptItem(Item item, Tile tile, Tile source) {
        Tile to = this.getTileTarget(item, tile, source, false);
        return to != null && to.block().acceptItem(item, to, tile);
    }

    @Override
    public void handleItem(Item item, Tile tile, Tile source) {
        Tile to = this.getTileTarget(item, tile, source, true);
        to.block().handleItem(item, to, tile);
    }

    boolean isSame(Tile tile, Tile other) {
        return other != null && other.block() instanceof Sorter && ((SorterEntity)other.entity()).sortItem == ((SorterEntity)tile.entity()).sortItem;
    }

    Tile getTileTarget(Item item, Tile dest, Tile source, boolean flip) {
        Tile to;
        SorterEntity entity = (SorterEntity)dest.entity();
        byte dir = source.relativeTo(dest.x, dest.y);
        if (dir == -1) {
            return null;
        }
        if (item == entity.sortItem != this.invert) {
            if (this.isSame(dest, source) && this.isSame(dest, dest.getNearby(dir))) {
                return null;
            }
            to = dest.getNearby(dir);
        } else {
            boolean bc;
            Tile a = dest.getNearby(Mathf.mod(dir - 1, 4));
            Tile b = dest.getNearby(Mathf.mod(dir + 1, 4));
            boolean ac = a != null && (!a.block().instantTransfer || !source.block().instantTransfer) && a.block().acceptItem(item, a, dest);
            boolean bl = bc = b != null && (!b.block().instantTransfer || !source.block().instantTransfer) && b.block().acceptItem(item, b, dest);
            if (ac && !bc) {
                to = a;
            } else if (bc && !ac) {
                to = b;
            } else {
                if (!bc) {
                    return null;
                }
                if (dest.rotation() == 0) {
                    to = a;
                    if (flip) {
                        dest.rotation(1);
                    }
                } else {
                    to = b;
                    if (flip) {
                        dest.rotation(0);
                    }
                }
            }
        }
        return to;
    }

    @Override
    public void buildTable(Tile tile, Table table) {
        SorterEntity entity = (SorterEntity)tile.entity();
        ItemSelection.buildItemTable(table, () -> entity.sortItem, item -> {
            lastItem = item;
            tile.configure(item == null ? -1 : (int)item.id);
        });
    }

    @Override
    public TileEntity newEntity() {
        return new SorterEntity();
    }

    public class SorterEntity
    extends TileEntity {
        @ArcAnnotate.Nullable
        Item sortItem;

        @Override
        public int config() {
            return this.sortItem == null ? -1 : (int)this.sortItem.id;
        }

        @Override
        public byte version() {
            return 2;
        }

        @Override
        public void write(DataOutput stream) throws IOException {
            super.write(stream);
            stream.writeShort(this.sortItem == null ? -1 : (int)this.sortItem.id);
        }

        @Override
        public void read(DataInput stream, byte revision) throws IOException {
            super.read(stream, revision);
            this.sortItem = Vars.content.item(stream.readShort());
            if (revision == 1) {
                new DirectionalItemBuffer(20, 45.0f).read(stream);
            }
        }
    }
}

