/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.distribution;

import io.anuke.arc.Core;
import io.anuke.arc.collection.OrderedSet;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Angles;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.util.Time;
import io.anuke.arc.util.pooling.Pool;
import io.anuke.arc.util.pooling.Pools;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Bullets;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.type.Bullet;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.graphics.Drawf;
import io.anuke.mindustry.graphics.Layer;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MassDriver
extends Block {
    protected float range;
    protected float rotateSpeed = 0.04f;
    protected float translation = 7.0f;
    protected int minDistribute = 10;
    protected float knockback = 4.0f;
    protected float reloadTime = 100.0f;
    protected Effects.Effect shootEffect = Fx.shootBig2;
    protected Effects.Effect smokeEffect = Fx.shootBigSmoke2;
    protected Effects.Effect recieveEffect = Fx.mineBig;
    protected float shake = 3.0f;
    protected TextureRegion baseRegion;

    public MassDriver(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.posConfig = true;
        this.configurable = true;
        this.hasItems = true;
        this.layer = Layer.turret;
        this.hasPower = true;
        this.outlineIcon = true;
    }

    @Override
    public void configured(Tile tile, Player player, int value) {
        ((MassDriverEntity)tile.entity()).link = value;
    }

    @Override
    public TextureRegion[] generateIcons() {
        return new TextureRegion[]{Core.atlas.find(this.name + "-base"), Core.atlas.find(this.name)};
    }

    @Override
    public void load() {
        super.load();
        this.baseRegion = Core.atlas.find(this.name + "-base");
    }

    @Override
    public void update(Tile tile) {
        MassDriverEntity entity = (MassDriverEntity)tile.entity();
        Tile link = Vars.world.tile(entity.link);
        boolean hasLink = this.linkValid(tile);
        if (entity.reload > 0.0f) {
            entity.reload = Mathf.clamp(entity.reload - entity.delta() / this.reloadTime * entity.power.satisfaction);
        }
        if (!this.shooterValid(tile, entity.currentShooter())) {
            entity.waitingShooters.remove(entity.currentShooter());
        }
        if (entity.state == DriverState.idle) {
            if (!entity.waitingShooters.isEmpty() && this.itemCapacity - entity.items.total() >= this.minDistribute) {
                entity.state = DriverState.accepting;
            } else if (hasLink) {
                entity.state = DriverState.shooting;
            }
        }
        if (entity.state == DriverState.idle || entity.state == DriverState.accepting) {
            this.tryDump(tile);
        }
        if (!entity.cons.valid()) {
            return;
        }
        if (entity.state == DriverState.accepting) {
            if (entity.currentShooter() == null || this.itemCapacity - entity.items.total() < this.minDistribute) {
                entity.state = DriverState.idle;
                return;
            }
            entity.rotation = Mathf.slerpDelta(entity.rotation, tile.angleTo(entity.currentShooter()), this.rotateSpeed * entity.power.satisfaction);
        } else if (entity.state == DriverState.shooting) {
            if (!hasLink || !entity.waitingShooters.isEmpty() && this.itemCapacity - entity.items.total() >= this.minDistribute) {
                entity.state = DriverState.idle;
                return;
            }
            float targetRotation = tile.angleTo(link);
            if (tile.entity.items.total() >= this.minDistribute && link.block().itemCapacity - link.entity.items.total() >= this.minDistribute) {
                MassDriverEntity other = (MassDriverEntity)link.entity();
                other.waitingShooters.add(tile);
                if (entity.reload <= 1.0E-4f) {
                    entity.rotation = Mathf.slerpDelta(entity.rotation, targetRotation, this.rotateSpeed * entity.power.satisfaction);
                    if (other.currentShooter() == tile && other.state == DriverState.accepting && Angles.near(entity.rotation, targetRotation, 2.0f) && Angles.near(other.rotation, targetRotation + 180.0f, 2.0f)) {
                        this.fire(tile, link);
                        other.waitingShooters.remove(tile);
                        entity.state = DriverState.idle;
                        other.state = DriverState.idle;
                    }
                }
            }
        }
    }

    @Override
    public void draw(Tile tile) {
        Draw.rect(this.baseRegion, tile.drawx(), tile.drawy());
    }

    @Override
    public void drawLayer(Tile tile) {
        MassDriverEntity entity = (MassDriverEntity)tile.entity();
        Draw.rect(this.region, tile.drawx() + Angles.trnsx(entity.rotation + 180.0f, entity.reload * this.knockback), tile.drawy() + Angles.trnsy(entity.rotation + 180.0f, entity.reload * this.knockback), entity.rotation - 90.0f);
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        Drawf.dashCircle(x * 8, y * 8, this.range, Pal.accent);
    }

    @Override
    public void drawConfigure(Tile tile) {
        float sin = Mathf.absin(Time.time(), 6.0f, 1.0f);
        Draw.color(Pal.accent);
        Lines.stroke(1.0f);
        Drawf.circles(tile.drawx(), tile.drawy(), ((float)tile.block().size / 2.0f + 1.0f) * 8.0f + sin - 2.0f, Pal.accent);
        MassDriverEntity entity = (MassDriverEntity)tile.entity();
        if (this.linkValid(tile)) {
            Tile target = Vars.world.tile(entity.link);
            Drawf.circles(target.drawx(), target.drawy(), ((float)target.block().size / 2.0f + 1.0f) * 8.0f + sin - 2.0f, Pal.place);
            Drawf.arrow(tile.drawx(), tile.drawy(), target.drawx(), target.drawy(), (float)(this.size * 8) + sin, 4.0f + sin);
        }
        Drawf.dashCircle(tile.drawx(), tile.drawy(), this.range, Pal.accent);
    }

    @Override
    public boolean onConfigureTileTapped(Tile tile, Tile other) {
        if (tile == other) {
            return false;
        }
        MassDriverEntity entity = (MassDriverEntity)tile.entity();
        if (entity.link == other.pos()) {
            tile.configure(-1);
            return false;
        }
        if (other.block() instanceof MassDriver && other.dst(tile) <= this.range && other.getTeam() == tile.getTeam()) {
            tile.configure(other.pos());
            return false;
        }
        return true;
    }

    @Override
    public boolean acceptItem(Item item, Tile tile, Tile source) {
        return tile.entity.items.total() < this.itemCapacity && this.linkValid(tile);
    }

    @Override
    public TileEntity newEntity() {
        return new MassDriverEntity();
    }

    protected void fire(Tile tile, Tile target) {
        MassDriverEntity entity = (MassDriverEntity)tile.entity();
        MassDriverEntity other = (MassDriverEntity)target.entity();
        entity.reload = 1.0f;
        DriverBulletData data = Pools.obtain(DriverBulletData.class, DriverBulletData::new);
        data.from = entity;
        data.to = other;
        int totalUsed = 0;
        for (int i = 0; i < Vars.content.items().size; ++i) {
            int maxTransfer;
            data.items[i] = maxTransfer = Math.min(entity.items.get(Vars.content.item(i)), ((MassDriver)tile.block()).itemCapacity - totalUsed);
            totalUsed += maxTransfer;
            entity.items.remove(Vars.content.item(i), maxTransfer);
        }
        float angle = tile.angleTo(target);
        Bullet.create(Bullets.driverBolt, entity, entity.getTeam(), tile.drawx() + Angles.trnsx(angle, this.translation), tile.drawy() + Angles.trnsy(angle, this.translation), angle, 1.0f, 1.0f, data);
        Effects.effect(this.shootEffect, tile.drawx() + Angles.trnsx(angle, this.translation), tile.drawy() + Angles.trnsy(angle, this.translation), angle);
        Effects.effect(this.smokeEffect, tile.drawx() + Angles.trnsx(angle, this.translation), tile.drawy() + Angles.trnsy(angle, this.translation), angle);
        Effects.shake(this.shake, this.shake, entity);
    }

    protected void handlePayload(MassDriverEntity entity, Bullet bullet, DriverBulletData data) {
        int totalItems = entity.items.total();
        int i = 0;
        while (i < data.items.length) {
            int maxAdd = Math.min(data.items[i], this.itemCapacity * 2 - totalItems);
            entity.items.add(Vars.content.item(i), maxAdd);
            int n = i++;
            data.items[n] = data.items[n] - maxAdd;
            if ((totalItems += maxAdd) >= this.itemCapacity * 2) break;
        }
        Effects.shake(this.shake, this.shake, entity);
        Effects.effect(this.recieveEffect, bullet);
        entity.reload = 1.0f;
        bullet.remove();
    }

    protected boolean shooterValid(Tile tile, Tile other) {
        if (other == null) {
            return true;
        }
        if (!(other.block() instanceof MassDriver)) {
            return false;
        }
        MassDriverEntity entity = (MassDriverEntity)other.entity();
        return entity.link == tile.pos() && tile.dst(other) <= this.range;
    }

    protected boolean linkValid(Tile tile) {
        if (tile == null) {
            return false;
        }
        MassDriverEntity entity = (MassDriverEntity)tile.entity();
        if (entity == null || entity.link == -1) {
            return false;
        }
        Tile link = Vars.world.tile(entity.link);
        return link != null && link.block() instanceof MassDriver && tile.dst(link) <= this.range;
    }

    static enum DriverState {
        idle,
        accepting,
        shooting,
        unloading;

    }

    public class MassDriverEntity
    extends TileEntity {
        int link = -1;
        float rotation = 90.0f;
        float reload = 0.0f;
        DriverState state = DriverState.idle;
        OrderedSet<Tile> waitingShooters = new OrderedSet();

        Tile currentShooter() {
            return this.waitingShooters.isEmpty() ? null : this.waitingShooters.first();
        }

        public void handlePayload(Bullet bullet, DriverBulletData data) {
            ((MassDriver)this.block).handlePayload(this, bullet, data);
        }

        @Override
        public int config() {
            return this.link;
        }

        @Override
        public void write(DataOutput stream) throws IOException {
            super.write(stream);
            stream.writeInt(this.link);
            stream.writeFloat(this.rotation);
            stream.writeByte((byte)this.state.ordinal());
        }

        @Override
        public void read(DataInput stream, byte revision) throws IOException {
            super.read(stream, revision);
            this.link = stream.readInt();
            this.rotation = stream.readFloat();
            this.state = DriverState.values()[stream.readByte()];
        }
    }

    public static class DriverBulletData
    implements Pool.Poolable {
        public MassDriverEntity from;
        public MassDriverEntity to;
        public int[] items;

        public DriverBulletData() {
            this.items = new int[Vars.content.items().size];
        }

        @Override
        public void reset() {
            this.from = null;
            this.to = null;
        }
    }
}

