/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.distribution;

import io.anuke.arc.math.Mathf;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.distribution.ItemBridge;
import io.anuke.mindustry.world.meta.BlockGroup;

public class LiquidBridge
extends ItemBridge {
    public LiquidBridge(String name) {
        super(name);
        this.hasItems = false;
        this.hasLiquids = true;
        this.outputsLiquid = true;
        this.group = BlockGroup.liquids;
    }

    @Override
    public void update(Tile tile) {
        ItemBridge.ItemBridgeEntity entity = (ItemBridge.ItemBridgeEntity)tile.entity();
        entity.time += entity.cycleSpeed * Time.delta();
        entity.time2 += (entity.cycleSpeed - 1.0f) * Time.delta();
        Tile other = Vars.world.tile(entity.link);
        if (!this.linkValid(tile, other)) {
            this.tryDumpLiquid(tile, entity.liquids.current());
        } else {
            if (entity.cons.valid()) {
                float alpha = 0.04f;
                if (this.hasPower) {
                    alpha *= entity.power.satisfaction;
                }
                entity.uptime = Mathf.lerpDelta(entity.uptime, 1.0f, alpha);
            } else {
                entity.uptime = Mathf.lerpDelta(entity.uptime, 0.0f, 0.02f);
            }
            if (entity.uptime >= 0.5f) {
                entity.cycleSpeed = this.tryMoveLiquid(tile, other, false, entity.liquids.current()) > 0.1f ? Mathf.lerpDelta(entity.cycleSpeed, 4.0f, 0.05f) : Mathf.lerpDelta(entity.cycleSpeed, 1.0f, 0.01f);
            }
        }
    }

    @Override
    public boolean acceptItem(Item item, Tile tile, Tile source) {
        return false;
    }
}

