/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.distribution;

import io.anuke.arc.Core;
import io.anuke.arc.collection.IntSet;
import io.anuke.arc.function.Eachable;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.CapStyle;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Angles;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Geometry;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.entities.traits.BuilderTrait;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.graphics.Layer;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.Liquid;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Edges;
import io.anuke.mindustry.world.Pos;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.meta.BlockGroup;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ItemBridge
extends Block {
    protected int timerTransport;
    protected int range;
    protected float transportTime;
    protected TextureRegion endRegion;
    protected TextureRegion bridgeRegion;
    protected TextureRegion arrowRegion;
    protected BuilderTrait.BuildRequest otherReq;
    private static int lastPlaced = Pos.invalid;

    public ItemBridge(String name) {
        super(name);
        this.timerTransport = this.timers++;
        this.transportTime = 2.0f;
        this.update = true;
        this.solid = true;
        this.hasPower = true;
        this.layer = Layer.power;
        this.expanded = true;
        this.itemCapacity = 10;
        this.posConfig = true;
        this.configurable = true;
        this.hasItems = true;
        this.unloadable = false;
        this.group = BlockGroup.transportation;
    }

    @Override
    public void configured(Tile tile, Player player, int value) {
        ItemBridgeEntity entity = (ItemBridgeEntity)tile.entity();
        if (Vars.world.tile(entity.link) != null && Vars.world.tile((int)entity.link).entity instanceof ItemBridgeEntity) {
            ItemBridgeEntity oe = (ItemBridgeEntity)Vars.world.tile(entity.link).entity();
            oe.incoming.remove(tile.pos());
        }
        entity.link = value;
        if (Vars.world.tile(value) != null && Vars.world.tile((int)value).entity instanceof ItemBridgeEntity) {
            ((ItemBridgeEntity)Vars.world.tile((int)value).entity).incoming.add(tile.pos());
        }
    }

    @Override
    public void load() {
        super.load();
        this.endRegion = Core.atlas.find(this.name + "-end");
        this.bridgeRegion = Core.atlas.find(this.name + "-bridge");
        this.arrowRegion = Core.atlas.find(this.name + "-arrow");
    }

    @Override
    public void drawRequestConfigTop(BuilderTrait.BuildRequest req, Eachable<BuilderTrait.BuildRequest> list) {
        this.otherReq = null;
        list.each(other -> {
            if (other.block == this && req.config == Pos.get(other.x, other.y)) {
                this.otherReq = other;
            }
        });
        if (this.otherReq == null) {
            return;
        }
        Lines.stroke(8.0f);
        Lines.line(this.bridgeRegion, req.drawx(), req.drawy(), this.otherReq.drawx(), this.otherReq.drawy(), CapStyle.none, -4.0f);
        Draw.rect(this.arrowRegion, (req.drawx() + this.otherReq.drawx()) / 2.0f, (req.drawy() + this.otherReq.drawy()) / 2.0f, Angles.angle(req.drawx(), req.drawy(), this.otherReq.drawx(), this.otherReq.drawy()));
    }

    @Override
    public void playerPlaced(Tile tile) {
        Tile link = this.findLink(tile.x, tile.y);
        if (this.linkValid(tile, link)) {
            link.configure(tile.pos());
        }
        lastPlaced = tile.pos();
    }

    public Tile findLink(int x, int y) {
        if (Vars.world.tile(x, y) != null && this.linkValid(Vars.world.tile(x, y), Vars.world.tile(lastPlaced)) && lastPlaced != Pos.get(x, y)) {
            return Vars.world.tile(lastPlaced);
        }
        return null;
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        Tile link = this.findLink(x, y);
        Lines.stroke(2.0f, Pal.placing);
        for (int i = 0; i < 4; ++i) {
            Lines.dashLine((float)(x * 8) + (float)Geometry.d4[i].x * 6.0f, (float)(y * 8) + (float)Geometry.d4[i].y * 6.0f, (float)(x * 8) + (float)Geometry.d4[i].x * ((float)this.range + 0.5f) * 8.0f, (float)(y * 8) + (float)Geometry.d4[i].y * ((float)this.range + 0.5f) * 8.0f, this.range);
        }
        Draw.reset();
        Draw.color(Pal.placing);
        Lines.stroke(1.0f);
        if (link != null) {
            byte rot = link.absoluteRelativeTo(x, y);
            float w = link.x == x ? 8 : Math.abs(link.x - x) * 8 - 8;
            float h = link.y == y ? 8 : Math.abs(link.y - y) * 8 - 8;
            Lines.rect((float)(x + link.x) / 2.0f * 8.0f - w / 2.0f, (float)(y + link.y) / 2.0f * 8.0f - h / 2.0f, w, h);
            Draw.rect("bridge-arrow", (float)(link.x * 8 + Geometry.d4[rot].x * 8), (float)(link.y * 8 + Geometry.d4[rot].y * 8), (float)(link.absoluteRelativeTo(x, y) * 90));
        }
        Draw.reset();
    }

    @Override
    public void drawConfigure(Tile tile) {
        ItemBridgeEntity entity = (ItemBridgeEntity)tile.entity();
        Draw.color(Pal.accent);
        Lines.stroke(1.0f);
        Lines.square(tile.drawx(), tile.drawy(), (float)(tile.block().size * 8) / 2.0f + 1.0f);
        for (int i = 1; i <= this.range; ++i) {
            for (int j = 0; j < 4; ++j) {
                Tile other = tile.getNearby(Geometry.d4[j].x * i, Geometry.d4[j].y * i);
                if (!this.linkValid(tile, other)) continue;
                boolean linked = other.pos() == entity.link;
                Draw.color(linked ? Pal.place : Pal.breakInvalid);
                Lines.square(other.drawx(), other.drawy(), (float)(other.block().size * 8) / 2.0f + 1.0f + (linked ? 0.0f : Mathf.absin(Time.time(), 4.0f, 1.0f)));
            }
        }
        Draw.reset();
    }

    @Override
    public boolean onConfigureTileTapped(Tile tile, Tile other) {
        ItemBridgeEntity entity = (ItemBridgeEntity)tile.entity();
        if (this.linkValid(tile, other)) {
            if (entity.link == other.pos()) {
                tile.configure(Pos.invalid);
            } else {
                tile.configure(other.pos());
            }
            return false;
        }
        return true;
    }

    @Override
    public void update(Tile tile) {
        ItemBridgeEntity entity = (ItemBridgeEntity)tile.entity();
        entity.time += entity.cycleSpeed * entity.delta();
        entity.time2 += (entity.cycleSpeed - 1.0f) * entity.delta();
        IntSet.IntSetIterator it = entity.incoming.iterator();
        while (it.hasNext) {
            int i = it.next();
            Tile other = Vars.world.tile(i);
            if (this.linkValid(tile, other, false)) continue;
            it.remove();
        }
        Tile other = Vars.world.tile(entity.link);
        if (!this.linkValid(tile, other)) {
            this.tryDump(tile);
            entity.uptime = 0.0f;
        } else {
            entity.uptime = entity.cons.valid() && (!this.hasPower || Mathf.isZero(1.0f - entity.power.satisfaction)) ? Mathf.lerpDelta(entity.uptime, 1.0f, 0.04f) : Mathf.lerpDelta(entity.uptime, 0.0f, 0.02f);
            this.updateTransport(tile, other);
        }
    }

    public void updateTransport(Tile tile, Tile other) {
        ItemBridgeEntity entity = (ItemBridgeEntity)tile.entity();
        if (entity.uptime >= 0.5f && entity.timer.get(this.timerTransport, this.transportTime)) {
            Item item = entity.items.take();
            if (item != null && other.block().acceptItem(item, other, tile)) {
                other.block().handleItem(item, other, tile);
                entity.cycleSpeed = Mathf.lerpDelta(entity.cycleSpeed, 4.0f, 0.05f);
            } else {
                entity.cycleSpeed = Mathf.lerpDelta(entity.cycleSpeed, 1.0f, 0.01f);
                if (item != null) {
                    entity.items.add(item, 1);
                }
            }
        }
    }

    @Override
    public void drawLayer(Tile tile) {
        ItemBridgeEntity entity = (ItemBridgeEntity)tile.entity();
        Tile other = Vars.world.tile(entity.link);
        if (!this.linkValid(tile, other)) {
            return;
        }
        byte i = tile.absoluteRelativeTo(other.x, other.y);
        Draw.color(Color.white, Color.black, Mathf.absin(Time.time(), 6.0f, 0.07f));
        Draw.alpha(Math.max(entity.uptime, 0.25f));
        Draw.rect(this.endRegion, tile.drawx(), tile.drawy(), (float)(i * 90 + 90));
        Draw.rect(this.endRegion, other.drawx(), other.drawy(), (float)(i * 90 + 270));
        Lines.stroke(8.0f);
        Lines.line(this.bridgeRegion, tile.worldx(), tile.worldy(), other.worldx(), other.worldy(), CapStyle.none, -4.0f);
        int dist = Math.max(Math.abs(other.x - tile.x), Math.abs(other.y - tile.y));
        float time = entity.time2 / 1.7f;
        int arrows = dist * 8 / 4 - 2;
        Draw.color();
        for (int a = 0; a < arrows; ++a) {
            Draw.alpha(Mathf.absin((float)a / (float)arrows - entity.time / 100.0f, 0.1f, 1.0f) * entity.uptime);
            Draw.rect(this.arrowRegion, tile.worldx() + (float)Geometry.d4[i].x * (4.0f + (float)a * 4.0f + time % 4.0f), tile.worldy() + (float)Geometry.d4[i].y * (4.0f + (float)a * 4.0f + time % 4.0f), (float)i * 90.0f);
        }
        Draw.reset();
    }

    @Override
    public boolean acceptItem(Item item, Tile tile, Tile source) {
        if (tile.getTeam() != source.getTeam()) {
            return false;
        }
        ItemBridgeEntity entity = (ItemBridgeEntity)tile.entity();
        Tile other = Vars.world.tile(entity.link);
        if (this.linkValid(tile, other)) {
            byte rel2;
            byte rel = tile.absoluteRelativeTo(other.x, other.y);
            if (rel == (rel2 = tile.relativeTo(source.x, source.y))) {
                return false;
            }
        } else {
            return source.block() instanceof ItemBridge && ((ItemBridgeEntity)source.entity()).link == tile.pos() && tile.entity.items.total() < this.itemCapacity;
        }
        return tile.entity.items.total() < this.itemCapacity;
    }

    @Override
    public boolean canDumpLiquid(Tile tile, Tile to, Liquid liquid) {
        byte rel2;
        ItemBridgeEntity entity = (ItemBridgeEntity)tile.entity();
        Tile other = Vars.world.tile(entity.link);
        if (!this.linkValid(tile, other)) {
            Tile edge = Edges.getFacingEdge(to, tile);
            byte i = tile.absoluteRelativeTo(edge.x, edge.y);
            IntSet.IntSetIterator it = entity.incoming.iterator();
            while (it.hasNext) {
                int v = it.next();
                if (tile.absoluteRelativeTo(Pos.x(v), Pos.y(v)) != i) continue;
                return false;
            }
            return true;
        }
        byte rel = tile.absoluteRelativeTo(other.x, other.y);
        return rel != (rel2 = tile.relativeTo(to.x, to.y));
    }

    @Override
    public boolean acceptLiquid(Tile tile, Tile source, Liquid liquid, float amount) {
        byte rel2;
        byte rel;
        if (tile.getTeam() != source.getTeam()) {
            return false;
        }
        ItemBridgeEntity entity = (ItemBridgeEntity)tile.entity();
        Tile other = Vars.world.tile(entity.link);
        if (this.linkValid(tile, other) ? (rel = tile.absoluteRelativeTo(other.x, other.y)) == (rel2 = tile.relativeTo(source.x, source.y)) : !(source.block() instanceof ItemBridge) || ((ItemBridgeEntity)source.entity()).link != tile.pos()) {
            return false;
        }
        return tile.entity.liquids.get(liquid) + amount < this.liquidCapacity && (tile.entity.liquids.current() == liquid || tile.entity.liquids.get(tile.entity.liquids.current()) < 0.2f);
    }

    @Override
    public boolean canDump(Tile tile, Tile to, Item item) {
        byte rel2;
        ItemBridgeEntity entity = (ItemBridgeEntity)tile.entity();
        Tile other = Vars.world.tile(entity.link);
        if (!this.linkValid(tile, other)) {
            Tile edge = Edges.getFacingEdge(to, tile);
            byte i = tile.absoluteRelativeTo(edge.x, edge.y);
            IntSet.IntSetIterator it = entity.incoming.iterator();
            while (it.hasNext) {
                int v = it.next();
                if (tile.absoluteRelativeTo(Pos.x(v), Pos.y(v)) != i) continue;
                return false;
            }
            return true;
        }
        byte rel = tile.absoluteRelativeTo(other.x, other.y);
        return rel != (rel2 = tile.relativeTo(to.x, to.y));
    }

    @Override
    public TileEntity newEntity() {
        return new ItemBridgeEntity();
    }

    public boolean linkValid(Tile tile, Tile other) {
        return this.linkValid(tile, other, true);
    }

    public boolean linkValid(Tile tile, Tile other, boolean checkDouble) {
        if (other == null || tile == null) {
            return false;
        }
        if (tile.x == other.x) {
            if (Math.abs(tile.y - other.y) > this.range) {
                return false;
            }
        } else if (tile.y == other.y) {
            if (Math.abs(tile.x - other.x) > this.range) {
                return false;
            }
        } else {
            return false;
        }
        return other.block() == this && (!checkDouble || ((ItemBridgeEntity)other.entity()).link != tile.pos());
    }

    public static class ItemBridgeEntity
    extends TileEntity {
        public int link = Pos.invalid;
        public IntSet incoming = new IntSet();
        public float uptime;
        public float time;
        public float time2;
        public float cycleSpeed = 1.0f;

        @Override
        public int config() {
            return this.link;
        }

        @Override
        public void write(DataOutput stream) throws IOException {
            super.write(stream);
            stream.writeInt(this.link);
            stream.writeFloat(this.uptime);
            stream.writeByte(this.incoming.size);
            IntSet.IntSetIterator it = this.incoming.iterator();
            while (it.hasNext) {
                stream.writeInt(it.next());
            }
        }

        @Override
        public void read(DataInput stream, byte revision) throws IOException {
            super.read(stream, revision);
            this.link = stream.readInt();
            this.uptime = stream.readFloat();
            int links = stream.readByte();
            for (int i = 0; i < links; ++i) {
                this.incoming.add(stream.readInt());
            }
        }
    }
}

