/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.distribution;

import io.anuke.arc.Core;
import io.anuke.arc.collection.LongArray;
import io.anuke.arc.function.Eachable;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Geometry;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.util.Log;
import io.anuke.arc.util.Pack;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.entities.traits.BuilderTrait;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.entities.type.Unit;
import io.anuke.mindustry.gen.Sounds;
import io.anuke.mindustry.graphics.Layer;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.ui.Cicon;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.Autotiler;
import io.anuke.mindustry.world.meta.BlockGroup;
import io.anuke.mindustry.world.meta.BlockStat;
import io.anuke.mindustry.world.meta.StatUnit;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Conveyor
extends Block
implements Autotiler {
    private static final float itemSpace = 0.4f;
    private static final float minmove = 3.0520372E-5f;
    private static ItemPos drawpos = new ItemPos();
    private static ItemPos pos1 = new ItemPos();
    private static ItemPos pos2 = new ItemPos();
    private final Vector2 tr1 = new Vector2();
    private final Vector2 tr2 = new Vector2();
    private final int[] blendresult = new int[3];
    private final BuilderTrait.BuildRequest[] directionals = new BuilderTrait.BuildRequest[4];
    private TextureRegion[][] regions = new TextureRegion[7][4];
    protected float speed = 0.0f;

    protected Conveyor(String name) {
        super(name);
        this.rotate = true;
        this.update = true;
        this.layer = Layer.overlay;
        this.group = BlockGroup.transportation;
        this.hasItems = true;
        this.itemCapacity = 4;
        this.idleSound = Sounds.conveyor;
        this.idleSoundVolume = 0.004f;
        this.unloadable = false;
    }

    private static int compareItems(long a, long b) {
        pos1.set(a, ItemPos.packShorts);
        pos2.set(b, ItemPos.packShorts);
        return Float.compare(Conveyor.pos1.y, Conveyor.pos2.y);
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(BlockStat.itemsMoved, this.speed * 60.0f * 2.5f, StatUnit.itemsSecond);
    }

    @Override
    public void load() {
        super.load();
        for (int i = 0; i < this.regions.length; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.regions[i][j] = Core.atlas.find(this.name + "-" + i + "-" + j);
            }
        }
    }

    @Override
    public void draw(Tile tile) {
        ConveyorEntity entity = (ConveyorEntity)tile.entity();
        byte rotation = tile.rotation();
        int frame = entity.clogHeat <= 0.5f ? (int)(Time.time() * this.speed * 8.0f * entity.timeScale % 4.0f) : 0;
        Draw.rect(this.regions[Mathf.clamp(entity.blendbits, 0, this.regions.length - 1)][Mathf.clamp(frame, 0, this.regions[0].length - 1)], tile.drawx(), tile.drawy(), (float)(8 * entity.blendsclx), (float)(8 * entity.blendscly), (float)(rotation * 90));
    }

    @Override
    public boolean shouldIdleSound(Tile tile) {
        ConveyorEntity entity = (ConveyorEntity)tile.entity();
        return entity.clogHeat <= 0.5f;
    }

    @Override
    public void onProximityUpdate(Tile tile) {
        super.onProximityUpdate(tile);
        ConveyorEntity entity = (ConveyorEntity)tile.entity();
        int[] bits = this.buildBlending(tile, tile.rotation(), null, true);
        entity.blendbits = bits[0];
        entity.blendsclx = bits[1];
        entity.blendscly = bits[2];
    }

    @Override
    public void drawRequestRegion(BuilderTrait.BuildRequest req, Eachable<BuilderTrait.BuildRequest> list) {
        int[] bits = this.getTiling(req, list);
        if (bits == null) {
            return;
        }
        TextureRegion region = this.regions[bits[0]][0];
        Draw.rect(region, req.drawx(), req.drawy(), (float)(region.getWidth() * bits[1]) * Draw.scl * req.animScale, (float)(region.getHeight() * bits[2]) * Draw.scl * req.animScale, (float)(req.rotation * 90));
    }

    @Override
    public boolean blends(Tile tile, int rotation, int otherx, int othery, int otherrot, Block otherblock) {
        return otherblock.outputsItems() && this.lookingAt(tile, rotation, otherx, othery, otherrot, otherblock);
    }

    @Override
    public TextureRegion[] generateIcons() {
        return new TextureRegion[]{Core.atlas.find(this.name + "-0-0")};
    }

    @Override
    public void drawLayer(Tile tile) {
        ConveyorEntity entity = (ConveyorEntity)tile.entity();
        byte rotation = tile.rotation();
        try {
            for (int i = 0; i < entity.convey.size; ++i) {
                ItemPos pos = drawpos.set(entity.convey.get(i), ItemPos.drawShorts);
                if (pos.item == null) continue;
                this.tr1.trns(rotation * 90, 8.0f, 0.0f);
                this.tr2.trns(rotation * 90, -4.0f, pos.x * 8.0f / 2.0f);
                Draw.rect(pos.item.icon(Cicon.medium), (float)(tile.x * 8) + this.tr1.x * pos.y + this.tr2.x, (float)(tile.y * 8) + this.tr1.y * pos.y + this.tr2.y, 5.0f, 5.0f);
            }
        }
        catch (IndexOutOfBoundsException e) {
            Log.err(e);
        }
    }

    @Override
    public void unitOn(Tile tile, Unit unit) {
        ConveyorEntity entity = (ConveyorEntity)tile.entity();
        if (entity.clogHeat > 0.5f) {
            return;
        }
        entity.noSleep();
        float speed = this.speed * 8.0f / 2.4f;
        float centerSpeed = 0.1f;
        float centerDstScl = 3.0f;
        float tx = Geometry.d4[tile.rotation()].x;
        float ty = Geometry.d4[tile.rotation()].y;
        float centerx = 0.0f;
        float centery = 0.0f;
        if (Math.abs(tx) > Math.abs(ty)) {
            centery = Mathf.clamp((tile.worldy() - unit.y) / centerDstScl, -centerSpeed, centerSpeed);
            if (Math.abs(tile.worldy() - unit.y) < 1.0f) {
                centery = 0.0f;
            }
        } else {
            centerx = Mathf.clamp((tile.worldx() - unit.x) / centerDstScl, -centerSpeed, centerSpeed);
            if (Math.abs(tile.worldx() - unit.x) < 1.0f) {
                centerx = 0.0f;
            }
        }
        if ((float)entity.convey.size * 0.4f < 0.9f) {
            unit.applyImpulse((tx * speed + centerx) * entity.delta(), (ty * speed + centery) * entity.delta());
        }
    }

    @Override
    public void update(Tile tile) {
        ConveyorEntity entity = (ConveyorEntity)tile.entity();
        entity.minitem = 1.0f;
        Tile next = tile.getNearby(tile.rotation());
        if (next != null) {
            next = next.link();
        }
        float nextMax = next != null && next.block() instanceof Conveyor ? 1.0f - Math.max(0.4f - ((ConveyorEntity)next.entity()).minitem, 0.0f) : 1.0f;
        int minremove = Integer.MAX_VALUE;
        for (int i = entity.convey.size - 1; i >= 0; --i) {
            long value = entity.convey.get(i);
            ItemPos pos = pos1.set(value, ItemPos.updateShorts);
            if (pos.item == null) {
                entity.convey.removeValue(value);
                break;
            }
            float nextpos = (i == entity.convey.size - 1 ? 100.0f : Conveyor.pos2.set((long)entity.convey.get((int)(i + 1)), (short[])ItemPos.updateShorts).y) - 0.4f;
            float maxmove = Math.min(nextpos - pos.y, this.speed * entity.delta());
            if (maxmove > 3.0520372E-5f) {
                pos.y += maxmove;
                if (Mathf.isEqual(pos.x, 0.0f, 0.1f)) {
                    pos.x = 0.0f;
                }
                pos.x = Mathf.lerpDelta(pos.x, 0.0f, 0.1f);
            }
            pos.y = Mathf.clamp(pos.y, 0.0f, nextMax);
            if (pos.y >= 0.9999f && this.offloadDir(tile, pos.item)) {
                if (next != null && next.block() instanceof Conveyor) {
                    ConveyorEntity othere = (ConveyorEntity)next.entity();
                    ItemPos ni = pos2.set(othere.convey.get(othere.lastInserted), ItemPos.updateShorts);
                    if (next.rotation() == tile.rotation()) {
                        ni.x = pos.x;
                    }
                    othere.convey.set(othere.lastInserted, ni.pack());
                }
                minremove = Math.min(i, minremove);
                tile.entity.items.remove(pos.item, 1);
                continue;
            }
            value = pos.pack();
            if (pos.y < entity.minitem) {
                entity.minitem = pos.y;
            }
            entity.convey.set(i, value);
        }
        entity.clogHeat = entity.minitem < 0.4f ? Mathf.lerpDelta(entity.clogHeat, 1.0f, 0.02f) : Mathf.lerpDelta(entity.clogHeat, 0.0f, 1.0f);
        if (entity.items.total() == 0) {
            entity.sleep();
        } else {
            entity.noSleep();
        }
        if (minremove != Integer.MAX_VALUE) {
            entity.convey.truncate(minremove);
        }
    }

    @Override
    public boolean isAccessible() {
        return true;
    }

    @Override
    public int removeStack(Tile tile, Item item, int amount) {
        ConveyorEntity entity = (ConveyorEntity)tile.entity();
        entity.noSleep();
        int removed = 0;
        block0: for (int j = 0; j < amount; ++j) {
            for (int i = 0; i < entity.convey.size; ++i) {
                long val = entity.convey.get(i);
                ItemPos pos = pos1.set(val, ItemPos.drawShorts);
                if (pos.item != item) continue;
                entity.convey.removeValue(val);
                entity.items.remove(item, 1);
                ++removed;
                continue block0;
            }
        }
        return removed;
    }

    @Override
    public void getStackOffset(Item item, Tile tile, Vector2 trns) {
        trns.trns((float)(tile.rotation() * 90) + 180.0f, 4.0f);
    }

    @Override
    public int acceptStack(Item item, int amount, Tile tile, Unit source) {
        ConveyorEntity entity = (ConveyorEntity)tile.entity();
        return Math.min((int)(entity.minitem / 0.4f), amount);
    }

    @Override
    public void handleStack(Item item, int amount, Tile tile, Unit source) {
        ConveyorEntity entity = (ConveyorEntity)tile.entity();
        for (int i = amount - 1; i >= 0; --i) {
            long result = ItemPos.packItem(item, 0.0f, (float)i * 0.4f);
            entity.convey.insert(0, result);
            entity.items.add(item, 1);
        }
        entity.noSleep();
    }

    @Override
    public boolean acceptItem(Item item, Tile tile, Tile source) {
        int direction = source == null ? 0 : Math.abs(source.relativeTo(tile.x, tile.y) - tile.rotation());
        float minitem = ((ConveyorEntity)tile.entity()).minitem;
        return (direction == 0 && minitem > 0.4f || direction % 2 == 1 && minitem > 0.52f) && (source == null || !source.block().rotate || (source.rotation() + 2) % 4 != tile.rotation());
    }

    @Override
    public void handleItem(Item item, Tile tile, Tile source) {
        float pos;
        byte rotation = tile.rotation();
        int ch = Math.abs(source.relativeTo(tile.x, tile.y) - rotation);
        int ang = source.relativeTo(tile.x, tile.y) - rotation;
        float f = ch == 0 ? 0.0f : (pos = ch % 2 == 1 ? 0.5f : 1.0f);
        float y = ang == -1 || ang == 3 ? 1.0f : (ang == 1 || ang == -3 ? -1.0f : 0.0f);
        ConveyorEntity entity = (ConveyorEntity)tile.entity();
        entity.noSleep();
        long result = ItemPos.packItem(item, y * 0.9f, pos);
        tile.entity.items.add(item, 1);
        for (int i = 0; i < entity.convey.size; ++i) {
            if (Conveyor.compareItems(result, entity.convey.get(i)) >= 0) continue;
            entity.convey.insert(i, result);
            entity.lastInserted = (byte)i;
            return;
        }
        entity.convey.add(result);
        entity.lastInserted = (byte)(entity.convey.size - 1);
    }

    @Override
    public TileEntity newEntity() {
        return new ConveyorEntity();
    }

    static class ItemPos {
        private static short[] writeShort = new short[4];
        private static byte[] writeByte = new byte[4];
        private static short[] packShorts = new short[4];
        private static short[] drawShorts = new short[4];
        private static short[] updateShorts = new short[4];
        Item item;
        float x;
        float y;

        private ItemPos() {
        }

        static long packItem(Item item, float x, float y) {
            short[] shorts = packShorts;
            shorts[0] = item.id;
            shorts[1] = (short)(x * 32767.0f);
            shorts[2] = (short)((y - 1.0f) * 32767.0f);
            return Pack.longShorts(shorts);
        }

        static int toInt(long value) {
            short[] values = Pack.shorts(value, writeShort);
            short itemid = values[0];
            float x = (float)values[1] / 32767.0f;
            float y = (float)values[2] / 32767.0f + 1.0f;
            byte[] bytes = writeByte;
            bytes[0] = (byte)itemid;
            bytes[1] = (byte)(x * 127.0f);
            bytes[2] = (byte)(y * 255.0f - 128.0f);
            return Pack.intBytes(bytes);
        }

        static long toLong(int value) {
            byte[] values = Pack.bytes(value, writeByte);
            short itemid = Vars.content.item((int)values[0]).id;
            float x = (float)values[1] / 127.0f;
            float y = (float)(values[2] + 128) / 255.0f;
            short[] shorts = writeShort;
            shorts[0] = itemid;
            shorts[1] = (short)(x * 32767.0f);
            shorts[2] = (short)((y - 1.0f) * 32767.0f);
            return Pack.longShorts(shorts);
        }

        ItemPos set(long lvalue, short[] values) {
            Pack.shorts(lvalue, values);
            this.item = values[0] >= Vars.content.items().size || values[0] < 0 ? null : Vars.content.items().get(values[0]);
            this.x = (float)values[1] / 32767.0f;
            this.y = (float)values[2] / 32767.0f + 1.0f;
            return this;
        }

        long pack() {
            return ItemPos.packItem(this.item, this.x, this.y);
        }
    }

    public static class ConveyorEntity
    extends TileEntity {
        LongArray convey = new LongArray();
        byte lastInserted;
        float minitem = 1.0f;
        int blendbits;
        int blendsclx;
        int blendscly;
        float clogHeat = 0.0f;

        @Override
        public void write(DataOutput stream) throws IOException {
            super.write(stream);
            stream.writeInt(this.convey.size);
            for (int i = 0; i < this.convey.size; ++i) {
                stream.writeInt(ItemPos.toInt(this.convey.get(i)));
            }
        }

        @Override
        public void read(DataInput stream, byte revision) throws IOException {
            super.read(stream, revision);
            this.convey.clear();
            int amount = stream.readInt();
            this.convey.ensureCapacity(Math.min(amount, 10));
            for (int i = 0; i < amount; ++i) {
                this.convey.add(ItemPos.toLong(stream.readInt()));
            }
        }
    }
}

