/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.distribution;

import io.anuke.arc.Core;
import io.anuke.arc.function.Eachable;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Mathf;
import io.anuke.mindustry.entities.traits.BuilderTrait;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.type.Liquid;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.Autotiler;
import io.anuke.mindustry.world.blocks.LiquidBlock;
import io.anuke.mindustry.world.modules.LiquidModule;

public class Conduit
extends LiquidBlock
implements Autotiler {
    protected final int timerFlow;
    protected TextureRegion[] topRegions;
    protected TextureRegion[] botRegions;

    public Conduit(String name) {
        super(name);
        this.timerFlow = this.timers++;
        this.topRegions = new TextureRegion[7];
        this.botRegions = new TextureRegion[7];
        this.rotate = true;
        this.solid = false;
        this.floating = true;
    }

    @Override
    public void load() {
        super.load();
        this.liquidRegion = Core.atlas.find("conduit-liquid");
        for (int i = 0; i < this.topRegions.length; ++i) {
            this.topRegions[i] = Core.atlas.find(this.name + "-top-" + i);
            this.botRegions[i] = Core.atlas.find("conduit-bottom-" + i);
        }
    }

    @Override
    public void onProximityUpdate(Tile tile) {
        super.onProximityUpdate(tile);
        ConduitEntity entity = (ConduitEntity)tile.entity();
        int[] bits = this.buildBlending(tile, tile.rotation(), null, true);
        entity.blendbits = bits[0];
    }

    @Override
    public void drawRequestRegion(BuilderTrait.BuildRequest req, Eachable<BuilderTrait.BuildRequest> list) {
        int[] bits = this.getTiling(req, list);
        if (bits == null) {
            return;
        }
        Draw.colorl(0.34f);
        Draw.alpha(0.5f);
        Draw.rect(this.botRegions[bits[0]], req.drawx(), req.drawy(), (float)this.botRegions[bits[0]].getWidth() * Draw.scl * req.animScale, (float)this.botRegions[bits[0]].getHeight() * Draw.scl * req.animScale, (float)(req.rotation * 90));
        Draw.color();
        Draw.rect(this.topRegions[bits[0]], req.drawx(), req.drawy(), (float)this.topRegions[bits[0]].getWidth() * Draw.scl * req.animScale, (float)this.topRegions[bits[0]].getHeight() * Draw.scl * req.animScale, (float)(req.rotation * 90));
    }

    @Override
    public void transformCase(int num, int[] bits) {
        bits[0] = num == 0 ? 3 : (num == 1 ? 6 : (num == 2 ? 2 : (num == 3 ? 4 : (num == 4 ? 5 : (num == 5 ? 1 : 0)))));
    }

    @Override
    public boolean blends(Tile tile, int rotation, int otherx, int othery, int otherrot, Block otherblock) {
        return otherblock.hasLiquids && otherblock.outputsLiquid && this.lookingAt(tile, rotation, otherx, othery, otherrot, otherblock);
    }

    @Override
    public void draw(Tile tile) {
        ConduitEntity entity = (ConduitEntity)tile.entity();
        LiquidModule mod = tile.entity.liquids;
        int rotation = tile.rotation() * 90;
        Draw.colorl(0.34f);
        Draw.rect(this.botRegions[entity.blendbits], tile.drawx(), tile.drawy(), (float)rotation);
        Draw.color(mod.current().color);
        Draw.alpha(entity.smoothLiquid);
        Draw.rect(this.botRegions[entity.blendbits], tile.drawx(), tile.drawy(), (float)rotation);
        Draw.color();
        Draw.rect(this.topRegions[entity.blendbits], tile.drawx(), tile.drawy(), (float)rotation);
    }

    @Override
    public void update(Tile tile) {
        ConduitEntity entity = (ConduitEntity)tile.entity();
        entity.smoothLiquid = Mathf.lerpDelta(entity.smoothLiquid, entity.liquids.total() / this.liquidCapacity, 0.05f);
        if (tile.entity.liquids.total() > 0.001f && tile.entity.timer.get(this.timerFlow, 1.0f)) {
            this.tryMoveLiquid(tile, tile.getNearby(tile.rotation()), true, tile.entity.liquids.current());
            entity.noSleep();
        } else {
            entity.sleep();
        }
    }

    @Override
    public TextureRegion[] generateIcons() {
        return new TextureRegion[]{Core.atlas.find("conduit-bottom"), Core.atlas.find(this.name + "-top-0")};
    }

    @Override
    public boolean acceptLiquid(Tile tile, Tile source, Liquid liquid, float amount) {
        tile.entity.noSleep();
        return tile.entity.liquids.get(liquid) + amount < this.liquidCapacity && (tile.entity.liquids.current() == liquid || tile.entity.liquids.get(tile.entity.liquids.current()) < 0.2f) && (2 + source.relativeTo(tile.x, tile.y)) % 4 != tile.rotation();
    }

    @Override
    public TileEntity newEntity() {
        return new ConduitEntity();
    }

    public static class ConduitEntity
    extends TileEntity {
        public float smoothLiquid;
        int blendbits;
    }
}

