/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.defense.turrets;

import io.anuke.mindustry.entities.bullet.BulletType;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.defense.turrets.CooledTurret;
import io.anuke.mindustry.world.blocks.defense.turrets.Turret;
import io.anuke.mindustry.world.meta.BlockStat;
import io.anuke.mindustry.world.meta.StatUnit;

public abstract class PowerTurret
extends CooledTurret {
    protected BulletType shootType;
    protected float powerUse = 1.0f;

    public PowerTurret(String name) {
        super(name);
        this.hasPower = true;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(BlockStat.damage, this.shootType.damage, StatUnit.none);
    }

    @Override
    public void init() {
        this.consumes.powerCond(this.powerUse, entity -> ((Turret.TurretEntity)entity).target != null);
        super.init();
    }

    @Override
    public BulletType useAmmo(Tile tile) {
        return this.shootType;
    }

    @Override
    public boolean hasAmmo(Tile tile) {
        return true;
    }

    @Override
    public BulletType peekAmmo(Tile tile) {
        return this.shootType;
    }

    @Override
    protected float baseReloadSpeed(Tile tile) {
        return tile.isEnemyCheat() ? 1.0f : tile.entity.power.satisfaction;
    }
}

