/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.defense.turrets;

import io.anuke.arc.math.Angles;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.bullet.BulletType;
import io.anuke.mindustry.entities.type.Bullet;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.type.Liquid;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.defense.turrets.PowerTurret;
import io.anuke.mindustry.world.blocks.defense.turrets.Turret;
import io.anuke.mindustry.world.consumers.ConsumeLiquidBase;
import io.anuke.mindustry.world.consumers.ConsumeLiquidFilter;
import io.anuke.mindustry.world.consumers.ConsumeType;
import io.anuke.mindustry.world.meta.BlockStat;
import io.anuke.mindustry.world.meta.StatUnit;
import io.anuke.mindustry.world.meta.values.BoosterListValue;

public class LaserTurret
extends PowerTurret {
    protected float firingMoveFract = 0.25f;
    protected float shootDuration = 100.0f;

    public LaserTurret(String name) {
        super(name);
        this.canOverdrive = false;
        this.consumes.add(new ConsumeLiquidFilter(liquid -> liquid.temperature <= 0.5f && liquid.flammability < 0.1f, 0.01f)).update(false);
        this.coolantMultiplier = 1.0f;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.remove(BlockStat.booster);
        this.stats.add(BlockStat.input, new BoosterListValue(this.reload, ((ConsumeLiquidBase)this.consumes.get((ConsumeType)ConsumeType.liquid)).amount, this.coolantMultiplier, false, l -> this.consumes.liquidfilters.get(l.id)));
        this.stats.remove(BlockStat.damage);
        this.stats.add(BlockStat.damage, this.shootType.damage * 60.0f / 5.0f, StatUnit.perSecond);
    }

    @Override
    public void update(Tile tile) {
        super.update(tile);
        LaserTurretEntity entity = (LaserTurretEntity)tile.entity();
        if (entity.bulletLife > 0.0f && entity.bullet != null) {
            this.tr.trns(entity.rotation, (float)(this.size * 8) / 2.0f, 0.0f);
            entity.bullet.rot(entity.rotation);
            entity.bullet.set(tile.drawx() + this.tr.x, tile.drawy() + this.tr.y);
            entity.bullet.time(0.0f);
            entity.heat = 1.0f;
            entity.recoil = this.recoil;
            entity.bulletLife -= Time.delta();
            if (entity.bulletLife <= 0.0f) {
                entity.bullet = null;
            }
        }
    }

    @Override
    protected void updateShooting(Tile tile) {
        LaserTurretEntity entity = (LaserTurretEntity)tile.entity();
        if (entity.bulletLife > 0.0f && entity.bullet != null) {
            return;
        }
        if (entity.reload >= this.reload && (entity.cons.valid() || tile.isEnemyCheat())) {
            BulletType type = this.peekAmmo(tile);
            this.shoot(tile, type);
            entity.reload = 0.0f;
        } else {
            Liquid liquid = entity.liquids.current();
            float maxUsed = ((ConsumeLiquidBase)this.consumes.get((ConsumeType)ConsumeType.liquid)).amount;
            float used = this.baseReloadSpeed(tile) * (tile.isEnemyCheat() ? maxUsed : Math.min(entity.liquids.get(liquid), maxUsed * Time.delta())) * liquid.heatCapacity * this.coolantMultiplier;
            entity.reload += used;
            entity.liquids.remove(liquid, used);
            if (Mathf.chance(0.06 * (double)used)) {
                Effects.effect(this.coolEffect, tile.drawx() + Mathf.range((float)(this.size * 8) / 2.0f), tile.drawy() + Mathf.range((float)(this.size * 8) / 2.0f));
            }
        }
    }

    @Override
    protected void turnToTarget(Tile tile, float targetRot) {
        LaserTurretEntity entity = (LaserTurretEntity)tile.entity();
        entity.rotation = Angles.moveToward(entity.rotation, targetRot, this.rotatespeed * entity.delta() * (entity.bulletLife > 0.0f ? this.firingMoveFract : 1.0f));
    }

    @Override
    protected void bullet(Tile tile, BulletType type, float angle) {
        LaserTurretEntity entity = (LaserTurretEntity)tile.entity();
        entity.bullet = Bullet.create(type, tile.entity, tile.getTeam(), tile.drawx() + this.tr.x, tile.drawy() + this.tr.y, angle);
        entity.bulletLife = this.shootDuration;
    }

    @Override
    public TileEntity newEntity() {
        return new LaserTurretEntity();
    }

    @Override
    public boolean shouldActiveSound(Tile tile) {
        LaserTurretEntity entity = (LaserTurretEntity)tile.entity();
        return entity.bulletLife > 0.0f && entity.bullet != null;
    }

    class LaserTurretEntity
    extends Turret.TurretEntity {
        Bullet bullet;
        float bulletLife;

        LaserTurretEntity() {
        }
    }
}

