/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.defense.turrets;

import io.anuke.arc.Events;
import io.anuke.arc.collection.ObjectMap;
import io.anuke.arc.collection.OrderedMap;
import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Items;
import io.anuke.mindustry.ctype.UnlockableContent;
import io.anuke.mindustry.entities.bullet.BulletType;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.entities.type.Unit;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.ui.Bar;
import io.anuke.mindustry.ui.Cicon;
import io.anuke.mindustry.ui.ItemImage;
import io.anuke.mindustry.ui.MultiReqImage;
import io.anuke.mindustry.ui.ReqImage;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.defense.turrets.CooledTurret;
import io.anuke.mindustry.world.blocks.defense.turrets.Turret;
import io.anuke.mindustry.world.consumers.ConsumeItemFilter;
import io.anuke.mindustry.world.meta.BlockStat;
import io.anuke.mindustry.world.meta.BlockStats;
import io.anuke.mindustry.world.meta.values.AmmoListValue;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ItemTurret
extends CooledTurret {
    protected int maxAmmo = 30;
    protected ObjectMap<Item, BulletType> ammo = new ObjectMap();

    public ItemTurret(String name) {
        super(name);
        this.hasItems = true;
    }

    protected void ammo(Object ... objects) {
        this.ammo = OrderedMap.of(objects);
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.remove(BlockStat.itemCapacity);
        this.stats.add(BlockStat.ammo, new AmmoListValue<Item>(this.ammo));
        this.consumes.add(new ConsumeItemFilter(i -> this.ammo.containsKey((Item)i)){

            @Override
            public void build(Tile tile, Table table) {
                MultiReqImage image = new MultiReqImage();
                Vars.content.items().each(i -> this.filter.test(i) && (!Vars.world.isZone() || Vars.data.isUnlocked((UnlockableContent)i)), item -> image.add(new ReqImage((Element)new ItemImage(item.icon(Cicon.medium)), () -> tile.entity != null && !((ItemTurretEntity)tile.entity).ammo.isEmpty() && ((ItemEntry)((ItemTurretEntity)tile.entity()).ammo.peek()).item == item)));
                table.add(image).size(32.0f);
            }

            @Override
            public boolean valid(TileEntity entity) {
                return !((ItemTurretEntity)entity).ammo.isEmpty();
            }

            @Override
            public void display(BlockStats stats) {
            }
        });
    }

    @Override
    public void onProximityAdded(Tile tile) {
        super.onProximityAdded(tile);
        if (tile.isEnemyCheat() && this.ammo.size > 0) {
            this.handleItem((Item)((ObjectMap.Entry)this.ammo.entries().next()).key, tile, tile);
        }
    }

    @Override
    public void displayBars(Tile tile, Table bars) {
        super.displayBars(tile, bars);
        Turret.TurretEntity entity = (Turret.TurretEntity)tile.entity();
        bars.add(new Bar("blocks.ammo", Pal.ammo, () -> (float)entity.totalAmmo / (float)this.maxAmmo)).growX();
        bars.row();
    }

    @Override
    public int acceptStack(Item item, int amount, Tile tile, Unit source) {
        Turret.TurretEntity entity = (Turret.TurretEntity)tile.entity();
        BulletType type = this.ammo.get(item);
        if (type == null) {
            return 0;
        }
        return Math.min((int)((float)(this.maxAmmo - entity.totalAmmo) / this.ammo.get((Item)item).ammoMultiplier), amount);
    }

    @Override
    public void handleStack(Item item, int amount, Tile tile, Unit source) {
        for (int i = 0; i < amount; ++i) {
            this.handleItem(item, tile, null);
        }
    }

    @Override
    public int removeStack(Tile tile, Item item, int amount) {
        return 0;
    }

    @Override
    public void handleItem(Item item, Tile tile, Tile source) {
        Turret.TurretEntity entity = (Turret.TurretEntity)tile.entity();
        if (entity == null) {
            return;
        }
        if (item == Items.pyratite) {
            Events.fire(EventType.Trigger.flameAmmo);
        }
        BulletType type = this.ammo.get(item);
        entity.totalAmmo = (int)((float)entity.totalAmmo + type.ammoMultiplier);
        for (int i = 0; i < entity.ammo.size; ++i) {
            ItemEntry entry = (ItemEntry)entity.ammo.get(i);
            if (entry.item != item) continue;
            entry.amount = (int)((float)entry.amount + type.ammoMultiplier);
            entity.ammo.swap(i, entity.ammo.size - 1);
            return;
        }
        entity.ammo.add(new ItemEntry(item, (int)type.ammoMultiplier));
        if (Vars.state.rules.tutorial) {
            Events.fire(new EventType.TurretAmmoDeliverEvent());
        }
    }

    @Override
    public boolean acceptItem(Item item, Tile tile, Tile source) {
        Turret.TurretEntity entity = (Turret.TurretEntity)tile.entity();
        return this.ammo != null && this.ammo.get(item) != null && (float)entity.totalAmmo + this.ammo.get((Item)item).ammoMultiplier <= (float)this.maxAmmo;
    }

    @Override
    public TileEntity newEntity() {
        return new ItemTurretEntity();
    }

    class ItemEntry
    extends Turret.AmmoEntry {
        protected Item item;

        ItemEntry(Item item, int amount) {
            this.item = item;
            this.amount = amount;
        }

        @Override
        public BulletType type() {
            return ItemTurret.this.ammo.get(this.item);
        }
    }

    public class ItemTurretEntity
    extends Turret.TurretEntity {
        @Override
        public void write(DataOutput stream) throws IOException {
            super.write(stream);
            stream.writeByte(this.ammo.size);
            for (Turret.AmmoEntry entry : this.ammo) {
                ItemEntry i = (ItemEntry)entry;
                stream.writeByte(i.item.id);
                stream.writeShort(i.amount);
            }
        }

        @Override
        public void read(DataInput stream, byte revision) throws IOException {
            super.read(stream, revision);
            int amount = stream.readByte();
            for (int i = 0; i < amount; ++i) {
                Item item = Vars.content.item(stream.readByte());
                short a = stream.readShort();
                this.totalAmmo += a;
                this.ammo.add(new ItemEntry(item, a));
            }
        }
    }
}

