/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.defense.turrets;

import io.anuke.arc.math.Mathf;
import io.anuke.mindustry.entities.bullet.BulletType;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.defense.turrets.ItemTurret;
import io.anuke.mindustry.world.blocks.defense.turrets.Turret;
import io.anuke.mindustry.world.meta.BlockStat;
import io.anuke.mindustry.world.meta.StatUnit;

public class DoubleTurret
extends ItemTurret {
    protected float shotWidth = 2.0f;

    public DoubleTurret(String name) {
        super(name);
        this.shots = 2;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.remove(BlockStat.reload);
        this.stats.add(BlockStat.reload, 60.0f / this.reload, StatUnit.none);
    }

    @Override
    protected void shoot(Tile tile, BulletType ammo) {
        Turret.TurretEntity entity = (Turret.TurretEntity)tile.entity();
        ++entity.shots;
        int i = Mathf.signs[entity.shots % 2];
        this.tr.trns(entity.rotation - 90.0f, this.shotWidth * (float)i, this.size * 8 / 2);
        this.bullet(tile, ammo, entity.rotation + Mathf.range(this.inaccuracy));
        this.effects(tile);
        this.useAmmo(tile);
    }
}

