/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.defense.turrets;

import io.anuke.arc.Events;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.type.Liquid;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.defense.turrets.Turret;
import io.anuke.mindustry.world.consumers.ConsumeLiquidBase;
import io.anuke.mindustry.world.consumers.ConsumeLiquidFilter;
import io.anuke.mindustry.world.consumers.ConsumeType;
import io.anuke.mindustry.world.meta.BlockStat;
import io.anuke.mindustry.world.meta.values.BoosterListValue;

public class CooledTurret
extends Turret {
    protected float coolantMultiplier = 5.0f;
    protected Effects.Effect coolEffect = Fx.fuelburn;

    public CooledTurret(String name) {
        super(name);
        this.hasLiquids = true;
        this.liquidCapacity = 20.0f;
        this.consumes.add(new ConsumeLiquidFilter(liquid -> liquid.temperature <= 0.5f && liquid.flammability < 0.1f, 0.2f)).update(false).boost();
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(BlockStat.booster, new BoosterListValue(this.reload, ((ConsumeLiquidBase)this.consumes.get((ConsumeType)ConsumeType.liquid)).amount, this.coolantMultiplier, true, l -> this.consumes.liquidfilters.get(l.id)));
    }

    @Override
    public void handleLiquid(Tile tile, Tile source, Liquid liquid, float amount) {
        if (tile.entity.liquids.currentAmount() <= 0.001f) {
            Events.fire(EventType.Trigger.turretCool);
        }
        super.handleLiquid(tile, source, liquid, amount);
    }

    @Override
    protected void updateShooting(Tile tile) {
        super.updateShooting(tile);
        float maxUsed = ((ConsumeLiquidBase)this.consumes.get((ConsumeType)ConsumeType.liquid)).amount;
        Turret.TurretEntity entity = (Turret.TurretEntity)tile.entity();
        Liquid liquid = entity.liquids.current();
        float used = Math.min(Math.min(entity.liquids.get(liquid), maxUsed * Time.delta()), Math.max(0.0f, (this.reload - entity.reload) / this.coolantMultiplier / liquid.heatCapacity)) * this.baseReloadSpeed(tile);
        entity.reload += used * liquid.heatCapacity * this.coolantMultiplier;
        entity.liquids.remove(liquid, used);
        if (Mathf.chance(0.06 * (double)used)) {
            Effects.effect(this.coolEffect, tile.drawx() + Mathf.range((float)(this.size * 8) / 2.0f), tile.drawy() + Mathf.range((float)(this.size * 8) / 2.0f));
        }
    }
}

