/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.defense.turrets;

import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.mindustry.entities.Predict;
import io.anuke.mindustry.entities.bullet.BulletType;
import io.anuke.mindustry.entities.type.Bullet;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.defense.turrets.ItemTurret;
import io.anuke.mindustry.world.blocks.defense.turrets.Turret;

public class ArtilleryTurret
extends ItemTurret {
    protected float velocityInaccuracy = 0.0f;

    public ArtilleryTurret(String name) {
        super(name);
        this.targetAir = false;
    }

    @Override
    protected void shoot(Tile tile, BulletType ammo) {
        Turret.TurretEntity entity = (Turret.TurretEntity)tile.entity();
        entity.recoil = this.recoil;
        entity.heat = 1.0f;
        BulletType type = this.peekAmmo(tile);
        this.tr.trns(entity.rotation, this.size * 8 / 2);
        Vector2 predict = Predict.intercept(tile, entity.target, type.speed);
        float dst = entity.dst(predict.x, predict.y);
        float maxTraveled = type.lifetime * type.speed;
        for (int i = 0; i < this.shots; ++i) {
            Bullet.create(ammo, tile.entity, tile.getTeam(), tile.drawx() + this.tr.x, tile.drawy() + this.tr.y, entity.rotation + Mathf.range(this.inaccuracy + type.inaccuracy), 1.0f + Mathf.range(this.velocityInaccuracy), dst / maxTraveled);
        }
        this.effects(tile);
        this.useAmmo(tile);
    }
}

