/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.defense;

import io.anuke.arc.Core;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Mathf;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.meta.BlockGroup;

public class Wall
extends Block {
    protected int variants = 0;

    public Wall(String name) {
        super(name);
        this.solid = true;
        this.destructible = true;
        this.group = BlockGroup.walls;
        this.buildCostMultiplier = 5.0f;
    }

    @Override
    public void load() {
        super.load();
        if (this.variants != 0) {
            this.variantRegions = new TextureRegion[this.variants];
            for (int i = 0; i < this.variants; ++i) {
                this.variantRegions[i] = Core.atlas.find(this.name + (i + 1));
            }
            this.region = this.variantRegions[0];
        }
    }

    @Override
    public void draw(Tile tile) {
        if (this.variants == 0) {
            Draw.rect(this.region, tile.drawx(), tile.drawy());
        } else {
            Draw.rect(this.variantRegions[Mathf.randomSeed(tile.pos(), 0, Math.max(0, this.variantRegions.length - 1))], tile.drawx(), tile.drawy());
        }
    }

    @Override
    public TextureRegion[] generateIcons() {
        return new TextureRegion[]{Core.atlas.find(Core.atlas.has(this.name) ? this.name : this.name + "1")};
    }

    @Override
    public boolean canReplace(Block other) {
        return super.canReplace(other) && this.health > other.health;
    }
}

